/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.basictable.filter;

import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.framework.lookandfeel.SwimapMetalTreeUI;
import com.swimap.iview.templates.basictable.filter.DefaultFilterElement;
import com.swimap.iview.templates.basictable.filter.FilterElement;
import com.swimap.iview.templates.basictable.filter.FilterTableRow;
import com.swimap.iview.templates.basictable.filter.Filterable;
import com.swimap.iview.templates.basictable.filter.MultiValueCombo;
import com.swimap.iview.templates.basictable.filter.MultiValueComboListener;
import com.swimap.iview.templates.basictable.filter.Operators;
import com.swimap.iview.templates.filtertree.FilterTreeCell;
import com.swimap.iview.templates.filtertreetable.AbstractTreeTableModel;
import com.swimap.iview.templates.filtertreetable.FilterTreeTable;
import com.swimap.iview.templates.filtertreetable.TreeTableModel;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.plaf.TreeUI;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class AdvancedCustomFilter {
    private static final long serialVersionUID = 4978383734905004657L;
    private IviewLogger logger = IviewLogger.getLogger(AdvancedCustomFilter.class, "IVIEW");
    private static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/templates/basictable/Res");
    private DefaultMutableTreeNode root = null;
    private FilterElement filter = null;
    private Map<Integer, Object> colnames = null;
    private Filterable filterableModel = null;
    private TreeTableExt treeTable = null;
    private TreeTableModelImpl treeTableModel = null;
    private JPanel controlPanel = new JPanel();
    private JPopupMenu popup = null;
    private final int MINIMUM_COL_WIDTH = 124;
    private final int VALUE_COLUMN_INDEX = 3;
    private boolean hideRootOperatorPopUp = false;

    public AdvancedCustomFilter(FilterElement filterElement, Map<Integer, Object> map, Filterable filterable) {
        this.filter = filterElement;
        this.colnames = map;
        this.filterableModel = filterable;
        this.init();
    }

    public JPanel getPanel() {
        return this.controlPanel;
    }

    private void init() {
        this.controlPanel.setSize(500, 350);
        this.controlPanel.setLayout(new BorderLayout());
        this.treeTableModel = this.getModel();
        this.treeTable = new TreeTableExt(this.treeTableModel);
        this.treeTable.setRootVisible(true);
        this.treeTable.setRowHeightExternally(20);
        this.treeTable.addMouseListener(new TableMouseListener());
        this.treeTable.addMouseMotionListener(new TableMouseListener());
        TableColumn tableColumn = this.treeTable.getColumnModel().getColumn(1);
        JComboBox<Object> jComboBox = new JComboBox<Object>(this.colnames.values().toArray());
        tableColumn.setCellEditor(new DefaultCellEditor(jComboBox));
        tableColumn = this.treeTable.getColumnModel().getColumn(2);
        jComboBox = new JComboBox();
        tableColumn.setCellEditor(new OperatorCellEditor(jComboBox));
        tableColumn = this.treeTable.getColumnModel().getColumn(3);
        tableColumn.setCellEditor(this.createValueCellEditor());
        tableColumn.setCellRenderer(new ValueCellRenderer());
        this.setColumnMinimumSize(this.treeTable.getColumnModel());
        int n = this.treeTable.getColumnCount();
        for (int i = 0; i < n; ++i) {
            this.treeTable.setColumnSortable(i, false);
        }
        this.treeTable.putTreeClientProperty("JTree.lineStyle", "Angled");
        this.treeTable.expandAllNodes();
        JScrollPane jScrollPane = new JScrollPane(this.treeTable);
        jScrollPane.setMinimumSize(new Dimension(430, 254));
        this.controlPanel.add((Component)jScrollPane, "Center");
    }

    private DefaultCellEditor createValueCellEditor() {
        JComboBox jComboBox = new JComboBox();
        jComboBox.setEditable(true);
        return new ValueCellEditor(jComboBox);
    }

    protected void setColumnMinimumSize(TableColumnModel tableColumnModel) {
        Enumeration<TableColumn> enumeration = tableColumnModel.getColumns();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement().setMinWidth(124);
        }
    }

    private void authorizePopup() {
        TreeNode treeNode = (TreeNode)this.treeTable.getTreeModel().getRoot();
        this.popup.getComponent(3).setEnabled(treeNode.getChildCount() > 0);
    }

    private void initializePopup() {
        this.popup = new JPopupMenu();
        this.popup.setName("rightClick_popupmenu");
        JMenuItem jMenuItem = new JMenuItem(res.getString("Add_Condition"));
        jMenuItem.setMnemonic('C');
        jMenuItem.setName("menu-item_Add Condition");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = AdvancedCustomFilter.this.treeTable.getSelectedRow();
                AdvancedCustomFilter.this.treeTableModel.addCondition(AdvancedCustomFilter.this.treeTable.getValueAt(n, 0));
                AdvancedCustomFilter.this.treeTable.updateUI();
            }
        });
        JMenuItem jMenuItem2 = new JMenuItem(res.getString("Add_Group_Condition"));
        jMenuItem2.setMnemonic('G');
        jMenuItem2.setName("menu-item_Add-Group-Condition");
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = AdvancedCustomFilter.this.treeTable.getSelectedRow();
                AdvancedCustomFilter.this.treeTableModel.addGroupCondition(AdvancedCustomFilter.this.treeTable.getValueAt(n, 0));
                AdvancedCustomFilter.this.treeTable.updateUI();
            }
        });
        JMenuItem jMenuItem3 = new JMenuItem(res.getString("Remove"));
        jMenuItem3.setMnemonic('R');
        jMenuItem3.setName("menu-item_remove");
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = AdvancedCustomFilter.this.treeTable.getSelectedRow();
                AdvancedCustomFilter.this.treeTableModel.removeCondition(AdvancedCustomFilter.this.treeTable.getValueAt(n, 0));
                AdvancedCustomFilter.this.treeTable.updateUI();
            }
        });
        this.popup.add(jMenuItem);
        this.popup.add(jMenuItem2);
        this.popup.addSeparator();
        this.popup.add(jMenuItem3);
    }

    private TreeTableModelImpl getModel() {
        this.initializeFilterElement();
        this.root = new DefaultMutableTreeNode();
        FilterTreeCellExt filterTreeCellExt = new FilterTreeCellExt(this.filter);
        filterTreeCellExt.setHideCheckbox(true);
        this.root.setUserObject(filterTreeCellExt);
        if (null != this.filter) {
            this.addChildren(this.root, this.filter);
        }
        return new TreeTableModelImpl(this.root);
    }

    private void initializeFilterElement() {
        if (null == this.filter) {
            this.filter = new DefaultFilterElement(Operators.GroupOperator.GROUP_OP_AND);
        }
    }

    private int addChildren(DefaultMutableTreeNode defaultMutableTreeNode, FilterElement filterElement) {
        int n = filterElement.getChildCount();
        FilterTreeCellExt filterTreeCellExt = null;
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        FilterElement filterElement2 = null;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            filterElement2 = filterElement.getChildAt(i);
            if (filterElement2.isCondition() && !this.colnames.containsKey(filterElement2.getColumnIndex())) continue;
            ++n2;
            filterTreeCellExt = new FilterTreeCellExt(filterElement2);
            filterTreeCellExt.setHideCheckbox(true);
            defaultMutableTreeNode2 = new DefaultMutableTreeNode(filterTreeCellExt);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            n3 = this.addChildren(defaultMutableTreeNode2, filterElement2);
            if (0 != n3 || filterElement2.isCondition()) continue;
            defaultMutableTreeNode.remove(defaultMutableTreeNode2);
        }
        return n2;
    }

    private int getIndexForColumn(Object object) {
        Set<Map.Entry<Integer, Object>> set = this.colnames.entrySet();
        for (Map.Entry<Integer, Object> entry : set) {
            if (!entry.getValue().equals(object)) continue;
            return entry.getKey();
        }
        return -1;
    }

    private DefaultFilterElement getConditionElem() {
        int n = -1;
        Operators.Operator operator = null;
        String string = null;
        Iterator<Map.Entry<Integer, Object>> iterator = this.colnames.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry<Integer, Object> entry = iterator.next();
            n = entry.getKey();
            List<Operators.Operator> list = this.filterableModel.getFilterOperatorList(n);
            operator = null != list && list.size() > 0 ? list.get(0) : Operators.Operator.EQUALS;
            string = entry.getValue().toString();
        }
        return new DefaultFilterElement(n, operator, "", string);
    }

    private DefaultFilterElement getGroupConditionElem() {
        return new DefaultFilterElement(Operators.GroupOperator.GROUP_OP_AND);
    }

    public FilterElement getFilter() {
        return this.filter;
    }

    void setHideRootOperatorPopUp(boolean bl) {
        this.hideRootOperatorPopUp = bl;
    }

    private static class FilterTreeUI
    extends SwimapMetalTreeUI {
        private FilterTreeUI() {
        }

        public void revalidatePathBounds(TreePath treePath) {
            this.treeState.invalidatePathBounds(treePath);
            this.updateSize();
        }
    }

    private static class TreeTableExt
    extends FilterTreeTable {
        private static final long serialVersionUID = -4422355366944748358L;
        private static TreeUI ui = new FilterTreeUI();

        TreeTableExt(TreeTableModel treeTableModel) {
            super(treeTableModel);
        }

        @Override
        public void updateUI() {
            super.updateUI();
            if (null != this.rendererTree) {
                this.rendererTree.setUI(ui);
            }
        }

        @Override
        protected void initTree(TreeTableModel treeTableModel) {
            super.initTree(treeTableModel);
            this.rendererTree.setUI(ui);
        }

        public FilterTreeUI getTreeUI() {
            return (FilterTreeUI)this.rendererTree.getUI();
        }

        public TreePath getTreeSelectionPath() {
            return this.rendererTree.getSelectionPath();
        }

        public int getRowForPath(TreePath treePath) {
            return this.rendererTree.getRowForPath(treePath);
        }

        public void putTreeClientProperty(Object object, Object object2) {
            this.rendererTree.putClientProperty(object, object2);
        }
    }

    private class Handler
    implements MouseListener,
    MouseMotionListener,
    Serializable {
        private static final long serialVersionUID = 3689073143435337130L;

        private Handler() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            JList jList = (JList)mouseEvent.getSource();
            jList.getParent().setVisible(false);
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            JList jList = (JList)mouseEvent.getSource();
            Point point = mouseEvent.getPoint();
            Rectangle rectangle = new Rectangle();
            jList.computeVisibleRect(rectangle);
            if (rectangle.contains(point)) {
                int n = jList.locationToIndex(point);
                if (n == -1 && point.y < 0) {
                    n = 0;
                }
                if (jList.getSelectedIndex() != n) {
                    jList.setSelectedIndex(n);
                    jList.ensureIndexIsVisible(n);
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
        }
    }

    private static class BlankTreeIcon
    implements Icon {
        private BlankTreeIcon() {
        }

        @Override
        public int getIconHeight() {
            return 0;
        }

        @Override
        public int getIconWidth() {
            return 0;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        }
    }

    private class ValueCellRenderer
    extends DefaultTableCellRenderer {
        private ValueCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (object instanceof Object[]) {
                String string = MultiValueCombo.getMultiValueStr((Object[])object);
                jLabel.setText(string);
            }
            jLabel.setToolTipText(jLabel.getText());
            return jLabel;
        }
    }

    private class ValueCellEditor
    extends DefaultCellEditor {
        private JComboBox valueCombo;
        private JTextField field;
        private boolean comboValue;
        private boolean multiValCombo;
        private MultiValueCombo multiValComboComp;

        ValueCellEditor(JComboBox jComboBox) {
            super(jComboBox);
            this.valueCombo = null;
            this.field = null;
            this.comboValue = false;
            this.multiValCombo = false;
            this.multiValComboComp = null;
            this.valueCombo = jComboBox;
            this.field = new JTextField();
            this.field.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    ValueCellEditor.this.stopCellEditing();
                }
            });
            this.multiValComboComp = new MultiValueCombo(null, null);
            this.multiValComboComp.setListener(new MultiValueComboListener(){

                @Override
                public void valueChanged() {
                    ValueCellEditor.this.stopCellEditing();
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            super.getTableCellEditorComponent(jTable, object, bl, n, n2);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)AdvancedCustomFilter.this.treeTable.getValueAt(n, 0);
            DefaultFilterElement defaultFilterElement = (DefaultFilterElement)((FilterTreeCell)defaultMutableTreeNode.getUserObject()).getFilterObject();
            this.valueCombo.removeAllItems();
            int n3 = defaultFilterElement.getColumnIndex();
            Collection<Object> collection = AdvancedCustomFilter.this.filterableModel.getFilterColumnValues(n3);
            Operators.Operator operator = defaultFilterElement.getCondOperator();
            if (operator == Operators.Operator.EXIST_IN || operator == Operators.Operator.NOT_EXIST_IN) {
                List<Object> list = AdvancedCustomFilter.this.filterableModel.getAddedColumnValueList(n3);
                this.multiValCombo = true;
                this.comboValue = false;
                return this.getMultiValEditorComp(collection, list, object, n);
            }
            if (collection.size() == 0) {
                this.field.setText(object.toString());
                this.comboValue = false;
                this.multiValCombo = false;
                return this.field;
            }
            for (Object object2 : collection) {
                this.valueCombo.addItem(object2);
            }
            this.valueCombo.setSelectedItem(object);
            this.comboValue = true;
            this.multiValCombo = false;
            return this.valueCombo;
        }

        private Component getMultiValEditorComp(Collection<Object> collection, List<Object> list, Object object, int n) {
            this.multiValComboComp.clearSelection();
            this.multiValComboComp.reinitList(collection, list);
            if (object instanceof Object[]) {
                this.multiValComboComp.setSelectedItems((Object[])object);
            } else {
                this.multiValComboComp.initComboValue();
            }
            return this.multiValComboComp;
        }

        @Override
        public Object getCellEditorValue() {
            if (this.multiValCombo) {
                return this.multiValComboComp.getSelectedItems();
            }
            return this.comboValue ? this.valueCombo.getSelectedItem() : this.field.getText();
        }
    }

    private class OperatorCellEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = -3208824370664205966L;
        private JComboBox comboBox;

        OperatorCellEditor(JComboBox jComboBox) {
            super(jComboBox);
            this.comboBox = null;
            this.comboBox = jComboBox;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            super.getTableCellEditorComponent(jTable, object, bl, n, n2);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)AdvancedCustomFilter.this.treeTable.getValueAt(n, 0);
            DefaultFilterElement defaultFilterElement = (DefaultFilterElement)((FilterTreeCell)defaultMutableTreeNode.getUserObject()).getFilterObject();
            this.comboBox.removeAllItems();
            List<Operators.Operator> list = AdvancedCustomFilter.this.filterableModel.getFilterOperatorList(defaultFilterElement.getColumnIndex());
            if (null == list || list.size() <= 0) {
                list = Arrays.asList(Operators.Operator.values());
            }
            for (Operators.Operator operator : list) {
                this.comboBox.addItem(operator);
            }
            this.comboBox.setSelectedItem(object);
            return this.comboBox;
        }

        @Override
        public Object getCellEditorValue() {
            return this.comboBox.getSelectedItem();
        }
    }

    private class TreeTableModelImpl
    extends AbstractTreeTableModel {
        private static final int INITIAL_SIZE = 8;
        private static final int COLUMN_COUNT = 4;
        private HashMap<DefaultMutableTreeNode, FilterTableRow> map;

        TreeTableModelImpl(Object object) {
            super(object);
            this.map = new HashMap(8);
            this.initModel((DefaultMutableTreeNode)object);
        }

        private void initModel(DefaultMutableTreeNode defaultMutableTreeNode) {
            Object[] objectArray = new Object[]{"", "", ""};
            FilterTableRow filterTableRow = new FilterTableRow(defaultMutableTreeNode, objectArray);
            this.map.put(defaultMutableTreeNode, filterTableRow);
            this.parse(defaultMutableTreeNode);
        }

        void parse(DefaultMutableTreeNode defaultMutableTreeNode) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = null;
            Object[] objectArray = null;
            FilterTableRow filterTableRow = null;
            FilterElement filterElement = null;
            int n = defaultMutableTreeNode.getChildCount();
            for (int i = 0; i < n; ++i) {
                defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
                filterElement = (FilterElement)((FilterTreeCell)defaultMutableTreeNode2.getUserObject()).getFilterObject();
                objectArray = filterElement.isCondition() ? new Object[]{((DefaultFilterElement)filterElement).getViewColumnName(), filterElement.getCondOperator(), filterElement.getCondValue()} : new Object[]{"", "", ""};
                filterTableRow = new FilterTableRow(defaultMutableTreeNode2, objectArray);
                this.map.put(defaultMutableTreeNode2, filterTableRow);
                this.parse((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i));
            }
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "";
                }
                case 1: {
                    return res.getString("AdvFilter_Column_Name");
                }
                case 2: {
                    return res.getString("AdvFilter_Operator");
                }
            }
            return res.getString("AdvFilter_Value");
        }

        @Override
        public boolean isCellEditable(Object object, int n) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            DefaultFilterElement defaultFilterElement = (DefaultFilterElement)((FilterTreeCell)defaultMutableTreeNode.getUserObject()).getFilterObject();
            return defaultFilterElement.isCondition() || n == 0;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return TreeTableModel.class;
                }
                case 1: {
                    return JComboBox.class;
                }
                case 2: {
                    return JComboBox.class;
                }
            }
            return JComboBox.class;
        }

        @Override
        public void setValueAt(Object object, Object object2, int n) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object2;
            DefaultFilterElement defaultFilterElement = (DefaultFilterElement)((FilterTreeCell)defaultMutableTreeNode.getUserObject()).getFilterObject();
            switch (n) {
                case 1: {
                    String string = defaultFilterElement.getViewColumnName();
                    this.map.get((Object)object2).getColData()[n - 1] = object;
                    if (string.equals(object.toString())) break;
                    int n2 = AdvancedCustomFilter.this.getIndexForColumn(object);
                    defaultFilterElement.setColumnIndex(n2);
                    defaultFilterElement.setViewColumnName(object.toString());
                    Operators.Operator operator = null;
                    List<Operators.Operator> list = AdvancedCustomFilter.this.filterableModel.getFilterOperatorList(0);
                    operator = null != list && list.size() > 0 ? list.get(0) : Operators.Operator.EQUALS;
                    defaultFilterElement.setOperator(operator);
                    this.map.get((Object)object2).getColData()[1] = operator;
                    this.changeConditionValue(defaultFilterElement, object2);
                    break;
                }
                case 2: {
                    Operators.Operator operator = (Operators.Operator)((Object)object);
                    this.map.get((Object)object2).getColData()[n - 1] = object;
                    Operators.Operator operator2 = defaultFilterElement.getCondOperator();
                    if (operator2 != operator) {
                        boolean bl;
                        boolean bl2 = operator2 == Operators.Operator.EXIST_IN || operator2 == Operators.Operator.NOT_EXIST_IN;
                        boolean bl3 = bl = operator == Operators.Operator.EXIST_IN || operator == Operators.Operator.NOT_EXIST_IN;
                        if (bl2 != bl) {
                            this.changeConditionValue(defaultFilterElement, object2);
                        }
                    }
                    defaultFilterElement.setOperator(operator);
                    break;
                }
                case 3: {
                    defaultFilterElement.setValue(object);
                    this.map.get((Object)object2).getColData()[n - 1] = object;
                    break;
                }
            }
        }

        private void changeConditionValue(DefaultFilterElement defaultFilterElement, Object object) {
            defaultFilterElement.setValue("");
            this.map.get((Object)object).getColData()[2] = "";
            TableModel tableModel = AdvancedCustomFilter.this.treeTable.getModel();
            if (tableModel instanceof AbstractTableModel) {
                ((AbstractTableModel)tableModel).fireTableDataChanged();
            }
        }

        @Override
        public Object getValueAt(Object object, int n) {
            FilterTableRow filterTableRow = this.map.get(object);
            return filterTableRow.getColData()[n - 1];
        }

        @Override
        public boolean isLeaf(Object object) {
            return ((TreeNode)object).isLeaf();
        }

        @Override
        public Object getChild(Object object, int n) {
            return ((TreeNode)object).getChildAt(n);
        }

        @Override
        public int getChildCount(Object object) {
            return ((TreeNode)object).getChildCount();
        }

        @Override
        public boolean isColumnSortable(int n) {
            return true;
        }

        public void addCondition(Object object) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            DefaultFilterElement defaultFilterElement = (DefaultFilterElement)((FilterTreeCell)defaultMutableTreeNode.getUserObject()).getFilterObject();
            if (!defaultFilterElement.isCondition()) {
                DefaultFilterElement defaultFilterElement2 = AdvancedCustomFilter.this.getConditionElem();
                FilterTreeCellExt filterTreeCellExt = new FilterTreeCellExt(defaultFilterElement2);
                filterTreeCellExt.setHideCheckbox(true);
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(filterTreeCellExt);
                this.addToMap(defaultFilterElement, defaultMutableTreeNode, defaultFilterElement2, defaultMutableTreeNode2, -1);
                TreePath treePath = this.getTreePath(defaultMutableTreeNode);
                AdvancedCustomFilter.this.treeTable.expandPath(treePath);
            } else {
                this.addCondition(defaultMutableTreeNode.getParent());
            }
        }

        public void addGroupCondition(Object object) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            DefaultFilterElement defaultFilterElement = (DefaultFilterElement)((FilterTreeCell)defaultMutableTreeNode.getUserObject()).getFilterObject();
            if (!defaultFilterElement.isCondition()) {
                DefaultFilterElement defaultFilterElement2 = AdvancedCustomFilter.this.getGroupConditionElem();
                FilterTreeCellExt filterTreeCellExt = new FilterTreeCellExt(defaultFilterElement2);
                filterTreeCellExt.setHideCheckbox(true);
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(filterTreeCellExt);
                this.addToMap(defaultFilterElement, defaultMutableTreeNode, defaultFilterElement2, defaultMutableTreeNode2, -1);
                DefaultFilterElement defaultFilterElement3 = AdvancedCustomFilter.this.getConditionElem();
                filterTreeCellExt = new FilterTreeCellExt(defaultFilterElement3);
                filterTreeCellExt.setHideCheckbox(true);
                DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(filterTreeCellExt);
                this.addToMap(defaultFilterElement2, defaultMutableTreeNode2, defaultFilterElement3, defaultMutableTreeNode3, -1);
                TreePath treePath = this.getTreePath(defaultMutableTreeNode2);
                AdvancedCustomFilter.this.treeTable.expandPath(treePath);
            } else {
                this.addGroup(defaultFilterElement, defaultMutableTreeNode);
            }
        }

        private void addGroup(DefaultFilterElement defaultFilterElement, DefaultMutableTreeNode defaultMutableTreeNode) {
            DefaultFilterElement defaultFilterElement2 = AdvancedCustomFilter.this.getGroupConditionElem();
            FilterTreeCellExt filterTreeCellExt = new FilterTreeCellExt(defaultFilterElement2);
            filterTreeCellExt.setHideCheckbox(true);
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(filterTreeCellExt);
            this.addToMap((DefaultFilterElement)defaultFilterElement.getParent(), (DefaultMutableTreeNode)defaultMutableTreeNode.getParent(), defaultFilterElement2, defaultMutableTreeNode2, defaultMutableTreeNode.getParent().getIndex(defaultMutableTreeNode));
            defaultFilterElement2.add(defaultFilterElement);
            defaultMutableTreeNode2.add(defaultMutableTreeNode);
            this.addCondition(defaultMutableTreeNode2);
            TreePath treePath = this.getTreePath(defaultMutableTreeNode2);
            AdvancedCustomFilter.this.treeTable.expandPath(treePath);
        }

        private TreePath getTreePath(TreeNode treeNode) {
            ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>(8);
            TreeNode treeNode2 = treeNode;
            do {
                arrayList.add(0, treeNode2);
            } while ((treeNode2 = treeNode2.getParent()) != null);
            return new TreePath(arrayList.toArray());
        }

        private void addToMap(DefaultFilterElement defaultFilterElement, DefaultMutableTreeNode defaultMutableTreeNode, DefaultFilterElement defaultFilterElement2, DefaultMutableTreeNode defaultMutableTreeNode2, int n) {
            if (-1 == n) {
                defaultFilterElement.add(defaultFilterElement2);
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
            } else {
                defaultFilterElement.insert(defaultFilterElement2, n);
                defaultMutableTreeNode.insert(defaultMutableTreeNode2, n);
            }
            Object[] objectArray = null;
            objectArray = defaultFilterElement2.isCondition() ? new Object[]{defaultFilterElement2.getViewColumnName(), defaultFilterElement2.getCondOperator(), defaultFilterElement2.getCondValue()} : new Object[]{"", "", ""};
            FilterTableRow filterTableRow = new FilterTableRow(defaultMutableTreeNode2, objectArray);
            this.map.put(defaultMutableTreeNode2, filterTableRow);
        }

        public void removeCondition(Object object) {
            DefaultMutableTreeNode defaultMutableTreeNode = this.getProperNode(object);
            if (null != defaultMutableTreeNode.getParent()) {
                this.remove(defaultMutableTreeNode);
            } else {
                int n = defaultMutableTreeNode.getChildCount();
                while (n > 0) {
                    this.remove((DefaultMutableTreeNode)defaultMutableTreeNode.getFirstChild());
                    n = defaultMutableTreeNode.getChildCount();
                }
            }
        }

        private void remove(DefaultMutableTreeNode defaultMutableTreeNode) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
            DefaultFilterElement defaultFilterElement = (DefaultFilterElement)((FilterTreeCell)defaultMutableTreeNode2.getUserObject()).getFilterObject();
            DefaultFilterElement defaultFilterElement2 = (DefaultFilterElement)((FilterTreeCell)defaultMutableTreeNode.getUserObject()).getFilterObject();
            defaultFilterElement.remove(defaultFilterElement2);
            defaultMutableTreeNode2.remove(defaultMutableTreeNode);
            this.removeColumnData(defaultMutableTreeNode);
        }

        private DefaultMutableTreeNode getProperNode(Object object) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            while (defaultMutableTreeNode.getParent() != null && defaultMutableTreeNode.getParent().getChildCount() == 1) {
                defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
            }
            return defaultMutableTreeNode;
        }

        private void removeColumnData(DefaultMutableTreeNode defaultMutableTreeNode) {
            this.map.remove(defaultMutableTreeNode);
            Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
            while (enumeration.hasMoreElements()) {
                this.removeColumnData((DefaultMutableTreeNode)enumeration.nextElement());
            }
        }

        public void setGroupOperator(Operators.GroupOperator groupOperator, DefaultMutableTreeNode defaultMutableTreeNode) {
            if (null == defaultMutableTreeNode) {
                return;
            }
            DefaultFilterElement defaultFilterElement = (DefaultFilterElement)((FilterTreeCell)defaultMutableTreeNode.getUserObject()).getFilterObject();
            if (!defaultFilterElement.isCondition()) {
                defaultFilterElement.setGroupOp(groupOperator);
            }
        }
    }

    private static class FilterTreeCellExt
    extends FilterTreeCell {
        private static Icon blankIcon = new BlankTreeIcon();

        FilterTreeCellExt(Object object) {
            super(object);
            this.setUncheckableClosedIcon(blankIcon);
            this.setUncheckableOpenedIcon(blankIcon);
            this.setUncheckableLeafIcon(blankIcon);
        }

        @Override
        public String toString() {
            return this.convertToString((FilterElement)this.getFilterObject());
        }

        private String convertToString(FilterElement filterElement) {
            if (null == filterElement || filterElement.isCondition()) {
                return " ";
            }
            switch (filterElement.getGroupOperator()) {
                case GROUP_OP_OR: {
                    return res.getString("Cond_GOP_OR");
                }
            }
            return res.getString("Cond_GOP_AND");
        }
    }

    private class TableMouseListener
    extends MouseAdapter {
        private TableMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                if (null == AdvancedCustomFilter.this.popup) {
                    AdvancedCustomFilter.this.initializePopup();
                }
                AdvancedCustomFilter.this.authorizePopup();
                int n = AdvancedCustomFilter.this.treeTable.rowAtPoint(mouseEvent.getPoint());
                int n2 = AdvancedCustomFilter.this.treeTable.getRowCount();
                if (n >= 0 && n < n2) {
                    AdvancedCustomFilter.this.treeTable.getSelectionModel().setSelectionInterval(n, n);
                    AdvancedCustomFilter.this.treeTable.removeEditor();
                    AdvancedCustomFilter.this.popup.show(AdvancedCustomFilter.this.treeTable, mouseEvent.getX(), mouseEvent.getY() - 1);
                } else {
                    AdvancedCustomFilter.this.logger.trace("row = " + n + ", total row count = " + n2);
                }
            } else if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                int n = AdvancedCustomFilter.this.treeTable.rowAtPoint(mouseEvent.getPoint());
                int n3 = AdvancedCustomFilter.this.treeTable.columnAtPoint(mouseEvent.getPoint());
                if (n >= 0 && n3 == 0) {
                    if (n == 0 && AdvancedCustomFilter.this.hideRootOperatorPopUp) {
                        return;
                    }
                    Object object = AdvancedCustomFilter.this.treeTable.getValueAt(n, n3);
                    final DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
                    int n4 = defaultMutableTreeNode.getLevel();
                    int n5 = (n4 + 1) * 20 + 3;
                    if (mouseEvent.getX() <= n5 || mouseEvent.getX() > n5 + 28) {
                        AdvancedCustomFilter.this.treeTable.setCursor(Cursor.getPredefinedCursor(0));
                        return;
                    }
                    DefaultFilterElement defaultFilterElement = (DefaultFilterElement)((FilterTreeCell)defaultMutableTreeNode.getUserObject()).getFilterObject();
                    if (defaultFilterElement.isCondition()) {
                        return;
                    }
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    JList jList = new JList();
                    jList.setSelectionMode(0);
                    jList.setFixedCellWidth(50);
                    Handler handler = new Handler(){

                        @Override
                        public void mouseReleased(MouseEvent mouseEvent) {
                            super.mouseReleased(mouseEvent);
                            JList jList = (JList)mouseEvent.getSource();
                            Operators.GroupOperator groupOperator = (Operators.GroupOperator)((Object)jList.getSelectedValue());
                            AdvancedCustomFilter.this.treeTableModel.setGroupOperator(groupOperator, defaultMutableTreeNode);
                            TreePath treePath = AdvancedCustomFilter.this.treeTable.getTreeSelectionPath();
                            if (null != treePath) {
                                AdvancedCustomFilter.this.treeTable.getTreeUI().revalidatePathBounds(treePath);
                            }
                        }
                    };
                    jList.addMouseListener(handler);
                    jList.addMouseMotionListener(handler);
                    Vector<Operators.GroupOperator> vector = new Vector<Operators.GroupOperator>(2);
                    vector.add(Operators.GroupOperator.GROUP_OP_AND);
                    vector.add(Operators.GroupOperator.GROUP_OP_OR);
                    jList.setListData(vector);
                    jPopupMenu.add(jList);
                    jPopupMenu.show(AdvancedCustomFilter.this.treeTable, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            int n = AdvancedCustomFilter.this.treeTable.rowAtPoint(mouseEvent.getPoint());
            int n2 = AdvancedCustomFilter.this.treeTable.columnAtPoint(mouseEvent.getPoint());
            if (n >= 0 && n2 == 0) {
                Object object = AdvancedCustomFilter.this.treeTable.getValueAt(n, n2);
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
                int n3 = defaultMutableTreeNode.getLevel();
                int n4 = (n3 + 1) * 20 + 3;
                if (mouseEvent.getX() <= n4 || mouseEvent.getX() > n4 + 28) {
                    AdvancedCustomFilter.this.treeTable.setCursor(Cursor.getPredefinedCursor(0));
                    return;
                }
                DefaultFilterElement defaultFilterElement = (DefaultFilterElement)((FilterTreeCell)defaultMutableTreeNode.getUserObject()).getFilterObject();
                if (defaultFilterElement.isCondition()) {
                    AdvancedCustomFilter.this.treeTable.setCursor(Cursor.getPredefinedCursor(0));
                    return;
                }
                AdvancedCustomFilter.this.treeTable.setCursor(Cursor.getPredefinedCursor(12));
            } else {
                AdvancedCustomFilter.this.treeTable.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }
}

