/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.basictable;

import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.templates.basictable.BasicTable;
import com.swimap.iview.templates.basictable.ColumnInformation;
import com.swimap.iview.templates.basictable.CustomizeListener;
import com.swimap.iview.templates.textfield.IntegerDocument;
import com.swimap.iview.templates.textfield.IntegerTextField;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.helpmanagement.HelpManager;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import javax.swing.text.Position;

public class CustomizeDlg
extends JDialog {
    private static IviewLogger logger = IviewLogger.getLogger(CustomizeDlg.class, "IVIEW");
    private static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/templates/basictable/Res");
    private static final Dimension DIMENSION = new Dimension(80, 21);
    private static final int CHECKBOX_WIDTH = 20;
    private static final int MIN_WIDTH = 0;
    private static final int MAX_WIDTH = 999;
    private static final int DEFAULT_COLNAME_MAXLENGTH = 100;
    private JTextField widthField = new IntegerTextField(0, 999);
    private JButton okBtn = new JButton(res.getString("Btn_OK"));
    private JButton cancelBtn = new JButton(res.getString("Btn_Cancel"));
    private JButton downBtn = new JButton(res.getString("Btn_Down"));
    private JButton upBtn = new JButton(res.getString("Btn_Up"));
    private JButton showBtn = new JButton(res.getString("Btn_Show"));
    private JButton hideBtn = new JButton(res.getString("Btn_Hide"));
    private JButton resetBtn = new JButton(res.getString("Btn_Reset"));
    private JButton showAllBtn = new JButton(res.getString("Btn_Show_All"));
    private JButton hideAllBtn = new JButton(res.getString("Btn_Hide_All"));
    private JList columnList = new DialogList();
    private JPanel southPane = new JPanel(new GridBagLayout());
    private JPanel bottomBtnPane = new JPanel(new GridBagLayout());
    private JPanel rightBtnPane = new JPanel(new GridBagLayout());
    private JTextField nameField = new JTextField();
    private String note1 = res.getString("note1");
    private JTextArea noteArea = new JTextArea(this.note1);
    private String note2 = res.getString("note2");
    private ColumnInformation[] columnsInfo = null;
    private ColumnInformation[] backupColumnsInfo = null;
    private BasicTable table = null;
    private Vector listenerVector = new Vector(5, 5);
    private boolean colIndexCustomizable = true;
    private int visibleCount = 0;
    private int alwaysShowCount = 0;
    private Object identifier = null;
    private int colNameMaxLength = 100;
    private boolean isInnerUpdate = false;
    private int innerUpdateCount = 0;
    private boolean isColumnNameCustomizable = true;
    private boolean isColumnWidthCustomizable = true;
    private JLabel nameLabel = null;
    private JLabel colwidthLabel = null;
    private JLabel pixelLabel = null;
    private JLabel emptyColNameLabel = null;
    private JPanel upDownPane = null;
    private JPanel parentPane = null;
    private JPanel parentPane1 = null;

    public CustomizeDlg(Frame frame, String string, boolean bl, ColumnInformation[] columnInformationArray, BasicTable basicTable) throws HeadlessException {
        super(frame, string, bl);
        this.init(columnInformationArray, basicTable);
    }

    public CustomizeDlg(Dialog dialog, String string, boolean bl, ColumnInformation[] columnInformationArray, BasicTable basicTable) throws HeadlessException {
        super(dialog, string, bl);
        this.init(columnInformationArray, basicTable);
    }

    public CustomizeDlg(Frame frame, String string, boolean bl, ColumnInformation[] columnInformationArray) {
        this(frame, string, bl, columnInformationArray, null);
    }

    public CustomizeDlg(Dialog dialog, String string, boolean bl, ColumnInformation[] columnInformationArray) {
        this(dialog, string, bl, columnInformationArray, null);
    }

    private void init(ColumnInformation[] columnInformationArray, BasicTable basicTable) {
        this.columnsInfo = new ColumnInformation[columnInformationArray.length];
        for (int i = 0; i < this.columnsInfo.length; ++i) {
            this.columnsInfo[i] = new ColumnInformation(columnInformationArray[i].getIdentifier(), columnInformationArray[i].getColName(), columnInformationArray[i].getState(), columnInformationArray[i].getColWidth(), columnInformationArray[i].getIndex());
        }
        this.backupColumnsInfo = columnInformationArray;
        this.table = basicTable;
        this.initList(this.columnsInfo);
        try {
            this.jbinit();
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
    }

    private void jbinit() throws Exception {
        this.columnList.setCellRenderer(new CheckRender());
        this.columnList.setSelectionMode(0);
        this.columnList.setName("CustomizeDlg_columnList");
        Border border = BorderFactory.createEmptyBorder(0, 0, 0, 10);
        this.noteArea.setBorder(border);
        this.noteArea.setFont(UIManager.getFont("Label.font"));
        this.noteArea.setWrapStyleWord(true);
        this.noteArea.setLineWrap(true);
        this.noteArea.setEditable(false);
        this.noteArea.setFocusable(false);
        this.noteArea.setForeground(UIManager.getColor("Panel.Foreground"));
        this.noteArea.setBackground(UIManager.getColor("Panel.Background"));
        this.noteArea.setName("CustomizeDlg_noteArea");
        this.okBtn.setPreferredSize(DIMENSION);
        this.okBtn.setName("CustomizeDlg_okBtn");
        this.cancelBtn.setPreferredSize(DIMENSION);
        this.cancelBtn.setMargin(new Insets(0, 0, 0, 0));
        this.cancelBtn.setName("CustomizeDlg_cancelBtn");
        this.upBtn.setPreferredSize(DIMENSION);
        this.upBtn.setMnemonic('U');
        this.upBtn.setName("CustomizeDlg_upBtn");
        this.downBtn.setPreferredSize(DIMENSION);
        this.downBtn.setMnemonic('D');
        this.downBtn.setName("CustomizeDlg_downBtn");
        this.hideBtn.setPreferredSize(DIMENSION);
        this.hideBtn.setMnemonic('H');
        this.hideBtn.setName("CustomizeDlg_hideBtn");
        this.showBtn.setPreferredSize(DIMENSION);
        this.showBtn.setMnemonic('S');
        this.showBtn.setName("CustomizeDlg_showBtn");
        this.resetBtn.setPreferredSize(DIMENSION);
        this.resetBtn.setMnemonic('R');
        this.resetBtn.setName("CustomizeDlg_resetBtn");
        this.showAllBtn.setPreferredSize(DIMENSION);
        this.showAllBtn.setMnemonic('A');
        Insets insets = this.showAllBtn.getInsets();
        insets.left = 0;
        insets.right = 0;
        this.showAllBtn.setMargin(insets);
        this.showAllBtn.setName("CustomizeDlg_showAllBtn");
        this.hideAllBtn.setPreferredSize(DIMENSION);
        this.hideAllBtn.setMnemonic('I');
        this.hideAllBtn.setName("CustomizeDlg_hideAllBtn");
        this.colwidthLabel = new JLabel(res.getString("Col_Width"));
        this.colwidthLabel.setLabelFor(this.widthField);
        ((IntegerTextField)this.widthField).setTooltipEnabled(true);
        this.colwidthLabel.setDisplayedMnemonic('W');
        this.widthField.setName("CustomizeDlg_colwidthText");
        this.colwidthLabel.setName("CustomizeDlg_colwidthLabel");
        this.southPane.add((Component)this.colwidthLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.southPane.add((Component)this.widthField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 5, 10), 0, 0));
        this.pixelLabel = new JLabel(res.getString("pixers"));
        this.southPane.add((Component)this.pixelLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 90), 0, 0));
        this.nameLabel = new JLabel(res.getString("Col_Name"));
        this.emptyColNameLabel = new JLabel("      ");
        this.nameLabel.setLabelFor(this.nameField);
        this.nameLabel.setDisplayedMnemonic('N');
        if (this.nameLabel.getText().indexOf(78) != -1) {
            this.nameLabel.setDisplayedMnemonicIndex(this.nameLabel.getText().lastIndexOf("N"));
        }
        this.nameLabel.setName("CustomizeDlg_nameLabel");
        this.nameField.setToolTipText(null);
        this.nameField.setDocument(new LengthDocument());
        this.southPane.add((Component)this.nameLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.southPane.add((Component)this.nameField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 0, 0, 10), 0, 0));
        this.southPane.add((Component)this.emptyColNameLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 90), 0, 0));
        JSeparator jSeparator = new JSeparator();
        jSeparator.setMinimumSize(new Dimension(300, 2));
        this.southPane.add((Component)jSeparator, new GridBagConstraints(0, 3, 3, 1, 1.0, 0.0, 18, 2, new Insets(8, 0, 8, 0), 0, 0));
        this.southPane.add((Component)this.bottomBtnPane, new GridBagConstraints(0, 4, 3, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout(10, 10));
        if (container instanceof JComponent) {
            ((JComponent)container).setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        }
        JScrollPane jScrollPane = new JScrollPane(this.columnList);
        jScrollPane.setPreferredSize(new Dimension(400, 260));
        this.bottomBtnPane.add((Component)this.okBtn, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 343, 0, 5), 0, 0));
        this.bottomBtnPane.add((Component)this.cancelBtn, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.upDownPane = new JPanel(new BorderLayout());
        this.upDownPane.setPreferredSize(new Dimension(80, 47));
        this.upDownPane.add((Component)this.upBtn, "North");
        this.upDownPane.add((Component)this.downBtn, "South");
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setPreferredSize(new Dimension(80, 47));
        jPanel.add((Component)this.hideBtn, "North");
        jPanel.add((Component)this.hideAllBtn, "South");
        this.parentPane = new JPanel(new BorderLayout());
        this.parentPane.setPreferredSize(new Dimension(80, 103));
        this.parentPane.add((Component)this.upDownPane, "North");
        this.parentPane.add((Component)jPanel, "South");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.setPreferredSize(new Dimension(100, 77));
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setPreferredSize(new Dimension(100, 47));
        jPanel3.add((Component)this.showBtn, "North");
        jPanel3.add((Component)this.showAllBtn, "South");
        jPanel2.add((Component)jPanel3, "North");
        jPanel2.add((Component)this.resetBtn, "South");
        this.parentPane1 = new JPanel(new BorderLayout());
        this.parentPane1.setPreferredSize(new Dimension(100, 185));
        this.parentPane1.add((Component)this.parentPane, "North");
        this.parentPane1.add((Component)jPanel2, "South");
        this.rightBtnPane.setLayout(new BorderLayout());
        this.rightBtnPane.add((Component)this.parentPane1, "North");
        this.rightBtnPane.add(Box.createVerticalGlue(), "Center");
        container.add((Component)this.noteArea, "North");
        container.add((Component)jScrollPane, "Center");
        container.add((Component)this.rightBtnPane, "East");
        container.add((Component)this.southPane, "South");
        this.setResizable(false);
        this.initListeners();
        this.columnList.setSelectedIndex(0);
        this.okBtn.setEnabled(false);
        ScreenToolKit.setDefaultButtons(this.okBtn, this.cancelBtn);
        this.setSize(new Dimension(538, 390));
        HelpManager.getInstance().enableHelpKey(container, "iView.table.columnDialog");
    }

    private void initList(ColumnInformation[] columnInformationArray) {
        this.visibleCount = 0;
        this.alwaysShowCount = 0;
        DefaultListModel<ColumnInformation> defaultListModel = new DefaultListModel<ColumnInformation>();
        Arrays.sort(columnInformationArray);
        for (int i = 0; i < columnInformationArray.length; ++i) {
            if (columnInformationArray[i].getState() == 3) continue;
            defaultListModel.addElement(columnInformationArray[i]);
            if (columnInformationArray[i].getState() != 1) {
                ++this.visibleCount;
            }
            if (columnInformationArray[i].getState() != 2 && columnInformationArray[i].getState() != 4) continue;
            ++this.alwaysShowCount;
        }
        this.columnList.setModel(defaultListModel);
        if (this.visibleCount == 1) {
            this.setLastVisibleColumn();
        }
    }

    public void setColNameCustomizable(boolean bl) {
        this.isColumnNameCustomizable = bl;
        int n = -1;
        if (this.columnList != null) {
            int n2 = this.columnList.getSelectedIndex();
            ColumnInformation columnInformation = (ColumnInformation)this.columnList.getModel().getElementAt(n2);
            if (columnInformation != null) {
                n = columnInformation.getState();
            }
        }
        if (bl) {
            if (n == 4) {
                this.nameField.setEditable(false);
                this.nameField.setForeground(Color.GRAY);
            } else {
                this.nameField.setEditable(true);
                this.nameField.setForeground(Color.BLACK);
            }
        } else {
            this.nameField.setEditable(false);
            this.nameField.setForeground(Color.GRAY);
        }
    }

    public void setColNameVisible(boolean bl) {
        this.nameField.setVisible(bl);
        this.nameLabel.setVisible(bl);
        this.emptyColNameLabel.setVisible(bl);
    }

    public void setColWidthVisible(boolean bl) {
        this.widthField.setVisible(bl);
        this.colwidthLabel.setVisible(bl);
        this.pixelLabel.setVisible(bl);
    }

    public void setColIndexVisible(boolean bl) {
        this.upBtn.setVisible(bl);
        this.downBtn.setVisible(bl);
        this.upDownPane.setVisible(bl);
        int n = 100;
        int n2 = 103;
        int n3 = 52;
        int n4 = 185;
        int n5 = 134;
        if (bl) {
            this.parentPane1.setPreferredSize(new Dimension(n, n4));
            this.parentPane.setPreferredSize(new Dimension(n, n2));
        } else {
            this.parentPane1.setPreferredSize(new Dimension(n, n5));
            this.parentPane.setPreferredSize(new Dimension(n, n3));
        }
        this.updateNoteAreaMessage();
    }

    public void setColWidthCustomizable(boolean bl) {
        this.isColumnWidthCustomizable = bl;
        int n = -1;
        if (this.columnList != null) {
            int n2 = this.columnList.getSelectedIndex();
            ColumnInformation columnInformation = (ColumnInformation)this.columnList.getModel().getElementAt(n2);
            if (columnInformation != null) {
                n = columnInformation.getState();
            }
        }
        if (bl && n != 4) {
            this.widthField.setEditable(true);
            this.widthField.setForeground(Color.BLACK);
        } else {
            this.widthField.setEditable(false);
            this.widthField.setToolTipText(null);
            this.widthField.setForeground(Color.GRAY);
        }
    }

    public void setColIndexCustomizable(boolean bl) {
        this.colIndexCustomizable = bl;
        if (!this.colIndexCustomizable) {
            this.upBtn.setEnabled(false);
            this.downBtn.setEnabled(false);
        }
        this.updateNoteAreaMessage();
    }

    public void addCustomizeListener(CustomizeListener customizeListener) {
        if (!this.listenerVector.contains(customizeListener)) {
            this.listenerVector.add(customizeListener);
        }
    }

    public void removeCustomizeListener(CustomizeListener customizeListener) {
        if (this.listenerVector.contains(customizeListener)) {
            this.listenerVector.remove(customizeListener);
        }
    }

    public ColumnInformation[] getColumnsInfo() {
        return this.backupColumnsInfo;
    }

    private void initListeners() {
        this.upBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomizeDlg.this.upBtnAction();
            }
        });
        this.downBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomizeDlg.this.downBtnAction();
            }
        });
        this.showBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomizeDlg.this.showBtnAction();
            }
        });
        this.hideBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomizeDlg.this.hideBtnAction();
            }
        });
        this.okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomizeDlg.this.okBtnAction(actionEvent);
            }
        });
        this.cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomizeDlg.this.cancelBtnAction(actionEvent);
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                CustomizeDlg.this.cancelBtn.doClick();
            }
        });
        this.resetBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomizeDlg.this.resetBtnAction();
            }
        });
        this.showAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomizeDlg.this.showAllBtnAction();
            }
        });
        this.hideAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomizeDlg.this.hideAllBtnAction();
            }
        });
        DocumentListener documentListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                CustomizeDlg.this.setNameAndWidth(CustomizeDlg.this.isInnerUpdate);
                CustomizeDlg.this.okBtn.setEnabled(true);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                CustomizeDlg.this.setNameAndWidth(CustomizeDlg.this.isInnerUpdate);
                CustomizeDlg.this.okBtn.setEnabled(true);
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                CustomizeDlg.this.setNameAndWidth(CustomizeDlg.this.isInnerUpdate);
                CustomizeDlg.this.okBtn.setEnabled(true);
            }
        };
        this.nameField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                int n = CustomizeDlg.this.columnList.getSelectedIndex();
                if (n < 0) {
                    return;
                }
                ColumnInformation columnInformation = (ColumnInformation)CustomizeDlg.this.columnList.getModel().getElementAt(n);
                columnInformation.setColName(CustomizeDlg.this.nameField.getText());
                Rectangle rectangle = CustomizeDlg.this.columnList.getCellBounds(n, n);
                CustomizeDlg.this.columnList.repaint(rectangle);
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                int n = CustomizeDlg.this.columnList.getSelectedIndex();
                if (n < 0) {
                    return;
                }
                ColumnInformation columnInformation = (ColumnInformation)CustomizeDlg.this.columnList.getModel().getElementAt(n);
                columnInformation.setColName(CustomizeDlg.this.nameField.getText());
                Rectangle rectangle = CustomizeDlg.this.columnList.getCellBounds(n, n);
                CustomizeDlg.this.columnList.repaint(rectangle);
            }
        });
        this.nameField.getDocument().addDocumentListener(documentListener);
        this.widthField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                int n = CustomizeDlg.this.columnList.getSelectedIndex();
                if (n < 0) {
                    return;
                }
                ColumnInformation columnInformation = (ColumnInformation)CustomizeDlg.this.columnList.getModel().getElementAt(n);
                if (CustomizeDlg.this.widthField.getText().length() > 0) {
                    columnInformation.setColWidth(Integer.parseInt(CustomizeDlg.this.widthField.getText().trim()));
                } else {
                    columnInformation.setColWidth(0);
                }
            }
        });
        this.widthField.getDocument().addDocumentListener(documentListener);
        this.columnList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                CustomizeDlg.this.listSelectionChanged(CustomizeDlg.this.columnList.getSelectedIndex());
            }
        });
        this.columnList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                CustomizeDlg.this.columnListMouseAction(mouseEvent);
            }
        });
        this.columnList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                CustomizeDlg.this.columnListKeyAction(keyEvent);
            }
        });
    }

    private void setNameAndWidth(boolean bl) {
        if (bl) {
            ++this.innerUpdateCount;
            if (this.innerUpdateCount == 2) {
                this.isInnerUpdate = false;
                this.innerUpdateCount = 0;
            }
            return;
        }
        if (this.columnList.getSelectedIndex() < 0) {
            return;
        }
        ColumnInformation columnInformation = (ColumnInformation)this.columnList.getModel().getElementAt(this.columnList.getSelectedIndex());
        if (this.nameField.getText().length() != 0) {
            columnInformation.setColName(this.nameField.getText());
        }
        if (this.widthField.getText().length() > 0) {
            columnInformation.setColWidth(Integer.parseInt(this.widthField.getText().trim()));
        } else {
            columnInformation.setColWidth(0);
        }
    }

    private void upBtnAction() {
        this.changeIndex(true);
        this.okBtn.setEnabled(true);
        this.columnList.requestFocus();
    }

    private void downBtnAction() {
        this.changeIndex(false);
        this.okBtn.setEnabled(true);
        this.columnList.requestFocus();
    }

    private void showBtnAction() {
        int n = this.columnList.getSelectedIndex();
        ColumnInformation columnInformation = (ColumnInformation)this.columnList.getModel().getElementAt(n);
        columnInformation.setState(0);
        ++this.visibleCount;
        if (this.visibleCount > 1) {
            this.setColVisibleShow(this.identifier);
        }
        this.columnList.repaint();
        this.listSelectionChanged(n);
        this.okBtn.setEnabled(true);
        this.columnList.requestFocus();
    }

    private void hideBtnAction() {
        int n = this.columnList.getSelectedIndex();
        ColumnInformation columnInformation = (ColumnInformation)this.columnList.getModel().getElementAt(n);
        columnInformation.setState(1);
        --this.visibleCount;
        if (this.visibleCount == 1) {
            this.setLastVisibleColumn();
        }
        this.columnList.repaint();
        this.listSelectionChanged(n);
        this.okBtn.setEnabled(true);
        this.columnList.requestFocus();
    }

    private void resetBtnAction() {
        this.columnsInfo = new ColumnInformation[this.backupColumnsInfo.length];
        for (int i = 0; i < this.columnsInfo.length; ++i) {
            this.columnsInfo[i] = new ColumnInformation(this.backupColumnsInfo[i].getIdentifier(), this.backupColumnsInfo[i].getColName(), this.backupColumnsInfo[i].getState(), this.backupColumnsInfo[i].getColWidth(), this.backupColumnsInfo[i].getIndex());
        }
        this.initList(this.columnsInfo);
        if (this.columnList.getModel().getSize() > 0) {
            this.columnList.setSelectedIndex(0);
            this.columnList.scrollRectToVisible(this.columnList.getCellBounds(0, 0));
        }
        this.okBtn.setEnabled(false);
        this.columnList.requestFocus();
    }

    private void okBtnAction(ActionEvent actionEvent) {
        this.setColVisibleShow(this.identifier);
        this.adjustColWidth();
        this.backupColumnsInfo = this.columnsInfo;
        if (this.table != null) {
            this.table.updateTable(this.columnsInfo);
            if (this.table.isPersistenceEnabled() && this.table.isAutoPersistenceTable()) {
                new Thread(){

                    @Override
                    public void run() {
                        CustomizeDlg.this.table.persistenceTable(CustomizeDlg.this.columnsInfo);
                    }
                }.start();
            }
        }
        int n = this.listenerVector.size();
        for (int i = 0; i < n; ++i) {
            ((CustomizeListener)this.listenerVector.get(i)).OKBtn_actionPerformed(actionEvent);
        }
        this.dispose();
    }

    private void cancelBtnAction(ActionEvent actionEvent) {
        int n = this.listenerVector.size();
        for (int i = 0; i < n; ++i) {
            ((CustomizeListener)this.listenerVector.get(i)).CancelBtn_actionPerformed(actionEvent);
        }
        this.dispose();
    }

    private void columnListMouseAction(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent) && (mouseEvent.getX() < 20 || mouseEvent.getX() >= 20 && mouseEvent.getClickCount() % 2 == 0)) {
            int n = this.columnList.locationToIndex(mouseEvent.getPoint());
            this.changeState(n);
            this.listSelectionChanged(this.columnList.getSelectedIndex());
            Rectangle rectangle = this.columnList.getCellBounds(n, n);
            this.columnList.repaint(rectangle);
        }
    }

    private void columnListKeyAction(KeyEvent keyEvent) {
        int n;
        if (keyEvent.getKeyCode() == 32 && (n = this.columnList.getSelectedIndex()) != -1) {
            this.changeState(n);
            this.listSelectionChanged(this.columnList.getSelectedIndex());
            Rectangle rectangle = this.columnList.getCellBounds(n, n);
            this.columnList.repaint(rectangle);
        }
    }

    private void showAllBtnAction() {
        this.visibleCount = 0;
        int n = this.columnList.getModel().getSize();
        ColumnInformation columnInformation = null;
        for (int i = 0; i < n; ++i) {
            columnInformation = (ColumnInformation)this.columnList.getModel().getElementAt(i);
            if (columnInformation.getState() == 2 || columnInformation.getState() == 4) {
                ++this.visibleCount;
                continue;
            }
            if (columnInformation.getState() == 3) continue;
            columnInformation.setState(0);
            ++this.visibleCount;
            if (this.visibleCount <= 1) continue;
            this.setColVisibleShow(this.identifier);
        }
        this.reintializeColList();
    }

    private void hideAllBtnAction() {
        int n = this.columnList.getModel().getSize();
        ColumnInformation columnInformation = null;
        int n2 = 0;
        for (int i = n - 1; i >= 0; --i) {
            columnInformation = (ColumnInformation)this.columnList.getModel().getElementAt(i);
            if (columnInformation.getState() == 2 || columnInformation.getState() == 4) {
                ++n2;
                continue;
            }
            if (columnInformation.getState() == 3 || columnInformation.getState() == 1) continue;
            columnInformation.setState(1);
            --this.visibleCount;
            if (this.visibleCount != 1 || n2 > 1) continue;
            this.setLastVisibleColumn();
        }
        this.reintializeColList();
    }

    private void reintializeColList() {
        this.columnList.repaint();
        this.listSelectionChanged(this.columnList.getSelectedIndex());
        this.okBtn.setEnabled(true);
        this.columnList.requestFocus();
    }

    private void changeState(int n) {
        ColumnInformation columnInformation = (ColumnInformation)this.columnList.getModel().getElementAt(n);
        switch (columnInformation.getState()) {
            case 0: {
                columnInformation.setState(1);
                --this.visibleCount;
                if (this.visibleCount == 1) {
                    this.setLastVisibleColumn();
                }
                this.okBtn.setEnabled(true);
                break;
            }
            case 1: {
                columnInformation.setState(0);
                ++this.visibleCount;
                if (this.visibleCount > 1) {
                    this.setColVisibleShow(this.identifier);
                }
                this.okBtn.setEnabled(true);
                break;
            }
        }
    }

    private void changeIndex(boolean bl) {
        int n = this.columnList.getSelectedIndex();
        ColumnInformation columnInformation = (ColumnInformation)this.columnList.getModel().getElementAt(n);
        ColumnInformation columnInformation2 = this.getNewSelectableColumn(n, bl);
        if (columnInformation2 == null) {
            logger.debug("next selectable columnInformation is null");
            return;
        }
        int n2 = this.getNewSelectableIndex(n, bl);
        if (n2 == -1) {
            logger.debug("next selectable index is -1");
            return;
        }
        int n3 = columnInformation.getIndex();
        int n4 = columnInformation2.getIndex();
        columnInformation.setIndex(n4);
        columnInformation2.setIndex(n3);
        ((DefaultListModel)this.columnList.getModel()).setElementAt(columnInformation, n2);
        ((DefaultListModel)this.columnList.getModel()).setElementAt(columnInformation2, n);
        this.columnList.setSelectedIndex(n2);
        this.columnList.scrollRectToVisible(this.columnList.getCellBounds(n2, n2));
        this.okBtn.setEnabled(true);
    }

    private ColumnInformation getNewSelectableColumn(int n, boolean bl) {
        int n2 = this.columnList.getModel().getSize() - 1;
        ColumnInformation columnInformation = null;
        int n3 = bl ? -1 : 1;
        int n4 = n + n3;
        if (n4 <= -1 && bl) {
            return null;
        }
        if (n4 > n2 && !bl) {
            return null;
        }
        columnInformation = (ColumnInformation)this.columnList.getModel().getElementAt(n4);
        while (columnInformation.getState() == 4) {
            if ((n4 += n3) <= -1 && bl) {
                return null;
            }
            if (n4 > n2 && !bl) {
                return null;
            }
            columnInformation = (ColumnInformation)this.columnList.getModel().getElementAt(n4);
        }
        return columnInformation;
    }

    private int getNewSelectableIndex(int n, boolean bl) {
        int n2 = this.columnList.getModel().getSize() - 1;
        ColumnInformation columnInformation = null;
        int n3 = bl ? -1 : 1;
        int n4 = n + n3;
        if (n4 <= -1 && bl) {
            return -1;
        }
        if (n4 > n2 && !bl) {
            return -1;
        }
        columnInformation = (ColumnInformation)this.columnList.getModel().getElementAt(n4);
        while (columnInformation.getState() == 4) {
            if ((n4 += n3) <= -1 && bl) {
                return -1;
            }
            if (n4 > n2 && !bl) {
                return -1;
            }
            columnInformation = (ColumnInformation)this.columnList.getModel().getElementAt(n4);
        }
        return n4;
    }

    private void adjustColWidth() {
        block0: for (int i = 0; i < this.columnsInfo.length; ++i) {
            if (this.columnsInfo[i].getColWidth() != 0) continue;
            for (int j = 0; j < this.backupColumnsInfo.length; ++j) {
                if (!this.backupColumnsInfo[j].getIdentifier().equals(this.columnsInfo[i].getIdentifier())) continue;
                this.columnsInfo[i].setColWidth(this.backupColumnsInfo[j].getColWidth());
                continue block0;
            }
        }
    }

    private int getColWidth(Object object) {
        Hashtable hashtable = this.table.getColumns();
        Set set = hashtable.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            TableColumn tableColumn = (TableColumn)hashtable.get(iterator.next());
            if (!tableColumn.getIdentifier().equals(object)) continue;
            return tableColumn.getMinWidth();
        }
        return 0;
    }

    private void listSelectionChanged(int n) {
        this.hideAllBtn.setEnabled(this.isAllColumnHidden());
        this.showAllBtn.setEnabled(this.isAllColumnVisible());
        boolean bl = this.okBtn.isEnabled();
        if (n < 0) {
            this.upBtn.setEnabled(false);
            this.downBtn.setEnabled(false);
            this.hideBtn.setEnabled(false);
            this.showBtn.setEnabled(false);
            this.nameField.setText("");
            this.widthField.setText("");
            this.nameField.setEditable(false);
            this.widthField.setEditable(false);
            this.okBtn.setEnabled(bl);
            this.updateNoteAreaMessage();
            return;
        }
        ColumnInformation columnInformation = (ColumnInformation)this.columnList.getModel().getElementAt(n);
        this.isInnerUpdate = true;
        this.nameField.setText(columnInformation.getColName());
        this.nameField.setCaretPosition(0);
        int n2 = columnInformation.getColWidth();
        int n3 = this.getColWidth(columnInformation.getIdentifier());
        if (n2 > 999) {
            ((IntegerTextField)this.widthField).setRange(n3, n2);
            ((IntegerDocument)this.widthField.getDocument()).setRange(n3, n2);
            this.widthField.setToolTipText("[" + n3 + ',' + n2 + ']');
        } else {
            ((IntegerTextField)this.widthField).setRange(n3, 999);
            ((IntegerDocument)this.widthField.getDocument()).setRange(n3, 999);
            this.widthField.setToolTipText("[" + n3 + ',' + 999 + ']');
        }
        this.isInnerUpdate = true;
        this.widthField.setText(Integer.toString(columnInformation.getColWidth()));
        this.hideBtn.setEnabled(columnInformation.getState() == 0);
        this.showBtn.setEnabled(columnInformation.getState() == 1);
        if (this.colIndexCustomizable) {
            if (null != this.getNewSelectableColumn(n, true)) {
                this.upBtn.setEnabled(true);
            } else {
                this.upBtn.setEnabled(false);
            }
            if (null != this.getNewSelectableColumn(n, false)) {
                this.downBtn.setEnabled(true);
            } else {
                this.downBtn.setEnabled(false);
            }
            if (columnInformation.getState() == 4) {
                this.downBtn.setEnabled(false);
                this.upBtn.setEnabled(false);
            }
        } else {
            this.upBtn.setEnabled(false);
            this.downBtn.setEnabled(false);
        }
        if (this.isColumnNameCustomizable && columnInformation.getState() != 4) {
            this.nameField.setEditable(true);
            this.nameField.setForeground(Color.BLACK);
        } else {
            this.nameField.setEditable(false);
            this.nameField.setForeground(Color.GRAY);
        }
        if (this.isColumnWidthCustomizable && columnInformation.getState() != 4) {
            this.widthField.setEditable(true);
            this.widthField.setForeground(Color.BLACK);
        } else {
            this.widthField.setEditable(false);
            this.widthField.setToolTipText(null);
            this.widthField.setForeground(Color.GRAY);
        }
        this.okBtn.setEnabled(bl);
        this.updateNoteAreaMessage();
    }

    private void updateNoteAreaMessage() {
        if (this.colIndexCustomizable && this.upDownPane.isVisible()) {
            if (!this.upBtn.isEnabled() && !this.downBtn.isEnabled()) {
                this.noteArea.setText(this.note2);
            } else {
                this.noteArea.setText(this.note1);
            }
        } else {
            this.noteArea.setText(this.note2);
        }
    }

    private boolean isAllColumnHidden() {
        int n = this.columnList.getModel().getSize();
        int n2 = n - this.visibleCount;
        boolean bl = false;
        bl = n2 + this.alwaysShowCount == n ? false : (this.alwaysShowCount == 0 && n2 == n - 1 ? false : this.alwaysShowCount == 0 || n2 != n - 1);
        return bl;
    }

    private boolean isAllColumnVisible() {
        int n = this.columnList.getModel().getSize();
        return this.visibleCount != n;
    }

    private void setLastVisibleColumn() {
        ColumnInformation columnInformation = null;
        int n = this.columnList.getModel().getSize();
        for (int i = 0; i < n; ++i) {
            columnInformation = (ColumnInformation)this.columnList.getModel().getElementAt(i);
            if (columnInformation.getState() == 2 || columnInformation.getState() == 4) {
                return;
            }
            if (columnInformation.getState() != 0) continue;
            columnInformation.setState(2);
            this.identifier = columnInformation.getIdentifier();
            this.columnList.repaint();
            return;
        }
    }

    private void setColVisibleShow(Object object) {
        if (object == null) {
            return;
        }
        ColumnInformation columnInformation = null;
        int n = this.columnList.getModel().getSize();
        for (int i = 0; i < n; ++i) {
            columnInformation = (ColumnInformation)this.columnList.getModel().getElementAt(i);
            if (!columnInformation.getIdentifier().equals(object)) continue;
            columnInformation.setState(0);
            this.identifier = null;
            break;
        }
        this.columnList.repaint();
    }

    public void setColNameMaxLength(int n) {
        this.colNameMaxLength = n;
    }

    private class DialogList
    extends JList {
        private DialogList() {
        }

        @Override
        public int getNextMatch(String string, int n, Position.Bias bias) {
            if (null != string && string.startsWith(" ")) {
                return -1;
            }
            return super.getNextMatch(string, n, bias);
        }
    }

    private class LengthDocument
    extends PlainDocument {
        private LengthDocument() {
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (this.getText(0, this.getLength()).getBytes().length + string.getBytes().length > CustomizeDlg.this.colNameMaxLength) {
                return;
            }
            super.insertString(n, string, attributeSet);
        }
    }

    private class CheckRender
    extends JCheckBox
    implements ListCellRenderer {
        private Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

        private CheckRender() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            ColumnInformation columnInformation = (ColumnInformation)object;
            this.setSelected(columnInformation.getState() != 1);
            int n2 = columnInformation.getState();
            if (n2 == 2 || n2 == 4) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
            this.setFont(jList.getFont());
            this.setText(object.toString());
            this.setBackground(bl ? UIManager.getColor("List.selectionBackground") : UIManager.getColor("List.background"));
            this.setBorderPainted(true);
            if (bl2) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(this.noFocusBorder);
            }
            return this;
        }
    }
}

