/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.basictable;

import com.swimap.iview.commstyle.commini.AreaDescContainer;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.commini.DialogCommStyleInfo;
import com.swimap.iview.commstyle.commini.GUICompCommStyleInfo;
import com.swimap.iview.commstyle.commini.xmlbind.PARA;
import com.swimap.iview.commstyle.commini.xmlbind.PARAS;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.commstyle.resource.i18n.ResourceUtil;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.templates.basictable.ColumnInformation;
import com.swimap.iview.templates.basictable.CustomizeDlg;
import com.swimap.iview.templates.basictable.TableActionElement;
import com.swimap.iview.templates.basictable.filter.CustomFilterDlg;
import com.swimap.iview.templates.basictable.filter.DefaultFilterElement;
import com.swimap.iview.templates.basictable.filter.FilterElement;
import com.swimap.iview.templates.basictable.filter.Filterable;
import com.swimap.iview.templates.basictable.filter.Operators;
import com.swimap.iview.templates.beans.TableProperties;
import com.swimap.iview.templates.beans.selectlist.SelectList;
import com.swimap.iview.templates.beans.selectlist.StateChangedListener;
import com.swimap.iview.templates.utils.MultiRowToolTip;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolTip;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.View;

public class BasicTable
extends JTable
implements TableProperties {
    private static IviewLogger logger = IviewLogger.getLogger(BasicTable.class, "IVIEW");
    public static final int RESIZE_FOR_HEADER = 0;
    public static final int RESIZE_FOR_CONTENT = 1;
    public static final int RESIZE_FOR_HEADER_AND_CONTENT = 2;
    public static final int VISIBLE_SHOW = 0;
    public static final int VISIBLE_HIDE = 1;
    public static final int VISIBLE_ALWAYS_SHOW = 2;
    public static final int VISIBLE_ALWAYS_HIDE = 3;
    public static final int VISIBLE_ALWAYS_SHOW_NOINDEX_CHANGE = 4;
    public static final int COL_RESIZE_OFF = 0;
    public static final int COL_RESIZE_ON_WHEN_TABLE_OFF = 1;
    public static final int COL_RESIZE_ON = 2;
    private static final int INVALID_INDEX = -1;
    private static final int DEFAULT_COLNAME_MAXLENGTH = 100;
    protected boolean hasResizeColWidth = false;
    protected static final int MIN_WIDTH = 15;
    private String type = "Table";
    private Dimension lastSizeDim = null;
    private Point lastLocDim = null;
    private static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/templates/basictable/Res");
    private int resizeSwitch = 1;
    private static final String COLUMN_NAME = "colName";
    private static final String COLUMN_WIDTH = "colWidth";
    private static final String COLUMN_STATE = "state";
    private static final String COLUMN_INDEX = "index";
    private static final String COLUMN_SORTED = "columnSorted";
    private static final String COLUMN_ISDESCENDING = "isdescending";
    private static final int MAX_ITEMS_COUNT = 10;
    private boolean customizable = true;
    private Hashtable colInfos = new Hashtable(20);
    private Vector keys = new Vector(20);
    private Hashtable columns = new Hashtable(20);
    private boolean colNameCustomizable = true;
    private boolean colWidthCustomizable = true;
    private boolean colIndexCustomizable = true;
    private boolean componentListenerAdded = false;
    private boolean customizeColIndexVisible = true;
    private boolean customizeColNameVisible = true;
    private boolean customizeColWidthVisible = true;
    private boolean hasSet = false;
    private boolean hasNotified = false;
    private boolean isInitState = true;
    private boolean autoPersistenceTable = true;
    private String tableName = null;
    private String persistenceDir = null;
    private int autoResizeColumnMode = 2;
    private int secondaryResizeColumnMode = 1;
    private int initialResizeColumnMode = -1;
    private Component owner = null;
    private int autoResizeCount = 0;
    private String bt_n = "BT_N";
    private String bt_r = "BT_R";
    private String bt_t = "BT_T";
    private int colNameMaxLength = 100;
    private boolean showTipWhenOmit = true;
    private final Object lock = new Object();
    private static final char[] oneChar = new char[1];
    private static final FontRenderContext DEFAULT_FRC = new FontRenderContext(null, false, false);
    private boolean stateChanged = false;
    private JList filterList = null;
    private JPanel multiValuePanel = null;
    private SelectList multiValueList = null;
    private JPopupMenu filterPopup = null;
    private boolean dataFilterEnabled = false;
    private Map<Integer, Integer> filterSelection = null;
    private static final int FILTER_SELECTION_CUSTOM = 1;
    private static final int FILTER_SELECTION_EQUAL = 2;
    private static final int FILTER_SELECTION_MULTIPLE = 3;
    private static final int MAXIMUM_COMBO_ITEMS = 8;
    private final int BUFFER_CAPACITY = 10;
    private final int ARRAYLIST_CAPACITY = 8;
    private String saveTablePath = null;
    private boolean hideRootPopUpOnFilter = false;
    private boolean addCustomOptEnum = false;

    public BasicTable() {
        this(null, null, null);
    }

    public BasicTable(TableModel tableModel) {
        this(tableModel, null, null);
    }

    public BasicTable(TableModel tableModel, TableColumnModel tableColumnModel) {
        this(tableModel, tableColumnModel, null);
    }

    public BasicTable(int n, int n2) {
        this(new DefaultTableModel(n, n2));
    }

    public BasicTable(Vector vector, Vector vector2) {
        this(new DefaultTableModel(vector, vector2));
    }

    public BasicTable(Object[][] objectArray, Object[] objectArray2) {
        super(objectArray, objectArray2);
        super.setName("BasicTable");
        this.addTableHeadListener();
        this.initColHashTable();
    }

    public BasicTable(TableModel tableModel, TableColumnModel tableColumnModel, ListSelectionModel listSelectionModel) {
        super(tableModel, tableColumnModel, listSelectionModel);
        super.setName("BasicTable");
        this.addTableHeadListener();
        this.initColHashTable();
    }

    @Override
    public void setModel(TableModel tableModel) {
        if (this.getModel() != tableModel) {
            super.setModel(tableModel);
            this.initColHashTable();
        }
    }

    public void updateColInfo() {
        int n = this.getColumnModel().getColumnCount();
        TableColumn tableColumn = null;
        ColumnInformation columnInformation = null;
        Hashtable<Object, ColumnInformation> hashtable = new Hashtable<Object, ColumnInformation>(20);
        ColumnInformation columnInformation2 = null;
        this.keys = new Vector(20);
        this.columns = new Hashtable(20);
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < n; ++i) {
            tableColumn = this.getColumnModel().getColumn(i);
            this.setColumnIdentifier(tableColumn);
            if (this.colInfos != null) {
                columnInformation2 = (ColumnInformation)this.colInfos.get(tableColumn.getIdentifier());
            }
            if (columnInformation2 != null) {
                n2 = columnInformation2.getState();
                bl = columnInformation2.isColumnSorted();
                bl2 = columnInformation2.isDescending();
            }
            columnInformation = new ColumnInformation(tableColumn.getIdentifier(), tableColumn.getHeaderValue().toString(), n2, tableColumn.getWidth(), i, bl, bl2);
            hashtable.put(tableColumn.getIdentifier(), columnInformation);
            this.columns.put(tableColumn.getIdentifier(), tableColumn);
            this.keys.add(tableColumn.getIdentifier());
        }
        this.colInfos = hashtable;
    }

    private void initColHashTable() {
        int n = this.getColumnModel().getColumnCount();
        TableColumn tableColumn = null;
        ColumnInformation columnInformation = null;
        this.colInfos = new Hashtable(20);
        this.keys = new Vector(20);
        this.columns = new Hashtable(20);
        for (int i = 0; i < n; ++i) {
            tableColumn = this.getColumnModel().getColumn(i);
            this.setColumnIdentifier(tableColumn);
            columnInformation = new ColumnInformation(tableColumn.getIdentifier(), tableColumn.getHeaderValue().toString(), 0, tableColumn.getWidth(), i);
            this.colInfos.put(tableColumn.getIdentifier(), columnInformation);
            this.columns.put(tableColumn.getIdentifier(), tableColumn);
            this.keys.add(tableColumn.getIdentifier());
        }
    }

    private void setColumnIdentifier(TableColumn tableColumn) {
        String string = tableColumn.getHeaderValue().toString();
        if (string.length() == 0) {
            string = " ";
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 1;
        while (this.keys.contains(stringBuffer.toString())) {
            stringBuffer.append(n);
            ++n;
        }
        tableColumn.setIdentifier(stringBuffer.toString());
    }

    protected TableColumn getTableColumn(Object object) {
        return (TableColumn)this.columns.get(object);
    }

    private ColumnInformation getColumnInformation(Object object) {
        return (ColumnInformation)this.colInfos.get(object);
    }

    protected Hashtable getColInfos() {
        return this.colInfos;
    }

    public Hashtable getConfigColInfos() {
        return this.getColInfos();
    }

    public Vector getKeys() {
        return this.keys;
    }

    public Hashtable getColumns() {
        return this.columns;
    }

    @Override
    public String getColumnName(int n) {
        Object object = this.getColumnModel().getColumn(n).getIdentifier();
        return this.getColumnInformation(object).getColName();
    }

    protected void updateTable(ColumnInformation[] columnInformationArray) {
        if (columnInformationArray == null) {
            return;
        }
        TableColumn tableColumn = null;
        int n = columnInformationArray.length;
        for (int i = 0; i < n; ++i) {
            this.colInfos.put(columnInformationArray[i].getIdentifier(), columnInformationArray[i]);
            tableColumn = this.getTableColumn(columnInformationArray[i].getIdentifier());
            if (columnInformationArray[i].getColWidth() >= tableColumn.getMinWidth() && columnInformationArray[i].getColWidth() <= tableColumn.getMaxWidth()) {
                tableColumn.setPreferredWidth(columnInformationArray[i].getColWidth());
            }
            tableColumn.setHeaderValue(columnInformationArray[i].getColName().length() > 0 ? columnInformationArray[i].getColName() : " ");
        }
        Arrays.sort(columnInformationArray);
        TableColumnModel tableColumnModel = this.getColumnModel();
        while (0 != tableColumnModel.getColumnCount()) {
            TableColumn tableColumn2 = tableColumnModel.getColumn(0);
            tableColumnModel.removeColumn(tableColumn2);
        }
        for (n = 0; n < columnInformationArray.length; ++n) {
            if (columnInformationArray[n].getState() == 3 || columnInformationArray[n].getState() == 1) continue;
            tableColumnModel.addColumn(this.getTableColumn(columnInformationArray[n].getIdentifier()));
            this.getModel().getColumnName(n);
        }
        this.revalidate();
        this.repaint();
    }

    public void setColAutoResizeMode(int n) {
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException("mode only can be one of the 'RESIZE_FOR_HEADER' ,'RESIZE_FOR_CONTENT' or 'RESIZE_FOR_HEADER_AND_CONTENT'");
        }
        if (this.initialResizeColumnMode != -1) {
            this.secondaryResizeColumnMode = n;
        } else {
            this.autoResizeColumnMode = n;
        }
    }

    public int getColAutoResizeMode() {
        return this.autoResizeColumnMode;
    }

    public void setColAutoResizeSwitch(int n) {
        if (n < 0 || n > 2) {
            return;
        }
        this.resizeSwitch = n;
    }

    public int getColAutoResizeSwitch() {
        return this.resizeSwitch;
    }

    public void setCustomizable(boolean bl) {
        this.customizable = bl;
    }

    public boolean isCustomizable() {
        return this.customizable;
    }

    public void setDefaultOrderOfColumn(CommStyleInfo commStyleInfo) {
        if (null == commStyleInfo) {
            logger.debug("CommonStyleInfo is null; cannot set the defeault order");
            return;
        }
        String string = commStyleInfo.getFileName();
        if (0 <= string.lastIndexOf("/")) {
            string = string.substring(string.lastIndexOf("/") + 1);
        }
        if (0 <= string.lastIndexOf("\\")) {
            string = string.substring(string.lastIndexOf("\\") + 1);
        }
        string = string.substring(0, string.lastIndexOf("."));
        try {
            this.readAreaDesc(commStyleInfo.getAreaDescContainer(0));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            logger.trace(indexOutOfBoundsException.getMessage(), indexOutOfBoundsException);
            return;
        }
    }

    private void readAreaDesc(AreaDescContainer areaDescContainer) {
        if (null == areaDescContainer) {
            return;
        }
        this.parseAreaName(areaDescContainer.getAreaName());
        int n = areaDescContainer.getDescContainerCount();
        ColumnInformation[] columnInformationArray = new ColumnInformation[n];
        DescContainer descContainer = null;
        for (int i = 0; i < n; ++i) {
            descContainer = areaDescContainer.getDescContainer(i);
            if (null == descContainer) {
                logger.trace("AreaDesc is null");
                continue;
            }
            columnInformationArray[i] = new ColumnInformation(this.resumeAll_n_r_t(descContainer.getDescName()), this.resumeAll_n_r_t(descContainer.getParasItemValue(COLUMN_NAME)), 0, 0, Integer.parseInt(descContainer.getParasItemValue(COLUMN_INDEX)));
        }
        this.updateTable(this.getAllColumns(columnInformationArray));
        this.hasResizeColWidth = true;
    }

    private ColumnInformation[] getAllColumns(ColumnInformation[] columnInformationArray) {
        int n;
        ColumnInformation[] columnInformationArray2 = new ColumnInformation[this.keys.size()];
        System.arraycopy(columnInformationArray, 0, columnInformationArray2, 0, columnInformationArray.length);
        ArrayList<Object> arrayList = new ArrayList<Object>(10);
        for (n = 0; n < columnInformationArray.length; ++n) {
            arrayList.add(columnInformationArray[n].getIdentifier());
        }
        n = columnInformationArray.length;
        for (int i = 0; i < this.keys.size(); ++i) {
            if (arrayList.contains(this.keys.get(i))) continue;
            ColumnInformation columnInformation = this.getColumnInformation(this.keys.get(i));
            columnInformationArray2[n] = new ColumnInformation(this.keys.get(i), columnInformation.getColName(), columnInformation.getState(), columnInformation.getColWidth(), n);
            ++n;
        }
        return columnInformationArray2;
    }

    public void setPersistenceName(String string, String string2) {
        if (string == null || string.trim().length() == 0 || string2 == null || string2.trim().length() == 0) {
            throw new IllegalArgumentException("tableName and fileName can not be null, and the length of the tableName or fileName can not be zero.");
        }
        Locale locale = Locale.getDefault();
        StringBuffer stringBuffer = new StringBuffer(10);
        stringBuffer.append("locale/");
        stringBuffer.append(locale.getLanguage());
        stringBuffer.append("_");
        stringBuffer.append(locale.getCountry());
        stringBuffer.append('/');
        stringBuffer.append(string2);
        this.persistenceDir = string2 = stringBuffer.toString();
        this.tableName = string;
        if (this.customizable) {
            this.updateFromPersistenceFile();
        }
        this.addColumnStateChangeListeners();
    }

    public boolean isPersistenceEnabled() {
        return this.persistenceDir != null;
    }

    public void setCustomizeDlgOwner(Component component) {
        if (!(component instanceof Frame) && !(component instanceof Dialog)) {
            throw new IllegalArgumentException("owner must be Frame type or Dialog type.");
        }
        this.owner = component;
    }

    public void persistenceTable(ColumnInformation[] columnInformationArray) {
        if (columnInformationArray == null) {
            columnInformationArray = this.getColumnsInfo();
        }
        this.writeBackToFile(columnInformationArray);
    }

    public void setAutoPersistenceTable(boolean bl) {
        this.autoPersistenceTable = bl;
    }

    public boolean isAutoPersistenceTable() {
        return this.autoPersistenceTable;
    }

    private ColumnInformation[] getColumnsInfo() {
        this.updateIndex();
        TableColumnModel tableColumnModel = this.getColumnModel();
        int n = tableColumnModel.getColumnCount();
        ColumnInformation columnInformation = null;
        TableColumn tableColumn = null;
        for (int i = 0; i < n; ++i) {
            tableColumn = tableColumnModel.getColumn(i);
            columnInformation = (ColumnInformation)this.colInfos.get(tableColumn.getIdentifier().toString());
            columnInformation.setColWidth(tableColumn.getWidth());
        }
        ColumnInformation[] columnInformationArray = new ColumnInformation[this.colInfos.size()];
        this.colInfos.values().toArray(columnInformationArray);
        return columnInformationArray;
    }

    private void updateIndex() {
        int n;
        TableColumnModel tableColumnModel = this.getColumnModel();
        int n2 = tableColumnModel.getColumnCount();
        int[] nArray = new int[n2];
        for (n = 0; n < n2; ++n) {
            nArray[n] = ((ColumnInformation)this.colInfos.get(tableColumnModel.getColumn(n).getIdentifier())).getIndex();
        }
        Arrays.sort(nArray);
        for (n = 0; n < n2; ++n) {
            ((ColumnInformation)this.colInfos.get(tableColumnModel.getColumn(n).getIdentifier())).setIndex(nArray[n]);
        }
    }

    private void updateFromPersistenceFile() {
        Object object;
        CommStyleInfo commStyleInfo = null;
        try {
            object = CommStyleManager.getInstance();
            commStyleInfo = ((CommStyleManager)object).getUserCommonStyleFileAtClient(this.persistenceDir);
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
            return;
        }
        if (commStyleInfo != null) {
            object = null;
            try {
                object = commStyleInfo.getAreaDescContainer(0);
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
            }
            if (object != null) {
                this.parseAreaName(((AreaDescContainer)object).getAreaName());
                int n = ((AreaDescContainer)object).getDescContainerCount();
                ColumnInformation[] columnInformationArray = new ColumnInformation[n];
                for (int i = 0; i < n; ++i) {
                    DescContainer descContainer = ((AreaDescContainer)object).getDescContainer(i);
                    if (descContainer == null) continue;
                    String string = descContainer.getParasItemValue(COLUMN_NAME);
                    if (null == string) {
                        string = "";
                    }
                    columnInformationArray[i] = new ColumnInformation(this.resumeAll_n_r_t(descContainer.getDescName()), this.resumeAll_n_r_t(string), Integer.parseInt(descContainer.getParasItemValue(COLUMN_STATE)), Integer.parseInt(descContainer.getParasItemValue(COLUMN_WIDTH)), Integer.parseInt(descContainer.getParasItemValue(COLUMN_INDEX)));
                }
                if (this.isValid(columnInformationArray)) {
                    this.updateTable(columnInformationArray);
                    this.hasResizeColWidth = true;
                }
            }
        } else {
            logger.trace("In BasicTable-Cannot read style-info from " + this.persistenceDir);
        }
    }

    private void parseAreaName(String string) {
        if (string == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string.substring(string.lastIndexOf("(")), "()/");
        this.bt_n = stringTokenizer.nextToken();
        this.bt_r = stringTokenizer.nextToken();
        this.bt_t = stringTokenizer.nextToken();
    }

    private String resumeAll_n_r_t(String string) {
        string = string.replaceAll(this.bt_t, "\t");
        string = string.replaceAll(this.bt_r, "\r");
        string = string.replaceAll(this.bt_n, "\n");
        return string;
    }

    private boolean isValid(ColumnInformation[] columnInformationArray) {
        if (columnInformationArray == null || columnInformationArray.length != this.keys.size()) {
            return false;
        }
        for (int i = 0; i < columnInformationArray.length; ++i) {
            if (this.keys.contains(columnInformationArray[i].getIdentifier())) continue;
            return false;
        }
        return true;
    }

    private void writeBackToFile(ColumnInformation[] columnInformationArray) {
        CommStyleInfo commStyleInfo = null;
        if (null == columnInformationArray) {
            return;
        }
        AreaDescContainer areaDescContainer = this.writeTableInfo(this.tableName, columnInformationArray);
        DescContainer descContainer = null;
        for (int i = 0; i < columnInformationArray.length; ++i) {
            descContainer = new DescContainer(this.replaceAll_n_r_t(columnInformationArray[i].getIdentifier().toString()));
            descContainer.setParasItem(COLUMN_NAME, this.replaceAll_n_r_t(columnInformationArray[i].getColName()), true);
            descContainer.setParasItem(COLUMN_STATE, Integer.toString(columnInformationArray[i].getState()), true);
            descContainer.setParasItem(COLUMN_WIDTH, Integer.toString(columnInformationArray[i].getColWidth()), true);
            descContainer.setParasItem(COLUMN_INDEX, Integer.toString(columnInformationArray[i].getIndex()), true);
            areaDescContainer.setDescContainer(descContainer, true);
        }
        commStyleInfo = new CommStyleInfo();
        commStyleInfo.setAreaDescContainer(areaDescContainer, true);
        CommStyleManager commStyleManager = CommStyleManager.getInstance();
        commStyleInfo.setFileName(commStyleManager.getUserDir() + this.persistenceDir + ".xml");
        commStyleManager.writeToUserAtClient(commStyleInfo);
    }

    private String getReplacement(ColumnInformation[] columnInformationArray, String string) {
        if ("\n".equals(string)) {
            string = "BT_N";
        } else if ("\r".equals(string)) {
            string = "BT_R";
        } else if ("\t".equals(string)) {
            string = "BT_T";
        } else {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        boolean bl = false;
        while (!bl) {
            for (int i = 0; i < columnInformationArray.length; ++i) {
                if (columnInformationArray[i].getIdentifier().toString().indexOf(stringBuffer.toString()) != -1 || columnInformationArray[i].getColName().indexOf(stringBuffer.toString()) != -1) {
                    bl = false;
                    break;
                }
                bl = true;
            }
            if (bl) continue;
            stringBuffer.append(n);
            ++n;
        }
        return stringBuffer.toString();
    }

    private String replaceAll_n_r_t(String string) {
        string = string.replaceAll("\n", this.bt_n);
        string = string.replaceAll("\r", this.bt_r);
        string = string.replaceAll("\t", this.bt_t);
        return string;
    }

    private void addTableHeadListener() {
        this.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(final MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent) && BasicTable.this.customizable) {
                    JPopupMenu jPopupMenu = BasicTable.this.getPopupMenu();
                    try {
                        ScreenToolKit.showPopupMenu(jPopupMenu, mouseEvent);
                    }
                    catch (Exception exception) {
                        jPopupMenu.setVisible(false);
                        jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    }
                } else if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                    if (BasicTable.this.initialResizeColumnMode != -1) {
                        BasicTable.this.autoResizeColumnMode = BasicTable.this.secondaryResizeColumnMode;
                    }
                    if (BasicTable.this.getColAutoResizeSwitch() == 0 || BasicTable.this.getColAutoResizeSwitch() == 1 && BasicTable.this.getAutoResizeMode() != 0) {
                        return;
                    }
                    final JTableHeader jTableHeader = BasicTable.this.getTableHeader();
                    TableColumn tableColumn = BasicTable.this.getResizingColumn(mouseEvent);
                    if (tableColumn == null || !jTableHeader.getResizingAllowed() || !tableColumn.getResizable()) {
                        return;
                    }
                    int n = BasicTable.this.getPerferredWidthForColumn(tableColumn);
                    tableColumn.setPreferredWidth(n);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MouseMotionListener[] mouseMotionListenerArray = jTableHeader.getMouseMotionListeners();
                            if (mouseMotionListenerArray != null) {
                                int n = mouseMotionListenerArray.length;
                                for (int i = 0; i < n; ++i) {
                                    mouseMotionListenerArray[i].mouseMoved(mouseEvent);
                                }
                            }
                        }
                    });
                }
            }
        });
    }

    public void setInitialResizeColumnMode(int n) {
        if (n == 0 || n == 1 || n == 2) {
            this.autoResizeColumnMode = n;
            this.initialResizeColumnMode = n;
            int n2 = this.getColumnModel().getColumnCount();
            TableColumn tableColumn = null;
            int n3 = n2;
            for (int i = 0; i < n3; ++i) {
                tableColumn = this.columnModel.getColumn(i);
                int n4 = this.getPerferredWidthForColumn(tableColumn);
                tableColumn.setPreferredWidth(n4);
            }
        } else {
            logger.debug("Invalid mode ColumnResizeMode shoule be RESIZE_FOR_HEADER or RESIZE_FOR_CONTENT or RESIZE_FOR_HEADER_AND_CONTENT");
        }
    }

    private void addColumnStateChangeListeners() {
        TableColumnModelListener tableColumnModelListener = new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent changeEvent) {
                BasicTable.this.stateChanged = true;
            }

            @Override
            public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
                BasicTable.this.stateChanged = true;
            }

            @Override
            public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
            }
        };
        TableColumnModel tableColumnModel = this.getColumnModel();
        tableColumnModel.addColumnModelListener(tableColumnModelListener);
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                if (BasicTable.this.stateChanged) {
                    BasicTable.this.saveStateInformation();
                    BasicTable.this.stateChanged = false;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveStateInformation() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isPersistenceEnabled() && this.isAutoPersistenceTable()) {
                TableColumn tableColumn = null;
                this.updateIndex();
                Hashtable hashtable = this.getConfigColInfos();
                int n = this.keys.size();
                for (int i = 0; i < n; ++i) {
                    ColumnInformation columnInformation = (ColumnInformation)hashtable.get(this.keys.get(i));
                    tableColumn = (TableColumn)this.columns.get(columnInformation.getIdentifier());
                    if (columnInformation.getState() == 1) continue;
                    columnInformation.setColWidth(tableColumn.getWidth());
                }
                ColumnInformation[] columnInformationArray = new ColumnInformation[this.keys.size()];
                for (n = 0; n < this.keys.size(); ++n) {
                    columnInformationArray[n] = (ColumnInformation)hashtable.get(this.keys.get(n));
                }
                this.persistenceTable(columnInformationArray);
            }
        }
    }

    public JPopupMenu getPopupMenu() {
        this.updateIndex();
        JPopupMenu jPopupMenu = new JPopupMenu();
        JCheckBoxMenuItem jCheckBoxMenuItem = null;
        TableColumn tableColumn = null;
        boolean bl = this.getColumnRealCount() == 1;
        int n = 0;
        Hashtable hashtable = this.getConfigColInfos();
        int n2 = this.keys.size();
        for (int i = 0; i < n2; ++i) {
            final ColumnInformation columnInformation = (ColumnInformation)hashtable.get(this.keys.get(i));
            tableColumn = (TableColumn)this.columns.get(columnInformation.getIdentifier());
            if (columnInformation.getState() == 3) continue;
            if (columnInformation.getState() != 1) {
                columnInformation.setColWidth(tableColumn.getWidth());
            }
            if (n >= 10) continue;
            String string = columnInformation.getColName().length() > 0 ? columnInformation.getColName() : " ";
            String string2 = ScreenToolKit.getAbbreviatoryString(string, 150, jPopupMenu.getFont());
            jCheckBoxMenuItem = new JCheckBoxMenuItem(string2){

                @Override
                public JToolTip createToolTip() {
                    MultiRowToolTip multiRowToolTip = new MultiRowToolTip();
                    multiRowToolTip.setComponent(this);
                    return multiRowToolTip;
                }
            };
            jCheckBoxMenuItem.setToolTipText(ResourceUtil.areEquals(string, string2) ? null : string);
            if (columnInformation.getState() != 1) {
                jCheckBoxMenuItem.setSelected(true);
            }
            if (columnInformation.getState() == 2 || columnInformation.getState() == 0 && bl || columnInformation.getState() == 4) {
                jCheckBoxMenuItem.setEnabled(false);
            }
            jCheckBoxMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    BasicTable.this.columnItemAction(columnInformation);
                }
            });
            jPopupMenu.add(jCheckBoxMenuItem);
            ++n;
        }
        jPopupMenu.addSeparator();
        JMenuItem jMenuItem = new JMenuItem(res.getString("more"));
        jMenuItem.setToolTipText(null);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BasicTable.this.otherItemAction();
            }
        });
        jPopupMenu.add(jMenuItem);
        return jPopupMenu;
    }

    protected void columnItemAction(ColumnInformation columnInformation) {
        if (columnInformation.getState() == 0 || columnInformation.getState() == 1) {
            if (columnInformation.getState() == 0) {
                this.setColumnVisible(columnInformation.getIdentifier(), 1);
            } else {
                this.setColumnVisible(columnInformation.getIdentifier(), 0);
            }
            if (this.isPersistenceEnabled() && this.isAutoPersistenceTable()) {
                new Thread(){

                    @Override
                    public void run() {
                        ColumnInformation[] columnInformationArray = new ColumnInformation[BasicTable.this.colInfos.size()];
                        BasicTable.this.colInfos.values().toArray(columnInformationArray);
                        BasicTable.this.persistenceTable(columnInformationArray);
                    }
                }.start();
            }
        }
    }

    private void otherItemAction() {
        Hashtable hashtable = this.getConfigColInfos();
        ColumnInformation[] columnInformationArray = new ColumnInformation[hashtable.size()];
        hashtable.values().toArray(columnInformationArray);
        CustomizeDlg customizeDlg = null;
        customizeDlg = this.owner != null ? (this.owner instanceof Frame ? new CustomizeDlg((Frame)this.owner, res.getString("customize"), true, columnInformationArray, this) : new CustomizeDlg((Dialog)this.owner, res.getString("customize"), true, columnInformationArray, this)) : new CustomizeDlg(FrameworkUtilities.getMainFrame(), res.getString("customize"), true, columnInformationArray, this);
        customizeDlg.setColNameCustomizable(this.colNameCustomizable);
        if (this.getAutoResizeMode() != 0 || !this.colWidthCustomizable) {
            this.colWidthCustomizable = false;
            logger.debug("table's getAutoResizeMode is not AUTO_RESIZE_OFF.");
        } else {
            this.colWidthCustomizable = true;
        }
        customizeDlg.setColWidthCustomizable(this.colWidthCustomizable);
        if (this.hasSet) {
            customizeDlg.setColIndexCustomizable(this.colIndexCustomizable);
        } else {
            customizeDlg.setColIndexCustomizable(this.getTableHeader().getReorderingAllowed());
        }
        customizeDlg.setColNameVisible(this.customizeColNameVisible);
        customizeDlg.setColWidthVisible(this.customizeColWidthVisible);
        customizeDlg.setColIndexVisible(this.customizeColIndexVisible);
        customizeDlg.setColNameMaxLength(this.colNameMaxLength);
        ScreenToolKit.centerLocateToScreen(customizeDlg);
        customizeDlg.setVisible(true);
    }

    public void setColumnVisible(Object object, int n) {
        if (object == null || n != 3 && n != 2 && n != 1 && n != 0 && n != 4) {
            throw new IllegalArgumentException("identifier can not be null and state must be one of 'VISIBLE_ALWAYS_HIDE','VISIBLE_ALWAYS_SHOW','VISIBLE_HIDE' or 'VISIBLE_SHOW' or 'VISIBLE_ALWAYS_SHOW_NOINDEX_CHANGE'.");
        }
        ColumnInformation columnInformation = this.getColumnInformation(object);
        if (columnInformation == null) {
            logger.debug("identifier is error.");
            return;
        }
        if (columnInformation.getState() == n) {
            return;
        }
        if (!this.isFurtherProcessRequired(columnInformation.getState(), n)) {
            columnInformation.setState(n);
            return;
        }
        columnInformation.setState(n);
        TableColumnModel tableColumnModel = this.getColumnModel();
        TableColumn tableColumn = this.getTableColumn(object);
        if (n == 1 || n == 3) {
            tableColumnModel.removeColumn(tableColumn);
        } else {
            int n2 = this.getColumnCount();
            Object object2 = null;
            ColumnInformation columnInformation2 = null;
            for (int i = 0; i < n2; ++i) {
                object2 = tableColumnModel.getColumn(i).getIdentifier();
                columnInformation2 = this.getColumnInformation(object2);
                if (columnInformation2.getIndex() <= columnInformation.getIndex()) continue;
                tableColumnModel.addColumn(tableColumn);
                tableColumnModel.moveColumn(tableColumnModel.getColumnCount() - 1, i);
                return;
            }
            tableColumnModel.addColumn(tableColumn);
        }
    }

    private boolean isFurtherProcessRequired(int n, int n2) {
        if (n == 2 && n2 == 0) {
            return false;
        }
        if (n == 0 && n2 == 2) {
            return false;
        }
        if (n == 1 && n2 == 3) {
            return false;
        }
        if (n == 3 && n2 == 1) {
            return false;
        }
        return n != 2 && n != 0 || n2 != 4;
    }

    public void setColumnVisible(Object[] objectArray, int n) {
        if (objectArray == null) {
            throw new IllegalArgumentException("identifiers can not be null.");
        }
        int n2 = objectArray.length;
        for (int i = 0; i < n2; ++i) {
            this.setColumnVisible(objectArray[i], n);
        }
    }

    public void setColNameCustomizable(boolean bl) {
        this.colNameCustomizable = bl;
    }

    public void setColWidthCustomizable(boolean bl) {
        this.colWidthCustomizable = bl;
    }

    public void setColIndexCustomizable(boolean bl) {
        this.hasSet = true;
        this.colIndexCustomizable = bl;
    }

    public void setCustomizeDlgColNameVisible(boolean bl) {
        this.customizeColNameVisible = bl;
    }

    public void setCustomizeDlgColWidthVisible(boolean bl) {
        this.customizeColWidthVisible = bl;
    }

    public void setCustomizeDlgColIndexVisible(boolean bl) {
        this.customizeColIndexVisible = bl;
    }

    public void setColNameMaxLength(int n) {
        this.colNameMaxLength = n;
    }

    public int getPerferredWidthForColumn(TableColumn tableColumn) {
        switch (this.getColAutoResizeMode()) {
            case 0: {
                return this.getPreferredWidthForHeader(tableColumn);
            }
            case 1: {
                return this.getPreferredWidthForContent(tableColumn);
            }
        }
        return this.getPreferredWidthForHeaderAndContent(tableColumn);
    }

    private int getPreferredWidthForHeader(TableColumn tableColumn) {
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer == null) {
            tableCellRenderer = this.getTableHeader().getDefaultRenderer();
        }
        Object object = tableColumn.getHeaderValue();
        Component component = tableCellRenderer.getTableCellRendererComponent(this, object, false, false, 0, this.convertColumnIndexToView(tableColumn.getModelIndex()));
        return component.getPreferredSize().width + 15;
    }

    protected int getPreferredWidthForContent(TableColumn tableColumn) {
        int n = 0;
        int n2 = this.convertColumnIndexToView(tableColumn.getModelIndex());
        TableCellRenderer tableCellRenderer = null;
        Object object = null;
        Component component = null;
        int n3 = this.getRowCount();
        for (int i = 0; i < n3; ++i) {
            tableCellRenderer = this.getCellRenderer(i, n2);
            object = this.getValueAt(i, n2);
            component = tableCellRenderer.getTableCellRendererComponent(this, object, false, false, i, n2);
            n = Math.max(component.getPreferredSize().width, n);
        }
        return n + 15;
    }

    private int getPreferredWidthForHeaderAndContent(TableColumn tableColumn) {
        return Math.max(this.getPreferredWidthForHeader(tableColumn), this.getPreferredWidthForContent(tableColumn));
    }

    protected TableColumn getResizingColumn(MouseEvent mouseEvent) {
        if (mouseEvent == null) {
            throw new IllegalArgumentException("e is null.");
        }
        Point point = mouseEvent.getPoint();
        int n = this.getTableHeader().columnAtPoint(point);
        if (n == -1) {
            return null;
        }
        JTableHeader jTableHeader = this.getTableHeader();
        Rectangle rectangle = jTableHeader.getHeaderRect(n);
        rectangle.grow(-3, 0);
        if (rectangle.contains(point)) {
            return null;
        }
        int n2 = rectangle.x + rectangle.width / 2;
        int n3 = 0;
        if (jTableHeader.getComponentOrientation().isLeftToRight()) {
            n3 = point.x < n2 ? n - 1 : n;
        } else {
            int n4 = n3 = point.x < n2 ? n : n - 1;
        }
        if (n3 == -1) {
            return null;
        }
        return jTableHeader.getColumnModel().getColumn(n3);
    }

    public void setTableWidthToPreferredSize() {
        int n;
        if (!(this.getParent() instanceof JViewport)) {
            return;
        }
        int n2 = this.getColumnModel().getColumnCount();
        if (n2 == 0) {
            return;
        }
        int n3 = ((JViewport)this.getParent()).getExtentSize().width;
        int n4 = this.getWidth();
        if (n4 > (n = this.getPreferredTableWidth()) && n4 > n3) {
            return;
        }
        int n5 = (n3 - n) / n2;
        int n6 = (n3 - n) % n2;
        if (n > n3) {
            if (this.getAutoResizeMode() != 0) {
                return;
            }
            n5 = 0;
            n6 = 0;
        }
        this.setColWidthToPreferredSize(n5, n6);
        Dimension dimension = this.getSize();
        dimension.width = Math.max(n, n3);
        this.setSize(dimension);
        this.getParent().validate();
        this.repaint();
        this.getTableHeader().repaint();
    }

    protected void setColWidthToPreferredSize(int n, int n2) {
        int n3 = this.getColumnModel().getColumnCount();
        for (int i = 0; i < n3; ++i) {
            TableColumn tableColumn = this.columnModel.getColumn(i);
            int n4 = this.getPerferredWidthForColumn(tableColumn) + n;
            if (i == n3 - 1) {
                n4 += n2;
            }
            tableColumn.setWidth(n4);
            tableColumn.setPreferredWidth(n4);
        }
    }

    private int getPreferredTableWidth() {
        int n = 0;
        int n2 = this.getColumnModel().getColumnCount();
        TableColumn tableColumn = null;
        int n3 = n2;
        for (int i = 0; i < n3; ++i) {
            tableColumn = this.columnModel.getColumn(i);
            n += this.getPerferredWidthForColumn(tableColumn);
        }
        return n;
    }

    protected int getColumnRealCount() {
        return this.getColumnModel().getColumnCount();
    }

    public void setTableWidthAutoResizeCount(int n) {
        this.autoResizeCount = n;
    }

    private void initComponentListener() {
        if (!this.componentListenerAdded) {
            this.componentListenerAdded = true;
            final ComponentAdapter componentAdapter = new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    if (BasicTable.this.autoResizeCount == -1 || BasicTable.this.autoResizeCount > 0) {
                        if (!BasicTable.this.hasResizeColWidth) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    BasicTable.this.setTableWidthToPreferredSize();
                                }
                            });
                        }
                        if (BasicTable.this.hasNotified && BasicTable.this.autoResizeCount > 0) {
                            BasicTable.this.autoResizeCount -= 1;
                        }
                    }
                }
            };
            this.getParent().addComponentListener(componentAdapter);
            ContainerAdapter containerAdapter = new ContainerAdapter(){

                @Override
                public void componentRemoved(ContainerEvent containerEvent) {
                    containerEvent.getContainer().removeComponentListener(componentAdapter);
                    containerEvent.getContainer().removeContainerListener(this);
                }
            };
            this.getParent().addContainerListener(containerAdapter);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.getParent() instanceof JViewport && !this.hasResizeColWidth && (this.autoResizeCount == -1 || this.autoResizeCount > 0)) {
            this.hasNotified = true;
            this.sizeColumnsToFit(-1);
        }
    }

    @Override
    public void sizeColumnsToFit(int n) {
        Container container = this.getParent();
        if (container != null) {
            this.initComponentListener();
        }
        if (container instanceof JViewport) {
            int n2 = ((JViewport)this.getParent()).getExtentSize().width;
            if (n == -1 && n2 > 0 && this.isInitState) {
                this.isInitState = false;
                this.setTableWidthToPreferredSize();
                if (this.autoResizeCount > 0) {
                    --this.autoResizeCount;
                }
                return;
            }
        }
        super.sizeColumnsToFit(n);
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        super.tableChanged(tableModelEvent);
        if (tableModelEvent.getFirstRow() == -1) {
            this.initColHashTable();
            if (this.autoResizeCount == -1 || this.autoResizeCount > 0) {
                this.isInitState = true;
                this.sizeColumnsToFit(-1);
            }
        }
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        String string = null;
        if (this.showTipWhenOmit) {
            JLabel jLabel;
            TableCellRenderer tableCellRenderer;
            Component component;
            int n = this.rowAtPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
            int n2 = this.columnAtPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
            if (n2 != -1 && n != -1 && (component = (tableCellRenderer = this.getCellRenderer(n, n2)).getTableCellRendererComponent(this, this.getValueAt(n, n2), this.isCellSelected(n, n2), false, n, n2)) instanceof JLabel && this.needTooltip(jLabel = (JLabel)component, this.getColumnModel().getColumn(n2).getWidth() - 1)) {
                string = jLabel.getText();
            }
        }
        if (string == null) {
            string = super.getToolTipText(mouseEvent);
        }
        return string;
    }

    @Override
    public Point getToolTipLocation(MouseEvent mouseEvent) {
        if (null == this.getToolTipText(mouseEvent)) {
            return null;
        }
        Point point = new Point();
        point.x = mouseEvent.getPoint().x + 20;
        point.y = mouseEvent.getPoint().y + 10;
        return point;
    }

    public void setShowTipWhenOmit(boolean bl) {
        this.showTipWhenOmit = bl;
    }

    private boolean needTooltip(JLabel jLabel, int n) {
        int n2;
        int n3;
        Icon icon;
        String string = jLabel.getText();
        Icon icon2 = icon = jLabel.isEnabled() ? jLabel.getIcon() : jLabel.getDisabledIcon();
        if (icon == null && string == null) {
            return false;
        }
        FontMetrics fontMetrics = jLabel.getFontMetrics(jLabel.getFont());
        Insets insets = jLabel.getInsets(new Insets(0, 0, 0, 0));
        int n4 = n - (insets.left + insets.right);
        int n5 = 0;
        int n6 = 0;
        boolean bl = true;
        if (!jLabel.getComponentOrientation().isLeftToRight()) {
            bl = false;
        }
        int n7 = jLabel.getHorizontalTextPosition();
        switch (n7) {
            case 10: {
                n7 = bl ? 2 : 4;
                break;
            }
            case 11: {
                n7 = bl ? 4 : 2;
            }
        }
        n5 = icon != null ? icon.getIconWidth() : 0;
        boolean bl2 = string == null || string.length() == 0;
        int n8 = 0;
        View view = null;
        if (bl2) {
            n6 = 0;
            string = "";
        } else {
            view = (View)jLabel.getClientProperty("html");
            if (view != null) {
                n6 = (int)view.getPreferredSpan(0);
            } else {
                n6 = SwingUtilities.computeStringWidth(fontMetrics, string);
                n8 = BasicTable.getLeftSideBearing(this, fontMetrics, string.charAt(0));
                if (n8 < 0) {
                    n6 -= n8;
                }
            }
        }
        int n9 = n3 = bl2 || icon == null ? 0 : jLabel.getIconTextGap();
        return false == bl2 && n6 > (n2 = n7 == 0 ? n4 : n4 - (n5 + n3));
    }

    private static int getLeftSideBearing(JComponent jComponent, FontMetrics fontMetrics, char c) {
        if ('W' == c) {
            BasicTable.oneChar[0] = c;
            GlyphVector glyphVector = fontMetrics.getFont().createGlyphVector(DEFAULT_FRC, oneChar);
            Rectangle rectangle = glyphVector.getGlyphPixelBounds(0, DEFAULT_FRC, 0.0f, 0.0f);
            return rectangle.x;
        }
        return 0;
    }

    @Override
    public int getSelectedRow() {
        return this.getRowCount() == 0 ? -1 : super.getSelectedRow();
    }

    public final boolean handleHeaderMouseClick(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent) && this.getResizingColumn(mouseEvent) == null) {
            boolean bl;
            int n = this.getTableHeader().columnAtPoint(mouseEvent.getPoint());
            int n2 = this.getTotalColWidth(n);
            boolean bl2 = bl = n2 - 15 <= mouseEvent.getPoint().x && mouseEvent.getPoint().x < n2;
            if (bl && this.isDataFilterEnabled() && this.isColumnFiltarable(n)) {
                boolean bl3 = this.initFilterList(mouseEvent);
                JScrollPane jScrollPane = new JScrollPane(this.filterList);
                jScrollPane.setBorder(null);
                this.setWidthHeightForFilterList(n, 15);
                this.filterPopup = new JPopupMenu();
                this.filterPopup.add(jScrollPane);
                if (bl3) {
                    this.filterPopup.addSeparator();
                    this.filterPopup.add(this.multiValuePanel);
                    this.filterPopup.setBackground(this.filterList.getBackground());
                }
                JTableHeader jTableHeader = this.getTableHeader();
                int n3 = this.getColumnWidth(n);
                n3 = Math.max(n3, 15);
                this.filterPopup.show(jTableHeader, n2 - n3 - 1, jTableHeader.getBounds().y + jTableHeader.getBounds().height);
                return true;
            }
            return false;
        }
        return false;
    }

    private void setWidthHeightForFilterList(int n, int n2) {
        int n3 = this.getColumnWidth(n);
        n3 = Math.max(n3, n2);
        int n4 = 1;
        Rectangle rectangle = this.filterList.getCellBounds(0, 0);
        if (rectangle != null) {
            n4 = rectangle.height;
        }
        int n5 = n3 - 1;
        if (this.filterList.getModel().getSize() > 8) {
            n5 -= n2;
        }
        int n6 = 75;
        this.filterList.setFixedCellWidth(Math.max(n5, n6));
        this.filterList.setFixedCellHeight(n4);
        this.filterList.setVisibleRowCount(Math.min(8, this.filterList.getModel().getSize()));
    }

    private boolean initFilterList(MouseEvent mouseEvent) {
        boolean bl;
        this.initList();
        Vector<Object> vector = new Vector<Object>(2);
        vector.add(res.getString("All_Filter"));
        int n = this.getTableHeader().columnAtPoint(mouseEvent.getPoint());
        int n2 = this.convertColumnIndexToModel(n);
        if (n2 < 0) {
            logger.trace("Error:PagedTable columnSelected index < 0" + String.valueOf(n));
            return false;
        }
        TableModel tableModel = this.getModel();
        if (tableModel.getColumnClass(n) != Enum.class || this.addCustomOptEnum) {
            vector.add(res.getString("Custom_Filter"));
        }
        if (!(tableModel instanceof Filterable)) {
            return false;
        }
        Filterable filterable = (Filterable)((Object)tableModel);
        DefaultFilterElement defaultFilterElement = (DefaultFilterElement)filterable.getFilter();
        Collection<Object> collection = filterable.getFilterColumnValues(n2);
        boolean bl2 = bl = this.isMultiValueSelectionEnabled(n) && null != collection && !collection.isEmpty();
        if (bl) {
            this.initMultiSelectionListPanel(collection, n2, defaultFilterElement);
        } else {
            vector.addAll(collection);
        }
        this.addListenerToList(vector, n, n2, defaultFilterElement, collection);
        this.selectFilterList(n2, filterable, defaultFilterElement, bl);
        return bl;
    }

    private void addListenerToList(Vector<Object> vector, int n, int n2, DefaultFilterElement defaultFilterElement, Collection<Object> collection) {
        this.filterList.setListData(vector);
        String string = this.getTableHeader().getColumnModel().getColumn(n).getHeaderValue().toString();
        Handler handler = new Handler(n2, collection, string, defaultFilterElement);
        this.filterList.addMouseListener(handler);
        this.filterList.addMouseMotionListener(handler);
    }

    private void initList() {
        if (null == this.filterList) {
            this.filterList = new JList();
            this.filterList.setSelectionMode(0);
        }
        this.filterList.removeAll();
        for (MouseListener eventListener : this.filterList.getMouseListeners()) {
            this.filterList.removeMouseListener(eventListener);
        }
        for (EventListener eventListener : this.filterList.getMouseMotionListeners()) {
            this.filterList.removeMouseMotionListener((MouseMotionListener)eventListener);
        }
    }

    private void initMultiSelectionListPanel(Collection<Object> collection, int n, DefaultFilterElement defaultFilterElement) {
        this.multiValuePanel = new JPanel(new BorderLayout());
        JPanel jPanel = new JPanel(new FlowLayout(2, 4, 4));
        this.initMultiValueList(collection);
        Dimension dimension = new Dimension(80, 21);
        final JButton jButton = this.initOkButton(n, defaultFilterElement, dimension);
        JButton jButton2 = this.initCancelButton(dimension);
        jPanel.add(jButton);
        jPanel.add(jButton2);
        this.multiValueList.addStateChangedListener(new StateChangedListener(){

            @Override
            public void stateChanged(int n) {
                int n2 = BasicTable.this.multiValueList.getRowCount();
                for (int i = 0; i < n2; ++i) {
                    if (!BasicTable.this.multiValueList.isRowSelected(i)) continue;
                    jButton.setEnabled(true);
                    return;
                }
                jButton.setEnabled(false);
            }
        });
        this.multiValuePanel.add((Component)jPanel, "South");
        this.multiValuePanel.add((Component)this.multiValueList, "North");
        this.multiValuePanel.setBackground(this.filterList.getBackground());
    }

    private JButton initCancelButton(Dimension dimension) {
        JButton jButton = new JButton(res.getString("Btn_Cancel"));
        jButton.setPreferredSize(dimension);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BasicTable.this.filterPopup.setVisible(false);
            }
        });
        return jButton;
    }

    private JButton initOkButton(final int n, final DefaultFilterElement defaultFilterElement, Dimension dimension) {
        JButton jButton = new JButton(res.getString("Btn_OK"));
        jButton.setEnabled(false);
        jButton.setPreferredSize(dimension);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object[] objectArray = BasicTable.this.multiValueList.getSelectedValues();
                BasicTable.this.multiValueFilterAction(n, objectArray, (Filterable)((Object)BasicTable.this.getModel()), defaultFilterElement);
                BasicTable.this.filterPopup.setVisible(false);
                BasicTable.this.getTableHeader().repaint();
            }
        });
        return jButton;
    }

    private void initMultiValueList(Collection<Object> collection) {
        if (null == this.multiValueList) {
            this.multiValueList = new SelectList(){

                @Override
                public Insets getInsets() {
                    return new Insets(0, 0, 1, 0);
                }
            };
            this.multiValueList.setScrollPaneBorder(BorderFactory.createEmptyBorder());
            this.multiValueList.setBorder(new ValueListBorder());
            this.multiValueList.setIsResponse(true);
            this.multiValueList.setFixedCellHeight(20);
            this.multiValueList.setCheckBoxCellSelectionEnabled(true);
        }
        this.multiValueList.setData(collection.toArray());
        this.multiValueList.setToolTip(new Vector<Object>(collection));
        int n = Math.min(collection.size(), 8);
        int n2 = this.multiValueList.getFixedCellHeight() * n + 1;
        this.multiValueList.setPreferredSize(new Dimension(172, n2));
        MultiSelectMouseHandler multiSelectMouseHandler = new MultiSelectMouseHandler();
        this.multiValueList.addMouseMotionListener(multiSelectMouseHandler);
        this.multiValueList.addMouseListener(multiSelectMouseHandler);
    }

    private void selectFilterList(int n, Filterable filterable, DefaultFilterElement defaultFilterElement, boolean bl) {
        if (null == defaultFilterElement) {
            this.filterList.setSelectedIndex(0);
            return;
        }
        ArrayList<DefaultFilterElement> arrayList = new ArrayList<DefaultFilterElement>(8);
        defaultFilterElement.getConditionsof(n, arrayList);
        int n2 = 0;
        if (null != this.filterSelection && this.filterSelection.containsKey(n)) {
            n2 = this.filterSelection.get(n);
        }
        int n3 = 0;
        switch (n2) {
            case 1: {
                n3 = arrayList.size() > 0 ? 1 : 0;
                this.filterList.setSelectedIndex(n3);
                if (bl) {
                    this.selectMultiValueList(arrayList);
                }
                return;
            }
            case 2: {
                if (arrayList.size() > 0) {
                    this.filterList.setSelectedValue(((DefaultFilterElement)arrayList.get(0)).getCondValue(), true);
                } else {
                    this.filterList.setSelectedIndex(0);
                }
                return;
            }
            case 3: {
                this.selectMultiValueList(arrayList);
                return;
            }
        }
        n3 = arrayList.size() > 0 ? 1 : 0;
        this.filterList.setSelectedIndex(n3);
    }

    private void selectMultiValueList(List<DefaultFilterElement> list) {
        Operators.Operator operator = null;
        for (DefaultFilterElement defaultFilterElement : list) {
            Object[] objectArray;
            Object object;
            operator = defaultFilterElement.getCondOperator();
            if (!Operators.Operator.EXIST_IN.equals((Object)operator) || !((object = defaultFilterElement.getCondValue()) instanceof Object[])) continue;
            for (Object object2 : objectArray = (Object[])object) {
                this.multiValueList.setElementSelected(object2, true);
            }
        }
    }

    private int getColumnWidth(int n) {
        TableColumn tableColumn = this.getTableHeader().getColumnModel().getColumn(n);
        return tableColumn == null ? 0 : tableColumn.getWidth();
    }

    private int getTotalColWidth(int n) {
        TableColumn tableColumn = null;
        int n2 = 0;
        for (int i = 0; i <= n; ++i) {
            tableColumn = this.getTableHeader().getColumnModel().getColumn(i);
            n2 += tableColumn.getWidth();
        }
        return n2;
    }

    private void allFilterAction(int n, Filterable filterable, DefaultFilterElement defaultFilterElement) {
        if (null == defaultFilterElement) {
            return;
        }
        if (null != this.filterSelection) {
            this.filterSelection.remove(n);
        }
        defaultFilterElement.removeAllRecursive(n);
        if (defaultFilterElement.getChildCount() == 0) {
            filterable.setFilter(null);
        } else {
            filterable.setFilter(defaultFilterElement);
        }
    }

    private void customFilterAction(int n, Collection<Object> collection, String string, Filterable filterable, DefaultFilterElement defaultFilterElement) {
        Map<Integer, Object> map = this.getColumnNameMap();
        CustomFilterDlg customFilterDlg = new CustomFilterDlg(collection, n, filterable, map){

            @Override
            public void dispose() {
                BasicTable.this.lastSizeDim = this.getSize();
                BasicTable.this.lastLocDim = this.getLocation();
                super.dispose();
            }
        };
        customFilterDlg.setHideAdvanceOptPopup(this.hideRootPopUpOnFilter);
        customFilterDlg.initializeConditions(defaultFilterElement);
        if (null != this.lastSizeDim) {
            customFilterDlg.setSize(this.lastSizeDim);
        }
        if (null != this.lastLocDim) {
            customFilterDlg.setLocation(this.lastLocDim);
        }
        customFilterDlg.setVisible(true);
        if (!customFilterDlg.isOKPressed()) {
            return;
        }
        if (this.filterSelection == null) {
            this.filterSelection = new HashMap<Integer, Integer>(8);
        }
        this.filterSelection.put(n, 1);
        FilterElement filterElement = customFilterDlg.getFilterElement();
        filterable.setFilter(filterElement);
    }

    private Map<Integer, Object> getColumnNameMap() {
        TreeMap<Integer, Object> treeMap = new TreeMap<Integer, Object>();
        ColumnInformation columnInformation = null;
        TableColumn tableColumn = null;
        int n = 0;
        for (Object e : this.getKeys()) {
            columnInformation = this.getColumnInformation(e);
            if (columnInformation.getState() == 3 || columnInformation.getState() == 1) continue;
            tableColumn = (TableColumn)this.columns.get(e);
            n = this.getColumnModel().getColumnIndex(e);
            if (!this.isColumnFiltarable(n)) continue;
            int n2 = this.convertColumnIndexToModel(n);
            treeMap.put(n2, tableColumn.getHeaderValue());
        }
        return treeMap;
    }

    private Object getViewColumnName(int n) {
        TableColumn tableColumn = null;
        if (n >= 0) {
            tableColumn = (TableColumn)this.columns.get(this.keys.get(n));
        } else {
            Map.Entry entry;
            Set set = this.columns.entrySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext() && (tableColumn = (TableColumn)(entry = iterator.next()).getValue()).getModelIndex() != n) {
            }
        }
        return tableColumn.getHeaderValue();
    }

    private void equalFilterAction(int n, Object object, Filterable filterable, DefaultFilterElement defaultFilterElement) {
        if (this.filterSelection == null) {
            this.filterSelection = new HashMap<Integer, Integer>(8);
        }
        this.filterSelection.put(n, 2);
        String string = this.getViewColumnName(n).toString();
        DefaultFilterElement defaultFilterElement2 = new DefaultFilterElement(n, Operators.Operator.EQUALS, object, string);
        DefaultFilterElement defaultFilterElement3 = defaultFilterElement;
        if (null == defaultFilterElement) {
            defaultFilterElement3 = new DefaultFilterElement(Operators.GroupOperator.GROUP_OP_AND);
        }
        defaultFilterElement3.addIntersectionFilter(defaultFilterElement2, n);
        filterable.setFilter(defaultFilterElement3);
    }

    private void multiValueFilterAction(int n, Object[] objectArray, Filterable filterable, DefaultFilterElement defaultFilterElement) {
        if (this.filterSelection == null) {
            this.filterSelection = new HashMap<Integer, Integer>(8);
        }
        this.filterSelection.put(n, 3);
        String string = this.getViewColumnName(n).toString();
        DefaultFilterElement defaultFilterElement2 = new DefaultFilterElement(n, Operators.Operator.EXIST_IN, objectArray, string);
        DefaultFilterElement defaultFilterElement3 = defaultFilterElement;
        if (null == defaultFilterElement3) {
            defaultFilterElement3 = new DefaultFilterElement(Operators.GroupOperator.GROUP_OP_AND);
        }
        defaultFilterElement3.addIntersectionFilter(defaultFilterElement2, n);
        filterable.setFilter(defaultFilterElement3);
    }

    public final void setDataFilterEnabled(boolean bl) {
        this.dataFilterEnabled = bl;
        TableModel tableModel = this.getModel();
        if (!(tableModel instanceof Filterable)) {
            throw new UnsupportedOperationException("Filter not supported");
        }
        if (!this.dataFilterEnabled) {
            ((Filterable)((Object)tableModel)).setFilter(null);
        }
        this.getTableHeader().repaint();
    }

    @Override
    public boolean isColumnFiltarable(int n) {
        TableModel tableModel = this.getModel();
        if (!(tableModel instanceof Filterable)) {
            return false;
        }
        int n2 = this.convertColumnIndexToModel(n);
        Filterable filterable = (Filterable)((Object)tableModel);
        return filterable.isColumnFilterable(n2);
    }

    @Override
    public final boolean isDataFilterEnabled() {
        return this.dataFilterEnabled;
    }

    @Override
    public final boolean isColumnFiltered(int n) {
        int n2 = this.convertColumnIndexToModel(n);
        TableModel tableModel = this.getModel();
        if (!(tableModel instanceof Filterable)) {
            return false;
        }
        Filterable filterable = (Filterable)((Object)tableModel);
        return filterable.isColumnFiltered(n2);
    }

    public boolean isMultiValueSelectionEnabled(int n) {
        int n2 = this.convertColumnIndexToModel(n);
        TableModel tableModel = this.getModel();
        if (!(tableModel instanceof Filterable)) {
            return false;
        }
        Filterable filterable = (Filterable)((Object)tableModel);
        return filterable.isMultiValueSelectionEnabled(n2);
    }

    @Override
    public boolean getSortable() {
        return false;
    }

    public final void setTableActionElement(TableActionElement ... tableActionElementArray) {
        TableModel tableModel = this.getModel();
        if (!(tableModel instanceof Filterable)) {
            throw new UnsupportedOperationException("Filter not supported");
        }
        if (null == tableActionElementArray) {
            return;
        }
        Filterable filterable = (Filterable)((Object)tableModel);
        for (TableActionElement tableActionElement : tableActionElementArray) {
            if (!(tableActionElement instanceof FilterElement)) continue;
            filterable.setFilter(this.getDefaultFilter((FilterElement)tableActionElement));
        }
    }

    private FilterElement getDefaultFilter(FilterElement filterElement) {
        TableModel tableModel = this.getModel();
        if (!(tableModel instanceof Filterable)) {
            return null;
        }
        Filterable filterable = (Filterable)((Object)tableModel);
        if (filterElement.isCondition()) {
            DefaultFilterElement defaultFilterElement = new DefaultFilterElement(Operators.GroupOperator.GROUP_OP_AND);
            defaultFilterElement.add(this.getDefaultFilter(filterElement, filterable));
            return defaultFilterElement;
        }
        return this.getDefaultFilter(filterElement, filterable);
    }

    private FilterElement getDefaultFilter(FilterElement filterElement, Filterable filterable) {
        if (filterElement.isCondition()) {
            int n = filterElement.getColumnIndex();
            String string = this.getViewColumnName(n).toString();
            return new DefaultFilterElement(n, filterElement.getCondOperator(), filterElement.getCondValue(), string);
        }
        DefaultFilterElement defaultFilterElement = new DefaultFilterElement(filterElement.getGroupOperator());
        int n = filterElement.getChildCount();
        FilterElement filterElement2 = null;
        for (int i = 0; i < n; ++i) {
            filterElement2 = this.getDefaultFilter(filterElement.getChildAt(i), filterable);
            if (null == filterElement2) continue;
            defaultFilterElement.add(filterElement2);
        }
        return defaultFilterElement.getChildCount() == 0 ? null : defaultFilterElement;
    }

    public static void cleanupWhileOSGIExit() {
        res = null;
    }

    @Override
    public void removeColumn(TableColumn tableColumn) {
        if (null == tableColumn) {
            return;
        }
        super.removeColumn(tableColumn);
        this.updateColInfo();
    }

    public void setTableProperty(String string, String string2) {
        if ("hideOperatorPopUpOnRoot".equals(string)) {
            this.hideRootPopUpOnFilter = Boolean.valueOf(string2);
        }
    }

    public void saveStateInformation(String string) {
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException("tableName and fileName can not be null, and the length of the tableName or fileName can not be zero.");
        }
        CommStyleInfo commStyleInfo = this.getTableInfo(string);
        DialogCommStyleInfo dialogCommStyleInfo = null;
        if (null != this.lastSizeDim) {
            dialogCommStyleInfo = new DialogCommStyleInfo(this.lastSizeDim.width, this.lastSizeDim.height);
        }
        if (null != this.lastLocDim && null != dialogCommStyleInfo) {
            AreaDescContainer areaDescContainer = dialogCommStyleInfo.getAreaDescContainer("DialogCommStyleInfo");
            DescContainer descContainer = new DescContainer();
            descContainer.setDescName("DialogLocation");
            PARAS pARAS = new PARAS();
            PARA pARA = new PARA();
            pARA.setName("XIndex");
            pARA.setValue(this.lastLocDim.x + "");
            PARA pARA2 = new PARA();
            pARA2.setName("YIndex");
            pARA2.setValue(this.lastLocDim.y + "");
            pARAS.addPARA(pARA);
            pARAS.addPARA(pARA2);
            descContainer.setPARAS(pARAS);
            areaDescContainer.addDescContainer(descContainer);
        }
        this.writeTableInfoToUser(string, commStyleInfo, false);
        this.writeDialogInfoToUser(string, dialogCommStyleInfo, false);
    }

    public void saveStateInformationAtClient(String string) {
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException("tableName and fileName can not be null, and the length of the tableName or fileName can not be zero.");
        }
        this.getTableFullFileName(string);
        CommStyleInfo commStyleInfo = this.getTableInfo(string);
        this.writeTableInfoToUser(string, commStyleInfo, true);
    }

    private CommStyleInfo getTableInfo(String string) {
        ColumnInformation[] columnInformationArray = this.getColumnsInfo();
        if (null == columnInformationArray) {
            return null;
        }
        AreaDescContainer areaDescContainer = this.writeTableInfo(string, columnInformationArray);
        DescContainer descContainer = null;
        CommStyleInfo commStyleInfo = null;
        for (int i = 0; i < columnInformationArray.length; ++i) {
            descContainer = new DescContainer(this.replaceAll_n_r_t(columnInformationArray[i].getIdentifier().toString()));
            descContainer.setParasItem(COLUMN_NAME, this.replaceAll_n_r_t(columnInformationArray[i].getColName()), true);
            descContainer.setParasItem(COLUMN_STATE, Integer.toString(columnInformationArray[i].getState()), true);
            descContainer.setParasItem(COLUMN_WIDTH, Integer.toString(columnInformationArray[i].getColWidth()), true);
            descContainer.setParasItem(COLUMN_INDEX, Integer.toString(columnInformationArray[i].getIndex()), true);
            this.constructColInfoDescContainer(descContainer, columnInformationArray[i]);
            areaDescContainer.setDescContainer(descContainer, true);
        }
        commStyleInfo = new CommStyleInfo();
        commStyleInfo.setAreaDescContainer(areaDescContainer, true);
        return commStyleInfo;
    }

    private AreaDescContainer writeTableInfo(String string, ColumnInformation[] columnInformationArray) {
        this.bt_n = this.getReplacement(columnInformationArray, "\n");
        this.bt_r = this.getReplacement(columnInformationArray, "\r");
        this.bt_t = this.getReplacement(columnInformationArray, "\t");
        String string2 = new StringBuffer("(").append(this.bt_n).append("/").append(this.bt_r).append("/").append(this.bt_t).append(")").toString();
        AreaDescContainer areaDescContainer = new AreaDescContainer(string + string2);
        return areaDescContainer;
    }

    private void writeTableInfoToUser(String string, CommStyleInfo commStyleInfo, boolean bl) {
        CommStyleManager commStyleManager = CommStyleManager.getInstance();
        if (null != commStyleInfo) {
            commStyleInfo.setFileName(commStyleManager.getUserDir() + this.saveTablePath + ".xml");
        }
        if (bl) {
            commStyleManager.writeToUserAtClient(commStyleInfo);
        } else {
            GUICompCommStyleInfo gUICompCommStyleInfo = new GUICompCommStyleInfo(this.type);
            this.copyGUIInfo(commStyleInfo, gUICompCommStyleInfo);
            commStyleManager.writeGUIInfoToUser(string, gUICompCommStyleInfo);
        }
    }

    private void writeDialogInfoToUser(String string, CommStyleInfo commStyleInfo, boolean bl) {
        CommStyleManager commStyleManager = CommStyleManager.getInstance();
        if (null != commStyleInfo) {
            commStyleInfo.setFileName(commStyleManager.getUserDir() + this.saveTablePath + ".xml");
        }
        if (bl) {
            commStyleManager.writeToUserAtClient(commStyleInfo);
        } else {
            GUICompCommStyleInfo gUICompCommStyleInfo = new GUICompCommStyleInfo("Dialog");
            this.copyGUIInfo(commStyleInfo, gUICompCommStyleInfo);
            commStyleManager.writeGUIInfoToUser(string, gUICompCommStyleInfo);
        }
    }

    private void copyGUIInfo(CommStyleInfo commStyleInfo, GUICompCommStyleInfo gUICompCommStyleInfo) {
        if (null == commStyleInfo || null == gUICompCommStyleInfo) {
            logger.trace("info or guiinfo is null ");
            return;
        }
        gUICompCommStyleInfo.setFileName(commStyleInfo.getFileName());
        gUICompCommStyleInfo.setEncoding(commStyleInfo.getEncoding());
        gUICompCommStyleInfo.setPluginName(commStyleInfo.getPluginName());
        gUICompCommStyleInfo.setPluginResource(commStyleInfo.getResource());
        gUICompCommStyleInfo.setPublicId(commStyleInfo.getPublicId());
        gUICompCommStyleInfo.setSystemId(commStyleInfo.getSystemId());
        gUICompCommStyleInfo.setRelatFileName(commStyleInfo.getRelatFileName());
        gUICompCommStyleInfo.setHasDtdHeader(commStyleInfo.hasDtdHeader());
        gUICompCommStyleInfo.setAreaDescContainer(commStyleInfo.getAreaDescContainer());
        gUICompCommStyleInfo.setUrlExternalForm(commStyleInfo.getUrlExternalForm());
    }

    public void restoreStateInformation(String string) {
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException("tableName can not be null, and the length of the tableName can not be zero.");
        }
        this.readTableInformation(string, false);
        this.readDialogInformation(string, false);
    }

    public void restoreStateInformationAtClient(String string) {
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException("tableName can not be null, and the length of the tableName can not be zero.");
        }
        this.getTableFullFileName(string);
        this.readTableInformation(string, true);
    }

    private void getTableFullFileName(String string) {
        StringBuffer stringBuffer = new StringBuffer(10);
        stringBuffer.append("GUIstyle/");
        stringBuffer.append("table/");
        stringBuffer.append(string);
        this.saveTablePath = stringBuffer.toString();
    }

    private void readTableInformation(String string, boolean bl) {
        Object object;
        CommStyleInfo commStyleInfo = null;
        try {
            object = CommStyleManager.getInstance();
            commStyleInfo = bl ? ((CommStyleManager)object).getUserCommonStyleFileAtClient(this.saveTablePath) : ((CommStyleManager)object).readGUIInfoFromUser(string, this.type);
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
            return;
        }
        if (null != commStyleInfo) {
            object = null;
            try {
                object = commStyleInfo.getAreaDescContainer(0);
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
            }
            if (null != object) {
                this.parseAreaName(((AreaDescContainer)object).getAreaName());
                DescContainer descContainer = null;
                int n = ((AreaDescContainer)object).getDescContainerCount();
                ColumnInformation[] columnInformationArray = new ColumnInformation[n];
                for (int i = 0; i < n; ++i) {
                    descContainer = ((AreaDescContainer)object).getDescContainer(i);
                    if (null == descContainer) continue;
                    String string2 = descContainer.getParasItemValue(COLUMN_NAME);
                    if (null == string2) {
                        string2 = "";
                    }
                    columnInformationArray[i] = this.constructColumnInformation(this.resumeAll_n_r_t(descContainer.getDescName()), this.resumeAll_n_r_t(string2), Integer.parseInt(descContainer.getParasItemValue(COLUMN_STATE)), Integer.parseInt(descContainer.getParasItemValue(COLUMN_WIDTH)), Integer.parseInt(descContainer.getParasItemValue(COLUMN_INDEX)), descContainer);
                }
                if (this.isValid(columnInformationArray)) {
                    this.updateTable(columnInformationArray);
                    this.hasResizeColWidth = true;
                } else {
                    logger.trace("Table is not updating,because of mismatching columns");
                }
            }
        } else {
            logger.trace("In Table-Cannot read style-info from " + this.saveTablePath);
        }
    }

    private void readDialogInformation(String string, boolean bl) {
        CommStyleInfo commStyleInfo = null;
        try {
            CommStyleManager commStyleManager = CommStyleManager.getInstance();
            if (bl) {
                commStyleInfo = commStyleManager.getUserCommonStyleFileAtClient(this.saveTablePath);
            } else {
                commStyleInfo = commStyleManager.readGUIInfoFromUser(string, "Dialog");
                DialogCommStyleInfo dialogCommStyleInfo = (DialogCommStyleInfo)commStyleInfo;
                if (null == dialogCommStyleInfo) {
                    return;
                }
                this.lastSizeDim = dialogCommStyleInfo.getSize();
                AreaDescContainer areaDescContainer = dialogCommStyleInfo.getAreaDescContainer("DialogCommStyleInfo");
                DescContainer descContainer = areaDescContainer.getDescContainer("DialogLocation");
                int n = Integer.parseInt(descContainer.getParasItemValue("XIndex"));
                int n2 = Integer.parseInt(descContainer.getParasItemValue("YIndex"));
                this.lastLocDim = new Point(n, n2);
            }
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
            return;
        }
    }

    protected ColumnInformation constructColumnInformation(Object object, String string, int n, int n2, int n3, DescContainer descContainer) {
        return new ColumnInformation(object, string, n, n2, n3);
    }

    protected void constructColInfoDescContainer(DescContainer descContainer, ColumnInformation columnInformation) {
    }

    public void setCustomFilterOnEnum(boolean bl) {
        this.addCustomOptEnum = bl;
    }

    private class Handler
    implements MouseListener,
    MouseMotionListener,
    Serializable {
        private static final long serialVersionUID = 3689073143435337130L;
        private int columnIndex = -1;
        private Collection<Object> filterValues = null;
        private String colName = null;
        private DefaultFilterElement fElement = null;

        Handler(int n, Collection<Object> collection, String string, DefaultFilterElement defaultFilterElement) {
            this.columnIndex = n;
            this.filterValues = collection;
            this.colName = string;
            this.fElement = defaultFilterElement;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            BasicTable.this.filterPopup.setVisible(false);
            JList jList = (JList)mouseEvent.getSource();
            if (-1 == jList.getSelectedIndex()) {
                return;
            }
            TableModel tableModel = BasicTable.this.getModel();
            if (!(tableModel instanceof Filterable)) {
                return;
            }
            Filterable filterable = (Filterable)((Object)tableModel);
            int n = jList.getSelectedIndex();
            switch (n) {
                case 0: {
                    BasicTable.this.allFilterAction(this.columnIndex, filterable, this.fElement);
                    break;
                }
                case 1: {
                    if (jList.getSelectedValue().equals(res.getString("Custom_Filter"))) {
                        BasicTable.this.customFilterAction(this.columnIndex, this.filterValues, this.colName, filterable, this.fElement);
                        break;
                    }
                    BasicTable.this.equalFilterAction(this.columnIndex, jList.getSelectedValue(), filterable, this.fElement);
                    break;
                }
                default: {
                    BasicTable.this.equalFilterAction(this.columnIndex, jList.getSelectedValue(), filterable, this.fElement);
                }
            }
            BasicTable.this.getTableHeader().repaint();
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            JList jList = (JList)mouseEvent.getSource();
            jList.clearSelection();
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            JList jList = (JList)mouseEvent.getSource();
            Point point = mouseEvent.getPoint();
            Rectangle rectangle = new Rectangle();
            jList.computeVisibleRect(rectangle);
            if (rectangle.contains(point)) {
                int n = jList.locationToIndex(point);
                if (n == -1 && point.y < 0) {
                    n = 0;
                }
                if (jList.getSelectedIndex() != n) {
                    jList.setSelectedIndex(n);
                    jList.ensureIndexIsVisible(n);
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
        }
    }

    private static class ValueListBorder
    implements Border {
        private ValueListBorder() {
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return new Insets(0, 0, 5, 0);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Color color = graphics.getColor();
            graphics.translate(n, n2);
            graphics.setColor(UIManager.getColor("Separator.foreground"));
            graphics.drawLine(0, n4 - 1, n3, n4 - 1);
            graphics.setColor(color);
            graphics.translate(-n, -n2);
        }
    }

    private class MultiSelectMouseHandler
    extends MouseAdapter {
        private MultiSelectMouseHandler() {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            JTable jTable = (JTable)mouseEvent.getSource();
            jTable.clearSelection();
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            JTable jTable = (JTable)mouseEvent.getSource();
            Point point = mouseEvent.getPoint();
            Rectangle rectangle = new Rectangle();
            jTable.computeVisibleRect(rectangle);
            if (rectangle.contains(point)) {
                int n = jTable.rowAtPoint(point);
                if (n == -1 && point.y < 0) {
                    n = 0;
                }
                if (jTable.getSelectedRow() != n) {
                    jTable.setRowSelectionInterval(n, n);
                    jTable.scrollRectToVisible(jTable.getCellRect(n, 1, true));
                }
            }
        }
    }
}

