/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.addressbook;

import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.util.log.IviewLogger;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class AddressBookModel
implements TableModel,
Serializable {
    private static IviewLogger logger = IviewLogger.getLogger(AddressBookModel.class, "IVIEW");
    private static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/templates/addressbook/Res");
    private static String[] columnNames = new String[]{res.getString("ServerName"), res.getString("ServerIP"), res.getString("ServerPort")};
    private Vector tableData = new Vector(10);

    @Override
    public int getRowCount() {
        return this.tableData.size();
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public String getColumnName(int n) {
        return columnNames[n];
    }

    public void insertRow(int n) {
        this.tableData.add(n < 0 ? 0 : n, this.createNewRow());
    }

    public Vector createNewRow() {
        Vector<String> vector = new Vector<String>(10);
        int n = columnNames.length;
        for (int i = 0; i < n; ++i) {
            vector.add(i, "");
        }
        return vector;
    }

    public void removeRow(int n) {
        try {
            this.tableData.remove(n);
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
    }

    public Vector getRowData(int n) {
        return (Vector)this.tableData.get(n);
    }

    @Override
    public final Object getValueAt(int n, int n2) {
        try {
            Vector vector = (Vector)this.tableData.get(n);
            return vector.get(n2);
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
            return "";
        }
    }

    @Override
    public final void setValueAt(Object object, int n, int n2) {
        try {
            Vector vector = (Vector)this.tableData.get(n);
            vector.set(n2, object);
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public final Class getColumnClass(int n) {
        return String.class;
    }

    @Override
    public final void addTableModelListener(TableModelListener tableModelListener) {
    }

    @Override
    public final void removeTableModelListener(TableModelListener tableModelListener) {
    }

    public Vector getTableData() {
        return this.tableData;
    }

    public void setTableData(Vector vector) {
        this.tableData = vector;
    }

    public String[] getColumnNames() {
        return columnNames;
    }

    public void setColumnNames(String[] stringArray) {
        columnNames = stringArray;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
    }
}

