/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.addressbook;

import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.templates.addressbook.AddressBookModel;
import com.swimap.iview.templates.textfield.IntegerDocument;
import com.swimap.iview.templates.textfield.ValidCharDocument;
import com.swimap.iview.templates.textfield.ipaddress.IPAddressTextField;
import com.swimap.iview.templates.textfield.ipaddress.InValideIPAddressException;
import com.swimap.iview.util.OptionPane;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;

public class AddressBookDlg
extends JDialog {
    private static IviewLogger logger = IviewLogger.getLogger(AddressBookDlg.class, "IVIEW");
    private static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/templates/addressbook/Res");
    private GridBagLayout dialogLayout = null;
    private JLabel serverNameLabel = null;
    private JTextField serverNameField = null;
    private JLabel serverIpLabel = null;
    private IPAddressTextField serverIpField = null;
    private JLabel serverPortLabel = null;
    private JTextField serverPortField = null;
    private JButton okButton = null;
    private JButton cancelButton = null;
    private boolean isModify = false;
    private JTable addressTable = null;
    private JPanel serverInfoPane = new JPanel();
    private GridBagLayout serverInfoGridBagLayout = new GridBagLayout();
    private static final int MINI_PORT = 1;
    private static final int MAX_PORT = 65535;

    public AddressBookDlg(JTable jTable, boolean bl) {
        super(FrameworkUtilities.getMainFrame(), res.getString("IpSetDlgTitle"), true);
        try {
            this.setAddressTable(jTable);
            this.setIsModify(bl);
            this.jbInit();
            this.pack();
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
    }

    public AddressBookDlg(JTable jTable, String string, boolean bl) {
        super(FrameworkUtilities.getMainFrame(), string, true);
        try {
            this.setAddressTable(jTable);
            this.setIsModify(bl);
            this.jbInit();
            this.pack();
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
    }

    private void jbInit() throws Exception {
        this.dialogLayout = new GridBagLayout();
        this.serverNameLabel = new JLabel(res.getString("Name"));
        this.serverNameLabel.setName("AddressBookDlg_serverNameLabel");
        this.serverNameField = new JTextField("");
        this.serverNameField.setName("AddressBookDlg_serverNameField");
        this.serverIpLabel = new JLabel(res.getString("IP"));
        this.serverIpLabel.setName("AddressBookDlg_serverIpLabel");
        this.serverIpField = new IPAddressTextField();
        this.serverIpField.setName("AddressBookDlg_serverIpField");
        this.serverPortLabel = new JLabel(res.getString("Port"));
        this.serverPortLabel.setName("AddressBookDlg_serverPortLabel");
        this.serverPortField = new JTextField();
        this.serverPortField.setName("AddressBookDlg_serverPortField");
        this.okButton = new JButton(res.getString("OK"));
        this.okButton.setName("AddressBookDlg_okButton");
        this.cancelButton = new JButton(res.getString("Cancel"));
        this.cancelButton.setName("AddressBookDlg_cancelButton");
        Dimension dimension = new Dimension(91, 21);
        Dimension dimension2 = new Dimension(130, 21);
        Dimension dimension3 = new Dimension(80, 21);
        this.serverNameLabel.setPreferredSize(dimension);
        this.serverNameField.setPreferredSize(dimension2);
        this.serverIpLabel.setPreferredSize(dimension);
        this.serverIpField.setPreferredSize(dimension2);
        this.serverPortLabel.setPreferredSize(dimension);
        this.serverPortField.setPreferredSize(dimension2);
        this.okButton.setPreferredSize(dimension3);
        this.cancelButton.setPreferredSize(dimension3);
        this.getContentPane().setLayout(this.dialogLayout);
        this.serverInfoPane.setName("AddressBookDlg_serverInfoPane");
        this.serverInfoPane.setLayout(this.serverInfoGridBagLayout);
        this.serverInfoPane.add((Component)this.serverNameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.serverInfoPane.add((Component)this.serverIpLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.serverInfoPane.add((Component)this.serverPortLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 17, 1, new Insets(0, 0, 0, 6), 0, 0));
        this.serverInfoPane.add((Component)this.serverNameField, new GridBagConstraints(1, 0, 3, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 6), 0, 0));
        this.serverInfoPane.add((Component)this.serverIpField, new GridBagConstraints(1, 1, 3, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 6), 0, 0));
        this.serverInfoPane.add((Component)this.serverPortField, new GridBagConstraints(1, 2, 3, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 6), 0, 0));
        this.getContentPane().add((Component)this.okButton, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 13, 0, new Insets(13, 0, 10, 10), 0, 0));
        this.getContentPane().add((Component)this.cancelButton, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(13, 10, 10, 0), 0, 0));
        this.getContentPane().add((Component)this.serverInfoPane, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 15, 1, new Insets(10, 20, 0, 20), 0, 0));
        ScreenToolKit.centerLocateToScreen(this);
        ScreenToolKit.setDefaultButtons(this.okButton, this.cancelButton);
        ((JPanel)this.getContentPane()).setPreferredSize(new Dimension(319, 150));
        this.setResizable(false);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddressBookDlg.this.okButton_actionPerformed(actionEvent);
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddressBookDlg.this.cancelButton_actionPerformed(actionEvent);
            }
        });
        this.initNameTextField();
        this.initIpTextField();
        this.initServerPortTextFild();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
            }
        });
    }

    public void okButton_actionPerformed(ActionEvent actionEvent) {
        int n;
        String string = this.serverNameField.getText();
        String string2 = this.delSpace(this.serverIpField.getText());
        String string3 = this.serverPortField.getText();
        if ("".equals(string) || string.length() == 0) {
            OptionPane.showMessageDialog(this, res.getString("nameIsNull"), res.getString("errorDlg"), 0);
            this.serverNameField.requestFocus();
            this.serverNameField.selectAll();
            return;
        }
        if (string.charAt(0) == '.' || string.endsWith(".")) {
            OptionPane.showMessageDialog(this, res.getString("invalidname"), res.getString("errorDlg"), 0);
            this.serverNameField.requestFocus();
            this.serverNameField.selectAll();
            return;
        }
        if (string2 == null || "".equals(string2.trim()) || "...".equals(string2) || "0.0.0.0".equals(string2)) {
            OptionPane.showMessageDialog(this, res.getString("inputipmsg"), res.getString("errorDlg"), 0);
            this.serverIpField.requestFocus();
            this.serverIpField.selectAll();
            return;
        }
        try {
            this.serverIpField.getValue();
        }
        catch (Exception exception) {
            logger.trace("IP address entered is not correct OR It is not fully entered in all four fields");
            OptionPane.showMessageDialog(this, res.getString("ipIsInvalid"), res.getString("errorDlg"), 0);
            this.serverIpField.requestFocus();
            this.serverIpField.selectAll();
            return;
        }
        if (!((IntegerDocument)this.serverPortField.getDocument()).isInRange(string3)) {
            OptionPane.showMessageDialog(this, res.getString("inputportmsg"), res.getString("errorDlg"), 0);
            this.serverPortField.requestFocus();
            this.serverPortField.selectAll();
            return;
        }
        int n2 = this.addressTable.getRowCount();
        for (n = 0; n < n2; ++n) {
            if (string2.equals(this.addressTable.getValueAt(n, 1)) && this.serverPortField.getText().equals(this.addressTable.getValueAt(n, 2)) && string.equals(this.addressTable.getValueAt(n, 0))) {
                if (!this.isModify) {
                    OptionPane.showMessageDialog(this, res.getString("exisServer"), res.getString("errorDlg"), 0);
                    return;
                }
                if (this.isModify && this.addressTable.getSelectedRow() == n) {
                    this.dispose();
                    return;
                }
            }
            if (string.equals(this.addressTable.getValueAt(n, 0)) && !this.isModify) {
                OptionPane.showMessageDialog(this, res.getString("exisName"), res.getString("errorDlg"), 0);
                this.serverNameField.requestFocus();
                this.serverNameField.selectAll();
                return;
            }
            if (!string.equals(this.addressTable.getValueAt(n, 0)) || !this.isModify || n == this.addressTable.getSelectedRow()) continue;
            OptionPane.showMessageDialog(this, res.getString("exisName"), res.getString("errorDlg"), 0);
            this.serverNameField.requestFocus();
            this.serverNameField.selectAll();
            return;
        }
        n = this.addressTable.getSelectedRow();
        if (!this.isModify) {
            int n3 = this.addressTable.getEditingColumn();
            int n4 = this.addressTable.getEditingRow();
            if (n3 != -1 || n4 != -1) {
                this.addressTable.getCellEditor(n4, n3).stopCellEditing();
            }
            ((AddressBookModel)this.addressTable.getModel()).insertRow(n);
        }
        this.addressTable.setValueAt(this.serverNameField.getText(), n < 0 ? 0 : n, 0);
        this.addressTable.setValueAt(this.delSpace(this.serverIpField.getText()), n < 0 ? 0 : n, 1);
        this.addressTable.setValueAt(this.serverPortField.getText(), n < 0 ? 0 : n, 2);
        this.dispose();
    }

    public void cancelButton_actionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }

    private void initNameTextField() {
        String string = "`~!@#$%^&*()\":;?/\\,|{}[]<> '";
        ValidCharDocument validCharDocument = new ValidCharDocument(50, string);
        this.serverNameField.setDocument(validCharDocument);
        if (this.isModify) {
            int n = this.addressTable.getSelectedRow();
            if (n < 0) {
                OptionPane.showMessageDialog(this, res.getString("inputipmsg"), res.getString("errorDlg"), 0);
                return;
            }
            this.serverNameField.setText((String)this.addressTable.getValueAt(n, 0));
        }
    }

    private void initIpTextField() {
        if (this.isModify) {
            int n;
            String string;
            int n2;
            int n3 = this.addressTable.getSelectedRow();
            if (n3 < 0) {
                OptionPane.showMessageDialog(this, res.getString("inputipmsg"), res.getString("errorDlg"), 0);
                return;
            }
            String string2 = this.delSpace((String)this.addressTable.getValueAt(n3, 1));
            String string3 = "0";
            String string4 = "0";
            String string5 = "0";
            String string6 = "0";
            int n4 = string2.indexOf(".");
            if (n4 != -1) {
                string3 = string2.substring(0, n4);
            }
            if ((n2 = (string = string2.substring(n4 + 1)).indexOf(".")) != -1) {
                string4 = string.substring(0, n2);
            }
            if ((n = (string = string.substring(n2 + 1)).indexOf(".")) != -1) {
                string5 = string.substring(0, n);
            }
            if (n4 != -1 && n2 != -1 && n != -1) {
                string6 = string.substring(n + 1);
            }
            ArrayList<String> arrayList = new ArrayList<String>(4);
            arrayList.clear();
            arrayList.add(string3);
            arrayList.add(string4);
            arrayList.add(string5);
            arrayList.add(string6);
            try {
                this.serverIpField.setValue(arrayList);
                return;
            }
            catch (InValideIPAddressException inValideIPAddressException) {
                logger.trace("error = IPAddressTextField  setValue ( ArrayList value ) ");
                logger.trace(inValideIPAddressException.getMessage(), inValideIPAddressException);
            }
        }
    }

    public String delSpace(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(16);
        int n2 = -1;
        int n3 = 0;
        while (n3 < n && (n3 = string.indexOf(32, n3)) != -1) {
            stringBuffer.append(string.substring(n2 + 1, n3));
            n2 = n3++;
        }
        return stringBuffer.append(string.substring(n2 + 1, n)).toString();
    }

    private void initServerPortTextFild() {
        IntegerDocument integerDocument = new IntegerDocument(1, 65535);
        this.serverPortField.setDocument(integerDocument);
        StringBuffer stringBuffer = new StringBuffer(16);
        stringBuffer.append('(').append(1).append('~').append(65535).append(')');
        this.serverPortField.setToolTipText(stringBuffer.toString());
        this.serverPortField.setText("9999");
        if (this.isModify) {
            int n = this.addressTable.getSelectedRow();
            if (n < 0) {
                OptionPane.showMessageDialog(this, res.getString("inputipmsg"), res.getString("errorDlg"), 0);
                return;
            }
            this.serverPortField.setText((String)this.addressTable.getValueAt(n, 2));
        }
    }

    public void setAddressTable(JTable jTable) {
        this.addressTable = jTable;
        this.addressTable.setName("AddressBookDlg_addressTable");
    }

    public void setIsModify(boolean bl) {
        this.isModify = bl;
    }
}

