/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.addressbook;

import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.templates.addressbook.AddressBookDlg;
import com.swimap.iview.templates.addressbook.AddressBookModel;
import com.swimap.iview.templates.addressbook.AddressbookInterface;
import com.swimap.iview.templates.persistencecombobox.DefaultPersistenceHandler;
import com.swimap.iview.templates.persistencecombobox.PersistenceHandlerInterface;
import com.swimap.iview.util.OptionPane;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

public class AddressBook
extends JDialog {
    private static IviewLogger logger = IviewLogger.getLogger(AddressBook.class, "IVIEW");
    private static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/templates/addressbook/Res");
    private JScrollPane jScrollPane1 = new JScrollPane();
    private JButton okButton = new JButton();
    private JButton cancelButton = new JButton();
    private JButton insertButton = new JButton();
    private JButton modifyButton = new JButton();
    private JButton delButton = new JButton();
    private JTable addressTable = null;
    private TitledBorder titledBorder1 = null;
    private static PersistenceHandlerInterface persistenceHandler = new DefaultPersistenceHandler();
    private static Object persistenceLoaction = "./backendList";
    private AddressbookInterface addressbookInterface = null;
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private boolean okButtonPressed = false;

    public AddressBook() {
        this(new JDialog(), "", true);
    }

    public AddressBook(JDialog jDialog, String string, boolean bl) {
        super(jDialog, string, bl);
        try {
            this.jbInit();
            this.pack();
            this.setOKbuttonrequestFocus();
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
    }

    public AddressBook(JFrame jFrame, String string) {
        super(jFrame, string, true);
        try {
            this.jbInit();
            this.pack();
            this.setOKbuttonrequestFocus();
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
    }

    public void setInterface(AddressbookInterface addressbookInterface) {
        this.addressbookInterface = addressbookInterface;
    }

    public JTable getAddressTable() {
        return this.addressTable;
    }

    public static Vector getAddress() {
        AddressBook addressBook = new AddressBook();
        addressBook.loadAddressInformation();
        addressBook.setModal(true);
        addressBook.show();
        Vector vector = null;
        if (addressBook.okButtonPressed) {
            vector = addressBook.getSelectedRowData();
        }
        return vector;
    }

    public void loadAddressInformation() {
        try {
            AddressBookModel addressBookModel = (AddressBookModel)persistenceHandler.loadPersistenceInformation(AddressBook.getPersistenceLoaction());
            if (addressBookModel != null) {
                this.addressTable.setModel(addressBookModel);
            }
            this.setOKbuttonrequestFocus();
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
    }

    private void jbInit() throws Exception {
        AddressBookModel addressBookModel = new AddressBookModel();
        this.addressTable = new JTable(addressBookModel);
        this.addressTable.setName("AddressBook_addressTable");
        this.addressTable.getTableHeader().setReorderingAllowed(false);
        this.addressTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    AddressBook.this.okButton_actionPerformed();
                }
            }
        });
        this.titledBorder1 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), res.getString("AddressBook"));
        this.getContentPane().setLayout(this.gridBagLayout1);
        this.jScrollPane1.setBorder(this.titledBorder1);
        this.jScrollPane1.setName("AddressBook_jScrooPan1");
        Dimension dimension = new Dimension(80, 21);
        this.okButton.setMaximumSize(dimension);
        this.okButton.setMinimumSize(dimension);
        this.okButton.setPreferredSize(dimension);
        this.okButton.setText(res.getString("OK"));
        this.okButton.setName("AddressBook_okButton");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddressBook.this.okButton_actionPerformed();
            }
        });
        this.cancelButton.setMaximumSize(dimension);
        this.cancelButton.setMinimumSize(dimension);
        this.cancelButton.setPreferredSize(dimension);
        this.cancelButton.setText(res.getString("Cancel"));
        this.cancelButton.setName("AddressBook_cancelButton");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddressBook.this.cancelButton_actionPerformed();
            }
        });
        this.insertButton.setMaximumSize(dimension);
        this.insertButton.setMinimumSize(dimension);
        this.insertButton.setPreferredSize(dimension);
        this.insertButton.setText(res.getString("Add"));
        this.insertButton.setName("AddressBook_insertButton");
        this.insertButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddressBook.this.insertButton_actionPerformed();
            }
        });
        this.insertButton.setMnemonic('A');
        this.modifyButton.setMaximumSize(dimension);
        this.modifyButton.setMinimumSize(dimension);
        this.modifyButton.setPreferredSize(dimension);
        this.modifyButton.setText(res.getString("Modify"));
        this.modifyButton.setName("AddressBook_modifyButton");
        this.modifyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddressBook.this.modifyButton_actionPerformed();
            }
        });
        this.modifyButton.setMnemonic('M');
        this.delButton.setMaximumSize(dimension);
        this.delButton.setMinimumSize(dimension);
        this.delButton.setPreferredSize(dimension);
        this.delButton.setText(res.getString("Delete"));
        this.delButton.setName("AddressBook_delButton");
        this.delButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddressBook.this.delButton_actionPerformed();
            }
        });
        this.delButton.setMnemonic('D');
        this.setTitle(res.getString("AddressBook"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                AddressBook.this.this_windowClosing();
            }
        });
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setName("AddressBook_rightPanel");
        jPanel.add((Component)this.insertButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(8, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.modifyButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.delButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 11, 0, new Insets(5, 0, 0, 0), 0, 0));
        JPanel jPanel2 = new JPanel(new FlowLayout(1));
        jPanel2.setName("AddressBook_bottomPanel");
        jPanel2.add(this.okButton);
        jPanel2.add(this.cancelButton);
        this.getContentPane().add((Component)this.jScrollPane1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)jPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)jPanel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        ScreenToolKit.centerLocateToScreen(this);
        ScreenToolKit.setDefaultButtons(this.okButton, this.cancelButton);
        String string = "ENTER";
        String string2 = "ESCAPE";
        this.addressTable.getInputMap().put(KeyStroke.getKeyStroke(string), string);
        this.addressTable.getActionMap().put(string, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddressBook.this.okButton_actionPerformed();
            }
        });
        this.addressTable.getInputMap().put(KeyStroke.getKeyStroke(string2), string2);
        this.addressTable.getActionMap().put(string2, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddressBook.this.cancelButton_actionPerformed();
            }
        });
        ((JPanel)this.getContentPane()).setPreferredSize(new Dimension(450, 230));
        this.setResizable(false);
        this.jScrollPane1.getViewport().add((Component)this.addressTable, null);
    }

    private void insertButton_actionPerformed() {
        AddressBookDlg addressBookDlg = new AddressBookDlg(this.addressTable, res.getString("IpSetDlgTitle"), false);
        addressBookDlg.setLocationRelativeTo(this);
        addressBookDlg.show();
        this.addressTable.revalidate();
        this.addressTable.repaint();
        this.setOKbuttonrequestFocus();
    }

    private void modifyButton_actionPerformed() {
        int n = this.addressTable.getSelectedRow();
        int n2 = this.addressTable.getRowCount();
        if (n == -1 || n >= n2) {
            OptionPane.showMessageDialog(this, res.getString("notselect"), res.getString("errorDlg"), 0);
            return;
        }
        AddressBookDlg addressBookDlg = new AddressBookDlg(this.addressTable, res.getString("IpSetModifyDlgTitle"), true);
        addressBookDlg.setLocationRelativeTo(this);
        addressBookDlg.show();
        this.addressTable.revalidate();
        this.addressTable.repaint();
        this.setOKbuttonrequestFocus();
    }

    private void delButton_actionPerformed() {
        int n = this.addressTable.getSelectedRow();
        int n2 = this.addressTable.getRowCount();
        if (n == -1 || n >= n2) {
            OptionPane.showMessageDialog(this, res.getString("notselect"), res.getString("errorDlg"), 0);
            return;
        }
        ((AddressBookModel)this.addressTable.getModel()).removeRow(this.addressTable.getSelectedRow());
        this.addressTable.revalidate();
        this.addressTable.repaint();
        this.setOKbuttonrequestFocus();
    }

    private void okButton_actionPerformed() {
        Vector vector = ((AddressBookModel)this.addressTable.getModel()).getTableData();
        int n = this.addressTable.getSelectedRow();
        int n2 = this.addressTable.getRowCount();
        if (n == -1 || n >= n2) {
            OptionPane.showMessageDialog(this, res.getString("notselect"), res.getString("errorDlg"), 0);
            return;
        }
        this.okButtonPressed = true;
        this.saveAddressInformation();
        if (null != this.addressbookInterface) {
            this.addressbookInterface.inputValue(vector, n);
        }
        this.dispose();
    }

    private void cancelButton_actionPerformed() {
        this.dispose();
        this.okButtonPressed = false;
    }

    public Vector getSelectedRowData() {
        try {
            int n = this.addressTable.getSelectedRow();
            if (this.addressTable.getEditingColumn() == -1 && -1 != n) {
                return ((AddressBookModel)this.addressTable.getModel()).getRowData(n);
            }
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
        return null;
    }

    public void saveAddressInformation() {
        try {
            persistenceHandler.savePersistenceInformation(this.addressTable.getModel(), AddressBook.getPersistenceLoaction());
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
    }

    private void this_windowClosing() {
        this.dispose();
        this.okButtonPressed = false;
    }

    private void setOKbuttonrequestFocus() {
        if (this.addressTable.getModel().getRowCount() > 0) {
            this.okButton.setEnabled(true);
            this.modifyButton.setEnabled(true);
            this.delButton.setEnabled(true);
            this.okButton.requestFocus(true);
        } else {
            this.okButton.setEnabled(false);
            this.modifyButton.setEnabled(false);
            this.delButton.setEnabled(false);
            this.cancelButton.requestFocus(true);
        }
    }

    public static PersistenceHandlerInterface getPersistenceHandler() {
        return persistenceHandler;
    }

    public static void setPersistenceHandler(PersistenceHandlerInterface persistenceHandlerInterface) {
        persistenceHandler = persistenceHandlerInterface;
    }

    public static Object getPersistenceLoaction() {
        return persistenceLoaction;
    }

    public static void setPersistenceLoaction(Object object) {
        persistenceLoaction = object;
    }
}

