/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.windowmanagement.windowtabbed;

import com.swimap.iview.framework.windowmanagement.windowtabbed.WindowTabbedConstants;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

class WindowTabbedUtil
implements WindowTabbedConstants {
    private static FontMetrics metrics = null;
    private static final String SUFFIX = "...";

    WindowTabbedUtil() {
    }

    static int calculateTabHeight() {
        FontMetrics fontMetrics = WindowTabbedUtil.getFontMetrics();
        int n = fontMetrics.getHeight();
        int n2 = n + 3 + 1 + 2 + 2 + 1;
        if (n2 < 24) {
            n2 = 24;
        }
        return n2;
    }

    static FontMetrics getFontMetrics() {
        if (metrics == null) {
            Graphics2D graphics2D = new BufferedImage(10, 10, 2).createGraphics();
            metrics = graphics2D.getFontMetrics(TAB_TEXT_FONT);
        }
        return metrics;
    }

    static String getAbbreviatoryString(String string, int n) {
        if (string == null) {
            throw new IllegalArgumentException("original can not be null.");
        }
        if (n < 0) {
            throw new IllegalArgumentException("length can not be less than 0.");
        }
        FontMetrics fontMetrics = WindowTabbedUtil.getFontMetrics();
        int n2 = fontMetrics.stringWidth(string);
        if (n2 <= n) {
            return string;
        }
        int n3 = string.length();
        int n4 = 0;
        while (fontMetrics.stringWidth(string.substring(0, n4)) + fontMetrics.stringWidth(SUFFIX) <= n && ++n4 <= n3) {
        }
        return string.substring(0, n4 - 1) + SUFFIX;
    }
}

