/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.windowmanagement.windowtabbed;

import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.framework.windowmanagement.InternalFrame;
import com.swimap.iview.framework.windowmanagement.windowtabbed.WindowTabbedConstants;
import com.swimap.iview.framework.windowmanagement.windowtabbed.WindowTabbedPane;
import com.swimap.iview.framework.windowmanagement.windowtabbed.WindowTabbedScrollPane;
import com.swimap.iview.templates.utils.ScrollPopupMenu;
import com.swimap.iview.util.ScreenToolKit;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ScrollPaneUI;

public class WindowTabbedPaneUI
extends ScrollPaneUI
implements WindowTabbedConstants {
    private ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/framework/windowmanagement/windowtabmenu/Res");
    private JButton rightArrow = null;
    private JButton leftArrow = null;
    private JButton downArrow = null;
    static final int MAXTITLELENGTH = 50;
    private ScrollPopupMenu popUpList = null;
    private WindowTabbedPane tabPane = null;
    private ScrollButtonMouseListener rightScrollListener = null;
    private ScrollButtonMouseListener leftScrollListener = null;
    private ScrollButtonListener rightButtonlistener = null;
    private ScrollButtonListener leftButtonlistener = null;
    private ScrollButtonListener downButtonlistener = null;

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowTabbedPaneUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.tabPane = (WindowTabbedPane)jComponent;
        this.initButtons();
        jComponent.add(this.downArrow);
        jComponent.add(this.leftArrow);
        jComponent.add(this.rightArrow);
        this.leftArrow.setVisible(false);
        this.rightArrow.setVisible(false);
        this.tabPane.getViewport().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                JViewport jViewport = WindowTabbedPaneUI.this.tabPane.getViewport();
                Rectangle rectangle = jViewport.getBounds();
                int n = jViewport.getViewPosition().x;
                WindowTabbedScrollPane windowTabbedScrollPane = WindowTabbedPaneUI.this.tabPane.getScrollPane();
                Rectangle rectangle2 = windowTabbedScrollPane.getBounds();
                WindowTabbedPaneUI.this.downArrow.setEnabled(true);
                if (n <= 0) {
                    WindowTabbedPaneUI.this.leftArrow.setEnabled(false);
                } else {
                    WindowTabbedPaneUI.this.leftArrow.setEnabled(true);
                }
                if (n + rectangle.width >= rectangle2.width) {
                    WindowTabbedPaneUI.this.rightArrow.setEnabled(false);
                } else {
                    WindowTabbedPaneUI.this.rightArrow.setEnabled(true);
                }
            }
        });
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.rightArrow.removeMouseListener(this.rightScrollListener);
        this.leftArrow.removeMouseListener(this.leftScrollListener);
        this.rightArrow.removeActionListener(this.rightButtonlistener);
        this.leftArrow.removeActionListener(this.leftButtonlistener);
        this.downArrow.removeActionListener(this.downButtonlistener);
        jComponent.remove(this.downArrow);
        jComponent.remove(this.leftArrow);
        jComponent.remove(this.rightArrow);
        this.rightArrow = null;
        this.leftArrow = null;
        this.downArrow = null;
        ChangeListener[] changeListenerArray = this.tabPane.getViewport().getChangeListeners();
        for (int i = 0; i < changeListenerArray.length; ++i) {
            this.tabPane.getViewport().removeChangeListener(changeListenerArray[i]);
        }
    }

    private void initButtons() {
        Border border = BorderFactory.createEtchedBorder(1);
        this.rightButtonlistener = new ScrollButtonListener();
        this.rightArrow = new JButton();
        this.rightArrow.setName("right");
        this.rightArrow.addActionListener(this.rightButtonlistener);
        this.rightScrollListener = new ScrollButtonMouseListener(this.rightArrow);
        this.rightArrow.addMouseListener(this.rightScrollListener);
        ImageIcon imageIcon = (ImageIcon)ResourceMng.getInstance().getIcon("RightIcon", false);
        if (imageIcon == null) {
            imageIcon = new ImageIcon(this.getClass().getResource("right.gif"));
        }
        this.rightArrow.setIcon(imageIcon);
        this.leftButtonlistener = new ScrollButtonListener();
        this.rightArrow.setBorder(border);
        this.leftArrow = new JButton();
        this.leftArrow.setName("left");
        this.leftArrow.addActionListener(this.leftButtonlistener);
        this.leftScrollListener = new ScrollButtonMouseListener(this.leftArrow);
        this.leftArrow.addMouseListener(this.leftScrollListener);
        ImageIcon imageIcon2 = (ImageIcon)ResourceMng.getInstance().getIcon("LeftIcon", false);
        if (imageIcon2 == null) {
            imageIcon2 = new ImageIcon(this.getClass().getResource("left.gif"));
        }
        this.leftArrow.setIcon(imageIcon2);
        this.leftArrow.setBorder(border);
        this.downButtonlistener = new ScrollButtonListener();
        this.downArrow = new JButton();
        this.downArrow.setName("down");
        this.downArrow.addActionListener(this.downButtonlistener);
        ImageIcon imageIcon3 = (ImageIcon)ResourceMng.getInstance().getIcon("DownIcon", false);
        if (imageIcon3 == null) {
            imageIcon3 = new ImageIcon(this.getClass().getResource("down.gif"));
        }
        this.downArrow.setIcon(imageIcon3);
        this.downArrow.setToolTipText(this.res.getString("TabList"));
        this.downArrow.setBorder(border);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        Rectangle rectangle = jComponent.getBounds();
        Color color = graphics.getColor();
        graphics.setColor(COLOR_BACKGROUND_SELECTED);
        graphics.fillRect(rectangle.x, rectangle.height - 4, rectangle.width, 4);
        graphics.setColor(new JLabel().getBackground());
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height - 4);
        graphics.setColor(COLOR_BORDER_LIGHT);
        graphics.drawLine(rectangle.x, rectangle.y + rectangle.height - 1 - 4, rectangle.x + rectangle.width, rectangle.y + rectangle.height - 1 - 4);
        graphics.setColor(color);
        graphics.setColor(COLOR_BORDER_LIGHT);
        graphics.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width, rectangle.y + rectangle.height - 1);
        graphics.setColor(color);
    }

    void popUpMenu() {
        this.popUpList = new ScrollPopupMenu();
        this.popUpList.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                if (null != WindowTabbedPaneUI.this.popUpList) {
                    WindowTabbedPaneUI.this.popUpList.removePopupMenuListener(this);
                    WindowTabbedPaneUI.this.popUpList.removeAll();
                }
                WindowTabbedPaneUI.this.popUpList = null;
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }
        });
        int n = 0;
        Set set = FrameworkUtilities.getWindowManager().getInternalFrameStore().keySet();
        Object[] objectArray = new Integer[set.size()];
        set.toArray(objectArray);
        Arrays.sort(objectArray);
        InternalFrame[] internalFrameArray = new InternalFrame[set.size()];
        for (int i = objectArray.length - 1; i >= 0; --i) {
            InternalFrame internalFrame = FrameworkUtilities.getWindowManager().getWindow((Integer)objectArray[i]);
            if (FrameworkUtilities.getWindowManager().hiddenFrameList(internalFrame)) continue;
            internalFrameArray[n] = internalFrame;
            ++n;
        }
        this.createMenuItem(internalFrameArray);
        MouseEvent mouseEvent = new MouseEvent(this.downArrow, 500, 0L, 0, 0, this.downArrow.getHeight(), 0, true);
        ScreenToolKit.showPopupMenu(this.popUpList, mouseEvent);
    }

    void createMenuItem(InternalFrame[] internalFrameArray) {
        JMenuItem jMenuItem = null;
        Font font = null;
        for (int i = internalFrameArray.length - 1; i >= 0; --i) {
            if (null == internalFrameArray[i]) continue;
            jMenuItem = new JMenuItem(internalFrameArray[i].getTitle());
            font = jMenuItem.getFont();
            final InternalFrame internalFrame = internalFrameArray[i];
            if (FrameworkUtilities.getWindowManager().getActiveWindowId() == internalFrameArray[i].getWindowId()) {
                jMenuItem.setFont(new Font(font.getFontName(), 1, font.getSize()));
            } else {
                jMenuItem.setFont(new Font(font.getFontName(), 0, font.getSize()));
            }
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    WindowTabbedPaneUI.this.onClick(internalFrame);
                }
            });
            if (jMenuItem.getText().length() > 50) {
                String string = internalFrameArray[i].getTitle();
                jMenuItem.setText(string.substring(0, 47).concat("..."));
                jMenuItem.setToolTipText(string);
            }
            this.popUpList.add(jMenuItem);
        }
    }

    void onClick(InternalFrame internalFrame) {
        if (internalFrame != null && (!internalFrame.isSelected() || internalFrame.isIcon())) {
            JInternalFrame jInternalFrame;
            if (internalFrame.isIcon()) {
                internalFrame.setIcon(false);
            }
            if ((jInternalFrame = FrameworkUtilities.getWindowManager().getDesktopPane().getNextMaximizableInternalFrame()) != null && jInternalFrame.isMaximum()) {
                internalFrame.setMaximum(true);
            }
            internalFrame.setSelected(true);
        }
    }

    private void scrollToRightByOneUnit() {
        JViewport jViewport = this.tabPane.getViewport();
        Rectangle rectangle = jViewport.getBounds();
        Point point = jViewport.getViewPosition();
        int n = point.x;
        WindowTabbedScrollPane windowTabbedScrollPane = this.tabPane.getScrollPane();
        Rectangle rectangle2 = windowTabbedScrollPane.getBounds();
        if (n + rectangle.width < rectangle2.width) {
            int n2 = windowTabbedScrollPane.getComponentCount();
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                Component component = windowTabbedScrollPane.getComponent(i);
                Rectangle rectangle3 = component.getBounds();
                if ((n3 += rectangle3.width) <= n) continue;
                if (n3 + rectangle.width < rectangle2.width) {
                    n = n3;
                    break;
                }
                n = rectangle2.width - rectangle.width;
                break;
            }
            point.x = n;
            jViewport.setViewPosition(point);
            windowTabbedScrollPane.updateUI();
        }
    }

    private void scrollToLeftByOneUnit() {
        JViewport jViewport = this.tabPane.getViewport();
        Point point = jViewport.getViewPosition();
        int n = point.x;
        WindowTabbedScrollPane windowTabbedScrollPane = this.tabPane.getScrollPane();
        if (n > 0) {
            int n2 = windowTabbedScrollPane.getComponentCount();
            int n3 = 0;
            int n4 = 0;
            for (int i = 0; i < n2; ++i) {
                Component component = windowTabbedScrollPane.getComponent(i);
                Rectangle rectangle = component.getBounds();
                if ((n3 += rectangle.width) >= n) {
                    point.x = n = n4;
                    jViewport.setViewPosition(point);
                    windowTabbedScrollPane.updateUI();
                    break;
                }
                n4 = n3;
            }
        }
    }

    private class ScrollButtonMouseListener
    extends MouseAdapter {
        private static final int START_TIME = 1000;
        private static final int STEP_TIME = 100;
        private Timer startTimer = new Timer();
        private Timer scrollTimer = new Timer();
        private JButton button = null;
        private boolean scrollStart = false;
        private boolean pressStart = false;

        ScrollButtonMouseListener(JButton jButton) {
            this.button = jButton;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.pressStart = true;
            this.startTimer = new Timer();
            this.startTimer.schedule(this.createStartTask(), 1000L);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.cancelTimer();
        }

        private void cancelTimer() {
            if (this.pressStart) {
                this.startTimer.cancel();
                this.pressStart = false;
            }
            if (this.scrollStart) {
                this.scrollTimer.cancel();
                this.scrollStart = false;
            }
        }

        private TimerTask createStartTask() {
            TimerTask timerTask = new TimerTask(){

                @Override
                public void run() {
                    ScrollButtonMouseListener.this.scrollStart = true;
                    ScrollButtonMouseListener.this.scrollTimer = new Timer();
                    ScrollButtonMouseListener.this.scrollTimer.schedule(ScrollButtonMouseListener.this.createScrollTask(), 0L, 100L);
                }
            };
            return timerTask;
        }

        private TimerTask createScrollTask() {
            TimerTask timerTask = new TimerTask(){

                @Override
                public void run() {
                    if (!ScrollButtonMouseListener.this.button.isEnabled()) {
                        ScrollButtonMouseListener.this.cancelTimer();
                        return;
                    }
                    if (ScrollButtonMouseListener.this.button.getName().equals("right")) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                WindowTabbedPaneUI.this.scrollToRightByOneUnit();
                            }
                        });
                    } else {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                WindowTabbedPaneUI.this.scrollToLeftByOneUnit();
                            }
                        });
                    }
                }
            };
            return timerTask;
        }
    }

    private class ScrollButtonListener
    implements ActionListener {
        private ScrollButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == WindowTabbedPaneUI.this.rightArrow) {
                WindowTabbedPaneUI.this.scrollToRightByOneUnit();
            } else if (actionEvent.getSource() == WindowTabbedPaneUI.this.downArrow) {
                WindowTabbedPaneUI.this.popUpMenu();
            } else {
                WindowTabbedPaneUI.this.scrollToLeftByOneUnit();
            }
        }
    }
}

