/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.windowmanagement.windowtabbed;

import com.swimap.iview.framework.windowmanagement.InternalFrame;
import com.swimap.iview.framework.windowmanagement.windowtabbed.WindowTabbedConstants;
import com.swimap.iview.framework.windowmanagement.windowtabbed.WindowTabbedItem;
import com.swimap.iview.framework.windowmanagement.windowtabbed.WindowTabbedPaneLayout;
import com.swimap.iview.framework.windowmanagement.windowtabbed.WindowTabbedPaneUI;
import com.swimap.iview.framework.windowmanagement.windowtabbed.WindowTabbedScrollPane;
import com.swimap.iview.framework.windowmanagement.windowtabbed.WindowTabbedUtil;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import javax.swing.DefaultSingleSelectionModel;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.SingleSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class WindowTabbedPane
extends JComponent
implements WindowTabbedConstants {
    private JViewport viewport = new JViewport();
    private WindowTabbedScrollPane page = new WindowTabbedScrollPane();
    private SingleSelectionModel singleSelectionModel = null;
    private ArrayList pageList = new ArrayList(10);
    private int height = WindowTabbedUtil.calculateTabHeight() + 4;
    private static final String UIClassID = "WindowTabbedPaneUI";
    private HashMap entries = new HashMap();

    @Override
    public String getUIClassID() {
        return UIClassID;
    }

    @Override
    public WindowTabbedPaneUI getUI() {
        return (WindowTabbedPaneUI)this.ui;
    }

    public void setUI(WindowTabbedPaneUI windowTabbedPaneUI) {
        super.setUI(windowTabbedPaneUI);
    }

    @Override
    public void updateUI() {
        this.setUI((WindowTabbedPaneUI)UIManager.getUI(this));
    }

    public WindowTabbedPane() {
        this.singleSelectionModel = this.createSelectionModel();
        this.setLayout(new WindowTabbedPaneLayout());
        this.setName("WindowTabbedPane");
        this.viewport.setName("viewport");
        this.viewport.setView(this.page);
        this.add(this.viewport);
        this.viewport.setOpaque(false);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                WindowTabbedPane.this.scrollToSelectedTab();
            }
        });
        this.updateUI();
    }

    private SingleSelectionModel createSelectionModel() {
        DefaultSingleSelectionModel defaultSingleSelectionModel = new DefaultSingleSelectionModel();
        defaultSingleSelectionModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                WindowTabbedPane.this.page.repaint();
            }
        });
        return defaultSingleSelectionModel;
    }

    public void selectTab(final WindowTabbedItem windowTabbedItem) {
        int n = this.pageList.indexOf(windowTabbedItem);
        this.singleSelectionModel.setSelectedIndex(n);
        if (null != windowTabbedItem) {
            windowTabbedItem.setSelected();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WindowTabbedPane.this.scrollRectToVisible(windowTabbedItem);
            }
        });
    }

    public void addTab(WindowTabbedItem windowTabbedItem) {
        if (windowTabbedItem == null) {
            return;
        }
        this.pageList.add(windowTabbedItem);
        this.page.add(windowTabbedItem);
        int n = this.pageList.size();
        if (n > 1) {
            WindowTabbedItem windowTabbedItem2 = (WindowTabbedItem)this.pageList.get(n - 2);
            Rectangle rectangle = windowTabbedItem2.getBounds();
            if (windowTabbedItem.getBounds().x <= rectangle.x) {
                windowTabbedItem.setLocation(rectangle.x + rectangle.width, rectangle.y);
            }
        }
        windowTabbedItem.updateUI();
    }

    public void removeTab(WindowTabbedItem windowTabbedItem) {
        if (windowTabbedItem == null) {
            return;
        }
        int n = this.singleSelectionModel.getSelectedIndex();
        WindowTabbedItem windowTabbedItem2 = null;
        if (n >= 0) {
            windowTabbedItem2 = (WindowTabbedItem)this.pageList.get(n);
        }
        this.pageList.remove(windowTabbedItem);
        this.page.remove(windowTabbedItem);
        if (windowTabbedItem2 != windowTabbedItem) {
            this.selectTab(windowTabbedItem2);
        }
        this.page.updateUI();
    }

    void addEntry(InternalFrame internalFrame, WindowTabbedItem windowTabbedItem) {
        this.entries.put(internalFrame.getWindowId(), windowTabbedItem);
    }

    void removeEntry(int n) {
        this.entries.remove(n);
    }

    public HashMap getEntries() {
        return this.entries;
    }

    public void hideTab(int n) {
        WindowTabbedItem windowTabbedItem = (WindowTabbedItem)this.entries.get(n);
        windowTabbedItem.setVisible(false);
        this.pageList.remove(windowTabbedItem);
    }

    public void showTab(int n) {
        WindowTabbedItem windowTabbedItem = (WindowTabbedItem)this.entries.get(n);
        windowTabbedItem.setVisible(true);
        this.pageList.add(windowTabbedItem);
    }

    public boolean isSelected(WindowTabbedItem windowTabbedItem) {
        int n;
        if (windowTabbedItem == null) {
            return false;
        }
        int n2 = this.singleSelectionModel.getSelectedIndex();
        return n2 == (n = this.pageList.indexOf(windowTabbedItem));
    }

    private void scrollRectToVisible(WindowTabbedItem windowTabbedItem) {
        if (windowTabbedItem == null) {
            return;
        }
        Rectangle rectangle = windowTabbedItem.getBounds();
        Point point = this.viewport.getViewPosition();
        int n = point.x;
        if (n > rectangle.x) {
            point.x = rectangle.x;
            this.viewport.setViewPosition(point);
        }
        if (n + this.viewport.getBounds().width < rectangle.x + rectangle.width) {
            point.x = n + (rectangle.x - n - this.viewport.getBounds().width) + rectangle.width;
            this.viewport.setViewPosition(point);
        }
    }

    WindowTabbedScrollPane getScrollPane() {
        return this.page;
    }

    JViewport getViewport() {
        return this.viewport;
    }

    int calcRealWidth() {
        int n = 0;
        int n2 = this.pageList.size();
        WindowTabbedItem windowTabbedItem = null;
        for (int i = 0; i < n2; ++i) {
            windowTabbedItem = (WindowTabbedItem)this.pageList.get(i);
            n += windowTabbedItem.getRealWidth();
        }
        return n;
    }

    int calcMinimumWidth() {
        int n = 0;
        int n2 = this.pageList.size();
        WindowTabbedItem windowTabbedItem = null;
        for (int i = 0; i < n2; ++i) {
            windowTabbedItem = (WindowTabbedItem)this.pageList.get(i);
            n += windowTabbedItem.getRealWidth() > 100 ? 100 : windowTabbedItem.getRealWidth();
        }
        return n;
    }

    void setMinimumSize() {
        int n = this.pageList.size();
        Hashtable<WindowTabbedItem, Integer> hashtable = new Hashtable<WindowTabbedItem, Integer>(16);
        float f = 100.0f;
        float f2 = 100.0f;
        while ((f2 = (float)((int)f)) != (float)((int)(f = this.populateAvgMap(f, hashtable)))) {
        }
        float f3 = (int)((f - (float)((int)f)) * 10.0f);
        WindowTabbedItem windowTabbedItem = null;
        Integer n2 = null;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            windowTabbedItem = (WindowTabbedItem)this.pageList.get(i);
            n2 = hashtable.get(windowTabbedItem);
            n3 = windowTabbedItem.getSize().height;
            if (null != n2) {
                windowTabbedItem.setSize(n2, n3);
                continue;
            }
            windowTabbedItem.setSize((int)(f + f3), n3);
            f3 = 0.0f;
        }
    }

    private float populateAvgMap(float f, Hashtable<WindowTabbedItem, Integer> hashtable) {
        int n;
        int n2 = this.pageList.size();
        WindowTabbedItem windowTabbedItem = null;
        int n3 = 0;
        int n4 = 0;
        for (n = 0; n < n2; ++n) {
            windowTabbedItem = (WindowTabbedItem)this.pageList.get(n);
            int n5 = windowTabbedItem.getRealWidth();
            if (!((float)n5 <= f)) continue;
            if (!hashtable.contains(windowTabbedItem)) {
                hashtable.put(windowTabbedItem, n5);
            }
            ++n3;
            n4 += n5;
        }
        n = Math.abs(n2 - n3);
        float f2 = f;
        if (n != 0) {
            int n6 = this.getViewport().getBounds().width - n4;
            f2 = Math.max(100.0f, (float)n6 / (float)n);
        }
        return f2;
    }

    void setRealSize() {
        int n = this.pageList.size();
        WindowTabbedItem windowTabbedItem = null;
        for (int i = 0; i < n; ++i) {
            windowTabbedItem = (WindowTabbedItem)this.pageList.get(i);
            if (windowTabbedItem.getRealWidth() < 100) continue;
            Dimension dimension = windowTabbedItem.getSize();
            windowTabbedItem.setSize(windowTabbedItem.getRealWidth(), dimension.height);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.height = this.height;
        return dimension;
    }

    public void selectNextTab(boolean bl) {
        int n = this.singleSelectionModel.getSelectedIndex();
        WindowTabbedItem windowTabbedItem = null;
        if (n >= 0) {
            if (bl) {
                try {
                    windowTabbedItem = (WindowTabbedItem)this.pageList.get(n + 1);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    windowTabbedItem = (WindowTabbedItem)this.pageList.get(0);
                }
            } else {
                try {
                    windowTabbedItem = (WindowTabbedItem)this.pageList.get(n - 1);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    windowTabbedItem = (WindowTabbedItem)this.pageList.get(this.pageList.size() - 1);
                }
            }
            this.selectTab(windowTabbedItem);
        }
    }

    private void scrollToSelectedTab() {
        final int n = this.singleSelectionModel.getSelectedIndex();
        if (n >= 0 && this.pageList.size() > n) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WindowTabbedPane.this.scrollRectToVisible((WindowTabbedItem)WindowTabbedPane.this.pageList.get(n));
                }
            });
        }
    }

    static {
        UIManager.put(UIClassID, "com.swimap.iview.framework.windowmanagement.windowtabbed.WindowTabbedPaneUI");
    }
}

