/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.windowmanagement.windowtabbed;

import com.swimap.iview.commstyle.commandmng.CommandManager;
import com.swimap.iview.commstyle.commini.AreaDescContainer;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.commini.xmlbind.PARA;
import com.swimap.iview.framework.applicationmanagement.ApplicationLauncher;
import com.swimap.iview.framework.applicationmanagement.ApplicationManager;
import com.swimap.iview.framework.applicationmanagement.gui.AppRoundButton;
import com.swimap.iview.framework.mainframe.MDIFrame;
import com.swimap.iview.framework.modulemanagement.BaseModule;
import com.swimap.iview.framework.modulemanagement.ModuleManagementException;
import com.swimap.iview.framework.modulemanagement.ModuleManager;
import com.swimap.iview.framework.subsystemmanagement.SubsystemManager;
import com.swimap.iview.framework.util.FrameworkCommandProcessor;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.framework.windowmanagement.InternalFrame;
import com.swimap.iview.framework.windowmanagement.windowtabbed.TabActionListener;
import com.swimap.iview.framework.windowmanagement.windowtabbed.WindowTabMenuSupport;
import com.swimap.iview.framework.windowmanagement.windowtabbed.WindowTabbedItem;
import com.swimap.iview.framework.windowmanagement.windowtabbed.WindowTabbedPane;
import com.swimap.iview.util.TypeConverter;
import com.swimap.iview.util.log.IviewLogger;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class WindowTabbedManager
extends BaseModule {
    private static IviewLogger logger = IviewLogger.getLogger(WindowTabbedManager.class, "IVIEW");
    private String moduleName = "mainwindowtabbedmanager";
    private CommStyleInfo configInfo = null;
    public static final String FILE_NAME = "conf/mainfrm/windowtab";
    private static final String ATTRIBUTE_ENABLE = "enableTabbedBar";
    private static final String ATTRIBUTE_SHOWBAR = "isTabbedBarVisible";
    private static final String ATTRIBUTE_SHOWICON = "isShowWindowTabIcon";
    private static final String COMMANDID = "iview mfrm toggle windowtabbedbar";
    private static final boolean DEFAULT_TABEDBAR_ENABLE = false;
    private static final boolean DEFAULT_TABEDBAR_VISIBLE = true;
    private static final boolean DEFAULT_TABICON_VISIBLE = true;
    private boolean tabbedBarEnable = false;
    private boolean tabbedBarVisible = true;
    private boolean defaultTabIconVisible = true;
    private WindowTabbedPane tabbedbar = null;
    private ArrayList menus = null;
    private final String TABMENU_CONFIG_PATH = "conf/mainfrm/windowtabmenu";
    private static final boolean DEFAULT_TABMENU_SETTING = true;

    public WindowTabbedManager(ModuleManager moduleManager) throws ModuleManagementException {
        super(moduleManager);
        this.register(this);
    }

    @Override
    public void reinitialize() {
        boolean bl = this.getTabMenuSetting();
        WindowTabMenuSupport.setTabMenuEnabled(bl);
        this.configInfo = this.readConfigInfo();
        if (this.configInfo == null) {
            logger.debug("CommStyleInfo is null,tab is disabled.");
        } else if (SubsystemManager.getInstance().isHideTabbedbar()) {
            this.tabbedBarEnable = false;
            this.tabbedBarVisible = false;
        } else {
            this.tabbedBarEnable = this.getBooleanValue(this.configInfo, ATTRIBUTE_ENABLE, this.tabbedBarEnable);
            this.tabbedBarVisible = this.getBooleanValue(this.configInfo, ATTRIBUTE_SHOWBAR, this.tabbedBarVisible);
            this.defaultTabIconVisible = this.getBooleanValue(this.configInfo, ATTRIBUTE_SHOWICON, true);
        }
        logger.debug("tabbedBarEnable:" + this.tabbedBarEnable + " | tabbedBarVisible:" + this.tabbedBarVisible);
        this.menus = this.getMenu();
        if (this.tabbedBarEnable) {
            if (this.tabbedbar == null) {
                this.tabbedbar = new WindowTabbedPane();
            }
            ((MDIFrame)FrameworkUtilities.getMainFrame()).showWindowTabbedBar(this.tabbedBarVisible);
            this.setMenuSelected(this.tabbedBarVisible);
        } else {
            this.setMenuEnabled(false);
            this.setMenuSelected(false);
        }
    }

    public WindowTabbedPane getTabbedBar() {
        return this.tabbedbar;
    }

    public void toggleTabbedBarVisible() {
        logger.debug("tabbedBarVisible before:" + this.tabbedBarVisible);
        if (!this.tabbedBarEnable) {
            logger.debug("WindowTabbedManager is disabled.");
            return;
        }
        this.tabbedBarVisible = !this.tabbedBarVisible;
        this.setBooleanValue(this.configInfo, ATTRIBUTE_SHOWBAR, this.tabbedBarVisible);
        this.writeConfigInfo(this.configInfo);
        MDIFrame mDIFrame = (MDIFrame)FrameworkUtilities.getMainFrame();
        mDIFrame.showWindowTabbedBar(this.tabbedBarVisible);
        this.setMenuSelected(this.tabbedBarVisible);
        logger.debug("tabbedBarVisible after:" + this.tabbedBarVisible);
    }

    @Override
    public String getModuleName() {
        return this.moduleName;
    }

    public boolean isTabbedBarEnable() {
        return this.tabbedBarEnable;
    }

    public void addTab(final InternalFrame internalFrame) {
        if (!this.tabbedBarEnable) {
            return;
        }
        if (internalFrame == null) {
            return;
        }
        final WindowTabbedItem windowTabbedItem = new WindowTabbedItem(internalFrame.getTitle(), internalFrame.getFrameIcon(), internalFrame.isClosable(), this.tabbedbar);
        windowTabbedItem.setCloseIconEnable(!internalFrame.isBusy());
        WindowTabMenuSupport.registerForTabMenu(windowTabbedItem);
        if (internalFrame.getName() != null) {
            windowTabbedItem.setName(internalFrame.getName());
        }
        final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                try {
                    Boolean bl;
                    if ("title".equals(propertyChangeEvent.getPropertyName())) {
                        windowTabbedItem.setTitle((String)propertyChangeEvent.getNewValue());
                        if (WindowTabbedManager.this.tabbedbar.isSelected(windowTabbedItem)) {
                            WindowTabbedManager.this.tabbedbar.selectTab(windowTabbedItem);
                        }
                    }
                    if ("frameIcon".equals(propertyChangeEvent.getPropertyName())) {
                        windowTabbedItem.setTabIcon((Icon)propertyChangeEvent.getNewValue());
                        if (WindowTabbedManager.this.tabbedbar.isSelected(windowTabbedItem)) {
                            WindowTabbedManager.this.tabbedbar.selectTab(windowTabbedItem);
                        }
                    }
                    if ("closable".equals(propertyChangeEvent.getPropertyName())) {
                        bl = (Boolean)propertyChangeEvent.getNewValue();
                        windowTabbedItem.setClosable(bl);
                        if (WindowTabbedManager.this.tabbedbar.isSelected(windowTabbedItem)) {
                            WindowTabbedManager.this.tabbedbar.selectTab(windowTabbedItem);
                        }
                    }
                    if ("isBusy".equals(propertyChangeEvent.getPropertyName())) {
                        bl = (Boolean)propertyChangeEvent.getNewValue();
                        windowTabbedItem.setCloseIconEnable(bl == false);
                    }
                }
                catch (Exception exception) {
                    logger.trace(exception.getMessage(), exception);
                }
            }
        };
        internalFrame.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
                InternalFrame internalFrame2 = (InternalFrame)internalFrameEvent.getSource();
                if (!internalFrame2.isIcon()) {
                    WindowTabbedManager.this.tabbedbar.selectTab(windowTabbedItem);
                }
                if (FrameworkCommandProcessor.getInstance().isAppStyle()) {
                    String string = internalFrame2.getAppID();
                    ApplicationManager.getInstance().getApplication(string).invokeActivationDeactivationCallback(string);
                    ApplicationLauncher.getAppLauncher().updateMDIFrame(string);
                    FrameworkUtilities.getWindowManager().updateActiveApPFrame(string, internalFrame2);
                }
                ((MDIFrame)FrameworkUtilities.getMainFrame()).updateCoolbar(internalFrame.getWindowId(), internalFrame.isMaximum());
            }

            @Override
            public void internalFrameDeiconified(InternalFrameEvent internalFrameEvent) {
                WindowTabbedManager.this.tabbedbar.selectTab(windowTabbedItem);
            }

            @Override
            public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
                WindowTabbedManager.this.tabbedbar.removeEntry(internalFrame.getWindowId());
                WindowTabMenuSupport.unregisterForTabMenu(windowTabbedItem);
                WindowTabbedManager.this.tabbedbar.removeTab(windowTabbedItem);
                internalFrame.removeInternalFrameListener(this);
                internalFrame.removePropertyChangeListener(propertyChangeListener);
                logger.debug("A tab for frame[" + internalFrame.getTitle() + "] is removed.");
            }

            @Override
            public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
                WindowTabbedManager.this.tabbedbar.selectTab(null);
            }

            @Override
            public void internalFrameIconified(InternalFrameEvent internalFrameEvent) {
                if (FrameworkUtilities.getWindowManager().getActiveWindow() == null) {
                    WindowTabbedManager.this.tabbedbar.selectTab(null);
                }
            }

            @Override
            public void internalFrameOpened(InternalFrameEvent internalFrameEvent) {
                if (FrameworkCommandProcessor.getInstance().isAppStyle()) {
                    InternalFrame internalFrame2 = (InternalFrame)internalFrameEvent.getSource();
                    String string = internalFrame2.getAppID();
                    FrameworkUtilities.getWindowManager().updateActiveApPFrame(string, internalFrame2);
                }
            }
        });
        windowTabbedItem.addTabActionListener(new TabActionListener(){

            @Override
            public void tabClosing() {
                internalFrame.closeWindow();
                if (FrameworkCommandProcessor.getInstance().isAppStyle() && WindowTabbedManager.this.tabbedbar.getEntries().size() == 0) {
                    AppRoundButton.getInstance().requestFocus();
                }
            }

            @Override
            public void tabSelected() {
                FrameworkUtilities.getWindowManager().activateWindow(internalFrame.getWindowId());
            }
        });
        internalFrame.addPropertyChangeListener(propertyChangeListener);
        this.tabbedbar.addTab(windowTabbedItem);
        this.tabbedbar.addEntry(internalFrame, windowTabbedItem);
        logger.debug("A tab for frame[" + internalFrame.getTitle() + "] is added.");
    }

    public void dispose() {
        if (this.tabbedBarEnable && this.tabbedBarVisible) {
            MDIFrame mDIFrame = (MDIFrame)FrameworkUtilities.getMainFrame();
            mDIFrame.showWindowTabbedBar(false);
        }
        this.configInfo = null;
        this.tabbedbar = null;
        this.menus = null;
        this.tabbedBarEnable = false;
        this.tabbedBarVisible = true;
    }

    private ArrayList getMenu() {
        return CommandManager.getInstance().getAbstractButton(COMMANDID);
    }

    private void setMenuSelected(boolean bl) {
        if (this.menus == null) {
            return;
        }
        int n = this.menus.size();
        for (int i = 0; i < n; ++i) {
            ((AbstractButton)this.menus.get(i)).setSelected(bl);
        }
    }

    private void setMenuEnabled(boolean bl) {
        if (this.menus == null) {
            return;
        }
        int n = this.menus.size();
        for (int i = 0; i < n; ++i) {
            ((AbstractButton)this.menus.get(i)).setEnabled(bl);
        }
    }

    private CommStyleInfo readConfigInfo() {
        try {
            CommStyleInfo commStyleInfo = CommStyleManager.getInstance().getCommonStyleFile(FILE_NAME);
            return commStyleInfo;
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
            return null;
        }
    }

    private void writeConfigInfo(CommStyleInfo commStyleInfo) {
        try {
            CommStyleManager.getInstance().writeToUser(commStyleInfo);
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
    }

    private boolean getBooleanValue(CommStyleInfo commStyleInfo, String string, boolean bl) {
        try {
            AreaDescContainer areaDescContainer = commStyleInfo.getAreaDescContainer(0);
            DescContainer descContainer = areaDescContainer.getDescContainer(0);
            PARA pARA = descContainer.getParasItem(string);
            if (null != pARA) {
                String string2 = pARA.getValue();
                return Boolean.valueOf(string2);
            }
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
        return bl;
    }

    private void setBooleanValue(CommStyleInfo commStyleInfo, String string, boolean bl) {
        if (commStyleInfo == null) {
            logger.debug("CommStyleInfo is null.");
            return;
        }
        try {
            commStyleInfo.getAreaDescContainer(0).getDescContainer(0).getParasItem(string).setValue(String.valueOf(bl));
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
    }

    private boolean getTabMenuSetting() {
        boolean bl = true;
        try {
            CommStyleInfo commStyleInfo = CommStyleManager.getInstance().getUserProductDefaultCommonStyleFile("conf/mainfrm/windowtabmenu");
            DescContainer descContainer = commStyleInfo.getAreaDescContainer(0).getDescContainer("tabMenuSetting");
            bl = (Boolean)TypeConverter.getParameter(descContainer.getParasItemValue("tabMenuEnable"), Boolean.class);
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
        return bl;
    }

    public static boolean getTabMenuEnabled() {
        return WindowTabMenuSupport.getTabMenuEnabled();
    }

    public boolean isDefaultTabIconVisible() {
        return this.defaultTabIconVisible;
    }
}

