/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.windowmanagement.windowtabbed;

import com.swimap.iview.commstyle.resource.i18n.ResourceUtil;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.framework.windowmanagement.WindowManager;
import com.swimap.iview.framework.windowmanagement.navigation.NavigationHistory;
import com.swimap.iview.framework.windowmanagement.windowtabbed.WindowTabbedConstants;
import com.swimap.iview.framework.windowmanagement.windowtabbed.WindowTabbedItem;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;

public class WindowTabbedItemUI
extends ComponentUI
implements WindowTabbedConstants {
    private MouseListener tabMouseListener = null;

    @Override
    public void installUI(JComponent jComponent) {
        WindowTabbedItem windowTabbedItem = (WindowTabbedItem)jComponent;
        this.installListeners(windowTabbedItem);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        WindowTabbedItem windowTabbedItem = (WindowTabbedItem)jComponent;
        windowTabbedItem.removeMouseListener(this.tabMouseListener);
        this.tabMouseListener = null;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowTabbedItemUI();
    }

    private void installListeners(final WindowTabbedItem windowTabbedItem) {
        this.tabMouseListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    if (!windowTabbedItem.isClosable()) {
                        windowTabbedItem.setSelected();
                    } else if (!windowTabbedItem.getCloseIcon().isCloseIcon(mouseEvent)) {
                        windowTabbedItem.setSelected();
                        WindowManager windowManager = FrameworkUtilities.getWindowManager();
                        NavigationHistory navigationHistory = (NavigationHistory)windowManager.getNavigationHistory();
                        int n = windowManager.getActiveWindowId();
                        navigationHistory.addWindow(n);
                    }
                }
            }
        };
        windowTabbedItem.addMouseListener(this.tabMouseListener);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        int n;
        int n2;
        WindowTabbedItem windowTabbedItem = (WindowTabbedItem)jComponent;
        int n3 = windowTabbedItem.getBounds().width;
        int n4 = windowTabbedItem.getBounds().height;
        Polygon polygon = new Polygon();
        polygon.addPoint(1, 6);
        polygon.addPoint(3, 4);
        polygon.addPoint(n3 - 2 - 1, 4);
        polygon.addPoint(n3 - 1, 5);
        polygon.addPoint(n3 - 1, n4 - 1);
        polygon.addPoint(1, n4 - 1);
        Polygon polygon2 = new Polygon();
        polygon2.addPoint(0, 5);
        polygon2.addPoint(2, 3);
        polygon2.addPoint(n3 - 2 - 1, 3);
        polygon2.addPoint(n3 - 1, 5);
        polygon2.addPoint(n3 - 1, n4 - 1);
        polygon2.addPoint(0, n4 - 1);
        Polygon polygon3 = new Polygon();
        polygon3.addPoint(1, 4);
        polygon3.addPoint(3, 2);
        polygon3.addPoint(n3 - 2 - 1, 2);
        polygon3.addPoint(n3 - 1, 3);
        polygon3.addPoint(n3 - 1, n4 - 1);
        polygon3.addPoint(1, n4 - 1);
        Polygon polygon4 = new Polygon();
        polygon4.addPoint(0, 3);
        polygon4.addPoint(2, 1);
        polygon4.addPoint(n3 - 2 - 1, 1);
        polygon4.addPoint(n3 - 1, 3);
        polygon4.addPoint(n3 - 1, n4 - 1);
        polygon4.addPoint(0, n4 - 1);
        if (windowTabbedItem.isSelected()) {
            graphics.setColor(COLOR_BORDER_SHADOW);
            graphics.drawPolygon(polygon4);
        } else {
            graphics.setColor(COLOR_BORDER_LIGHT);
            graphics.drawPolygon(polygon2);
        }
        if (windowTabbedItem.isSelected()) {
            graphics.setColor(COLOR_BACKGROUND_SELECTED);
            graphics.fillPolygon(polygon3);
            graphics.setColor(COLOR_BACKGROUND_SELECTED);
            graphics.drawLine(1, n4 - 1, n3 - 1, n4 - 1);
        } else {
            graphics.setColor(COLOR_BACKGROUND_UNSELECTED);
            graphics.fillPolygon(polygon);
        }
        if (windowTabbedItem.getTabIcon() != null) {
            n2 = 4;
            n = (windowTabbedItem.getHeight() - 3 - windowTabbedItem.getTabIcon().getIconHeight()) / 2 + 3;
            windowTabbedItem.getTabIcon().paintIcon(windowTabbedItem, graphics, n2, n);
        }
        if (windowTabbedItem.isSelected()) {
            graphics.setColor(COLOR_TEXT_SELECTED);
        } else {
            graphics.setColor(COLOR_TEXT_UNSELECTED);
        }
        n2 = 4;
        if (windowTabbedItem.getTabIcon() != null) {
            n2 += windowTabbedItem.getTabIcon().getIconWidth() + 4;
        }
        n = (windowTabbedItem.getHeight() - 3 - windowTabbedItem.getTitleHeight()) / 2 + windowTabbedItem.getTitleHeight() + 3;
        n -= 4;
        if (windowTabbedItem.getSize().width < windowTabbedItem.getRealWidth()) {
            this.drawString(graphics, windowTabbedItem.getMinimumTitle(), n2, n);
            if (windowTabbedItem.getTitle() != null && !ResourceUtil.areEquals(windowTabbedItem.getTitle(), windowTabbedItem.getMinimumTitle())) {
                windowTabbedItem.setToolTipText(windowTabbedItem.getTitle());
            } else {
                windowTabbedItem.setToolTipText(null);
            }
        } else {
            this.drawString(graphics, windowTabbedItem.getTitle(), n2, n);
            windowTabbedItem.setToolTipText(null);
        }
        if (windowTabbedItem.isClosable()) {
            int n5 = windowTabbedItem.getWidth() - 10 - windowTabbedItem.getCloseIcon().getIconWidth();
            int n6 = (windowTabbedItem.getHeight() - 3 - windowTabbedItem.getCloseIcon().getIconHeight()) / 2 + 3;
            windowTabbedItem.getCloseIcon().paintIcon(windowTabbedItem, graphics, n5, n6);
        }
    }

    private void drawString(Graphics graphics, String string, int n, int n2) {
        graphics.drawString(string, n, n2);
    }
}

