/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.windowmanagement.windowtabbed;

import com.swimap.iview.commstyle.resource.i18n.ResourceUtil;
import com.swimap.iview.framework.windowmanagement.windowtabbed.TabActionListener;
import com.swimap.iview.framework.windowmanagement.windowtabbed.WindowTabbedConstants;
import com.swimap.iview.framework.windowmanagement.windowtabbed.WindowTabbedItemUI;
import com.swimap.iview.framework.windowmanagement.windowtabbed.WindowTabbedPane;
import com.swimap.iview.framework.windowmanagement.windowtabbed.WindowTabbedUtil;
import com.swimap.iview.templates.utils.MultiRowToolTip;
import com.swimap.iview.util.CloseIcon;
import com.swimap.iview.util.IconCloseListener;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.UIManager;

public class WindowTabbedItem
extends JComponent
implements WindowTabbedConstants {
    private static IviewLogger logger = IviewLogger.getLogger(WindowTabbedItem.class, "IVIEW");
    private static final String UIClassID = "WindowTabbedItemUI";
    private WindowTabbedPane tabPane = null;
    private CloseIcon closeIcon = null;
    private Icon tabIcon = null;
    private String title = "";
    private String minimumTitle = "";
    private boolean closable = true;
    private boolean closeIconEnable = true;
    private int realWidth = 0;
    private int realHeight = 0;
    private int titleWidth = 0;
    private int titleHeight = 0;
    private ArrayList tabActionListeners = new ArrayList(2);

    int getTitleHeight() {
        return this.titleHeight;
    }

    public WindowTabbedItem(String string, Icon icon, boolean bl, WindowTabbedPane windowTabbedPane) {
        if (windowTabbedPane == null) {
            throw new IllegalArgumentException("tabPane is null.");
        }
        if (string != null) {
            this.title = string;
        }
        this.tabIcon = icon;
        this.closable = bl;
        this.tabPane = windowTabbedPane;
        this.setName(string);
        if (this.closable) {
            this.closeIcon = this.createCloseIcon();
        }
        this.setTabSize();
    }

    private CloseIcon createCloseIcon() {
        CloseIcon closeIcon = new CloseIcon(this);
        closeIcon.addIconCloseListener(new IconCloseListener(){

            @Override
            public void close() {
                int n = WindowTabbedItem.this.tabActionListeners.size();
                for (int i = 0; i < n; ++i) {
                    TabActionListener tabActionListener = (TabActionListener)WindowTabbedItem.this.tabActionListeners.get(i);
                    tabActionListener.tabClosing();
                }
            }
        });
        return closeIcon;
    }

    public WindowTabbedItem(String string, WindowTabbedPane windowTabbedPane) {
        this(string, null, true, windowTabbedPane);
    }

    @Override
    public JToolTip createToolTip() {
        MultiRowToolTip multiRowToolTip = new MultiRowToolTip();
        multiRowToolTip.setMaxLineNumber(10);
        multiRowToolTip.setComponent(this);
        return multiRowToolTip;
    }

    String getMinimumTitle() {
        this.minimumTitle = this.calcMinimumTitle(this.title);
        return this.minimumTitle;
    }

    private void setTabSize() {
        this.titleWidth = this.calcTitleWidth();
        this.titleHeight = this.calcTitleHeight();
        this.realWidth = this.calcRealWidth();
        this.realHeight = this.calcRealHeight();
        this.setSize(this.realWidth, this.realHeight);
    }

    private String calcMinimumTitle(String string) {
        int n = this.getMinimumTitleWidth();
        return WindowTabbedUtil.getAbbreviatoryString(string, n);
    }

    private int getMinimumTitleWidth() {
        int n = 0;
        n = Math.max(this.getSize().width, 100) - 4;
        if (this.getTabIcon() != null) {
            n -= this.getTabIcon().getIconWidth() + 4;
        }
        n -= 4;
        if (this.isClosable()) {
            n -= this.getCloseIcon().getIconWidth();
        }
        return n -= 10;
    }

    private int calcTitleWidth() {
        FontMetrics fontMetrics = WindowTabbedUtil.getFontMetrics();
        return fontMetrics.stringWidth(this.title);
    }

    private int calcTitleHeight() {
        FontMetrics fontMetrics = WindowTabbedUtil.getFontMetrics();
        return fontMetrics.getHeight();
    }

    private int calcRealHeight() {
        int n = 4 + this.titleHeight + 2 + 2 + 1;
        if (n < 24) {
            return 24;
        }
        return n;
    }

    private int calcRealWidth() {
        int n = 0;
        n += 0;
        ++n;
        n += 4;
        if (this.tabIcon != null) {
            n += this.getTabIcon().getIconWidth() + 4;
        }
        n += this.titleWidth + 4;
        if (this.isClosable()) {
            n += this.getCloseIcon().getIconWidth();
        }
        n += 10;
        return ++n;
    }

    int getRealWidth() {
        return this.realWidth;
    }

    public void setTitle(String string) {
        logger.debug("set title =" + string);
        if (ResourceUtil.areEquals(this.title, string) || string == null) {
            return;
        }
        this.title = string;
        this.titleWidth = this.calcTitleWidth();
        this.realWidth = this.calcRealWidth();
        this.minimumTitle = this.getMinimumTitle();
        this.setSize(this.realWidth, this.realHeight);
        this.revalidate();
        this.repaint();
    }

    public void setClosable(boolean bl) {
        logger.debug("set closable =" + bl);
        if (this.closable == bl) {
            return;
        }
        this.closable = bl;
        if (this.closable && this.closeIcon == null) {
            this.closeIcon = this.createCloseIcon();
        }
        this.setTabSize();
        this.closeIcon.setEnabled(this.closeIconEnable && bl);
        this.revalidate();
        this.repaint();
    }

    public void setTabIcon(Icon icon) {
        logger.debug("set tabIcon =" + icon);
        this.tabIcon = icon;
        this.setTabSize();
        this.revalidate();
        this.repaint();
    }

    public void setCloseIconEnable(boolean bl) {
        this.closeIconEnable = bl;
        if (this.getCloseIcon() != null && this.isClosable()) {
            this.getCloseIcon().setEnabled(bl);
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getSize();
    }

    boolean isClosable() {
        return this.closable;
    }

    CloseIcon getCloseIcon() {
        return this.closeIcon;
    }

    Icon getTabIcon() {
        return this.tabIcon;
    }

    boolean isSelected() {
        return this.tabPane.isSelected(this);
    }

    void setSelected() {
        int n = this.tabActionListeners.size();
        for (int i = 0; i < n; ++i) {
            TabActionListener tabActionListener = (TabActionListener)this.tabActionListeners.get(i);
            tabActionListener.tabSelected();
        }
    }

    String getTitle() {
        return this.title;
    }

    @Override
    public String getUIClassID() {
        return UIClassID;
    }

    public void addTabActionListener(TabActionListener tabActionListener) {
        this.tabActionListeners.add(tabActionListener);
    }

    public void removeTabActionListener(TabActionListener tabActionListener) {
        this.tabActionListeners.remove(tabActionListener);
    }

    @Override
    public WindowTabbedItemUI getUI() {
        return (WindowTabbedItemUI)this.ui;
    }

    public void setUI(WindowTabbedItemUI windowTabbedItemUI) {
        super.setUI(windowTabbedItemUI);
    }

    @Override
    public void updateUI() {
        this.setUI((WindowTabbedItemUI)UIManager.getUI(this));
    }

    static {
        UIManager.put(UIClassID, "com.swimap.iview.framework.windowmanagement.windowtabbed.WindowTabbedItemUI");
    }
}

