/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.windowmanagement.windowtabbed;

import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.framework.windowmanagement.InternalFrame;
import com.swimap.iview.framework.windowmanagement.windowtabbed.WindowTabbedItem;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;

class WindowTabMenuSupport {
    private static IviewLogger logger = IviewLogger.getLogger(WindowTabMenuSupport.class, "IVIEW");
    private static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/framework/windowmanagement/windowtabmenu/Res");
    private static String RESTORE = res.getString("Restore");
    private static String MINIMIZE = res.getString("Minimize");
    private static String MAXIMIZE = res.getString("Maximize");
    private static String CLOSE = res.getString("Close");
    private static String CLOSEOTHERS = res.getString("CloseOthers");
    private static String CLOSEALL = res.getString("CloseAll");
    private static boolean tabMenuEnabled = true;
    private static MouseListener tabMenuInvokeListener = new TabMenuInvokeListener();

    private WindowTabMenuSupport() {
    }

    private static ArrayList getMenus() {
        InternalFrame internalFrame = FrameworkUtilities.getWindowManager().getWindow(FrameworkUtilities.getWindowManager().getActiveWindowId());
        if (null == internalFrame) {
            return null;
        }
        JMenuItem jMenuItem = WindowTabMenuSupport.createRestoreMenu(internalFrame);
        JMenuItem jMenuItem2 = WindowTabMenuSupport.createMinimizeMenu(internalFrame);
        JMenuItem jMenuItem3 = WindowTabMenuSupport.createMaximizeMenu(internalFrame);
        JMenuItem jMenuItem4 = WindowTabMenuSupport.createCloseMenu(internalFrame);
        JMenuItem jMenuItem5 = WindowTabMenuSupport.createCloseOthersMenu(internalFrame);
        JMenuItem jMenuItem6 = WindowTabMenuSupport.createCloseAllMenu(internalFrame);
        ArrayList<JComponent> arrayList = new ArrayList<JComponent>();
        arrayList.add(jMenuItem);
        arrayList.add(jMenuItem2);
        arrayList.add(jMenuItem3);
        arrayList.add(new JSeparator());
        arrayList.add(jMenuItem4);
        arrayList.add(jMenuItem5);
        arrayList.add(jMenuItem6);
        return arrayList;
    }

    static void registerForTabMenu(WindowTabbedItem windowTabbedItem) {
        windowTabbedItem.addMouseListener(tabMenuInvokeListener);
    }

    static void unregisterForTabMenu(WindowTabbedItem windowTabbedItem) {
        windowTabbedItem.removeMouseListener(tabMenuInvokeListener);
    }

    private static JPopupMenu createPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        ArrayList arrayList = WindowTabMenuSupport.getMenus();
        if (null == arrayList || arrayList.size() == 0) {
            return null;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            jPopupMenu.add((JComponent)arrayList.get(i));
        }
        return jPopupMenu;
    }

    private static JMenuItem createRestoreMenu(final InternalFrame internalFrame) {
        JMenuItem jMenuItem = new JMenuItem(RESTORE);
        jMenuItem.setMnemonic('R');
        if (!internalFrame.isMaximum() && !internalFrame.isIcon()) {
            jMenuItem.setEnabled(false);
            return jMenuItem;
        }
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                logger.debug("Restoring window: " + internalFrame.getTitle());
                FrameworkUtilities.getWindowManager().restoreWindow(internalFrame.getWindowId());
            }
        });
        return jMenuItem;
    }

    private static JMenuItem createMinimizeMenu(final InternalFrame internalFrame) {
        JMenuItem jMenuItem = new JMenuItem(MINIMIZE);
        jMenuItem.setMnemonic('n');
        if (internalFrame.isIcon() || !internalFrame.isIconifiable()) {
            jMenuItem.setEnabled(false);
            return jMenuItem;
        }
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                logger.debug("Minimize Window: " + internalFrame.getTitle());
                FrameworkUtilities.getWindowManager().minimizeWindow(internalFrame.getWindowId());
            }
        });
        return jMenuItem;
    }

    private static JMenuItem createMaximizeMenu(final InternalFrame internalFrame) {
        JMenuItem jMenuItem = new JMenuItem(MAXIMIZE);
        jMenuItem.setMnemonic('x');
        if (internalFrame.isMaximum() || !internalFrame.isMaximizable()) {
            jMenuItem.setEnabled(false);
            return jMenuItem;
        }
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                logger.debug("Maximizing Window: " + internalFrame.getTitle());
                FrameworkUtilities.getWindowManager().maximizeWindow(internalFrame.getWindowId());
            }
        });
        return jMenuItem;
    }

    private static JMenuItem createCloseMenu(final InternalFrame internalFrame) {
        JMenuItem jMenuItem = new JMenuItem(CLOSE);
        jMenuItem.setMnemonic('C');
        if (internalFrame.isBusy() || !internalFrame.isClosable()) {
            jMenuItem.setEnabled(false);
            return jMenuItem;
        }
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                logger.debug("Closing Window: " + internalFrame.getTitle());
                FrameworkUtilities.getWindowManager().closeWindow(internalFrame.getWindowId());
            }
        });
        return jMenuItem;
    }

    private static JMenuItem createCloseOthersMenu(final InternalFrame internalFrame) {
        JMenuItem jMenuItem = new JMenuItem(CLOSEOTHERS);
        jMenuItem.setMnemonic('O');
        int n = FrameworkUtilities.getWindowManager().getClosableWindowCount();
        if (n < 1 || n == 1 && internalFrame.isClosable() && !internalFrame.isBusy()) {
            jMenuItem.setEnabled(false);
        }
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                logger.debug("Closing Other Windows: " + internalFrame.getTitle());
                FrameworkUtilities.getWindowManager().closeOtherWindows(internalFrame);
            }
        });
        return jMenuItem;
    }

    private static JMenuItem createCloseAllMenu(final InternalFrame internalFrame) {
        JMenuItem jMenuItem = new JMenuItem(CLOSEALL);
        jMenuItem.setMnemonic('A');
        int n = FrameworkUtilities.getWindowManager().getClosableWindowCount();
        if (n < 1) {
            jMenuItem.setEnabled(false);
        }
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                logger.debug("Closing All Windows from: " + internalFrame.getTitle());
                FrameworkUtilities.getWindowManager().closeAllWindows();
            }
        });
        return jMenuItem;
    }

    static void setTabMenuEnabled(boolean bl) {
        tabMenuEnabled = bl;
    }

    public static boolean getTabMenuEnabled() {
        return tabMenuEnabled;
    }

    private static class TabMenuInvokeListener
    extends MouseAdapter {
        private TabMenuInvokeListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (SwingUtilities.isRightMouseButton(mouseEvent) && tabMenuEnabled) {
                Component component = (Component)mouseEvent.getSource();
                if (!(component instanceof WindowTabbedItem)) {
                    return;
                }
                WindowTabbedItem windowTabbedItem = (WindowTabbedItem)component;
                windowTabbedItem.setSelected();
                JPopupMenu jPopupMenu = WindowTabMenuSupport.createPopupMenu();
                if (null == jPopupMenu) {
                    return;
                }
                ScreenToolKit.showPopupMenu(jPopupMenu, mouseEvent);
            }
        }
    }
}

