/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.windowmanagement.welcomepage.draggable;

import com.swimap.iview.framework.windowmanagement.welcomepage.WelcomeManager;
import com.swimap.iview.framework.windowmanagement.welcomepage.WorkbenchButton;
import com.swimap.iview.framework.windowmanagement.welcomepage.WorkbenchLayout;
import com.swimap.iview.framework.windowmanagement.welcomepage.WorkbenchManager;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import javax.swing.JPanel;

public class WorkbenchDropTargetListener
implements DropTargetListener {
    private final JPanel workbenchPanel;
    private static final int MARGIN_TOP = 30;
    private static final Cursor DROPPABLE_CURSOR = Cursor.getPredefinedCursor(0);
    private static IviewLogger logger = IviewLogger.getLogger(WorkbenchDropTargetListener.class, "IVIEW");

    public WorkbenchDropTargetListener(JPanel jPanel) {
        this.workbenchPanel = jPanel;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        try {
            DataFlavor dataFlavor = WorkbenchButton.getDragAndDropPanelDataFlavor();
            if (dropTargetDragEvent.isDataFlavorSupported(dataFlavor)) {
                if (!this.workbenchPanel.getCursor().equals(DROPPABLE_CURSOR)) {
                    this.workbenchPanel.setCursor(DROPPABLE_CURSOR);
                }
            } else {
                dropTargetDragEvent.acceptDrag(0);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.trace("ClassNotFoundException on dragOver");
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
        if (!this.workbenchPanel.getCursor().equals(Cursor.getDefaultCursor())) {
            this.workbenchPanel.setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        WorkbenchButton workbenchButton = this.getDroppedButton(dropTargetDropEvent);
        if (null == workbenchButton) {
            return;
        }
        WorkbenchButton workbenchButton2 = this.getTargetButton(workbenchButton, dropTargetDropEvent.getLocation());
        if (null != workbenchButton2) {
            this.rearrange(workbenchButton, workbenchButton2);
        } else {
            this.move(workbenchButton, dropTargetDropEvent.getLocation());
        }
        dropTargetDropEvent.dropComplete(true);
    }

    private WorkbenchButton getDroppedButton(DropTargetDropEvent dropTargetDropEvent) {
        DataFlavor dataFlavor = null;
        Object object = null;
        Transferable transferable = null;
        WorkbenchButton workbenchButton = null;
        try {
            dataFlavor = WorkbenchButton.getDragAndDropPanelDataFlavor();
            transferable = dropTargetDropEvent.getTransferable();
            if (transferable.isDataFlavorSupported(dataFlavor)) {
                object = dropTargetDropEvent.getTransferable().getTransferData(dataFlavor);
            }
        }
        catch (Exception exception) {
            object = null;
        }
        if (null != object) {
            workbenchButton = (WorkbenchButton)object;
        }
        return workbenchButton;
    }

    private WorkbenchButton getTargetButton(WorkbenchButton workbenchButton, Point point) {
        WorkbenchButton workbenchButton2 = null;
        Container container = workbenchButton.getParent();
        WorkbenchLayout workbenchLayout = (WorkbenchLayout)container.getLayout();
        Point point2 = workbenchLayout.getDestIndex(point, container.getComponents().length, 104);
        int n = 0;
        Component[] componentArray = container.getComponents();
        int n2 = 30;
        WorkbenchButton workbenchButton3 = null;
        for (int i = 0; i < componentArray.length; ++i) {
            workbenchButton3 = (WorkbenchButton)componentArray[i];
            if (workbenchButton3.getYPosition() <= n2) continue;
            n2 = workbenchButton3.getYPosition();
        }
        n = n2 + 104;
        if (point.y > n) {
            return workbenchButton2;
        }
        for (Component component : container.getComponents()) {
            WorkbenchButton workbenchButton4;
            if (!(component instanceof WorkbenchButton) || (workbenchButton4 = (WorkbenchButton)component).getYPosition() != point2.y) continue;
            workbenchButton2 = workbenchButton4;
            break;
        }
        return workbenchButton2;
    }

    private void rearrange(WorkbenchButton workbenchButton, WorkbenchButton workbenchButton2) {
        int n;
        Container container = workbenchButton.getParent();
        int n2 = workbenchButton.getYPosition();
        int n3 = n2 < (n = workbenchButton2.getYPosition()) ? n2 : n;
        int n4 = n2 < n ? n : n2;
        WorkbenchButton workbenchButton3 = null;
        for (Component component : container.getComponents()) {
            if (!(component instanceof WorkbenchButton)) continue;
            workbenchButton3 = (WorkbenchButton)component;
            int n5 = workbenchButton3.getYPosition();
            if (n2 == n3) {
                if (n5 == n3) {
                    this.updatePosition(workbenchButton3, n4);
                    continue;
                }
                if (n5 <= n3 || n5 > n4) continue;
                this.updatePosition(workbenchButton3, n5 -= 104);
                continue;
            }
            if (n5 == n4) {
                this.updatePosition(workbenchButton3, n3);
                continue;
            }
            if (n5 < n3 || n5 >= n4) continue;
            this.updatePosition(workbenchButton3, n5 += 104);
        }
        this.workbenchPanel.setCursor(Cursor.getDefaultCursor());
        workbenchButton.setCursor(Cursor.getDefaultCursor());
        workbenchButton2.setCursor(Cursor.getDefaultCursor());
        this.workbenchPanel.doLayout();
    }

    private void updatePosition(WorkbenchButton workbenchButton, int n) {
        WorkbenchManager workbenchManager = WelcomeManager.getWorkbenchManager();
        workbenchButton.setYPosition(n);
        workbenchButton.storeYInfo();
        workbenchManager.fireWorkbenchEvent(workbenchButton, 1);
        Component[] componentArray = workbenchButton.getParent().getComponents();
        WorkbenchButton workbenchButton2 = null;
        for (Component component : componentArray) {
            if (!(component instanceof WorkbenchButton)) continue;
            workbenchButton2 = (WorkbenchButton)component;
            workbenchButton2.setSaveRequired(true);
        }
    }

    private void move(WorkbenchButton workbenchButton, Point point) {
        Container container = workbenchButton.getParent();
        WorkbenchLayout workbenchLayout = (WorkbenchLayout)container.getLayout();
        Point point2 = workbenchLayout.getDestIndex(point, container.getComponents().length, 104);
        this.updatePosition(workbenchButton, (int)point2.getY());
        this.workbenchPanel.setCursor(Cursor.getDefaultCursor());
        workbenchButton.setCursor(Cursor.getDefaultCursor());
        this.workbenchPanel.doLayout();
        this.workbenchPanel.scrollRectToVisible(new Rectangle(workbenchButton.getX(), workbenchButton.getY() - 30, workbenchButton.getPreferredSize().width, workbenchButton.getY() + 104));
    }
}

