/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.windowmanagement.welcomepage.draggable;

import com.swimap.iview.framework.windowmanagement.welcomepage.WorkbenchButton;
import com.swimap.iview.framework.windowmanagement.welcomepage.WorkbenchLayout;
import com.swimap.iview.framework.windowmanagement.welcomepage.draggable.DraggableLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.Autoscroll;
import javax.swing.JPanel;
import javax.swing.Scrollable;

public class WorkbenchDragPanel
extends JPanel
implements Scrollable,
Autoscroll {
    private static final long serialVersionUID = 5003854102590387713L;
    private static final int MARGIN_GAP = 4;
    private static final boolean FIND_WIDTH = true;
    private static final boolean FIND_HEIGHT = false;
    public static final int AUTOSCROLL_MARGIN = 30;
    private static final int SCROLL_WIDTH = 15;

    public WorkbenchDragPanel(WorkbenchLayout workbenchLayout) {
        super(workbenchLayout, true);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.getPreferredWidth(), this.getPreferredHeight());
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        return 30;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        return 30;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return true;
    }

    private int getPreferredHeight() {
        return this.getMaxDistance(false) + 15;
    }

    public int getPreferredWidth() {
        return this.getMaxDistance(true);
    }

    private int getMaxDistance(boolean bl) {
        int n = 0;
        WorkbenchButton workbenchButton = null;
        for (Component component : this.getComponents()) {
            if (!(component instanceof WorkbenchButton)) continue;
            workbenchButton = (WorkbenchButton)component;
            int n2 = 0;
            n2 = bl ? workbenchButton.getX() : workbenchButton.getY();
            n = n < (n2 += DraggableLayout.getDefaulFixedWidth()) ? n2 : n;
        }
        return n += 4;
    }

    @Override
    public void autoscroll(Point point) {
        boolean bl;
        Rectangle rectangle = this.getParent().getBounds();
        boolean bl2 = point.x + rectangle.x <= 30;
        boolean bl3 = point.x + rectangle.x > 30;
        boolean bl4 = point.y + rectangle.y <= 30;
        boolean bl5 = bl = point.y + rectangle.y > 30;
        if (bl2) {
            this.scrollRectToVisible(new Rectangle(point.x - 30, point.y - 30, 0, 0));
        } else if (bl3) {
            this.scrollRectToVisible(new Rectangle(point.x, point.y, 30, 30));
        }
        if (bl4) {
            this.scrollRectToVisible(new Rectangle(point.x - 30, point.y - 30, 0, 0));
        } else if (bl) {
            this.scrollRectToVisible(new Rectangle(point.x, point.y, 30, 30));
        }
        this.repaint();
    }

    @Override
    public Insets getAutoscrollInsets() {
        Rectangle rectangle = this.getParent().getBounds();
        return new Insets(rectangle.y + 30, rectangle.x + 30, rectangle.y + rectangle.height + 30, rectangle.x + rectangle.width + 30);
    }
}

