/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.windowmanagement.welcomepage.draggable;

import com.swimap.iview.framework.windowmanagement.welcomepage.IButtonStateListerer;
import com.swimap.iview.framework.windowmanagement.welcomepage.draggable.DraggableButton;
import com.swimap.iview.framework.windowmanagement.welcomepage.draggable.DraggableLayout;
import com.swimap.iview.framework.windowmanagement.welcomepage.draggable.WorkbenchDropTargetListener;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import javax.swing.JPanel;

public class PanelDropTargetListener
implements DropTargetListener {
    private final JPanel welcomePagePanel;
    private IButtonStateListerer welcomePage;
    protected DataFlavor dragAndDropPanelFlavor;
    private static final Cursor DROPPABLE_CURSOR = Cursor.getPredefinedCursor(0);
    private static IviewLogger logger = IviewLogger.getLogger(WorkbenchDropTargetListener.class, "IVIEW");

    public PanelDropTargetListener(JPanel jPanel, IButtonStateListerer iButtonStateListerer, DataFlavor dataFlavor) {
        this.welcomePagePanel = jPanel;
        this.welcomePage = iButtonStateListerer;
        this.dragAndDropPanelFlavor = dataFlavor;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        try {
            if (null == this.dragAndDropPanelFlavor) {
                return;
            }
            if (dropTargetDragEvent.isDataFlavorSupported(this.dragAndDropPanelFlavor)) {
                if (!this.welcomePagePanel.getCursor().equals(DROPPABLE_CURSOR)) {
                    this.welcomePagePanel.setCursor(DROPPABLE_CURSOR);
                }
            } else {
                dropTargetDragEvent.acceptDrag(0);
            }
        }
        catch (Exception exception) {
            logger.trace("ClassNotFoundException on dragOver");
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
        if (!this.welcomePagePanel.getCursor().equals(Cursor.getDefaultCursor())) {
            this.welcomePagePanel.setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        if (!dropTargetDropEvent.isDataFlavorSupported(this.dragAndDropPanelFlavor)) {
            return;
        }
        DraggableButton draggableButton = this.getDroppedButton(dropTargetDropEvent);
        if (null == draggableButton) {
            return;
        }
        DraggableButton draggableButton2 = this.getTargetButton(draggableButton, dropTargetDropEvent.getLocation());
        if (null != draggableButton2) {
            this.swap(draggableButton, draggableButton2);
        } else {
            this.move(draggableButton, dropTargetDropEvent.getLocation());
        }
        dropTargetDropEvent.dropComplete(true);
    }

    private DraggableButton getDroppedButton(DropTargetDropEvent dropTargetDropEvent) {
        Object object = null;
        Transferable transferable = null;
        DraggableButton draggableButton = null;
        try {
            if (null == this.dragAndDropPanelFlavor) {
                return draggableButton;
            }
            transferable = dropTargetDropEvent.getTransferable();
            if (transferable.isDataFlavorSupported(this.dragAndDropPanelFlavor)) {
                object = dropTargetDropEvent.getTransferable().getTransferData(this.dragAndDropPanelFlavor);
            }
        }
        catch (Exception exception) {
            object = null;
        }
        if (null != object) {
            draggableButton = (DraggableButton)object;
        }
        return draggableButton;
    }

    private DraggableButton getTargetButton(DraggableButton draggableButton, Point point) {
        DraggableButton draggableButton2 = null;
        Container container = draggableButton.getParent();
        DraggableLayout draggableLayout = (DraggableLayout)container.getLayout();
        Point point2 = draggableLayout.getDestIndex(point);
        for (Component component : container.getComponents()) {
            DraggableButton draggableButton3;
            if (!(component instanceof DraggableButton) || (draggableButton3 = (DraggableButton)component).getXIndex() != point2.x || draggableButton3.getYIndex() != point2.y) continue;
            draggableButton2 = draggableButton3;
            break;
        }
        return draggableButton2;
    }

    private void swap(DraggableButton draggableButton, DraggableButton draggableButton2) {
        int n = draggableButton.getXIndex();
        int n2 = draggableButton.getYIndex();
        draggableButton.setXIndex(draggableButton2.getXIndex());
        draggableButton.setYIndex(draggableButton2.getYIndex());
        draggableButton2.setXIndex(n);
        draggableButton2.setYIndex(n2);
        draggableButton.storeXYInfo();
        draggableButton2.storeXYInfo();
        this.welcomePage.buttonDragged(draggableButton2, draggableButton);
        this.welcomePagePanel.setCursor(Cursor.getDefaultCursor());
        draggableButton.setCursor(Cursor.getDefaultCursor());
        draggableButton2.setCursor(Cursor.getDefaultCursor());
        this.welcomePagePanel.doLayout();
        this.welcomePagePanel.scrollRectToVisible(new Rectangle(draggableButton.getX(), draggableButton.getY(), DraggableLayout.getDefaulFixedWidth(), DraggableLayout.getDefaulFixedHeigth()));
    }

    private void move(DraggableButton draggableButton, Point point) {
        Container container = draggableButton.getParent();
        DraggableLayout draggableLayout = (DraggableLayout)container.getLayout();
        Point point2 = draggableLayout.getDestIndex(point);
        draggableButton.setXIndex((int)point2.getX());
        draggableButton.setYIndex((int)point2.getY());
        draggableButton.storeXYInfo();
        this.welcomePage.buttonDragged(draggableButton, null);
        this.welcomePagePanel.setCursor(Cursor.getDefaultCursor());
        draggableButton.setCursor(Cursor.getDefaultCursor());
        this.welcomePagePanel.doLayout();
        this.welcomePagePanel.scrollRectToVisible(new Rectangle(draggableButton.getX(), draggableButton.getY(), DraggableLayout.getDefaulFixedWidth(), DraggableLayout.getDefaulFixedHeigth()));
    }
}

