/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.windowmanagement.welcomepage.draggable;

import com.swimap.iview.framework.windowmanagement.welcomepage.ConfigUtilities;
import com.swimap.iview.framework.windowmanagement.welcomepage.draggable.DraggableButton;
import com.swimap.iview.util.ScreenToolKit;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;

public class DraggableLayout
implements LayoutManager {
    private static final int DEFAULT_ICON_BUF_GAP = 25;
    private int ICON_BUF_GAP = 25;
    private int GAP_BTWN_BTNS = 32;
    private static int PERCENT_DIVIDER = 100;
    private int DEFAULT_ICON_WIDTH;
    private int DEFAULT_ICON_HEIGHT;
    private int DELTA_W;
    private int DELTA_H;
    private int FIXED_SIZE_WIDTH;
    private int FIXED_SIZE_HEIGHT;
    private int FIXED_SIZE;
    private int SCREEN_WIDTH;

    public DraggableLayout() {
        this.DEFAULT_ICON_WIDTH = ConfigUtilities.getDefaultIconSize().width;
        this.DEFAULT_ICON_HEIGHT = ConfigUtilities.getDefaultIconSize().height;
        this.DELTA_W = this.DEFAULT_ICON_WIDTH / PERCENT_DIVIDER * 6;
        this.DELTA_H = this.DEFAULT_ICON_HEIGHT / PERCENT_DIVIDER * 6;
        this.FIXED_SIZE_WIDTH = this.DEFAULT_ICON_WIDTH + this.ICON_BUF_GAP - this.DELTA_W;
        this.FIXED_SIZE_HEIGHT = this.DEFAULT_ICON_HEIGHT + this.ICON_BUF_GAP - this.DELTA_H;
        this.FIXED_SIZE = this.getFixedWidth();
        this.SCREEN_WIDTH = ScreenToolKit.getScreenWidth();
    }

    public DraggableLayout(Dimension dimension, int n, int n2, int n3) {
        this.DEFAULT_ICON_WIDTH = ConfigUtilities.getDefaultIconSize().width;
        this.DEFAULT_ICON_HEIGHT = ConfigUtilities.getDefaultIconSize().height;
        this.DELTA_W = this.DEFAULT_ICON_WIDTH / PERCENT_DIVIDER * 6;
        this.DELTA_H = this.DEFAULT_ICON_HEIGHT / PERCENT_DIVIDER * 6;
        this.FIXED_SIZE_WIDTH = this.DEFAULT_ICON_WIDTH + this.ICON_BUF_GAP - this.DELTA_W;
        this.FIXED_SIZE_HEIGHT = this.DEFAULT_ICON_HEIGHT + this.ICON_BUF_GAP - this.DELTA_H;
        this.FIXED_SIZE = this.getFixedWidth();
        this.SCREEN_WIDTH = ScreenToolKit.getScreenWidth();
        this.ICON_BUF_GAP = n;
        this.GAP_BTWN_BTNS = n2;
        this.DELTA_W = dimension.width / PERCENT_DIVIDER * 6;
        this.DELTA_H = dimension.height / PERCENT_DIVIDER * 6;
        this.FIXED_SIZE_WIDTH = dimension.width + this.ICON_BUF_GAP - this.DELTA_W;
        this.FIXED_SIZE_HEIGHT = dimension.height + this.ICON_BUF_GAP - this.DELTA_H;
        this.FIXED_SIZE = this.FIXED_SIZE_WIDTH;
        this.SCREEN_WIDTH = n3;
        this.DEFAULT_ICON_WIDTH = dimension.width;
        this.DEFAULT_ICON_HEIGHT = dimension.height;
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Component[] componentArray = container.getComponents();
            if (componentArray.length == 0) {
                return;
            }
            DraggableButton draggableButton = null;
            int n = 0;
            int n2 = 0;
            for (Component component : componentArray) {
                if (!(component instanceof DraggableButton)) continue;
                draggableButton = (DraggableButton)component;
                int n3 = draggableButton.getXIndex();
                int n4 = draggableButton.getYIndex();
                n = n3 == 0 ? this.ICON_BUF_GAP - this.DELTA_W / 2 : this.ICON_BUF_GAP - this.DELTA_W / 2 + n3 * this.DEFAULT_ICON_WIDTH + this.ICON_BUF_GAP * n3 - this.DELTA_W;
                n2 = n4 == 0 ? this.ICON_BUF_GAP - this.DELTA_H / 2 : this.ICON_BUF_GAP - this.DELTA_H / 2 + n4 * this.DEFAULT_ICON_HEIGHT + this.GAP_BTWN_BTNS * n4 - this.DELTA_H;
                int n5 = draggableButton.getPreferredSize().width;
                int n6 = draggableButton.getPreferredSize().height;
                draggableButton.setBounds(n, n2, n5, n6);
            }
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        return this.getCustomLayoutSize(container);
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        return this.getCustomLayoutSize(container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimension getCustomLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Component[] componentArray = container.getComponents();
            if (componentArray.length == 0) {
                return new Dimension(0, 0);
            }
            int n = 0;
            int n2 = 0;
            DraggableButton draggableButton = null;
            for (Component component : componentArray) {
                if (!(component instanceof DraggableButton)) continue;
                draggableButton = (DraggableButton)component;
                n = draggableButton.getXIndex() > n ? draggableButton.getXIndex() : n;
                n2 = draggableButton.getYIndex() > n2 ? draggableButton.getYIndex() : n2;
            }
            return new Dimension(n * this.getFixedWidth(), n2 * this.getFixedHeight());
        }
    }

    @Override
    public void removeLayoutComponent(Component component) {
    }

    public Point getDestIndex(Point point) {
        int n = -1;
        int n2 = -1;
        if (null != point) {
            n = point.x <= this.ICON_BUF_GAP - this.DELTA_W / 2 ? 0 : (point.x + this.DELTA_W - (this.ICON_BUF_GAP - this.DELTA_W / 2)) / (this.DEFAULT_ICON_WIDTH + this.ICON_BUF_GAP);
            n2 = point.y <= this.ICON_BUF_GAP - this.DELTA_H / 2 ? 0 : (point.y + this.DELTA_H - (this.ICON_BUF_GAP - this.DELTA_H / 2)) / (this.DEFAULT_ICON_HEIGHT + this.GAP_BTWN_BTNS);
        }
        return new Point(n, n2);
    }

    public int getScreenWidth() {
        return this.SCREEN_WIDTH;
    }

    public static int getDefaulFixedWidth() {
        int n = ConfigUtilities.getDefaultIconSize().width;
        int n2 = n / PERCENT_DIVIDER * 6;
        return n + 25 - n2;
    }

    public static int getDefaulFixedHeigth() {
        int n = ConfigUtilities.getDefaultIconSize().height;
        int n2 = n / PERCENT_DIVIDER * 6;
        return n + 25 - n2;
    }

    public int getFixedSize() {
        return this.FIXED_SIZE;
    }

    public int getFixedHeight() {
        return this.FIXED_SIZE_HEIGHT;
    }

    public int getFixedWidth() {
        return this.FIXED_SIZE_WIDTH;
    }
}

