/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.windowmanagement.welcomepage.draggable;

import com.swimap.iview.framework.windowmanagement.welcomepage.IButtonStateListerer;
import com.swimap.iview.framework.windowmanagement.welcomepage.draggable.DraggableButton;
import com.swimap.iview.framework.windowmanagement.welcomepage.draggable.DraggableLayout;
import com.swimap.iview.framework.windowmanagement.welcomepage.draggable.WorkbenchDropTargetListener;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;

public class DraggableButtonDropTargetListener
implements DropTargetListener {
    protected final DraggableButton targetButton;
    protected IButtonStateListerer welcomePage;
    protected JPanel containerPanel;
    protected DataFlavor dataFlavor;
    private static final Cursor DROPPABLE_CURSOR = Cursor.getPredefinedCursor(0);
    private static IviewLogger logger = IviewLogger.getLogger(WorkbenchDropTargetListener.class, "IVIEW");

    public DraggableButtonDropTargetListener(DraggableButton draggableButton, IButtonStateListerer iButtonStateListerer, JPanel jPanel, DataFlavor dataFlavor) {
        this.targetButton = draggableButton;
        this.welcomePage = iButtonStateListerer;
        this.containerPanel = jPanel;
        this.dataFlavor = dataFlavor;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        try {
            if (dropTargetDragEvent.isDataFlavorSupported(this.dataFlavor)) {
                if (!this.targetButton.getCursor().equals(DROPPABLE_CURSOR)) {
                    this.targetButton.setCursor(DROPPABLE_CURSOR);
                }
            } else {
                dropTargetDragEvent.acceptDrag(0);
            }
        }
        catch (Exception exception) {
            logger.trace("ClassNotFoundException on dragOver");
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
        if (!this.containerPanel.getCursor().equals(Cursor.getDefaultCursor())) {
            this.containerPanel.setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        if (!dropTargetDropEvent.isDataFlavorSupported(this.dataFlavor)) {
            return;
        }
        this.swap(dropTargetDropEvent);
        dropTargetDropEvent.dropComplete(true);
    }

    private void swap(DropTargetDropEvent dropTargetDropEvent) {
        Object object = null;
        Transferable transferable = null;
        try {
            transferable = dropTargetDropEvent.getTransferable();
            if (transferable.isDataFlavorSupported(this.dataFlavor)) {
                object = dropTargetDropEvent.getTransferable().getTransferData(this.dataFlavor);
            }
            if (object == null) {
                return;
            }
            this.swapObject(object);
        }
        catch (Exception exception) {
            object = null;
        }
    }

    private void swapObject(Object object) {
        DraggableButton draggableButton = (DraggableButton)object;
        int n = draggableButton.getXIndex();
        int n2 = draggableButton.getYIndex();
        draggableButton.setXIndex(this.targetButton.getXIndex());
        draggableButton.setYIndex(this.targetButton.getYIndex());
        this.targetButton.setXIndex(n);
        this.targetButton.setYIndex(n2);
        draggableButton.storeXYInfo();
        this.targetButton.storeXYInfo();
        this.welcomePage.buttonDragged(draggableButton, this.targetButton);
        if (this.welcomePage instanceof JInternalFrame) {
            ((JInternalFrame)((Object)this.welcomePage)).setCursor(Cursor.getDefaultCursor());
        }
        this.targetButton.getParent().setCursor(Cursor.getDefaultCursor());
        this.targetButton.setCursor(Cursor.getDefaultCursor());
        draggableButton.setCursor(Cursor.getDefaultCursor());
        this.containerPanel.doLayout();
        LayoutManager layoutManager = this.containerPanel.getLayout();
        int n3 = DraggableLayout.getDefaulFixedWidth();
        int n4 = DraggableLayout.getDefaulFixedHeigth();
        if (layoutManager instanceof DraggableLayout) {
            n3 = ((DraggableLayout)layoutManager).getFixedWidth();
            n4 = ((DraggableLayout)layoutManager).getFixedHeight();
        }
        this.containerPanel.scrollRectToVisible(new Rectangle(draggableButton.getX(), draggableButton.getY(), n3, n4));
    }
}

