/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.windowmanagement.welcomepage.draggable;

import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.commini.xmlbind.PARA;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.framework.windowmanagement.welcomepage.WelcomeManager;
import com.swimap.iview.framework.windowmanagement.welcomepage.WelcomeTextButton;
import com.swimap.iview.framework.windowmanagement.welcomepage.draggable.DraggableButtonTransferHandler;
import com.swimap.iview.framework.windowmanagement.welcomepage.draggable.DraggableLayout;
import com.swimap.iview.framework.windowmanagement.welcomepage.draggable.ScrollableDragPanel;
import com.swimap.iview.util.ScreenToolKit;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Locale;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.TransferHandler;

public class DraggableButton
extends WelcomeTextButton
implements Transferable {
    private static final long serialVersionUID = -6947069953108816233L;
    public static final int DEFAULT_INDEX = -1;
    private static final String MIME_TYPE = "application/x-java-jvm-local-objectref;class=" + DraggableButton.class.getName();
    private static DataFlavor dragAndDropPanelDataFlavor = null;
    private int xIndex = -1;
    private int yIndex = -1;
    public static final String X_INDEX = "xIndex";
    public static final String Y_INDEX = "yIndex";
    public static final String WORKBENCH_ID = "workbenchid";
    private String workbenchId = null;
    public static final String PROPERTY_DESC = "properties";
    private DraggableButtonTransferHandler transferListener = new DraggableButtonTransferHandler();
    static Boolean menuOrFuncFlag = false;
    private transient MouseMotionListener draggingListener = new MouseAdapter(){

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            JComponent jComponent = (JComponent)mouseEvent.getSource();
            DraggableButton draggableButton = null;
            if (jComponent instanceof JLabel || jComponent instanceof JTextArea) {
                draggableButton = (DraggableButton)jComponent.getParent();
                draggableButton.setFocused(false);
            }
            TransferHandler transferHandler = jComponent.getTransferHandler();
            transferHandler.exportAsDrag(jComponent, mouseEvent, 1);
        }
    };
    public static final Comparator<WelcomeTextButton> NAME_ORDER = new Comparator<WelcomeTextButton>(){

        @Override
        public int compare(WelcomeTextButton welcomeTextButton, WelcomeTextButton welcomeTextButton2) {
            Locale locale = ResourceMng.getInstance().getLocale();
            return Collator.getInstance(locale).compare(welcomeTextButton.getButtonName().toLowerCase(), welcomeTextButton2.getButtonName().toLowerCase());
        }
    };

    public DraggableButton(DescContainer descContainer) {
        super(descContainer);
    }

    public DraggableButton(DescContainer descContainer, boolean bl) {
        super(descContainer, bl);
    }

    public DraggableButton(DescContainer descContainer, String string, Dimension dimension, int n) {
        super(descContainer, string, dimension, n);
    }

    private void setHandlerAndListener() {
        this.setTransferHandler(this.transferListener);
        for (Component component : this.getComponents()) {
            if (component instanceof JLabel) {
                ((JLabel)component).setTransferHandler(this.transferListener);
            } else if (component instanceof JTextArea) {
                ((JTextArea)component).setTransferHandler(this.transferListener);
            }
            component.addMouseMotionListener(this.draggingListener);
        }
    }

    @Override
    public void initializeButton() {
        super.initializeButton();
        this.setHandlerAndListener();
    }

    public static DraggableButton getUIObjectWithoutIndex(DescContainer descContainer) {
        DraggableButton draggableButton = new DraggableButton(descContainer, false);
        draggableButton.workbenchId = descContainer.getParasItemValue(WORKBENCH_ID);
        return draggableButton;
    }

    public static Object getUIObject(DescContainer descContainer) {
        DraggableButton draggableButton = new DraggableButton(descContainer);
        draggableButton.workbenchId = descContainer.getParasItemValue(WORKBENCH_ID);
        String string = descContainer.getParasItemValue(X_INDEX);
        String string2 = descContainer.getParasItemValue(Y_INDEX);
        if (string != null && string2 != null) {
            try {
                int n = Integer.parseInt(descContainer.getParasItemValue(X_INDEX));
                int n2 = Integer.parseInt(descContainer.getParasItemValue(Y_INDEX));
                draggableButton.setXIndex(n);
                draggableButton.setYIndex(n2);
            }
            catch (NumberFormatException numberFormatException) {
                draggableButton.setXIndex(-1);
                draggableButton.setYIndex(-1);
            }
        }
        return draggableButton;
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        DataFlavor dataFlavor2 = null;
        try {
            dataFlavor2 = DraggableButton.getDragAndDropPanelDataFlavor();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        if (dataFlavor2 != null && dataFlavor.equals(dataFlavor2)) {
            return this;
        }
        return null;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] dataFlavorArray = new DataFlavor[]{null};
        try {
            dataFlavorArray[0] = DraggableButton.getDragAndDropPanelDataFlavor();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return dataFlavorArray;
        }
        return dataFlavorArray;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        DataFlavor[] dataFlavorArray = new DataFlavor[]{null};
        try {
            dataFlavorArray[0] = DraggableButton.getDragAndDropPanelDataFlavor();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        for (DataFlavor dataFlavor2 : dataFlavorArray) {
            if (!dataFlavor2.equals(dataFlavor)) continue;
            return true;
        }
        return false;
    }

    public static DataFlavor getDragAndDropPanelDataFlavor() throws ClassNotFoundException {
        if (dragAndDropPanelDataFlavor == null) {
            dragAndDropPanelDataFlavor = new DataFlavor(MIME_TYPE);
        }
        return dragAndDropPanelDataFlavor;
    }

    public final int getXIndex() {
        return this.xIndex;
    }

    public static void setMenuOrFuncFlag(Boolean bl) {
        menuOrFuncFlag = bl;
    }

    public void setXIndex(int n) {
        this.xIndex = n;
    }

    public final int getYIndex() {
        return this.yIndex;
    }

    public void setYIndex(int n) {
        this.yIndex = n;
    }

    public boolean storeXYInfo() {
        boolean bl = false;
        DescContainer descContainer = this.getDescContainer();
        int n = this.getNum(descContainer.getParasItemValue(X_INDEX));
        int n2 = this.getNum(descContainer.getParasItemValue(Y_INDEX));
        descContainer.setParasItem(X_INDEX, this.xIndex + "", true);
        descContainer.setParasItem(Y_INDEX, this.yIndex + "", true);
        if (!(n == this.xIndex && n2 == this.yIndex || n == -1 && n2 == -1)) {
            bl = true;
        }
        return bl;
    }

    private int getNum(String string) {
        int n = -1;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n = -1;
        }
        return n;
    }

    public static Point getAvailableXY(JPanel jPanel, Point point) {
        DraggableLayout draggableLayout = (DraggableLayout)jPanel.getLayout();
        Point point2 = draggableLayout.getDestIndex(point);
        DraggableButton draggableButton = DraggableButton.getTargetButton(point2, jPanel);
        if (null == draggableButton) {
            return point2;
        }
        Point point3 = new Point();
        point3 = menuOrFuncFlag != false ? DraggableButton.getNextAvailablePosition(jPanel, DraggableButton.getLastGridPosition(jPanel)) : DraggableButton.getNextAvailablePositionXY(jPanel, point2);
        return point3;
    }

    private static Point getNextAvailablePosition(JPanel jPanel, Point point) {
        int n;
        Point point2 = new Point();
        int n2 = DraggableButton.getMaximumXValue(jPanel) + 1;
        for (n = 0; n <= point.y; ++n) {
            for (int i = 0; i < n2; ++i) {
                DraggableButton draggableButton = DraggableButton.getTargetButton(new Point(i, n), jPanel);
                if (null != draggableButton) continue;
                point2.setLocation(i, n);
                return point2;
            }
        }
        point2 = new Point(0, n);
        return point2;
    }

    private static Point getNextAvailablePositionXY(JPanel jPanel, Point point) {
        Point point2 = new Point();
        int n = DraggableButton.getMaximumXValue(jPanel) + 1;
        int n2 = point.y;
        for (int i = point.x; i <= n; ++i) {
            DraggableButton draggableButton;
            if (i == n) {
                ++n2;
                i = 0;
            }
            if (null != (draggableButton = DraggableButton.getTargetButton(new Point(i, n2), jPanel))) continue;
            point2.setLocation(i, n2);
            return point2;
        }
        return point2;
    }

    private static int getMaximumXValue(JPanel jPanel) {
        boolean bl = false;
        if (jPanel instanceof ScrollableDragPanel) {
            bl = true;
        }
        int n = DraggableButton.getColumnCount(jPanel, bl);
        int n2 = 0;
        DraggableButton draggableButton = null;
        for (Component component : jPanel.getComponents()) {
            if (!(component instanceof DraggableButton)) continue;
            draggableButton = (DraggableButton)component;
            n2 = Math.max(n2, draggableButton.getXIndex());
        }
        return Math.max(n - 1, n2);
    }

    private static Point getLastGridPosition(JPanel jPanel) {
        Point point = new Point();
        boolean bl = false;
        if (jPanel instanceof ScrollableDragPanel) {
            bl = true;
        }
        int n = DraggableButton.getColumnCount(jPanel, bl);
        point.x = -1;
        point.y = -1;
        DraggableButton draggableButton = null;
        for (Component component : jPanel.getComponents()) {
            if (!(component instanceof DraggableButton)) continue;
            draggableButton = (DraggableButton)component;
            point.y = Math.max(point.y, draggableButton.getYIndex());
        }
        if (point.y > -1) {
            for (Component component : jPanel.getComponents()) {
                if (!(component instanceof DraggableButton) || ((DraggableButton)component).getYIndex() != point.y) continue;
                draggableButton = (DraggableButton)component;
                point.x = Math.max(point.x, draggableButton.getXIndex());
            }
        }
        ++point.x;
        if (point.x > n - 1) {
            point.x = 0;
            ++point.y;
        }
        return point;
    }

    private static DraggableButton getTargetButton(Point point, JPanel jPanel) {
        DraggableButton draggableButton = null;
        for (Component component : jPanel.getComponents()) {
            DraggableButton draggableButton2;
            if (!(component instanceof DraggableButton) || (draggableButton2 = (DraggableButton)component).getXIndex() != point.x || draggableButton2.getYIndex() != point.y) continue;
            draggableButton = draggableButton2;
            break;
        }
        return draggableButton;
    }

    public static boolean isPreoccupied(Point point, JPanel jPanel) {
        return null != DraggableButton.getTargetButton(point, jPanel);
    }

    public static boolean sortDragableWelcomeTextButtons(ArrayList<WelcomeTextButton> arrayList) {
        int n = arrayList.size();
        DraggableButton draggableButton = null;
        DraggableButton draggableButton2 = null;
        boolean bl = true;
        for (int i = 1; i < n; ++i) {
            for (int j = 0; j < n - i; ++j) {
                draggableButton = (DraggableButton)arrayList.get(j);
                draggableButton2 = (DraggableButton)arrayList.get(j + 1);
                if (draggableButton.getXIndex() != -1 && draggableButton.getYIndex() != -1 || draggableButton2.getXIndex() != -1 && draggableButton2.getYIndex() != -1) {
                    bl = false;
                }
                if (draggableButton.getXIndex() != -1 && draggableButton.getYIndex() != -1 || draggableButton2.getXIndex() == -1 || draggableButton2.getYIndex() == -1) continue;
                arrayList.remove(j);
                arrayList.add(j, draggableButton2);
                arrayList.remove(j + 1);
                arrayList.add(j + 1, draggableButton);
            }
        }
        if (n < 2) {
            bl = false;
        }
        return bl;
    }

    public static void resetDuplicates(ArrayList<WelcomeTextButton> arrayList) {
        if (null == arrayList) {
            return;
        }
        int n = arrayList.size();
        DraggableButton draggableButton = null;
        DraggableButton draggableButton2 = null;
        for (int i = 0; i < n; ++i) {
            draggableButton = (DraggableButton)arrayList.get(i);
            if (draggableButton.getXIndex() == -1 || draggableButton.getYIndex() == -1) continue;
            for (int j = i + 1; j < n; ++j) {
                draggableButton2 = (DraggableButton)arrayList.get(j);
                if (draggableButton.getXIndex() != draggableButton2.getXIndex() || draggableButton.getYIndex() != draggableButton2.getYIndex()) continue;
                ((DraggableButton)arrayList.get(j)).setXIndex(-1);
                ((DraggableButton)arrayList.get(j)).setYIndex(-1);
            }
        }
    }

    public final String getWorkbenchId() {
        return this.workbenchId;
    }

    public final void setWorkbenchId(String string) {
        String string2 = "";
        if (!"_default_iview_workbenches".equals(string)) {
            string2 = string;
        }
        DescContainer descContainer = this.getDescContainer();
        descContainer.setParasItem(WORKBENCH_ID, string2, true);
        this.workbenchId = string;
    }

    public void setProperty(String string, String string2) {
        if (null == string || string.trim().length() == 0) {
            return;
        }
        if (null != this.getDescContainer()) {
            if (null == this.getDescContainer().getDescContainer(PROPERTY_DESC)) {
                this.getDescContainer().addDescContainer(PROPERTY_DESC);
            }
            this.getDescContainer().getDescContainer(PROPERTY_DESC).setParasItem(string.trim(), string2, true);
            WelcomeManager.getWelcomePageReference().modifylink(this, false);
        }
    }

    public void removeProperty(String string) {
        PARA pARA;
        if (null == string || string.trim().length() == 0) {
            return;
        }
        if (null != this.getDescContainer() && null != this.getDescContainer().getDescContainer(PROPERTY_DESC) && null != (pARA = this.getDescContainer().getDescContainer(PROPERTY_DESC).getParasItem(string.trim()))) {
            this.getDescContainer().getDescContainer(PROPERTY_DESC).removeParasItem(pARA);
            if (this.getDescContainer().getDescContainer(PROPERTY_DESC).getParasItemCount() == 0) {
                this.getDescContainer().removeDescContainer(PROPERTY_DESC);
            }
            WelcomeManager.getWelcomePageReference().modifylink(this, false);
        }
    }

    public String getProperty(String string) {
        String string2 = null;
        if (null == string || string.trim().length() == 0) {
            string2 = null;
        } else if (null != this.getDescContainer() && null != this.getDescContainer().getDescContainer(PROPERTY_DESC)) {
            string2 = this.getDescContainer().getDescContainer(PROPERTY_DESC).getParasItemValue(string.trim());
        }
        return null == string2 ? "" : string2;
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        try {
            ArrayList arrayList;
            if (null != this.getDescContainer() && null != this.getDescContainer().getDescContainer(PROPERTY_DESC) && null != (arrayList = this.getDescContainer().getDescContainer(PROPERTY_DESC).getPARAS().getPARAArrayList())) {
                for (PARA pARA : arrayList) {
                    properties.setProperty(pARA.getName(), pARA.getValue());
                }
            }
        }
        catch (Exception exception) {
            properties = new Properties();
        }
        return properties;
    }

    public static Point getAvailableXY(ArrayList<WelcomeTextButton> arrayList, Point point, JPanel jPanel) {
        WelcomeTextButton welcomeTextButton = null;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            DraggableButton draggableButton;
            welcomeTextButton = arrayList.get(i);
            if (!(welcomeTextButton instanceof DraggableButton) || (draggableButton = (DraggableButton)welcomeTextButton).getXIndex() != point.x || draggableButton.getYIndex() != point.y) continue;
            Point point2 = DraggableButton.getLastGridPosition(arrayList, jPanel);
            return point2;
        }
        return point;
    }

    private static Point getLastGridPosition(ArrayList<WelcomeTextButton> arrayList, JPanel jPanel) {
        int n;
        Point point = new Point();
        boolean bl = false;
        if (jPanel instanceof ScrollableDragPanel) {
            bl = true;
        }
        int n2 = DraggableButton.getColumnCount(jPanel, bl);
        point.x = -1;
        point.y = -1;
        DraggableButton draggableButton = null;
        WelcomeTextButton welcomeTextButton = null;
        int n3 = arrayList.size();
        for (n = 0; n < n3; ++n) {
            welcomeTextButton = arrayList.get(n);
            if (!(welcomeTextButton instanceof DraggableButton)) continue;
            draggableButton = (DraggableButton)welcomeTextButton;
            point.y = Math.max(point.y, draggableButton.getYIndex());
        }
        if (point.y > -1) {
            for (n = 0; n < n3; ++n) {
                welcomeTextButton = arrayList.get(n);
                if (!(welcomeTextButton instanceof DraggableButton) || ((DraggableButton)welcomeTextButton).getYIndex() != point.y) continue;
                draggableButton = (DraggableButton)welcomeTextButton;
                point.x = Math.max(point.x, draggableButton.getXIndex());
            }
        }
        ++point.x;
        if (point.x > n2 - 1) {
            point.x = 0;
            ++point.y;
        }
        return point;
    }

    public static int getColumnCount(JPanel jPanel, boolean bl) {
        int n = ScreenToolKit.getScreenWidth();
        int n2 = DraggableLayout.getDefaulFixedWidth();
        LayoutManager layoutManager = null;
        if (null != jPanel) {
            layoutManager = jPanel.getLayout();
        }
        if (layoutManager instanceof DraggableLayout) {
            n = ((DraggableLayout)layoutManager).getScreenWidth();
        }
        int n3 = 0;
        if (bl) {
            n3 = 174;
        }
        int n4 = (n - n3) / n2;
        return n4;
    }
}

