/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.windowmanagement.welcomepage.draggable;

import com.swimap.iview.framework.windowmanagement.welcomepage.draggable.DraggableButton;
import com.swimap.iview.framework.windowmanagement.welcomepage.draggable.DraggableLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JPanel;

public class DragAutoScroll {
    private JPanel draggablePanel = null;
    private static final long serialVersionUID = 5003854102590387713L;
    private static final int MARGIN_GAP = 4;
    private static final boolean FIND_WIDTH = true;
    private static final boolean FIND_HEIGHT = false;
    public static final int AUTOSCROLL_MARGIN = 30;
    private static final int SCROLL_WIDTH = 15;

    public DragAutoScroll(JPanel jPanel) {
        this.draggablePanel = jPanel;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.getPreferredWidth(), this.getPreferredHeight());
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.draggablePanel.getPreferredSize();
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        return 30;
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        return 30;
    }

    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    public boolean getScrollableTracksViewportHeight() {
        return true;
    }

    public int getPreferredHeight() {
        return this.getMaxDistance(false) + 15;
    }

    public int getPreferredWidth() {
        return this.getMaxDistance(true);
    }

    protected int getMaxDistance(boolean bl) {
        int n = 0;
        DraggableButton draggableButton = null;
        int n2 = DraggableLayout.getDefaulFixedWidth();
        LayoutManager layoutManager = this.draggablePanel.getLayout();
        if (layoutManager instanceof DraggableLayout) {
            n2 = ((DraggableLayout)layoutManager).getFixedWidth();
        }
        for (Component component : this.draggablePanel.getComponents()) {
            if (!(component instanceof DraggableButton)) continue;
            draggableButton = (DraggableButton)component;
            int n3 = 0;
            n3 = bl ? draggableButton.getX() : draggableButton.getY();
            n = n < (n3 += n2) ? n3 : n;
        }
        return n += 4;
    }

    public void autoscroll(Point point) {
        boolean bl;
        Rectangle rectangle = this.draggablePanel.getBounds();
        boolean bl2 = point.x + rectangle.x <= 30;
        boolean bl3 = point.x + rectangle.x > 30;
        boolean bl4 = point.y + rectangle.y <= 30;
        boolean bl5 = bl = point.y + rectangle.y > 30;
        if (bl2) {
            this.draggablePanel.scrollRectToVisible(new Rectangle(point.x - 30, point.y - 30, 0, 0));
        } else if (bl3) {
            this.draggablePanel.scrollRectToVisible(new Rectangle(point.x, point.y, 30, 30));
        }
        if (bl4) {
            this.draggablePanel.scrollRectToVisible(new Rectangle(point.x - 30, point.y - 30, 0, 0));
        } else if (bl) {
            this.draggablePanel.scrollRectToVisible(new Rectangle(point.x, point.y, 30, 30));
        }
        this.draggablePanel.repaint();
    }

    public Insets getAutoscrollInsets() {
        Rectangle rectangle = this.draggablePanel.getParent().getBounds();
        return new Insets(rectangle.y + 30, rectangle.x + 30, rectangle.y + rectangle.height + 30, rectangle.x + rectangle.width + 30);
    }
}

