/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.windowmanagement.welcomepage;

import com.swimap.iview.commstyle.commini.AreaDescContainer;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.commstyle.resource.i18n.ResourceUtil;
import com.swimap.iview.framework.Main;
import com.swimap.iview.framework.pluginmanagement.Plugin;
import com.swimap.iview.framework.pluginmanagement.PluginManager;
import com.swimap.iview.framework.subsystemmanagement.SubsystemManager;
import com.swimap.iview.framework.util.FrameworkCommandProcessor;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.framework.windowmanagement.welcomepage.AddLinkDialog;
import com.swimap.iview.framework.windowmanagement.welcomepage.ButtonInfo;
import com.swimap.iview.framework.windowmanagement.welcomepage.CategorySettings;
import com.swimap.iview.framework.windowmanagement.welcomepage.ConfigUtilities;
import com.swimap.iview.framework.windowmanagement.welcomepage.CreateWorkbenchDialog;
import com.swimap.iview.framework.windowmanagement.welcomepage.DefaultExportManager;
import com.swimap.iview.framework.windowmanagement.welcomepage.DefaultImportManager;
import com.swimap.iview.framework.windowmanagement.welcomepage.IWelcomeButtonListener;
import com.swimap.iview.framework.windowmanagement.welcomepage.IWorkbenchListener;
import com.swimap.iview.framework.windowmanagement.welcomepage.WelcomeButtonEvent;
import com.swimap.iview.framework.windowmanagement.welcomepage.WelcomeButtonInfo;
import com.swimap.iview.framework.windowmanagement.welcomepage.WelcomeManager;
import com.swimap.iview.framework.windowmanagement.welcomepage.WelcomePage;
import com.swimap.iview.framework.windowmanagement.welcomepage.WelcomeTextButton;
import com.swimap.iview.framework.windowmanagement.welcomepage.WelcomeUtilities;
import com.swimap.iview.framework.windowmanagement.welcomepage.WorkbenchButton;
import com.swimap.iview.framework.windowmanagement.welcomepage.WorkbenchEvent;
import com.swimap.iview.framework.windowmanagement.welcomepage.WorkbenchInfo;
import com.swimap.iview.framework.windowmanagement.welcomepage.WorkbenchModifyDialog;
import com.swimap.iview.framework.windowmanagement.welcomepage.draggable.DraggableButton;
import com.swimap.iview.framework.windowmanagement.welcomepage.exception.ButtonInfoException;
import com.swimap.iview.util.OptionPane;
import com.swimap.iview.util.helpmanagement.HelpManager;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class WorkbenchManager {
    static ResourceBundle res = WelcomeUtilities.res;
    public static final String WORKBENCH_SETTING_DESC = "workbenchsetting";
    private static final int ARRAY_INDEX = 10;
    private Map<WelcomeTextButton, CommStyleInfo> commMap = new HashMap<WelcomeTextButton, CommStyleInfo>(10);
    private List<WelcomeTextButton> enableList = new ArrayList<WelcomeTextButton>(10);
    private ArrayList<WorkbenchButton> workbenchButtons = null;
    private static IviewLogger logger = IviewLogger.getLogger(WorkbenchManager.class, "IVIEW");
    private ArrayList<IWorkbenchListener> wbListeners = new ArrayList(10);
    private ArrayList<IWelcomeButtonListener> buttonListeners = new ArrayList(10);
    private ConcurrentHashMap<String, ArrayList<WelcomeTextButton>> benchContents = new ConcurrentHashMap(10);
    private ConcurrentHashMap<String, ArrayList<WorkbenchButton>> idWorkBenchMap = new ConcurrentHashMap(10);
    private WorkbenchButton selectedWorkBench = null;
    private WorkbenchButton defaultWorkbench = null;
    private static CommStyleInfo importCommstyle = null;
    private static final String XML_EXT = ".xml";
    private JMenuItem addLink = null;
    private ArrayList<String> buttonNameSet = new ArrayList(16);

    WorkbenchManager() {
        this.initialize();
    }

    public ArrayList<WorkbenchInfo> getAllWorkbenches() {
        ArrayList<WorkbenchInfo> arrayList = new ArrayList<WorkbenchInfo>(0);
        if (!ConfigUtilities.isDraggableLayout()) {
            return arrayList;
        }
        ArrayList<WorkbenchInfo> arrayList2 = null;
        ArrayList<String> arrayList3 = new ArrayList<String>(0);
        for (WorkbenchButton workbenchButton : this.workbenchButtons) {
            if (arrayList3.contains(workbenchButton.getWorkbenchId())) continue;
            arrayList3.add(workbenchButton.getWorkbenchId());
            arrayList2 = this.getWorkbenchById(workbenchButton.getWorkbenchId());
            if (null == arrayList2) continue;
            arrayList.addAll(arrayList2);
        }
        return arrayList;
    }

    public ArrayList<WorkbenchInfo> getVisibleWorkbenches() {
        ArrayList<WorkbenchInfo> arrayList = new ArrayList<WorkbenchInfo>(0);
        if (!ConfigUtilities.isDraggableLayout()) {
            return arrayList;
        }
        ArrayList<String> arrayList2 = new ArrayList<String>(0);
        for (WorkbenchButton workbenchButton : this.workbenchButtons) {
            if (!workbenchButton.isSelected() || arrayList2.contains(workbenchButton.getWorkbenchId())) continue;
            arrayList2.add(workbenchButton.getWorkbenchId());
            ArrayList<WorkbenchButton> arrayList3 = this.idWorkBenchMap.get(workbenchButton.getWorkbenchId());
            for (WorkbenchButton workbenchButton2 : arrayList3) {
                if (!workbenchButton2.isSelected()) continue;
                arrayList.add(new WorkbenchInfo(workbenchButton2));
            }
        }
        return arrayList;
    }

    public ArrayList<WorkbenchInfo> getWorkbenchById(String string) {
        ArrayList<WorkbenchInfo> arrayList = new ArrayList<WorkbenchInfo>(0);
        if (!ConfigUtilities.isDraggableLayout() || null == string) {
            return arrayList;
        }
        ArrayList<WorkbenchButton> arrayList2 = this.idWorkBenchMap.get(string);
        if (null == arrayList2) {
            return arrayList;
        }
        for (WorkbenchButton workbenchButton : arrayList2) {
            arrayList.add(new WorkbenchInfo(workbenchButton));
        }
        return arrayList;
    }

    public ArrayList<WelcomeButtonInfo> getAllWelcomeButtons(String string) {
        return this.getWelcomeButtons(string, false);
    }

    public void setAllWorkBenchsWelcomeButtonEnable(String string, boolean bl) {
        WelcomePage welcomePage = WelcomeManager.getWelcomeRef();
        if (null == welcomePage) {
            logger.trace("Show/Hide failed as WelcomePage is not inited.");
            return;
        }
        if (null == string) {
            throw new IllegalArgumentException("Wlecomebutton Id cannot be null");
        }
        int n = ConfigUtilities.getLayoutType();
        if (n == 1 || n == 0) {
            ArrayList<WelcomeTextButton> arrayList = new ArrayList<WelcomeTextButton>(1);
            welcomePage.setAllWorkBenchWelcomeButtonEnable(string, bl, arrayList);
        } else {
            this.setAllWorkBenchWelcomeButtonEnable(string, bl);
        }
    }

    private void setAllWorkBenchWelcomeButtonEnable(String string, boolean bl) {
        WelcomePage welcomePage = WelcomeManager.getWelcomeRef();
        if (null == welcomePage) {
            logger.trace("Show/Hide failed as WelcomePage is not inited.");
            return;
        }
        if (null == string) {
            throw new IllegalArgumentException("Wlecomebutton Id cannot be null");
        }
        Set set = this.benchContents.keySet();
        ArrayList<WelcomeTextButton> arrayList = new ArrayList<WelcomeTextButton>(1);
        for (String string2 : set) {
            arrayList.clear();
            ArrayList<WelcomeTextButton> arrayList2 = this.benchContents.get(string2);
            for (WelcomeTextButton welcomeTextButton : arrayList2) {
                String string3 = welcomePage.getWelcomeButtonIDButton(welcomeTextButton);
                if (!ResourceUtil.areEquals(string, string3)) continue;
                welcomePage.enableDisableAllWorkBenchWelcomeButton(bl, string, welcomeTextButton, arrayList);
            }
        }
    }

    public void setAllWorkBenchsWelcomeButtonVisibility(String string, boolean bl) {
        WelcomePage welcomePage = WelcomeManager.getWelcomeRef();
        if (null == welcomePage) {
            logger.trace("Show/Hide failed as WelcomePage is not inited.");
            return;
        }
        if (null == string) {
            throw new IllegalArgumentException("Wlecomebutton Id cannot be null");
        }
        int n = ConfigUtilities.getLayoutType();
        if (n == 1 || n == 0) {
            ArrayList<WelcomeTextButton> arrayList = new ArrayList<WelcomeTextButton>(1);
            welcomePage.setAllWorkBenchWelcomeButtonVisibility(string, bl, arrayList);
        } else {
            this.setAllWorkBenchWelcomeButtonVisibility(string, bl);
        }
    }

    private void setAllWorkBenchWelcomeButtonVisibility(String string, boolean bl) {
        WelcomePage welcomePage = WelcomeManager.getWelcomeRef();
        if (null == welcomePage) {
            logger.trace("Show/Hide failed as WelcomePage is not inited.");
            return;
        }
        if (null == string) {
            throw new IllegalArgumentException("Wlecomebutton Id cannot be null");
        }
        Set<Map.Entry<String, ArrayList<WelcomeTextButton>>> set = this.benchContents.entrySet();
        ArrayList<WelcomeTextButton> arrayList = new ArrayList<WelcomeTextButton>(1);
        for (Map.Entry<String, ArrayList<WelcomeTextButton>> entry : set) {
            arrayList.clear();
            String string2 = entry.getKey();
            for (WelcomeTextButton welcomeTextButton : entry.getValue()) {
                String string3 = welcomePage.getWelcomeButtonIDButton(welcomeTextButton);
                if (!ResourceUtil.areEquals(string, string3)) continue;
                welcomePage.showHideAllWorkBenchWelcomeButton(bl, string2, string, welcomeTextButton, arrayList);
            }
        }
    }

    ArrayList<WelcomeButtonInfo> getWelcomeButtons(String string, boolean bl) {
        ArrayList<WelcomeButtonInfo> arrayList = new ArrayList<WelcomeButtonInfo>(2);
        if (null == string) {
            return arrayList;
        }
        ArrayList<WelcomeTextButton> arrayList2 = this.benchContents.get(string);
        if (null != arrayList2) {
            for (WelcomeTextButton object : arrayList2) {
                if (!object.isSelected()) continue;
                arrayList.add(new WelcomeButtonInfo(object));
            }
        }
        if (!bl) {
            Set<WelcomeTextButton> set = WelcomeManager.getWelcomeRef().getAllLoadedButtons();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                WelcomeTextButton welcomeTextButton = (WelcomeTextButton)iterator.next();
                if (!ResourceUtil.areEquals(((DraggableButton)welcomeTextButton).getWorkbenchId(), string) || null != arrayList2 && arrayList2.contains(welcomeTextButton)) continue;
                arrayList.add(new WelcomeButtonInfo(welcomeTextButton));
            }
        }
        return arrayList;
    }

    private void initialize() {
        this.workbenchButtons = this.readWelcomeButtonConfig();
        this.rearrangeWorkbenches();
    }

    private void rearrangeWorkbenches() {
        if (null == this.workbenchButtons) {
            return;
        }
        Collections.sort(this.workbenchButtons, WelcomeManager.SL_NUMBER_COMPTR);
        if (null != this.defaultWorkbench && this.workbenchButtons.remove(this.defaultWorkbench)) {
            this.workbenchButtons.add(this.defaultWorkbench);
        }
        if (null == this.selectedWorkBench) {
            this.selectedWorkBench = this.getFirstWorkbenchButton();
        }
    }

    private ArrayList<WorkbenchButton> readWelcomeButtonConfig() {
        ArrayList<WorkbenchButton> arrayList = new ArrayList<WorkbenchButton>(10);
        List<Plugin> list = PluginManager.getInstance().getStartupPluginList();
        int n = 0;
        String[] stringArray = FrameworkCommandProcessor.getInstance().getFilteredExtPaths(Main.extPaths);
        if (stringArray != null) {
            n = stringArray.length;
            CommStyleInfo commStyleInfo = null;
            for (int i = 0; i < n; ++i) {
                String string = "conf/" + stringArray[i] + "/welcomebutton";
                commStyleInfo = CommStyleManager.getInstance().getCommonStyleFile(string, true);
                if (null == commStyleInfo) continue;
                commStyleInfo.setRelatFileName(string);
                WelcomeManager.addWelcomeButtonInfoToMap(string, commStyleInfo);
                this.createWBButton(commStyleInfo, arrayList);
                this.readCategory(commStyleInfo);
            }
        }
        int n2 = 0;
        if (list != null && 0 < list.size()) {
            CommStyleInfo commStyleInfo = null;
            n2 = list.size();
            for (int i = 0; i < n2; ++i) {
                if (WorkbenchManager.isAllUserPersistance()) {
                    commStyleInfo = list.get(i).getIntegrateCommStyleReader().getAllUserCommStyleInfo("welcomebutton");
                    if (null != commStyleInfo) {
                        WelcomeManager.addWelcomeButtonInfoToMap(list.get(i).getPluginName() + "/alluser", commStyleInfo);
                    }
                } else {
                    commStyleInfo = list.get(i).getIntegrateCommStyleReader().getUserCommStyleInfo("welcomebutton");
                    if (null != commStyleInfo) {
                        WelcomeManager.addWelcomeButtonInfoToMap(list.get(i).getPluginName() + "/user", commStyleInfo);
                    }
                }
                if (null == commStyleInfo) continue;
                this.createWBButton(commStyleInfo, arrayList);
                this.readCategory(commStyleInfo);
            }
        }
        if (null != (importCommstyle = WorkbenchManager.readImportCommInfo())) {
            this.createWBButton(importCommstyle, arrayList);
        }
        return arrayList;
    }

    void readWorkbenchInfo(CommStyleInfo commStyleInfo) {
        if (null == commStyleInfo) {
            return;
        }
        ArrayList<WorkbenchButton> arrayList = new ArrayList<WorkbenchButton>(10);
        this.createWBButton(commStyleInfo, arrayList);
        for (WorkbenchButton workbenchButton : arrayList) {
            this.workbenchButtons.add(workbenchButton);
        }
        this.readCategory(commStyleInfo);
    }

    private void readCategory(CommStyleInfo commStyleInfo) {
        DescContainer descContainer;
        AreaDescContainer areaDescContainer = null;
        if (commStyleInfo.getAreaDescContainerCount() > 0 && null != (descContainer = (areaDescContainer = commStyleInfo.getAreaDescContainer(0)).getDescContainer("categorysetting"))) {
            DescContainer[] descContainerArray = descContainer.getDescContainer();
            String string = null;
            String string2 = null;
            String string3 = null;
            for (DescContainer descContainer2 : descContainerArray) {
                String string4 = descContainer2.getDescName();
                string = commStyleInfo.getResString(string4);
                if (null == string && null == (string = string4)) continue;
                string2 = descContainer2.getParasItemValue("parent");
                string3 = commStyleInfo.getResString(string2);
                if (null == string3) {
                    string3 = string2;
                }
                int n = Integer.MAX_VALUE;
                try {
                    int n2 = Integer.parseInt(descContainer2.getParasItemValue("linkseqnumber"));
                    if (n2 >= 0) {
                        n = n2;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    n = Integer.MAX_VALUE;
                }
                CategorySettings.getInstance().addCategoryInfo(string4, string, string2, string3, n);
            }
        }
    }

    private void createWBButton(CommStyleInfo commStyleInfo, ArrayList<WorkbenchButton> arrayList) {
        DescContainer descContainer = null;
        try {
            if (null != commStyleInfo && 0 >= commStyleInfo.getAreaDescContainerCount()) {
                logger.info("GetAreaDescContainerCount is less than or equal to zero");
                return;
            }
            this.setResourceBundle(commStyleInfo);
            descContainer = commStyleInfo.getAreaDescContainer(0).getDescContainer(WORKBENCH_SETTING_DESC);
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
        if (null == descContainer) {
            return;
        }
        int n = descContainer.getDescContainerCount();
        DescContainer descContainer2 = null;
        for (int i = 0; i < n; ++i) {
            descContainer2 = descContainer.getDescContainer(i);
            if (null == descContainer2.getDescName() || descContainer2.getDescName().trim().length() == 0 || null == descContainer2.getParasItemValue("name") || descContainer2.getParasItemValue("name").trim().length() == 0) continue;
            try {
                WorkbenchButton workbenchButton;
                boolean bl = Boolean.valueOf(descContainer2.getParasItemValue("dynamic"));
                if (!this.workBenchValidation(descContainer2) || null == (workbenchButton = this.createWBButton(descContainer2, commStyleInfo, bl))) continue;
                arrayList.add(workbenchButton);
                continue;
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
            }
        }
    }

    WorkbenchButton createWBButton(DescContainer descContainer, CommStyleInfo commStyleInfo, boolean bl) {
        if (null == descContainer || null == commStyleInfo) {
            return null;
        }
        WorkbenchButton workbenchButton = (WorkbenchButton)WorkbenchButton.getUIObject(descContainer, bl);
        if (workbenchButton.isClickSelected() && (workbenchButton.isUserEnable() && workbenchButton.isSelected() || !workbenchButton.isUserEnable())) {
            this.selectedWorkBench = workbenchButton;
        }
        JPopupMenu jPopupMenu = this.getButtonPopupMenu(workbenchButton);
        workbenchButton.setPopupMenu(jPopupMenu);
        String string = workbenchButton.getWorkbenchId();
        if (null != string && "_default_iview_workbenches".equals(string)) {
            this.defaultWorkbench = workbenchButton;
        }
        if (null == this.idWorkBenchMap.get(string)) {
            ArrayList<WorkbenchButton> arrayList = new ArrayList<WorkbenchButton>(10);
            arrayList.add(workbenchButton);
            this.idWorkBenchMap.put(string, arrayList);
        } else {
            this.idWorkBenchMap.get(string).add(workbenchButton);
        }
        if (workbenchButton.isUserEnable()) {
            this.enableList.add(workbenchButton);
            this.setAddMenuState();
        } else if (!workbenchButton.isSelected()) {
            this.refreshDialog(workbenchButton);
        }
        this.commMap.put(workbenchButton, commStyleInfo);
        if (workbenchButton.isSelected()) {
            workbenchButton.initializeButton();
            workbenchButton.addClickListener();
        }
        return workbenchButton;
    }

    private void refreshDialog(WorkbenchButton workbenchButton) {
        if (workbenchButton.isUserEnable()) {
            return;
        }
        if (this.enableList.contains(workbenchButton)) {
            this.enableList.remove(workbenchButton);
        } else {
            this.enableList.add(workbenchButton);
        }
        this.setAddMenuState();
    }

    final JPopupMenu getButtonPopupMenu(WorkbenchButton workbenchButton) {
        final JPopupMenu jPopupMenu = new JPopupMenu();
        final WelcomePage welcomePage = WelcomeManager.getWelcomeRef();
        final JMenuItem jMenuItem = this.getModifyWbenchLink(workbenchButton);
        jPopupMenu.add(jMenuItem);
        final JSeparator jSeparator = new JSeparator();
        final JMenuItem jMenuItem2 = this.getRemoveWbenchLink(workbenchButton);
        jPopupMenu.add(jMenuItem2);
        jPopupMenu.add(jSeparator);
        final JMenuItem jMenuItem3 = this.getImportWbenchLink();
        jPopupMenu.add(jMenuItem3);
        final JMenuItem jMenuItem4 = this.getExportWbenchLink(workbenchButton);
        jPopupMenu.add(jMenuItem4);
        jPopupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                jMenuItem.setVisible(WelcomeManager.popupvisibilemap.get((Object)WelcomeManager.WBpopupMenuItems.Workbench_ModifyLink));
                jMenuItem2.setVisible(WelcomeManager.popupvisibilemap.get((Object)WelcomeManager.WBpopupMenuItems.Workbench_RemoveLink));
                jMenuItem3.setVisible(WelcomeManager.isShowImportWBMenuItem());
                jMenuItem4.setVisible(WelcomeManager.isShowExportWBMenuItem());
                jSeparator.setVisible(jMenuItem3.isVisible() || jMenuItem4.isVisible());
                welcomePage.validateMenuSeparators(jPopupMenu);
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }
        });
        welcomePage.validateMenuSeparators(jPopupMenu);
        return jPopupMenu;
    }

    private JMenuItem getExportWbenchLink(final WorkbenchButton workbenchButton) {
        JMenuItem jMenuItem = new JMenuItem(res.getString("Export_Workbench_Link"));
        jMenuItem.setName("ExportWorkbench");
        jMenuItem.setMnemonic('E');
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                workbenchButton.processClick();
                WorkbenchManager.this.showExportWorkbench(workbenchButton);
            }
        });
        return jMenuItem;
    }

    protected void showExportWorkbench(WorkbenchButton workbenchButton) {
        String string = WelcomeUtilities.getWBExportFileName(workbenchButton.getFullName());
        if (null != string) {
            DefaultExportManager defaultExportManager = new DefaultExportManager(workbenchButton, string);
            defaultExportManager.exportWorkbench();
        }
    }

    private JMenuItem getRemoveWbenchLink(final WorkbenchButton workbenchButton) {
        String string = res.getString("Close_Workbench");
        if (workbenchButton.isDynamic()) {
            string = res.getString("Remove_Workbench");
        }
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.setName("Workbench_RemoveLink");
        if (workbenchButton.isDynamic()) {
            jMenuItem.setMnemonic('R');
        } else {
            jMenuItem.setMnemonic('C');
        }
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                workbenchButton.processClick();
                try {
                    WorkbenchManager.this.removeWorkBench(new WorkbenchInfo(workbenchButton), FrameworkUtilities.getMainFrame());
                }
                catch (ButtonInfoException buttonInfoException) {
                    logger.trace(buttonInfoException);
                }
            }
        });
        jMenuItem.setEnabled(workbenchButton.isRemovable());
        return jMenuItem;
    }

    private JMenuItem getModifyWbenchLink(final WorkbenchButton workbenchButton) {
        JMenuItem jMenuItem = new JMenuItem(res.getString("Modify_Workbench"));
        jMenuItem.setName("Workbench_ModifyLink");
        jMenuItem.setMnemonic('M');
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                workbenchButton.processClick();
                try {
                    WorkbenchManager.this.modifyWorkBench(new WorkbenchInfo(workbenchButton), FrameworkUtilities.getMainFrame(), null);
                }
                catch (ButtonInfoException buttonInfoException) {
                    logger.trace(buttonInfoException);
                }
            }
        });
        return jMenuItem;
    }

    protected void removeWorkBench(WorkbenchInfo workbenchInfo, Window window) throws ButtonInfoException {
        if (null == workbenchInfo || null == workbenchInfo.getButton()) {
            throw new ButtonInfoException("Provided workbench button is not valid");
        }
        WorkbenchButton workbenchButton = (WorkbenchButton)workbenchInfo.getButton();
        if (!workbenchButton.isRemovable()) {
            throw new ButtonInfoException("Workbench '" + workbenchButton.getButtonName() + "' with id " + workbenchInfo.getId() + " is not removable.");
        }
        if (!workbenchButton.isSelected()) {
            throw new ButtonInfoException("Workbench '" + workbenchButton.getButtonName() + "' with id " + workbenchInfo.getId() + " is already removed.");
        }
        String string = res.getString("Confirm_Workbench_Close");
        if (workbenchButton.isDynamic()) {
            string = res.getString("Confirm_Workbench_Remove");
        }
        WorkbenchButton workbenchButton2 = this.selectedWorkBench;
        workbenchButton.processClick();
        this.selectedWorkBench = workbenchButton2;
        int n = OptionPane.showConfirmDialog(window, string, res.getString("Confirm"), 0);
        if (n != 0) {
            return;
        }
        if (workbenchButton.isDynamic()) {
            this.deleteWorkbench(workbenchButton);
        } else {
            this.closeWorkbench(workbenchButton);
        }
        if (ResourceUtil.areEquals(this.selectedWorkBench.getWorkbenchId(), workbenchButton.getWorkbenchId())) {
            this.selectedWorkBench = this.getNextWorkbenchButton(this.selectedWorkBench);
            if (null == this.selectedWorkBench) {
                this.selectedWorkBench = this.getFirstWorkbenchButton();
            }
        }
        if (null != this.selectedWorkBench) {
            this.selectedWorkBench.forceClick();
        } else {
            WelcomeManager.getWelcomePageReference().resetToDefaultBackground();
            WelcomeManager.getWelcomePageReference().refreshWelcomePage();
        }
    }

    private void deleteWorkbench(WorkbenchButton workbenchButton) {
        WorkbenchInfo workbenchInfo = new WorkbenchInfo(workbenchButton);
        WorkbenchManager.deleteExistingButtons(workbenchInfo);
        workbenchButton.setSaveRequired(true);
        workbenchButton.setPopupMenu(null);
        workbenchButton.removeClickListener();
        workbenchButton.removeIconComponent();
        WorkbenchManager.deleteExistingButton(workbenchInfo);
        workbenchButton.removeFocusListener();
    }

    static void deleteExistingButtons(WorkbenchInfo workbenchInfo) {
        WorkbenchManager workbenchManager = WelcomeManager.getWorkbenchManager();
        if (null == workbenchManager) {
            return;
        }
        ArrayList<WelcomeButtonInfo> arrayList = workbenchManager.getAllWelcomeButtons(workbenchInfo.getId());
        for (WelcomeButtonInfo welcomeButtonInfo : arrayList) {
            WorkbenchManager.deleteExistingButton(welcomeButtonInfo);
        }
        workbenchManager.deleteButtons(workbenchInfo);
    }

    private static void deleteExistingButton(ButtonInfo buttonInfo) {
        WorkbenchButton workbenchButton;
        WorkbenchManager workbenchManager = WelcomeManager.getWorkbenchManager();
        WelcomeTextButton welcomeTextButton = buttonInfo.getButton();
        DescContainer descContainer = welcomeTextButton.getDescContainer();
        DescContainer descContainer2 = (DescContainer)descContainer._getParent();
        descContainer2.removeDescContainer(descContainer);
        if (welcomeTextButton instanceof DraggableButton) {
            CommStyleInfo commStyleInfo = (CommStyleInfo)descContainer._getRootParent();
            if (welcomeTextButton.isExecutable()) {
                try {
                    WelcomeManager.getWelcomeRef().writeToUser(commStyleInfo);
                }
                catch (IOException iOException) {
                    logger.trace("write to user failed." + iOException);
                }
            } else {
                WorkbenchManager.updateInfo(commStyleInfo);
            }
            WelcomeManager.getWelcomeRef().modifylink(welcomeTextButton, true);
            WelcomeManager.getWelcomeRef().removeButtonReference((DraggableButton)welcomeTextButton);
            workbenchManager.fireWelcomeButtonEvent(welcomeTextButton, 2);
        } else if (welcomeTextButton instanceof WorkbenchButton && (workbenchButton = (WorkbenchButton)welcomeTextButton).isDynamic()) {
            workbenchManager.removeDynamicWorkBenchReference(workbenchButton);
            workbenchManager.fireWorkbenchEvent(workbenchButton, 2);
        }
    }

    private void removeDynamicWorkBenchReference(WorkbenchButton workbenchButton) {
        workbenchButton.storelink(this.commMap.get(workbenchButton));
        this.enableList.remove(workbenchButton);
        this.workbenchButtons.remove(workbenchButton);
        this.commMap.remove(workbenchButton);
        this.benchContents.remove(workbenchButton.getWorkbenchId());
        List list = this.idWorkBenchMap.get(workbenchButton.getWorkbenchId());
        if (null != list && list.size() != 0) {
            list.remove(workbenchButton);
        }
        if ((list = (List)this.idWorkBenchMap.get(workbenchButton.getWorkbenchId())) == null || list.isEmpty()) {
            this.idWorkBenchMap.remove(workbenchButton.getWorkbenchId());
        }
        this.buttonNameSet.remove(workbenchButton.getFullName());
    }

    private void closeWorkbench(WorkbenchButton workbenchButton) {
        this.refreshDialog(workbenchButton);
        workbenchButton.setSelected(false);
        this.fireWorkbenchEvent(workbenchButton, 2);
        workbenchButton.setSaveRequired(true);
        workbenchButton.removeClickListener();
        workbenchButton.removeIconComponent();
    }

    private WorkbenchButton getNextWorkbenchButton(WorkbenchButton workbenchButton) {
        TreeMap<Integer, WorkbenchButton> treeMap = new TreeMap<Integer, WorkbenchButton>();
        WorkbenchButton workbenchButton2 = null;
        Iterator<WorkbenchButton> iterator = this.workbenchButtons.iterator();
        boolean bl = iterator.hasNext();
        while (bl) {
            workbenchButton2 = iterator.next();
            if (workbenchButton2.isSelected()) {
                treeMap.put(workbenchButton2.getYPosition(), workbenchButton2);
            }
            bl = iterator.hasNext();
        }
        Integer n = treeMap.higherKey(workbenchButton.getYPosition());
        if (n == null) {
            if (treeMap.size() > 0) {
                return (WorkbenchButton)treeMap.firstEntry().getValue();
            }
            return null;
        }
        return (WorkbenchButton)treeMap.get(n);
    }

    private WorkbenchButton getFirstWorkbenchButton() {
        for (WorkbenchButton workbenchButton : this.workbenchButtons) {
            if (null == workbenchButton || !workbenchButton.isSelected()) continue;
            return workbenchButton;
        }
        return null;
    }

    private static WorkbenchButton getLastSelectedWorkbenchButton(ArrayList<WelcomeTextButton> arrayList) {
        WorkbenchButton workbenchButton = null;
        Iterator<WelcomeTextButton> iterator = arrayList.iterator();
        boolean bl = iterator.hasNext();
        while (bl) {
            workbenchButton = (WorkbenchButton)iterator.next();
            bl = iterator.hasNext();
        }
        return workbenchButton;
    }

    protected void modifyWorkBench(WorkbenchInfo workbenchInfo, Window window, String string) throws ButtonInfoException {
        if (null == workbenchInfo || null == workbenchInfo.getButton()) {
            throw new ButtonInfoException("Provided Workbench button is not valid");
        }
        WorkbenchButton workbenchButton = (WorkbenchButton)workbenchInfo.getButton();
        if (!workbenchButton.isSelected()) {
            throw new ButtonInfoException("Workbench " + workbenchButton + " is not visible");
        }
        workbenchButton.processClick();
        WorkbenchModifyDialog workbenchModifyDialog = new WorkbenchModifyDialog((WelcomeTextButton)workbenchButton, window, this);
        if (null != string) {
            workbenchModifyDialog.setTitle(string);
        }
        workbenchModifyDialog.setName("WelcomePage_modifyLinkDlg");
        HelpManager helpManager = HelpManager.getInstance();
        helpManager.enableHelpKey(workbenchModifyDialog.getRootPane(), "iVIEW.WelcomePage.ModifyWorkbenchDialog");
        workbenchModifyDialog.setVisible(true);
        if (workbenchModifyDialog.isButtonModified()) {
            workbenchButton.refreshButton(true);
            if (workbenchModifyDialog.isIconModified()) {
                workbenchButton.removeIconComponent();
                workbenchButton.initializeButton();
                workbenchButton.addClickListener();
            }
            if (workbenchModifyDialog.isbackgroundModified()) {
                workbenchButton.changeBackGroundImage();
            }
            this.fireWorkbenchEvent(workbenchButton, 1);
            workbenchButton.setSaveRequired(true);
        }
    }

    private void setResourceBundle(CommStyleInfo commStyleInfo) {
        int n = commStyleInfo.getAreaDescContainer(0).getDescCount();
        String string = null;
        DescContainer descContainer = null;
        for (int i = 0; i < n; ++i) {
            descContainer = commStyleInfo.getAreaDescContainer(0).getDescContainer(i);
            string = descContainer.getParasItemValue("type");
            if (string == null) {
                logger.trace("this desc have no type tag (descname: " + descContainer.getDescName() + ')');
                continue;
            }
            if (!"ResourceBundle".equals(descContainer.getParasItemValue("type"))) continue;
            ResourceBundle resourceBundle = null;
            String string2 = descContainer.getParasItemValue("resourceBundleName");
            try {
                resourceBundle = null != commStyleInfo.getPluginName() ? commStyleInfo.getResource().getResourceBundleFromPropertyFile(string2) : ResourceMng.getInstance().getResourceBundleFromPropertyFile(string2);
                if (null == resourceBundle) {
                    resourceBundle = ResourceBundle.getBundle(string2);
                }
            }
            catch (Exception exception) {
                logger.trace("Exception occured in bundle  while getting the resource..");
            }
            commStyleInfo.setResourceBundle(resourceBundle);
        }
    }

    protected final ArrayList<WorkbenchButton> retrieveWorkbenchButtons() {
        return this.workbenchButtons;
    }

    protected void addWorkBenchInfo(WelcomeTextButton welcomeTextButton) {
        ArrayList<WelcomeTextButton> arrayList;
        String string = ((DraggableButton)welcomeTextButton).getWorkbenchId();
        if (null == string || string.trim().length() == 0) {
            string = "_default_iview_workbenches";
        }
        if (null == (arrayList = this.benchContents.get(string))) {
            arrayList = new ArrayList(10);
        } else {
            this.benchContents.remove(string);
        }
        arrayList.add(welcomeTextButton);
        this.benchContents.put(string, arrayList);
    }

    protected final ArrayList<WelcomeTextButton> getSelectedWPButtons() {
        if (null == this.selectedWorkBench) {
            return new ArrayList<WelcomeTextButton>(0);
        }
        return this.getWPButtons(this.selectedWorkBench.getWorkbenchId());
    }

    protected final ArrayList<WelcomeTextButton> getWPButtons(String string) {
        ArrayList<WelcomeTextButton> arrayList = new ArrayList<WelcomeTextButton>(0);
        if (null != string) {
            arrayList = this.benchContents.get(string);
        }
        if (null == arrayList) {
            arrayList = new ArrayList(0);
        }
        return arrayList;
    }

    protected void setSelectedWorkBench(WorkbenchButton workbenchButton) {
        this.selectedWorkBench = workbenchButton;
    }

    protected void setFreshLoading(boolean bl) {
        if (null != this.selectedWorkBench) {
            this.selectedWorkBench.setFreshLoading(bl);
        }
    }

    protected final boolean isFreshLoading() {
        boolean bl = false;
        if (null != this.selectedWorkBench) {
            bl = this.selectedWorkBench.isFreshLoading();
        }
        return bl;
    }

    final WorkbenchButton getSelectedWBench() {
        return this.selectedWorkBench;
    }

    protected void removeWelcomeButton(WelcomeTextButton welcomeTextButton) {
        String string = ((DraggableButton)welcomeTextButton).getWorkbenchId();
        ArrayList<WelcomeTextButton> arrayList = this.benchContents.get(string);
        if (null != arrayList) {
            arrayList.remove(welcomeTextButton);
        }
    }

    protected JPopupMenu getPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(this.getAddWbenchLink());
        jPopupMenu.add(this.getCreateWbenchLink());
        final JSeparator jSeparator = new JSeparator();
        jPopupMenu.add(jSeparator);
        final JMenuItem jMenuItem = this.getImportWbenchLink();
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                WorkbenchManager.this.setAddMenuState();
                jMenuItem.setVisible(WelcomeManager.isShowImportWBMenuItem());
                jSeparator.setVisible(jMenuItem.isVisible());
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }
        });
        return jPopupMenu;
    }

    private JMenuItem getImportWbenchLink() {
        JMenuItem jMenuItem = new JMenuItem(res.getString("Import_Workbench_Link"));
        jMenuItem.setName("ImportWorkbench");
        jMenuItem.setMnemonic('I');
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WorkbenchManager.this.showImportWorkbench();
            }
        });
        return jMenuItem;
    }

    private JMenuItem getAddWbenchLink() {
        this.addLink = new JMenuItem(res.getString("Add_Workbench_Link"));
        this.addLink.setName("Add Workbench");
        this.addLink.setMnemonic('A');
        this.addLink.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WorkbenchManager.this.addWorkbenches(FrameworkUtilities.getMainFrame(), null);
            }
        });
        this.setAddMenuState();
        return this.addLink;
    }

    private JMenuItem getCreateWbenchLink() {
        JMenuItem jMenuItem = new JMenuItem(res.getString("Create_Workbench_Menu"));
        jMenuItem.setName("Create Workbench");
        jMenuItem.setMnemonic('C');
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WorkbenchManager.this.createDynamicWorkbench();
            }
        });
        return jMenuItem;
    }

    protected void createDynamicWorkbench() {
        ArrayList<String> arrayList = this.getDynamicWorkbenchIds();
        CreateWorkbenchDialog createWorkbenchDialog = new CreateWorkbenchDialog((Window)FrameworkUtilities.getMainFrame(), arrayList, this);
        createWorkbenchDialog.setName("WelcomePage_WorkbenchCreateDlg");
        createWorkbenchDialog.setVisible(true);
        DescContainer descContainer = createWorkbenchDialog.getWorkbenchButtonDesc();
        if (null == descContainer) {
            return;
        }
        if (null == importCommstyle) {
            importCommstyle = WorkbenchManager.getCreatedImportCommStyle();
        }
        importCommstyle.getAreaDescContainer(0).getDescContainer(WORKBENCH_SETTING_DESC).addDescContainer(descContainer);
        DescContainer descContainer2 = importCommstyle.getAreaDescContainer(0).getDescContainer(WORKBENCH_SETTING_DESC).getDescContainer(descContainer.getDescName());
        WorkbenchButton workbenchButton = this.createWBButton(descContainer2, importCommstyle, true);
        workbenchButton.setSaveRequired(true);
        this.addWorkbenchference(workbenchButton);
        this.fireWorkbenchEvent(workbenchButton, 0);
        workbenchButton.forceClick();
    }

    private ArrayList<String> getDynamicWorkbenchIds() {
        ArrayList<String> arrayList = new ArrayList<String>(1);
        try {
            DescContainer[] descContainerArray = importCommstyle.getAreaDescContainer(0).getDescContainer(WORKBENCH_SETTING_DESC).getDescContainer();
            String string = null;
            for (DescContainer descContainer : descContainerArray) {
                string = descContainer.getDescName();
                if (null == string || !string.startsWith("_dynamic_iview_workbench_")) continue;
                arrayList.add(string);
            }
        }
        catch (Exception exception) {
            arrayList = new ArrayList(1);
        }
        return arrayList;
    }

    protected void addWorkbenches(Window window, String string) {
        AddLinkDialog addLinkDialog = new AddLinkDialog(window, this.enableList, 2, string);
        addLinkDialog.setTitle(string, 2);
        addLinkDialog.setName("WelcomePage_FunctionLinkDlg");
        addLinkDialog.setVisible(true);
        ArrayList<WelcomeTextButton> arrayList = addLinkDialog.getSelectedButtons();
        if (null != arrayList) {
            Iterator<WelcomeTextButton> iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                this.addWorkbench((WorkbenchButton)iterator.next());
            }
            if (arrayList.size() > 0) {
                this.selectedWorkBench = WorkbenchManager.getLastSelectedWorkbenchButton(arrayList);
                if (null != this.selectedWorkBench) {
                    this.selectedWorkBench.forceClick();
                    WelcomeManager.getWelcomeRef().refreshWelcomePage();
                }
            }
        }
    }

    private void addWorkbench(WorkbenchButton workbenchButton) {
        if (null == workbenchButton) {
            return;
        }
        this.fireWorkbenchEvent(workbenchButton, 0);
        workbenchButton.setSaveRequired(true);
        workbenchButton.setSelected(true);
        workbenchButton.initializeButton();
        workbenchButton.addClickListener();
        this.refreshDialog(workbenchButton);
    }

    protected void saveWorkbenches() {
        for (WorkbenchButton workbenchButton : this.workbenchButtons) {
            if (!workbenchButton.isSaveRequired()) continue;
            CommStyleInfo commStyleInfo = (CommStyleInfo)workbenchButton.getDescContainer()._getRootParent();
            String string = commStyleInfo.getRelatFileName();
            CommStyleInfo commStyleInfo2 = null;
            if (null != string) {
                if (string.endsWith(XML_EXT)) {
                    string = string.substring(0, string.length() - 4);
                }
                commStyleInfo2 = WelcomeManager.readCommInfo(string, commStyleInfo.getPluginName());
            }
            if (null == commStyleInfo2) {
                commStyleInfo2 = this.commMap.get(workbenchButton);
            } else {
                AreaDescContainer areaDescContainer = commStyleInfo2.getAreaDescContainer(0);
                DescContainer descContainer = areaDescContainer.getDescContainer(WORKBENCH_SETTING_DESC);
                if (null == descContainer) {
                    descContainer = new DescContainer(WORKBENCH_SETTING_DESC);
                    areaDescContainer.addDescContainer(descContainer);
                }
                if (descContainer.getDescContainer(workbenchButton.getDescContainer().getDescName()) != null) {
                    descContainer.removeDescContainer(workbenchButton.getDescContainer().getDescName());
                }
                descContainer.addDescContainer(workbenchButton.getDescContainer());
            }
            workbenchButton.storelink(commStyleInfo2);
            workbenchButton.setSaveRequired(false);
        }
    }

    protected boolean isValidWBId(String string) {
        return null != string && string.trim().length() != 0 && null != this.idWorkBenchMap.get(string);
    }

    public void addWorkbenchListener(IWorkbenchListener iWorkbenchListener) {
        this.wbListeners.add(iWorkbenchListener);
    }

    public void removeWorkbenchListener(IWorkbenchListener iWorkbenchListener) {
        this.wbListeners.remove(iWorkbenchListener);
    }

    public void addWelcomeButtonListener(IWelcomeButtonListener iWelcomeButtonListener) {
        this.buttonListeners.add(iWelcomeButtonListener);
    }

    public void removeWelcomeButtonListener(IWelcomeButtonListener iWelcomeButtonListener) {
        this.buttonListeners.remove(iWelcomeButtonListener);
    }

    public void fireWorkbenchEvent(WorkbenchButton workbenchButton, int n) {
        WorkbenchEvent workbenchEvent = null;
        for (IWorkbenchListener iWorkbenchListener : this.wbListeners) {
            if (null == workbenchEvent) {
                workbenchEvent = new WorkbenchEvent(n, new WorkbenchInfo(workbenchButton));
            }
            switch (n) {
                case 0: {
                    iWorkbenchListener.workbenchAdded(workbenchEvent);
                    break;
                }
                case 1: {
                    iWorkbenchListener.workbenchModified(workbenchEvent);
                    break;
                }
                case 2: {
                    iWorkbenchListener.workbenchRemoved(workbenchEvent);
                    break;
                }
            }
        }
    }

    void fireWelcomeButtonEvent(WelcomeTextButton welcomeTextButton, int n) {
        WelcomeButtonEvent welcomeButtonEvent = null;
        for (IWelcomeButtonListener iWelcomeButtonListener : this.buttonListeners) {
            if (null == welcomeButtonEvent) {
                welcomeButtonEvent = new WelcomeButtonEvent(n, new WelcomeButtonInfo(welcomeTextButton));
            }
            switch (n) {
                case 0: {
                    iWelcomeButtonListener.buttonAdded(welcomeButtonEvent);
                    break;
                }
                case 1: {
                    iWelcomeButtonListener.buttonModified(welcomeButtonEvent);
                    break;
                }
                case 2: {
                    iWelcomeButtonListener.buttonRemoved(welcomeButtonEvent);
                    break;
                }
            }
        }
    }

    ArrayList<WelcomeTextButton> getSelectedWBEnableList(List<WelcomeTextButton> list, String string) {
        ArrayList<WelcomeTextButton> arrayList = new ArrayList<WelcomeTextButton>(0);
        String string2 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = "_default_iview_workbenches".equals(string);
        for (WelcomeTextButton welcomeTextButton : list) {
            string2 = ((DraggableButton)welcomeTextButton).getWorkbenchId();
            bl = bl3 && ("_default_iview_workbenches".equals(string2) || !this.isValidWBId(string2));
            bl2 = ResourceUtil.areEquals(string2, string);
            if (!bl && !bl2) continue;
            arrayList.add(welcomeTextButton);
        }
        return arrayList;
    }

    protected final WorkbenchButton getDefaultWorkbench() {
        return this.defaultWorkbench;
    }

    void sortBySerialNum(WorkbenchButton workbenchButton) {
        DraggableButton draggableButton = null;
        for (WelcomeButtonInfo welcomeButtonInfo : this.getWelcomeButtons(workbenchButton.getWorkbenchId(), true)) {
            draggableButton = (DraggableButton)welcomeButtonInfo.getButton();
            draggableButton.setXIndex(-1);
            draggableButton.setYIndex(-1);
            draggableButton.storeXYInfo();
            WelcomeManager.getWelcomePageReference().modifylink(draggableButton, false);
        }
        if (null != this.selectedWorkBench && ResourceUtil.areEquals(this.selectedWorkBench.getWorkbenchId(), workbenchButton.getWorkbenchId())) {
            this.selectedWorkBench.forceClick();
        }
    }

    protected void showImportWorkbench() {
        String string = WelcomeUtilities.getWBImportFileName();
        if (null != string) {
            DefaultImportManager defaultImportManager = new DefaultImportManager(string);
            defaultImportManager.importWorkbench();
        }
    }

    private void deleteButtons(WorkbenchInfo workbenchInfo) {
        this.benchContents.remove(workbenchInfo.getId());
    }

    void removeAllWorkbenchInfos() {
        this.benchContents.clear();
    }

    void addWorkbenchference(WorkbenchButton workbenchButton) {
        this.workbenchButtons.add(workbenchButton);
        this.rearrangeWorkbenches();
    }

    private static CommStyleInfo readImportCommInfo() {
        CommStyleManager commStyleManager = CommStyleManager.getInstance();
        if (WorkbenchManager.isAllUserPersistance()) {
            return commStyleManager.getAllUsersCommonStyleFile(WorkbenchManager.getImportCommInfoPath());
        }
        return commStyleManager.getUserCommonStyleFile(WorkbenchManager.getImportCommInfoPath());
    }

    static CommStyleInfo getCreatedImportCommStyle() {
        DescContainer descContainer;
        Object object;
        Object object2;
        if (null == importCommstyle && null == (importCommstyle = WorkbenchManager.readImportCommInfo())) {
            object2 = CommStyleManager.getInstance();
            importCommstyle = new CommStyleInfo();
            object = WorkbenchManager.isAllUserPersistance() ? ((CommStyleManager)object2).getAllUsersInfoStyleDir() : ((CommStyleManager)object2).getUserDir();
            importCommstyle.setFileName((String)object + "/" + WorkbenchManager.getImportCommInfoPath() + XML_EXT);
        }
        object2 = null;
        if (importCommstyle.getAreaDescContainerCount() > 0) {
            object2 = importCommstyle.getAreaDescContainer(0);
        }
        if (null == object2) {
            object2 = new AreaDescContainer();
            importCommstyle.addAreaDescContainer((AreaDescContainer)object2);
        }
        if (null == (object = ((AreaDescContainer)object2).getDescContainer(WORKBENCH_SETTING_DESC))) {
            object = new DescContainer();
            ((DescContainer)object).setDescName(WORKBENCH_SETTING_DESC);
            ((AreaDescContainer)object2).addDescContainer((DescContainer)object);
        }
        if (null == (descContainer = ((AreaDescContainer)object2).getDescContainer("welcomebuttonsetting"))) {
            descContainer = new DescContainer();
            descContainer.setDescName("welcomebuttonsetting");
            ((AreaDescContainer)object2).addDescContainer(descContainer);
        }
        return importCommstyle;
    }

    static boolean isAllUserPersistance() {
        return WelcomeManager.getWelcomePageReference() != null && WelcomeManager.getWelcomePageReference().isAllUsersLocation();
    }

    static String getImportCommInfoPath() {
        StringBuffer stringBuffer = new StringBuffer(10);
        stringBuffer.append("integrate/").append(SubsystemManager.getInstance().getIntegratePath()).append("/imported").append('/').append("welcomebutton");
        return stringBuffer.toString();
    }

    static final CommStyleInfo getImportCommStyle() {
        return importCommstyle;
    }

    void resetUserEnableList(WorkbenchButton workbenchButton) {
        if (workbenchButton.isUserEnable() && !this.enableList.contains(workbenchButton)) {
            this.enableList.add(workbenchButton);
        } else if (!workbenchButton.isUserEnable() && this.enableList.contains(workbenchButton)) {
            this.enableList.remove(workbenchButton);
        }
        this.setAddMenuState();
    }

    public void setWelcomeButtonVisibility(String string, boolean bl) {
        Collection<Map.Entry<String, ArrayList<WelcomeTextButton>>> collection;
        WelcomePage welcomePage = WelcomeManager.getWelcomeRef();
        if (null == welcomePage) {
            logger.trace("Show/Hide failed as WelcomePage is not inited.");
            return;
        }
        if (null == string) {
            throw new IllegalArgumentException("Wlecomebutton Id cannot be null");
        }
        ArrayList<WelcomeTextButton> arrayList = new ArrayList<WelcomeTextButton>(1);
        int n = ConfigUtilities.getLayoutType();
        if (n == 1 || n == 0) {
            welcomePage.setWelcomeButtonVisibility(string, bl, arrayList);
        } else {
            collection = this.benchContents.entrySet();
            for (Map.Entry<String, ArrayList<WelcomeTextButton>> entry : collection) {
                for (WelcomeTextButton welcomeTextButton : entry.getValue()) {
                    welcomePage.showHideWelcomeButton(bl, entry.getKey(), string, welcomeTextButton, arrayList);
                }
            }
        }
        collection = new ArrayList(1);
        collection.add((Map.Entry<String, ArrayList<WelcomeTextButton>>)((Object)string));
        welcomePage.resetFunctionalDialogButtonVisibility(bl, (List<String>)collection);
    }

    public void setWelcomeButtonVisibility(final List<String> list, final boolean bl) {
        final WelcomePage welcomePage = WelcomeManager.getWelcomeRef();
        if (null == welcomePage) {
            logger.trace("Show/Hide failed as WelcomePage is not inited.");
            return;
        }
        if (null == list || list.size() < 1) {
            throw new IllegalArgumentException("Wlecomebutton Id cannot be null");
        }
        logger.trace("Start array of setWelcomeButtonVisibility with Size = " + list.size() + " isShow = " + bl + " : " + System.currentTimeMillis());
        ArrayList<WelcomeTextButton> arrayList = new ArrayList<WelcomeTextButton>(1);
        int n = ConfigUtilities.getLayoutType();
        if (n == 1 || n == 0) {
            int n2 = list.size();
            String string = null;
            for (int i = 0; i < n2; ++i) {
                string = list.get(i);
                welcomePage.setWelcomeButtonVisibility(string, bl, arrayList);
            }
        } else {
            ArrayList<WelcomeTextButton> arrayList22;
            ArrayList<WelcomeTextButton> arrayList3 = new ArrayList<WelcomeTextButton>();
            for (ArrayList<WelcomeTextButton> arrayList22 : this.benchContents.values()) {
                arrayList3.addAll(arrayList22);
            }
            int n3 = list.size();
            arrayList22 = new ArrayList();
            String string = null;
            for (int i = 0; i < n3; ++i) {
                string = list.get(i);
                for (WelcomeTextButton welcomeTextButton : arrayList3) {
                    if (!ResourceUtil.areEquals(string, welcomeTextButton.getDescContainer().getDescName())) continue;
                    arrayList22.add(welcomeTextButton);
                    if (!welcomeTextButton.isVisible() != bl) continue;
                    String string2 = ((DraggableButton)welcomeTextButton).getWorkbenchId();
                    welcomePage.addRemoveWelcomeButton(string2, welcomeTextButton, bl);
                }
                arrayList3.remove(arrayList22);
            }
            if (bl) {
                welcomePage.updateUI();
            }
            new Thread(new Runnable(){

                @Override
                public void run() {
                    int n = list.size();
                    if (n > 0) {
                        welcomePage.resetFunctionalDialogButtonVisibility(bl, list);
                    }
                }
            }).start();
        }
        logger.trace("Start array of setWelcomeButtonVisibility : " + System.currentTimeMillis());
    }

    public void setWelcomeButtonEnable(String string, boolean bl) {
        WelcomePage welcomePage = WelcomeManager.getWelcomeRef();
        if (null == welcomePage) {
            logger.trace("Enable/Disable failed as WelcomePage is not inited.");
            return;
        }
        if (null == string) {
            throw new IllegalArgumentException("Wlecomebutton Id cannot be null");
        }
        ArrayList<WelcomeTextButton> arrayList = new ArrayList<WelcomeTextButton>(1);
        int n = ConfigUtilities.getLayoutType();
        if (n == 1 || n == 0) {
            welcomePage.setWelcomeButtonEnable(string, bl, arrayList);
        } else {
            Set<Map.Entry<String, ArrayList<WelcomeTextButton>>> set = this.benchContents.entrySet();
            for (Map.Entry<String, ArrayList<WelcomeTextButton>> entry : set) {
                for (WelcomeTextButton welcomeTextButton : entry.getValue()) {
                    welcomePage.enableDisableWelcomeButton(bl, string, welcomeTextButton, arrayList);
                }
            }
        }
        welcomePage.resetFunctionalDialogButtonEnable(bl, string);
    }

    public ArrayList<WelcomeTextButton> getAllWelcomeTextButton(String string, String string2) {
        ArrayList<WelcomeTextButton> arrayList = new ArrayList<WelcomeTextButton>(1);
        arrayList.addAll(this.getAllWelcomePageTextButton(string, string2));
        arrayList.addAll(WelcomeManager.getWelcomeRef().getAllLinkDlgTextButton(string, string2));
        return arrayList;
    }

    public ArrayList<WelcomeTextButton> getAllWelcomePageTextButton(String string, String string2) {
        ArrayList<WelcomeTextButton> arrayList = new ArrayList<WelcomeTextButton>(1);
        if (null == string2 || null == string) {
            return arrayList;
        }
        ArrayList<WelcomeTextButton> arrayList2 = this.benchContents.get(string);
        if (null != arrayList2) {
            for (WelcomeTextButton welcomeTextButton : arrayList2) {
                if (!string2.equals(welcomeTextButton.getDescName())) continue;
                arrayList.add(welcomeTextButton);
            }
        }
        return arrayList;
    }

    public ArrayList<ButtonInfo> getAllWelcomePageTextButtonInfo(String string, String string2) {
        ArrayList<ButtonInfo> arrayList = new ArrayList<ButtonInfo>(1);
        if (null == string2 || null == string) {
            return arrayList;
        }
        ArrayList<WelcomeTextButton> arrayList2 = this.benchContents.get(string);
        if (null != arrayList2) {
            for (WelcomeTextButton welcomeTextButton : arrayList2) {
                if (!string2.equals(welcomeTextButton.getDescName())) continue;
                arrayList.add(new WelcomeButtonInfo(welcomeTextButton));
            }
        }
        return arrayList;
    }

    public WelcomeTextButton getWelcomeTextButton(String string, String string2) {
        WelcomeTextButton welcomeTextButton = null;
        if (null == string2 || null == string) {
            return welcomeTextButton;
        }
        ArrayList<WelcomeTextButton> arrayList = this.benchContents.get(string);
        if (null != arrayList) {
            for (WelcomeTextButton welcomeTextButton2 : arrayList) {
                if (!string2.equals(welcomeTextButton2.getDescName())) continue;
                welcomeTextButton = welcomeTextButton2;
            }
        }
        return welcomeTextButton;
    }

    protected ArrayList<WelcomeTextButton> getAllWelcomeTextButton(String string) {
        ArrayList<WelcomeTextButton> arrayList = new ArrayList<WelcomeTextButton>();
        for (ArrayList<WelcomeTextButton> arrayList2 : this.benchContents.values()) {
            if (null == arrayList2) continue;
            for (WelcomeTextButton welcomeTextButton : arrayList2) {
                if (!string.equals(welcomeTextButton.getDescName())) continue;
                arrayList.add(welcomeTextButton);
            }
        }
        return arrayList;
    }

    ArrayList<WelcomeTextButton> getVisibleWelcomeTextButton(String string) {
        ArrayList<WelcomeTextButton> arrayList = this.getWPButtons(string);
        if (arrayList.isEmpty()) {
            return null;
        }
        ArrayList<WelcomeTextButton> arrayList2 = new ArrayList<WelcomeTextButton>(1);
        for (WelcomeTextButton welcomeTextButton : arrayList) {
            if (!welcomeTextButton.isVisible()) continue;
            arrayList2.add(welcomeTextButton);
        }
        return arrayList2;
    }

    void clickSelectedWBench() {
        if (null != this.selectedWorkBench) {
            this.selectedWorkBench.setFocusSelected(true);
            this.selectedWorkBench.changeBackGroundImage();
            this.selectedWorkBench.updateUI();
        }
    }

    boolean isWorkBenchButtonExist(String string) {
        if (null == this.workbenchButtons || this.workbenchButtons.isEmpty()) {
            return false;
        }
        int n = this.workbenchButtons.size();
        for (int i = 0; i < n; ++i) {
            if (!this.workbenchButtons.get(i).getFullName().equals(string)) continue;
            return true;
        }
        return false;
    }

    private void setAddMenuState() {
        if (this.addLink != null) {
            boolean bl = false == this.enableList.isEmpty() && WelcomeManager.isShowAddWBLinkMenuItem();
            this.addLink.setVisible(bl);
        }
    }

    static void clear() {
        importCommstyle = null;
    }

    public String getSelectedWBenchId() {
        if (null != this.selectedWorkBench) {
            return this.selectedWorkBench.getWorkbenchId();
        }
        return null;
    }

    protected void cleanUp() {
        this.buttonListeners.clear();
        this.buttonListeners = null;
        for (ArrayList<WelcomeTextButton> arrayList : this.benchContents.values()) {
            arrayList.clear();
        }
        this.benchContents.clear();
        this.benchContents = null;
        for (ArrayList<WelcomeTextButton> arrayList : this.idWorkBenchMap.values()) {
            arrayList.clear();
        }
        this.idWorkBenchMap.clear();
        this.idWorkBenchMap = null;
        this.commMap.clear();
        this.commMap = null;
        WorkbenchButton.removeFocusLostListener();
        this.workbenchButtons.clear();
        this.workbenchButtons = null;
        this.wbListeners.clear();
        this.wbListeners = null;
        this.enableList.clear();
        this.enableList = null;
    }

    private static void updateInfo(CommStyleInfo commStyleInfo) {
        if (null != commStyleInfo) {
            if (WorkbenchManager.isAllUserPersistance()) {
                WelcomeManager.writeAllUserCommInfo(commStyleInfo);
            } else {
                WelcomeManager.writeCommInfo(commStyleInfo);
            }
        }
    }

    WorkbenchButton getWorkBenchByName(String string) {
        if (null == this.workbenchButtons || this.workbenchButtons.isEmpty()) {
            return null;
        }
        int n = this.workbenchButtons.size();
        for (int i = 0; i < n; ++i) {
            if (!this.workbenchButtons.get(i).getFullName().equals(string)) continue;
            return this.workbenchButtons.get(i);
        }
        return null;
    }

    private boolean workBenchValidation(DescContainer descContainer) {
        String string = null;
        string = descContainer.getParasItemValue("name");
        if (this.buttonNameSet.contains(string)) {
            logger.trace("Fail to load as button with name " + string + " already loaded");
            return false;
        }
        this.buttonNameSet.add(string);
        return true;
    }
}

