/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.windowmanagement.welcomepage;

import com.swimap.iview.commstyle.resource.i18n.ResourceUtil;
import com.swimap.iview.framework.windowmanagement.welcomepage.ConfigUtilities;
import com.swimap.iview.framework.windowmanagement.welcomepage.WorkbenchButton;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class WorkbenchLayout
implements LayoutManager {
    private static final Dimension BUTTON_SIZE = ConfigUtilities.getDefaultIconSize();
    public static final int MARGIN = 40;
    public static final int WIDTH = WorkbenchLayout.BUTTON_SIZE.width + 80;
    private static final int MARGIN_TOP = 30;
    private static final int INITIAL_CAPACITY = 10;
    public static final Comparator<WorkbenchButton> Y_ORDER = new Comparator<WorkbenchButton>(){

        @Override
        public int compare(WorkbenchButton workbenchButton, WorkbenchButton workbenchButton2) {
            if (-1 == workbenchButton.getYPosition()) {
                return 1;
            }
            if (-1 == workbenchButton2.getYPosition()) {
                return -1;
            }
            if (workbenchButton.getYPosition() > workbenchButton2.getYPosition()) {
                return -1;
            }
            if (workbenchButton.getYPosition() < workbenchButton2.getYPosition()) {
                return 1;
            }
            return 0;
        }
    };

    @Override
    public void addLayoutComponent(String string, Component component) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            ArrayList<WorkbenchButton> arrayList = this.getSortedComponents(container);
            if (arrayList.size() == 0) {
                return;
            }
            WorkbenchButton workbenchButton = null;
            int n = 30;
            for (WorkbenchButton workbenchButton2 : arrayList) {
                if (!(workbenchButton2 instanceof WorkbenchButton)) continue;
                workbenchButton = workbenchButton2;
                int n2 = workbenchButton.getPreferredSize().width;
                int n3 = 104;
                workbenchButton.setBounds(40, workbenchButton.getYPosition(), n2 + 10, n3);
                n += n3;
            }
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        return this.getCustomLayoutSize(container);
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        return this.getCustomLayoutSize(container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimension getCustomLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Component[] componentArray = container.getComponents();
            WorkbenchButton workbenchButton = null;
            int n = 0;
            if (componentArray.length == 0) {
                return new Dimension(0, 0);
            }
            workbenchButton = (WorkbenchButton)componentArray[componentArray.length - 1];
            n = workbenchButton.getY() + 104;
            return new Dimension(workbenchButton.getWidth() + 80, n);
        }
    }

    @Override
    public void removeLayoutComponent(Component component) {
    }

    public Point getDestIndex(Point point, int n, int n2) {
        int n3 = 0;
        int n4 = 30;
        if (null != point) {
            n3 = point.x;
            n4 = 30 > point.y ? 30 : (point.y - 30) / n2 * n2 + 30;
        }
        return new Point(n3, n4);
    }

    private ArrayList<WorkbenchButton> getSortedComponents(Container container) {
        ArrayList<WorkbenchButton> arrayList = new ArrayList<WorkbenchButton>(10);
        Component[] componentArray = container.getComponents();
        if (0 != componentArray.length) {
            List<Component> list = Arrays.asList(componentArray);
            Iterator<Component> iterator = list.iterator();
            int n = 0;
            int n2 = -1;
            boolean bl = iterator.hasNext();
            WorkbenchButton workbenchButton = null;
            while (bl) {
                workbenchButton = (WorkbenchButton)iterator.next();
                if (-1 == workbenchButton.getYPosition()) {
                    n2 = this.getAvailableYPos(list, workbenchButton);
                    workbenchButton.setYPosition(n2);
                    workbenchButton.storeYInfo();
                } else if (this.isYPosAlreadyExist(list, workbenchButton)) {
                    n2 = this.getAvailableYPos(list, workbenchButton);
                    workbenchButton.setYPosition(n2);
                    workbenchButton.storeYInfo();
                    workbenchButton.setSaveRequired(true);
                }
                ++n;
                arrayList.add(workbenchButton);
                bl = iterator.hasNext();
            }
        }
        return arrayList;
    }

    private boolean isYPosAlreadyExist(List list, WorkbenchButton workbenchButton) {
        int n = workbenchButton.getYPosition();
        String string = workbenchButton.getDescContainer().getParasItemValue("name");
        String string2 = "";
        WorkbenchButton workbenchButton2 = null;
        for (Object e : list) {
            workbenchButton2 = (WorkbenchButton)e;
            string2 = workbenchButton2.getDescContainer().getParasItemValue("name");
            if (workbenchButton2.getYPosition() != n || ResourceUtil.areEquals(string, string2)) continue;
            return true;
        }
        return false;
    }

    private int getAvailableYPos(List list, WorkbenchButton workbenchButton) {
        int n = 30;
        int n2 = 104;
        boolean bl = true;
        while (bl) {
            if (this.isPositionConfigured(list, n)) {
                n += n2;
                continue;
            }
            bl = false;
        }
        return n;
    }

    private boolean isPositionConfigured(List list, int n) {
        WorkbenchButton workbenchButton = null;
        for (Object e : list) {
            workbenchButton = (WorkbenchButton)e;
            if (workbenchButton.getYPosition() != n) continue;
            return true;
        }
        return false;
    }
}

