/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.windowmanagement.welcomepage;

import com.swimap.iview.commstyle.commandmng.authority.AuthorityAction;
import com.swimap.iview.commstyle.commini.AreaDescContainer;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.commini.ImageButtonIconInfo;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.framework.pluginmanagement.Plugin;
import com.swimap.iview.framework.pluginmanagement.PluginManager;
import com.swimap.iview.framework.windowmanagement.welcomepage.ConfigUtilities;
import com.swimap.iview.framework.windowmanagement.welcomepage.WelcomeManager;
import com.swimap.iview.framework.windowmanagement.welcomepage.WelcomeTextButton;
import com.swimap.iview.framework.windowmanagement.welcomepage.WorkbenchManager;
import com.swimap.iview.framework.windowmanagement.welcomepage.draggable.WorkbenchButtonTransferHandler;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.TransferHandler;

public class WorkbenchButton
extends WelcomeTextButton
implements Transferable {
    private static final long serialVersionUID = -8828436625584939946L;
    public static final String DEFAULT_WORKBENCH = "_default_iview_workbenches";
    static final String DYNAMIC_WORKBENCH = "_dynamic_iview_workbench_";
    private static final String IS_CLICK_SELECTED = "isClickSelected";
    private static final String CLICK_SELECTED = "true";
    public static final String BACKGROUND_IMAGE = "background";
    private boolean clickSelected = false;
    private boolean orgClickSelectedState = false;
    static final String DEFAULT_ICON = "default_wbench.png";
    static final String DYNAMIC_ICON = "default_wbench_created.png";
    private String workbenchId = null;
    private boolean freshLoading = true;
    private static IviewLogger logger = IviewLogger.getLogger(WorkbenchButton.class, "IVIEW");
    private static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/framework/windowmanagement/welcomepage/Res");
    private static final int DEFAULT_TEXT_WIDTH = 75;
    private static final int ARRAY_INDEX = 10;
    static final String DYNAMIC = "dynamic";
    public static final int DEFAULT_HEIGHT = 104;
    private static ConcurrentHashMap<WorkbenchButton, IFocusLostListener> focusListener = new ConcurrentHashMap(10);
    private String backgroundImage = null;
    private boolean saveRequired = false;
    public static final String Y_POSITION = "yPosition";
    private transient MouseAdapter mouseAdapter = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (16 == mouseEvent.getModifiers()) {
                WorkbenchButton.this.processClick();
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            logger.trace("WorkbenchButton mouse pressed");
            WorkbenchButton.this.processClick();
        }
    };
    private WorkbenchButtonTransferHandler transferListener = new WorkbenchButtonTransferHandler();
    private static final String MIME_TYPE = "application/x-java-jvm-local-objectref;class=" + WorkbenchButton.class.getName();
    private static DataFlavor dragAndDropPanelDataFlavor = null;
    public static final int DEFAULT_POSITION = -1;
    private int yPosition = -1;
    private transient MouseMotionListener draggingListener = new MouseAdapter(){

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            JComponent jComponent = (JComponent)mouseEvent.getSource();
            WorkbenchButton workbenchButton = null;
            if (jComponent instanceof JLabel || jComponent instanceof JTextArea) {
                workbenchButton = (WorkbenchButton)jComponent.getParent();
                workbenchButton.setFocused(false);
            }
            TransferHandler transferHandler = jComponent.getTransferHandler();
            transferHandler.exportAsDrag(jComponent, mouseEvent, 1);
        }
    };

    @Override
    protected void resetSize() {
        super.resetSize();
        this.setSize(this.getWidth(), this.getHeight() + 4);
    }

    WorkbenchButton(DescContainer descContainer, boolean bl) {
        super(descContainer, bl ? DYNAMIC_ICON : DEFAULT_ICON, ConfigUtilities.getDefaultIconSize(), 75);
        this.workbenchId = descContainer.getDescName();
        String string = descContainer.getParasItemValue(IS_CLICK_SELECTED);
        this.clickSelected = null != string && CLICK_SELECTED.equals(string.trim());
        this.orgClickSelectedState = this.clickSelected;
        String string2 = descContainer.getParasItemValue(Y_POSITION);
        if (null != string2) {
            int n = Integer.parseInt(string2);
            this.setYPosition(n);
        }
        WorkbenchButton.addFocusLostListener(this, new IFocusLostListener(){

            @Override
            public void focusLost() {
                WorkbenchButton.this.setFocusSelected(false);
                WorkbenchButton.this.repaint();
            }
        });
    }

    void addClickListener() {
        for (Component component : this.getComponents()) {
            component.addMouseListener(this.mouseAdapter);
        }
    }

    void removeClickListener() {
        for (Component component : this.getComponents()) {
            component.removeMouseListener(this.mouseAdapter);
        }
    }

    protected void processClick() {
        logger.trace("Process Click is called");
        if (this.clickSelected || !this.isSelected()) {
            logger.trace("Process Click Click selected" + this.clickSelected);
            logger.trace("Process Click Click selected" + this.isSelected());
            return;
        }
        this.fireAllFocusLost();
        this.setClickSelected(true);
        this.setFocusSelected(true);
        WelcomeManager.getWorkbenchManager().setSelectedWorkBench(this);
        this.changeBackGroundImage();
        WelcomeManager.getWelcomePageReference().refreshWelcomePage();
        WelcomeManager.getWelcomePageReference().scrollToWorkbench();
    }

    void changeBackGroundImage() {
        ImageIcon imageIcon = null;
        CommStyleInfo commStyleInfo = (CommStyleInfo)this.getDescContainer()._getRootParent();
        ImageButtonIconInfo imageButtonIconInfo = super.getImageInformation(this.backgroundImage, commStyleInfo);
        if (null != imageButtonIconInfo) {
            imageIcon = imageButtonIconInfo.getIcon();
        }
        if (null != imageIcon) {
            WelcomeManager.getWelcomePageReference().changeBackGroundImage(imageIcon);
        } else {
            WelcomeManager.getWelcomePageReference().resetToDefaultBackground();
        }
    }

    private void fireAllFocusLost() {
        for (WorkbenchButton workbenchButton : focusListener.keySet()) {
            workbenchButton.setClickSelected(false);
            focusListener.get(workbenchButton).focusLost();
        }
    }

    public static Object getUIObject(DescContainer descContainer, boolean bl) {
        WorkbenchButton workbenchButton = new WorkbenchButton(descContainer, bl);
        if (null != workbenchButton) {
            workbenchButton.setBackgroundImage(descContainer.getParasItemValue(BACKGROUND_IMAGE));
        }
        return workbenchButton;
    }

    protected void setBackgroundImage(String string) {
        this.backgroundImage = string;
    }

    public static Object getUIObject() {
        CommStyleInfo commStyleInfo = new CommStyleInfo();
        AreaDescContainer areaDescContainer = new AreaDescContainer();
        DescContainer descContainer = new DescContainer("welcomebuttonsetting");
        DescContainer descContainer2 = new DescContainer(DEFAULT_WORKBENCH);
        descContainer2.setParasItem("name", res.getString("Default_Workbench_Name"), true);
        descContainer2.setParasItem("description", res.getString("Default_Workbench_Description"), true);
        descContainer2.setParasItem("serialnumber", "2147483647", true);
        descContainer2.setParasItem("isRemovable", "false", true);
        descContainer.addDescContainer(descContainer2);
        areaDescContainer.addDescContainer(descContainer);
        commStyleInfo.addAreaDescContainer(areaDescContainer);
        return new WorkbenchButton(commStyleInfo.getAreaDescContainer(0).getDescContainer(0).getDescContainer(0), false);
    }

    private static void addFocusLostListener(WorkbenchButton workbenchButton, IFocusLostListener iFocusLostListener) {
        if (null != workbenchButton && null != iFocusLostListener) {
            focusListener.put(workbenchButton, iFocusLostListener);
        }
    }

    protected static void removeFocusLostListener() {
        focusListener.clear();
    }

    protected void setClickSelected(boolean bl) {
        this.clickSelected = bl;
    }

    public final String getWorkbenchId() {
        return this.workbenchId;
    }

    protected final boolean isFreshLoading() {
        return this.freshLoading;
    }

    protected final void setFreshLoading(boolean bl) {
        this.freshLoading = bl;
    }

    protected void storelink(CommStyleInfo commStyleInfo) {
        if (null == commStyleInfo) {
            return;
        }
        try {
            AreaDescContainer areaDescContainer = commStyleInfo.getAreaDescContainer(0);
            this.getDescContainer().setParasItem(IS_CLICK_SELECTED, this.clickSelected ? CLICK_SELECTED : "false", true);
            DescContainer descContainer = areaDescContainer.getDescContainer("workbenchsetting");
            if (WorkbenchManager.isAllUserPersistance()) {
                this.writeToAllUser(commStyleInfo, descContainer);
            } else {
                this.writeToUser(commStyleInfo, descContainer);
            }
        }
        catch (IOException iOException) {
            logger.trace("Failed to save the " + this.getButtonName() + " workbench informations", iOException);
        }
    }

    private void writeToUser(CommStyleInfo commStyleInfo, DescContainer descContainer) throws IOException {
        if (null != commStyleInfo.getPluginName()) {
            Plugin plugin = PluginManager.getInstance().getPluginFromFolder(commStyleInfo.getPluginName());
            if (null != plugin) {
                CommStyleInfo commStyleInfo2 = plugin.getIntegrateCommStyleReader().getUserCommStyleInfo("welcomebutton");
                this.replaceDesc(commStyleInfo2, descContainer);
                plugin.getIntegrateCommStyleReader().writeToUser(commStyleInfo2);
            }
        } else {
            this.replaceDesc(commStyleInfo, descContainer);
            CommStyleManager.getInstance().writeToUser(commStyleInfo);
        }
    }

    private void writeToAllUser(CommStyleInfo commStyleInfo, DescContainer descContainer) throws IOException {
        if (null != commStyleInfo.getPluginName()) {
            Plugin plugin = PluginManager.getInstance().getPluginFromFolder(commStyleInfo.getPluginName());
            if (null != plugin) {
                CommStyleInfo commStyleInfo2 = plugin.getIntegrateCommStyleReader().getAllUserCommStyleInfo("welcomebutton");
                this.replaceDesc(commStyleInfo2, descContainer);
                plugin.getIntegrateCommStyleReader().writeToAllUsers(commStyleInfo2);
            }
        } else {
            this.replaceDesc(commStyleInfo, descContainer);
            WelcomeManager.getWelcomePageReference().writeToPath(commStyleInfo, commStyleInfo.getFileName());
        }
    }

    private void replaceDesc(CommStyleInfo commStyleInfo, DescContainer descContainer) {
        AreaDescContainer areaDescContainer = commStyleInfo.getAreaDescContainer(0);
        DescContainer descContainer2 = areaDescContainer.getDescContainer("workbenchsetting");
        areaDescContainer.removeDescContainer(descContainer2);
        areaDescContainer.addDescContainer(descContainer);
    }

    final boolean isClickSelected() {
        return this.clickSelected;
    }

    public final String getBackgroundImage() {
        return this.backgroundImage;
    }

    @Override
    public AuthorityAction getAction() {
        return null;
    }

    @Override
    public boolean isActionButton() {
        return false;
    }

    boolean isSaveRequired() {
        return this.saveRequired || this.clickSelected != this.orgClickSelectedState;
    }

    public void setSaveRequired(boolean bl) {
        this.saveRequired = bl;
    }

    public void forceClick() {
        this.setClickSelected(false);
        this.processClick();
    }

    String getBackgroundInfo() {
        String string = this.getDescContainer().getParasItemValue(BACKGROUND_IMAGE);
        return null == string ? this.getDefaultImage() : string;
    }

    protected String getDefaultImage() {
        String string = "";
        try {
            File file;
            ImageIcon imageIcon = ConfigUtilities.getWelcomeImage();
            String string2 = imageIcon.getDescription();
            URL uRL = null;
            uRL = string2 != null && string2.contains("jar!") ? (string2.startsWith("jar:") ? new URL(string2) : new URL("jar", null, string2)) : (null != string2 && false == string2.startsWith("file:/") ? new URL("file", null, string2) : new URL(string2));
            String string3 = uRL.toURI().getPath();
            if (null != string3 && (file = new File(string3)).exists()) {
                string = file.getAbsolutePath();
            }
        }
        catch (Exception exception) {
            string = "";
        }
        return string;
    }

    final void setUserEnableStatus(boolean bl) {
        super.setUserEnable(bl);
    }

    final void setRemovableStatus(boolean bl) {
        super.setRemovable(bl);
    }

    final boolean isDynamic() {
        boolean bl = false;
        DescContainer descContainer = this.getDescContainer();
        if (null != descContainer) {
            bl = Boolean.valueOf(descContainer.getParasItemValue(DYNAMIC));
        }
        return bl;
    }

    @Override
    public boolean isDrawBorder() {
        return true;
    }

    @Override
    public void initializeButton() {
        super.initializeButton();
        this.setHandlerAndListener();
    }

    private void setHandlerAndListener() {
        this.setTransferHandler(this.transferListener);
        for (Component component : this.getComponents()) {
            if (component instanceof JLabel) {
                ((JLabel)component).setTransferHandler(this.transferListener);
            } else if (component instanceof JTextArea) {
                ((JTextArea)component).setTransferHandler(this.transferListener);
            }
            component.addMouseMotionListener(this.draggingListener);
        }
        this.addMouseMotionListener(this.draggingListener);
    }

    public static DataFlavor getDragAndDropPanelDataFlavor() throws ClassNotFoundException {
        if (dragAndDropPanelDataFlavor == null) {
            dragAndDropPanelDataFlavor = new DataFlavor(MIME_TYPE);
        }
        return dragAndDropPanelDataFlavor;
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        DataFlavor dataFlavor2 = null;
        try {
            dataFlavor2 = WorkbenchButton.getDragAndDropPanelDataFlavor();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        if (dataFlavor2 != null && dataFlavor2.equals(dataFlavor)) {
            return this;
        }
        return null;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] dataFlavorArray = new DataFlavor[]{null};
        try {
            dataFlavorArray[0] = WorkbenchButton.getDragAndDropPanelDataFlavor();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return dataFlavorArray;
        }
        return dataFlavorArray;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        DataFlavor[] dataFlavorArray = new DataFlavor[]{null};
        try {
            dataFlavorArray[0] = WorkbenchButton.getDragAndDropPanelDataFlavor();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        for (DataFlavor dataFlavor2 : dataFlavorArray) {
            if (!dataFlavor2.equals(dataFlavor)) continue;
            return true;
        }
        return false;
    }

    public final int getYPosition() {
        return this.yPosition;
    }

    public void setYPosition(int n) {
        this.yPosition = n;
    }

    public boolean storeYInfo() {
        boolean bl = false;
        DescContainer descContainer = this.getDescContainer();
        String string = descContainer.getParasItemValue(Y_POSITION);
        int n = -1;
        if (null != string) {
            n = this.getNum(string);
        }
        descContainer.setParasItem(Y_POSITION, this.yPosition + "", true);
        if (n != this.yPosition && n != -1) {
            bl = true;
        }
        return bl;
    }

    private int getNum(String string) {
        int n = -1;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n = -1;
        }
        return n;
    }

    protected void removeFocusListener() {
        focusListener.remove(this);
    }

    static interface IFocusLostListener {
        public void focusLost();
    }
}

