/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.windowmanagement.welcomepage;

import com.swimap.iview.commstyle.commandmng.CommandManager;
import com.swimap.iview.commstyle.commandmng.ICommandProcessor;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.commini.TextButton;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.framework.applicationmanagement.gui.ApplicationButton;
import com.swimap.iview.framework.windowmanagement.welcomepage.ExecutableLinkDialog;
import com.swimap.iview.framework.windowmanagement.welcomepage.IClickListener;
import com.swimap.iview.framework.windowmanagement.welcomepage.IWBLauncherFactory;
import com.swimap.iview.framework.windowmanagement.welcomepage.ImageTool;
import com.swimap.iview.framework.windowmanagement.welcomepage.WelcomeButtonInfo;
import com.swimap.iview.framework.windowmanagement.welcomepage.WelcomeManager;
import com.swimap.iview.framework.windowmanagement.welcomepage.WorkbenchButton;
import com.swimap.iview.framework.windowmanagement.welcomepage.draggable.DraggableButton;
import com.swimap.iview.util.OptionPane;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.color.ColorSpace;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class WelcomeTextButton
extends TextButton {
    private static final long serialVersionUID = -7264290988001346839L;
    private boolean doubleClickSelected = false;
    private IClickListener iClickListener = null;
    private ShadowIconLabel shadowIconLabel = null;
    private BufferedImage copyImage = null;
    private static final Color SELECTED_COLOR = new Color(106, 122, 164);
    private static final Color WB_BORDER_TOP_CLR = new Color(54, 127, 167);
    private static final Color WB_BORDER_BOTTOM_CLR = new Color(128, 160, 192);
    protected ICommandProcessor m_commandProcessor = null;
    private String descName = "";
    private boolean needCommit = false;
    private boolean buttonPasted = false;
    private static IviewLogger logger = IviewLogger.getLogger(WelcomeTextButton.class, "IVIEW");

    public WelcomeTextButton(DescContainer descContainer) {
        super(descContainer);
        this.descName = descContainer.getDescName();
    }

    public WelcomeTextButton(DescContainer descContainer, boolean bl) {
        super(descContainer, bl);
        this.descName = descContainer.getDescName();
    }

    public String getDescName() {
        return this.descName;
    }

    public WelcomeTextButton(DescContainer descContainer, Dimension dimension) {
        super(descContainer, dimension);
        this.descName = descContainer.getDescName();
    }

    public WelcomeTextButton(DescContainer descContainer, String string, Dimension dimension, int n) {
        super(descContainer, string, dimension, n);
        this.descName = descContainer.getDescName();
    }

    public static Object getUIObject(DescContainer descContainer) {
        return new WelcomeTextButton(descContainer);
    }

    @Override
    public JLabel getImageComponent() {
        this.shadowIconLabel = new ShadowIconLabel();
        return this.shadowIconLabel;
    }

    protected void removeImageComponent() {
        if (this.shadowIconLabel != null) {
            MouseListener[] mouseListenerArray = this.shadowIconLabel.getMouseListeners();
            for (int i = 0; i < mouseListenerArray.length; ++i) {
                this.shadowIconLabel.removeMouseListener(mouseListenerArray[i]);
                mouseListenerArray[i] = null;
            }
            MouseMotionListener[] mouseMotionListenerArray = this.shadowIconLabel.getMouseMotionListeners();
            for (int i = 0; i < mouseMotionListenerArray.length; ++i) {
                this.shadowIconLabel.removeMouseMotionListener(mouseMotionListenerArray[i]);
                mouseListenerArray[i] = null;
            }
            this.shadowIconLabel.si = null;
        }
        this.shadowIconLabel = null;
    }

    public void setFocusSelected(boolean bl) {
        this.doubleClickSelected = bl;
    }

    public boolean isFocusSelected() {
        return this.doubleClickSelected;
    }

    public void setState(int n) {
        this.shadowIconLabel.si.setState(n);
    }

    protected void showPopupForButton(MouseEvent mouseEvent) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void processClick(Object object) {
        try {
            if (!this.isEnabled()) {
                return;
            }
            if (this.isExecutable()) {
                if (!ExecutableLinkDialog.checkPermittedPath(this.getCommand(), true)) {
                    return;
                }
                if (IWBLauncherFactory.isExtensionExist()) {
                    this.executeCommand();
                    return;
                }
                ResourceBundle resourceBundle = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/framework/windowmanagement/welcomepage/Res");
                String string = resourceBundle.getString("infoDialog_title");
                String string2 = resourceBundle.getString("exeWelPage_info");
                OptionPane.showMessageDialog(this, string2 + this.getCommand(), string, 1);
                return;
            }
            if (null != this.getCommand() && this.hasValidCommand()) {
                if (this.m_commandProcessor != null) {
                    CommandManager.getInstance().invokeCommand(this.getCommand(), this.m_commandProcessor);
                    return;
                }
                CommandManager.getInstance().invokeCommand(this.getCommand(), this);
                return;
            }
            if (null != this.getAction() && this.getAction().isActionEnabled()) {
                ActionEvent actionEvent = new ActionEvent(object, 1001, null);
                this.getAction().actionPerformed(actionEvent);
                return;
            }
            if (!(this instanceof DraggableButton)) return;
            WelcomeManager.getWelcomeRef().removeTextButton(this);
            return;
        }
        catch (Throwable throwable) {
            WelcomeManager.getWelcomeRef().removeTextButton(this);
            logger.trace("IView Handled error in welcome text Button mouse clickAction" + throwable);
        }
    }

    @Override
    protected void processTextClick(Object object) {
        this.processClick(object);
    }

    @Override
    protected void executeCommand() {
        WelcomeManager.getWelcomeRef().getIWBExtension().execute(new WelcomeButtonInfo(this));
    }

    public void addSelectionListener(IClickListener iClickListener) {
        this.iClickListener = iClickListener;
    }

    @Override
    public void fireClickAction(boolean bl) {
        if (bl && this.isSingleSelected()) {
            if (null != this.iClickListener) {
                this.iClickListener.buttonClicked(this);
            }
        } else {
            if (this.isSingleSelected() || null == this.iClickListener || !this.isEnabled()) {
                return;
            }
            this.iClickListener.buttonClicked(this);
        }
        this.setSingleSelected(true);
        this.getTitleComponent().repaint();
        if (this instanceof ApplicationButton) {
            this.setState(2);
        } else {
            this.setState(1);
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.repaint();
    }

    public boolean isDrawBorder() {
        return false;
    }

    void disableButton() {
        BufferedImage bufferedImage = (BufferedImage)this.shadowIconLabel.si.getImage();
        WritableRaster writableRaster = bufferedImage.copyData(null);
        this.copyImage = new BufferedImage(bufferedImage.getColorModel(), writableRaster, bufferedImage.isAlphaPremultiplied(), null);
    }

    void enableButton() {
        this.shadowIconLabel.resetEnabledImage();
    }

    public boolean setCommandProcessor(ICommandProcessor iCommandProcessor) {
        this.m_commandProcessor = iCommandProcessor;
        return true;
    }

    public ICommandProcessor getCommandProcessor() {
        return this.m_commandProcessor;
    }

    @Override
    protected boolean isPersistenceToAllUsers() {
        if (null == WelcomeManager.getWelcomeRef()) {
            return false;
        }
        return WelcomeManager.getWelcomeRef().isAllUsersLocation();
    }

    public boolean isNeedCommit() {
        return this.needCommit;
    }

    public void setNeedCommit(boolean bl) {
        this.needCommit = bl;
    }

    public void setButtonPasted(boolean bl) {
        this.buttonPasted = bl;
    }

    public boolean isButtonPasted() {
        return this.buttonPasted;
    }

    boolean isButtonLoaded(ArrayList<String> arrayList) {
        String string = null;
        string = this instanceof WorkbenchButton ? this.getFullName() : this.getFullName() + this.getCategory();
        if (arrayList.contains(string)) {
            logger.trace("Fail to load as button with name " + string + " already loaded");
            return true;
        }
        arrayList.add(string);
        return false;
    }

    private class ShadowIconLabel
    extends JLabel {
        private static final long serialVersionUID = 3426478448160712757L;
        ShadowIcon si;
        private int shadowSize = 4;
        private int shadowOffsetX = 4;
        private int shadowOffsetY = 4;
        private final Color NORMAL_HIG_COLOR = new Color(0, 0, 0, 0);
        private final Color NORMAL_LOW_COLOR = new Color(0, 0, 0, 100);
        private final Color HOVER_HIG_COLOR = new Color(0, 0, 0, 0);
        private final Color HOVER_LOW_COLOR = new Color(0, 0, 0, 204);

        public ShadowIconLabel() {
            ImageIcon imageIcon = WelcomeTextButton.this.getImage();
            BufferedImage bufferedImage = null;
            try {
                bufferedImage = ImageIO.read(new URL(imageIcon.getDescription()));
            }
            catch (IOException iOException) {
                logger.trace("exception when reading the buffered image", iOException);
                WelcomeTextButton.this.resetDefaultImage();
                imageIcon = WelcomeTextButton.this.getImage();
                bufferedImage = null;
                try {
                    bufferedImage = ImageIO.read(new URL(imageIcon.getDescription()));
                }
                catch (IOException iOException2) {
                    logger.trace("exception when reading the default buffered image", iOException2);
                    bufferedImage = null;
                    return;
                }
            }
            imageIcon.setImage(bufferedImage);
            this.si = new ShadowIcon(bufferedImage);
            this.changeSize();
            this.addListeners();
            this.setIcon(this.si);
        }

        private void resetEnabledImage() {
            if (null != WelcomeTextButton.this.copyImage) {
                this.si = new ShadowIcon(WelcomeTextButton.this.copyImage);
                this.setIcon(this.si);
            }
        }

        private void addListeners() {
            this.addMouseMotionListener(new MouseMotionListener(){

                @Override
                public void mouseDragged(MouseEvent mouseEvent) {
                    if (WelcomeTextButton.this instanceof ApplicationButton) {
                        if (!WelcomeTextButton.this.isSingleSelected()) {
                            ShadowIconLabel.this.si.setState(0);
                        }
                    } else {
                        ShadowIconLabel.this.si.setState(0);
                    }
                }

                @Override
                public void mouseMoved(MouseEvent mouseEvent) {
                    if (WelcomeTextButton.this instanceof ApplicationButton) {
                        if (!WelcomeTextButton.this.isSingleSelected()) {
                            // empty if block
                        }
                    } else if (ShadowIconLabel.this.isHoverImage(ShadowIconLabel.this.si.getImage(), mouseEvent.getPoint())) {
                        ShadowIconLabel.this.si.setState(1);
                    } else {
                        ShadowIconLabel.this.si.setState(0);
                    }
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (!(WelcomeTextButton.this instanceof ApplicationButton)) {
                        ShadowIconLabel.this.si.setState(2);
                    }
                    if (SwingUtilities.isLeftMouseButton(mouseEvent) && (mouseEvent.getModifiers() & 2) == 2) {
                        WelcomeTextButton.this.fireControlClick();
                    } else {
                        WelcomeTextButton.this.fireClickAction(SwingUtilities.isLeftMouseButton(mouseEvent));
                    }
                    WelcomeTextButton.this.showPopupForButton(mouseEvent);
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    if (!WelcomeTextButton.this.isSingleSelected()) {
                        // empty if block
                    }
                }

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (2 == mouseEvent.getClickCount() && 16 == mouseEvent.getModifiers()) {
                        try {
                            WelcomeTextButton.this.processClick(mouseEvent.getSource());
                        }
                        catch (Throwable throwable) {
                            WelcomeManager.getWelcomeRef().removeTextButton(WelcomeTextButton.this);
                            logger.trace("IView Handled error in welcome text Button mouse clickAction" + throwable);
                        }
                    }
                }
            });
        }

        private void changeSize() {
            int n = WelcomeTextButton.this.getIconDefualtWidth();
            int n2 = WelcomeTextButton.this.getIconDefualtHeight();
            Dimension dimension = new Dimension(n, n2);
            dimension.setSize(dimension.getWidth() + (double)this.shadowSize, dimension.getHeight() + (double)this.shadowSize);
            this.setPreferredSize(dimension);
            this.revalidate();
        }

        private boolean isHoverImage(Image image, Point point) {
            int n = WelcomeTextButton.this.getIconDefualtWidth();
            int n2 = WelcomeTextButton.this.getIconDefualtHeight();
            int n3 = this.getWidth();
            int n4 = this.getHeight();
            int n5 = (n3 - n) / 2;
            int n6 = (n4 - n2) / 2;
            int n7 = n5 + n;
            int n8 = n6 + n2;
            double d = point.getX();
            double d2 = point.getY();
            return d >= (double)n5 && d <= (double)n7 && d2 >= (double)n6 && d2 <= (double)n8;
        }

        private Color getMixedColor(Color color, float f, Color color2, float f2) {
            int[] nArray = new int[]{color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()};
            int[] nArray2 = new int[]{color2.getRed(), color2.getGreen(), color2.getBlue(), color2.getAlpha()};
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = (int)((float)nArray[i] * f + (float)nArray2[i] * f2);
            }
            return new Color(nArray[0], nArray[1], nArray[2], nArray[3]);
        }

        private class ShadowIcon
        extends ImageIcon {
            private static final long serialVersionUID = 5751299188989672652L;
            private static final int NORMAL = 0;
            private static final int HOVER = 1;
            private static final int PRESSED = 2;
            private int state;
            private Color shadowHig;
            private Color shadowLow;
            private boolean disabled;

            public ShadowIcon(BufferedImage bufferedImage) {
                super(bufferedImage);
                this.shadowHig = ShadowIconLabel.this.NORMAL_HIG_COLOR;
                this.shadowLow = ShadowIconLabel.this.NORMAL_LOW_COLOR;
                this.disabled = false;
            }

            public void setState(int n) {
                if (this.state == n) {
                    return;
                }
                this.state = n;
                ShadowIconLabel.this.repaint();
            }

            @Override
            public synchronized void paintIcon(Component component, Graphics graphics, int n, int n2) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                if (WelcomeTextButton.this.isTransparent()) {
                    graphics2D.setComposite(AlphaComposite.getInstance(3, 0.5f));
                } else {
                    graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
                }
                BufferedImage bufferedImage = (BufferedImage)this.getImage();
                if (WelcomeTextButton.this.isFocusSelected() || !WelcomeTextButton.this.isEnabled()) {
                    this.drawPressedState(component, graphics, bufferedImage);
                } else {
                    switch (this.state) {
                        case 0: {
                            this.drawNorState(component, graphics, n, n2, bufferedImage);
                            break;
                        }
                        case 1: {
                            this.shadowHig = ShadowIconLabel.this.HOVER_HIG_COLOR;
                            this.shadowLow = ShadowIconLabel.this.HOVER_LOW_COLOR;
                            this.drawHoverState(component, graphics, n, n2, bufferedImage);
                            break;
                        }
                        case 2: {
                            this.drawPressedState(component, graphics, bufferedImage);
                            break;
                        }
                    }
                }
            }

            private void drawNorState(Component component, Graphics graphics, int n, int n2, BufferedImage bufferedImage) {
                this.shadowHig = ShadowIconLabel.this.NORMAL_HIG_COLOR;
                this.shadowLow = ShadowIconLabel.this.NORMAL_LOW_COLOR;
                this.drawShadowState(component, graphics, n, n2, bufferedImage);
            }

            private void drawHoverState(Component component, Graphics graphics, int n, int n2, BufferedImage bufferedImage) {
                this.shadowHig = ShadowIconLabel.this.HOVER_HIG_COLOR;
                this.shadowLow = ShadowIconLabel.this.HOVER_LOW_COLOR;
                this.drawShadowState(component, graphics, n, n2, bufferedImage);
            }

            private void drawPressedState(Component component, Graphics graphics, BufferedImage bufferedImage) {
                int n = WelcomeTextButton.this.getIconDefualtWidth();
                int n2 = WelcomeTextButton.this.getIconDefualtHeight();
                int n3 = (ShadowIconLabel.this.getWidth() - n) / 2;
                graphics.drawImage(bufferedImage, n3 + ShadowIconLabel.this.shadowOffsetX / 2, ShadowIconLabel.this.shadowOffsetY / 2, n, n2, null);
                graphics.translate(n3 + ShadowIconLabel.this.shadowOffsetX / 2, ShadowIconLabel.this.shadowOffsetY / 2);
                if (WelcomeTextButton.this.isEnabled() && !(WelcomeTextButton.this instanceof ApplicationButton)) {
                    ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, WB_BORDER_TOP_CLR, 0.0f, n2, WB_BORDER_BOTTOM_CLR);
                    this.drawImageBorder((Graphics2D)graphics, bufferedImage, gradientPaint, 4);
                }
                graphics.translate(-n3 - ShadowIconLabel.this.shadowOffsetX / 2, -ShadowIconLabel.this.shadowOffsetY / 2);
                if (!this.disabled && !WelcomeTextButton.this.isEnabled()) {
                    this.disabled = true;
                    this.convertToGrayscale(bufferedImage);
                }
            }

            private void drawShadowState(Component component, Graphics graphics, int n, int n2, BufferedImage bufferedImage) {
                int n3 = WelcomeTextButton.this.getIconDefualtWidth();
                int n4 = WelcomeTextButton.this.getIconDefualtHeight();
                if (WelcomeTextButton.this instanceof WorkbenchButton) {
                    Shape shape = ImageTool.getShape(this.smallerImage(bufferedImage), 100, n3, n4, true);
                    this.paintShadow((Graphics2D)graphics, ShadowIconLabel.this.shadowSize, shape);
                }
                graphics.drawImage(bufferedImage, (ShadowIconLabel.this.getWidth() - n3) / 2, 0, n3, n4, null);
                if (this.state == 1 && !WelcomeTextButton.this.isPortalStyleButton()) {
                    this.drawImageBorder((Graphics2D)graphics, bufferedImage, Color.WHITE, 2);
                }
            }

            private void drawImageBorder(Graphics2D graphics2D, BufferedImage bufferedImage, Paint paint, int n) {
                int n2 = WelcomeTextButton.this.getIconDefualtWidth();
                int n3 = WelcomeTextButton.this.getIconDefualtHeight();
                int n4 = 0;
                if (this.state == 1 && !WelcomeTextButton.this.isFocusSelected()) {
                    n4 = (ShadowIconLabel.this.getWidth() - n2) / 2;
                }
                graphics2D.setPaint(paint);
                BufferedImage bufferedImage2 = this.getBorderImage(bufferedImage);
                bufferedImage2 = this.getBorderImage(bufferedImage2);
                graphics2D.translate(2 + n4, 2);
                graphics2D.setStroke(new BasicStroke(2.0f, 1, 1));
                Shape shape = ImageTool.getShape(bufferedImage2, 0, n2, n3, false);
                if (WelcomeTextButton.this.isEnabled() && WelcomeTextButton.this.isSingleSelected()) {
                    graphics2D.setComposite(AlphaComposite.getInstance(3, 0.5f));
                    graphics2D.setColor(SELECTED_COLOR);
                    graphics2D.fill(shape);
                }
                if (WelcomeTextButton.this.isDrawBorder()) {
                    graphics2D.setStroke(new BasicStroke(n, 1, 1));
                    graphics2D.draw(shape);
                }
            }

            public void convertToGrayscale(BufferedImage bufferedImage) {
                ColorConvertOp colorConvertOp = new ColorConvertOp(ColorSpace.getInstance(1003), null);
                colorConvertOp.filter(bufferedImage, bufferedImage);
                ShadowIconLabel.this.repaint();
            }

            private BufferedImage getBorderImage(BufferedImage bufferedImage) {
                AffineTransform affineTransform = new AffineTransform();
                int n = WelcomeTextButton.this.getIconDefualtWidth();
                int n2 = WelcomeTextButton.this.getIconDefualtHeight();
                affineTransform.scale(((float)n - 2.0f) / (float)bufferedImage.getWidth(), ((float)n2 - 2.0f) / (float)bufferedImage.getHeight());
                AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 2);
                return affineTransformOp.filter(bufferedImage, null);
            }

            private void paintShadow(Graphics2D graphics2D, int n, Shape shape) {
                int n2 = WelcomeTextButton.this.getIconDefualtWidth();
                int n3 = (ShadowIconLabel.this.getWidth() - n2) / 2;
                graphics2D.translate(n3 + ShadowIconLabel.this.shadowOffsetX + ShadowIconLabel.this.shadowSize, ShadowIconLabel.this.shadowOffsetY + ShadowIconLabel.this.shadowSize);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                int n4 = n * 2;
                float f = 2.0f / (float)n4;
                Color color = ShadowIconLabel.this.getMixedColor(this.shadowLow, f, this.shadowHig, 1.0f - f);
                for (int i = n4; i >= 0; i -= 2) {
                    graphics2D.setColor(color);
                    graphics2D.setStroke(new BasicStroke(i));
                    graphics2D.draw(shape);
                }
                graphics2D.translate(-n3 - ShadowIconLabel.this.shadowOffsetX - ShadowIconLabel.this.shadowSize, -ShadowIconLabel.this.shadowOffsetY - ShadowIconLabel.this.shadowSize);
            }

            private BufferedImage smallerImage(BufferedImage bufferedImage) {
                AffineTransform affineTransform = new AffineTransform();
                int n = WelcomeTextButton.this.getIconDefualtWidth();
                int n2 = WelcomeTextButton.this.getIconDefualtHeight();
                affineTransform.scale(((float)n - (float)(ShadowIconLabel.this.shadowSize * 2)) / (float)bufferedImage.getWidth(), ((float)n2 - (float)(ShadowIconLabel.this.shadowSize * 2)) / (float)bufferedImage.getHeight());
                AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 2);
                return affineTransformOp.filter(bufferedImage, null);
            }
        }
    }
}

