/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.windowmanagement.welcomepage;

import com.swimap.iview.commstyle.commini.AreaDescContainer;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.commini.xmlbind.PARA;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.framework.modulemanagement.ModuleManagementException;
import com.swimap.iview.framework.modulemanagement.ModuleManager;
import com.swimap.iview.framework.systemsettingsmanagement.BaseClientSettings;
import com.swimap.iview.framework.systemsettingsmanagement.SystemSettingsManager;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.framework.windowmanagement.welcomepage.ConfigUtilities;
import com.swimap.iview.util.helpmanagement.HelpManager;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.omg.CORBA.ORB;

public class WelcomePageSetting
extends BaseClientSettings {
    private boolean defaultCheckBoxFlag = false;
    private JPanel welcomePanel = null;
    private boolean changed = false;
    private JCheckBox wpsCheckBox = null;
    private static IviewLogger logger = IviewLogger.getLogger(SystemSettingsManager.class, "IVIEW");
    private static final String WELCOMEPAGE_SETTING_NAME = "WelcomePageSetting";
    private static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/framework/windowmanagement/welcomepage/Res");

    public WelcomePageSetting(ModuleManager moduleManager, ORB oRB, String string, String string2) throws ModuleManagementException {
        super(moduleManager, oRB, string, string2);
    }

    public WelcomePageSetting(ModuleManager moduleManager) throws ModuleManagementException {
        super(moduleManager);
    }

    @Override
    public boolean apply() {
        SystemSettingsManager systemSettingsManager = FrameworkUtilities.getSystemSettingsManager();
        boolean bl = this.wpsCheckBox.isSelected();
        if (this.defaultCheckBoxFlag == bl) {
            return true;
        }
        try {
            this.saveSettingsToConfig(bl);
            this.defaultCheckBoxFlag = bl;
            systemSettingsManager.setSystemSettingStatus(this.getTabLabel(), true, systemSettingsManager.getReloginMessage());
        }
        catch (IOException iOException) {
            logger.trace("IOException during the apply." + iOException);
            this.wpsCheckBox.setSelected(this.defaultCheckBoxFlag);
            systemSettingsManager.setSystemSettingStatus(this.getTabLabel(), false, res.getString("Fail_msg"));
        }
        return true;
    }

    @Override
    public boolean exit() {
        this.wpsCheckBox.setSelected(this.defaultCheckBoxFlag);
        return true;
    }

    @Override
    public JPanel getSettingsPanel() {
        if (null == this.welcomePanel) {
            this.welcomePanel = new JPanel();
            this.welcomePanel.setLayout(new BorderLayout());
            this.welcomePanel.setName("PreferenceDialog_WelcomePanel");
            boolean bl = ConfigUtilities.isEnableWelcomePage();
            JPanel jPanel = this.createWelcomePageSettingPanel(bl);
            this.welcomePanel.add((Component)jPanel, "North");
            this.welcomePanel.putClientProperty("HELP_ID_PROPERTY", "iVIEW.systemsetting.workbench");
            HelpManager.getInstance().enableHelpKey(this.welcomePanel, "iVIEW.systemsetting.workbench");
        }
        return this.welcomePanel;
    }

    @Override
    public void reinitialize() {
        super.reinitialize();
        boolean bl = ConfigUtilities.isEnableWelcomePage();
        if (null != this.wpsCheckBox) {
            this.wpsCheckBox.setSelected(bl);
            this.defaultCheckBoxFlag = bl;
        }
    }

    @Override
    public Icon getTabIcon() {
        return null;
    }

    @Override
    public String getTabLabel() {
        return res.getString("welcomePageSetting_TabLabel");
    }

    @Override
    public boolean isChanged() {
        return this.changed;
    }

    @Override
    public int getTitleDescription() {
        return 1;
    }

    @Override
    public String getModuleName() {
        return WELCOMEPAGE_SETTING_NAME;
    }

    private JPanel createWelcomePageSettingPanel(boolean bl) {
        JPanel jPanel = new JPanel();
        jPanel.setName("WelcomePageSettingPanel");
        this.wpsCheckBox = new JCheckBox();
        this.wpsCheckBox.setName("WelcomePageSettingCheckBox");
        jPanel.setLayout(new GridBagLayout());
        this.defaultCheckBoxFlag = bl;
        this.wpsCheckBox.setSelected(bl);
        this.wpsCheckBox.setText(res.getString("welcomePageSetting_CheckboxLabel"));
        logger.trace("creating theWelcomePageSettingPanel...");
        jPanel.add((Component)this.wpsCheckBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 17, 8, 12), 0, 0));
        this.wpsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WelcomePageSetting.this.wpsCheckBox_actionPerformed();
            }
        });
        logger.trace("createdtheWelcomePageSettingPanel!!!");
        return jPanel;
    }

    private void wpsCheckBox_actionPerformed() {
        boolean bl = this.wpsCheckBox.isSelected();
        this.changed = bl != this.defaultCheckBoxFlag;
        this.notifyChange();
    }

    private void notifyChange() {
        FrameworkUtilities.getSystemSettingsManager().clientSettingChanged(this.getModuleName(), this.changed);
    }

    private void saveSettingsToConfig(boolean bl) throws IOException {
        CommStyleManager commStyleManager = CommStyleManager.getInstance();
        CommStyleInfo commStyleInfo = commStyleManager.getCommonStyleFile("conf/mainfrm/welcomepagesetting");
        if (null == commStyleInfo) {
            return;
        }
        AreaDescContainer areaDescContainer = commStyleInfo.getAreaDescContainer(0);
        DescContainer descContainer = areaDescContainer.getDescContainer("pagesetting");
        if (null != descContainer) {
            if (descContainer.getParasItemCount() != 1) {
                areaDescContainer.removeDescContainer("pagesetting");
                DescContainer descContainer2 = new DescContainer("pagesetting");
                areaDescContainer.addDescContainer(descContainer2);
                PARA pARA = new PARA();
                pARA.setName("isEnableWelcomePage");
                descContainer2.addParasItem(pARA);
                descContainer2.setParasItem("isEnableWelcomePage", String.valueOf(bl), true);
            } else {
                descContainer.setParasItem("isEnableWelcomePage", String.valueOf(bl), true);
            }
            CommStyleManager.getInstance().writeToServer(commStyleInfo);
        }
    }
}

