/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.windowmanagement.welcomepage;

import com.swimap.iview.commstyle.commandmng.CommandManager;
import com.swimap.iview.commstyle.commandmng.ICommandProcessor;
import com.swimap.iview.commstyle.commandmng.authority.AuthorityAction;
import com.swimap.iview.commstyle.commandmng.authority.AuthorityView;
import com.swimap.iview.commstyle.commini.AreaDescContainer;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.CommStyleParserFactory;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.commini.IProfileParser;
import com.swimap.iview.commstyle.commini.MenuItem;
import com.swimap.iview.commstyle.commini.PathManager;
import com.swimap.iview.commstyle.commini.TextButton;
import com.swimap.iview.commstyle.commini.xmlbind.PARA;
import com.swimap.iview.commstyle.commini.xmlbind.PARAS;
import com.swimap.iview.commstyle.commini.xmlimpl.read.XmlObject;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.commstyle.resource.i18n.ResourceUtil;
import com.swimap.iview.framework.Main;
import com.swimap.iview.framework.pluginmanagement.Plugin;
import com.swimap.iview.framework.pluginmanagement.PluginManager;
import com.swimap.iview.framework.subsystemmanagement.SubsystemManager;
import com.swimap.iview.framework.util.FrameworkCommandProcessor;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.framework.windowmanagement.InternalFrame;
import com.swimap.iview.framework.windowmanagement.welcomepage.AddLinkDialog;
import com.swimap.iview.framework.windowmanagement.welcomepage.ButtonClipboard;
import com.swimap.iview.framework.windowmanagement.welcomepage.ButtonInfo;
import com.swimap.iview.framework.windowmanagement.welcomepage.ConfigUtilities;
import com.swimap.iview.framework.windowmanagement.welcomepage.FixedSplitPane;
import com.swimap.iview.framework.windowmanagement.welcomepage.IButtonStateListerer;
import com.swimap.iview.framework.windowmanagement.welcomepage.IMenuClickListener;
import com.swimap.iview.framework.windowmanagement.welcomepage.IWBLauncher;
import com.swimap.iview.framework.windowmanagement.welcomepage.IWBLauncherFactory;
import com.swimap.iview.framework.windowmanagement.welcomepage.MenuAddLinkDialog;
import com.swimap.iview.framework.windowmanagement.welcomepage.ModifyLinkDialog;
import com.swimap.iview.framework.windowmanagement.welcomepage.ScrollableFlowPanel;
import com.swimap.iview.framework.windowmanagement.welcomepage.WelcomeButtonInfo;
import com.swimap.iview.framework.windowmanagement.welcomepage.WelcomeButtonModifyDialog;
import com.swimap.iview.framework.windowmanagement.welcomepage.WelcomeManager;
import com.swimap.iview.framework.windowmanagement.welcomepage.WelcomeTextButton;
import com.swimap.iview.framework.windowmanagement.welcomepage.WelcomeUtilities;
import com.swimap.iview.framework.windowmanagement.welcomepage.WorkbenchButton;
import com.swimap.iview.framework.windowmanagement.welcomepage.WorkbenchCombo;
import com.swimap.iview.framework.windowmanagement.welcomepage.WorkbenchInfo;
import com.swimap.iview.framework.windowmanagement.welcomepage.WorkbenchLayout;
import com.swimap.iview.framework.windowmanagement.welcomepage.WorkbenchManager;
import com.swimap.iview.framework.windowmanagement.welcomepage.draggable.DraggableButton;
import com.swimap.iview.framework.windowmanagement.welcomepage.draggable.DraggableButtonDropTargetListener;
import com.swimap.iview.framework.windowmanagement.welcomepage.draggable.DraggableLayout;
import com.swimap.iview.framework.windowmanagement.welcomepage.draggable.PanelDropTargetListener;
import com.swimap.iview.framework.windowmanagement.welcomepage.draggable.ScrollableDragPanel;
import com.swimap.iview.framework.windowmanagement.welcomepage.draggable.WorkbenchDragPanel;
import com.swimap.iview.framework.windowmanagement.welcomepage.draggable.WorkbenchDropTargetListener;
import com.swimap.iview.framework.windowmanagement.welcomepage.exception.ButtonInfoException;
import com.swimap.iview.util.OptionPane;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class WelcomePage
extends InternalFrame
implements IButtonStateListerer,
IMenuClickListener {
    private static IviewLogger logger = IviewLogger.getLogger(WelcomePage.class, "IVIEW");
    static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/framework/windowmanagement/Res");
    private static final int MAX_BUTTON_COUNT = 100;
    public static final String WELCOME_BUTTON_SETTING_DESC = "welcomebuttonsetting";
    public static final int GRIDBAG_LAYOUT = 0;
    public static final int FLOW_LAYOUT = 1;
    public static final int DRAGGABLE_LAYOUT = 2;
    private static final int SCROLL_UNIT = 30;
    private JPanel foregroundPanel = null;
    private JPanel workbenchForePanel = null;
    private ArrayList<String> filteredCommandsTempList = null;
    private ArrayList<WelcomeTextButton> treeBtnList = new ArrayList(10);
    private ArrayList<String> treeButtonNameSet = new ArrayList(16);
    private static final GridBagConstraints gbConst = new GridBagConstraints();
    private static final int MAX_TEXT_LENGTH = 127;
    private final Object FILEMAP_LOCK = new Object();
    private ArrayList<WelcomeTextButton> m_buttonArray = new ArrayList(10);
    private ConcurrentHashMap<WelcomeTextButton, CommStyleInfo> commMap = new ConcurrentHashMap(20);
    private Map<String, WelcomeTextButton> fileMap = new HashMap<String, WelcomeTextButton>(20);
    private List<WelcomeTextButton> enableList = new ArrayList<WelcomeTextButton>(10);
    private List<WelcomeTextButton> selectedList = null;
    private CommStyleInfo exeCommstyle = null;
    private AreaDescContainer areaDesc = null;
    private DescContainer exeDescContainer = null;
    private int serialNo = 0;
    protected Point popupPoint = null;
    private AddLinkDialog treeDialog = null;
    private WorkbenchManager workbenchManager = null;
    private ButtonClipboard clipboard = null;
    private FixedSplitPane splitPane = null;
    private JPanel mainPanel = null;
    private List<String> workBenchList = new ArrayList<String>(10);
    static boolean jbInitCalled;
    private transient MouseAdapter showPopupMenuMouseAdapter = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            WelcomePage.this.popupPoint = null;
            if ((mouseEvent.getModifiers() & 4) != 0) {
                JPopupMenu jPopupMenu = WelcomePage.this.getPopupMenu();
                WelcomePage.this.popupPoint = mouseEvent.getPoint();
                if (null != jPopupMenu && WelcomePage.this.isAnyPopupMenuEnabled()) {
                    ScreenToolKit.showPopupMenu(jPopupMenu, mouseEvent);
                }
            } else {
                WelcomePage.this.buttonClicked(null);
            }
        }
    };
    Map<String, ArrayList<String>> buttonNameSet = new ConcurrentHashMap<String, ArrayList<String>>(20);

    public WelcomePage() {
        this.readConfigFile(true);
    }

    public WelcomePage(boolean bl) {
        jbInitCalled = false;
        ConfigUtilities.readWelcomePageSetting();
    }

    protected void initWelcomePage(WorkbenchManager workbenchManager) {
        this.workbenchManager = workbenchManager;
        this.clipboard = new ButtonClipboard();
        this.readAndSortWelcomeButton();
    }

    private void readAndSortWelcomeButton() {
        this.selectedList = this.readWelcomeButtonConfig();
        int n = this.selectedList.size();
        boolean bl = ConfigUtilities.isDraggableLayout();
        WelcomeTextButton welcomeTextButton = null;
        for (int i = 0; i < n; ++i) {
            welcomeTextButton = this.selectedList.get(i);
            if (welcomeTextButton.isUserEnable() || bl) continue;
            welcomeTextButton.setSerialNo(this.serialNo++);
        }
        this.treeBtnList.clear();
        this.populateTreeBtnList();
    }

    protected WelcomePage(WorkbenchManager workbenchManager, boolean bl) {
        this.workbenchManager = workbenchManager;
        this.clipboard = new ButtonClipboard();
        this.readConfigFile(bl);
    }

    private void readConfigFile(boolean bl) {
        ConfigUtilities.readWelcomePageSetting();
        this.readAndSortWelcomeButton();
    }

    private boolean isAnyPopupMenuEnabled() {
        boolean bl = WelcomeManager.popupvisibilemap.get((Object)WelcomeManager.WBpopupMenuItems.ArrangeIconByName);
        boolean bl2 = WelcomeManager.popupvisibilemap.get((Object)WelcomeManager.WBpopupMenuItems.CreateShortCut);
        boolean bl3 = WelcomeManager.popupvisibilemap.get((Object)WelcomeManager.WBpopupMenuItems.Paste);
        return bl || bl2 || bl3;
    }

    private void sortButtons(List<WelcomeTextButton> list) {
        List<WelcomeTextButton> list2 = null;
        list2 = ConfigUtilities.isDraggableLayout() ? this.workbenchManager.getSelectedWPButtons() : list;
        List<WelcomeTextButton> list3 = this.getVisibleItems(list2);
        int n = list3.size();
        int n2 = n > 100 ? 100 : n;
        this.m_buttonArray.clear();
        Collections.sort(list3, WelcomeManager.SL_NUMBER_COMPTR);
        WelcomeTextButton welcomeTextButton = null;
        for (int i = 0; i < n2; ++i) {
            welcomeTextButton = list3.get(i);
            this.m_buttonArray.add(welcomeTextButton);
        }
    }

    private List<WelcomeTextButton> getVisibleItems(List<WelcomeTextButton> list) {
        List<WelcomeTextButton> list2 = new ArrayList<WelcomeTextButton>(0);
        if (null == list) {
            return list2;
        }
        list2 = this.getVisibileButtons(list);
        return list2;
    }

    private ArrayList<WelcomeTextButton> readWelcomeButtonConfig() {
        CommStyleInfo commStyleInfo;
        CommStyleInfo commStyleInfo2;
        ArrayList<WelcomeTextButton> arrayList = new ArrayList<WelcomeTextButton>(16);
        List<Plugin> list = PluginManager.getInstance().getStartupPluginList();
        int n = 0;
        String[] stringArray = FrameworkCommandProcessor.getInstance().getFilteredExtPaths(Main.extPaths);
        if (stringArray != null) {
            n = stringArray.length;
            String string = null;
            commStyleInfo2 = null;
            for (int i = 0; i < n; ++i) {
                string = "conf/" + stringArray[i] + "/welcomebutton";
                commStyleInfo2 = WelcomeManager.getWelcomeButtonInfo(string);
                if (null == commStyleInfo2) {
                    logger.trace("CommStyleInfo not available for path : " + string);
                    continue;
                }
                this.createWelcomeTextButton(commStyleInfo2, arrayList, false, false);
            }
        }
        int n2 = 0;
        if (list != null) {
            commStyleInfo2 = null;
            n2 = list.size();
            Plugin plugin = null;
            boolean bl = this.isAllUsersLocation();
            for (int i = 0; i < n2; ++i) {
                plugin = list.get(i);
                commStyleInfo2 = bl ? WelcomeManager.getWelcomeButtonInfo(plugin.getPluginName() + "/alluser") : WelcomeManager.getWelcomeButtonInfo(plugin.getPluginName() + "/user");
                if (null == commStyleInfo2) continue;
                this.createWelcomeTextButton(commStyleInfo2, arrayList, false, false);
            }
        }
        if (null != (commStyleInfo2 = this.readExeCommInfo())) {
            this.createWelcomeTextButton(commStyleInfo2, arrayList, true, false);
            this.exeCommstyle = commStyleInfo2;
            this.areaDesc = commStyleInfo2.getAreaDescContainer(0);
            this.exeDescContainer = this.areaDesc.getDescContainer(0);
        }
        if (ConfigUtilities.isDraggableLayout() && null != (commStyleInfo = WorkbenchManager.getImportCommStyle())) {
            this.createWelcomeTextButton(commStyleInfo, arrayList, false, false);
        }
        return arrayList;
    }

    private void refreshGridLayoutPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = this.m_buttonArray.size();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (0 != n) {
            n4 = this.getNumberOfRows(gridBagConstraints, n);
        }
        gridBagConstraints.gridx = n3;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        WelcomeTextButton welcomeTextButton = null;
        for (int i = 0; i < n; ++i) {
            welcomeTextButton = this.m_buttonArray.get(i);
            gridBagConstraints.gridx = n3++;
            if (i % n4 == 0 && i != 0) {
                gridBagConstraints.gridy = ++n2;
                n3 = 0;
                gridBagConstraints.gridx = n3++;
            }
            this.foregroundPanel.add((Component)welcomeTextButton, gridBagConstraints);
        }
    }

    private void refreshFlowLayoutPanel() {
        int n = this.m_buttonArray.size();
        WelcomeTextButton welcomeTextButton = null;
        for (int i = 0; i < n; ++i) {
            welcomeTextButton = this.m_buttonArray.get(i);
            this.foregroundPanel.add(welcomeTextButton);
        }
    }

    protected void jbInit() {
        super.setTitle(ConfigUtilities.getWelcomePageTitle());
        this.setClosable(ConfigUtilities.isWorkbenchCloseable());
        this.setupLayout();
        this.hideButtons();
        this.mainPanel = this.wrapInBackgroundImage(this.foregroundPanel, ConfigUtilities.getWelcomeImage(), 1, 10);
        JPanel jPanel = null;
        if (!ConfigUtilities.isDraggableLayout()) {
            this.mainPanel.setComponentPopupMenu(this.getPopupMenu());
            this.changeBackGroundImage(ConfigUtilities.getWelcomeImage(), this.mainPanel, this.foregroundPanel, 1.0f);
        } else {
            jPanel = this.wrapInBackgroundImage(this.workbenchForePanel, ConfigUtilities.getWorkbenchImage(), 1, 10);
            this.changeBackGroundImage(ConfigUtilities.getWorkbenchImage(), jPanel, this.workbenchForePanel, 0.5f);
        }
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(this.mainPanel);
        if (ConfigUtilities.isDraggableLayout()) {
            JScrollPane jScrollPane2 = new JScrollPane();
            jScrollPane2.getVerticalScrollBar().setBlockIncrement(30);
            jScrollPane2.getVerticalScrollBar().setUnitIncrement(30);
            jScrollPane2.setMinimumSize(new Dimension(174, 100));
            jScrollPane2.getViewport().add(jPanel);
            this.splitPane = new FixedSplitPane(1, (Component)jScrollPane2, jScrollPane);
            this.getContentPane().add(this.splitPane);
        } else {
            this.getContentPane().add(jScrollPane);
        }
    }

    private void hideButtons() {
        boolean bl = Boolean.getBoolean("hideallwelcomebuttons");
        if (!bl) {
            return;
        }
        ArrayList<WelcomeButtonInfo> arrayList = null;
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (WorkbenchInfo workbenchInfo : this.workbenchManager.getAllWorkbenches()) {
            arrayList = workbenchInfo.getAllWelcomeButtons();
            for (WelcomeButtonInfo welcomeButtonInfo : arrayList) {
                arrayList2.add(welcomeButtonInfo.getButton().getDescName());
            }
        }
        this.workbenchManager.setWelcomeButtonVisibility(arrayList2, false);
    }

    private void setupLayout() {
        switch (ConfigUtilities.getLayoutType()) {
            case 1: {
                FlowLayout flowLayout = new FlowLayout(0, 18, 20);
                this.foregroundPanel = new ScrollableFlowPanel(flowLayout);
                this.foregroundPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
                this.foregroundPanel.setOpaque(false);
                this.refreshFlowLayoutPanel();
                break;
            }
            case 0: {
                GridBagLayout gridBagLayout = new GridBagLayout();
                this.foregroundPanel = new JPanel(gridBagLayout);
                this.foregroundPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
                this.foregroundPanel.setOpaque(false);
                this.refreshGridLayoutPanel();
                break;
            }
            default: {
                this.setupDraggableLayout();
            }
        }
    }

    private void setupDraggableLayout() {
        WorkbenchLayout workbenchLayout = new WorkbenchLayout();
        this.workbenchForePanel = new WorkbenchDragPanel(workbenchLayout);
        this.workbenchForePanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.workbenchForePanel.setOpaque(false);
        this.workbenchForePanel.setComponentPopupMenu(this.workbenchManager.getPopupMenu());
        this.workbenchForePanel.setDropTarget(new DropTarget(this.workbenchForePanel, new WorkbenchDropTargetListener(this.workbenchForePanel)));
        this.refreshWorkbenchPanel();
        DraggableLayout draggableLayout = new DraggableLayout();
        this.foregroundPanel = new ScrollableDragPanel(draggableLayout);
        this.foregroundPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.foregroundPanel.setOpaque(false);
        try {
            this.foregroundPanel.setDropTarget(new DropTarget(this.foregroundPanel, new PanelDropTargetListener(this.foregroundPanel, this, DraggableButton.getDragAndDropPanelDataFlavor())));
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.foregroundPanel.setDropTarget(new DropTarget(this.foregroundPanel, new PanelDropTargetListener(this.foregroundPanel, this, null)));
        }
        this.foregroundPanel.addMouseListener(this.showPopupMenuMouseAdapter);
        this.addResizeListener();
        this.fetchDraggableButtons();
        DraggableButton.resetDuplicates(this.m_buttonArray);
        boolean bl = DraggableButton.sortDragableWelcomeTextButtons(this.m_buttonArray);
        this.workbenchManager.setFreshLoading(bl);
        if (this.workbenchManager.isFreshLoading()) {
            this.arrangeIconByName(this.workbenchManager.getSelectedWBenchId());
        } else {
            this.refreshDraggableLayoutPanel(this.m_buttonArray);
        }
    }

    private void addResizeListener() {
        this.foregroundPanel.addHierarchyBoundsListener(new HierarchyBoundsListener(){

            @Override
            public void ancestorMoved(HierarchyEvent hierarchyEvent) {
            }

            @Override
            public void ancestorResized(HierarchyEvent hierarchyEvent) {
                if (null != WelcomePage.this.splitPane) {
                    WelcomePage.this.splitPane.revalidate();
                }
            }
        });
    }

    private void fetchDraggableButtons() {
        ArrayList<WelcomeTextButton> arrayList = this.workbenchManager.getSelectedWPButtons();
        int n = arrayList.size();
        int n2 = n > 100 ? 100 : n;
        this.m_buttonArray.clear();
        WelcomeTextButton welcomeTextButton = null;
        for (int i = 0; i < n2; ++i) {
            welcomeTextButton = arrayList.get(i);
            this.m_buttonArray.add(welcomeTextButton);
        }
    }

    private void refreshWorkbenchPanel() {
        this.workbenchForePanel.removeAll();
        ArrayList<WorkbenchButton> arrayList = this.workbenchManager.retrieveWorkbenchButtons();
        for (WorkbenchButton workbenchButton : arrayList) {
            if (!workbenchButton.isSelected()) continue;
            this.workbenchForePanel.add(workbenchButton);
        }
        this.workbenchForePanel.revalidate();
        this.workbenchForePanel.doLayout();
        this.workbenchForePanel.updateUI();
    }

    private void refreshDraggableLayoutPanel(ArrayList<WelcomeTextButton> arrayList) {
        int n = arrayList.size();
        int n2 = 0;
        int n3 = 0;
        DraggableButton draggableButton = null;
        int n4 = (ScreenToolKit.getScreenWidth() - 174) / DraggableLayout.getDefaulFixedWidth();
        boolean bl = true;
        Point point = new Point(n2, n3);
        for (int i = 0; i < n; ++i) {
            draggableButton = (DraggableButton)arrayList.get(i);
            bl = true;
            point.x = draggableButton.getXIndex();
            point.y = draggableButton.getYIndex();
            if (draggableButton.getXIndex() != -1 && draggableButton.getYIndex() != -1 && !this.isButtonExistsinXY(new Point(draggableButton.getXIndex(), draggableButton.getYIndex()))) {
                this.addDraggableButton(draggableButton);
                bl = false;
            }
            if (bl) {
                while (this.isButtonExistsinXY(new Point(n2, n3))) {
                    if (++n2 % n4 != 0 || n2 == 0) continue;
                    ++n3;
                    n2 = 0;
                }
                this.addDraggableButton(draggableButton, n2, n3);
            }
            if (!draggableButton.storeXYInfo()) continue;
            this.modifylink(draggableButton, true);
        }
        this.workBenchList.clear();
        this.foregroundPanel.doLayout();
        this.workbenchForePanel.doLayout();
    }

    private boolean isButtonExistsinXY(Point point) {
        Component[] componentArray;
        boolean bl = false;
        if (null == point || null == this.foregroundPanel) {
            return bl;
        }
        for (Component component : componentArray = this.foregroundPanel.getComponents()) {
            DraggableButton draggableButton;
            if (!(component instanceof DraggableButton) || (draggableButton = (DraggableButton)component).getXIndex() != point.x || draggableButton.getYIndex() != point.y) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private int getNumberOfRows(GridBagConstraints gridBagConstraints, int n) {
        if (0 < n && n <= 4) {
            gridBagConstraints.insets = new Insets(100, 240 / n, 100, 240 / n);
            return 4;
        }
        if (4 < n && n <= 6) {
            gridBagConstraints.insets = new Insets(50, 90, 50, 90);
            return 3;
        }
        if (6 < n && n <= 8) {
            gridBagConstraints.insets = new Insets(50, 60, 50, 60);
            return 4;
        }
        if (n == 9) {
            gridBagConstraints.insets = new Insets(25, 90, 25, 90);
            return 3;
        }
        if (9 < n && n <= 16) {
            gridBagConstraints.insets = new Insets(25, 60, 25, 60);
            return 4;
        }
        gridBagConstraints.insets = new Insets(5, 60, 5, 60);
        return 5;
    }

    public JPanel wrapInBackgroundImage(JComponent jComponent, Icon icon, int n, int n2) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jComponent.setOpaque(false);
        jPanel.add((Component)jComponent, gbConst);
        JLabel jLabel = new JLabel(icon);
        jLabel.setMinimumSize(new Dimension(1, 1));
        jLabel.setPreferredSize(new Dimension(1, 1));
        jLabel.setHorizontalAlignment(n2);
        jLabel.setVerticalAlignment(n);
        jPanel.add((Component)jLabel, gbConst);
        return jPanel;
    }

    private JPopupMenu getPopupMenu() {
        final JPopupMenu jPopupMenu = new JPopupMenu();
        this.addCreationMenuItems(jPopupMenu);
        final JMenuItem jMenuItem = new JMenuItem(res.getString("Arrange_Links"));
        jMenuItem.setName("ArrangeIconByName");
        jMenuItem.setMnemonic('A');
        final JMenuItem jMenuItem2 = new JMenuItem(res.getString("Paste_Link"));
        jMenuItem2.setName("Paste");
        jMenuItem2.setMnemonic('P');
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WelcomePage.this.pasteButton(FrameworkUtilities.getMainFrame(), WelcomePage.this.workbenchManager.getSelectedWBench(), true);
            }
        });
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WelcomePage.this.arrangeIconByName(WelcomePage.this.workbenchManager.getSelectedWBenchId());
                WelcomePage.this.scrollToWorkbench();
            }
        });
        if (ConfigUtilities.isDraggableLayout()) {
            jMenuItem.setEnabled(this.workbenchManager.getSelectedWPButtons().size() > 0);
            jMenuItem2.setEnabled(null != this.clipboard.getClipboardButton());
            jPopupMenu.add(new JSeparator());
            jPopupMenu.add(jMenuItem);
            jPopupMenu.add(new JSeparator());
            jPopupMenu.add(jMenuItem2);
        }
        jPopupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                jMenuItem.setVisible(WelcomeManager.popupvisibilemap.get((Object)WelcomeManager.WBpopupMenuItems.ArrangeIconByName));
                jMenuItem2.setVisible(WelcomeManager.popupvisibilemap.get((Object)WelcomeManager.WBpopupMenuItems.Paste));
                WelcomePage.this.validateMenuSeparators(jPopupMenu);
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }
        });
        this.validateMenuSeparators(jPopupMenu);
        return jPopupMenu;
    }

    private void addCreationMenuItems(final JPopupMenu jPopupMenu) {
        final JMenuItem jMenuItem = new JMenuItem(res.getString("Create_Function_Link"));
        jMenuItem.setName("WelcomePage_functionLink_MenuItem");
        jMenuItem.setMnemonic('S');
        JMenuItem jMenuItem2 = new JMenuItem(res.getString("CREATE") + this.getIWBExtension().getPopupMenuItemName());
        jMenuItem2.setName("WelcomePage_exeLink_MenuItem");
        jMenuItem2.setMnemonic('C');
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WorkbenchInfo workbenchInfo = null;
                if (ConfigUtilities.isDraggableLayout()) {
                    workbenchInfo = new WorkbenchInfo(WelcomePage.this.workbenchManager.getSelectedWBench());
                }
                try {
                    WelcomePage.this.addLink(null, workbenchInfo, true, false, null);
                }
                catch (ButtonInfoException buttonInfoException) {
                    logger.trace(buttonInfoException);
                }
            }
        });
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WorkbenchInfo workbenchInfo = null;
                if (ConfigUtilities.isDraggableLayout()) {
                    workbenchInfo = new WorkbenchInfo(WelcomePage.this.workbenchManager.getSelectedWBench());
                }
                try {
                    WelcomePage.this.addLink(null, workbenchInfo, true, true, null);
                }
                catch (ButtonInfoException buttonInfoException) {
                    logger.trace(buttonInfoException);
                }
            }
        });
        if (ConfigUtilities.isDraggableLayout()) {
            jMenuItem.setEnabled(null != this.workbenchManager.getSelectedWBench());
            jMenuItem2.setEnabled(null != this.workbenchManager.getSelectedWBench());
        }
        jPopupMenu.add(jMenuItem);
        if (IWBLauncherFactory.isExtensionExist()) {
            jPopupMenu.add(jMenuItem2);
            jPopupMenu.remove(jMenuItem);
        }
        jPopupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                jMenuItem.setVisible(WelcomeManager.popupvisibilemap.get((Object)WelcomeManager.WBpopupMenuItems.CreateShortCut));
                WelcomePage.this.validateMenuSeparators(jPopupMenu);
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }
        });
    }

    boolean pasteButton(JFrame jFrame, WorkbenchButton workbenchButton, boolean bl) {
        DraggableButton draggableButton = this.clipboard.getClipboardButton();
        if (null == draggableButton) {
            return false;
        }
        String string = draggableButton.getWorkbenchId();
        int n = this.clipboard.getClipboardType();
        DraggableButton draggableButton2 = null;
        boolean bl2 = false;
        boolean bl3 = ResourceUtil.areEquals(string, workbenchButton.getWorkbenchId());
        if (n == 1 && (bl3 || !bl3 && !this.selectedReachedMaximumButtons(workbenchButton, 1, jFrame))) {
            if (!bl3 && this.isButtonExistWorkbench(draggableButton.getFullName(), workbenchButton.getWorkbenchId())) {
                OptionPane.showLineWrapOptionDialog(FrameworkUtilities.getMainFrame(), WelcomeUtilities.res.getString("Button_Exist"), 1);
                return false;
            }
            if (!bl) {
                this.popupPoint = new Point(1, 1);
            }
            draggableButton2 = this.cutPastedButton(draggableButton, workbenchButton.getWorkbenchId());
            if (!bl3) {
                this.foregroundPanel.add(draggableButton2);
                if (this.foregroundPanel.getComponentZOrder(draggableButton2) > 0) {
                    this.foregroundPanel.setComponentZOrder(draggableButton2, 0);
                }
            }
            this.clipboard.clearClipboard();
            bl2 = true;
        } else if (n == 0 && !this.selectedReachedMaximumButtons(workbenchButton, 1, jFrame) && null != (draggableButton2 = this.doCopyPatse(draggableButton, workbenchButton.getWorkbenchId(), true))) {
            this.foregroundPanel.add(draggableButton2);
            draggableButton2.fireClickAction(false);
            bl2 = true;
        }
        if (bl2) {
            this.updateInfo(draggableButton2);
            this.foregroundPanel.doLayout();
            this.foregroundPanel.scrollRectToVisible(new Rectangle(draggableButton2.getX(), draggableButton2.getY(), DraggableLayout.getDefaulFixedWidth(), DraggableLayout.getDefaulFixedHeigth()));
            this.saveWelcomeButtonInfo(string);
            this.workbenchManager.addWorkBenchInfo(draggableButton2);
            this.workbenchManager.fireWelcomeButtonEvent(draggableButton2, 0);
        }
        return true;
    }

    private DraggableButton cutPastedButton(DraggableButton draggableButton, String string) {
        this.workbenchManager.removeWelcomeButton(draggableButton);
        this.removeButtonInfoFromButtonSet(draggableButton);
        this.workbenchManager.fireWelcomeButtonEvent(draggableButton, 2);
        draggableButton.setWorkbenchId(string);
        this.setDragabbleXY(draggableButton, this.popupPoint);
        draggableButton.storeXYInfo();
        this.deleteExistingButton(draggableButton);
        this.modifylink(draggableButton, true);
        draggableButton.fireClickAction(false);
        this.addButtonInfoToButtonSet(draggableButton);
        return draggableButton;
    }

    private void deleteExistingButton(DraggableButton draggableButton) {
        DescContainer descContainer = null;
        DescContainer descContainer2 = null;
        String string = null;
        CommStyleInfo commStyleInfo = this.commMap.get(draggableButton);
        if (null != commStyleInfo) {
            DescContainer descContainer3 = commStyleInfo.getAreaDescContainer(0).getDescContainer(WELCOME_BUTTON_SETTING_DESC);
            String string2 = draggableButton.getFullName();
            String string3 = draggableButton.getWorkbenchId();
            String string4 = "_default_iview_workbenches";
            int n = descContainer3.getDescContainerCount();
            String string5 = "";
            for (int i = 0; i < n; ++i) {
                descContainer2 = descContainer3.getDescContainer(i);
                string5 = descContainer2.getParasItemValue("name");
                string = commStyleInfo.getResString(string5);
                if (null == string) {
                    string = string5;
                }
                if (null == (string4 = descContainer2.getParasItemValue("workbenchid")) || string4.isEmpty()) {
                    string4 = "_default_iview_workbenches";
                }
                if (!string2.equals(string) || !string4.equals(string3)) continue;
                if (descContainer != null) {
                    descContainer3.removeDescContainer(descContainer);
                    descContainer = null;
                    break;
                }
                descContainer = descContainer2;
            }
        }
    }

    private DraggableButton doCopyPatse(WelcomeTextButton welcomeTextButton, String string, boolean bl) {
        if (welcomeTextButton == null) {
            logger.trace("Invalid button");
            return null;
        }
        DraggableButton draggableButton = null;
        DescContainer descContainer = welcomeTextButton.getDescContainer();
        if (null == descContainer) {
            return draggableButton;
        }
        DescContainer descContainer2 = this.getCopyDesc(descContainer, welcomeTextButton.getFullName(), string);
        if (this.getNameLength(descContainer2) > 127) {
            String string2 = res.getString("Max_Name_Length_Limit_Reached");
            OptionPane.showMessageDialog(this.getContentPane(), string2);
            return draggableButton;
        }
        CommStyleInfo commStyleInfo = null;
        commStyleInfo = false == welcomeTextButton.isExecutable() || welcomeTextButton.isImported() ? this.commMap.get(welcomeTextButton) : this.exeCommstyle;
        if (null != commStyleInfo && commStyleInfo.getAreaDescCount() > 0) {
            Object object;
            if (!welcomeTextButton.isExecutable()) {
                object = commStyleInfo.getAreaDescContainer(0);
                if (null != object && null != ((AreaDescContainer)object).getDescContainer(WELCOME_BUTTON_SETTING_DESC)) {
                    ((AreaDescContainer)object).getDescContainer(WELCOME_BUTTON_SETTING_DESC).addDescContainer(descContainer2);
                } else if (null != object && null == ((AreaDescContainer)object).getDescContainer(WELCOME_BUTTON_SETTING_DESC)) {
                    DescContainer descContainer3 = new DescContainer(WELCOME_BUTTON_SETTING_DESC);
                    descContainer3.addDescContainer(descContainer2);
                    ((AreaDescContainer)object).addDescContainer(descContainer3);
                }
            } else {
                this.writeExeCommInfo(descContainer2);
            }
            if (!bl) {
                this.popupPoint = new Point(1, 1);
            }
            draggableButton = this.addCopiedButtonsInfo(descContainer2, commStyleInfo, string);
            if (welcomeTextButton.isActionButton()) {
                draggableButton.setActionButton(true);
            }
            draggableButton.initializeButton();
            object = welcomeTextButton.getCommandProcessor();
            if (null != object) {
                draggableButton.setCommandProcessor((ICommandProcessor)object);
            }
            if (!welcomeTextButton.isEnabled()) {
                draggableButton.setEnabled(false);
            } else {
                draggableButton.setEnabled(true);
            }
            this.setDraggableTarget(draggableButton);
        }
        return draggableButton;
    }

    public DraggableButton copyPastedButton(WelcomeTextButton welcomeTextButton, String string) {
        if (string == null || this.workbenchManager.getWorkbenchById(string).isEmpty()) {
            logger.trace("Invalid work bench inforamtion");
            return null;
        }
        if (null == welcomeTextButton || !welcomeTextButton.isEnabled() || !welcomeTextButton.isVisible()) {
            logger.trace("Invalid Button || Button is disabled or not visible ");
            return null;
        }
        DraggableButton draggableButton = this.doCopyPatse(welcomeTextButton, string, false);
        if (null != draggableButton) {
            if (ResourceUtil.areEquals(string, this.workbenchManager.getSelectedWBenchId())) {
                this.foregroundPanel.add(draggableButton);
            }
            draggableButton.fireClickAction(false);
            this.foregroundPanel.doLayout();
            this.foregroundPanel.scrollRectToVisible(new Rectangle(draggableButton.getX(), draggableButton.getY(), DraggableLayout.getDefaulFixedWidth(), DraggableLayout.getDefaulFixedHeigth()));
            this.saveWelcomeButtonInfo(string);
            this.workbenchManager.addWorkBenchInfo(draggableButton);
            this.workbenchManager.fireWelcomeButtonEvent(draggableButton, 0);
        }
        return draggableButton;
    }

    private DraggableButton addCopiedButtonsInfo(DescContainer descContainer, CommStyleInfo commStyleInfo, String string) {
        DraggableButton draggableButton = (DraggableButton)DraggableButton.getUIObject(descContainer);
        draggableButton.setPopupMenu(this.getButtonPopupMenu(draggableButton));
        draggableButton.addSelectionListener(this);
        if (ResourceUtil.areEquals(string, this.workbenchManager.getSelectedWBenchId())) {
            this.setDragabbleXY(draggableButton, this.popupPoint);
            draggableButton.storeXYInfo();
        }
        draggableButton.setWorkbenchId(string);
        this.setDraggableTarget(draggableButton);
        if (!draggableButton.isExecutable()) {
            if (draggableButton.isUserEnable()) {
                this.enableList.add(draggableButton);
            }
            this.commMap.put(draggableButton, commStyleInfo);
        }
        this.addButtonInfoToButtonSet(draggableButton);
        this.selectedList.add(draggableButton);
        this.workBenchList.add(draggableButton.getWorkbenchId());
        draggableButton.setButtonPasted(true);
        this.deleteExistingButton(draggableButton);
        this.modifylink(draggableButton, false);
        return draggableButton;
    }

    private DescContainer getCopyDesc(DescContainer descContainer, String string, String string2) {
        DescContainer descContainer2 = new DescContainer();
        descContainer2.setDescName(descContainer.getDescName());
        PARAS pARAS = descContainer.getPARAS();
        String string3 = "name";
        PARAS pARAS2 = new PARAS();
        if (null != pARAS) {
            for (XmlObject xmlObject : pARAS.getPARA()) {
                PARA pARA;
                if (null != xmlObject && null != ((PARA)xmlObject).getName() && ResourceUtil.areEquals(((PARA)xmlObject).getName(), string3)) {
                    pARA = new PARA();
                    pARA.setName("name");
                    String string4 = string;
                    string4 = null == string4 ? "" : string4;
                    int n = this.getAvailableCopyCount(string4, string2);
                    if (n != 0) {
                        string4 = string4 + '(' + n + ')';
                    }
                    pARA.setValue(string4);
                    pARAS2.addPARA(pARA);
                    continue;
                }
                pARA = new PARA();
                pARA.setName(((PARA)xmlObject).getName());
                pARA.setValue(((PARA)xmlObject).getValue());
                pARAS2.addPARA(pARA);
            }
        }
        descContainer2.setPARAS(pARAS2);
        for (XmlObject xmlObject : descContainer.getDescContainer()) {
            descContainer2.addDescContainer((DescContainer)xmlObject);
        }
        return descContainer2;
    }

    public void arrangeIconByName(String string) {
        if (string == null || !ResourceUtil.areEquals(this.workbenchManager.getSelectedWBenchId(), string)) {
            return;
        }
        ArrayList<WelcomeTextButton> arrayList = this.workbenchManager.getWPButtons(string);
        if (arrayList.isEmpty()) {
            return;
        }
        List<WelcomeTextButton> list = this.getVisibleItems(arrayList);
        Collections.sort(list, DraggableButton.NAME_ORDER);
        int n = list.size() > 100 ? 100 : list.size();
        this.m_buttonArray.clear();
        DraggableButton draggableButton = null;
        for (int i = 0; i < n; ++i) {
            draggableButton = (DraggableButton)list.get(i);
            draggableButton.setXIndex(-1);
            draggableButton.setYIndex(-1);
            this.m_buttonArray.add(draggableButton);
        }
        this.foregroundPanel.removeAll();
        this.refreshDraggableLayoutPanel(this.m_buttonArray);
    }

    private void sortBySavedOrder() {
        ArrayList<WelcomeTextButton> arrayList = this.workbenchManager.getSelectedWPButtons();
        List<WelcomeTextButton> list = this.getVisibleItems(arrayList);
        int n = list.size() > 100 ? 100 : list.size();
        Iterator<WelcomeTextButton> iterator = list.iterator();
        this.m_buttonArray.clear();
        boolean bl = iterator.hasNext();
        for (int i = 0; bl && i < n; ++i) {
            this.m_buttonArray.add((DraggableButton)iterator.next());
            bl = iterator.hasNext();
        }
        this.foregroundPanel.removeAll();
        this.refreshDraggableLayoutPanel(this.m_buttonArray);
    }

    JPopupMenu getButtonPopupMenu(final WelcomeTextButton welcomeTextButton) {
        final JPopupMenu jPopupMenu = new JPopupMenu(){

            @Override
            public void setVisible(boolean bl) {
                if (!WelcomePage.this.isSelected()) {
                    logger.trace("WelcomePage is not visibile");
                    return;
                }
                super.setVisible(bl);
            }
        };
        final JMenuItem jMenuItem = new JMenuItem(res.getString("Modify_Link"));
        jMenuItem.setName("WelcomePage_ModifyLink_MenuItem");
        jMenuItem.setMnemonic('M');
        if (welcomeTextButton.isExecutable()) {
            if (IWBLauncherFactory.isExtensionExist()) {
                jMenuItem.setEnabled(true);
            } else {
                jMenuItem.setEnabled(false);
            }
        } else {
            jMenuItem.setEnabled(true);
        }
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    WelcomePage.this.showModifyLink(null, new WelcomeButtonInfo(welcomeTextButton));
                }
                catch (ButtonInfoException buttonInfoException) {
                    logger.trace(buttonInfoException);
                }
            }
        });
        final JMenuItem jMenuItem2 = new JMenuItem(res.getString("Remove_Link"));
        jMenuItem2.setName("WelcomePage_RemoveLink_MenuItem");
        jMenuItem2.setMnemonic('R');
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    WelcomePage.this.showRemoveLink(null, new WelcomeButtonInfo(welcomeTextButton));
                }
                catch (ButtonInfoException buttonInfoException) {
                    logger.trace(buttonInfoException);
                }
            }
        });
        jMenuItem2.setEnabled(welcomeTextButton.isRemovable() || welcomeTextButton.isExecutable());
        jPopupMenu.add(jMenuItem);
        jPopupMenu.add(jMenuItem2);
        final JMenuItem jMenuItem3 = new JMenuItem(res.getString("Copy_Link"));
        jMenuItem3.setName("WelcomePage_CopyLink_MenuItem");
        jMenuItem3.setMnemonic('C');
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WelcomePage.this.clipboard.copyButton((DraggableButton)welcomeTextButton);
            }
        });
        jMenuItem3.setEnabled(true);
        final JMenuItem jMenuItem4 = new JMenuItem(res.getString("Cut_Link"));
        jMenuItem4.setName("WelcomePage_CopyLink_MenuItem");
        jMenuItem4.setMnemonic('T');
        jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WelcomePage.this.clipboard.cutButton((DraggableButton)welcomeTextButton);
            }
        });
        jMenuItem4.setEnabled(true);
        if (ConfigUtilities.isDraggableLayout()) {
            jPopupMenu.add(new JSeparator());
            jPopupMenu.add(jMenuItem4);
            jPopupMenu.add(jMenuItem3);
        }
        jPopupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                jMenuItem.setVisible(WelcomeManager.popupvisibilemap.get((Object)WelcomeManager.WBpopupMenuItems.ModifyLink));
                jMenuItem2.setVisible(WelcomeManager.popupvisibilemap.get((Object)WelcomeManager.WBpopupMenuItems.RemoveLink));
                jMenuItem4.setVisible(WelcomeManager.popupvisibilemap.get((Object)WelcomeManager.WBpopupMenuItems.CutLink));
                jMenuItem3.setVisible(WelcomeManager.popupvisibilemap.get((Object)WelcomeManager.WBpopupMenuItems.CopyLink));
                WelcomePage.this.validateMenuSeparators(jPopupMenu);
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }
        });
        this.validateMenuSeparators(jPopupMenu);
        return jPopupMenu;
    }

    protected void validateMenuSeparators(JPopupMenu jPopupMenu) {
        int n;
        Component[] componentArray = jPopupMenu.getComponents();
        boolean bl = true;
        Component component = null;
        for (n = 0; n < componentArray.length; ++n) {
            component = componentArray[n];
            if (component instanceof JSeparator) {
                if (bl) {
                    component.setVisible(false);
                } else {
                    component.setVisible(true);
                }
                bl = true;
                continue;
            }
            if (!(component instanceof JMenu) && !(component instanceof JMenuItem) || !component.isVisible()) continue;
            bl = false;
        }
        for (n = componentArray.length - 1; n > 0; --n) {
            component = componentArray[n];
            if (component instanceof JSeparator) {
                component.setVisible(false);
                continue;
            }
            if (component.isVisible()) break;
        }
    }

    private void modifylinkDialog(WelcomeButtonInfo welcomeButtonInfo, Window window, String string) {
        Object object;
        WelcomeTextButton welcomeTextButton = null;
        boolean bl = false;
        WorkbenchCombo workbenchCombo = null;
        WorkbenchButton workbenchButton = null;
        if (ConfigUtilities.isDraggableLayout()) {
            workbenchButton = this.workbenchManager.getSelectedWBench();
        }
        List<WelcomeTextButton> list = this.getLinkDlgEnableList(workbenchButton);
        WelcomeTextButton welcomeTextButton2 = welcomeButtonInfo.getButton();
        WorkbenchCombo[] workbenchComboArray = this.getWorkbenchCombo(welcomeTextButton2);
        if (welcomeTextButton2.isExecutable()) {
            object = WelcomeButtonInfo.createClone(welcomeButtonInfo);
            this.getIWBExtension().modifyButton((ButtonInfo)object);
            if (!((ButtonInfo)object).isButtonModified()) {
                return;
            }
            WelcomeButtonInfo.copyButtonInfo((WelcomeButtonInfo)object, welcomeButtonInfo);
            welcomeTextButton = welcomeButtonInfo.getButton();
            this.modifylink(welcomeTextButton, true, welcomeButtonInfo.isIconModified());
            bl = welcomeButtonInfo.isButtonModified();
            String string2 = welcomeButtonInfo.getModifiedWBId();
            if (ConfigUtilities.isDraggableLayout()) {
                for (WorkbenchCombo workbenchCombo2 : workbenchComboArray) {
                    if (!ResourceUtil.areEquals(workbenchCombo2.getId(), string2)) continue;
                    workbenchCombo = workbenchCombo2;
                    break;
                }
            }
        } else {
            object = new WelcomeButtonModifyDialog(welcomeTextButton2, window, string, workbenchComboArray);
            ((Component)object).setName("WelcomePage_modifyLinkDlg");
            ((Dialog)object).setVisible(true);
            welcomeTextButton = ((ModifyLinkDialog)object).getModifiedButton();
            this.modifylink(welcomeTextButton, true, ((ModifyLinkDialog)object).isIconModified());
            this.saveWelcomeButtonInfo(null);
            bl = ((ModifyLinkDialog)object).isButtonModified();
            workbenchCombo = ((WelcomeButtonModifyDialog)object).modifiedWorkbench();
        }
        boolean bl2 = list.contains(welcomeTextButton);
        boolean bl3 = false;
        if ((bl || null != workbenchCombo) && ConfigUtilities.isDraggableLayout()) {
            String string2;
            this.clearClipboardOnUpdation(welcomeTextButton2);
            if (null != workbenchCombo) {
                bl3 = this.moveButtonDesc(this.workbenchManager.getSelectedWBench(), welcomeTextButton2, workbenchCombo);
            } else {
                welcomeTextButton2.fireClickAction(false);
            }
            if (bl3 || bl) {
                this.workbenchManager.fireWelcomeButtonEvent(welcomeTextButton, 1);
            }
            String string3 = ((DraggableButton)welcomeTextButton2).getWorkbenchId();
            if (bl2 && null != string3 && null != workbenchButton && null != this.treeDialog && ResourceUtil.areEquals(string3, string2 = workbenchButton.getWorkbenchId())) {
                this.treeDialog.refreshDialog(list);
            }
        } else if (bl2 && bl && !ConfigUtilities.isDraggableLayout() && null != this.treeDialog) {
            this.treeDialog.refreshDialog(list);
        }
    }

    private boolean moveButtonDesc(WelcomeTextButton welcomeTextButton, WelcomeTextButton welcomeTextButton2, WorkbenchCombo workbenchCombo) {
        boolean bl = false;
        if (null == welcomeTextButton) {
            return bl;
        }
        WorkbenchButton workbenchButton = null;
        WorkbenchButton workbenchButton2 = (WorkbenchButton)welcomeTextButton;
        DraggableButton draggableButton = (DraggableButton)welcomeTextButton2;
        try {
            workbenchButton = workbenchCombo.getButton();
            boolean bl2 = this.cutPaste(new WelcomeButtonInfo(draggableButton), new WorkbenchInfo(workbenchButton), true);
            if (!bl2) {
                this.revertWorkbench(draggableButton, workbenchButton2.getWorkbenchId());
                return false;
            }
            if (!workbenchButton.isSelected()) {
                workbenchButton2.forceClick();
            }
            bl = true;
        }
        catch (ButtonInfoException buttonInfoException) {
            this.revertWorkbench(draggableButton, workbenchButton2.getWorkbenchId());
            if (buttonInfoException.getMessage().indexOf("No enough space in workbench") != -1) {
                String string = MessageFormat.format(res.getString("Cannot_button_move"), workbenchButton.getButtonName());
                OptionPane.showLineWrapOptionDialog(FrameworkUtilities.getMainFrame(), string, 0);
            } else {
                this.moveButtonDescException(draggableButton, workbenchButton2.getWorkbenchId(), buttonInfoException);
            }
        }
        catch (Exception exception) {
            this.moveButtonDescException(draggableButton, workbenchButton2.getWorkbenchId(), exception);
        }
        return bl;
    }

    private void moveButtonDescException(DraggableButton draggableButton, String string, Exception exception) {
        this.revertWorkbench(draggableButton, string);
        String string2 = res.getString("Error_button_move");
        OptionPane.showLineWrapOptionDialog(FrameworkUtilities.getMainFrame(), string2, 0);
        logger.trace(exception);
    }

    private void revertWorkbench(DraggableButton draggableButton, String string) {
        draggableButton.setWorkbenchId(string);
        this.modifylink(draggableButton, true);
    }

    WorkbenchCombo[] getWorkbenchCombo(WelcomeTextButton welcomeTextButton) {
        if (!ConfigUtilities.isDraggableLayout()) {
            return null;
        }
        ArrayList<WorkbenchInfo> arrayList = null;
        arrayList = WelcomeManager.isShowAddWBLinkMenuItem() ? this.workbenchManager.getAllWorkbenches() : this.workbenchManager.getVisibleWorkbenches();
        WorkbenchCombo[] workbenchComboArray = new WorkbenchCombo[arrayList.size()];
        int n = 0;
        boolean bl = false;
        for (WorkbenchInfo workbenchInfo : arrayList) {
            bl = this.isButtonSelected(welcomeTextButton, workbenchInfo);
            workbenchComboArray[n++] = new WorkbenchCombo(workbenchInfo.getButton(), bl);
        }
        return workbenchComboArray;
    }

    private boolean isButtonSelected(WelcomeTextButton welcomeTextButton, WorkbenchInfo workbenchInfo) {
        WorkbenchButton workbenchButton = this.workbenchManager.getSelectedWBench();
        String string = null;
        boolean bl = false;
        if (null != welcomeTextButton && null != workbenchButton) {
            if (welcomeTextButton instanceof DraggableButton) {
                string = ((DraggableButton)welcomeTextButton).getWorkbenchId();
            } else if (welcomeTextButton instanceof WorkbenchButton) {
                string = ((WorkbenchButton)welcomeTextButton).getWorkbenchId();
            }
            if (null != string && string.equals(workbenchInfo.getId()) && workbenchButton.getFullName().equals(workbenchInfo.getFullName())) {
                bl = true;
            }
        }
        return bl;
    }

    private void clearClipboardOnUpdation(WelcomeTextButton welcomeTextButton) {
        DraggableButton draggableButton = this.clipboard.getClipboardButton();
        if (null != draggableButton && draggableButton.equals(welcomeTextButton)) {
            this.clipboard.clearClipboard();
        }
    }

    private void removeLink(WelcomeTextButton welcomeTextButton, Window window, boolean bl) {
        DescContainer descContainer;
        AreaDescContainer areaDescContainer;
        Object object;
        int n;
        if (bl && (n = OptionPane.showConfirmDialog(window, object = res.getString("confirm_remove"), res.getString("Confirm"), 0)) != 0) {
            return;
        }
        object = welcomeTextButton.getDescContainer();
        n = 0;
        if (ConfigUtilities.isDraggableLayout()) {
            n = ((DraggableButton)welcomeTextButton).isImported();
        }
        if (welcomeTextButton.isExecutable() && n == 0) {
            this.exeDescContainer.removeDescContainer((DescContainer)object);
        } else {
            welcomeTextButton.setSelected(false);
            this.refreshDialog(welcomeTextButton);
        }
        this.removeButtonInfoFromButtonSet(welcomeTextButton);
        this.selectedList.remove(welcomeTextButton);
        this.enableList.remove(welcomeTextButton);
        if (ConfigUtilities.isDraggableLayout()) {
            this.clearClipboardOnUpdation(welcomeTextButton);
            this.workbenchManager.removeWelcomeButton(welcomeTextButton);
            this.workbenchManager.fireWelcomeButtonEvent(welcomeTextButton, 2);
        }
        this.refreshWelcomePage();
        this.modifylink(welcomeTextButton, false);
        CommStyleInfo commStyleInfo = this.commMap.get(welcomeTextButton);
        if (null != commStyleInfo && null != (areaDescContainer = commStyleInfo.getAreaDescContainer(0)) && null != (descContainer = areaDescContainer.getDescContainer(WELCOME_BUTTON_SETTING_DESC))) {
            descContainer.removeDescContainer(welcomeTextButton.getDescContainer());
            descContainer.updateSubDescsHashMap();
        }
        this.updateInfo(welcomeTextButton);
        this.commMap.remove(welcomeTextButton);
        if (welcomeTextButton instanceof DraggableButton) {
            this.removeDraggingListener(welcomeTextButton);
        }
        welcomeTextButton.setPopupMenu(null);
        welcomeTextButton.removeIconComponent();
        welcomeTextButton.removeImageComponent();
    }

    protected void refreshWelcomePage() {
        this.sortButtons(this.selectedList);
        this.foregroundPanel.removeAll();
        switch (ConfigUtilities.getLayoutType()) {
            case 1: {
                this.refreshFlowLayoutPanel();
                break;
            }
            case 0: {
                this.refreshGridLayoutPanel();
                break;
            }
            default: {
                DraggableButton.resetDuplicates(this.m_buttonArray);
                this.refreshWorkbenchPanel();
                this.refreshDraggableLayoutPanel(this.m_buttonArray);
            }
        }
        this.foregroundPanel.validate();
        this.foregroundPanel.repaint();
        this.getContentPane().validate();
    }

    private void setEnableActionButtons(ArrayList<WelcomeTextButton> arrayList) {
        if (null == arrayList) {
            return;
        }
        ArrayList<WelcomeTextButton> arrayList2 = new ArrayList<WelcomeTextButton>(arrayList);
        for (WelcomeTextButton welcomeTextButton : arrayList2) {
            this.setEnableStatus(welcomeTextButton);
        }
    }

    void updateWelcomePage() {
        if (null == this.selectedList || null == this.foregroundPanel) {
            return;
        }
        this.refreshWelcomePage();
        this.setEnableActionButtons(this.m_buttonArray);
        if (ConfigUtilities.isDraggableLayout()) {
            this.scrollToWorkbench();
        }
        this.treeDialog = null;
    }

    void scrollToWorkbench() {
        if (!ConfigUtilities.isDraggableLayout() || null == this.workbenchManager) {
            return;
        }
        WorkbenchButton workbenchButton = this.workbenchManager.getSelectedWBench();
        if (null != workbenchButton) {
            this.workbenchForePanel.scrollRectToVisible(new Rectangle(workbenchButton.getX(), workbenchButton.getY(), 1, workbenchButton.getPreferredSize().height));
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WelcomePage.this.foregroundPanel.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
            }
        });
    }

    private void createFunctionalLink(WorkbenchButton workbenchButton, Window window, String string) {
        if (this.reachedMaximumButtons(workbenchButton, window)) {
            return;
        }
        if (null != this.enableList) {
            ArrayList<WelcomeTextButton> arrayList = this.getAddedButtons(workbenchButton, string);
            DraggableButton.setMenuOrFuncFlag(false);
            this.addFuncLinksToWelcomePage(workbenchButton, arrayList, window);
        }
    }

    void addMenuLinkToWelcomePage(WorkbenchButton workbenchButton, ArrayList<WelcomeTextButton> arrayList) {
        this.popupPoint = new Point(1, 1);
        DraggableButton.setMenuOrFuncFlag(true);
        this.addFuncLinksToWelcomePage(workbenchButton, arrayList, FrameworkUtilities.getMainFrame());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFuncLinksToWelcomePage(WorkbenchButton workbenchButton, ArrayList<WelcomeTextButton> arrayList, Window window) {
        if (null != arrayList && arrayList.size() > 0 && !this.selectedReachedMaximumButtons(workbenchButton, arrayList.size(), window)) {
            this.foregroundPanel.setCursor(Cursor.getPredefinedCursor(3));
            try {
                Iterator<WelcomeTextButton> iterator = arrayList.iterator();
                WelcomeTextButton welcomeTextButton = null;
                WelcomeTextButton welcomeTextButton2 = null;
                boolean bl = null == workbenchButton ? false : workbenchButton.isSelected();
                boolean bl2 = iterator.hasNext();
                while (bl2) {
                    welcomeTextButton = iterator.next();
                    welcomeTextButton2 = this.getCopyButtonExist(welcomeTextButton.getFullName(), welcomeTextButton.getCategory(), workbenchButton);
                    if (null != welcomeTextButton2) {
                        welcomeTextButton = welcomeTextButton2;
                    }
                    if (null == (welcomeTextButton = ConfigUtilities.isDraggableLayout() ? this.copyPastedButtonFromTree(welcomeTextButton, workbenchButton.getWorkbenchId()) : this.copyPastedButtonFromTree(welcomeTextButton, this.workbenchManager.getSelectedWBench().getWorkbenchId()))) {
                        bl2 = iterator.hasNext();
                        continue;
                    }
                    this.addFunctionalLink(workbenchButton, welcomeTextButton, this.getNextAvailableXY(bl));
                    bl2 = iterator.hasNext();
                }
                this.refreshWelcomePage();
            }
            finally {
                this.foregroundPanel.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    private Point getNextAvailableXY(boolean bl) {
        if (!ConfigUtilities.isDraggableLayout() || !bl) {
            return new Point(0, 0);
        }
        Point point = DraggableButton.getAvailableXY(this.foregroundPanel, this.popupPoint);
        if (this.popupPoint.x + DraggableLayout.getDefaulFixedWidth() < this.foregroundPanel.getX() + this.foregroundPanel.getPreferredSize().width) {
            this.popupPoint.x += DraggableLayout.getDefaulFixedWidth();
            Point point2 = ((DraggableLayout)this.foregroundPanel.getLayout()).getDestIndex(this.popupPoint);
            if (DraggableButton.isPreoccupied(point2, this.foregroundPanel)) {
                this.popupPoint.x -= DraggableLayout.getDefaulFixedWidth();
            }
        }
        return point;
    }

    private void addFunctionalLink(WelcomeTextButton welcomeTextButton, WelcomeTextButton welcomeTextButton2, Point point) {
        welcomeTextButton2.setSerialNo(this.serialNo++);
        if (!this.selectedList.contains(welcomeTextButton2)) {
            this.addButtonInfoToButtonSet(welcomeTextButton2);
            this.selectedList.add(welcomeTextButton2);
        }
        welcomeTextButton2.setSelected(true);
        if (welcomeTextButton2 instanceof DraggableButton) {
            welcomeTextButton2.setSelected(true);
            ((DraggableButton)welcomeTextButton2).initializeButton();
            ((DraggableButton)welcomeTextButton2).setXIndex(point.x);
            ((DraggableButton)welcomeTextButton2).setYIndex(point.y);
            if (null != welcomeTextButton) {
                ((DraggableButton)welcomeTextButton2).setWorkbenchId(((WorkbenchButton)welcomeTextButton).getWorkbenchId());
            }
            this.workbenchManager.addWorkBenchInfo(welcomeTextButton2);
            this.workbenchManager.fireWelcomeButtonEvent(welcomeTextButton2, 0);
            this.workBenchList.add(((DraggableButton)welcomeTextButton2).getWorkbenchId());
        } else {
            welcomeTextButton2.setSelected(true);
            welcomeTextButton2.initializeButton();
        }
        this.refreshDialog(welcomeTextButton2);
        this.setEnableStatus(welcomeTextButton2);
        welcomeTextButton2.fireClickAction(false);
        this.foregroundPanel.add(welcomeTextButton2);
        this.foregroundPanel.doLayout();
        this.updateInfo(welcomeTextButton2);
    }

    private List<WelcomeTextButton> getAllWorkBenchLinkDlgEnableList() {
        ArrayList<WelcomeTextButton> arrayList = new ArrayList<WelcomeTextButton>(this.treeBtnList);
        ArrayList<WelcomeTextButton> arrayList2 = new ArrayList(0);
        arrayList2 = this.getVisibileButtons(arrayList);
        return arrayList2;
    }

    private ArrayList<WelcomeTextButton> getAddedButtons(WorkbenchButton workbenchButton, String string) {
        int n = 0;
        if (ConfigUtilities.isDraggableLayout()) {
            n = 1;
        }
        List<WelcomeTextButton> list = this.getAllWorkBenchLinkDlgEnableList();
        if (null == this.treeDialog || list.size() != this.treeDialog.getButtonCount() || ConfigUtilities.isDraggableLayout() && (null == this.treeDialog.getListedWBid() || !ResourceUtil.areEquals(this.treeDialog.getListedWBid(), workbenchButton.getWorkbenchId()))) {
            this.treeDialog = new AddLinkDialog((Window)FrameworkUtilities.getMainFrame(), list, n, string);
            this.treeDialog.setName("WelcomePage_FunctionLinkDlg");
        } else {
            this.treeDialog.setTitle(string, n);
        }
        this.treeDialog.setVisible(true);
        return this.treeDialog.getSelectedButtons();
    }

    List<WelcomeTextButton> getEnableList(WorkbenchButton workbenchButton) {
        List<Object> list = new ArrayList(0);
        if (ConfigUtilities.isDraggableLayout() && null != workbenchButton) {
            list = this.workbenchManager.getSelectedWBEnableList(this.enableList, workbenchButton.getWorkbenchId());
        } else if (!ConfigUtilities.isDraggableLayout()) {
            list = this.enableList;
        }
        ArrayList<WelcomeTextButton> arrayList = new ArrayList<WelcomeTextButton>(0);
        for (WelcomeTextButton welcomeTextButton : list) {
            try {
                if (welcomeTextButton.isActionButton() && null != welcomeTextButton.getAction() && false == welcomeTextButton.getAction().isActionVisible()) continue;
                arrayList.add(welcomeTextButton);
            }
            catch (Throwable throwable) {
                logger.trace("Iview handled Error in Enabling welcomeButton " + welcomeTextButton.getButtonName(), throwable);
            }
        }
        return arrayList;
    }

    private boolean reachedMaximumButtons(WorkbenchButton workbenchButton, Window window) {
        String string = null;
        if (ConfigUtilities.isDraggableLayout()) {
            string = workbenchButton.getWorkbenchId();
        }
        if (this.reachedMaximumButtons(string, 1)) {
            String string2 = "";
            string2 = ConfigUtilities.isDraggableLayout() ? MessageFormat.format(res.getString("Limit_Exceed_Workbench"), workbenchButton.getButtonName(), 100) : MessageFormat.format(res.getString("Limit_Exceed"), 100);
            OptionPane.showMessageDialog(window, string2);
            return true;
        }
        return false;
    }

    private boolean selectedReachedMaximumButtons(WorkbenchButton workbenchButton, int n, Window window) {
        String string = null;
        if (ConfigUtilities.isDraggableLayout()) {
            string = workbenchButton.getWorkbenchId();
        }
        if (this.reachedMaximumButtons(string, n)) {
            if (null != window) {
                String string2 = "";
                string2 = ConfigUtilities.isDraggableLayout() ? MessageFormat.format(res.getString("Limit_Exceed_Multiple_Workbench"), n, workbenchButton.getButtonName(), 100) : MessageFormat.format(res.getString("Limit_Exceed_Multiple"), n, 100);
                OptionPane.showMessageDialog(window, string2);
            }
            return true;
        }
        return false;
    }

    private boolean reachedMaximumButtons(String string, int n) {
        return ConfigUtilities.isDraggableLayout() && this.workbenchManager.getWPButtons(string).size() + n - 1 >= 100 || false == ConfigUtilities.isDraggableLayout() && this.selectedList.size() + n - 1 >= 100;
    }

    private void setWorkbenchId(String string, WelcomeTextButton welcomeTextButton) {
        if (ConfigUtilities.isDraggableLayout()) {
            if (this.workbenchManager.isValidWBId(string)) {
                ((DraggableButton)welcomeTextButton).setWorkbenchId(string);
            } else {
                ((DraggableButton)welcomeTextButton).setWorkbenchId("_default_iview_workbenches");
            }
        }
    }

    private void setDragabbleXY(WelcomeTextButton welcomeTextButton, Point point) {
        if (ConfigUtilities.isDraggableLayout()) {
            Point point2 = DraggableButton.getAvailableXY(this.foregroundPanel, point);
            ((DraggableButton)welcomeTextButton).setXIndex(point2.x);
            ((DraggableButton)welcomeTextButton).setYIndex(point2.y);
        }
    }

    private void createExeLink(WorkbenchButton workbenchButton, Window window, String string) {
        if (this.reachedMaximumButtons(workbenchButton, window)) {
            return;
        }
        ButtonInfo buttonInfo = this.getIWBExtension().createButton();
        if (null == buttonInfo) {
            return;
        }
        WelcomeTextButton welcomeTextButton = buttonInfo.getButton();
        if (null != welcomeTextButton) {
            welcomeTextButton.addSelectionListener(this);
            String string2 = null;
            if (ConfigUtilities.isDraggableLayout()) {
                string2 = workbenchButton.getWorkbenchId();
            }
            this.addExeToWelcomePage(welcomeTextButton, string2);
        }
    }

    public boolean createButton(ButtonInfo buttonInfo) {
        Object object;
        String string = null;
        if (null == buttonInfo) {
            logger.debug("ButtonInfo is null");
            return false;
        }
        if (buttonInfo instanceof WorkbenchInfo) {
            throw new IllegalArgumentException("ButtonInfo is not a welcome button " + buttonInfo.getId());
        }
        if (ConfigUtilities.isDraggableLayout() && buttonInfo instanceof WelcomeButtonInfo) {
            string = ((WelcomeButtonInfo)buttonInfo).getWorkbenchId();
        }
        if (this.reachedMaximumButtons(string, 1)) {
            logger.debug("WorkbenchId contain Maximium no of welcome buttons");
            return false;
        }
        ArrayList<WorkbenchInfo> arrayList = this.workbenchManager.getAllWorkbenches();
        String string2 = buttonInfo.getFullName();
        WorkbenchCombo workbenchCombo = null;
        WelcomeTextButton welcomeTextButton = buttonInfo.getButton();
        boolean bl = false;
        for (WorkbenchInfo object22 : arrayList) {
            bl = false;
            if (!object22.getId().equals(string)) continue;
            bl = this.isButtonSelected(welcomeTextButton, object22);
            workbenchCombo = new WorkbenchCombo(object22.getButton(), bl);
        }
        if (workbenchCombo == null) {
            if (!(string == null || string.trim().length() == 0)) {
                if (!this.workbenchManager.isValidWBId(string)) {
                    logger.debug("Workbenchid " + string + "  for " + string2 + "welcomeButton is invalid");
                    return false;
                }
            } else {
                object = this.workbenchManager.getDefaultWorkbench();
                string = ((WorkbenchButton)object).getWorkbenchId();
                if (this.reachedMaximumButtons(string, 1)) {
                    logger.debug("WorkbenchId contain Maximium no of welcome buttons");
                    return false;
                }
                workbenchCombo = new WorkbenchCombo((TextButton)object, true);
            }
        }
        object = this.workbenchManager.getAllWelcomeButtons(string);
        Iterator bl2 = ((ArrayList)object).iterator();
        while (bl2.hasNext()) {
            WelcomeButtonInfo welcomeButtonInfo = (WelcomeButtonInfo)bl2.next();
            if (!welcomeButtonInfo.getFullName().equals(string2)) continue;
            logger.debug("Button with same name already exist");
            return false;
        }
        boolean bl3 = false;
        if (null != welcomeTextButton) {
            boolean bl4;
            this.modifylink(welcomeTextButton, true, buttonInfo.isIconModified());
            welcomeTextButton.addSelectionListener(this);
            this.popupPoint = new Point(1, 1);
            this.addExeToWelcomePage(welcomeTextButton, string);
            if (null != workbenchCombo) {
                bl4 = this.moveButtonDesc(this.workbenchManager.getSelectedWBench(), welcomeTextButton, workbenchCombo);
            }
            if (bl4) {
                this.workbenchManager.fireWelcomeButtonEvent(welcomeTextButton, 1);
            }
        }
        return true;
    }

    public boolean modifyButton(ButtonInfo buttonInfo) {
        boolean bl = false;
        if (null == buttonInfo) {
            logger.debug("ButtonInfo is null");
            return false;
        }
        if (buttonInfo instanceof WorkbenchInfo) {
            throw new IllegalArgumentException("ButtonInfo is not a welcome button " + buttonInfo.getId());
        }
        WelcomeButtonInfo welcomeButtonInfo = (WelcomeButtonInfo)buttonInfo;
        ArrayList<WorkbenchInfo> arrayList = this.workbenchManager.getAllWorkbenches();
        ArrayList<WelcomeButtonInfo> arrayList2 = this.workbenchManager.getAllWelcomeButtons(welcomeButtonInfo.getWorkbenchId());
        String string = welcomeButtonInfo.getId();
        for (WelcomeButtonInfo welcomeButtonInfo2 : arrayList2) {
            if (!welcomeButtonInfo2.getId().equals(string)) continue;
            try {
                boolean bl2;
                welcomeButtonInfo2.setFullName(welcomeButtonInfo.getFullName());
                welcomeButtonInfo2.setDescription(welcomeButtonInfo.getActualDescription());
                welcomeButtonInfo2.setCommand(welcomeButtonInfo.getCommand());
                welcomeButtonInfo2.setImagePath(welcomeButtonInfo.getImagePath());
                welcomeButtonInfo2.setExtButtonInfo(welcomeButtonInfo.getExtButtonInfo());
                welcomeButtonInfo2.setMenuID(welcomeButtonInfo.getMenuID());
                WorkbenchCombo workbenchCombo = null;
                WelcomeTextButton welcomeTextButton = welcomeButtonInfo.getButton();
                WelcomeTextButton welcomeTextButton2 = welcomeButtonInfo2.getButton();
                if (welcomeButtonInfo.getModifiedWBId() != null && !welcomeButtonInfo.getModifiedWBId().equals(welcomeButtonInfo2.getWorkbenchId())) {
                    welcomeButtonInfo2.setModifiedWBId(welcomeButtonInfo.getModifiedWBId());
                    bl2 = false;
                    for (WorkbenchInfo workbenchInfo : arrayList) {
                        if (!workbenchInfo.getId().equals(welcomeButtonInfo.getModifiedWBId())) continue;
                        bl2 = this.isButtonSelected(welcomeTextButton, workbenchInfo);
                        workbenchCombo = new WorkbenchCombo(workbenchInfo.getButton(), bl2);
                    }
                }
                this.modifylink(welcomeTextButton2, true, welcomeButtonInfo.isIconModified());
                bl2 = false;
                bl = welcomeButtonInfo.isButtonModified();
                if (!bl && null == workbenchCombo || !ConfigUtilities.isDraggableLayout()) continue;
                if (null != workbenchCombo) {
                    bl2 = this.moveButtonDesc(this.workbenchManager.getSelectedWBench(), welcomeTextButton, workbenchCombo);
                }
                if (bl2 || bl) {
                    this.workbenchManager.fireWelcomeButtonEvent(welcomeTextButton2, 1);
                }
                return true;
            }
            catch (Exception exception) {
                logger.trace("Failed to modify the the buttonInfo" + exception);
                return false;
            }
        }
        return true;
    }

    public void changeIcontoGrey(String string, String string2) {
        if (null == string) {
            logger.trace("Welcome button id is null");
            return;
        }
        ArrayList<WelcomeTextButton> arrayList = this.workbenchManager.getAllWelcomeTextButton(string);
        for (WelcomeTextButton welcomeTextButton : arrayList) {
            welcomeTextButton.setImagePath(string2);
            this.modifylink(welcomeTextButton, true, true);
            welcomeTextButton.refreshButton(true);
            this.workbenchManager.fireWelcomeButtonEvent(welcomeTextButton, 1);
            welcomeTextButton.repaint();
        }
    }

    private void addExeToWelcomePage(WelcomeTextButton welcomeTextButton, String string) {
        if (null != welcomeTextButton) {
            this.addButtonInfoToButtonSet(welcomeTextButton);
            this.selectedList.add(welcomeTextButton);
            if (ConfigUtilities.isDraggableLayout()) {
                this.setDragabbleXY(welcomeTextButton, this.popupPoint);
                this.setWorkbenchId(string, welcomeTextButton);
                this.workbenchManager.addWorkBenchInfo(welcomeTextButton);
                this.workbenchManager.fireWelcomeButtonEvent(welcomeTextButton, 0);
                this.workBenchList.add(((DraggableButton)welcomeTextButton).getWorkbenchId());
            }
            this.refreshWelcomePage();
            this.writeExeCommInfo(welcomeTextButton.getDescContainer());
            welcomeTextButton.addSelectionListener(this);
            welcomeTextButton.fireClickAction(false);
            welcomeTextButton.setPopupMenu(this.getButtonPopupMenu(welcomeTextButton));
        }
    }

    public void modifylink(WelcomeTextButton welcomeTextButton, boolean bl) {
        this.modifylink(welcomeTextButton, bl, false);
    }

    private void modifylink(WelcomeTextButton welcomeTextButton, boolean bl, boolean bl2) {
        if (null != welcomeTextButton) {
            if (bl2) {
                welcomeTextButton.removeIconComponent();
                if (welcomeTextButton instanceof DraggableButton) {
                    ((DraggableButton)welcomeTextButton).initializeButton();
                    this.setDraggableTarget((DraggableButton)welcomeTextButton);
                } else {
                    welcomeTextButton.initializeButton();
                }
            }
            if (bl) {
                welcomeTextButton.refreshButton(true);
            }
            boolean bl3 = false;
            if (ConfigUtilities.isDraggableLayout()) {
                bl3 = ((DraggableButton)welcomeTextButton).isImported();
            }
            if (welcomeTextButton.isExecutable() && !bl3) {
                try {
                    this.writeToUser(this.exeCommstyle);
                }
                catch (IOException iOException) {
                    logger.trace(iOException.getMessage(), iOException);
                }
            } else {
                welcomeTextButton.setNeedCommit(true);
            }
            if (welcomeTextButton.isSingleSelected()) {
                welcomeTextButton.setState(1);
            }
        }
    }

    public boolean preLogoutSaveTask() {
        ArrayList<CommStyleInfo> arrayList = new ArrayList<CommStyleInfo>();
        DraggableButton draggableButton = null;
        Component component = null;
        Iterator iterator = this.commMap.keySet().iterator();
        boolean bl = iterator.hasNext();
        iterator = this.commMap.keySet().iterator();
        while (bl) {
            component = (Component)iterator.next();
            if (component instanceof DraggableButton) {
                draggableButton = (DraggableButton)component;
                CommStyleInfo commStyleInfo = this.commMap.get(draggableButton);
                if (arrayList.contains(commStyleInfo)) {
                    bl = iterator.hasNext();
                    continue;
                }
                boolean bl2 = false;
                if (ConfigUtilities.isDraggableLayout()) {
                    bl2 = draggableButton.isImported();
                }
                if (draggableButton.isExecutable() && !bl2) {
                    bl = iterator.hasNext();
                    continue;
                }
                if (null != commStyleInfo && draggableButton.isNeedCommit()) {
                    logger.trace("Button changed:" + draggableButton.getButtonName() + ' ' + draggableButton.getDescName());
                    arrayList.add(commStyleInfo);
                    if (this.isAllUsersLocation()) {
                        WelcomeManager.writeAllUserCommInfo(commStyleInfo);
                    } else {
                        WelcomeManager.writeCommInfo(commStyleInfo);
                    }
                }
            }
            bl = iterator.hasNext();
        }
        return super.preLogout();
    }

    private void updateInfo(WelcomeTextButton welcomeTextButton) {
        CommStyleInfo commStyleInfo = this.commMap.get(welcomeTextButton);
        if (null != commStyleInfo) {
            if (this.isAllUsersLocation()) {
                WelcomeManager.writeAllUserCommInfo(commStyleInfo);
            } else {
                WelcomeManager.writeCommInfo(commStyleInfo);
            }
        }
    }

    void readWelcomeButtonInfo(CommStyleInfo commStyleInfo, String string) {
        if (null == commStyleInfo) {
            return;
        }
        ArrayList<WelcomeTextButton> arrayList = new ArrayList<WelcomeTextButton>();
        this.createWelcomeTextButton(commStyleInfo, arrayList, false, true);
        for (WelcomeTextButton object2 : arrayList) {
            this.selectedList.add(object2);
        }
        String string2 = commStyleInfo.getRelatFileName();
        CommStyleManager commStyleManager = CommStyleManager.getInstance();
        CommStyleInfo commStyleInfo2 = null;
        if (commStyleInfo.getFileName().indexOf("style/users/") != -1 || commStyleInfo.getFileName().indexOf("style/all users/") != -1) {
            if (null == string) {
                commStyleInfo2 = commStyleManager.getDefaultProductCommonStyleFile(string2);
                commStyleInfo2.setRelatFileName(string2);
            } else {
                Plugin plugin = PluginManager.getInstance().getPlugin(string);
                if (null == plugin) {
                    return;
                }
                commStyleInfo2 = plugin.getIntegrateCommStyleReader().getCommStyleInfo(string2);
            }
        } else {
            commStyleInfo2 = commStyleInfo;
            commStyleInfo = null;
        }
        if (null == commStyleInfo2) {
            return;
        }
        this.createWelcomeTextButtonProduct(commStyleInfo2, commStyleInfo, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createWelcomeTextButton(CommStyleInfo commStyleInfo, List<WelcomeTextButton> list, boolean bl, boolean bl2) {
        DescContainer descContainer = null;
        try {
            if (null != commStyleInfo && 0 >= commStyleInfo.getAreaDescCount()) {
                logger.info("GetAreaDescContainerCount is less than or equal to zero ");
                return;
            }
            WelcomeTextButton.setResourceBundle(commStyleInfo);
            descContainer = commStyleInfo.getAreaDescContainer(0).getDescContainer(WELCOME_BUTTON_SETTING_DESC);
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
        if (null == descContainer) {
            return;
        }
        int n = descContainer.getDescContainerCount();
        DescContainer descContainer2 = null;
        for (int i = 0; i < n; ++i) {
            descContainer2 = descContainer.getDescContainer(i);
            try {
                WelcomeTextButton welcomeTextButton = this.createWelcomeTextButton(descContainer2);
                if (!bl2 ? false == this.validateButton(welcomeTextButton) : false == this.validateDynamicButton(welcomeTextButton)) continue;
                if (this.addButtonAccessories(welcomeTextButton)) {
                    welcomeTextButton.setPopupMenu(this.getButtonPopupMenu(welcomeTextButton));
                    list.add(welcomeTextButton);
                }
                boolean bl3 = false;
                if (ConfigUtilities.isDraggableLayout()) {
                    bl3 = ((DraggableButton)welcomeTextButton).isImported();
                }
                if (bl && !bl3) continue;
                this.commMap.put(welcomeTextButton, commStyleInfo);
                String string = commStyleInfo.getPluginName();
                Object object = this.FILEMAP_LOCK;
                synchronized (object) {
                    if (string != null) {
                        this.fileMap.put(string + '/' + commStyleInfo.getRelatFileName(), welcomeTextButton);
                    } else {
                        this.fileMap.put(commStyleInfo.getRelatFileName(), welcomeTextButton);
                    }
                    continue;
                }
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
            }
        }
    }

    private boolean validateDynamicButton(WelcomeTextButton welcomeTextButton) {
        ArrayList<String> arrayList;
        if (null == welcomeTextButton) {
            return false;
        }
        String string = "_default_iview_workbenches";
        String string2 = welcomeTextButton.getFullName() + welcomeTextButton.getCategory();
        if (welcomeTextButton instanceof DraggableButton && (null == (string = ((DraggableButton)welcomeTextButton).getWorkbenchId()) || string.length() == 0)) {
            string = "_default_iview_workbenches";
        }
        if (null == (arrayList = this.buttonNameSet.get(string)) || arrayList.size() < 1) {
            ArrayList<String> arrayList2 = new ArrayList<String>(10);
            arrayList2.add(string2);
            this.buttonNameSet.put(string, arrayList2);
        } else if (arrayList.contains(string2)) {
            logger.trace("Dynamic button with name " + string2 + " already loaded so removing the old button configuration");
            WelcomeTextButton welcomeTextButton2 = null;
            String string3 = null;
            if (ConfigUtilities.isDraggableLayout()) {
                ArrayList<WelcomeButtonInfo> arrayList3 = this.workbenchManager.getAllWelcomeButtons(string);
                DraggableButton draggableButton = null;
                for (WelcomeButtonInfo welcomeButtonInfo : arrayList3) {
                    string3 = welcomeButtonInfo.getFullName() + welcomeButtonInfo.getCategory();
                    if (!string3.equals(string2)) continue;
                    draggableButton = (DraggableButton)welcomeButtonInfo.getButton();
                    this.selectedList.remove(draggableButton);
                    this.commMap.remove(draggableButton);
                    break;
                }
                if (null != draggableButton) {
                    this.workbenchManager.removeWelcomeButton(draggableButton);
                }
            } else {
                Set<WelcomeTextButton> set = this.getAllLoadedButtons();
                for (WelcomeTextButton welcomeTextButton3 : set) {
                    string3 = welcomeTextButton3.getFullName() + welcomeTextButton3.getCategory();
                    if (!string3.equals(string2)) continue;
                    this.selectedList.remove(welcomeTextButton3);
                    this.commMap.remove(welcomeTextButton3);
                    welcomeTextButton2 = welcomeTextButton3;
                    break;
                }
                set.remove(welcomeTextButton2);
            }
        } else {
            arrayList.add(string2);
        }
        return true;
    }

    private boolean addButtonAccessories(WelcomeTextButton welcomeTextButton) {
        boolean bl = false;
        if (welcomeTextButton.isUserEnable()) {
            this.enableList.add(welcomeTextButton);
            if (welcomeTextButton.isSelected()) {
                bl = true;
            }
        } else if (welcomeTextButton.isSelected()) {
            bl = true;
        } else {
            this.refreshDialog(welcomeTextButton);
        }
        return bl;
    }

    private void setEnableStatus(WelcomeTextButton welcomeTextButton) {
        AuthorityAction authorityAction;
        boolean bl;
        if (null == welcomeTextButton) {
            return;
        }
        if (welcomeTextButton.isExecutable()) {
            welcomeTextButton.setEnabled(true);
            return;
        }
        boolean bl2 = true;
        String string = welcomeTextButton.getCommand();
        CommandManager commandManager = CommandManager.getInstance();
        DescContainer descContainer = commandManager.getCommandDescContainer(string);
        boolean bl3 = bl = null != descContainer;
        if (null != welcomeTextButton.getAction()) {
            welcomeTextButton.setActionButton(true);
        }
        if (bl) {
            bl2 = commandManager.securityInfoCheck(string);
            authorityAction = commandManager.getAction(descContainer, string);
            if (null != authorityAction) {
                if (!bl2 || !authorityAction.isEnabled()) {
                    welcomeTextButton.disableButton();
                    welcomeTextButton.setEnabled(false);
                }
                return;
            }
        }
        try {
            authorityAction = welcomeTextButton.getAction();
            if (!(bl2 && (null == authorityAction || authorityAction.isEnabled() && authorityAction.isActionEnabled()))) {
                welcomeTextButton.setEnabled(false);
            } else if (null == authorityAction) {
                AuthorityView authorityView = commandManager.getAuthorityView(descContainer, string);
                if (!bl2 || null != authorityView && !authorityView.isEnabled(string)) {
                    welcomeTextButton.disableButton();
                    welcomeTextButton.setEnabled(false);
                } else if (null == authorityView) {
                    welcomeTextButton.setEnabled(welcomeTextButton.isEnabled());
                } else {
                    welcomeTextButton.setEnabled(true);
                }
            } else {
                welcomeTextButton.setEnabled(true);
            }
        }
        catch (Throwable throwable) {
            logger.trace("IView Handled Error while updating  Visibilityof WelcomeButton " + welcomeTextButton.getButtonName(), throwable);
        }
    }

    private WelcomeTextButton createWelcomeTextButton(DescContainer descContainer) {
        WelcomeTextButton welcomeTextButton = null;
        String string = descContainer.getParasItemValue("name");
        if (null == string || string.trim().length() == 0) {
            return welcomeTextButton;
        }
        String string2 = descContainer.getParasItemValue("command");
        boolean bl = CommandManager.getInstance().isCommandLicensed(string2);
        if (!bl) {
            return welcomeTextButton;
        }
        if (ConfigUtilities.isDraggableLayout()) {
            String string3 = descContainer.getParasItemValue("workbenchid");
            if (!this.workbenchManager.isValidWBId(string3)) {
                if (null == string3 || string3.trim().length() == 0) {
                    string3 = "_default_iview_workbenches";
                    descContainer.setParasItem("workbenchid", string3, true);
                } else {
                    logger.trace("Workbench id" + string3 + "for " + string + "welcomebutton is invalid");
                    return welcomeTextButton;
                }
            }
            if ((welcomeTextButton = (DraggableButton)DraggableButton.getUIObject(descContainer)).isSelected()) {
                ((DraggableButton)welcomeTextButton).initializeButton();
                welcomeTextButton.addSelectionListener(this);
            }
        } else {
            welcomeTextButton = (WelcomeTextButton)WelcomeTextButton.getUIObject(descContainer);
            if (welcomeTextButton.isSelected()) {
                welcomeTextButton.initializeButton();
                welcomeTextButton.addSelectionListener(this);
            }
        }
        return welcomeTextButton;
    }

    private CommStyleInfo readExeCommInfo() {
        StringBuffer stringBuffer = new StringBuffer(16);
        stringBuffer.append("integrate/").append(SubsystemManager.getInstance().getIntegratePath()).append('/').append("welcomebutton");
        CommStyleInfo commStyleInfo = null;
        commStyleInfo = this.isAllUsersLocation() ? CommStyleManager.getInstance().getAllUsersCommonStyleFile(stringBuffer.toString()) : CommStyleManager.getInstance().getUserCommonStyleFile(stringBuffer.toString());
        return commStyleInfo;
    }

    private void writeExeCommInfo(DescContainer descContainer) {
        if (null == this.exeCommstyle) {
            this.exeCommstyle = new CommStyleInfo();
        }
        if (null == this.areaDesc) {
            this.areaDesc = new AreaDescContainer();
            this.exeCommstyle.addAreaDescContainer(this.areaDesc);
        }
        if (null == this.exeDescContainer) {
            this.exeDescContainer = new DescContainer(WELCOME_BUTTON_SETTING_DESC);
            this.areaDesc.addDescContainer(this.exeDescContainer);
        }
        this.exeDescContainer.addDescContainer(descContainer);
        try {
            this.writeToUser(this.exeCommstyle);
        }
        catch (IOException iOException) {
            logger.trace("Unable to write to user" + iOException);
        }
    }

    void writeToUser(CommStyleInfo commStyleInfo) throws IOException {
        String string = this.buildUserPath() + "integrate/" + SubsystemManager.getInstance().getIntegratePath() + "/welcomebutton.xml";
        this.writeToPath(commStyleInfo, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeToPath(CommStyleInfo commStyleInfo, String string) throws IOException {
        CommStyleParserFactory commStyleParserFactory = CommStyleParserFactory.getInstance();
        IProfileParser iProfileParser = commStyleParserFactory.createProfileParser();
        if (null == commStyleInfo || null == iProfileParser) {
            logger.trace("CommStyleInfo is : " + commStyleInfo + " Profileparser is : " + iProfileParser);
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            commStyleInfo.marshal(byteArrayOutputStream);
            iProfileParser.write(((Object)byteArrayOutputStream).toString(), string);
        }
        finally {
            if (null != byteArrayOutputStream) {
                ((OutputStream)byteArrayOutputStream).close();
            }
        }
    }

    private String buildUserPath() {
        String string = PathManager.getInstance().getUserInfoPath();
        if (null != string && string.length() > 0) {
            return string;
        }
        int n = this.getIWBExtension().getPersistenceLocation();
        switch (n) {
            case 1: {
                return CommStyleManager.getInstance().getAllUsersInfoStyleDir();
            }
        }
        return CommStyleManager.getInstance().getUserDir();
    }

    public void filterWelcomeButton(ArrayList arrayList) {
        logger.trace("Begin filterWelcomeButton, Total modules= " + arrayList);
        if (null == arrayList || arrayList.size() == 0 || !ConfigUtilities.isEnableWelcomePage() || null == this.foregroundPanel) {
            return;
        }
        ArrayList<String> arrayList2 = this.getFilteredCommandsList(arrayList, null);
        int n = arrayList2.size();
        for (String string : arrayList2) {
            this.removeButtonByCommandID(string);
        }
        if (n > 0 && ConfigUtilities.isDraggableLayout()) {
            this.loadWorkBenchInfos(true);
        }
        if (n > 0 && ConfigUtilities.isDraggableLayout() && this.workbenchManager.isFreshLoading()) {
            this.arrangeIconByName(this.workbenchManager.getSelectedWBenchId());
        } else if (n > 0 && ConfigUtilities.isDraggableLayout() && !this.workbenchManager.isFreshLoading()) {
            this.sortBySavedOrder();
        } else if (n > 0) {
            this.refreshWelcomePage();
        }
        if (n > 0) {
            this.scrollToWorkbench();
        }
        logger.trace("End filterWelcomeButton");
    }

    private ArrayList<String> getFilteredCommandsList(ArrayList arrayList, String string) {
        ArrayList<String> arrayList2 = new ArrayList<String>(1);
        HashMap hashMap = CommandManager.getInstance().getModuleToCommandIDMap();
        int n = arrayList.size();
        String string2 = null;
        String string3 = null;
        ArrayList arrayList3 = null;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            string2 = (String)arrayList.get(i);
            arrayList3 = (ArrayList)hashMap.get(string2);
            if (arrayList3 == null) continue;
            n2 = arrayList3.size();
            for (int j = 0; j < n2; ++j) {
                string3 = (String)arrayList3.get(j);
                logger.trace("Remove welcomebuttons by commandID = '" + string3 + "' in module:" + string2);
                arrayList2.add(string3);
                if (null == string || !string.equals(string3)) continue;
                arrayList2 = new ArrayList(1);
                arrayList2.add(string3);
                return arrayList2;
            }
        }
        return arrayList2;
    }

    private boolean isFilteredWelcomeButton(String string) {
        boolean bl = false;
        if (null == this.filteredCommandsTempList) {
            ArrayList<String> arrayList = FrameworkCommandProcessor.getInstance().getFailedModules();
            if (null == arrayList || arrayList.size() == 0 || null == string || string.trim().length() == 0) {
                return bl;
            }
            this.filteredCommandsTempList = this.getFilteredCommandsList(arrayList, null);
        }
        bl = this.filteredCommandsTempList.contains(string);
        return bl;
    }

    private void removeButtonByCommandID(String string) {
        int n;
        String string2 = null;
        ArrayList<WelcomeTextButton> arrayList = new ArrayList<WelcomeTextButton>(1);
        int n2 = this.selectedList.size();
        for (n = 0; n < n2; ++n) {
            try {
                string2 = this.selectedList.get(n).getCommand();
                if (!string.equals(string2)) continue;
                if (ConfigUtilities.isDraggableLayout()) {
                    this.workbenchManager.removeWelcomeButton(this.selectedList.get(n));
                    this.removeButtonInfoFromButtonSet(this.selectedList.get(n));
                }
                arrayList.add(this.selectedList.get(n));
                continue;
            }
            catch (Exception exception) {
                logger.error("Failed to remove button " + this.selectedList.get(n));
            }
        }
        this.selectedList.removeAll(arrayList);
        arrayList = new ArrayList(1);
        n2 = this.enableList.size();
        for (n = 0; n < n2; ++n) {
            try {
                string2 = this.enableList.get(n).getCommand();
                if (!string.equals(string2)) continue;
                arrayList.add(this.enableList.get(n));
                continue;
            }
            catch (Exception exception) {
                logger.error("Failed to remove button " + this.selectedList.get(n));
            }
        }
        this.enableList.removeAll(arrayList);
        n2 = this.treeBtnList.size();
        for (n = 0; n < n2; ++n) {
            try {
                string2 = this.treeBtnList.get(n).getCommand();
                if (!string.equals(string2)) continue;
                arrayList.add(this.treeBtnList.get(n));
                continue;
            }
            catch (Exception exception) {
                logger.error("Failed to remove button " + this.treeBtnList.get(n));
            }
        }
        this.treeBtnList.removeAll(arrayList);
    }

    public void addDraggableButton(DraggableButton draggableButton, int n, int n2) {
        draggableButton.setXIndex(n);
        draggableButton.setYIndex(n2);
        this.setDraggableTarget(draggableButton);
        this.foregroundPanel.add(draggableButton);
        if (draggableButton.isSingleSelected() && this.foregroundPanel.getComponentZOrder(draggableButton) > 0) {
            this.foregroundPanel.setComponentZOrder(draggableButton, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDraggableTarget(DraggableButton draggableButton) {
        DataFlavor dataFlavor = null;
        try {
            dataFlavor = DraggableButton.getDragAndDropPanelDataFlavor();
        }
        catch (ClassNotFoundException classNotFoundException) {
            dataFlavor = null;
        }
        DropTarget dropTarget = new DropTarget(draggableButton, new DraggableButtonDropTargetListener(draggableButton, this, this.foregroundPanel, dataFlavor));
        DraggableButton draggableButton2 = draggableButton;
        synchronized (draggableButton2) {
            draggableButton.setDropTarget(dropTarget);
            for (Component component : draggableButton.getComponents()) {
                component.setDropTarget(dropTarget);
            }
        }
    }

    public Point addDraggableButton(DraggableButton draggableButton) {
        int n = draggableButton.getXIndex();
        int n2 = draggableButton.getYIndex();
        this.addDraggableButton(draggableButton, n, n2);
        return new Point(n, n2);
    }

    private void refreshDialog(WelcomeTextButton welcomeTextButton) {
        if (welcomeTextButton.isUserEnable()) {
            return;
        }
        if (this.enableList.contains(welcomeTextButton)) {
            this.enableList.remove(welcomeTextButton);
        } else {
            this.enableList.add(welcomeTextButton);
        }
    }

    protected void loadWorkBenchInfos(boolean bl) {
        if (null == this.selectedList) {
            return;
        }
        if (bl) {
            this.workbenchManager.removeAllWorkbenchInfos();
        }
        for (WelcomeTextButton welcomeTextButton : this.selectedList) {
            this.workbenchManager.addWorkBenchInfo(welcomeTextButton);
        }
    }

    protected final Set<WelcomeTextButton> getAllLoadedButtons() {
        HashSet<WelcomeTextButton> hashSet = new HashSet<WelcomeTextButton>(1);
        hashSet.clear();
        for (WelcomeTextButton welcomeTextButton : this.selectedList) {
            hashSet.add(welcomeTextButton);
        }
        for (WelcomeTextButton welcomeTextButton : this.enableList) {
            hashSet.add(welcomeTextButton);
        }
        return hashSet;
    }

    public void showAddExecutableLink(Window window, WorkbenchInfo workbenchInfo) throws ButtonInfoException {
        this.showAddExecutableLink(window, workbenchInfo, null);
    }

    public void showAddExecutableLink(Window window, WorkbenchInfo workbenchInfo, String string) throws ButtonInfoException {
        this.addLink(window, workbenchInfo, false, true, string);
    }

    public void addExecutableLink(WorkbenchInfo workbenchInfo, WelcomeButtonInfo welcomeButtonInfo) throws ButtonInfoException {
        this.addLink(workbenchInfo, welcomeButtonInfo, true);
    }

    public void addFunctionalLink(WorkbenchInfo workbenchInfo, WelcomeButtonInfo welcomeButtonInfo) throws ButtonInfoException {
        this.addLink(workbenchInfo, welcomeButtonInfo, false);
    }

    public void showAddFunctionalLink(Window window, WorkbenchInfo workbenchInfo) throws ButtonInfoException {
        this.showAddFunctionalLink(window, workbenchInfo, null);
    }

    public void showAddFunctionalLink(Window window, WorkbenchInfo workbenchInfo, String string) throws ButtonInfoException {
        this.addLink(window, workbenchInfo, false, false, string);
    }

    private void addLink(WorkbenchInfo workbenchInfo, WelcomeButtonInfo welcomeButtonInfo, boolean bl) throws ButtonInfoException {
        boolean bl2 = ConfigUtilities.isDraggableLayout();
        if (!bl2) {
            return;
        }
        WorkbenchButton workbenchButton = this.parseWorkbenchButton(workbenchInfo);
        String string = workbenchButton.getWorkbenchId();
        if (this.reachedMaximumButtons(string, 1)) {
            throw new ButtonInfoException("Cannot add new welcome button.The '" + string + "' reached the maximum limit of " + 100);
        }
        DraggableButton draggableButton = null;
        if (null == welcomeButtonInfo || null == welcomeButtonInfo.getButton()) {
            throw new ButtonInfoException("Provided welcome button is not valid.");
        }
        draggableButton = (DraggableButton)welcomeButtonInfo.getButton();
        ArrayList<WelcomeButtonInfo> arrayList = this.workbenchManager.getAllWelcomeButtons(string);
        for (WelcomeButtonInfo welcomeButtonInfo2 : arrayList) {
            if (!welcomeButtonInfo2.getFullName().equals(draggableButton.getButtonName())) continue;
            throw new ButtonInfoException("Provided welcome button '" + draggableButton.getButtonName() + "Button with same name already exist");
        }
        this.popupPoint = new Point(1, 1);
        if (bl) {
            if (!draggableButton.isExecutable()) {
                throw new ButtonInfoException("Provided welcome button '" + draggableButton.getButtonName() + "' is not an executable link.");
            }
            draggableButton.initializeButton();
            this.addExeToWelcomePage(draggableButton, string);
        } else {
            if (draggableButton.isExecutable()) {
                throw new ButtonInfoException("Provided welcome button '" + draggableButton.getButtonName() + "' is not a functional link.");
            }
            if (draggableButton.isSelected()) {
                throw new ButtonInfoException("Provided welcome button '" + draggableButton.getButtonName() + "' is already added in workbench '" + draggableButton.getWorkbenchId() + "'.");
            }
            if (null == this.enableList || !this.workbenchManager.getSelectedWBEnableList(this.enableList, string).contains(draggableButton)) {
                throw new ButtonInfoException("Provided welcome button '" + draggableButton.getButtonName() + "' does not belongs to '" + string + "' workbench.");
            }
            ArrayList arrayList2 = new ArrayList(1);
            arrayList2.add(draggableButton);
            if (workbenchButton.isSelected()) {
                workbenchButton.forceClick();
            }
            this.addFuncLinksToWelcomePage(workbenchButton, arrayList2, null);
        }
    }

    private void addLink(Window window, WorkbenchInfo workbenchInfo, boolean bl, boolean bl2, String string) throws ButtonInfoException {
        WorkbenchButton workbenchButton = this.parseWorkbenchButton(workbenchInfo);
        if (!bl) {
            if (!workbenchButton.isSelected()) {
                throw new ButtonInfoException("Either Provided work bench or Default work bench is not visible");
            }
            this.popupPoint = new Point(1, 1);
            workbenchButton.processClick();
        }
        if (bl2) {
            this.createExeLink(workbenchButton, null == window ? FrameworkUtilities.getMainFrame() : window, string);
        } else {
            this.createFunctionalLink(workbenchButton, null == window ? FrameworkUtilities.getMainFrame() : window, string);
        }
    }

    private WorkbenchButton parseWorkbenchButton(WorkbenchInfo workbenchInfo) throws ButtonInfoException {
        WorkbenchButton workbenchButton = null;
        if (ConfigUtilities.isDraggableLayout() && (null == workbenchInfo || null == workbenchInfo.getButton())) {
            workbenchButton = this.workbenchManager.getDefaultWorkbench();
        } else if (ConfigUtilities.isDraggableLayout()) {
            workbenchButton = (WorkbenchButton)workbenchInfo.getButton();
        }
        if (ConfigUtilities.isDraggableLayout() && (null == workbenchButton || !workbenchButton.isSelected() && !WelcomeManager.isShowAddWBLinkMenuItem())) {
            throw new ButtonInfoException("Provided workbench button is not valid.or workbench button does not exist");
        }
        return workbenchButton;
    }

    public void showRemoveLink(Window window, WelcomeButtonInfo welcomeButtonInfo) throws ButtonInfoException {
        String string = this.getWelcomButtonException(welcomeButtonInfo);
        if (null != string) {
            throw new ButtonInfoException(string);
        }
        WelcomeTextButton welcomeTextButton = welcomeButtonInfo.getButton();
        if (!welcomeTextButton.isRemovable()) {
            throw new ButtonInfoException("Welcome button '" + welcomeTextButton.getButtonName() + "' with id " + welcomeButtonInfo.getId() + " is not removable.");
        }
        this.removeLink(welcomeTextButton, null == window ? FrameworkUtilities.getMainFrame() : window, true);
    }

    private String getWelcomButtonException(WelcomeButtonInfo welcomeButtonInfo) {
        if (null == welcomeButtonInfo || null == welcomeButtonInfo.getButton()) {
            return "Provided welcome button is not valid";
        }
        WelcomeTextButton welcomeTextButton = welcomeButtonInfo.getButton();
        if (!welcomeTextButton.isSelected()) {
            return "Welcome button '" + welcomeTextButton.getButtonName() + "' with id " + welcomeButtonInfo.getId() + " is not visible";
        }
        if (!welcomeTextButton.isEnabled() || !welcomeTextButton.isVisible()) {
            return "Welcome Button " + welcomeButtonInfo.getButton() + " is not enabled or visible";
        }
        if (ConfigUtilities.isDraggableLayout()) {
            ArrayList<WorkbenchInfo> arrayList = this.workbenchManager.getWorkbenchById(welcomeButtonInfo.getWorkbenchId());
            WorkbenchInfo workbenchInfo = this.getWorkbenchInfo(arrayList);
            if (null == workbenchInfo) {
                return "workbench of " + welcomeButtonInfo.getButton() + " Button does not " + "Exit";
            }
            WorkbenchButton workbenchButton = (WorkbenchButton)workbenchInfo.getButton();
            workbenchButton.processClick();
            welcomeButtonInfo.getButton().fireClickAction(false);
        }
        return null;
    }

    public void showModifyLink(Window window, WelcomeButtonInfo welcomeButtonInfo) throws ButtonInfoException {
        this.showModifyLink(window, welcomeButtonInfo, null);
    }

    public void showModifyLink(Window window, WelcomeButtonInfo welcomeButtonInfo, String string) throws ButtonInfoException {
        String string2 = this.getWelcomButtonException(welcomeButtonInfo);
        if (null != string2) {
            throw new ButtonInfoException(string2);
        }
        this.modifylinkDialog(welcomeButtonInfo, null == window ? FrameworkUtilities.getMainFrame() : window, string);
    }

    private WorkbenchInfo getWorkbenchInfo(ArrayList<WorkbenchInfo> arrayList) {
        WorkbenchInfo workbenchInfo = null;
        for (WorkbenchInfo workbenchInfo2 : arrayList) {
            if (!workbenchInfo2.isSelected()) continue;
            workbenchInfo = workbenchInfo2;
            break;
        }
        return workbenchInfo;
    }

    public void showAddWorkbenchLink(Window window) {
        this.showAddWorkbenchLink(window, null);
    }

    public void showAddWorkbenchLink(Window window, String string) {
        if (ConfigUtilities.isDraggableLayout()) {
            this.workbenchManager.addWorkbenches(null == window ? FrameworkUtilities.getMainFrame() : window, string);
        }
    }

    public void showRemoveWorkbenchLink(Window window, WorkbenchInfo workbenchInfo) throws ButtonInfoException {
        if (ConfigUtilities.isDraggableLayout()) {
            this.workbenchManager.removeWorkBench(workbenchInfo, null == window ? FrameworkUtilities.getMainFrame() : window);
        }
    }

    public void showModifyWorkbenchLink(Window window, WorkbenchInfo workbenchInfo) throws ButtonInfoException {
        this.showModifyWorkbenchLink(window, workbenchInfo, null);
    }

    public void showModifyWorkbenchLink(Window window, WorkbenchInfo workbenchInfo, String string) throws ButtonInfoException {
        if (ConfigUtilities.isDraggableLayout()) {
            this.workbenchManager.modifyWorkBench(workbenchInfo, null == window ? FrameworkUtilities.getMainFrame() : window, string);
        }
    }

    public void cutPaste(WelcomeButtonInfo welcomeButtonInfo, WorkbenchInfo workbenchInfo) throws ButtonInfoException {
        this.cutPaste(welcomeButtonInfo, workbenchInfo, false);
    }

    private boolean cutPaste(WelcomeButtonInfo welcomeButtonInfo, WorkbenchInfo workbenchInfo, boolean bl) throws ButtonInfoException {
        boolean bl2 = ConfigUtilities.isDraggableLayout();
        if (!bl2) {
            return false;
        }
        if (null == welcomeButtonInfo || null == welcomeButtonInfo.getButton()) {
            throw new ButtonInfoException("Provided welcome button is not valid");
        }
        DraggableButton draggableButton = (DraggableButton)welcomeButtonInfo.getButton();
        WorkbenchButton workbenchButton = this.parseWorkbenchButton(workbenchInfo);
        if (!bl && !workbenchButton.isSelected()) {
            throw new ButtonInfoException("Cannot move the button '" + draggableButton.getButtonName() + "' to non visible workbench '" + workbenchButton.getWorkbenchId() + "' ");
        }
        if (!draggableButton.isSelected()) {
            throw new ButtonInfoException("Cannot move the non visible button '" + draggableButton.getButtonName() + "' to the workbench '" + workbenchButton.getWorkbenchId() + "' ");
        }
        boolean bl3 = ResourceUtil.areEquals(draggableButton.getWorkbenchId(), workbenchButton.getWorkbenchId());
        if (bl3 || !this.selectedReachedMaximumButtons(workbenchButton, 1, null)) {
            workbenchButton.processClick();
            this.clipboard.cutButton(draggableButton);
            boolean bl4 = this.pasteButton(null, workbenchButton, false);
            return false != bl4;
        }
        throw new ButtonInfoException("No enough space in workbench '" + workbenchButton.getWorkbenchId() + "' to paste a new button");
    }

    protected void changeBackGroundImage(ImageIcon imageIcon) {
        this.changeBackGroundImage(imageIcon, this.mainPanel, this.foregroundPanel, 1.0f);
    }

    private void changeBackGroundImage(final ImageIcon imageIcon, JPanel jPanel, JPanel jPanel2, final float f) {
        jPanel.removeAll();
        jPanel.add((Component)jPanel2, gbConst);
        JLabel jLabel = new JLabel(){

            @Override
            public void paint(Graphics graphics) {
                if (null != imageIcon) {
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    Composite composite = graphics2D.getComposite();
                    graphics2D.setComposite(AlphaComposite.getInstance(3, f));
                    Image image = imageIcon.getImage();
                    graphics2D.drawImage(image, this.getX(), this.getY(), this.getWidth(), this.getHeight(), this);
                    graphics2D.setComposite(composite);
                }
            }
        };
        jLabel.setPreferredSize(new Dimension(1, 1));
        jLabel.setMinimumSize(new Dimension(1, 1));
        jLabel.setVerticalAlignment(1);
        jLabel.setHorizontalAlignment(10);
        jPanel.add((Component)jLabel, gbConst);
        jPanel.updateUI();
    }

    protected void resetToDefaultBackground() {
        this.changeBackGroundImage(ConfigUtilities.getWelcomeImage());
    }

    public void showMenuAddLink(String string, AuthorityAction authorityAction, String string2) {
        boolean bl = ConfigUtilities.isDraggableLayout();
        if (!bl) {
            return;
        }
        if (null == this.workbenchManager.getSelectedWBench()) {
            return;
        }
        MenuAddLinkDialog.addMenuLinkToWB(string, authorityAction, string2);
    }

    public WelcomeTextButton getAvailableSameCommandButton(String string, AuthorityAction authorityAction, String string2) {
        if (null == this.workbenchManager) {
            return null;
        }
        List<WelcomeTextButton> list = null;
        List<WelcomeTextButton> list2 = this.getAllWorkBenchLinkDlgEnableList();
        list = this.getSameCommandButtons(list2, string, authorityAction);
        if (!list.isEmpty()) {
            if (null == string2 || string2.trim().length() == 0) {
                return list.get(0);
            }
            ArrayList<WelcomeTextButton> arrayList = new ArrayList<WelcomeTextButton>(0);
            String string3 = "";
            for (WelcomeTextButton welcomeTextButton : list) {
                string3 = welcomeTextButton.getMenuID();
                if (null == string3) {
                    arrayList.add(welcomeTextButton);
                    continue;
                }
                if (!string2.equals(string3)) continue;
                return welcomeTextButton;
            }
            if (!arrayList.isEmpty()) {
                return (WelcomeTextButton)arrayList.get(0);
            }
        }
        return null;
    }

    public WelcomeTextButton getWelcomeTextButtonObject(String string, AuthorityAction authorityAction, String string2) {
        if (null == this.workbenchManager) {
            return null;
        }
        if (null == string) {
            string = "";
        }
        WelcomeTextButton welcomeTextButton = null;
        welcomeTextButton = this.searchForButtonInTheList(this.treeBtnList, string, authorityAction, string2);
        if (welcomeTextButton != null) {
            return welcomeTextButton;
        }
        welcomeTextButton = this.searchForButtonInTheList(this.selectedList, string, authorityAction, string2);
        return welcomeTextButton;
    }

    private WelcomeTextButton searchForButtonInTheList(List<WelcomeTextButton> list, String string, AuthorityAction authorityAction, String string2) {
        WelcomeTextButton welcomeTextButton = null;
        for (WelcomeTextButton welcomeTextButton2 : list) {
            try {
                String string3;
                String string4;
                if (welcomeTextButton2.isActionButton() && null != welcomeTextButton2.getAction() && false == welcomeTextButton2.getAction().isActionVisible()) continue;
                String string5 = welcomeTextButton2.getCommand();
                string5 = null == string5 ? "" : string5.trim();
                AuthorityAction authorityAction2 = welcomeTextButton2.getAction();
                String string6 = null == authorityAction2 ? "" : authorityAction2.getClass().toString();
                String string7 = string4 = null == authorityAction ? "" : authorityAction.getClass().toString();
                if (!string5.equals(string) || !string6.equals(string4)) continue;
                if (null == welcomeTextButton) {
                    welcomeTextButton = welcomeTextButton2;
                    if (null == string2 || string2.trim().length() == 0) break;
                }
                if (null == (string3 = welcomeTextButton2.getMenuID()) || !string2.equals(string3)) continue;
                welcomeTextButton = welcomeTextButton2;
                break;
            }
            catch (Throwable throwable) {
                logger.trace("IView Handled Error in welcomepage  " + welcomeTextButton2.getButtonName() + "Full name " + welcomeTextButton2.getFullName());
            }
        }
        return welcomeTextButton;
    }

    public WelcomeTextButton getSameCommandButton(String string, AuthorityAction authorityAction) {
        if (null == this.workbenchManager) {
            return null;
        }
        WorkbenchButton workbenchButton = null;
        List<WelcomeTextButton> list = null;
        List<WelcomeTextButton> list2 = null;
        for (WorkbenchInfo workbenchInfo : this.workbenchManager.getAllWorkbenches()) {
            workbenchButton = (WorkbenchButton)workbenchInfo.getButton();
            list = this.getEnableList(workbenchButton);
            list2 = this.getSameCommandButtons(list, string, authorityAction);
            if (list2.isEmpty()) continue;
            return list2.get(0);
        }
        return null;
    }

    public List<WelcomeTextButton> getCommandVisible(WorkbenchButton workbenchButton, String string, AuthorityAction authorityAction) {
        ArrayList<WelcomeButtonInfo> arrayList = null;
        List<WelcomeTextButton> list = null;
        arrayList = this.workbenchManager.getWelcomeButtons(workbenchButton.getWorkbenchId(), true);
        list = this.getSameCommandButtonsInfo(arrayList, string, authorityAction);
        return list;
    }

    List<WelcomeTextButton> getSameCommandButtonsInfo(List<WelcomeButtonInfo> list, String string, AuthorityAction authorityAction) {
        WelcomeTextButton welcomeTextButton = null;
        ArrayList<WelcomeTextButton> arrayList = new ArrayList<WelcomeTextButton>(0);
        for (WelcomeButtonInfo welcomeButtonInfo : list) {
            welcomeTextButton = welcomeButtonInfo.getButton();
            this.addSameButton(arrayList, welcomeTextButton, string, authorityAction);
        }
        return arrayList;
    }

    private void addSameButton(List<WelcomeTextButton> list, WelcomeTextButton welcomeTextButton, String string, AuthorityAction authorityAction) {
        String string2;
        String string3;
        if (null == string) {
            string = "";
        }
        string3 = null == (string3 = welcomeTextButton.getCommand()) ? "" : string3.trim();
        AuthorityAction authorityAction2 = welcomeTextButton.getAction();
        String string4 = null == authorityAction2 ? "" : authorityAction2.getClass().toString();
        String string5 = string2 = null == authorityAction ? "" : authorityAction.getClass().toString();
        if (string3.equals(string) && string4.equals(string2)) {
            list.add(welcomeTextButton);
        }
    }

    List<WelcomeTextButton> getSameCommandButtons(List<WelcomeTextButton> list, String string, AuthorityAction authorityAction) {
        ArrayList<WelcomeTextButton> arrayList = new ArrayList<WelcomeTextButton>(0);
        for (WelcomeTextButton welcomeTextButton : list) {
            this.addSameButton(arrayList, welcomeTextButton, string, authorityAction);
        }
        return arrayList;
    }

    void removeButtonReference(DraggableButton draggableButton) {
        this.enableList.remove(draggableButton);
        this.removeButtonInfoFromButtonSet(draggableButton);
        this.selectedList.remove(draggableButton);
        this.commMap.remove(draggableButton);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WelcomeTextButton importButton(DescContainer descContainer) {
        WelcomeTextButton welcomeTextButton = this.createWelcomeTextButton(descContainer);
        CommStyleInfo commStyleInfo = WorkbenchManager.getImportCommStyle();
        if (null == welcomeTextButton || null == commStyleInfo) {
            return welcomeTextButton;
        }
        this.setEnableStatus(welcomeTextButton);
        this.commMap.put(welcomeTextButton, commStyleInfo);
        Object object = this.FILEMAP_LOCK;
        synchronized (object) {
            if (commStyleInfo.getPluginName() != null) {
                this.fileMap.put(commStyleInfo.getPluginName() + '/' + commStyleInfo.getRelatFileName(), welcomeTextButton);
            } else {
                this.fileMap.put(commStyleInfo.getRelatFileName(), welcomeTextButton);
            }
        }
        boolean bl = this.isFilteredWelcomeButton(welcomeTextButton.getCommand());
        if (!bl && this.addButtonAccessories(welcomeTextButton)) {
            welcomeTextButton.setPopupMenu(this.getButtonPopupMenu(welcomeTextButton));
            this.workbenchManager.addWorkBenchInfo(welcomeTextButton);
            this.addButtonInfoToButtonSet(welcomeTextButton);
            this.selectedList.add(welcomeTextButton);
            if (welcomeTextButton instanceof DraggableButton) {
                this.workBenchList.add(((DraggableButton)welcomeTextButton).getWorkbenchId());
            }
            this.updateInfo(welcomeTextButton);
            welcomeTextButton.refreshButton(true);
        } else if (bl) {
            this.updateInfo(welcomeTextButton);
            welcomeTextButton = null;
        }
        if (null != this.treeDialog) {
            this.treeDialog = null;
        }
        return welcomeTextButton;
    }

    void setMergedSettings(WorkbenchButton workbenchButton, DescContainer descContainer) {
        boolean bl = Boolean.valueOf(descContainer.getParasItemValue("isUserEnable"));
        workbenchButton.setUserEnableStatus(bl);
        this.workbenchManager.resetUserEnableList(workbenchButton);
        boolean bl2 = Boolean.valueOf(descContainer.getParasItemValue("isSelected"));
        workbenchButton.setSelected(bl2);
        if (bl2) {
            workbenchButton.removeIconComponent();
            workbenchButton.initializeButton();
            workbenchButton.addClickListener();
        }
        boolean bl3 = Boolean.valueOf(descContainer.getParasItemValue("isRemovable"));
        workbenchButton.setRemovableStatus(bl3);
    }

    @Override
    public void buttonClicked(Object object) {
        if (object instanceof DraggableButton && this.foregroundPanel.getComponentZOrder((WelcomeTextButton)object) > 0) {
            this.foregroundPanel.setComponentZOrder((WelcomeTextButton)object, 0);
        }
        if (null == this.selectedList) {
            return;
        }
        int n = this.selectedList.size();
        WelcomeTextButton welcomeTextButton = null;
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            welcomeTextButton = this.selectedList.get(i);
            bl = welcomeTextButton.isSingleSelected();
            if (!bl) continue;
            welcomeTextButton.setSingleSelected(false);
            welcomeTextButton.setState(0);
        }
        this.foregroundPanel.updateUI();
    }

    void resetFunctionalDialogButtonVisibility(boolean bl, List<String> list) {
        int n = this.treeBtnList.size();
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = this.treeBtnList.get(i).getDescContainer().getDescName();
            if (!list.contains(string)) continue;
            this.treeBtnList.get(i).setVisible(bl);
        }
    }

    void resetFunctionalDialogButtonEnable(boolean bl, String string) {
        int n = this.treeBtnList.size();
        for (int i = 0; i < n; ++i) {
            if (!string.equals(this.treeBtnList.get(i).getDescContainer().getDescName())) continue;
            this.treeBtnList.get(i).setEnabled(bl);
        }
    }

    void clearFilteredCommandList() {
        this.filteredCommandsTempList = null;
    }

    void showHideWelcomeButton(boolean bl, String string, String string2, WelcomeTextButton welcomeTextButton, List<WelcomeTextButton> list) {
        if (ResourceUtil.areEquals(string2, welcomeTextButton.getDescContainer().getDescName()) && !welcomeTextButton.isVisible() == bl) {
            this.addRemoveWelcomeButton(string, welcomeTextButton, bl);
            list.add(welcomeTextButton);
        }
    }

    void enableDisableWelcomeButton(boolean bl, String string, WelcomeTextButton welcomeTextButton, List<WelcomeTextButton> list) {
        if (ResourceUtil.areEquals(string, welcomeTextButton.getDescContainer().getDescName()) && !welcomeTextButton.isEnabled() == bl) {
            if (bl) {
                welcomeTextButton.enableButton();
                welcomeTextButton.setPopupMenu(this.getButtonPopupMenu(welcomeTextButton));
            } else {
                welcomeTextButton.disableButton();
                welcomeTextButton.setPopupMenu(null);
            }
            welcomeTextButton.setEnabled(bl);
            list.add(welcomeTextButton);
        }
    }

    void addRemoveWelcomeButton(String string, WelcomeTextButton welcomeTextButton, boolean bl) {
        if (bl && null != string) {
            DraggableButton draggableButton = (DraggableButton)welcomeTextButton;
            ArrayList<WelcomeTextButton> arrayList = this.workbenchManager.getVisibleWelcomeTextButton(string);
            if (null != arrayList) {
                Point point = DraggableButton.getAvailableXY(arrayList, new Point(draggableButton.getXIndex(), draggableButton.getYIndex()), this.foregroundPanel);
                draggableButton.setXIndex(point.x);
                draggableButton.setYIndex(point.y);
            }
        }
        welcomeTextButton.setVisible(bl);
        if (null != string && ResourceUtil.areEquals(string, this.workbenchManager.getSelectedWBench().getWorkbenchId())) {
            if (bl) {
                this.foregroundPanel.add(welcomeTextButton);
                this.updateUI();
            } else {
                this.foregroundPanel.remove(welcomeTextButton);
            }
        }
    }

    void setWelcomeButtonVisibility(String string, boolean bl, List<WelcomeTextButton> list) {
        int n = this.m_buttonArray.size();
        WelcomeTextButton welcomeTextButton = null;
        for (int i = 0; i < n; ++i) {
            welcomeTextButton = this.m_buttonArray.get(i);
            this.showHideWelcomeButton(bl, null, string, welcomeTextButton, list);
        }
    }

    void setAllWorkBenchWelcomeButtonVisibility(String string, boolean bl, List<WelcomeTextButton> list) {
        int n = this.m_buttonArray.size();
        WelcomeTextButton welcomeTextButton = null;
        for (int i = 0; i < n; ++i) {
            welcomeTextButton = this.m_buttonArray.get(i);
            this.showHideAllWorkBenchWelcomeButton(bl, null, string, welcomeTextButton, list);
        }
    }

    void showHideAllWorkBenchWelcomeButton(boolean bl, String string, String string2, WelcomeTextButton welcomeTextButton, List<WelcomeTextButton> list) {
        String string3 = this.getWelcomeButtonIDButton(welcomeTextButton);
        if (ResourceUtil.areEquals(string2, string3) && !welcomeTextButton.isVisible() == bl) {
            this.addRemoveWelcomeButton(string, welcomeTextButton, bl);
            list.add(welcomeTextButton);
        }
    }

    void setAllWorkBenchWelcomeButtonEnable(String string, boolean bl, List<WelcomeTextButton> list) {
        int n = this.m_buttonArray.size();
        WelcomeTextButton welcomeTextButton = null;
        for (int i = 0; i < n; ++i) {
            welcomeTextButton = this.m_buttonArray.get(i);
            this.enableDisableAllWorkBenchWelcomeButton(bl, string, welcomeTextButton, list);
        }
    }

    String getWelcomeButtonIDButton(WelcomeTextButton welcomeTextButton) {
        String string;
        String string2 = "";
        PARA pARA = welcomeTextButton.getDescContainer().getParasItem("name");
        if (null != pARA && null != (string = pARA.getValue())) {
            string2 = string;
        }
        return string2;
    }

    void enableDisableAllWorkBenchWelcomeButton(boolean bl, String string, WelcomeTextButton welcomeTextButton, List<WelcomeTextButton> list) {
        String string2 = this.getWelcomeButtonIDButton(welcomeTextButton);
        if (ResourceUtil.areEquals(string, string2) && !welcomeTextButton.isEnabled() == bl) {
            if (bl) {
                welcomeTextButton.enableButton();
                welcomeTextButton.setPopupMenu(this.getButtonPopupMenu(welcomeTextButton));
            } else {
                welcomeTextButton.disableButton();
                welcomeTextButton.setPopupMenu(null);
            }
            welcomeTextButton.setEnabled(bl);
            list.add(welcomeTextButton);
        }
    }

    void setWelcomeButtonEnable(String string, boolean bl, List<WelcomeTextButton> list) {
        int n = this.m_buttonArray.size();
        WelcomeTextButton welcomeTextButton = null;
        for (int i = 0; i < n; ++i) {
            welcomeTextButton = this.m_buttonArray.get(i);
            this.enableDisableWelcomeButton(bl, string, welcomeTextButton, list);
        }
    }

    private int getAvailableCopyCount(String string, String string2) {
        int n;
        List<WelcomeTextButton> list = null;
        ArrayList<Integer> arrayList = new ArrayList<Integer>(0);
        list = ConfigUtilities.isDraggableLayout() ? this.workbenchManager.getWPButtons(string2) : this.selectedList;
        Integer n2 = 0;
        Integer n3 = 0;
        String string3 = this.regexCheck(string);
        String string4 = string3 + "\\(+" + "[0-9]*" + "\\)+";
        String string5 = "";
        int n4 = list.size();
        for (n = 0; n < n4; ++n) {
            string5 = list.get(n).getFullName();
            if (string.equals(string5)) {
                n3 = n2 = Integer.valueOf(Math.max(n2, 1));
                arrayList.add(0);
                continue;
            }
            if (!string5.matches(string4)) continue;
            String string6 = string5.substring(string5.lastIndexOf("(") + 1, string5.lastIndexOf(")"));
            n2 = Math.max(Integer.parseInt(string6) + 1, n2);
            arrayList.add(Integer.parseInt(string6));
            n3 = n2;
        }
        n = arrayList.size();
        if (n == n3) {
            return n3;
        }
        int n5 = 0;
        Collections.sort(arrayList);
        if ((Integer)arrayList.get(0) != n5) {
            return n5;
        }
        for (int i = 0; i < n - 1; ++i) {
            if ((Integer)arrayList.get(i) + 1 == (Integer)arrayList.get(i + 1)) continue;
            n5 = (Integer)arrayList.get(i) + 1;
            break;
        }
        return n5;
    }

    private WelcomeTextButton getCopyButtonExist(String string, String string2, WorkbenchButton workbenchButton) {
        List<WelcomeTextButton> list = null;
        list = ConfigUtilities.isDraggableLayout() ? this.workbenchManager.getAllWelcomePageTextButton(workbenchButton.getWorkbenchId(), string) : this.selectedList;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            if (!list.get(i).getFullName().equals(string) || !ResourceUtil.areEquals(list.get(i).getCategory(), string2)) continue;
            return list.get(i);
        }
        return null;
    }

    public boolean isButtonExist(String string) {
        return this.isButtonExistWorkbench(string, this.workbenchManager.getSelectedWBenchId());
    }

    public boolean isButtonExistWorkbench(String string, String string2) {
        List<WelcomeTextButton> list = null;
        list = ConfigUtilities.isDraggableLayout() ? this.workbenchManager.getWPButtons(string2) : this.selectedList;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            if (!list.get(i).getFullName().equals(string)) continue;
            return true;
        }
        return false;
    }

    private void populateTreeBtnList() {
        int n;
        CommStyleInfo commStyleInfo;
        List<Plugin> list = PluginManager.getInstance().getStartupPluginList();
        int n2 = 0;
        CommStyleInfo commStyleInfo2 = null;
        CommStyleManager commStyleManager = CommStyleManager.getInstance();
        String[] stringArray = FrameworkCommandProcessor.getInstance().getFilteredExtPaths(Main.extPaths);
        if (stringArray != null) {
            n2 = stringArray.length;
            String string = null;
            commStyleInfo = null;
            for (n = 0; n < n2; ++n) {
                string = "conf/" + stringArray[n] + "/welcomebutton";
                commStyleInfo = WelcomeManager.getWelcomeButtonInfo(string);
                if (null == commStyleInfo) {
                    logger.trace("CommStyleInfo not available in map : " + string);
                    continue;
                }
                commStyleInfo2 = commStyleInfo;
                if (commStyleInfo.getFileName().indexOf("style/users/") != -1 || commStyleInfo.getFileName().indexOf("style/all users/") != -1) {
                    commStyleInfo = commStyleManager.getDefaultProductCommonStyleFileOfExtPath(string, stringArray[n]);
                    if (null == commStyleInfo) continue;
                    commStyleInfo.setRelatFileName(string);
                }
                this.createWelcomeTextButtonProduct(commStyleInfo, commStyleInfo2, false);
            }
        }
        int n3 = 0;
        if (list != null && 0 < list.size()) {
            commStyleInfo = null;
            n3 = list.size();
            for (n = 0; n < n3; ++n) {
                commStyleInfo = WelcomeManager.getWelcomeButtonInfo(list.get(n).getPluginName() + "/user");
                if (null == commStyleInfo && null == (commStyleInfo = WelcomeManager.getWelcomeButtonInfo(list.get(n).getPluginName() + "/alluser"))) {
                    logger.trace("CommStyleInfo not available in map : " + list.get(n).getId());
                    continue;
                }
                commStyleInfo2 = commStyleInfo;
                if ((commStyleInfo.getFileName().indexOf("style/users/") != -1 || commStyleInfo.getFileName().indexOf("style/all users/") != -1) && null == (commStyleInfo = list.get(n).getIntegrateCommStyleReader().getCommStyleInfo("welcomebutton"))) continue;
                this.createWelcomeTextButtonProduct(commStyleInfo, commStyleInfo2, false);
            }
        }
    }

    private void createWelcomeTextButtonProduct(CommStyleInfo commStyleInfo, CommStyleInfo commStyleInfo2, boolean bl) {
        DescContainer descContainer = null;
        try {
            if (null != commStyleInfo && 0 >= commStyleInfo.getAreaDescCount()) {
                logger.info("GetAreaDescContainerCount is less than or equal to zero ");
                return;
            }
            WelcomeTextButton.setResourceBundle(commStyleInfo);
            descContainer = commStyleInfo.getAreaDescContainer(0).getDescContainer(WELCOME_BUTTON_SETTING_DESC);
        }
        catch (Exception exception) {
            logger.warn(exception.getMessage(), exception);
        }
        if (null == descContainer) {
            return;
        }
        int n = descContainer.getDescContainerCount();
        DescContainer descContainer2 = null;
        for (int i = 0; i < n; ++i) {
            descContainer2 = descContainer.getDescContainer(i);
            try {
                WelcomeTextButton welcomeTextButton = this.createLinkDlgWelcomeTextButton(descContainer2);
                if (null == welcomeTextButton) continue;
                if (welcomeTextButton.isExecutable()) {
                    logger.trace("buttontype is executable link, so it will not add to dialog");
                    continue;
                }
                if (welcomeTextButton.isButtonLoaded(this.treeButtonNameSet)) {
                    if (!bl) continue;
                    String string = welcomeTextButton.getFullName() + welcomeTextButton.getCategory();
                    this.removeButtonFromTreeBtnList(string);
                }
                if (null == commStyleInfo2) {
                    this.commMap.put(welcomeTextButton, commStyleInfo);
                } else {
                    this.commMap.put(welcomeTextButton, commStyleInfo2);
                }
                this.treeBtnList.add(welcomeTextButton);
                continue;
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
            }
        }
    }

    private void removeButtonFromTreeBtnList(String string) {
        for (WelcomeTextButton welcomeTextButton : new ArrayList<WelcomeTextButton>(this.treeBtnList)) {
            String string2 = welcomeTextButton.getFullName() + welcomeTextButton.getCategory();
            if (!string.equals(string2)) continue;
            logger.error("remove operation:" + welcomeTextButton.getName());
            this.treeBtnList.remove(welcomeTextButton);
            this.commMap.remove(welcomeTextButton);
            break;
        }
    }

    private int getNameLength(DescContainer descContainer) {
        PARAS pARAS = descContainer.getPARAS();
        if (null != pARAS) {
            for (PARA pARA : pARAS.getPARA()) {
                if (null == pARA || null == pARA.getName() || !"name".equals(pARA.getName())) continue;
                return pARA.getValue().length();
            }
        }
        return 0;
    }

    private WelcomeTextButton copyPastedButtonFromTree(WelcomeTextButton welcomeTextButton, String string) {
        Object object;
        Object object2;
        DraggableButton draggableButton = null;
        DescContainer descContainer = welcomeTextButton.getDescContainer();
        if (null == descContainer) {
            return draggableButton;
        }
        DescContainer descContainer2 = this.getCopyDesc(descContainer, welcomeTextButton.getFullName(), string);
        if (this.getNameLength(descContainer2) > 127) {
            String string2 = res.getString("Max_Name_Length_Limit_Reached");
            OptionPane.showMessageDialog(this.getContentPane(), string2);
            return draggableButton;
        }
        CommStyleInfo commStyleInfo = null;
        commStyleInfo = !welcomeTextButton.isExecutable() || welcomeTextButton.isImported() ? this.commMap.get(welcomeTextButton) : this.exeCommstyle;
        if (null == commStyleInfo && this.treeBtnList.contains(welcomeTextButton)) {
            object2 = (CommStyleInfo)welcomeTextButton.getDescContainer()._getRootParent();
            object = null;
            object = ((CommStyleInfo)object2).getPluginName() != null ? ((CommStyleInfo)object2).getPluginName() + '/' + ((CommStyleInfo)object2).getRelatFileName() : ((CommStyleInfo)object2).getRelatFileName();
            WelcomeTextButton welcomeTextButton2 = null;
            if (object != null) {
                welcomeTextButton2 = this.fileMap.get(object);
            }
            if (welcomeTextButton2 != null) {
                commStyleInfo = this.commMap.get(welcomeTextButton2);
            }
        }
        if (null != commStyleInfo && commStyleInfo.getAreaDescCount() > 0) {
            if (!welcomeTextButton.isExecutable()) {
                object2 = commStyleInfo.getAreaDescContainer(0);
                if (null != object2 && null != ((AreaDescContainer)object2).getDescContainer(WELCOME_BUTTON_SETTING_DESC)) {
                    object = ((AreaDescContainer)object2).getDescContainer(WELCOME_BUTTON_SETTING_DESC);
                    if (((DescContainer)object).getDescContainer(descContainer2.getDescName()) == null) {
                        ((DescContainer)object).addDescContainer(descContainer2);
                    } else {
                        int n = ((DescContainer)object).getDescContainerCount();
                        boolean bl = false;
                        DescContainer descContainer3 = null;
                        CommStyleInfo commStyleInfo2 = null;
                        CommStyleInfo commStyleInfo3 = null;
                        String string3 = null;
                        String string4 = null;
                        String string5 = null;
                        for (int i = 0; i < n; ++i) {
                            descContainer3 = ((DescContainer)object).getDescContainer(i);
                            commStyleInfo2 = (CommStyleInfo)descContainer3._getRootParent();
                            string5 = commStyleInfo2.getResString(descContainer3.getParasItemValue("name"));
                            if (null == string5) {
                                string5 = descContainer3.getParasItemValue("name");
                            }
                            string4 = descContainer3.getParasItemValue("workbenchid");
                            commStyleInfo3 = (CommStyleInfo)descContainer._getRootParent();
                            string3 = commStyleInfo3.getResString(descContainer2.getParasItemValue("name"));
                            if (null == string3) {
                                string3 = descContainer2.getParasItemValue("name");
                            }
                            if (!descContainer3.getDescName().equals(descContainer2.getDescName()) || !string5.equals(string3) || (string4 != null && string4.trim().length() != 0 || !"_default_iview_workbenches".equals(string)) && (string4 == null || !string4.equals(string))) continue;
                            bl = true;
                            ((DescContainer)object).removeDescContainer(descContainer3);
                            ((DescContainer)object).addDescContainer(descContainer2);
                            break;
                        }
                        if (!bl) {
                            ((DescContainer)object).addDescContainer(descContainer2);
                        }
                    }
                } else if (null != object2 && null == ((AreaDescContainer)object2).getDescContainer(WELCOME_BUTTON_SETTING_DESC)) {
                    object = new DescContainer(WELCOME_BUTTON_SETTING_DESC);
                    ((DescContainer)object).addDescContainer(descContainer2);
                    ((AreaDescContainer)object2).addDescContainer((DescContainer)object);
                }
            } else {
                this.writeExeCommInfo(descContainer2);
            }
            draggableButton = this.addCopiedButtonsInfoTree(descContainer2, commStyleInfo, string);
            if (welcomeTextButton.isActionButton()) {
                draggableButton.setActionButton(true);
            }
            ((TextButton)draggableButton).initializeButton();
            object2 = welcomeTextButton.getCommandProcessor();
            if (null != object2) {
                draggableButton.setCommandProcessor((ICommandProcessor)object2);
            }
            if (!welcomeTextButton.isEnabled()) {
                draggableButton.setEnabled(false);
            } else {
                draggableButton.setEnabled(true);
                draggableButton.setPopupMenu(this.getButtonPopupMenu(draggableButton));
            }
            if (draggableButton instanceof DraggableButton) {
                this.setDraggableTarget(draggableButton);
            }
        }
        return draggableButton;
    }

    private DraggableButton addCopiedButtonsInfoTree(DescContainer descContainer, CommStyleInfo commStyleInfo, String string) {
        DraggableButton draggableButton = (DraggableButton)DraggableButton.getUIObject(descContainer);
        draggableButton.addSelectionListener(this);
        this.setDragabbleXY(draggableButton, this.popupPoint);
        draggableButton.storeXYInfo();
        draggableButton.setWorkbenchId(string);
        this.setDraggableTarget(draggableButton);
        if (!draggableButton.isExecutable()) {
            if (draggableButton.isUserEnable()) {
                this.enableList.add(draggableButton);
            }
            this.commMap.put(draggableButton, commStyleInfo);
        }
        this.addButtonInfoToButtonSet(draggableButton);
        this.selectedList.add(draggableButton);
        this.workBenchList.add(draggableButton.getWorkbenchId());
        return draggableButton;
    }

    private List<WelcomeTextButton> getLinkDlgEnableList(WorkbenchButton workbenchButton) {
        ArrayList<Object> arrayList = new ArrayList(0);
        if (ConfigUtilities.isDraggableLayout() && null != workbenchButton) {
            arrayList = this.workbenchManager.getSelectedWBEnableList(this.treeBtnList, workbenchButton.getWorkbenchId());
        } else if (!ConfigUtilities.isDraggableLayout()) {
            arrayList = this.treeBtnList;
        }
        ArrayList<WelcomeTextButton> arrayList2 = new ArrayList<WelcomeTextButton>(0);
        for (WelcomeTextButton welcomeTextButton : arrayList) {
            try {
                String string = welcomeTextButton.getCommand();
                CommandManager commandManager = CommandManager.getInstance();
                AuthorityAction authorityAction = commandManager.getAction(string);
                if (null != authorityAction) {
                    if (!authorityAction.isVisible()) continue;
                    arrayList2.add(welcomeTextButton);
                    continue;
                }
                if (welcomeTextButton.isActionButton() && null != welcomeTextButton.getAction() && false == welcomeTextButton.getAction().isActionVisible()) continue;
                arrayList2.add(welcomeTextButton);
            }
            catch (Exception exception) {
                logger.trace("Error in button ButtonName " + welcomeTextButton.getButtonName() + "Full name " + welcomeTextButton.getFullName());
            }
        }
        return arrayList2;
    }

    public List<String> getChangeWorkBench() {
        return this.workBenchList;
    }

    private boolean validateButton(WelcomeTextButton welcomeTextButton) {
        ArrayList<String> arrayList;
        if (null == welcomeTextButton) {
            return false;
        }
        String string = "_default_iview_workbenches";
        String string2 = welcomeTextButton.getFullName() + welcomeTextButton.getCategory();
        if (welcomeTextButton instanceof DraggableButton && (null == (string = ((DraggableButton)welcomeTextButton).getWorkbenchId()) || string.length() == 0)) {
            string = "_default_iview_workbenches";
        }
        if (null == (arrayList = this.buttonNameSet.get(string)) || arrayList.size() < 1) {
            ArrayList<String> arrayList2 = new ArrayList<String>(10);
            arrayList2.add(string2);
            this.buttonNameSet.put(string, arrayList2);
        } else {
            if (arrayList.contains(string2)) {
                logger.trace("Fail to load as button with name " + string2 + " already loaded");
                return false;
            }
            arrayList.add(string2);
        }
        return true;
    }

    public void saveWelcomeButtonInfo(String string) {
        ArrayList<WelcomeTextButton> arrayList = null;
        arrayList = null != string ? this.workbenchManager.getWPButtons(string) : this.workbenchManager.getSelectedWPButtons();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            ((DraggableButton)arrayList.get(i)).storeXYInfo();
            this.modifylink((DraggableButton)arrayList.get(i), true);
        }
    }

    public void setButtonState() {
        this.setEnableActionButtons((ArrayList)this.selectedList);
        new Thread(new Runnable(){

            @Override
            public void run() {
                WelcomePage.this.setEnableActionButtons(WelcomePage.this.treeBtnList);
            }
        }).start();
    }

    public ArrayList<WelcomeTextButton> getAllLinkDlgTextButton(String string, String string2) {
        ArrayList<WelcomeTextButton> arrayList = new ArrayList<WelcomeTextButton>(1);
        if (null == string2 || null == string) {
            return arrayList;
        }
        for (WelcomeTextButton welcomeTextButton : this.treeBtnList) {
            if (!ResourceUtil.areEquals(((DraggableButton)welcomeTextButton).getWorkbenchId(), string) || !string2.equals(welcomeTextButton.getDescName())) continue;
            arrayList.add(welcomeTextButton);
        }
        return arrayList;
    }

    IWBLauncher getIWBExtension() {
        return IWBLauncherFactory.getIWBLauncher();
    }

    boolean isAllUsersLocation() {
        IWBLauncher iWBLauncher = this.getIWBExtension();
        return iWBLauncher != null && iWBLauncher.getPersistenceLocation() == 1;
    }

    private WelcomeTextButton createLinkDlgWelcomeTextButton(DescContainer descContainer) {
        WelcomeTextButton welcomeTextButton = null;
        String string = descContainer.getParasItemValue("name");
        if (null == string || string.trim().length() == 0) {
            return welcomeTextButton;
        }
        String string2 = descContainer.getParasItemValue("command");
        boolean bl = CommandManager.getInstance().isCommandLicensed(string2);
        if (!bl) {
            return welcomeTextButton;
        }
        if (ConfigUtilities.isDraggableLayout()) {
            String string3 = descContainer.getParasItemValue("workbenchid");
            if (!(null == string3 || string3.trim().length() == 0) && !this.workbenchManager.isValidWBId(string3)) {
                logger.trace("Workbench id" + string3 + "for " + string + " welcomebutton is invalid");
                return welcomeTextButton;
            }
            welcomeTextButton = DraggableButton.getUIObjectWithoutIndex(descContainer);
        } else {
            welcomeTextButton = (WelcomeTextButton)WelcomeTextButton.getUIObject(descContainer);
        }
        return welcomeTextButton;
    }

    ArrayList<String> getAvailableSameCommandButton(List<MenuItem> list) {
        if (null == this.workbenchManager) {
            return null;
        }
        List<WelcomeTextButton> list2 = null;
        List<WelcomeTextButton> list3 = this.getAllWorkBenchLinkDlgEnableList();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = list.size();
        MenuItem menuItem = null;
        AbstractAction abstractAction = null;
        String string = null;
        ArrayList<WelcomeTextButton> arrayList2 = null;
        for (int i = 0; i < n; ++i) {
            menuItem = list.get(i);
            if (null == menuItem) continue;
            abstractAction = menuItem.getMenuItemAction();
            string = menuItem.getID();
            if (abstractAction != null && !(abstractAction instanceof AuthorityAction) || (list2 = this.getSameCommandButtons(list3, menuItem.getCommand(), (AuthorityAction)abstractAction)).size() <= 0) continue;
            if (null == string || string.trim().length() == 0) {
                arrayList.add(list2.get(0).getDescName());
                continue;
            }
            arrayList2 = new ArrayList<WelcomeTextButton>(0);
            String string2 = "";
            for (WelcomeTextButton welcomeTextButton : list2) {
                string2 = welcomeTextButton.getMenuID();
                if (null == string2) {
                    arrayList2.add(welcomeTextButton);
                    continue;
                }
                if (!string.equals(string2)) continue;
                arrayList.add(welcomeTextButton.getDescName());
            }
            if (arrayList2.size() <= 0) continue;
            arrayList.add(((WelcomeTextButton)arrayList2.get(0)).getDescName());
        }
        return arrayList;
    }

    protected void clear() {
        this.treeBtnList.clear();
        this.treeBtnList = null;
        this.m_buttonArray.clear();
        this.m_buttonArray = null;
        if (null != this.selectedList) {
            this.selectedList.clear();
            this.selectedList = null;
        }
        this.fileMap.clear();
        this.fileMap = null;
        this.commMap.clear();
        this.commMap = null;
        this.enableList.clear();
        this.enableList = null;
        this.workBenchList.clear();
        this.workBenchList = null;
    }

    private void addButtonInfoToButtonSet(WelcomeTextButton welcomeTextButton) {
        this.validateButton(welcomeTextButton);
    }

    private void removeButtonInfoFromButtonSet(WelcomeTextButton welcomeTextButton) {
        ArrayList<String> arrayList;
        String string = "_default_iview_workbenches";
        String string2 = welcomeTextButton.getFullName() + welcomeTextButton.getCategory();
        if (welcomeTextButton instanceof DraggableButton) {
            string = ((DraggableButton)welcomeTextButton).getWorkbenchId();
        }
        if ((arrayList = this.buttonNameSet.get(string)) != null) {
            arrayList.remove(string2);
            this.buttonNameSet.put(string, arrayList);
        }
    }

    private List<WelcomeTextButton> getVisibileButtons(List<WelcomeTextButton> list) {
        ArrayList<WelcomeTextButton> arrayList = new ArrayList<WelcomeTextButton>(0);
        for (WelcomeTextButton welcomeTextButton : list) {
            try {
                String string = welcomeTextButton.getCommand();
                CommandManager commandManager = CommandManager.getInstance();
                AuthorityAction authorityAction = commandManager.getAction(string);
                if (null != authorityAction) {
                    if (!authorityAction.isVisible()) continue;
                    arrayList.add(welcomeTextButton);
                    continue;
                }
                if (null == welcomeTextButton.getAction()) {
                    AuthorityView authorityView = commandManager.getAuthorityViewAction(string);
                    if (authorityView == null) {
                        arrayList.add(welcomeTextButton);
                        continue;
                    }
                    if (!authorityView.isVisible(string)) continue;
                    arrayList.add(welcomeTextButton);
                    continue;
                }
                if (null == welcomeTextButton.getAction() || !welcomeTextButton.getAction().isActionVisible()) continue;
                arrayList.add(welcomeTextButton);
            }
            catch (Throwable throwable) {
                logger.trace("IView Handled Error while updating  Visibilityof WelcomeButton " + welcomeTextButton.getButtonName(), throwable);
            }
        }
        return arrayList;
    }

    public void removeTextButton(TextButton textButton) {
        if (!(textButton instanceof WelcomeTextButton)) {
            logger.error("Not removed since button : " + textButton.getName() + " is not WelcomeTextButton!");
            return;
        }
        WelcomeTextButton welcomeTextButton = (WelcomeTextButton)textButton;
        int n = OptionPane.showConfirmDialog(FrameworkUtilities.getMainFrame(), res.getString("remove_link_message"), res.getString("Confirm"), 0);
        if (n == 0) {
            if (!welcomeTextButton.isRemovable()) {
                throw new IllegalArgumentException("Button : " + welcomeTextButton.getName() + " is not removable");
            }
            if (!welcomeTextButton.isSelected()) {
                throw new IllegalArgumentException("Button : " + welcomeTextButton.getName() + " is already in removed state");
            }
            logger.trace("Removing button : " + textButton.getName());
            this.removeLink(welcomeTextButton, FrameworkUtilities.getMainFrame(), false);
        } else {
            logger.trace("User denied removing button : " + textButton.getName());
        }
    }

    private String regexCheck(String string) {
        String string2 = string;
        string2 = string2.replace("\\", "\\\\");
        string2 = string2.replace("(", "\\(");
        string2 = string2.replace(")", "\\)");
        string2 = string2.replace("[", "\\[");
        string2 = string2.replace("]", "\\]");
        string2 = string2.replace("{", "\\{");
        string2 = string2.replace("}", "\\}");
        string2 = string2.replace("?", "\\?");
        string2 = string2.replace("*", "\\*");
        string2 = string2.replace("$", "\\$");
        string2 = string2.replace("^", "\\^");
        string2 = string2.replace("+", "\\+");
        string2 = string2.replace("|", "\\|");
        return string2;
    }

    private void removeDraggingListener(WelcomeTextButton welcomeTextButton) {
        for (Component component : welcomeTextButton.getComponents()) {
            MouseMotionListener[] mouseMotionListenerArray = component.getMouseMotionListeners();
            for (int i = 0; i < mouseMotionListenerArray.length; ++i) {
                component.removeMouseMotionListener(mouseMotionListenerArray[i]);
                mouseMotionListenerArray[i] = null;
            }
        }
    }

    @Override
    public void buttonDragged(Object object, Object object2) {
        if (object instanceof DraggableButton) {
            this.modifylink((DraggableButton)object, true);
        }
        if (object2 instanceof DraggableButton) {
            this.modifylink((DraggableButton)object2, true);
        }
        this.saveWelcomeButtonInfo(null);
    }

    @Override
    public boolean isSupportClick(Object object) {
        if (object instanceof MenuItem) {
            MenuItem menuItem = (MenuItem)object;
            WelcomeTextButton welcomeTextButton = this.getWelcomeTextButtonObject(menuItem.getCommand(), (AuthorityAction)menuItem.getMenuItemAction(), menuItem.getID());
            return null != welcomeTextButton;
        }
        return false;
    }

    @Override
    public void preClick() {
        if (!this.isRegistered()) {
            FrameworkUtilities.getWindowManager().registerWindow(this);
            FrameworkUtilities.getWindowManager().activateWindow(this.getWindowId());
        } else if (!this.isSelected()) {
            if (this.isIcon()) {
                this.setIcon(false);
            }
            this.setSelected(true);
        }
    }

    @Override
    public void click(Object object) {
        if (object instanceof MenuItem) {
            MenuItem menuItem = (MenuItem)object;
            this.showMenuAddLink(menuItem.getCommand(), (AuthorityAction)menuItem.getMenuItemAction(), menuItem.getID());
        }
    }

    @Override
    public void postClick() {
    }

    static {
        WelcomePage.gbConst.gridx = 0;
        WelcomePage.gbConst.gridy = 0;
        WelcomePage.gbConst.weightx = 1.0;
        WelcomePage.gbConst.weighty = 1.0;
        WelcomePage.gbConst.fill = 1;
        WelcomePage.gbConst.anchor = 18;
        jbInitCalled = false;
    }
}

