/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.windowmanagement.welcomepage;

import com.swimap.iview.commstyle.commandmng.authority.AuthorityAction;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.MenuItem;
import com.swimap.iview.framework.menumanagement.MenuManager;
import com.swimap.iview.framework.modulemanagement.BaseModule;
import com.swimap.iview.framework.modulemanagement.InternalLocalMsg;
import com.swimap.iview.framework.modulemanagement.ModuleManager;
import com.swimap.iview.framework.pluginmanagement.Plugin;
import com.swimap.iview.framework.pluginmanagement.PluginManager;
import com.swimap.iview.framework.util.FrameworkCommandProcessor;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.framework.windowmanagement.welcomepage.ButtonInfo;
import com.swimap.iview.framework.windowmanagement.welcomepage.ButtonValidationInfo;
import com.swimap.iview.framework.windowmanagement.welcomepage.CategorySettings;
import com.swimap.iview.framework.windowmanagement.welcomepage.ConfigUtilities;
import com.swimap.iview.framework.windowmanagement.welcomepage.IWBLauncherFactory;
import com.swimap.iview.framework.windowmanagement.welcomepage.SerialNumberComparator;
import com.swimap.iview.framework.windowmanagement.welcomepage.WelcomePage;
import com.swimap.iview.framework.windowmanagement.welcomepage.WelcomeTextButton;
import com.swimap.iview.framework.windowmanagement.welcomepage.WelcomeUtilities;
import com.swimap.iview.framework.windowmanagement.welcomepage.WorkbenchManager;
import com.swimap.iview.util.FileChooser;
import com.swimap.iview.util.FileChooserFilter;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.filechooser.FileFilter;
import org.omg.CORBA.ORB;

public class WelcomeManager
extends BaseModule {
    private static IviewLogger logger = IviewLogger.getLogger(WelcomeManager.class, "IVIEW");
    private static final String MODULE_NAME = "WelcomePage";
    private static WelcomePage welcomePage = null;
    private static boolean isInitialization = true;
    private static boolean isSystemLoaded = false;
    private static WorkbenchManager workbenchManager;
    public static final SerialNumberComparator SL_NUMBER_COMPTR;
    private static final String CLIENT_SETTING_CLASSNAME = "com.swimap.iview.framework.windowmanagement.welcomepage.WelcomePageSetting";
    private static boolean showAddWBLinkMenuItem;
    private static boolean showImportWBMenuItem;
    private static boolean showExportWBMenuItem;
    public static HashMap<WBpopupMenuItems, Boolean> popupvisibilemap;
    private static int settingKey;
    private static HashMap<String, CommStyleInfo> welcomeButtonCommStyleMap;
    static Thread welcomeLoadThread;

    public WelcomeManager(ModuleManager moduleManager, ORB oRB, String string, String string2) {
        super(moduleManager, oRB, string, string2);
    }

    public WelcomeManager(ModuleManager moduleManager) {
        super(moduleManager);
    }

    @Override
    public String getModuleName() {
        return MODULE_NAME;
    }

    @Override
    public void initialize() {
        Thread thread = FrameworkCommandProcessor.getInstance().getWelcomeThread();
        if (null != thread && thread.isAlive()) {
            try {
                logger.trace("loadwelcomeThread start joined to main thread");
                thread.join();
                logger.trace("loadwelcomeThread joined to the main thread");
            }
            catch (InterruptedException interruptedException) {
                logger.trace(interruptedException.getMessage(), interruptedException);
            }
        }
    }

    @Override
    protected void postSystemLoadingFinished() {
        WelcomeManager.initExtensionPointAndShow();
    }

    @Override
    protected void postSequencedInit() {
        if (welcomeLoadThread != null && welcomeLoadThread.isAlive()) {
            try {
                logger.trace("postSequencedInit welcomeLoadThread start joined to main thread");
                welcomeLoadThread.join();
                logger.trace("postSequencedInit welcomeLoadThread joined to the main thread");
            }
            catch (InterruptedException interruptedException) {
                logger.trace(interruptedException.getMessage(), interruptedException);
            }
        }
        if (!FrameworkCommandProcessor.getInstance().isAppStyle()) {
            if (FrameworkUtilities.getWindowTabbedManager().isDefaultTabIconVisible()) {
                welcomePage.setFrameIcon(welcomePage.getFrameIcon());
            } else {
                welcomePage.setFrameIcon(null);
            }
        }
    }

    public static void load() {
        WelcomeManager.initializeWelcomePage(false);
    }

    private static void initializeWelcomePage(boolean bl) {
        try {
            WelcomeManager.clearWelcomeButtonInfoMap();
            welcomePage = new WelcomePage(bl);
            workbenchManager = new WorkbenchManager();
            if (bl) {
                welcomePage.initWelcomePage(workbenchManager);
                if (ConfigUtilities.isDraggableLayout()) {
                    welcomePage.loadWorkBenchInfos(false);
                }
                WelcomeManager.showWelcomePage(bl);
            } else {
                welcomeLoadThread = new Thread("initializeWelcomePage"){

                    @Override
                    public void run() {
                        welcomePage.initWelcomePage(workbenchManager);
                        if (ConfigUtilities.isDraggableLayout()) {
                            welcomePage.loadWorkBenchInfos(false);
                        }
                    }
                };
                welcomeLoadThread.setName("InitWelcomePage");
                welcomeLoadThread.setPriority(10);
                welcomeLoadThread.start();
            }
        }
        catch (Exception exception) {
            welcomePage = null;
            workbenchManager = null;
            logger.trace("Unable to initialize welcome frame : ");
            logger.trace(exception.getMessage(), exception);
            return;
        }
    }

    private static void showWelcomePage(boolean bl) {
        boolean bl2 = ConfigUtilities.isEnableWelcomePage() || bl;
        boolean bl3 = FrameworkCommandProcessor.getInstance().isAppStyle();
        if (!bl3 && !WelcomePage.jbInitCalled) {
            welcomePage.jbInit();
            WelcomePage.jbInitCalled = true;
        }
        if (!bl3 && bl2 && (ConfigUtilities.isEnableAfterRelogin() || isInitialization)) {
            FrameworkUtilities.getWindowManager().registerWindow(welcomePage);
            isInitialization = false;
        }
        if (!bl3 && ConfigUtilities.isDraggableLayout()) {
            workbenchManager.clickSelectedWBench();
        }
        if (!bl) {
            isSystemLoaded = false;
        }
    }

    public static WelcomePage getWelcomePage() {
        WelcomeManager.getWelcomePageReference();
        if (null != welcomePage) {
            FrameworkUtilities.getWindowManager().registerWindow(welcomePage);
            FrameworkUtilities.getWindowManager().activateWindow(welcomePage.getWindowId());
        }
        return welcomePage;
    }

    public static WelcomePage getWelcomePageReference() {
        if (null == welcomePage) {
            isInitialization = true;
            WelcomeManager.initializeWelcomePage(true);
            Thread thread = new Thread(){

                @Override
                public void run() {
                    FrameworkCommandProcessor.getInstance().showWelcomeBubble();
                }
            };
            thread.start();
        }
        return welcomePage;
    }

    @Override
    public void stop() {
        if (welcomePage != null) {
            welcomePage.clear();
            if (workbenchManager != null) {
                workbenchManager.cleanUp();
                workbenchManager = null;
            }
            welcomePage.removeAll();
            welcomePage.dispose();
            welcomePage = null;
        }
    }

    public static WelcomePage getWelcomeRef() {
        return welcomePage;
    }

    public static final WorkbenchManager getWorkbenchManager() {
        return workbenchManager;
    }

    public static boolean writeCommInfo(CommStyleInfo commStyleInfo) {
        String string = commStyleInfo.getPluginName();
        if (null == string) {
            CommStyleManager.getInstance().writeToUser(commStyleInfo);
            return true;
        }
        Plugin plugin = PluginManager.getInstance().getPluginFromFolder(string);
        try {
            if (null == plugin) {
                return false;
            }
            plugin.getIntegrateCommStyleReader().writeToUser(commStyleInfo);
        }
        catch (IOException iOException) {
            logger.trace(iOException.getMessage(), iOException);
            return false;
        }
        return true;
    }

    static boolean writeAllUserCommInfo(CommStyleInfo commStyleInfo) {
        String string = commStyleInfo.getPluginName();
        if (null == string) {
            try {
                if (null != welcomePage) {
                    String string2 = WelcomeManager.convertToAllUserPath(commStyleInfo.getFileName());
                    welcomePage.writeToPath(commStyleInfo, string2);
                }
            }
            catch (IOException iOException) {
                logger.trace(iOException.getMessage(), iOException);
            }
            return true;
        }
        Plugin plugin = PluginManager.getInstance().getPluginFromFolder(string);
        try {
            if (null == plugin) {
                return false;
            }
            plugin.getIntegrateCommStyleReader().writeToAllUsers(commStyleInfo);
        }
        catch (IOException iOException) {
            logger.trace(iOException.getMessage(), iOException);
            return false;
        }
        return true;
    }

    private static String convertToAllUserPath(String string) {
        CommStyleManager commStyleManager = CommStyleManager.getInstance();
        String string2 = string;
        String string3 = commStyleManager.getAllUsersInfoStyleDir();
        if (string3 != null && string3.length() > 0) {
            if (string2.startsWith("style/defaultstyle/")) {
                String string4 = string2.substring("style/defaultstyle/".length());
                string2 = string3 + string4;
            } else if (string2.startsWith("style/productstyle/")) {
                String string5 = string2.substring("style/productstyle/".length());
                string2 = string3 + string5;
            } else if (string2.startsWith("style/users/")) {
                String string6 = string2.substring("style/users/".length() + commStyleManager.getUsername().length());
                string2 = string3 + string6;
            }
        }
        return string2;
    }

    @Override
    public Object processEvent(InternalLocalMsg internalLocalMsg) {
        if (internalLocalMsg == InternalLocalMsg.MSG_EXIT_TERMINAL || internalLocalMsg == InternalLocalMsg.MSG_LOGOUT) {
            if (null != workbenchManager && null != WelcomeManager.getWelcomeRef() && ConfigUtilities.isDraggableLayout()) {
                workbenchManager.saveWorkbenches();
            }
            if (settingKey > -1) {
                FrameworkUtilities.getSystemSettingsManager().removeSetting(settingKey);
            }
            if (null != welcomePage) {
                boolean bl = welcomePage.preLogoutSaveTask();
                logger.trace("Prelogout of welcome page is =" + bl);
            }
        }
        return null;
    }

    public static void updateWelcomePage() {
        if (null != welcomePage) {
            welcomePage.updateWelcomePage();
        }
    }

    @Override
    protected void lowPriorityInitAfterLoaded() {
        if (!FrameworkCommandProcessor.getInstance().isAppStyle()) {
            isSystemLoaded = true;
            welcomePage.refreshWelcomePage();
            settingKey = FrameworkUtilities.getSystemSettingsManager().addClientModuleSettingsWithSequence("400", CLIENT_SETTING_CLASSNAME, this.getModuleName());
        }
    }

    static CommStyleInfo readCommInfo(String string, String string2) {
        if (null == string2) {
            return CommStyleManager.getInstance().getUserCommonStyleFile(string);
        }
        Plugin plugin = PluginManager.getInstance().getPluginFromFolder(string2);
        if (null == plugin) {
            return null;
        }
        return plugin.getIntegrateCommStyleReader().getUserCommStyleInfo(string);
    }

    public static ButtonValidationInfo validateButtonInfo(ButtonInfo buttonInfo, boolean bl) {
        if (null == buttonInfo) {
            throw new IllegalArgumentException("Info object is null.");
        }
        return WelcomeManager.validateInfo(buttonInfo.getFullName(), bl);
    }

    static ButtonValidationInfo validateInfo(String string, boolean bl) {
        boolean bl2 = false;
        if (null != welcomePage && bl) {
            bl2 = welcomePage.isButtonExist(string);
        }
        int n = 0;
        String string2 = "";
        if (bl2) {
            n = 1;
            string2 = WelcomeUtilities.res.getString("Button_Exist");
        }
        return new ButtonValidationInfo(n, string2);
    }

    private static void initExtensionPointAndShow() {
        if (IWBLauncherFactory.forceLoadExtensions()) {
            WorkbenchManager.clear();
            CategorySettings.clear();
            WelcomeManager.reinitWelcomePageExtensionPoint();
        }
        WelcomeManager.showWelcomePage(false);
    }

    private static void reinitWelcomePageExtensionPoint() {
        WelcomeManager.clearWelcomeButtonInfoMap();
        welcomePage = new WelcomePage(false);
        workbenchManager = new WorkbenchManager();
        welcomePage.initWelcomePage(workbenchManager);
        if (ConfigUtilities.isDraggableLayout()) {
            welcomePage.loadWorkBenchInfos(false);
        }
    }

    public static void setShowAddWBLinkMenuItem(boolean bl) {
        showAddWBLinkMenuItem = bl;
    }

    public static void setShowImportWBMenuItem(boolean bl) {
        showImportWBMenuItem = bl;
    }

    public static void setShowExportWBMenuItem(boolean bl) {
        showExportWBMenuItem = bl;
    }

    public static boolean isShowAddWBLinkMenuItem() {
        return showAddWBLinkMenuItem;
    }

    public static boolean isShowImportWBMenuItem() {
        return showImportWBMenuItem;
    }

    public static boolean isShowExportWBMenuItem() {
        return showExportWBMenuItem;
    }

    public static String getWelcomeButtonID(String string, String string2, String string3) {
        WelcomeTextButton welcomeTextButton;
        MenuItem menuItem;
        AbstractAction abstractAction;
        MenuManager menuManager = FrameworkUtilities.getMenuManager();
        if (null == menuManager || null == string || null == string2 || null == string3) {
            return null;
        }
        Component component = menuManager.getMenuItem(string, string2, string3, true);
        if (component instanceof MenuItem && ((abstractAction = (menuItem = (MenuItem)component).getMenuItemAction()) instanceof AuthorityAction || null == abstractAction) && null != welcomePage && null != (welcomeTextButton = welcomePage.getAvailableSameCommandButton(menuItem.getCommand(), (AuthorityAction)abstractAction, string3))) {
            return welcomeTextButton.getDescName();
        }
        return null;
    }

    public static List<String> getWelcomeButtonID(List<MenuItem> list) {
        if (null != list && list.size() > 0) {
            logger.trace("Start  getWelcomeButtonID size = " + list.size() + "Time = " + System.currentTimeMillis());
            if (null != welcomePage) {
                logger.trace("End  getWelcomeButtonID " + list.size() + "Time = " + System.currentTimeMillis());
                ArrayList<String> arrayList = welcomePage.getAvailableSameCommandButton(list);
                logger.trace("End  getWelcomeButtonID Time = " + System.currentTimeMillis());
                return arrayList;
            }
        }
        return null;
    }

    public static ArrayList<FileFilter> getWelcomePageImageFilters() {
        ArrayList<FileFilter> arrayList = new ArrayList<FileFilter>(4);
        FileChooserFilter fileChooserFilter = new FileChooserFilter();
        fileChooserFilter.addExtension("jpg");
        fileChooserFilter.addExtension("gif");
        fileChooserFilter.addExtension("png");
        fileChooserFilter.setDescription(WelcomeUtilities.res.getString("All_Files") + " (*.jpg, *.gif, *.png)");
        fileChooserFilter.setExtensionListInDescription(false);
        arrayList.add(FileChooser.JPG_FILECHOOSERFILTER);
        arrayList.add(FileChooser.GIF_FILECHOOSERFILTER);
        arrayList.add(FileChooser.PNG_FILECHOOSERFILTER);
        arrayList.add(fileChooserFilter);
        return arrayList;
    }

    public static void setMenuItemVisibility(HashMap<WBpopupMenuItems, Boolean> hashMap) {
        if (hashMap == null || hashMap.isEmpty()) {
            return;
        }
        popupvisibilemap.putAll(hashMap);
    }

    public static void addWelcomeButtonInfoToMap(String string, CommStyleInfo commStyleInfo) {
        logger.debug("IT- adding welcome button comm style info for path " + string);
        welcomeButtonCommStyleMap.put(string, commStyleInfo);
    }

    public static CommStyleInfo getWelcomeButtonInfo(String string) {
        CommStyleInfo commStyleInfo = null;
        commStyleInfo = welcomeButtonCommStyleMap.get(string);
        if (null != commStyleInfo) {
            logger.debug("IT- CommStyle info object found for path " + string);
        } else {
            logger.debug("IT- comm style info not available for path " + string);
        }
        return commStyleInfo;
    }

    public static void loadWelcomeButtons(String string, String string2) {
        if (null == string || null == workbenchManager || null == welcomePage) {
            return;
        }
        if (null == string2 || string2.trim().length() == 0) {
            CommStyleInfo commStyleInfo = CommStyleManager.getInstance().getCommonStyleFile(string, true);
            if (commStyleInfo == null) {
                logger.trace("CommStyle file is invalid");
                return;
            }
            commStyleInfo.setRelatFileName(string);
            if (ConfigUtilities.isDraggableLayout()) {
                workbenchManager.readWorkbenchInfo(commStyleInfo);
            }
            welcomePage.readWelcomeButtonInfo(commStyleInfo, null);
        } else {
            Plugin plugin = PluginManager.getInstance().getPlugin(string2);
            if (null == plugin) {
                return;
            }
            CommStyleInfo commStyleInfo = null;
            commStyleInfo = WelcomeManager.getWelcomePageReference() != null && WelcomeManager.getWelcomePageReference().isAllUsersLocation() ? plugin.getIntegrateCommStyleReader().getAllUserCommStyleInfo(string) : plugin.getIntegrateCommStyleReader().getUserCommStyleInfo(string);
            if (ConfigUtilities.isDraggableLayout()) {
                workbenchManager.readWorkbenchInfo(commStyleInfo);
            }
            welcomePage.readWelcomeButtonInfo(commStyleInfo, string2);
        }
        if (ConfigUtilities.isDraggableLayout()) {
            welcomePage.loadWorkBenchInfos(true);
        }
        if (!WelcomePage.jbInitCalled) {
            WelcomePage.jbInitCalled = true;
            welcomePage.jbInit();
        }
        if (isSystemLoaded) {
            welcomePage.refreshWelcomePage();
        }
    }

    public static void clearWelcomeButtonInfoMap() {
        logger.debug("IT- clearing welcome style info map");
        welcomeButtonCommStyleMap.clear();
    }

    static {
        SL_NUMBER_COMPTR = new SerialNumberComparator();
        showAddWBLinkMenuItem = true;
        showImportWBMenuItem = true;
        showExportWBMenuItem = true;
        popupvisibilemap = null;
        popupvisibilemap = new HashMap();
        popupvisibilemap.put(WBpopupMenuItems.CreateShortCut, true);
        popupvisibilemap.put(WBpopupMenuItems.ArrangeIconByName, true);
        popupvisibilemap.put(WBpopupMenuItems.Paste, true);
        popupvisibilemap.put(WBpopupMenuItems.ModifyLink, true);
        popupvisibilemap.put(WBpopupMenuItems.RemoveLink, true);
        popupvisibilemap.put(WBpopupMenuItems.CutLink, true);
        popupvisibilemap.put(WBpopupMenuItems.CopyLink, true);
        popupvisibilemap.put(WBpopupMenuItems.Workbench_ModifyLink, true);
        popupvisibilemap.put(WBpopupMenuItems.Workbench_RemoveLink, true);
        settingKey = -1;
        welcomeButtonCommStyleMap = new HashMap();
        welcomeLoadThread = null;
    }

    public static enum WBpopupMenuItems {
        CreateShortCut,
        ArrangeIconByName,
        Paste,
        ModifyLink,
        RemoveLink,
        CutLink,
        CopyLink,
        Workbench_ModifyLink,
        Workbench_RemoveLink;

    }
}

