/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.windowmanagement.welcomepage;

import com.swimap.iview.framework.registry.RegistryProvider;
import com.swimap.iview.framework.windowmanagement.welcomepage.IWBLauncher;
import com.swimap.iview.framework.windowmanagement.welcomepage.IWBLauncherImpl;
import com.swimap.iview.util.log.IviewLogger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;

public final class IWBLauncherFactory {
    private static IviewLogger logger = IviewLogger.getLogger(IWBLauncherFactory.class, "IVIEW");
    private static final String EXTENSION_ID = "com.iview.welcomepage.iwblauncher";
    private static boolean extensionExist = false;
    private static IWBLauncher extInstance = null;

    public static IWBLauncher getIWBLauncher() {
        if (null == extInstance) {
            try {
                extInstance = IWBLauncherFactory.getExtension();
            }
            catch (Exception exception) {
                logger.trace("Extensions are not available.");
            }
            if (null == extInstance) {
                extInstance = new IWBLauncherImpl();
            }
        }
        return extInstance;
    }

    private static IWBLauncher getExtension() {
        IExtensionRegistry iExtensionRegistry = RegistryProvider.getRegistry();
        if (null == iExtensionRegistry) {
            return null;
        }
        IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint(EXTENSION_ID);
        if (null == iExtensionPoint) {
            return null;
        }
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        if (null == iExtensionArray || iExtensionArray.length < 1) {
            return null;
        }
        IWBLauncher iWBLauncher = null;
        try {
            for (IConfigurationElement iConfigurationElement : iExtensionArray[0].getConfigurationElements()) {
                iWBLauncher = (IWBLauncher)iConfigurationElement.createExecutableExtension("class");
                if (null == iWBLauncher) continue;
                extensionExist = true;
                break;
            }
        }
        catch (CoreException coreException) {
            logger.trace(coreException.getMessage(), coreException);
        }
        return iWBLauncher;
    }

    static boolean isExtensionExist() {
        if (null == extInstance) {
            IWBLauncherFactory.getIWBLauncher();
        }
        return extensionExist;
    }

    static boolean forceLoadExtensions() {
        if (extensionExist) {
            return false;
        }
        IWBLauncher iWBLauncher = null;
        try {
            iWBLauncher = IWBLauncherFactory.getExtension();
        }
        catch (Exception exception) {
            logger.trace("Extensions are not available.");
        }
        if (null == iWBLauncher) {
            if (null == extInstance) {
                extInstance = new IWBLauncherImpl();
            }
            return false;
        }
        extInstance = iWBLauncher;
        return true;
    }
}

