/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.windowmanagement.welcomepage;

import com.swimap.iview.commstyle.commini.AreaDescContainer;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.commstyle.resource.i18n.ResourceUtil;
import com.swimap.iview.framework.lookandfeel.skin.TooltipListCellRenderer;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.framework.windowmanagement.welcomepage.ButtonValidationInfo;
import com.swimap.iview.framework.windowmanagement.welcomepage.ConfigUtilities;
import com.swimap.iview.framework.windowmanagement.welcomepage.WelcomeManager;
import com.swimap.iview.framework.windowmanagement.welcomepage.WelcomeTextButton;
import com.swimap.iview.framework.windowmanagement.welcomepage.WelcomeUtilities;
import com.swimap.iview.framework.windowmanagement.welcomepage.WorkbenchCombo;
import com.swimap.iview.framework.windowmanagement.welcomepage.draggable.DraggableButton;
import com.swimap.iview.templates.textfield.CharInputTextField;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.FileChooser;
import com.swimap.iview.util.OpenFileChooser;
import com.swimap.iview.util.OptionPane;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.helpmanagement.HelpManager;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class ExecutableLinkDialog
extends JDialog {
    private static IviewLogger logger = IviewLogger.getLogger(ExecutableLinkDialog.class, "IVIEW");
    private static final ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/framework/windowmanagement/welcomepage/Res");
    private static final int DIALOG_WIDTH = 330;
    private static final int DIALOG_HEIGHT = 200;
    private static final int COMPONENT_WIDTH = 80;
    private static final int COMPONENT_HEIGHT = 21;
    private static final int LABEL_WIDTH = 74;
    private static final int TEXT_WIDTH = 210;
    private static final int MAX_TEXT_LENGTH = 127;
    private static final int MIN_TEXT_LENGTH_DES = 0;
    private static final int MIN_TEXT_LENGTH = 1;
    private static final int MARGINS_BORDER = 12;
    private static final int CHOOSER_BTN_SIZE = 20;
    protected CharInputTextField nameText = null;
    protected CharInputTextField descriptionText = null;
    protected JTextField executionPathText = null;
    protected JTextField iconText = null;
    private WelcomeTextButton imageButton = null;
    private String name = "";
    private String description = "";
    private String command = "";
    private String icon = "";
    private JButton btnModify = null;
    private JButton btnCreate = null;
    private JButton btnTest = null;
    private static final String PARA_NAME = "name";
    private static final String PARA_DESCRIPTION = "description";
    private static final String PARA_ICON = "icon";
    private static final String PARA_COMMAND = "command";
    private static final String PARA_WORKBENCH = "workbenchid";
    private static final String PARA_EXECUTABLE = "isExecutable";
    private static final String PARA_SERIAL = "serialnumber";
    private static final String PARA_SELECTED = "isSelected";
    private boolean draggable = false;
    private String nameTextOld = "";
    private String descriptionTextOld = "";
    private String iconTextOld = "";
    private boolean iconModified = false;
    private String wbenchOld = "";
    private String executionPathOld = "";
    private boolean buttonModified = false;
    private WorkbenchCombo[] workbenchCombo = null;
    private WorkbenchCombo buttonWBModified = null;
    private JComboBox workbenchList = null;
    protected JTextArea infoLabel = null;

    public static boolean checkPermittedPath(String string, boolean bl) {
        boolean bl2 = true;
        if (null == string) {
            return true;
        }
        if (string.startsWith("\\\\") || string.startsWith("//")) {
            bl2 = false;
            if (bl) {
                OptionPane.showMessageDialog(null, res.getString("ExecutableLink_Dialog_BadLink"));
            }
        }
        return bl2;
    }

    public ExecutableLinkDialog(Window window, boolean bl, String string) {
        super(window);
        this.setModal(true);
        String string2 = string;
        if (null == string2) {
            string2 = res.getString("Create_Executable_Link");
        }
        this.setTitle(string2);
        this.draggable = bl;
        this.jbInit(true);
    }

    public ExecutableLinkDialog(Window window, WelcomeTextButton welcomeTextButton, String string, WorkbenchCombo[] workbenchComboArray) {
        super(window);
        String string2;
        String string3;
        String string4;
        this.workbenchCombo = workbenchComboArray;
        this.setModal(true);
        this.imageButton = welcomeTextButton;
        String string5 = string;
        if (null == string5) {
            string5 = res.getString("Modify_Executable_Link");
        }
        this.setTitle(string5);
        String string6 = welcomeTextButton.getDescContainer().getParasItemValue(PARA_NAME);
        if (null != string6) {
            this.name = string6;
        }
        if (null != (string4 = welcomeTextButton.getDescContainer().getParasItemValue(PARA_DESCRIPTION))) {
            this.description = string4;
        }
        if (null != (string3 = welcomeTextButton.getDescContainer().getParasItemValue(PARA_ICON))) {
            this.icon = string3;
        }
        if (null != (string2 = welcomeTextButton.getDescContainer().getParasItemValue(PARA_COMMAND))) {
            this.command = string2;
        }
        this.jbInit(false);
    }

    private void jbInit(boolean bl) {
        this.setName("WelcomePage_executableLinkDlg");
        this.setSize(new Dimension(330, 200));
        JPanel jPanel = this.createInputPanel();
        this.infoLabel = new JTextArea(res.getString("Executable_Link_Info"));
        this.infoLabel.setFont((Font)UIManager.get("Label.font"));
        this.infoLabel.setOpaque(false);
        this.infoLabel.setMargin(new Insets(12, 12, 7, 3));
        this.infoLabel.setEditable(false);
        this.infoLabel.setLineWrap(true);
        this.infoLabel.setWrapStyleWord(true);
        this.infoLabel.setFocusable(false);
        this.infoLabel.setSize(100, 48);
        this.infoLabel.setPreferredSize(new Dimension(100, 48));
        this.infoLabel.setName("ExecutableLink_Dialog_InfoLabel");
        JPanel jPanel2 = this.createButtonPanel(bl);
        this.getContentPane().add((Component)jPanel, "North");
        this.getContentPane().add((Component)this.infoLabel, "Center");
        this.getContentPane().add((Component)jPanel2, "South");
        HelpManager helpManager = HelpManager.getInstance();
        helpManager.enableHelpKey(this.getRootPane(), "iVIEW.Workbench.ModifyLinkDialog");
        this.setResizable(false);
        this.pack();
        ScreenToolKit.centerLocateToScreen(this);
    }

    private JPanel createInputPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setName("Executable_Link_Dlg_panel");
        jPanel.add((Component)this.getNamePanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(12, 12, 0, 12), 0, 0));
        jPanel.add((Component)this.getDescriptionPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 2, new Insets(5, 12, 0, 12), 0, 0));
        jPanel.add((Component)this.getExecutionPanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 12, 0, 12), 0, 0));
        jPanel.add((Component)this.getIconPanel(), new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 2, new Insets(5, 12, 0, 12), 0, 0));
        if (null != this.workbenchCombo) {
            jPanel.add((Component)this.getWorkbenchPanel(), new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 10, 2, new Insets(5, 12, 10, 12), 0, 0));
        }
        return jPanel;
    }

    private void validateCommand(DocumentEvent documentEvent) {
        Document document = documentEvent.getDocument();
        String string = null;
        try {
            string = document.getText(0, document.getLength());
        }
        catch (BadLocationException badLocationException) {
            logger.trace(badLocationException.getMessage(), badLocationException);
        }
        boolean bl = null != string && string.length() > 0;
        this.setModifyButtonEnabled(true);
        this.btnTest.setEnabled(bl);
    }

    private void validateName(DocumentEvent documentEvent) {
        Document document = documentEvent.getDocument();
        String string = null;
        try {
            string = document.getText(0, document.getLength());
        }
        catch (BadLocationException badLocationException) {
            logger.trace(badLocationException.getMessage(), badLocationException);
        }
        this.enableModifyByValue(string);
    }

    private void enableModifyByValue(String string) {
        boolean bl = null != string && string.trim().length() > 0;
        this.btnModify.setEnabled(bl);
        this.btnCreate.setEnabled(bl);
    }

    protected void testCommand() {
        if (!ExecutableLinkDialog.checkPermittedPath(this.executionPathText.getText(), true)) {
            return;
        }
        CommonUtil.executeCommand(this.executionPathText.getText());
    }

    private JPanel createButtonPanel(boolean bl) {
        JPanel jPanel = new JPanel();
        jPanel.setName("Executable_Link_Dlg_btn_panel");
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        this.btnTest = new JButton(res.getString("ExecutableLink_Dialog_Test"));
        this.btnTest.setName("Executable_Link_Dlg_Test_Btn");
        this.btnTest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExecutableLinkDialog.this.testCommand();
            }
        });
        this.btnTest.setPreferredSize(new Dimension(80, 21));
        String string = this.executionPathText.getText();
        boolean bl2 = null != string && string.trim().length() > 0;
        this.btnTest.setEnabled(bl2);
        this.btnCreate = new JButton(res.getString("TreeDialog_Create"));
        this.btnCreate.setName("Executable_Link_Dlg_Create_Btn");
        this.btnCreate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExecutableLinkDialog.this.createExeButton();
            }
        });
        this.btnCreate.setPreferredSize(new Dimension(80, 21));
        this.btnCreate.setEnabled(false);
        this.btnModify = new JButton(res.getString("ModifyLink_Dialog_Modify"));
        this.btnModify.setName("Modify_Link_Dlg_Modify_Btn");
        this.btnModify.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExecutableLinkDialog.this.modifyButton();
            }
        });
        this.btnModify.setPreferredSize(new Dimension(80, 21));
        this.btnModify.setEnabled(false);
        JButton jButton = new JButton(res.getString("TreeDialog_Cancel"));
        jButton.setName("Executable_Link_Dlg_CANCEL_Btn");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExecutableLinkDialog.this.imageButton = null;
                ExecutableLinkDialog.this.removeAll();
                ExecutableLinkDialog.this.dispose();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                ExecutableLinkDialog.this.imageButton = null;
                ExecutableLinkDialog.this.removeAll();
                ExecutableLinkDialog.this.dispose();
            }
        });
        jButton.setPreferredSize(new Dimension(80, 21));
        jPanel3.add(this.btnTest);
        FlowLayout flowLayout = new FlowLayout(2);
        flowLayout.setHgap(4);
        jPanel2.setLayout(flowLayout);
        jPanel2.add(bl ? this.btnCreate : this.btnModify);
        jPanel2.add(jButton);
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        jPanel.add((Component)jPanel3, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 4, 7, 12), 0, 0));
        jPanel.add((Component)jPanel2, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 22, 2, new Insets(5, 17, 7, 8), 0, 0));
        ScreenToolKit.setDefaultButtons(bl ? this.btnCreate : this.btnModify, jButton);
        return jPanel;
    }

    private void modifyButton() {
        WorkbenchCombo workbenchCombo;
        Object object;
        String string;
        String string2;
        String string3;
        String string4;
        if (!ExecutableLinkDialog.checkPermittedPath(this.executionPathText.getText(), true)) {
            return;
        }
        DescContainer descContainer = this.imageButton.getDescContainer();
        ButtonValidationInfo buttonValidationInfo = WelcomeManager.validateInfo(string4, !this.nameTextOld.equals(string4 = this.nameText.getText().trim()));
        if (!buttonValidationInfo.isSuccess()) {
            OptionPane.showLineWrapOptionDialog(FrameworkUtilities.getMainFrame(), buttonValidationInfo.getErrMessage(), 1);
            return;
        }
        String string5 = string4 = null == string4 ? "" : string4;
        if (!ResourceUtil.areEquals(this.nameTextOld, string4)) {
            this.imageButton.setFullName(string4);
            this.nameTextOld = string4;
            this.buttonModified = true;
        }
        if (!ResourceUtil.areEquals(this.descriptionTextOld, string3 = this.descriptionText.getText())) {
            this.imageButton.setDescription(string3);
            this.descriptionTextOld = string3;
            this.buttonModified = true;
        }
        if (!ResourceUtil.areEquals(this.iconTextOld, string2 = this.iconText.getText())) {
            this.imageButton.setImagePath(string2);
            this.iconTextOld = string2;
            this.buttonModified = true;
            this.iconModified = true;
        }
        if (!ResourceUtil.areEquals(this.executionPathOld, string = this.executionPathText.getText())) {
            this.imageButton.setCommand(string);
            this.executionPathOld = string;
            this.buttonModified = true;
        }
        if (null != this.workbenchCombo && null != (object = this.workbenchList.getSelectedItem()) && !ResourceUtil.areEquals((workbenchCombo = (WorkbenchCombo)object).getId(), this.wbenchOld)) {
            descContainer.setParasItem(PARA_WORKBENCH, workbenchCombo.getId(), true);
            this.buttonModified = true;
            this.wbenchOld = workbenchCombo.getId();
            this.buttonWBModified = workbenchCombo;
        }
        this.dispose();
    }

    public boolean isButtonModified() {
        return this.buttonModified;
    }

    private void setModifyButtonEnabled(boolean bl) {
        this.btnModify.setEnabled(bl);
        this.enableModifyByValue(this.nameText.getText());
    }

    public WelcomeTextButton getImageButton() {
        return this.imageButton;
    }

    protected void createExeButton() {
        if (!ExecutableLinkDialog.checkPermittedPath(this.executionPathText.getText(), true)) {
            return;
        }
        ButtonValidationInfo buttonValidationInfo = WelcomeManager.validateInfo(this.nameText.getText().trim(), true);
        if (!buttonValidationInfo.isSuccess()) {
            OptionPane.showLineWrapOptionDialog(FrameworkUtilities.getMainFrame(), buttonValidationInfo.getErrMessage(), 1);
            return;
        }
        this.imageButton = this.createButton(ExecutableLinkDialog.getExeDesc(this.nameText.getText(), this.descriptionText.getText(), this.executionPathText.getText(), this.iconText.getText(), Integer.MAX_VALUE));
        this.dispose();
    }

    public static DescContainer getExeDesc(String string, String string2, String string3, String string4, int n) {
        CommStyleInfo commStyleInfo = new CommStyleInfo();
        AreaDescContainer areaDescContainer = new AreaDescContainer();
        DescContainer descContainer = new DescContainer("welcomebuttonsetting");
        DescContainer descContainer2 = new DescContainer(string);
        descContainer2.setParasItem(PARA_NAME, string, true);
        descContainer2.setParasItem(PARA_DESCRIPTION, string2, true);
        descContainer2.setParasItem(PARA_ICON, string4, true);
        descContainer2.setParasItem(PARA_COMMAND, string3, true);
        descContainer2.setParasItem(PARA_EXECUTABLE, "true", true);
        descContainer2.setParasItem(PARA_SERIAL, "" + n, true);
        descContainer2.setParasItem(PARA_SELECTED, "true", true);
        descContainer.addDescContainer(descContainer2);
        areaDescContainer.addDescContainer(descContainer);
        commStyleInfo.addAreaDescContainer(areaDescContainer);
        return commStyleInfo.getAreaDescContainer(0).getDescContainer(0).getDescContainer(0);
    }

    private WelcomeTextButton createButton(DescContainer descContainer) {
        if (this.draggable) {
            DraggableButton draggableButton = new DraggableButton(descContainer);
            draggableButton.initializeButton();
            return draggableButton;
        }
        WelcomeTextButton welcomeTextButton = new WelcomeTextButton(descContainer, ConfigUtilities.getDefaultIconSize());
        welcomeTextButton.initializeButton();
        return welcomeTextButton;
    }

    private JPanel getNamePanel() {
        JLabel jLabel = new JLabel(res.getString("ExecutableLink_Dialog_Name"));
        jLabel.setPreferredSize(new Dimension(74, 21));
        jLabel.setMaximumSize(new Dimension(74, 21));
        jLabel.setMinimumSize(new Dimension(74, 21));
        this.nameText = new CharInputTextField(1, 127, "");
        this.nameText.setText(this.name.trim());
        this.nameText.setTooltipEnabled(true);
        this.nameText.setName("ExecutableLink_Dialog_nameText");
        this.nameText.setMinimumSize(new Dimension(210, 21));
        this.nameText.setPreferredSize(new Dimension(210, 21));
        this.nameText.setMaximumSize(new Dimension(210, 21));
        this.nameText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                ExecutableLinkDialog.this.validateName(documentEvent);
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                ExecutableLinkDialog.this.validateName(documentEvent);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                ExecutableLinkDialog.this.validateName(documentEvent);
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(3, 1)));
        jPanel.add(this.nameText);
        this.nameTextOld = this.nameText.getText();
        return jPanel;
    }

    private JPanel getDescriptionPanel() {
        JLabel jLabel = new JLabel(res.getString("ExecutableLink_Dialog_Description"));
        jLabel.setMinimumSize(new Dimension(74, 21));
        jLabel.setMaximumSize(new Dimension(74, 21));
        jLabel.setPreferredSize(new Dimension(74, 21));
        this.descriptionText = new CharInputTextField(0, 127, "");
        this.descriptionText.setText(this.description);
        this.descriptionText.setTooltipEnabled(true);
        this.descriptionText.setName("ExecutableLink_Dialog_descriptionText");
        this.descriptionText.setMinimumSize(new Dimension(210, 21));
        this.descriptionText.setPreferredSize(new Dimension(210, 21));
        this.descriptionText.setMaximumSize(new Dimension(210, 21));
        this.descriptionText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                ExecutableLinkDialog.this.setModifyButtonEnabled(true);
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                ExecutableLinkDialog.this.setModifyButtonEnabled(true);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                ExecutableLinkDialog.this.setModifyButtonEnabled(true);
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(3, 1)));
        jPanel.add(this.descriptionText);
        this.descriptionTextOld = this.descriptionText.getText();
        return jPanel;
    }

    private JPanel getWorkbenchPanel() {
        Object object;
        JLabel jLabel = new JLabel(res.getString("Button_Move"));
        jLabel.setMinimumSize(new Dimension(74, 21));
        jLabel.setMaximumSize(new Dimension(74, 21));
        jLabel.setPreferredSize(new Dimension(74, 21));
        if (null != this.workbenchCombo) {
            this.workbenchList = new JComboBox<WorkbenchCombo>(this.workbenchCombo);
            object = WorkbenchCombo.getSelected(this.workbenchCombo);
            if (null != object) {
                this.workbenchList.setSelectedItem(object);
                this.wbenchOld = ((WorkbenchCombo)object).getId();
            }
            this.workbenchList.setRenderer(new TooltipListCellRenderer(this.workbenchList));
            this.workbenchList.setName("ModifyLink_Dialog_descriptionText");
            this.workbenchList.setMinimumSize(new Dimension(210, 21));
            this.workbenchList.setPreferredSize(new Dimension(210, 21));
            this.workbenchList.setMaximumSize(new Dimension(210, 21));
            this.workbenchList.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ExecutableLinkDialog.this.setModifyButtonEnabled(true);
                }
            });
        }
        object = new JPanel();
        ((Container)object).setLayout(new BoxLayout((Container)object, 0));
        ((Container)object).add(jLabel);
        ((Container)object).add(Box.createRigidArea(new Dimension(3, 1)));
        ((Container)object).add(this.workbenchList);
        return object;
    }

    private JPanel getExecutionPanel() {
        JLabel jLabel = new JLabel(res.getString("ExecutableLink_Dialog_ExecutablePath"));
        jLabel.setMinimumSize(new Dimension(74, 21));
        jLabel.setMaximumSize(new Dimension(74, 21));
        jLabel.setPreferredSize(new Dimension(74, 21));
        this.executionPathText = new JTextField(this.command);
        this.executionPathText.setName("ExecutableLink_Dialog_command");
        this.executionPathText.setMinimumSize(new Dimension(185, 21));
        this.executionPathText.setPreferredSize(new Dimension(185, 21));
        this.executionPathText.setMaximumSize(new Dimension(185, 21));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(3, 1)));
        jPanel.add(this.executionPathText);
        jPanel.add(Box.createRigidArea(new Dimension(3, 1)));
        JButton jButton = new JButton("...");
        jButton.setPreferredSize(new Dimension(20, 20));
        jButton.setMaximumSize(new Dimension(20, 20));
        jButton.setMinimumSize(new Dimension(20, 20));
        jButton.setName("ExecutableLink_Dialog_pathchooserBtn");
        jPanel.add(jButton);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExecutableLinkDialog.this.pathchooserBtnAction();
            }
        });
        this.executionPathText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                ExecutableLinkDialog.this.validateCommand(documentEvent);
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                ExecutableLinkDialog.this.validateCommand(documentEvent);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                ExecutableLinkDialog.this.validateCommand(documentEvent);
            }
        });
        this.executionPathOld = this.executionPathText.getText();
        return jPanel;
    }

    private void pathchooserBtnAction() {
        Object object;
        String string = this.executionPathText.getText();
        String string2 = System.getProperty("user.dir");
        if (null != string && string.trim().length() != 0) {
            object = new File(string);
            string2 = null != ((File)object).getName() && (string.lastIndexOf("\\") > 0 || string.lastIndexOf("/") > 0) ? string : System.getProperty("user.dir");
        }
        object = null;
        OpenFileChooser openFileChooser = new OpenFileChooser(string2);
        openFileChooser.setName("ExecutionPath_fileChooser");
        openFileChooser.setAcceptAllFileFilterUsed(true);
        openFileChooser.addChoosableFileFilter(FileChooser.BAT_FILECHOOSERFILTER);
        openFileChooser.addChoosableFileFilter(FileChooser.EXE_FILECHOOSERFILTER);
        if (openFileChooser.showDialog(FrameworkUtilities.getMainFrame(), res.getString("ExecutableLink_Dialog_Select")) == 0) {
            if (null != openFileChooser.getSelectedFile()) {
                object = openFileChooser.getSelectedFile().getPath();
            }
        } else {
            object = null;
        }
        if (null != object && ((String)object).length() > 0) {
            this.executionPathText.setText((String)object);
            this.executionPathText.setToolTipText((String)object);
        }
    }

    private JPanel getIconPanel() {
        JLabel jLabel = new JLabel(res.getString("ExecutableLink_Dialog_Icon"));
        jLabel.setMinimumSize(new Dimension(74, 21));
        jLabel.setPreferredSize(new Dimension(74, 21));
        jLabel.setMaximumSize(new Dimension(74, 21));
        if (null != this.imageButton) {
            this.icon = this.imageButton.getImagePath();
        }
        if (this.icon == null || this.icon.length() == 0) {
            this.icon = "default.gif";
        }
        this.iconText = new JTextField(this.icon);
        this.iconText.setName("ExecutableLink_Dialog_iconText");
        this.iconText.setMinimumSize(new Dimension(185, 21));
        this.iconText.setPreferredSize(new Dimension(185, 21));
        this.iconText.setMaximumSize(new Dimension(185, 21));
        this.iconText.setCaretPosition(0);
        JPanel jPanel = new JPanel();
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(3, 1)));
        jPanel.add(this.iconText);
        this.iconText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                ExecutableLinkDialog.this.setModifyButtonEnabled(true);
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                ExecutableLinkDialog.this.setModifyButtonEnabled(true);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                ExecutableLinkDialog.this.setModifyButtonEnabled(true);
            }
        });
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        JButton jButton = new JButton("...");
        jButton.setPreferredSize(new Dimension(20, 20));
        jButton.setMaximumSize(new Dimension(20, 20));
        jButton.setMinimumSize(new Dimension(20, 20));
        jButton.setName("ExecutableLink_Dialog_iconchooserBtn");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = WelcomeUtilities.showFileChooser(ExecutableLinkDialog.this.iconText.getText());
                if (null != string && string.length() > 0) {
                    ExecutableLinkDialog.this.iconText.setText(string);
                    if (null == ExecutableLinkDialog.this.imageButton) {
                        ExecutableLinkDialog.this.iconText.setToolTipText(string);
                    } else {
                        ExecutableLinkDialog.this.iconText.setToolTipText(ExecutableLinkDialog.this.imageButton.getImagePath());
                    }
                    ExecutableLinkDialog.this.setModifyButtonEnabled(true);
                }
            }
        });
        jPanel.add(Box.createRigidArea(new Dimension(3, 1)));
        jPanel.add(jButton);
        this.iconTextOld = this.iconText.getText();
        return jPanel;
    }

    public WorkbenchCombo modifiedWorkbench() {
        return this.buttonWBModified;
    }

    protected final boolean isIconModified() {
        return this.iconModified;
    }
}

