/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.windowmanagement.welcomepage;

import com.swimap.iview.commstyle.commini.AreaDescContainer;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.commini.xmlbind.PARA;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.framework.windowmanagement.welcomepage.IImportManager;
import com.swimap.iview.framework.windowmanagement.welcomepage.WelcomeManager;
import com.swimap.iview.framework.windowmanagement.welcomepage.WelcomePage;
import com.swimap.iview.framework.windowmanagement.welcomepage.WelcomeTextButton;
import com.swimap.iview.framework.windowmanagement.welcomepage.WorkbenchButton;
import com.swimap.iview.framework.windowmanagement.welcomepage.WorkbenchInfo;
import com.swimap.iview.framework.windowmanagement.welcomepage.WorkbenchManager;
import com.swimap.iview.util.OptionPane;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.log.IviewLogger;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;

public class DefaultImportManager
implements IImportManager {
    private static IviewLogger logger = IviewLogger.getLogger(DefaultImportManager.class, "IVIEW");
    public static final ResourceBundle RES = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/framework/windowmanagement/welcomepage/transfer/Res");
    private String filename = null;
    private final int MAX_NAME_LENGTH = 127;

    public DefaultImportManager(String string) {
        this.filename = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean importWorkbench() {
        block13: {
            try {
                this.setBusyCursor();
                CommStyleManager commStyleManager = CommStyleManager.getInstance();
                CommStyleInfo commStyleInfo = commStyleManager.getAbsCommStyleFile(this.filename);
                AreaDescContainer areaDescContainer = commStyleInfo.getAreaDescContainer(0);
                DescContainer descContainer = areaDescContainer.getDescContainer("workbenchsetting");
                DescContainer descContainer2 = areaDescContainer.getDescContainer("welcomebuttonsetting");
                DescContainer descContainer3 = descContainer.getDescContainer(0);
                String string = descContainer3.getDescName();
                String string2 = descContainer3.getParasItem("name").getValue();
                if (string2.length() > 127) {
                    logger.trace("Import workbench failed since namelength exceeds maximum name length");
                    OptionPane.showLineWrapOptionDialog(FrameworkUtilities.getMainFrame(), RES.getString("Import_Error") + " " + RES.getString("Max_Name_Length_Limit_Reached"), 0);
                    boolean bl = false;
                    return bl;
                }
                ArrayList<WorkbenchInfo> arrayList = WelcomeManager.getWorkbenchManager().getWorkbenchById(string);
                WorkbenchManager workbenchManager = WelcomeManager.getWorkbenchManager();
                if (arrayList.size() == 0) {
                    if (workbenchManager.isWorkBenchButtonExist(string2)) {
                        OptionPane.showLineWrapOptionDialog(FrameworkUtilities.getMainFrame(), RES.getString("Workbench_Button_Exist"), 0);
                        boolean bl = false;
                        return bl;
                    }
                    this.importNewWorkbench(descContainer3, descContainer2);
                    break block13;
                }
                WorkbenchButton workbenchButton = workbenchManager.getWorkBenchByName(string2);
                if (null != workbenchButton && workbenchButton != arrayList.get(0).getButton()) {
                    OptionPane.showLineWrapOptionDialog(FrameworkUtilities.getMainFrame(), RES.getString("Workbench_Button_Exist"), 0);
                    boolean bl = false;
                    return bl;
                }
                int n = OptionPane.showConfirmDialog(FrameworkUtilities.getMainFrame(), RES.getString("Confirm_import"), RES.getString("Confirm"), 0);
                if (n == 0) {
                    this.importExistingBench(descContainer3, descContainer2, arrayList.get(0));
                    break block13;
                }
                boolean bl = false;
                return bl;
            }
            catch (Exception exception) {
                this.showErrorDialog(exception);
                boolean bl = false;
                return bl;
            }
            finally {
                this.setDefaultCursor();
            }
        }
        return true;
    }

    private void showErrorDialog(Exception exception) {
        logger.trace("Error Occured while importing the workbench, please check below exception.");
        logger.trace(exception);
        OptionPane.showLineWrapOptionDialog(FrameworkUtilities.getMainFrame(), RES.getString("Import_Error"), 0);
    }

    private void setDefaultCursor() {
        logger.trace("Finished importing workbench from : " + (null == this.filename ? "" : this.filename));
        ScreenToolKit.setComponentCursorBusy(FrameworkUtilities.getMainFrame(), false);
        logger.trace("Importing finished, client default cursor set!");
    }

    private void setBusyCursor() {
        logger.trace("Started to import workbench from : " + (null == this.filename ? "" : this.filename));
        ScreenToolKit.setComponentCursorBusy(FrameworkUtilities.getMainFrame(), true);
        logger.trace("Importing in progress, client busy cursor set!");
    }

    private void importNewWorkbench(DescContainer descContainer, DescContainer descContainer2) {
        WorkbenchButton workbenchButton = this.importWorkbenchButton(descContainer);
        this.importWelcomeButtons(descContainer2);
        if (this.checkButtonExistsInPos(workbenchButton.getDescContainer())) {
            workbenchButton.setYPosition(-1);
        }
        workbenchButton.refreshButton(true);
        workbenchButton.setSaveRequired(true);
        if (workbenchButton.isSelected()) {
            workbenchButton.forceClick();
        }
    }

    private void importExistingBench(DescContainer descContainer, DescContainer descContainer2, WorkbenchInfo workbenchInfo) {
        JComponent jComponent;
        WorkbenchManager workbenchManager = WelcomeManager.getWorkbenchManager();
        WorkbenchButton workbenchButton = (WorkbenchButton)workbenchInfo.getButton();
        this.modifyExistingWorkbench(workbenchButton, descContainer);
        if (workbenchButton.isRemovable()) {
            workbenchButton.getDescContainer().setParasItem("dynamic", "true", true);
            jComponent = workbenchManager.getButtonPopupMenu(workbenchButton);
            workbenchButton.setPopupMenu((JPopupMenu)jComponent);
        }
        WorkbenchManager.deleteExistingButtons(workbenchInfo);
        this.importWelcomeButtons(descContainer2);
        if (this.checkButtonExistsInPos(workbenchButton.getDescContainer())) {
            workbenchButton.setYPosition(-1);
        }
        workbenchButton.refreshButton(false);
        workbenchButton.setSaveRequired(true);
        jComponent = workbenchManager.getSelectedWBench();
        if (workbenchButton.isSelected()) {
            workbenchButton.forceClick();
        } else if (null != jComponent && ((WorkbenchButton)jComponent).getWorkbenchId().equals(workbenchInfo.getId())) {
            ((WorkbenchButton)jComponent).forceClick();
        }
    }

    private boolean checkButtonExistsInPos(DescContainer descContainer) {
        String string = descContainer.getParasItemValue("yPosition");
        ArrayList<WorkbenchInfo> arrayList = WelcomeManager.getWorkbenchManager().getAllWorkbenches();
        WorkbenchButton workbenchButton = null;
        String string2 = null;
        for (WorkbenchInfo workbenchInfo : arrayList) {
            workbenchButton = (WorkbenchButton)workbenchInfo.getButton();
            string2 = workbenchButton.getDescContainer().getParasItemValue("yPosition");
            if (string == null || !string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    private void modifyExistingWorkbench(WorkbenchButton workbenchButton, DescContainer descContainer) {
        WorkbenchManager workbenchManager = WelcomeManager.getWorkbenchManager();
        WelcomePage welcomePage = WelcomeManager.getWelcomeRef();
        boolean bl = Boolean.valueOf(descContainer.getParasItemValue("isSelected"));
        if (bl && !workbenchButton.isSelected()) {
            workbenchManager.fireWorkbenchEvent(workbenchButton, 0);
        }
        boolean bl2 = false;
        DescContainer descContainer2 = workbenchButton.getDescContainer();
        ArrayList arrayList = descContainer.getPARAS().getPARAArrayList();
        for (PARA pARA : arrayList) {
            String string = pARA.getName();
            String string2 = pARA.getValue();
            String string3 = descContainer2.getParasItemValue(string);
            if (!string.equals("isSelected") && null != string2 && !string2.equals(string3)) {
                bl2 = true;
            }
            descContainer2.setParasItem(string, string2, true);
        }
        welcomePage.setMergedSettings(workbenchButton, descContainer2);
        if (bl2) {
            workbenchManager.fireWorkbenchEvent(workbenchButton, 1);
        }
    }

    private WorkbenchButton importWorkbenchButton(DescContainer descContainer) {
        WorkbenchManager workbenchManager = WelcomeManager.getWorkbenchManager();
        CommStyleInfo commStyleInfo = WorkbenchManager.getCreatedImportCommStyle();
        DescContainer descContainer2 = commStyleInfo.getAreaDescContainer(0).getDescContainer("workbenchsetting");
        descContainer2.addDescContainer(descContainer);
        descContainer.setParasItem("dynamic", "true", true);
        WorkbenchButton workbenchButton = null;
        workbenchButton = workbenchManager.createWBButton(descContainer, commStyleInfo, true);
        if (null != workbenchButton) {
            workbenchManager.addWorkbenchference(workbenchButton);
            workbenchManager.fireWorkbenchEvent(workbenchButton, 0);
        }
        return workbenchButton;
    }

    private void importWelcomeButtons(DescContainer descContainer) {
        WorkbenchManager workbenchManager = WelcomeManager.getWorkbenchManager();
        WelcomePage welcomePage = WelcomeManager.getWelcomeRef();
        CommStyleInfo commStyleInfo = WorkbenchManager.getCreatedImportCommStyle();
        DescContainer descContainer2 = commStyleInfo.getAreaDescContainer(0).getDescContainer("welcomebuttonsetting");
        WelcomeTextButton welcomeTextButton = null;
        for (DescContainer descContainer3 : descContainer.getDescContainer()) {
            descContainer2.addDescContainer(descContainer3);
            welcomeTextButton = welcomePage.importButton(descContainer3);
            if (null == welcomeTextButton) continue;
            workbenchManager.fireWelcomeButtonEvent(welcomeTextButton, 0);
        }
        welcomePage.clearFilteredCommandList();
    }
}

