/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.windowmanagement.welcomepage;

import com.swimap.iview.commstyle.commini.AreaDescContainer;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.framework.windowmanagement.welcomepage.IExportManager;
import com.swimap.iview.framework.windowmanagement.welcomepage.WelcomeButtonInfo;
import com.swimap.iview.framework.windowmanagement.welcomepage.WelcomeManager;
import com.swimap.iview.framework.windowmanagement.welcomepage.WorkbenchButton;
import com.swimap.iview.framework.windowmanagement.welcomepage.WorkbenchInfo;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.log.IviewLogger;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class DefaultExportManager
implements IExportManager {
    private static IviewLogger logger = IviewLogger.getLogger(DefaultExportManager.class, "IVIEW");
    private WorkbenchButton button = null;
    private String filename = null;

    public DefaultExportManager(WorkbenchButton workbenchButton, String string) {
        this.button = workbenchButton;
        this.filename = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exportWorkbench() {
        boolean bl = false;
        if (null != this.button) {
            try {
                this.setBusyCursor();
                CommStyleInfo commStyleInfo = new CommStyleInfo();
                CommStyleManager commStyleManager = CommStyleManager.getInstance();
                commStyleInfo.addAreaDescContainer(this.getExportData());
                commStyleInfo.setFileName(this.filename);
                commStyleManager.write(commStyleInfo);
                bl = true;
            }
            finally {
                this.setDefaultCursor();
            }
        }
        return bl;
    }

    private void setDefaultCursor() {
        logger.trace("Finished exporting workbench to : " + (null == this.filename ? "" : this.filename));
        ScreenToolKit.setComponentCursorBusy(FrameworkUtilities.getMainFrame(), false);
        logger.trace("Exporting finished, client default cursor set!");
    }

    private void setBusyCursor() {
        logger.trace("Started to export workbench to : " + (null == this.filename ? "" : this.filename));
        ScreenToolKit.setComponentCursorBusy(FrameworkUtilities.getMainFrame(), true);
        logger.trace("Exporting in progress, client busy cursor set!");
    }

    private AreaDescContainer getExportData() {
        AreaDescContainer areaDescContainer = new AreaDescContainer();
        areaDescContainer.addDescContainer(this.getWbenchSettings());
        areaDescContainer.addDescContainer(this.getButtonSettings());
        return areaDescContainer;
    }

    private DescContainer getButtonSettings() {
        String string = this.button.getWorkbenchId();
        DescContainer descContainer = new DescContainer();
        descContainer.setDescName("welcomebuttonsetting");
        DescContainer descContainer2 = null;
        String string2 = null;
        Properties properties = null;
        String string32 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        ArrayList<WorkbenchInfo> arrayList = WelcomeManager.getWorkbenchManager().getWorkbenchById(string);
        if (arrayList.size() > 0) {
            WorkbenchInfo workbenchInfo = arrayList.get(0);
            ArrayList<WelcomeButtonInfo> arrayList2 = workbenchInfo.getAllWelcomeButtons();
            for (WelcomeButtonInfo welcomeButtonInfo : arrayList2) {
                descContainer2 = new DescContainer();
                descContainer2.setDescName(welcomeButtonInfo.getId());
                descContainer2.setParasItem("imported", Boolean.toString(true), true);
                descContainer2.setParasItem("name", welcomeButtonInfo.getFullName(), true);
                descContainer2.setParasItem("description", welcomeButtonInfo.getDescription(), true);
                descContainer2.setParasItem("isUserEnable", Boolean.toString(welcomeButtonInfo.isUserEnabled()), true);
                descContainer2.setParasItem("isRemovable", Boolean.toString(welcomeButtonInfo.isRemovable()), true);
                descContainer2.setParasItem("serialnumber", welcomeButtonInfo.getSerialNumber() + "", true);
                descContainer2.setParasItem("workbenchid", string, true);
                descContainer2.setParasItem("command", welcomeButtonInfo.getCommand(), true);
                descContainer2.setParasItem("xIndex", welcomeButtonInfo.getXIndex() + "", true);
                descContainer2.setParasItem("yIndex", welcomeButtonInfo.getYIndex() + "", true);
                descContainer2.setParasItem("icon", welcomeButtonInfo.getIconInfo(), true);
                descContainer2.setParasItem("isExecutable", Boolean.toString(welcomeButtonInfo.isExecutable()), true);
                descContainer2.setParasItem("isSelected", Boolean.toString(welcomeButtonInfo.isSelected()), true);
                Map<String, String> map = welcomeButtonInfo.getExtButtonInfo();
                Set<Map.Entry<String, String>> set = map.entrySet();
                for (Map.Entry<String, String> entry : set) {
                    descContainer2.setParasItem(entry.getKey(), entry.getValue(), true);
                }
                string2 = welcomeButtonInfo.getCategory();
                if (null != string2 && string2.trim().length() > 0) {
                    descContainer2.setParasItem("category", string2, true);
                }
                if (null != welcomeButtonInfo.getActionName()) {
                    descContainer2.setParasItem("action", welcomeButtonInfo.getActionName(), true);
                }
                if ((properties = welcomeButtonInfo.getProperties()).size() > 0) {
                    DescContainer descContainer3 = new DescContainer();
                    descContainer3.setDescName("properties");
                    for (String string32 : properties.keySet()) {
                        string4 = properties.getProperty(string32);
                        descContainer3.setParasItem(string32, string4, true);
                    }
                    descContainer2.addDescContainer(descContainer3);
                }
                string5 = welcomeButtonInfo.getPluginName();
                string6 = welcomeButtonInfo.getExportedPluginName();
                if (null != string5 && string5.length() > 0) {
                    descContainer2.setParasItem("exportedPluginName", string5, true);
                } else if (null != string6 && string6.length() > 0) {
                    descContainer2.setParasItem("exportedPluginName", string6, true);
                }
                descContainer.addDescContainer(descContainer2);
            }
        }
        return descContainer;
    }

    private DescContainer getWbenchSettings() {
        DescContainer descContainer = new DescContainer();
        descContainer.setDescName("workbenchsetting");
        DescContainer descContainer2 = new DescContainer();
        descContainer2.setDescName(this.button.getWorkbenchId());
        descContainer2.setParasItem("imported", Boolean.toString(true), true);
        descContainer2.setParasItem("name", this.button.getFullName(), true);
        descContainer2.setParasItem("description", this.button.getDescription(), true);
        descContainer2.setParasItem("isUserEnable", Boolean.toString(this.button.isUserEnable()), true);
        descContainer2.setParasItem("isRemovable", Boolean.toString(this.button.isRemovable()), true);
        descContainer2.setParasItem("isSelected", Boolean.toString(this.button.isSelected()), true);
        descContainer2.setParasItem("serialnumber", "2147483647", true);
        descContainer2.setParasItem("background", this.button.getBackgroundInfo(), true);
        descContainer2.setParasItem("category", this.button.getCategory(), true);
        descContainer2.setParasItem("icon", this.button.getIconInfo(), true);
        descContainer2.setParasItem("yPosition", this.button.getYPosition() + "", true);
        String string = this.button.getPluginName();
        String string2 = this.button.getExportedPluginName();
        if (null != string && string.length() > 0) {
            descContainer2.setParasItem("exportedPluginName", string, true);
        } else if (null != string2 && string2.length() > 0) {
            descContainer2.setParasItem("exportedPluginName", string2, true);
        }
        descContainer.addDescContainer(descContainer2);
        return descContainer;
    }
}

