/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.windowmanagement.welcomepage;

import com.swimap.iview.commstyle.commini.AreaDescContainer;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.framework.windowmanagement.welcomepage.ConfigUtilities;
import com.swimap.iview.framework.windowmanagement.welcomepage.WelcomeUtilities;
import com.swimap.iview.framework.windowmanagement.welcomepage.WorkbenchManager;
import com.swimap.iview.templates.textfield.CharInputTextField;
import com.swimap.iview.util.OptionPane;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.helpmanagement.HelpManager;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.UUID;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class CreateWorkbenchDialog
extends JDialog {
    private static final long serialVersionUID = -840738711197953853L;
    private static IviewLogger logger = IviewLogger.getLogger(CreateWorkbenchDialog.class, "IVIEW");
    private static ResourceBundle res = WelcomeUtilities.res;
    private static final int DIALOG_WIDTH = 330;
    private static final int DIALOG_HEIGHT = 200;
    private static final int COMPONENT_WIDTH = 80;
    private static final int COMPONENT_HEIGHT = 21;
    private static final int LABEL_WIDTH = 78;
    private static final int TEXT_WIDTH = 210;
    private static final int MAX_TEXT_LENGTH = 127;
    private static final int MIN_TEXT_LENGTH_DES = 0;
    private static final int MIN_TEXT_LENGTH = 1;
    private CharInputTextField nameText = null;
    private CharInputTextField descriptionText = null;
    private JTextField iconText = null;
    private JTextField backgroundText = null;
    private DescContainer benchDesc = null;
    private JButton btnCreate = null;
    private WorkbenchManager wbManager = null;

    public CreateWorkbenchDialog(Window window, ArrayList<String> arrayList, WorkbenchManager workbenchManager) {
        super(window);
        this.wbManager = workbenchManager;
        this.setModal(true);
        this.setTitle(res.getString("Create_Workbench"));
        this.jbInit();
        HelpManager helpManager = HelpManager.getInstance();
        helpManager.enableHelpKey(this.getRootPane(), "iVIEW.WelcomePage.CreateWorkbenchDialog");
    }

    private void jbInit() {
        this.setSize(new Dimension(330, 200));
        JPanel jPanel = this.createInputPanel();
        JPanel jPanel2 = this.createButtonPanel();
        this.getContentPane().add((Component)jPanel, "Center");
        this.getContentPane().add((Component)jPanel2, "South");
        this.setResizable(false);
        this.pack();
        ScreenToolKit.centerLocateToScreen(this);
    }

    private JPanel createInputPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setName("Workbench_Link_Dlg_panel");
        jPanel.add((Component)this.getNamePanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(12, 12, 0, 12), 0, 0));
        jPanel.add((Component)this.getDescriptionPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 2, new Insets(5, 12, 0, 12), 0, 0));
        jPanel.add((Component)this.getIconPanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 2, new Insets(5, 12, 0, 12), 0, 0));
        jPanel.add(this.getBackgroundPanel(), new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 2, new Insets(5, 12, 0, 12), 0, 0));
        return jPanel;
    }

    private Component getBackgroundPanel() {
        JLabel jLabel = new JLabel(res.getString("CreateBench_Dialog_bacground"));
        jLabel.setMinimumSize(new Dimension(78, 21));
        jLabel.setPreferredSize(new Dimension(78, 21));
        jLabel.setMaximumSize(new Dimension(78, 21));
        String string = this.getDefaultImage();
        this.backgroundText = new JTextField(string);
        this.backgroundText.setName("Workbench_Dialog_iconText");
        this.backgroundText.setMinimumSize(new Dimension(185, 21));
        this.backgroundText.setPreferredSize(new Dimension(185, 21));
        this.backgroundText.setMaximumSize(new Dimension(185, 21));
        this.backgroundText.setEditable(false);
        this.backgroundText.setBackground(Color.WHITE);
        JPanel jPanel = new JPanel();
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(3, 1)));
        jPanel.add(this.backgroundText);
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        JButton jButton = new JButton("...");
        jButton.setPreferredSize(new Dimension(20, 20));
        jButton.setMaximumSize(new Dimension(20, 20));
        jButton.setMinimumSize(new Dimension(20, 20));
        jButton.setName("Workbench_Dialog_iconchooserBtn");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = WelcomeUtilities.showFileChooser(CreateWorkbenchDialog.this.backgroundText.getText());
                if (null != string && string.length() > 0) {
                    CreateWorkbenchDialog.this.backgroundText.setText(string);
                    CreateWorkbenchDialog.this.backgroundText.setToolTipText(string);
                }
            }
        });
        jPanel.add(Box.createRigidArea(new Dimension(3, 1)));
        jPanel.add(jButton);
        return jPanel;
    }

    protected String getDefaultImage() {
        String string = "";
        try {
            File file;
            ImageIcon imageIcon = ConfigUtilities.getWelcomeImage();
            URL uRL = new URL(imageIcon.getDescription());
            String string2 = uRL.toURI().getPath();
            if (null != string2 && (file = new File(string2)).exists()) {
                string = file.getAbsolutePath();
            }
        }
        catch (Exception exception) {
            string = "";
        }
        return string;
    }

    private void validateName(DocumentEvent documentEvent) {
        Document document = documentEvent.getDocument();
        String string = null;
        try {
            string = document.getText(0, document.getLength());
        }
        catch (BadLocationException badLocationException) {
            logger.trace(badLocationException.getMessage(), badLocationException);
        }
        boolean bl = null != string && string.trim().length() > 0;
        this.btnCreate.setEnabled(bl);
    }

    private JPanel createButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setName("Workbench_Link_Dlg_btn_panel");
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        this.btnCreate = new JButton(res.getString("TreeDialog_Create"));
        this.btnCreate.setMnemonic('C');
        this.btnCreate.setName("Workbench_Link_Dlg_Create_Btn");
        this.btnCreate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CreateWorkbenchDialog.this.createWorkbenchButtonDesc();
            }
        });
        this.btnCreate.setPreferredSize(new Dimension(80, 21));
        this.btnCreate.setEnabled(false);
        JButton jButton = new JButton(res.getString("TreeDialog_Cancel"));
        jButton.setName("Workbench_Link_Dlg_CANCEL_Btn");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CreateWorkbenchDialog.this.benchDesc = null;
                CreateWorkbenchDialog.this.removeAll();
                CreateWorkbenchDialog.this.dispose();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                CreateWorkbenchDialog.this.benchDesc = null;
                CreateWorkbenchDialog.this.removeAll();
                CreateWorkbenchDialog.this.dispose();
            }
        });
        jButton.setPreferredSize(new Dimension(80, 21));
        FlowLayout flowLayout = new FlowLayout(2);
        flowLayout.setHgap(4);
        jPanel2.setLayout(flowLayout);
        jPanel2.add(this.btnCreate);
        jPanel2.add(jButton);
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        jPanel.add((Component)jPanel3, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 17, 7, 12), 0, 0));
        jPanel.add((Component)jPanel2, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 22, 2, new Insets(5, 17, 7, 8), 0, 0));
        ScreenToolKit.setDefaultButtons(this.btnCreate, jButton);
        return jPanel;
    }

    protected void createWorkbenchButtonDesc() {
        String string = this.nameText.getText().trim();
        if (this.wbManager.isWorkBenchButtonExist(string)) {
            String string2 = res.getString("Workbench_Button_Exist");
            OptionPane.showLineWrapOptionDialog(FrameworkUtilities.getMainFrame(), string2, 1);
            return;
        }
        this.benchDesc = this.getWbenchDesc(string, this.descriptionText.getText(), this.iconText.getText(), this.backgroundText.getText());
        this.dispose();
    }

    public DescContainer getWorkbenchButtonDesc() {
        return this.benchDesc;
    }

    private DescContainer getWbenchDesc(String string, String string2, String string3, String string4) {
        CommStyleInfo commStyleInfo = new CommStyleInfo();
        AreaDescContainer areaDescContainer = new AreaDescContainer();
        DescContainer descContainer = new DescContainer("workbenchsetting");
        String string5 = this.getUniqueWorkbenchId();
        DescContainer descContainer2 = new DescContainer(string5);
        descContainer2.setParasItem("name", string, true);
        descContainer2.setParasItem("description", string2, true);
        descContainer2.setParasItem("icon", string3, true);
        descContainer2.setParasItem("dynamic", "true", true);
        descContainer2.setParasItem("background", string4, true);
        descContainer2.setParasItem("serialnumber", "2147483647", true);
        descContainer2.setParasItem("isSelected", "true", true);
        descContainer.addDescContainer(descContainer2);
        areaDescContainer.addDescContainer(descContainer);
        commStyleInfo.addAreaDescContainer(areaDescContainer);
        return commStyleInfo.getAreaDescContainer(0).getDescContainer(0).getDescContainer(0);
    }

    private String getUniqueWorkbenchId() {
        UUID uUID = UUID.randomUUID();
        String string = "_dynamic_iview_workbench_" + uUID.toString();
        return string;
    }

    private JPanel getNamePanel() {
        JLabel jLabel = new JLabel(res.getString("ExecutableLink_Dialog_Name"));
        jLabel.setPreferredSize(new Dimension(78, 21));
        jLabel.setMaximumSize(new Dimension(78, 21));
        jLabel.setMinimumSize(new Dimension(78, 21));
        this.nameText = new CharInputTextField(1, 127, "");
        this.nameText.setTooltipEnabled(true);
        this.nameText.setName("Workbench_Dialog_nameText");
        this.nameText.setMinimumSize(new Dimension(210, 21));
        this.nameText.setPreferredSize(new Dimension(210, 21));
        this.nameText.setMaximumSize(new Dimension(210, 21));
        this.nameText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                CreateWorkbenchDialog.this.validateName(documentEvent);
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                CreateWorkbenchDialog.this.validateName(documentEvent);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                CreateWorkbenchDialog.this.validateName(documentEvent);
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(3, 1)));
        jPanel.add(this.nameText);
        return jPanel;
    }

    private JPanel getDescriptionPanel() {
        JLabel jLabel = new JLabel(res.getString("ExecutableLink_Dialog_Description"));
        jLabel.setMinimumSize(new Dimension(78, 21));
        jLabel.setMaximumSize(new Dimension(78, 21));
        jLabel.setPreferredSize(new Dimension(78, 21));
        this.descriptionText = new CharInputTextField(0, 127, "");
        this.descriptionText.setTooltipEnabled(true);
        this.descriptionText.setName("ExecutableLink_Dialog_descriptionText");
        this.descriptionText.setMinimumSize(new Dimension(210, 21));
        this.descriptionText.setPreferredSize(new Dimension(210, 21));
        this.descriptionText.setMaximumSize(new Dimension(210, 21));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(3, 1)));
        jPanel.add(this.descriptionText);
        return jPanel;
    }

    private JPanel getIconPanel() {
        JLabel jLabel = new JLabel(res.getString("ExecutableLink_Dialog_Icon"));
        jLabel.setMinimumSize(new Dimension(78, 21));
        jLabel.setPreferredSize(new Dimension(78, 21));
        jLabel.setMaximumSize(new Dimension(78, 21));
        String string = "default_wbench_created.png";
        this.iconText = new JTextField(string);
        this.iconText.setName("Workbench_Dialog_iconText");
        this.iconText.setMinimumSize(new Dimension(185, 21));
        this.iconText.setPreferredSize(new Dimension(185, 21));
        this.iconText.setMaximumSize(new Dimension(185, 21));
        this.iconText.setEditable(false);
        this.iconText.setBackground(Color.WHITE);
        JPanel jPanel = new JPanel();
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(3, 1)));
        jPanel.add(this.iconText);
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        JButton jButton = new JButton("...");
        jButton.setPreferredSize(new Dimension(20, 20));
        jButton.setMaximumSize(new Dimension(20, 20));
        jButton.setMinimumSize(new Dimension(20, 20));
        jButton.setName("Workbench_Dialog_iconchooserBtn");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = WelcomeUtilities.showFileChooser(CreateWorkbenchDialog.this.iconText.getText());
                if (null != string && string.length() > 0) {
                    CreateWorkbenchDialog.this.iconText.setText(string);
                    CreateWorkbenchDialog.this.iconText.setToolTipText(string);
                }
            }
        });
        jPanel.add(Box.createRigidArea(new Dimension(3, 1)));
        jPanel.add(jButton);
        return jPanel;
    }
}

