/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.windowmanagement.welcomepage;

import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.framework.subsystemmanagement.SubsystemManager;
import com.swimap.iview.framework.util.ResourceAdapter;
import com.swimap.iview.framework.windowmanagement.welcomepage.WelcomePage;
import com.swimap.iview.util.adapter.TypeConverter;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Dimension;
import javax.swing.ImageIcon;

public final class ConfigUtilities {
    private static final IviewLogger logger = IviewLogger.getLogger(ConfigUtilities.class, "IVIEW");
    private static final String PAGE_SETTING_DESC = "pagesetting";
    private static final String PARA_isEnableWelcomePage = "isEnableWelcomePage";
    private static final String PARA_isEnableAfterRelogin = "isEnableAfterRelogin";
    private static final String PARA_welcomeImage = "welcomeImage";
    private static final String PARA_welcomepagetitle = "welcomepagetitle";
    private static final String PARA_isWorkBenchCloseable = "isWorkBenchCloseable";
    private static final String PARA_LAYOUT_TYPE = "welcomepagelayout";
    private static final String PARA_ENABLE_MENU_COPY = "enableMenuCopy";
    private static final String DEFAULT_TITLE = "Welcome";
    private static boolean m_isEnableWelcomePage = false;
    private static Dimension iconSize = new Dimension(65, 65);
    private static ImageIcon m_welcomeImage = null;
    private static ImageIcon m_workbenchImage = null;
    private static boolean m_isEnableAfterRelogin = false;
    private static String m_title = "Welcome";
    private static boolean m_isWorkBenchCloseable = true;
    private static int layoutType = 2;
    private static boolean enableMenuCopy = false;

    static void readWelcomePageSetting() {
        CommStyleManager commStyleManager = CommStyleManager.getInstance();
        CommStyleInfo commStyleInfo = commStyleManager.getDefaultProductCommonStyleFile("conf/mainfrm/welcomepagesetting");
        SubsystemManager subsystemManager = SubsystemManager.getInstance();
        if (null != commStyleInfo) {
            String string;
            Object object;
            Object object2;
            Object object3;
            DescContainer descContainer = commStyleInfo.getAreaDescContainer(0).getDescContainer(PAGE_SETTING_DESC);
            CommStyleInfo commStyleInfo2 = commStyleManager.getUserCommonStyleFile("conf/mainfrm/welcomepagesetting");
            if (null != commStyleInfo2) {
                object3 = commStyleInfo2.getAreaDescContainer(0).getDescContainer(PAGE_SETTING_DESC);
                m_isEnableWelcomePage = Boolean.valueOf(((DescContainer)object3).getParasItemValue(PARA_isEnableWelcomePage));
            } else {
                m_isEnableWelcomePage = Boolean.valueOf(descContainer.getParasItemValue(PARA_isEnableWelcomePage));
            }
            iconSize = ConfigUtilities.toDimension(descContainer.getParasItemValue("buttonSize"), new Dimension(65, 65));
            m_isEnableAfterRelogin = Boolean.valueOf(descContainer.getParasItemValue(PARA_isEnableAfterRelogin));
            object3 = descContainer.getParasItemValue(PARA_welcomeImage);
            if (subsystemManager.getClientLoadMode() == SubsystemManager.LoadMode.complex) {
                object2 = ResourceMng.getInstance();
                object = ((ResourceMng)object2).getSkinImage((String)object3);
                if (null == object) {
                    m_welcomeImage = (ImageIcon)((ResourceMng)object2).getIconDirect((String)object3);
                    m_workbenchImage = (ImageIcon)((ResourceMng)object2).getIconDirect((String)object3);
                } else {
                    m_welcomeImage = object;
                    m_workbenchImage = ((ResourceMng)object2).getSkinImage((String)object3);
                }
            }
            if (null == (m_title = descContainer.getParasItemValue(PARA_welcomepagetitle)) || m_title.length() == 0) {
                m_title = DEFAULT_TITLE;
            }
            if (null != (object2 = descContainer.getParasItemValue(PARA_isWorkBenchCloseable))) {
                m_isWorkBenchCloseable = Boolean.valueOf((String)object2);
            }
            try {
                layoutType = Integer.parseInt(descContainer.getParasItemValue(PARA_LAYOUT_TYPE));
                if (layoutType < 0 || layoutType > 2) {
                    logger.trace("Input parameter for layout is : " + layoutType + " and it is not in the specified range ");
                    layoutType = 2;
                }
            }
            catch (NumberFormatException numberFormatException) {
                logger.trace("Input parameter for layout cant be null or \" \" or String type" + numberFormatException);
                layoutType = 2;
            }
            object = null;
            try {
                object = WelcomePage.res.getString(m_title);
            }
            catch (Exception exception) {
                logger.trace("Resource string not found." + exception);
            }
            if (null != object) {
                m_title = object;
            }
            if (null != (string = descContainer.getParasItemValue(PARA_ENABLE_MENU_COPY)) && layoutType == 2) {
                enableMenuCopy = Boolean.valueOf(string.trim());
            }
        }
        if (subsystemManager.getClientLoadMode() == SubsystemManager.LoadMode.single) {
            m_welcomeImage = ResourceAdapter.getWelcomeImage();
            m_workbenchImage = ResourceAdapter.getWelcomeImage();
        }
    }

    private static Dimension toDimension(String string, Dimension dimension) {
        int[] nArray = TypeConverter.toIntList(string, ',', null);
        if (nArray != null && nArray.length == 2 && nArray[0] >= dimension.width && nArray[1] >= dimension.height) {
            return new Dimension(nArray[0], nArray[1]);
        }
        return dimension;
    }

    public static boolean isDraggableLayout() {
        return 2 == layoutType;
    }

    static int getLayoutType() {
        return layoutType;
    }

    static String getWelcomePageTitle() {
        return m_title;
    }

    static boolean isWorkbenchCloseable() {
        return m_isWorkBenchCloseable;
    }

    static ImageIcon getWelcomeImage() {
        return m_welcomeImage;
    }

    static ImageIcon getWorkbenchImage() {
        return m_workbenchImage;
    }

    static boolean isEnableAfterRelogin() {
        return m_isEnableAfterRelogin;
    }

    static boolean isEnableWelcomePage() {
        return m_isEnableWelcomePage;
    }

    public static boolean isEnableMenuCopy() {
        return enableMenuCopy;
    }

    public static Dimension getDefaultIconSize() {
        return iconSize;
    }
}

