/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.windowmanagement.welcomepage;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;

public final class CategorySettings {
    private static CategorySettings settings = null;
    private Category rootCategory = new Category();
    private static final int ARRAY_CAPACITY = 10;

    private CategorySettings() {
    }

    public static CategorySettings getInstance() {
        if (null == settings) {
            settings = new CategorySettings();
        }
        return settings;
    }

    public void addCategoryInfo(String string, String string2, String string3, String string4) {
        this.addCategoryInfo(string, string2, string3, string4, Integer.MAX_VALUE);
    }

    public void addCategoryInfo(String string, String string2, String string3, String string4, int n) {
        Category category = new Category(string, string2, string3, n);
        if (null == string3) {
            this.rootCategory.addChild(category);
        } else {
            Category category2 = this.findCategory(this.rootCategory, string);
            if (null == category2) {
                Category category3 = this.findCategory(this.rootCategory, string3);
                if (null != category3) {
                    category3.addChild(category);
                } else {
                    category3 = new Category(string3, string4, null, n);
                    category3.addChild(category);
                    this.rootCategory.addChild(category3);
                }
            } else if (null == category2.getParentName()) {
                category2.seqNumber = n;
                Category category4 = this.findCategory(this.rootCategory, string3);
                if (null == category4) {
                    category4 = new Category(string3, string4, null, n);
                    category4.addChild(category2);
                    this.rootCategory.addChild(category4);
                } else {
                    category4.addChild(category2);
                }
            }
        }
    }

    private Category findCategory(Category category, String string) {
        Category category2 = null;
        if (0 < category.childrens.size()) {
            for (Category category3 : category.childrens) {
                if (category3.name.equals(string)) {
                    category2 = category3;
                    break;
                }
                category2 = this.findCategory(category3, string);
                if (null == category2) continue;
                break;
            }
        }
        return category2;
    }

    public ArrayList<Category> getParentNodes(String string) {
        Category category;
        ArrayList<Category> arrayList = new ArrayList<Category>(10);
        if (0 < this.rootCategory.childrens.size() && null != (category = this.findCategory(this.rootCategory, string))) {
            while (null != category.name) {
                arrayList.add(category);
                category = category.getParentCategory();
            }
            Collections.reverse(arrayList);
        }
        return arrayList;
    }

    int findCategorySerialNumber(String string) {
        Category category = this.findCategory(this.rootCategory, string);
        if (null != category) {
            return category.getCategorySeqNumber();
        }
        return Integer.MAX_VALUE;
    }

    public Category getNewCatergory(String string, String string2, String string3, int n) {
        return new Category(string, string2, string3, n);
    }

    static void clear() {
        settings = null;
    }

    class Category {
        private String name = null;
        private String resName = null;
        private String parentName = null;
        private Category parentCategory = null;
        private LinkedHashSet<Category> childrens = new LinkedHashSet();
        private int seqNumber = Integer.MAX_VALUE;

        Category() {
        }

        Category(String string, String string2, String string3, int n) {
            this.name = string;
            this.resName = string2;
            if (null == this.resName) {
                this.resName = this.name;
            }
            this.parentName = string3;
            this.seqNumber = n;
        }

        public String getName() {
            return this.name;
        }

        public String getParentName() {
            return this.parentName;
        }

        public Category getParentCategory() {
            return this.parentCategory;
        }

        public boolean equals(Object object) {
            if (object instanceof Category) {
                Category category = (Category)object;
                if (null != this.name && this.name.equals(category.name)) {
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            return this.resName;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public void addChild(Category category) {
            if (!this.childrens.contains(category)) {
                this.childrens.add(category);
                if (null != category.parentCategory) {
                    for (Category category2 : category.parentCategory.childrens) {
                        if (!category2.equals(category)) continue;
                        category.parentCategory.childrens.remove(category2);
                        break;
                    }
                }
                category.parentCategory = this;
                category.parentName = this.name;
            } else {
                for (Category category3 : this.childrens) {
                    if (!category3.equals(category)) continue;
                    category3.seqNumber = category.seqNumber;
                    break;
                }
            }
        }

        public int getCategorySeqNumber() {
            return this.seqNumber;
        }
    }
}

