/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.windowmanagement.welcomepage;

import com.swimap.iview.framework.windowmanagement.welcomepage.draggable.DraggableButton;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;

public class ButtonClipboard
implements ClipboardOwner {
    private Clipboard clipbboard = new Clipboard("ButtonClipboard");
    public static final int COPY = 0;
    public static final int CUT = 1;
    private int clipboardType = -1;

    ButtonClipboard() {
    }

    void cutButton(DraggableButton draggableButton) {
        this.changeClipboard(draggableButton);
        draggableButton.setTransparency(true);
        this.clipboardType = 1;
    }

    void copyButton(DraggableButton draggableButton) {
        this.changeClipboard(draggableButton);
        this.clipboardType = 0;
    }

    private void changeClipboard(DraggableButton draggableButton) {
        this.clearClipboard();
        this.clipbboard.setContents(draggableButton, this);
    }

    DraggableButton getClipboardButton() {
        Transferable transferable = this.clipbboard.getContents(this);
        if (transferable instanceof DraggableButton) {
            return (DraggableButton)transferable;
        }
        return null;
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    int getClipboardType() {
        return this.clipboardType;
    }

    void clearClipboard() {
        this.clipboardType = -1;
        DraggableButton draggableButton = this.getClipboardButton();
        if (null != draggableButton) {
            draggableButton.setTransparency(false);
        }
        this.clipbboard.setContents(null, this);
    }
}

