/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.windowmanagement.welcomepage;

import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.commstyle.resource.i18n.ResourceUtil;
import com.swimap.iview.framework.windowmanagement.welcomepage.CategorySettings;
import com.swimap.iview.framework.windowmanagement.welcomepage.WelcomeTextButton;
import com.swimap.iview.framework.windowmanagement.welcomepage.WorkbenchButton;
import com.swimap.iview.framework.windowmanagement.welcomepage.draggable.DraggableButton;
import com.swimap.iview.templates.textfield.CharInputTextField;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.helpmanagement.HelpManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class AddLinkDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/framework/windowmanagement/welcomepage/Res");
    private JButton btnCreate = null;
    private JTree tree = null;
    private static final int DIALOG_WIDTH = 425;
    private static final int DIALOG_HEIGHT = 330;
    private static final int BUTTON_WIDTH = 80;
    private static final int BUTTON_HEIGHT = 21;
    private static final int SB_INITIAL_CAPACITY = 1;
    private ArrayList<WelcomeTextButton> selectedButtons = new ArrayList(1);
    public static final int NORMAL_BUTTON = 0;
    public static final int DRAGGABLE_BUTTON = 1;
    public static final int WORKBENCH_BUTTON = 2;
    private TreeModel model = null;
    private String listedWBid = null;
    private static final int PIXEL = 12;
    private int buttonCount = 0;
    private static final int ARRAY_CAPACITY = 10;
    private CharInputTextField searchTxtField = null;
    private static final int MAX_TEXT_LENGTH = 127;
    private static final int MIN_TEXT_LENGTH = 1;
    private List<WelcomeTextButton> buttonList = null;

    public AddLinkDialog(Window window, List<WelcomeTextButton> list, int n, String string) {
        super(window);
        JPanel jPanel;
        this.setModal(true);
        this.setName("AddLinkDialog");
        if (n == 1 && null != list && list.size() > 0 && (jPanel = list.get(0)) instanceof DraggableButton) {
            this.listedWBid = ((DraggableButton)jPanel).getWorkbenchId();
        }
        this.setTitle(string, n);
        this.setSize(new Dimension(425, 330));
        jPanel = this.createTreePanel(this.getTreeModel(list));
        JPanel jPanel2 = this.createButtonPanel();
        this.setMinimumSize(new Dimension(196, 36));
        this.getContentPane().add(Box.createVerticalStrut(12), "First");
        this.getContentPane().add(Box.createHorizontalStrut(12), "Before");
        this.getContentPane().add((Component)jPanel, "Center");
        this.getContentPane().add(Box.createHorizontalStrut(12), "After");
        this.getContentPane().add((Component)jPanel2, "Last");
        ScreenToolKit.centerLocateToScreen(this);
        this.setDefaultCloseOperation(0);
        HelpManager helpManager = HelpManager.getInstance();
        if (n == 2) {
            helpManager.enableHelpKey(this.getRootPane(), "iVIEW.WelcomePage.AddWorkbenchDialog");
        } else {
            helpManager.enableHelpKey(this.getRootPane(), "iVIEW.WelcomePage.AddShortcutDialog");
        }
    }

    protected void setTitle(String string, int n) {
        String string2 = string;
        if (null == string2) {
            string2 = res.getString("Create_Link");
            if (n == 2) {
                string2 = res.getString("Add_Workbench_Link_Title");
            }
        }
        super.setTitle(string2);
    }

    private JPanel createTreePanel(TreeModel treeModel) {
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setVgap(5);
        JPanel jPanel = new JPanel(borderLayout);
        jPanel.setName("Add__LInk_Dlg_tree_panel");
        this.tree = new JTree(treeModel);
        this.tree.setName("Add_LInk_Dlg_tree");
        this.tree.setRootVisible(false);
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                if (treeSelectionEvent.getNewLeadSelectionPath() == null) {
                    AddLinkDialog.this.btnCreate.setEnabled(false);
                    return;
                }
                AddLinkDialog.this.btnCreate.setEnabled(AddLinkDialog.this.isAllSelectedButtonsEnabled());
            }
        });
        this.tree.setCellRenderer(new AddLinkCellRenderer());
        this.tree.setShowsRootHandles(true);
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        JLabel jLabel = new JLabel(res.getString("Search"));
        jLabel.setName("AddLinkDialog_SearchLabel");
        jLabel.setSize(50, 20);
        jLabel.setPreferredSize(new Dimension(50, 20));
        this.searchTxtField = new CharInputTextField(1, 127, "");
        this.searchTxtField.setTooltipEnabled(true);
        this.searchTxtField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                AddLinkDialog.this.performSearch();
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (40 == keyEvent.getKeyCode()) {
                    AddLinkDialog.this.tree.setSelectionRow(0);
                    AddLinkDialog.this.tree.requestFocus();
                }
            }
        });
        JLabel jLabel2 = new JLabel(res.getString("ShortcutInfo"));
        jLabel2.setName("AddLinkDialog_ShortcutInfoLabel");
        jPanel2.add(jLabel);
        jPanel2.add(Box.createRigidArea(new Dimension(12, 20)));
        jPanel2.add(this.searchTxtField);
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.add((Component)jLabel2, "South");
        return jPanel;
    }

    private JPanel createButtonPanel() {
        JPanel jPanel = new JPanel();
        FlowLayout flowLayout = new FlowLayout(2, 4, 12);
        jPanel.setLayout(flowLayout);
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 8));
        jPanel.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        jPanel.setName("Function_LInk_Dlg_btn_panel");
        this.btnCreate = new JButton(res.getString("TreeDialog_Create"));
        this.btnCreate.setMnemonic('C');
        this.btnCreate.setName("Function_LInk_Dlg_Create_Btn");
        this.btnCreate.setEnabled(false);
        this.btnCreate.setPreferredSize(new Dimension(80, 21));
        JButton jButton = new JButton(res.getString("TreeDialog_Cancel"));
        jButton.setName("Function_LInk_Dlg_CANCEL_Btn");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddLinkDialog.this.selectedButtons.clear();
                AddLinkDialog.this.tree.clearSelection();
                if (AddLinkDialog.this.searchTxtField.getText().trim().length() != 0) {
                    AddLinkDialog.this.refreshDialog(AddLinkDialog.this.buttonList);
                    AddLinkDialog.this.searchTxtField.setText("");
                }
                AddLinkDialog.this.dispose();
            }
        });
        jButton.setPreferredSize(new Dimension(80, 21));
        this.registerEvents();
        jPanel.add(this.btnCreate);
        jPanel.add(jButton);
        ScreenToolKit.setDefaultButtons(this.btnCreate, jButton);
        return jPanel;
    }

    private TreeModel getTreeModel(List<WelcomeTextButton> list) {
        this.buttonList = list;
        this.buttonCount = 0;
        if (list == null) {
            return null;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Root");
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        DefaultMutableTreeNode defaultMutableTreeNode3 = null;
        String string = null;
        String string2 = null;
        ArrayList<DefaultMutableTreeNode> arrayList = new ArrayList<DefaultMutableTreeNode>(10);
        for (WelcomeTextButton serializable : list) {
            if (!serializable.isVisible()) {
                --this.buttonCount;
                continue;
            }
            defaultMutableTreeNode3 = new DefaultMutableTreeNode(serializable);
            string = serializable.getCategory();
            string2 = serializable.getCategoryResName();
            if (null == string || 0 == string.length()) {
                arrayList.add(defaultMutableTreeNode3);
                ++this.buttonCount;
                continue;
            }
            ArrayList<CategorySettings.Category> arrayList2 = CategorySettings.getInstance().getParentNodes(string);
            if (0 < arrayList2.size()) {
                this.appendCategoryNodes(defaultMutableTreeNode, arrayList2, defaultMutableTreeNode3);
                ++this.buttonCount;
                continue;
            }
            boolean bl = false;
            Object object = null;
            Enumeration<TreeNode> enumeration = defaultMutableTreeNode.breadthFirstEnumeration();
            boolean bl2 = enumeration.hasMoreElements();
            String string3 = null;
            while (bl2) {
                defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
                object = defaultMutableTreeNode2.getUserObject();
                string3 = object.toString();
                if (object instanceof CategorySettings.Category) {
                    string3 = ((CategorySettings.Category)object).getName();
                }
                if (string.equals(string3)) {
                    int n = this.getInsertIndex(defaultMutableTreeNode3, defaultMutableTreeNode2);
                    defaultMutableTreeNode2.insert(defaultMutableTreeNode3, n);
                    ++this.buttonCount;
                    bl = true;
                    break;
                }
                bl2 = enumeration.hasMoreElements();
            }
            if (bl) continue;
            CategorySettings.Category category = CategorySettings.getInstance().getNewCatergory(string, string2, null, Integer.MAX_VALUE);
            defaultMutableTreeNode2 = new DefaultMutableTreeNode(category);
            int n = this.getInsertIndex(defaultMutableTreeNode3, defaultMutableTreeNode2);
            defaultMutableTreeNode2.insert(defaultMutableTreeNode3, n);
            ++this.buttonCount;
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
        for (DefaultMutableTreeNode defaultMutableTreeNode4 : arrayList) {
            defaultMutableTreeNode.insert(defaultMutableTreeNode4, this.getInsertIndex(defaultMutableTreeNode4, defaultMutableTreeNode));
        }
        this.mergeSameDisplayCategories(defaultMutableTreeNode);
        this.model = new DefaultTreeModel(defaultMutableTreeNode);
        return this.model;
    }

    private void mergeSameDisplayCategories(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.mergeSameChildren(defaultMutableTreeNode);
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        while (enumeration.hasMoreElements()) {
            defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            if (defaultMutableTreeNode2.isLeaf()) continue;
            this.mergeSameDisplayCategories(defaultMutableTreeNode2);
        }
    }

    private void mergeSameChildren(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        DefaultMutableTreeNode defaultMutableTreeNode3 = null;
        for (int i = 0; i < defaultMutableTreeNode.getChildCount() - 1; ++i) {
            defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            if (defaultMutableTreeNode2.isLeaf()) continue;
            for (int j = i + 1; j < defaultMutableTreeNode.getChildCount(); ++j) {
                boolean bl;
                defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(j);
                if (defaultMutableTreeNode3.isLeaf() || !(bl = ResourceUtil.areEquals(defaultMutableTreeNode2.toString(), defaultMutableTreeNode3.toString()))) continue;
                this.moveChildren(defaultMutableTreeNode3, defaultMutableTreeNode2);
                defaultMutableTreeNode.remove(j);
                --j;
            }
        }
    }

    private void moveChildren(DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode defaultMutableTreeNode2) {
        while (defaultMutableTreeNode.getChildCount() > 0) {
            defaultMutableTreeNode2.add((DefaultMutableTreeNode)defaultMutableTreeNode.getFirstChild());
        }
    }

    private void appendCategoryNodes(DefaultMutableTreeNode defaultMutableTreeNode, ArrayList<CategorySettings.Category> arrayList, DefaultMutableTreeNode defaultMutableTreeNode2) {
        DefaultMutableTreeNode defaultMutableTreeNode3 = this.getAvailableNode(defaultMutableTreeNode, arrayList, 0);
        int n = 0;
        if (null != defaultMutableTreeNode3) {
            TreeNode[] treeNodeArray = defaultMutableTreeNode3.getPath();
            if (null != treeNodeArray) {
                n = treeNodeArray.length - 1;
            }
        } else {
            defaultMutableTreeNode3 = defaultMutableTreeNode;
        }
        int n2 = arrayList.size();
        CategorySettings.Category category = null;
        DefaultMutableTreeNode defaultMutableTreeNode4 = null;
        int n3 = 0;
        while (n < n2) {
            category = arrayList.get(n);
            defaultMutableTreeNode4 = new DefaultMutableTreeNode(category);
            n3 = this.getInsertIndex(defaultMutableTreeNode4, defaultMutableTreeNode3);
            defaultMutableTreeNode3.insert(defaultMutableTreeNode4, n3);
            defaultMutableTreeNode3 = defaultMutableTreeNode4;
            ++n;
        }
        n3 = this.getInsertIndex(defaultMutableTreeNode2, defaultMutableTreeNode3);
        defaultMutableTreeNode3.insert(defaultMutableTreeNode2, n3);
    }

    private DefaultMutableTreeNode getAvailableNode(DefaultMutableTreeNode defaultMutableTreeNode, ArrayList<CategorySettings.Category> arrayList, int n) {
        CategorySettings.Category category = arrayList.get(n);
        String string = category.getName();
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            if (defaultMutableTreeNode3.isLeaf()) continue;
            Object object = defaultMutableTreeNode3.getUserObject();
            String string2 = object.toString();
            if (object instanceof CategorySettings.Category) {
                CategorySettings.Category category2 = (CategorySettings.Category)defaultMutableTreeNode3.getUserObject();
                string2 = category2.getName();
            }
            if (!string2.equals(string)) continue;
            if (n + 1 < arrayList.size() && null != (defaultMutableTreeNode2 = this.getAvailableNode(defaultMutableTreeNode3, arrayList, n + 1))) {
                return defaultMutableTreeNode2;
            }
            defaultMutableTreeNode2 = defaultMutableTreeNode3;
            break;
        }
        return defaultMutableTreeNode2;
    }

    ArrayList<WelcomeTextButton> getSelectedButtons() {
        return this.selectedButtons;
    }

    private void registerEvents() {
        this.btnCreate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddLinkDialog.this.selectedButtons = AddLinkDialog.this.getSelectedTreeButtons();
                AddLinkDialog.this.tree.clearSelection();
                if (AddLinkDialog.this.searchTxtField.getText().trim().length() != 0) {
                    AddLinkDialog.this.refreshDialog(AddLinkDialog.this.buttonList);
                    AddLinkDialog.this.searchTxtField.setText("");
                }
                AddLinkDialog.this.dispose();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                AddLinkDialog.this.selectedButtons.clear();
                AddLinkDialog.this.tree.clearSelection();
                if (AddLinkDialog.this.searchTxtField.getText().trim().length() != 0) {
                    AddLinkDialog.this.refreshDialog(AddLinkDialog.this.buttonList);
                    AddLinkDialog.this.searchTxtField.setText("");
                }
                AddLinkDialog.this.dispose();
            }
        });
    }

    private boolean isAllSelectedButtonsEnabled() {
        boolean bl = true;
        boolean bl2 = false;
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        Object object = null;
        for (int i = 0; i < treePathArray.length; ++i) {
            if (null == treePathArray[i] || null == (defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[i].getLastPathComponent()) || null == (object = defaultMutableTreeNode.getUserObject()) || !(object instanceof WelcomeTextButton)) continue;
            bl2 = true;
            if (object instanceof WorkbenchButton && ((WorkbenchButton)object).isSelected()) {
                bl = false;
                break;
            }
            if (!(object instanceof DraggableButton) || ((DraggableButton)object).isEnabled()) continue;
            bl = false;
            break;
        }
        return bl2 && bl;
    }

    protected ArrayList<WelcomeTextButton> getSelectedTreeButtons() {
        ArrayList<WelcomeTextButton> arrayList = new ArrayList<WelcomeTextButton>(1);
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        Object object = null;
        for (int i = 0; i < treePathArray.length; ++i) {
            if (null == treePathArray[i] || null == (defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[i].getLastPathComponent()) || null == (object = defaultMutableTreeNode.getUserObject()) || !(object instanceof WelcomeTextButton) || !((WelcomeTextButton)object).isEnabled()) continue;
            arrayList.add((WelcomeTextButton)object);
        }
        return arrayList;
    }

    protected void refreshDialog(List<WelcomeTextButton> list) {
        this.tree.setModel(this.getTreeModel(list));
        this.tree.revalidate();
        this.tree.updateUI();
        this.getContentPane().repaint();
    }

    private String getDisplayName(WelcomeTextButton welcomeTextButton) {
        String string = welcomeTextButton.getFullName();
        if (null == string || string.trim().length() == 0) {
            return "          ";
        }
        return string;
    }

    final String getListedWBid() {
        return this.listedWBid;
    }

    final int getButtonCount() {
        return this.buttonCount;
    }

    private int getInsertIndex(DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode defaultMutableTreeNode2) {
        Object object;
        CategorySettings categorySettings = CategorySettings.getInstance();
        int n = 0;
        if (defaultMutableTreeNode.getUserObject() instanceof WelcomeTextButton) {
            n = ((WelcomeTextButton)defaultMutableTreeNode.getUserObject()).getSeqenceNumber();
        } else {
            CategorySettings.Category category = (CategorySettings.Category)defaultMutableTreeNode.getUserObject();
            object = category.getName();
            n = categorySettings.findCategorySerialNumber((String)object);
        }
        int n2 = defaultMutableTreeNode2.getChildCount();
        object = null;
        String string = null;
        CategorySettings.Category category = null;
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            object = (DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(i);
            if (((DefaultMutableTreeNode)object).getUserObject() instanceof WelcomeTextButton) {
                n3 = ((WelcomeTextButton)((DefaultMutableTreeNode)object).getUserObject()).getSeqenceNumber();
            } else {
                category = (CategorySettings.Category)((DefaultMutableTreeNode)object).getUserObject();
                string = category.getName();
                n3 = categorySettings.findCategorySerialNumber(string);
            }
            if (n3 > n) {
                n2 = i;
                break;
            }
            if (n3 != n) continue;
            n2 = i + 1;
            break;
        }
        return n2;
    }

    private void performSearch() {
        if (this.searchTxtField.getText().trim().length() == 0) {
            this.refreshDialog(this.buttonList);
            this.expandAll(false);
            this.tree.expandPath(new TreePath(this.model.getRoot()));
        } else {
            ArrayList<DefaultMutableTreeNode> arrayList = new ArrayList<DefaultMutableTreeNode>();
            ArrayList<DefaultMutableTreeNode> arrayList2 = new ArrayList<DefaultMutableTreeNode>();
            this.getTreeNode(this.searchTxtField.getText(), new TreePath(this.model.getRoot()), arrayList, arrayList2);
            for (int i = 0; i < arrayList2.size(); ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)arrayList2.get(i).getParent();
                defaultMutableTreeNode.remove(arrayList2.get(i));
                while (defaultMutableTreeNode.getChildCount() == 0 && !defaultMutableTreeNode.isRoot()) {
                    DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
                    defaultMutableTreeNode2.remove(defaultMutableTreeNode);
                    defaultMutableTreeNode = defaultMutableTreeNode2;
                }
            }
            if (arrayList.isEmpty()) {
                this.tree.setModel(null);
            } else {
                this.tree.setModel(this.model);
                this.expandAll(true);
            }
            this.getTreeModel(this.buttonList);
            this.tree.revalidate();
            this.tree.updateUI();
        }
    }

    private void expandAll(boolean bl) {
        TreeNode treeNode = (TreeNode)this.tree.getModel().getRoot();
        this.expandAll(new TreePath(treeNode), bl);
    }

    private void expandAll(TreePath treePath, boolean bl) {
        TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
        if (treeNode.getChildCount() >= 0) {
            TreeNode treeNode2 = null;
            TreePath treePath2 = null;
            Enumeration<? extends TreeNode> enumeration = treeNode.children();
            while (enumeration.hasMoreElements()) {
                treeNode2 = enumeration.nextElement();
                treePath2 = treePath.pathByAddingChild(treeNode2);
                this.expandAll(treePath2, bl);
            }
        }
        if (bl) {
            this.tree.expandPath(treePath);
        } else {
            this.tree.collapsePath(treePath);
        }
    }

    private void getTreeNode(String string, TreePath treePath, ArrayList<DefaultMutableTreeNode> arrayList, ArrayList<DefaultMutableTreeNode> arrayList2) {
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        int n = this.model.getChildCount(treePath.getLastPathComponent());
        TreePath treePath2 = null;
        for (int i = 0; i < n; ++i) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)this.model.getChild(treePath.getLastPathComponent(), i);
            if (defaultMutableTreeNode.isLeaf() && !((WelcomeTextButton)defaultMutableTreeNode.getUserObject()).getFullName().toLowerCase().contains(string.toLowerCase())) {
                arrayList2.add(defaultMutableTreeNode);
            } else if (defaultMutableTreeNode.isLeaf()) {
                arrayList.add(defaultMutableTreeNode);
            }
            treePath2 = treePath.pathByAddingChild(defaultMutableTreeNode);
            this.getTreeNode(string, treePath2, arrayList, arrayList2);
        }
    }

    private class AddLinkCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 3435697327376458008L;

        private AddLinkCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            if (bl3 && defaultMutableTreeNode.getUserObject() instanceof WelcomeTextButton) {
                WelcomeTextButton welcomeTextButton = (WelcomeTextButton)defaultMutableTreeNode.getUserObject();
                this.setText(AddLinkDialog.this.getDisplayName(welcomeTextButton));
                if (!(welcomeTextButton instanceof WorkbenchButton)) {
                    if (!welcomeTextButton.isEnabled()) {
                        if (!bl) {
                            this.setEnabled(false);
                            this.setDisabledIcon(this.getDefaultLeafIcon());
                        } else {
                            this.setForeground(new Color(163, 163, 163));
                        }
                    }
                } else if (welcomeTextButton.isSelected()) {
                    if (!bl) {
                        this.setEnabled(false);
                        this.setDisabledIcon(this.getDefaultLeafIcon());
                    } else {
                        this.setForeground(new Color(163, 163, 163));
                    }
                }
            }
            return this;
        }
    }
}

