/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.windowmanagement.navigation;

import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.framework.windowmanagement.navigation.NavigationHistory;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class NavigationHistoryAction
extends AbstractAction {
    private int MAX_HISTORY_LENGTH = 9;
    private boolean forward = false;
    private JPopupMenu historyMenu = null;
    private final NavigationHistory history = (NavigationHistory)FrameworkUtilities.getWindowManager().getNavigationHistory();

    public NavigationHistoryAction(boolean bl) {
        this.forward = bl;
        if (bl) {
            this.history.setBackwardAction(this);
        } else {
            this.history.setForwardAction(this);
        }
    }

    public JPopupMenu getMenu() {
        JMenuItem jMenuItem = null;
        this.historyMenu = new JPopupMenu();
        int[] nArray = this.forward ? this.history.getForwardEntries() : this.history.getBackwardEntries();
        NavigationActionListener navigationActionListener = null;
        for (int i = 0; i < nArray.length && i <= this.MAX_HISTORY_LENGTH; ++i) {
            String string = FrameworkUtilities.getWindowManager().getActiveFrameTitle(nArray[i]);
            jMenuItem = new JMenuItem(string);
            navigationActionListener = new NavigationActionListener(i);
            jMenuItem.addActionListener(navigationActionListener);
            this.historyMenu.add(jMenuItem);
        }
        if (0 == nArray.length) {
            return null;
        }
        return this.historyMenu;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.forward) {
            this.history.forward();
        } else {
            this.history.backward();
        }
        this.update();
    }

    void update() {
        if (this.forward) {
            boolean bl = this.history.isForwardPossible();
            this.setEnabled(bl);
        } else {
            boolean bl = this.history.isBackwardPossible();
            this.setEnabled(bl);
        }
    }

    class NavigationActionListener
    implements ActionListener {
        private int index = 0;

        public NavigationActionListener(int n) {
            this.index = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (NavigationHistoryAction.this.forward) {
                for (int i = 0; i < this.index + 1; ++i) {
                    NavigationHistoryAction.this.history.forward();
                }
            } else {
                for (int i = 0; i < this.index + 1; ++i) {
                    NavigationHistoryAction.this.history.backward();
                }
            }
        }
    }
}

