/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.windowmanagement.navigation;

import com.swimap.iview.framework.windowmanagement.WindowManager;
import com.swimap.iview.framework.windowmanagement.navigation.INavigationHistory;
import com.swimap.iview.framework.windowmanagement.navigation.NavigationHistoryAction;
import java.util.ArrayList;
import java.util.Iterator;

public class NavigationHistory
implements INavigationHistory {
    private static final int CAPACITY = 50;
    private WindowManager windowManager = null;
    private ArrayList<Integer> history = new ArrayList(50);
    private int activeWindow = 0;
    private NavigationHistoryAction backwardAction = null;
    private NavigationHistoryAction forwardAction = null;
    private boolean removeForward = false;

    public NavigationHistory(WindowManager windowManager) {
        this.windowManager = windowManager;
    }

    @Override
    public int getCurrentWindowId() {
        int n = this.getWindow(this.activeWindow);
        return n;
    }

    @Override
    public int[] getWindowIds() {
        int[] nArray = new int[this.history.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.history.get(i);
        }
        return nArray;
    }

    @Override
    public void addWindow(int n) {
        Integer n2 = null;
        if (!this.history.isEmpty()) {
            n2 = this.history.get(this.activeWindow);
        }
        if (null == n2 || n2 != n) {
            this.removeForwardWindows();
            if (50 == this.history.size()) {
                this.history.remove(0);
            }
            this.history.add(n);
            this.activeWindow = this.history.size() - 1;
        }
        this.optimizeHistory();
        this.updateActions();
    }

    private void removeForwardWindows() {
        int n = this.history.size();
        for (int i = this.activeWindow + 1; i < n; ++i) {
            this.history.remove(this.activeWindow + 1);
        }
        this.updateActions();
    }

    @Override
    public void removeWindows(int n) {
        Iterator<Integer> iterator = this.history.iterator();
        int n2 = 0;
        int n3 = 0;
        int n4 = this.getWindow(this.activeWindow);
        while (iterator.hasNext()) {
            Integer n5 = iterator.next();
            if (n5.equals(n)) {
                if (n2 < this.activeWindow) {
                    ++n3;
                } else if (!iterator.hasNext() && n2 == this.activeWindow) {
                    ++n3;
                } else if (n2 == this.activeWindow && this.removeForward && n4 == n) {
                    ++n3;
                }
                iterator.remove();
            }
            ++n2;
        }
        this.activeWindow -= n3;
        this.optimizeHistory();
        this.updateActions();
    }

    private void optimizeHistory() {
        Iterator<Integer> iterator = this.history.iterator();
        Integer n = null;
        int n2 = -1;
        int n3 = 0;
        while (iterator.hasNext()) {
            Integer n4 = iterator.next();
            if (null != n && n4.equals(n)) {
                if (n2 < this.activeWindow) {
                    ++n3;
                }
                iterator.remove();
            } else {
                n = n4;
            }
            ++n2;
        }
        this.activeWindow -= n3;
    }

    void forward() {
        if (this.isForwardPossible()) {
            this.shiftWindow(true);
        }
        this.updateActions();
        this.removeForward = true;
    }

    void backward() {
        if (this.isBackwardPossible()) {
            this.shiftWindow(false);
        }
        this.updateActions();
        this.removeForward = false;
    }

    boolean isForwardPossible() {
        return 0 <= this.activeWindow + 1 && this.activeWindow + 1 < this.history.size();
    }

    boolean isBackwardPossible() {
        return 0 <= this.activeWindow - 1 && this.activeWindow - 1 < this.history.size();
    }

    private void shiftWindow(boolean bl) {
        this.activeWindow = bl ? ++this.activeWindow : --this.activeWindow;
        int n = this.getWindow(this.activeWindow);
        if (-1 != n) {
            this.windowManager.activateWindow(n);
        }
        this.updateActions();
    }

    private int getWindow(int n) {
        if (0 <= n && n < this.history.size()) {
            return this.history.get(n);
        }
        return -1;
    }

    void shiftCurrentWindow(int n, boolean bl) {
        this.activeWindow = this.history.indexOf(n);
        this.windowManager.activateWindow(n);
        this.updateActions();
    }

    void setForwardAction(NavigationHistoryAction navigationHistoryAction) {
        this.forwardAction = navigationHistoryAction;
        this.updateActions();
    }

    void setBackwardAction(NavigationHistoryAction navigationHistoryAction) {
        this.backwardAction = navigationHistoryAction;
        this.updateActions();
    }

    private void updateActions() {
        if (this.backwardAction != null) {
            this.backwardAction.update();
        }
        if (this.forwardAction != null) {
            this.forwardAction.update();
        }
    }

    public int[] getForwardEntries() {
        int n = this.history.size() - this.activeWindow - 1;
        n = Math.max(0, n);
        int[] nArray = new int[n];
        for (int i = this.activeWindow + 1; i < this.history.size(); ++i) {
            nArray[i - this.activeWindow - 1] = this.getWindow(i);
        }
        return nArray;
    }

    public int[] getBackwardEntries() {
        int n = this.activeWindow;
        n = Math.max(0, n);
        int[] nArray = new int[n];
        for (int i = 0; i < this.activeWindow; ++i) {
            nArray[this.activeWindow - 1 - i] = this.getWindow(i);
        }
        return nArray;
    }
}

