/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.windowmanagement.navigation;

import com.swimap.iview.commstyle.commini.PopupButton;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.framework.windowmanagement.navigation.NavigationHistoryAction;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JPopupMenu;

public class ForwardButton
extends PopupButton {
    static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/Res");
    private static final String TOOLBAR_ICON = "mainfrm/Right.png";
    private static final String TOOLTIP_TEXT = "ToolTip_Forward";
    private static final String FORWARD_BUTTON_NAME = "Forward_Drop_Down";
    private NavigationHistoryAction forwardAction = new NavigationHistoryAction(true);

    public ForwardButton() {
        this.init();
        this.getRightButton().setName(FORWARD_BUTTON_NAME);
        this.setVisible(true);
        boolean bl = this.forwardAction.isEnabled();
        this.setEnabled(bl);
    }

    private void init() {
        Icon icon = ResourceMng.getInstance().getIconDirect(TOOLBAR_ICON);
        this.forwardAction.putValue("SmallIcon", icon);
        this.getLeftButton().setAction(this.forwardAction);
        String string = res.getString(TOOLTIP_TEXT);
        this.setToolTipTextForFront(string);
        this.getLeftButton().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                if (ForwardButton.this.getPopup() != null && ForwardButton.this.getPopup().isVisible()) {
                    ForwardButton.this.setToolTipDisabled();
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                String string = res.getString(ForwardButton.TOOLTIP_TEXT);
                ForwardButton.this.setToolTipTextForFront(string);
            }
        });
        this.getRightButton().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                JPopupMenu jPopupMenu = ForwardButton.this.forwardAction.getMenu();
                ForwardButton.this.setPopup(jPopupMenu);
                ForwardButton.this.showPopupMenu();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                if (ForwardButton.this.getPopup() != null && ForwardButton.this.getPopup().isVisible()) {
                    ForwardButton.this.setToolTipDisabled();
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                String string = res.getString(ForwardButton.TOOLTIP_TEXT);
                ForwardButton.this.setToolTipTextForFront(string);
            }
        });
    }

    private void setToolTipTextForFront(String string) {
        this.getLeftButton().setToolTipText(string);
    }

    private void setToolTipDisabled() {
        this.getLeftButton().setToolTipText(null);
    }

    public static void cleanupWhileOSGIExit() {
        res = null;
    }
}

