/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.windowmanagement.navigation;

import com.swimap.iview.commstyle.commini.PopupButton;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.framework.windowmanagement.navigation.NavigationHistoryAction;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JPopupMenu;

public class BackButton
extends PopupButton {
    static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/Res");
    private static final String TOOLBAR_ICON = "mainfrm/Left.png";
    private static final String TOOLTIP_TEXT = "ToolTip_Back";
    private static final String BACK_BUTTON_NAME = "Back_Drop_Down";
    private NavigationHistoryAction backwardAction = new NavigationHistoryAction(false);

    public BackButton() {
        this.init();
        this.getRightButton().setName(BACK_BUTTON_NAME);
        this.setVisible(true);
        boolean bl = this.backwardAction.isEnabled();
        this.setEnabled(bl);
    }

    private void init() {
        Icon icon = ResourceMng.getInstance().getIconDirect(TOOLBAR_ICON);
        this.backwardAction.putValue("SmallIcon", icon);
        this.getLeftButton().setAction(this.backwardAction);
        String string = res.getString(TOOLTIP_TEXT);
        this.setToolTipTextForBackWard(string);
        this.getLeftButton().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                if (BackButton.this.getPopup() != null && BackButton.this.getPopup().isVisible()) {
                    BackButton.this.setToolTipDisabled();
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                String string = res.getString(BackButton.TOOLTIP_TEXT);
                BackButton.this.setToolTipTextForBackWard(string);
            }
        });
        this.getRightButton().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                JPopupMenu jPopupMenu = BackButton.this.backwardAction.getMenu();
                BackButton.this.setPopup(jPopupMenu);
                BackButton.this.showPopupMenu();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                if (BackButton.this.getPopup() != null && BackButton.this.getPopup().isVisible()) {
                    BackButton.this.setToolTipDisabled();
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                String string = res.getString(BackButton.TOOLTIP_TEXT);
                BackButton.this.setToolTipTextForBackWard(string);
            }
        });
    }

    private void setToolTipTextForBackWard(String string) {
        this.getLeftButton().setToolTipText(string);
    }

    private void setToolTipDisabled() {
        this.getLeftButton().setToolTipText(null);
    }

    public static void cleanupWhileOSGIExit() {
        res = null;
    }
}

