/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.windowmanagement;

import com.swimap.iview.framework.windowmanagement.IWindowTile;
import com.swimap.iview.framework.windowmanagement.InternalDialog;
import com.swimap.iview.framework.windowmanagement.InternalFrame;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Dimension;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;

public class WindowTileImpl
implements IWindowTile {
    private static IviewLogger logger = IviewLogger.getLogger(WindowTileImpl.class, "IVIEW");
    private static final int ICON_HEIGHT = 40;
    private JDesktopPane desktopPane = null;

    public WindowTileImpl(JDesktopPane jDesktopPane) {
        if (jDesktopPane == null) {
            throw new IllegalArgumentException("JDesktopPane can't be null.");
        }
        this.desktopPane = jDesktopPane;
    }

    private void tileWindows(JInternalFrame[] jInternalFrameArray, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = jInternalFrameArray.length;
        int n8 = n5;
        int n9 = n6;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2 && i * n2 + j < n7; ++j) {
                JInternalFrame jInternalFrame = jInternalFrameArray[i * n2 + j];
                if (!jInternalFrame.isClosed()) {
                    try {
                        jInternalFrame.setMaximum(false);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        logger.trace(propertyVetoException.getMessage(), propertyVetoException);
                    }
                }
                jInternalFrame.setBounds(n8, n9, n3, n4);
                n8 += n3;
            }
            n9 += n4;
            n8 = n5;
        }
    }

    private void filterWindows(JInternalFrame[] jInternalFrameArray, List list, List list2) {
        for (int i = 0; i < jInternalFrameArray.length; ++i) {
            if (jInternalFrameArray[i].isIcon()) continue;
            if (jInternalFrameArray[i] instanceof InternalFrame && ((InternalFrame)jInternalFrameArray[i]).isManaged() && (jInternalFrameArray[i].isMaximum() || jInternalFrameArray[i].isResizable())) {
                list.add(jInternalFrameArray[i]);
                continue;
            }
            list2.add(jInternalFrameArray[i]);
        }
    }

    @Override
    public void tileFrames() {
        JInternalFrame[] jInternalFrameArray = this.desktopPane.getAllFrames();
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        this.filterWindows(jInternalFrameArray, arrayList, arrayList2);
        boolean bl = arrayList.size() + arrayList2.size() != jInternalFrameArray.length;
        int n = arrayList.size();
        if (n == 0) {
            return;
        }
        JInternalFrame[] jInternalFrameArray2 = new JInternalFrame[n];
        arrayList.toArray(jInternalFrameArray2);
        int n2 = (int)Math.sqrt(n);
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        if (n2 * n2 == n) {
            n3 = n2;
            n5 = n2;
            n7 = n;
        } else {
            int n12 = n2 + 1;
            n5 = n / n12;
            n6 = n5 + 1;
            n4 = n % n12;
            n3 = n12 - n4;
            n7 = n5 * n3;
            n8 = n6 * n4;
        }
        Dimension dimension = this.desktopPane.getSize();
        if (bl && dimension.height > 40) {
            dimension.height -= 40;
        }
        n9 = dimension.width / (n3 + n4);
        n10 = n5 == 0 ? 0 : dimension.height / n5;
        n11 = n6 == 0 ? 0 : dimension.height / n6;
        JInternalFrame[] jInternalFrameArray3 = new JInternalFrame[n7];
        System.arraycopy(jInternalFrameArray2, 0, jInternalFrameArray3, 0, jInternalFrameArray3.length);
        this.tileWindows(jInternalFrameArray3, n5, n3, n9, n10, 0, 0);
        int n13 = n3 * n9;
        jInternalFrameArray3 = new JInternalFrame[n8];
        System.arraycopy(jInternalFrameArray2, n7, jInternalFrameArray3, 0, jInternalFrameArray3.length);
        this.tileWindows(jInternalFrameArray3, n6, n4, n9, n11, n13, 0);
        for (JInternalFrame jInternalFrame : arrayList2) {
            if (jInternalFrame instanceof InternalDialog) {
                if (!((InternalDialog)jInternalFrame).getParentInternalFrame().isSelected()) continue;
                jInternalFrame.toFront();
                continue;
            }
            jInternalFrame.moveToFront();
        }
    }
}

