/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.windowmanagement;

import com.swimap.iview.commstyle.commini.AreaDescContainer;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.framework.windowmanagement.IWindowStyleInterface;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Rectangle;

public class WindowStyle
implements IWindowStyleInterface {
    private static IviewLogger logger = IviewLogger.getLogger(WindowStyle.class, "IVIEW");
    public static final String WINDOW_STYLE_AREA_NAME = "WindowStyle";
    public static final String LOCATION_DESC_NAME = "location";
    public static final String XCOORDINATE_PARA_NAME = "XCoordinate";
    public static final String YCOORDINATE_PARA_NAME = "YCoordinate";
    public static final String SIZE_DESC_NAME = "size";
    public static final String WIDTH_PARA_NAME = "width";
    public static final String HEIGHT_PARA_NAME = "height";
    public static final String STATE_DESC_NAME = "state";
    public static final String STATE_PARA_NAME = "state";
    public static final String SHOWTABICON_PARA_NAME = "showWindowTabIcon";
    public final int ICON_STATE = 1;
    public final int NORMAL_STATE = 2;
    public final int MAXIMUM_STATE = 3;
    private Rectangle bounds = null;
    private int state = 2;
    private CommStyleInfo styleInfo = null;
    private boolean showWindowTabicon = true;
    public static final Rectangle DEFAULT_BOUNDS = new Rectangle(0, 0, 500, 600);

    @Override
    public Rectangle getWindowBounds() {
        return this.bounds;
    }

    @Override
    public void setWindowBounds(Rectangle rectangle) {
        this.bounds = rectangle;
    }

    public void setWindowBounds(int n, int n2, int n3, int n4) {
        if (null == this.bounds) {
            this.bounds = new Rectangle(n, n2, n3, n4);
        } else {
            this.bounds.x = n;
            this.bounds.y = n2;
            this.bounds.width = n3;
            this.bounds.height = n4;
        }
    }

    @Override
    public int getWindowState() {
        return this.state;
    }

    @Override
    public void setWindowState(int n) {
        this.state = n;
    }

    public boolean loadStyles(String string) {
        Object object;
        if (null == string) {
            logger.error("Load style error, the style name is null");
            return false;
        }
        CommStyleInfo commStyleInfo = null;
        try {
            commStyleInfo = CommStyleManager.getInstance().getUserProductDefaultCommonStyleFile("conf/mainfrm/windowstyle");
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
        if (null == commStyleInfo) {
            logger.error("Load style error, can get the style info from style file.");
            return false;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        boolean bl = true;
        try {
            object = commStyleInfo.getParasItemValue(WINDOW_STYLE_AREA_NAME, string, XCOORDINATE_PARA_NAME);
            String string2 = commStyleInfo.getParasItemValue(WINDOW_STYLE_AREA_NAME, string, YCOORDINATE_PARA_NAME);
            String string3 = commStyleInfo.getParasItemValue(WINDOW_STYLE_AREA_NAME, string, WIDTH_PARA_NAME);
            String string4 = commStyleInfo.getParasItemValue(WINDOW_STYLE_AREA_NAME, string, HEIGHT_PARA_NAME);
            String string5 = commStyleInfo.getParasItemValue(WINDOW_STYLE_AREA_NAME, string, "state");
            String string6 = commStyleInfo.getParasItemValue(WINDOW_STYLE_AREA_NAME, string, SHOWTABICON_PARA_NAME);
            n = Integer.parseInt((String)object);
            n2 = Integer.parseInt(string2);
            n3 = Integer.parseInt(string3);
            n4 = Integer.parseInt(string4);
            n5 = Integer.parseInt(string5);
            if (null != string6) {
                bl = Boolean.parseBoolean(string6);
            }
        }
        catch (Exception exception) {
            logger.error("load style error, the information can't be translated.");
            logger.trace(exception.getMessage(), exception);
            return false;
        }
        object = new Rectangle(n, n2, n3, n4);
        this.setWindowBounds((Rectangle)object);
        this.setWindowState(n5);
        this.setWindowTabIcon(bl);
        return true;
    }

    private void setWindowTabIcon(boolean bl) {
        this.showWindowTabicon = bl;
    }

    public boolean isWindowTabIcon() {
        return this.showWindowTabicon;
    }

    public boolean storeStyles(String string) {
        DescContainer descContainer;
        AreaDescContainer areaDescContainer;
        if (null == this.styleInfo) {
            try {
                this.styleInfo = CommStyleManager.getInstance().getCommonStyleFile("conf/mainfrm/windowstyle");
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
            }
            if (null == this.styleInfo) {
                this.styleInfo = new CommStyleInfo();
                logger.error("store style error, the file no exist, create a new one.");
            }
        }
        if (null == (areaDescContainer = this.styleInfo.getAreaDescContainer(WINDOW_STYLE_AREA_NAME))) {
            areaDescContainer = new AreaDescContainer(WINDOW_STYLE_AREA_NAME);
            this.styleInfo.addAreaDescContainer(areaDescContainer);
        }
        if (null == (descContainer = areaDescContainer.getDescContainer(string))) {
            descContainer = new DescContainer(string);
            areaDescContainer.addDescContainer(descContainer);
        }
        if (null == this.bounds) {
            this.bounds = new Rectangle(DEFAULT_BOUNDS);
        }
        descContainer.setParasItem(XCOORDINATE_PARA_NAME, String.valueOf(this.bounds.x), true);
        descContainer.setParasItem(YCOORDINATE_PARA_NAME, String.valueOf(this.bounds.y), true);
        descContainer.setParasItem(WIDTH_PARA_NAME, String.valueOf(this.bounds.width), true);
        descContainer.setParasItem(HEIGHT_PARA_NAME, String.valueOf(this.bounds.height), true);
        descContainer.setParasItem("state", String.valueOf(this.getWindowState()), true);
        descContainer.setParasItem(WINDOW_STYLE_AREA_NAME, String.valueOf(this.isWindowTabIcon()), true);
        try {
            CommStyleManager.getInstance().writeToUser(this.styleInfo);
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
            return false;
        }
        return true;
    }
}

