/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.windowmanagement;

import com.swimap.iview.commstyle.resource.i18n.ResourceUtil;
import com.swimap.iview.framework.mainframe.MDIFrame;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.framework.windowmanagement.WindowSetting;
import com.swimap.iview.templates.textfield.ValidCharDocument;
import com.swimap.iview.util.helpmanagement.HelpManager;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class WindowSettingPanel
extends JPanel {
    private static IviewLogger logger = IviewLogger.getLogger(WindowSettingPanel.class, "IVIEW");
    private JPanel windowTitlePanel = new JPanel();
    JTextField titleField = new JTextField();
    private WindowSetting panelManager = null;
    private static final int TITLE_MAX_LENGTH = 1024;

    public WindowSettingPanel() {
        this((WindowSetting)null);
    }

    public WindowSettingPanel(WindowSetting windowSetting) {
        try {
            this.panelManager = windowSetting;
            this.jbInit();
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
    }

    private void jbInit() throws Exception {
        ValidCharDocument validCharDocument = new ValidCharDocument(1024);
        validCharDocument.setInValidCharString("");
        this.titleField.setDocument(validCharDocument);
        this.windowTitlePanel.setLayout(new BorderLayout(12, 6));
        this.windowTitlePanel.add((Component)this.titleField, "North");
        this.setLayout(new BorderLayout());
        this.add((Component)this.windowTitlePanel, "North");
        this.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.titleField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (ResourceUtil.areEquals(WindowSettingPanel.this.titleField.getText().trim(), ((MDIFrame)FrameworkUtilities.getMainFrame()).getMDITitle())) {
                    WindowSettingPanel.this.panelManager.notifyChange(false);
                } else {
                    WindowSettingPanel.this.panelManager.notifyChange(true);
                }
            }
        });
        this.putClientProperty("HELP_ID_PROPERTY", "iVIEW.WindowTitle");
        HelpManager.getInstance().enableHelpKey(this, "iVIEW.WindowTitle");
    }
}

