/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.windowmanagement;

import com.swimap.iview.commstyle.resource.i18n.ResourceUtil;
import com.swimap.iview.framework.mainframe.MDIFrame;
import com.swimap.iview.framework.modulemanagement.InternalLocalMsg;
import com.swimap.iview.framework.modulemanagement.ModuleManagementException;
import com.swimap.iview.framework.modulemanagement.ModuleManager;
import com.swimap.iview.framework.subsystemmanagement.SubsystemManager;
import com.swimap.iview.framework.systemsettingsmanagement.BaseClientSettings;
import com.swimap.iview.framework.systemsettingsmanagement.SystemSettingsManager;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.framework.windowmanagement.WindowManager;
import com.swimap.iview.framework.windowmanagement.WindowSettingPanel;
import com.swimap.iview.util.OptionPane;
import com.swimap.iview.util.log.IviewLogger;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.omg.CORBA.ORB;

public class WindowSetting
extends BaseClientSettings {
    private static IviewLogger logger = IviewLogger.getLogger(WindowSetting.class, "IVIEW");
    static final String MODULE_NAME = "mainframesetting";
    private WindowSettingPanel panel = null;
    private boolean bChanged = false;

    public WindowSetting(ModuleManager moduleManager, ORB oRB, String string, String string2) throws ModuleManagementException {
        super(moduleManager, oRB, string, string2);
        if (SubsystemManager.getInstance().getClientLoadMode() == SubsystemManager.LoadMode.single) {
            throw new ModuleManagementException("Single Mode - not required to change title.");
        }
    }

    @Override
    public boolean apply() {
        try {
            WindowManager windowManager = (WindowManager)this.getLocalReference("mainwindowmanager");
            String string = this.panel.titleField.getText().trim();
            if (string.length() == 0 || string == null) {
                FrameworkUtilities.getSystemSettingsManager().activateSetting(this);
                this.panel.titleField.requestFocusInWindow();
                OptionPane.showErrorDialog(FrameworkUtilities.getMainFrame(), WindowManager.res.getString("WindowSettiongPanel_Input_NOSpace"));
                return false;
            }
            String string2 = windowManager.getMDITitle();
            if (!ResourceUtil.areEquals(string, windowManager.getMDITitle())) {
                windowManager.setMDITitle(string);
                try {
                    windowManager.writeBackSetting();
                    this.panel.titleField.setText(string);
                    FrameworkUtilities.getSystemSettingsManager().setSystemSettingStatus(this.getTabLabel(), true, "");
                }
                catch (IOException iOException) {
                    windowManager.setMDITitle(string2);
                    this.panel.titleField.setText(string2);
                    FrameworkUtilities.getSystemSettingsManager().setSystemSettingStatus(this.getTabLabel(), false, WindowManager.res.getString("Fail_msg"));
                }
            }
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
            return false;
        }
        this.bChanged = false;
        return true;
    }

    @Override
    public Icon getTabIcon() {
        return null;
    }

    @Override
    public boolean exit() {
        if (this.panel != null) {
            this.panel.titleField.setText(((MDIFrame)FrameworkUtilities.getMainFrame()).getMDITitle());
        }
        this.bChanged = false;
        return true;
    }

    @Override
    public JPanel getSettingsPanel() {
        if (this.panel == null) {
            this.panel = new WindowSettingPanel(this);
        }
        return this.panel;
    }

    @Override
    public boolean isChanged() {
        return this.bChanged;
    }

    public void setChanged(boolean bl) {
        this.bChanged = bl;
    }

    @Override
    public String getTabLabel() {
        return WindowManager.res.getString("WindowSettingPanel_Setting_Title");
    }

    @Override
    public String getModuleName() {
        return MODULE_NAME;
    }

    @Override
    public Object processEvent(InternalLocalMsg internalLocalMsg) {
        switch (internalLocalMsg.ID) {
            case 1: {
                Object[] objectArray = (Object[])internalLocalMsg.data;
                this.panel.titleField.setText((String)objectArray[1]);
                this.notifyChange(false);
                break;
            }
        }
        return null;
    }

    final void notifyChange(boolean bl) {
        try {
            SystemSettingsManager systemSettingsManager = (SystemSettingsManager)this.getReference("mainsystemsettingmanager", "");
            systemSettingsManager.clientSettingChanged(this.getModuleName(), bl || this.isChanged());
            this.bChanged = bl;
        }
        catch (ModuleManagementException moduleManagementException) {
            logger.trace(moduleManagementException.getMessage(), moduleManagementException);
        }
    }

    @Override
    public void reinitialize() {
        WindowManager windowManager = FrameworkUtilities.getWindowManager();
        if (this.panel != null) {
            this.panel.titleField.setText(((MDIFrame)FrameworkUtilities.getMainFrame()).getMDITitle());
        }
        windowManager.setMDIFrame(windowManager.parentFrame);
    }

    @Override
    public int getTitleDescription() {
        return 1;
    }
}

