/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.windowmanagement;

import com.swimap.iview.commstyle.commini.foldingmenus.FoldingCBMenuItem;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.commstyle.resource.i18n.ResourceUtil;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.framework.windowmanagement.InternalFrame;
import com.swimap.iview.framework.windowmanagement.WindowManager;
import com.swimap.iview.framework.windowmanagement.navigation.NavigationHistory;
import com.swimap.iview.templates.utils.MultiRowToolTip;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.log.IviewLogger;
import java.beans.PropertyVetoException;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JToolTip;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;

public class WindowManagerCheckBoxMenuItem
extends FoldingCBMenuItem {
    private static IviewLogger logger = IviewLogger.getLogger(WindowManagerCheckBoxMenuItem.class, "IVIEW");
    private String baseTitle = "";
    private String sno = "";
    private final int HALF_SCREENWITH = (int)((double)ScreenToolKit.getScreenWidth() / 2.0);
    private final int MAX_LINE_TOOLTIP = 10;
    protected InternalFrame internalFrame = null;
    protected JFrame frame = null;
    private transient InternalFrameListener listener = new WindowMenuItemInternalFrameListener();

    public WindowManagerCheckBoxMenuItem(InternalFrame internalFrame) {
        this.setInternalFrame(internalFrame);
    }

    public WindowManagerCheckBoxMenuItem(JFrame jFrame) {
        this.setFrame(jFrame, true);
    }

    @Override
    public void setMnemonic(char c) {
        String string = this.getText();
        super.setMnemonic(c);
        String string2 = ".*\\(" + c + "\\)";
        if (string != null && (string.toLowerCase().matches(string2) || string.toUpperCase().matches(string2))) {
            this.setDisplayedMnemonicIndex(string.length() - 2);
        }
    }

    public void setInternalFrame(InternalFrame internalFrame) {
        if (internalFrame == null && this.internalFrame != null) {
            this.internalFrame.removeInternalFrameListener(this.listener);
        }
        this.internalFrame = internalFrame;
        if (this.internalFrame != null) {
            this.internalFrame.addInternalFrameListener(this.listener);
        }
        this.updateMenuItem();
    }

    public void setFrame(JFrame jFrame, boolean bl) {
        this.frame = jFrame;
        this.updateMenuItem();
    }

    public InternalFrame getInternalFrame() {
        return this.internalFrame;
    }

    public int getInternalFrameID() {
        if (null != this.internalFrame) {
            return this.internalFrame.getWindowId();
        }
        return -1;
    }

    private void updateMenuItem() {
        if (this.internalFrame != null) {
            String string = "";
            this.setIcon(ResourceMng.getInstance().getIconDirect(string));
            String string2 = this.internalFrame.getTitle();
            if (null == string2) {
                string2 = "";
            }
            this.setText(string2);
            this.setBaseTitle(string2);
            this.setActionCommand("");
            this.setSelected(this.internalFrame.isSelected());
        } else if (this.frame != null) {
            String string = "";
            this.setIcon(ResourceMng.getInstance().getIconDirect(string));
            String string3 = this.frame.getTitle();
            if (null == string3) {
                string3 = "";
            }
            this.setText(string3);
            this.setBaseTitle(string3);
            this.setActionCommand("");
            this.setSelected(this.frame.isFocused());
        }
    }

    @Override
    public JToolTip createToolTip() {
        MultiRowToolTip multiRowToolTip = new MultiRowToolTip();
        multiRowToolTip.setMaxLineNumber(10);
        multiRowToolTip.setComponent(this);
        return multiRowToolTip;
    }

    public void updateMenuBaseTitle(String string) {
        this.setBaseTitle(string);
        this.setText(this.sno + ' ' + this.baseTitle);
        this.updateWindowPopupMenu();
    }

    public void updateMenuItemTitle(String string) {
        this.sno = string;
        this.setText(this.sno + ' ' + this.baseTitle);
        this.setName(this.getText());
        this.setMnemonic(this.sno.charAt(0));
        this.updateWindowPopupMenu();
    }

    @Override
    public void setText(String string) {
        String string2 = ScreenToolKit.getAbbreviatoryString(string, this.HALF_SCREENWITH, this.getFont());
        if (ResourceUtil.areEquals(string2, string)) {
            this.setToolTipText(null);
        } else {
            this.setToolTipText(this.getBaseTitle());
        }
        super.setText(string2);
    }

    private void updateWindowPopupMenu() {
        WindowManager windowManager = FrameworkUtilities.getWindowManager();
        windowManager.updateWindowPopupMenu();
    }

    public String getBaseTitle() {
        return this.baseTitle;
    }

    void setBaseTitle(String string) {
        this.baseTitle = string;
    }

    @Override
    public String toString() {
        String string = this.baseTitle;
        if (null == string || string.length() == 0) {
            string = " ";
        }
        return string;
    }

    @Override
    public void doClick(int n) {
        FrameworkUtilities.getWindowManager().clearAllSelected();
        logger.trace(" frame isSelected is" + this.isSelected());
        if (!this.isSelected()) {
            super.doClick(n);
            if (this.internalFrame != null) {
                JInternalFrame jInternalFrame;
                if (this.internalFrame.isIcon()) {
                    this.internalFrame.setIcon(false);
                }
                if ((jInternalFrame = FrameworkUtilities.getWindowManager().getDesktopPane().getNextMaximizableInternalFrame()) != null && jInternalFrame.isMaximum()) {
                    this.internalFrame.setMaximum(true);
                    NavigationHistory navigationHistory = (NavigationHistory)FrameworkUtilities.getWindowManager().getNavigationHistory();
                    int n2 = this.internalFrame.getWindowId();
                    navigationHistory.addWindow(n2);
                }
                try {
                    this.internalFrame.setSelected(true);
                }
                catch (Exception exception) {
                    logger.trace(exception.getMessage(), exception);
                }
            } else if (this.frame != null) {
                logger.trace("frame is not null" + this.frame.getName() + "state" + this.frame.getState());
                this.frame.setVisible(true);
                this.frame.requestFocus();
                if (this.frame.getState() == 1) {
                    this.frame.setState(0);
                }
            }
        }
    }

    @Override
    public boolean isAlwaysShown() {
        return true;
    }

    private class WindowMenuItemInternalFrameListener
    implements InternalFrameListener {
        private WindowMenuItemInternalFrameListener() {
        }

        @Override
        public void internalFrameOpened(InternalFrameEvent internalFrameEvent) {
        }

        @Override
        public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
        }

        @Override
        public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
            FrameworkUtilities.getWindowManager().removeMenuItem(WindowManagerCheckBoxMenuItem.this);
        }

        @Override
        public void internalFrameIconified(InternalFrameEvent internalFrameEvent) {
            WindowManagerCheckBoxMenuItem.this.setSelected(false);
        }

        @Override
        public void internalFrameDeiconified(InternalFrameEvent internalFrameEvent) {
            JInternalFrame jInternalFrame = internalFrameEvent.getInternalFrame();
            if (null != jInternalFrame && !jInternalFrame.isIcon()) {
                FrameworkUtilities.getWindowManager().selectMenuItem(WindowManagerCheckBoxMenuItem.this);
            }
        }

        @Override
        public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
            JInternalFrame jInternalFrame = internalFrameEvent.getInternalFrame();
            if (null != jInternalFrame && !jInternalFrame.isIcon()) {
                FrameworkUtilities.getWindowManager().selectMenuItem(WindowManagerCheckBoxMenuItem.this);
                try {
                    jInternalFrame.setClosed(false);
                }
                catch (PropertyVetoException propertyVetoException) {
                    logger.trace(propertyVetoException.getMessage(), propertyVetoException);
                }
            }
        }

        @Override
        public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
            WindowManagerCheckBoxMenuItem.this.setSelected(false);
        }
    }
}

