/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.windowmanagement;

import com.swimap.iview.commstyle.commandmng.CommandManager;
import com.swimap.iview.commstyle.commini.AreaDescContainer;
import com.swimap.iview.commstyle.commini.CheckBoxMenuItem;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.commini.Menu;
import com.swimap.iview.commstyle.commini.MenuItem;
import com.swimap.iview.commstyle.commini.foldingmenus.FoldingMenuItem;
import com.swimap.iview.commstyle.commini.xmlbind.PARA;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.framework.applicationmanagement.AppMenuManager;
import com.swimap.iview.framework.applicationmanagement.ApplicationData;
import com.swimap.iview.framework.applicationmanagement.ApplicationLauncher;
import com.swimap.iview.framework.mainframe.MDIFrame;
import com.swimap.iview.framework.menumanagement.MenuManager;
import com.swimap.iview.framework.modulemanagement.BaseModule;
import com.swimap.iview.framework.modulemanagement.InternalLocalMsg;
import com.swimap.iview.framework.modulemanagement.ModuleManagementException;
import com.swimap.iview.framework.modulemanagement.ModuleManager;
import com.swimap.iview.framework.subsystemmanagement.SubsystemManager;
import com.swimap.iview.framework.util.FrameworkCommandProcessor;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.framework.windowmanagement.ExtendWindow;
import com.swimap.iview.framework.windowmanagement.IDesktopListener;
import com.swimap.iview.framework.windowmanagement.IInternalFrameInterface;
import com.swimap.iview.framework.windowmanagement.IWindowManagerInterface;
import com.swimap.iview.framework.windowmanagement.InternalDialog;
import com.swimap.iview.framework.windowmanagement.InternalFrame;
import com.swimap.iview.framework.windowmanagement.MainDesktopPane;
import com.swimap.iview.framework.windowmanagement.ManagedFrameListener;
import com.swimap.iview.framework.windowmanagement.WindowListDlg;
import com.swimap.iview.framework.windowmanagement.WindowManagerCheckBoxMenuItem;
import com.swimap.iview.framework.windowmanagement.navigation.INavigationHistory;
import com.swimap.iview.framework.windowmanagement.navigation.NavigationHistory;
import com.swimap.iview.framework.windowmanagement.windowtabbed.WindowTabbedItem;
import com.swimap.iview.framework.windowmanagement.windowtabbed.WindowTabbedPane;
import com.swimap.iview.util.OptionPane;
import com.swimap.iview.util.ReflectionUtilities;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.mdi.ExtendedWindow;
import com.swimap.mdi.ExternalContainer;
import com.swimap.mdi.InternalLayer;
import com.swimap.mdi.WindowInterface;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import org.omg.CORBA.ORB;

public class WindowManager
extends BaseModule
implements IWindowManagerInterface {
    private static IviewLogger logger = IviewLogger.getLogger(WindowManager.class, "IVIEW");
    static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/framework/windowmanagement/Res");
    public static final String SETTING_FILE = "conf/mainfrm/mainframesetting";
    public static final int UPDATE_SETTING = 1;
    public static final int TOP_MOST_LAYER = JLayeredPane.DRAG_LAYER;
    public static final int MODAL_LAYER = JLayeredPane.MODAL_LAYER;
    public static final int COMMON_LAYER = JLayeredPane.PALETTE_LAYER;
    public static final int LOW_MOST_LAYER = JLayeredPane.DEFAULT_LAYER;
    public static final int WINDOW_REGISTER_ERROR = -1;
    public static final String MAIN_MENU_DESC = "mainMenu";
    public static final String WINDOW_MENU_DESC = "WindowMenu";
    protected Hashtable internalFrameStore = new Hashtable();
    protected Vector desktopListeners = new Vector();
    protected int windowIdKey = 0;
    private static final int FRAME_MENU_ID = 999;
    private int frameId = 999;
    public static final int INVALIDE_WINDOW_KEY = -1;
    protected MDIFrame parentFrame = null;
    protected MainDesktopPane desktopPane = new MainDesktopPane();
    protected static String moduleName = "window module(undefined)";
    private JSeparator menuSeparator = new JSeparator();
    public static final byte MAX_LIST_COUNT = 9;
    private Map<String, InternalFrame> activeAPPframes = new HashMap<String, InternalFrame>();
    private JMenuItem otherItem = new FoldingMenuItem(res.getString("ALL_WINDOW_ITEM")){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean isAlwaysShown() {
            return true;
        }
    };
    private WindowListDlg dlg = null;
    private static final int DLG_WIDTH = 400;
    private static final int DLG_HEIGHT = 400;
    private static final int INITIAL_CAPACITY = 20;
    private ConcurrentHashMap id_MenuItem_Map = new ConcurrentHashMap(20);
    private Vector menuItemList = new Vector();
    private Vector menuItemGroup = new Vector();
    private WindowManagerInternalFrameListener internalFrameListener = new WindowManagerInternalFrameListener();
    private InternalFramePropertyChangeListener propertyChangeListener = new InternalFramePropertyChangeListener();
    private boolean isLogout = false;
    private static final String WINDOW_MENU = "WindowMenu";
    private static final String FULL_SCREEN_MENU = "Fullscreen";
    private static final String CLOSE_WINDOW = "Close Window";
    private static final String PRINT_PREVIEW_MENU = "Print_Preview";
    private static final String PRINT_MENU = "Print";
    private static final String PAGE_SETUP_MENU = "Page_Setup";
    private static final String CLOSE_ALL = "Close all";
    private static final String MINIMIZE = "Minimize";
    private static final String MINIMIZE_ALL = "Minimize all";
    private static final String CASCADE = "Cascade";
    private static final String TILEFRAMES = "TileFrames";
    private static final String TILE_HORIZONTAL = "TileHorizontal";
    private static final String TILE_VERTICAL = "TileVertical";
    public static final String RESET_PERSPECTIVE = "ResetPerspective";
    public static final String DEFAULT_STYLE = "DefaultStyle";
    private boolean status = false;
    private static final String FULL_SCREEN_COMMAND_ID = "mainframe:fullscreen";
    private static final String DESC_MAINFRAME = "mainframe";
    private static final String PARA_MDI = "mdi";
    private static final String PARA_TITLE = "title";
    private ArrayList hideWindowId = new ArrayList(1);
    private ConcurrentHashMap windowMenuFrameMap = new ConcurrentHashMap(1);
    private ConcurrentHashMap frameListenerMap = new ConcurrentHashMap(1);
    private String customMenuItemName = null;
    private NavigationHistory navigationHistory = new NavigationHistory(this);
    boolean registerHistory = false;
    boolean regWindow = false;
    private boolean fullScreenPasswordProtected = false;
    private boolean fullScreenLock = false;
    private Object perMangerInstance = null;
    private static Comparator<Integer> integerComparator = new Comparator<Integer>(){

        @Override
        public int compare(Integer n, Integer n2) {
            return 0;
        }
    };

    public WindowManager(ModuleManager moduleManager, ORB oRB, String string, String string2, String string3) throws ModuleManagementException {
        super(moduleManager, oRB, string, string2);
        moduleName = string3;
        this.register(this);
        this.init();
    }

    public WindowManager(ModuleManager moduleManager, String string) throws ModuleManagementException {
        this(moduleManager, null, null, null, string);
    }

    private void init() {
        this.otherItem.setMnemonic(87);
        this.otherItem.setIcon(new ImageIcon(""));
        this.otherItem.setName("WindowManager_otherItem");
        this.otherItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WindowManager.this.showOtherWindow();
            }
        });
        if (Boolean.getBoolean("perspective")) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    WindowManager.this.perMangerInstance = ReflectionUtilities.callStaticMethod("com.swimap.iview.framework.dockingmanagement.PerspectiveManager", "getInstance", null, null);
                }
            }).start();
        }
    }

    private void showOtherWindow() {
        if (this.dlg == null) {
            this.dlg = new WindowListDlg(FrameworkUtilities.getMainFrame(), res.getString("ALL_WINDOW"), true);
            this.dlg.setResizable(false);
        }
        this.dlg.addListData(this.menuItemGroup);
        this.dlg.setSize(400, 400);
        ScreenToolKit.centerLocateToScreen(this.dlg);
        boolean bl = this.dlg.showDialog(this.getCurrentMenuItem((InternalFrame)this.getActiveWindow()));
        if (bl) {
            this.activateWindow(this.dlg.getSelectedID());
        }
    }

    private WindowManagerCheckBoxMenuItem getCurrentMenuItem(InternalFrame internalFrame) {
        Iterator iterator = this.menuItemGroup.iterator();
        WindowManagerCheckBoxMenuItem windowManagerCheckBoxMenuItem = null;
        while (iterator.hasNext()) {
            windowManagerCheckBoxMenuItem = (WindowManagerCheckBoxMenuItem)iterator.next();
            if (windowManagerCheckBoxMenuItem.getInternalFrame() != internalFrame) continue;
            return windowManagerCheckBoxMenuItem;
        }
        return null;
    }

    public void setMDIFrame(MDIFrame mDIFrame) {
        this.parentFrame = mDIFrame;
        if (this.readSetting()) {
            this.updateSettingPanel();
        }
    }

    public int registerWindow(InternalFrame internalFrame) {
        return this.registerWindow(internalFrame, COMMON_LAYER);
    }

    @Override
    public int registerWindow(InternalFrame internalFrame, int n) {
        return this.registerWindow(internalFrame, n, true);
    }

    public int registerWindow(InternalFrame internalFrame, int n, boolean bl) {
        boolean bl2 = true;
        InternalFrame internalFrame2 = (InternalFrame)this.getActiveWindow();
        if (internalFrame2 != null && internalFrame.isManaged()) {
            if (internalFrame2.isMaximizable() && internalFrame2.isManaged()) {
                bl2 = internalFrame2.isMaximum();
            } else {
                JInternalFrame jInternalFrame = this.desktopPane.getNextMaximizableInternalFrame();
                if (null != jInternalFrame) {
                    bl2 = jInternalFrame.isMaximum();
                }
            }
        }
        return this.registerWindow(internalFrame, n, bl, bl2);
    }

    public int registerWindow(InternalFrame internalFrame, int n, boolean bl, boolean bl2) {
        Serializable serializable;
        Object object;
        int n2 = this.getWindowIdKey();
        if (null != this.internalFrameStore.get(internalFrame.getWindowId())) {
            int n3 = internalFrame.getWindowId();
            this.navigationHistory.addWindow(n3);
            return -1;
        }
        this.deIconifyMainFrame();
        internalFrame.setWindowManager(this);
        internalFrame.setLayer(n);
        internalFrame.setWindowId(n2);
        if (!internalFrame.styleLoaded() && bl) {
            internalFrame.setSize(this.desktopPane.getDefaultSizeOfInternaFrame());
            internalFrame.setLocation(this.desktopPane.getPosOfNewInternalFrame(internalFrame));
        }
        ApplicationLauncher applicationLauncher = ApplicationLauncher.getAppLauncher();
        logger.debug("  Registering Window , launch App Id : " + applicationLauncher.getCurrentLaunchAppId() + " , Visible App Id :: " + applicationLauncher.getVisibleAppId() + " , Active Frame App Id :: " + applicationLauncher.getActiveFrameAppId());
        internalFrame.addInternalFrameListener(this.internalFrameListener);
        internalFrame.addPropertyChangeListener(this.propertyChangeListener);
        if (FrameworkCommandProcessor.getInstance().isAppStyle()) {
            object = ApplicationLauncher.getAppLauncher().getVisibleAppId();
            if (null == object) {
                object = this.getAppIdFromActiveMenuManager();
            }
            internalFrame.setAppID((String)object);
        }
        this.internalFrameStore.put(n2, internalFrame);
        this.regWindow = true;
        logger.trace("Internal Frame registered wih the window  - " + internalFrame.getName());
        internalFrame.setRegister(true);
        if (!this.updateMenu(internalFrame)) {
            logger.trace("Update menu failed:" + internalFrame.getTitle());
        }
        if (FrameworkCommandProcessor.getInstance().isAppStyle() && !(internalFrame instanceof InternalDialog) && ((ApplicationData)(object = ApplicationLauncher.getAppLauncher().getApplicationData(internalFrame.getAppID()))).getWindow() != null && ((Component)(serializable = ((ApplicationData)object).getWindow())).isVisible()) {
            ApplicationLauncher.getAppLauncher().setIsAppEmptyFrameDisposing(true);
            if (internalFrame.isMaximizable()) {
                ((InternalFrame)serializable).setMaximum(false);
            }
            ((InternalFrame)serializable).closeWindow();
            ApplicationLauncher.getAppLauncher().setIsAppEmptyFrameDisposing(false);
        }
        this.desktopPane.add(internalFrame);
        FrameworkUtilities.getWindowTabbedManager().addTab(internalFrame);
        object = internalFrame.getSize();
        serializable = internalFrame.getAdjustedMaxSize();
        if (null != serializable) {
            internalFrame.setSize(new Dimension(((Rectangle)serializable).width, ((Rectangle)serializable).height));
        }
        internalFrame.setVisible(true);
        internalFrame.setSize((Dimension)object);
        internalFrame.setMaximum(bl2);
        internalFrame.getDesktopIcon().setToolTipText(internalFrame.getTitle());
        int n4 = internalFrame.getWindowId();
        this.navigationHistory.addWindow(n4);
        return internalFrame.getWindowId();
    }

    private String getAppIdFromActiveMenuManager() {
        String string = null;
        MenuManager menuManager = FrameworkUtilities.getMenuManager();
        if (menuManager instanceof AppMenuManager) {
            string = ((AppMenuManager)menuManager).getAppId();
        }
        logger.debug("GetAppId from active menumanager:" + string);
        return string;
    }

    public void hideTab(InternalFrame internalFrame) {
        if (!FrameworkUtilities.getWindowTabbedManager().isTabbedBarEnable()) {
            return;
        }
        boolean bl = false;
        this.hideWindowId.add(internalFrame.getWindowId());
        this.hideWindowItem(internalFrame);
        FrameworkUtilities.getWindowTabbedManager().getTabbedBar().hideTab(internalFrame.getWindowId());
        if (internalFrame.isMaximum()) {
            bl = true;
        }
        internalFrame.setVisible(false);
        internalFrame.setMaximizable(false);
        InternalFrame internalFrame2 = (InternalFrame)FrameworkUtilities.getWindowManager().getDesktopPane().getNextMaximizableInternalFrame();
        if (internalFrame2 != null) {
            WindowTabbedItem windowTabbedItem = (WindowTabbedItem)FrameworkUtilities.getWindowTabbedManager().getTabbedBar().getEntries().get(internalFrame2.getWindowId());
            FrameworkUtilities.getWindowTabbedManager().getTabbedBar().selectTab(windowTabbedItem);
            if (bl) {
                internalFrame2.setMaximum(true);
            }
            if (internalFrame.isIcon()) {
                internalFrame.setIcon(false);
                internalFrame2.setIcon(true);
            }
        }
        this.desktopPane.remove(internalFrame);
    }

    public void showTab(InternalFrame internalFrame) {
        if (!FrameworkUtilities.getWindowTabbedManager().isTabbedBarEnable()) {
            return;
        }
        FrameworkUtilities.getWindowTabbedManager().getTabbedBar().showTab(internalFrame.getWindowId());
        this.showWinidowItem(internalFrame);
        InternalFrame internalFrame2 = (InternalFrame)FrameworkUtilities.getWindowManager().getDesktopPane().getNextMaximizableInternalFrame();
        this.desktopPane.add(internalFrame);
        if (internalFrame2.isMaximum()) {
            internalFrame.setMaximizable(true);
            internalFrame.setVisible(true);
            internalFrame.setMaximum(true);
        } else {
            internalFrame.setMaximizable(true);
            internalFrame.setVisible(true);
        }
        internalFrame.setSelected(true);
        this.hideWindowId.remove((Object)internalFrame.getWindowId());
    }

    public boolean hiddenFrameList(InternalFrame internalFrame) {
        ListIterator listIterator = this.hideWindowId.listIterator();
        while (listIterator.hasNext()) {
            int n = (Integer)listIterator.next();
            if (n != internalFrame.getWindowId()) continue;
            return true;
        }
        return false;
    }

    public void setFrameVisible(WindowInterface windowInterface, boolean bl) {
        if (bl) {
            this.showFrame(windowInterface);
        } else {
            this.hideFrame(windowInterface);
        }
    }

    void showFrame(WindowInterface windowInterface) {
        if (null == windowInterface) {
            throw new IllegalArgumentException("Frame argument canot be null");
        }
        if (windowInterface instanceof InternalFrame) {
            InternalFrame internalFrame = (InternalFrame)windowInterface;
            if (this.hiddenFrameList(internalFrame)) {
                this.showTab(internalFrame);
                logger.trace("Frame :" + internalFrame.getTitle() + "is shown Succesfully");
            } else {
                logger.trace("Frame :" + internalFrame.getTitle() + "is not hidden so it cannot be shown");
            }
        } else if (windowInterface instanceof ExtendedWindow) {
            ExtendedWindow extendedWindow = (ExtendedWindow)windowInterface;
            InternalFrame internalFrame = (InternalFrame)extendedWindow.getContainer();
            if (this.hiddenFrameList(internalFrame)) {
                this.showTab(internalFrame);
                logger.trace("Hidden frame: " + internalFrame.getTitle() + " is shown");
            } else {
                logger.trace("Frame : " + internalFrame.getTitle() + "is not hidden ");
            }
        } else {
            logger.trace("Incorrect paramenter:Parameter can be only frame or Extended window");
        }
    }

    void hideFrame(WindowInterface windowInterface) {
        if (null == windowInterface) {
            throw new IllegalArgumentException("NULL FRAME!Frame argument cannot be null");
        }
        if (windowInterface instanceof InternalFrame) {
            InternalFrame internalFrame = (InternalFrame)windowInterface;
            if (this.hiddenFrameList(internalFrame)) {
                logger.trace("Frame: " + internalFrame.getTitle() + "  is already hidden");
            } else {
                this.hideTab(internalFrame);
                logger.trace("Frame : " + internalFrame.getTitle() + " is hidden Succesfully  ");
            }
        } else if (windowInterface instanceof ExtendedWindow) {
            ExtendedWindow extendedWindow = (ExtendedWindow)windowInterface;
            InternalFrame internalFrame = (InternalFrame)extendedWindow.getContainer();
            if (this.hiddenFrameList(internalFrame)) {
                logger.trace("Frame: " + internalFrame.getTitle() + "  is already hidden");
            } else {
                this.hideTab(internalFrame);
                logger.trace("Frame : " + internalFrame.getTitle() + " is hidden Succesfully  ");
            }
        } else {
            logger.trace("Incorrect parameterParameter can only be frame or Extend Window");
        }
    }

    private synchronized int getWindowIdKey() {
        return this.windowIdKey++;
    }

    public void showFullScreen(InternalFrame internalFrame) {
        if (null == this.internalFrameStore.get(internalFrame.getWindowId())) {
            logger.error("The internalFrame:" + internalFrame.getTitle() + " is not registered.");
            return;
        }
        ScreenToolKit.showFullScreen(FrameworkUtilities.getMainFrame(), internalFrame);
        internalFrame.getMostRecentFocusOwner().requestFocus();
        if (null != internalFrame.getModalChild()) {
            internalFrame.getModalChild().getMostRecentFocusOwner().requestFocus();
        }
    }

    public void fullScreenActiveWindow() {
        InternalFrame internalFrame = (InternalFrame)this.desktopPane.getSelectedFrame();
        if (null != internalFrame) {
            this.showFullScreen(internalFrame);
        }
    }

    @Override
    public boolean activateWindow(int n) {
        InternalFrame internalFrame = (InternalFrame)this.internalFrameStore.get(n);
        if (null == internalFrame) {
            logger.trace("The window being activated does no exist.");
            return false;
        }
        this.deIconifyMainFrame();
        internalFrame.setIcon(false);
        internalFrame.setSelected(true);
        logger.trace("The frame: " + internalFrame.getTitle() + " maximum state is :" + internalFrame.isMaximum() + "Managed :" + internalFrame.isManaged());
        return true;
    }

    private void deIconifyMainFrame() {
        JFrame jFrame = FrameworkUtilities.getMainFrame();
        if (null != jFrame) {
            if (jFrame.getState() == 1) {
                jFrame.setState(0);
            } else {
                Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
                if (window == jFrame) {
                    return;
                }
                ArrayList<Window> arrayList = new ArrayList<Window>(5);
                this.getAllWindows(arrayList, jFrame);
                if (window == null || !arrayList.contains(window)) {
                    jFrame.toFront();
                }
            }
        }
    }

    private void getAllWindows(List<Window> list, Window window) {
        if (null == window) {
            return;
        }
        for (Window window2 : window.getOwnedWindows()) {
            list.add(window2);
            this.getAllWindows(list, window2);
        }
    }

    private void closeInternalDlg() {
        JInternalFrame[] jInternalFrameArray = this.desktopPane.getAllFrames();
        if (null != jInternalFrameArray && jInternalFrameArray.length > 0) {
            for (int i = 0; i < jInternalFrameArray.length; ++i) {
                if (!(jInternalFrameArray[i] instanceof InternalDialog)) continue;
                InternalDialog internalDialog = (InternalDialog)jInternalFrameArray[i];
                try {
                    if (internalDialog.closeWindow()) continue;
                    logger.error("Can't close InternalDialog :" + internalDialog.getTitle());
                    continue;
                }
                catch (Exception exception) {
                    logger.trace(exception.getMessage(), exception);
                }
            }
        }
    }

    @Override
    public void closeAllWindows() {
        logger.debug("start to close All windows ");
        boolean bl = true;
        JInternalFrame[] jInternalFrameArray = this.desktopPane.getAllFrames();
        if (null != jInternalFrameArray && jInternalFrameArray.length > 0) {
            for (int i = 0; i < jInternalFrameArray.length; ++i) {
                if (!jInternalFrameArray[i].isClosable()) {
                    if (this.isLogout) {
                        try {
                            jInternalFrameArray[i].dispose();
                        }
                        catch (Exception exception) {
                            logger.trace(exception.getMessage(), exception);
                        }
                        continue;
                    }
                    bl = false;
                    continue;
                }
                if (((InternalFrame)jInternalFrameArray[i]).isBusy()) {
                    logger.debug(jInternalFrameArray[i].getTitle() + " internalFrame is busy, can't close.");
                    bl = false;
                    continue;
                }
                if (jInternalFrameArray[i] instanceof InternalFrame) {
                    InternalFrame internalFrame = (InternalFrame)jInternalFrameArray[i];
                    try {
                        boolean bl2 = this.closeWindow(internalFrame.getWindowId());
                        if (!bl2) {
                            logger.error("Can't close window:" + internalFrame.getTitle());
                        }
                    }
                    catch (Exception exception) {
                        logger.trace(exception.getMessage(), exception);
                    }
                }
                if (jInternalFrameArray[i].isClosed()) continue;
                bl = false;
            }
        }
        Set set = this.frameListenerMap.keySet();
        boolean bl3 = true;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            boolean bl4 = true;
            Object e = iterator.next();
            ManagedFrameListener managedFrameListener = (ManagedFrameListener)this.frameListenerMap.get(e);
            bl4 = managedFrameListener.closeFrame();
            if (bl4) continue;
            bl3 = false;
            logger.debug("Frame " + ((JFrame)e).getTitle() + " Cannot be closed");
        }
        if (bl && bl3) {
            this.clearWindowMenuItem();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WindowTabbedPane windowTabbedPane = FrameworkUtilities.getWindowTabbedManager().getTabbedBar();
                if (null != windowTabbedPane) {
                    windowTabbedPane.updateUI();
                }
            }
        });
        logger.debug("End to close all windows");
    }

    public InternalFrame getWindow(int n) {
        InternalFrame internalFrame = (InternalFrame)this.internalFrameStore.get(n);
        return internalFrame;
    }

    @Override
    public boolean setWindowLayerNumber(int n, int n2) {
        InternalFrame internalFrame = this.getWindow(n);
        if (null == internalFrame) {
            return false;
        }
        internalFrame.setLayer(n2);
        return true;
    }

    @Override
    public void tileWindows() {
        this.desktopPane.tileInternalFrames(0);
    }

    public void tileVerticalWindows() {
        this.desktopPane.tileInternalFrames(1);
    }

    public void tileFrames() {
        this.desktopPane.tileFrames();
    }

    @Override
    public void cascadeWindows() {
        this.desktopPane.cascadeInternalFrames();
    }

    @Override
    public void minimizeAllWindows() {
        this.desktopPane.minimizeAllWindows();
        this.refreshMenuStatus();
    }

    @Override
    public boolean minimizeWindow(int n) {
        InternalFrame internalFrame = this.getWindow(n);
        if (null == internalFrame) {
            return false;
        }
        if (!internalFrame.isIconifiable()) {
            return false;
        }
        internalFrame.setIcon(true);
        return true;
    }

    @Override
    public boolean maximizeWindow(int n) {
        InternalFrame internalFrame = this.getWindow(n);
        if (null == internalFrame) {
            return false;
        }
        if (!internalFrame.isMaximizable()) {
            return false;
        }
        internalFrame.setMaximum(true);
        return true;
    }

    public boolean maximizeActivateWindow() {
        return this.maximizeWindow(this.getActiveWindowId());
    }

    public boolean minimizeActivateWindow() {
        return this.minimizeWindow(this.getActiveWindowId());
    }

    public boolean restoreWindow(int n) {
        InternalFrame internalFrame = this.getWindow(n);
        if (null == internalFrame) {
            return false;
        }
        internalFrame.setMaximum(false);
        return true;
    }

    @Override
    public boolean closeWindow(int n) {
        InternalFrame internalFrame = this.getWindow(n);
        if (null == internalFrame) {
            return false;
        }
        if (!internalFrame.closeWindow()) {
            return false;
        }
        this.updateWindowPopupMenu();
        return true;
    }

    final void updateWindowPopupMenu() {
        MenuManager menuManager = FrameworkUtilities.getMenuManager();
        Menu menu = menuManager.getBaseMenuSet().getMenu("WindowMenu");
        if (menu != null && menu.isShowing() && menu.getPopupMenuOrigin().x < 0) {
            menu.getPopupMenu().setSize(menu.getPopupMenu().getPreferredSize().width + menu.getPopupMenuOrigin().x, menu.getPopupMenu().getPreferredSize().height);
        }
    }

    public boolean closeActivateWindow() {
        return this.closeWindow(this.getActiveWindowId());
    }

    public void closeAllWindowsAndDialogs() {
        this.isLogout = true;
        this.closeAllWindows();
        this.closeInternalDlg();
        this.isLogout = false;
    }

    @Override
    public void clear() {
        super.clear();
        this.isLogout = true;
        this.clearMenu();
        this.isLogout = false;
    }

    private void clearMenu() {
        MenuManager menuManager = this.parentFrame.getMenuManager();
        for (int i = 0; i < this.menuItemList.size(); ++i) {
            try {
                JMenuItem jMenuItem = (JMenuItem)this.menuItemList.get(i);
                menuManager.removeMenuItem(MAIN_MENU_DESC, "WindowMenu", jMenuItem);
                continue;
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
            }
        }
        Menu menu = menuManager.getMenu(MAIN_MENU_DESC, "WindowMenu");
        if (null != menu && menu.getMenuComponent(menu.getMenuComponentCount() - 1).equals(this.menuSeparator)) {
            menuManager.removeSeparator(MAIN_MENU_DESC, "WindowMenu", this.menuSeparator);
        }
        this.menuItemList.removeAllElements();
        this.menuItemGroup.removeAllElements();
        this.id_MenuItem_Map.clear();
    }

    public final boolean isLogout() {
        return this.isLogout;
    }

    @Override
    public boolean unregisterWindow(int n) {
        Object object;
        InternalFrame internalFrame = this.getWindow(n);
        if (null == internalFrame) {
            return false;
        }
        boolean bl = !internalFrame.isVisible();
        boolean bl2 = internalFrame.isMaximum();
        if (!bl && bl2) {
            internalFrame.setMaximum(false);
        }
        this.internalFrameStore.remove(n);
        if (!bl) {
            internalFrame.setSelected(false);
            internalFrame.disposeOnly();
            this.desktopPane.getDesktopManager().closeFrame(internalFrame);
            this.desktopPane.invalidate();
            this.desktopPane.repaint();
        }
        internalFrame.removeInternalFrameListener(this.internalFrameListener);
        internalFrame.removePropertyChangeListener(this.propertyChangeListener);
        JMenuItem jMenuItem = internalFrame.getRelationalMenuItem();
        this.id_MenuItem_Map.remove(n);
        this.menuItemGroup.remove(jMenuItem);
        if (null != jMenuItem) {
            object = this.parentFrame.getMenuManager();
            if (null != object) {
                if (this.internalFrameStore.entrySet().size() < 1 && this.windowMenuFrameMap.entrySet().size() < 1) {
                    ((MenuManager)object).removeSeparator(MAIN_MENU_DESC, "WindowMenu", this.menuSeparator);
                }
                if (this.menuItemGroup.size() == 9) {
                    ((MenuManager)object).removeMenuItem(MAIN_MENU_DESC, "WindowMenu", this.otherItem);
                }
                ((MenuManager)object).removeMenuItem(MAIN_MENU_DESC, "WindowMenu", jMenuItem);
                this.menuItemList.remove(jMenuItem);
                this.updateMenuItemTitle();
            }
            if (jMenuItem instanceof WindowManagerCheckBoxMenuItem) {
                ((WindowManagerCheckBoxMenuItem)jMenuItem).setInternalFrame(null);
            }
            jMenuItem = null;
        }
        internalFrame.setRelationalMenuItem(null);
        internalFrame.setRegister(false);
        if (!bl && bl2 && (object = this.desktopPane.getNextMaximizableInternalFrame()) != null) {
            try {
                ((JInternalFrame)object).setMaximum(true);
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
            }
        }
        this.navigationHistory.removeWindows(n);
        this.desktopPane.activeFrame();
        return true;
    }

    void hideWindowItem(InternalFrame internalFrame) {
        JMenuItem jMenuItem = null;
        jMenuItem = internalFrame.getRelationalMenuItem();
        WindowManagerCheckBoxMenuItem windowManagerCheckBoxMenuItem = (WindowManagerCheckBoxMenuItem)jMenuItem;
        FrameworkUtilities.getWindowManager().removeMenuItem(windowManagerCheckBoxMenuItem);
        MenuManager menuManager = this.parentFrame.getMenuManager();
        if (null != menuManager && this.menuItemGroup.size() < 1) {
            menuManager.removeSeparator(MAIN_MENU_DESC, "WindowMenu", this.menuSeparator);
            MenuManager menuManager2 = FrameworkUtilities.getMenuManager();
            Menu menu = menuManager2.getBaseMenuSet().getMenu("WindowMenu");
            this.setMenuItemEnabled(menu, CASCADE, false);
            this.setMenuItemEnabled(menu, TILEFRAMES, false);
            this.setMenuItemEnabled(menu, TILE_HORIZONTAL, false);
            this.setMenuItemEnabled(menu, TILE_VERTICAL, false);
            this.setMenuItemEnabled(menu, MINIMIZE_ALL, false);
            this.setMenuItemEnabled(menu, MINIMIZE, false);
            this.setMenuItemEnabled(menu, CLOSE_ALL, false);
            this.setMenuItemEnabled(menu, CLOSE_WINDOW, false);
            this.setMenuItemEnabled(menu, FULL_SCREEN_MENU, false);
        }
        this.updateMenuItemTitle();
    }

    void showWinidowItem(InternalFrame internalFrame) {
        JMenuItem jMenuItem = internalFrame.getRelationalMenuItem();
        if (null != jMenuItem) {
            MenuManager menuManager = this.parentFrame.getMenuManager();
            if (menuManager != null && this.menuItemGroup.size() < 1) {
                menuManager.addSeparator(MAIN_MENU_DESC, "WindowMenu", this.menuSeparator);
                MenuManager menuManager2 = FrameworkUtilities.getMenuManager();
                Menu menu = menuManager2.getBaseMenuSet().getMenu("WindowMenu");
                this.setMenuItemEnabled(menu, CASCADE, true);
                this.setMenuItemEnabled(menu, TILEFRAMES, true);
                this.setMenuItemEnabled(menu, TILE_HORIZONTAL, true);
                this.setMenuItemEnabled(menu, TILE_VERTICAL, true);
                this.setMenuItemEnabled(menu, MINIMIZE_ALL, true);
                this.setMenuItemEnabled(menu, MINIMIZE, true);
                this.setMenuItemEnabled(menu, CLOSE_ALL, true);
                this.setMenuItemEnabled(menu, CLOSE_WINDOW, true);
                this.setMenuItemEnabled(menu, FULL_SCREEN_MENU, true);
            }
            if (!this.updateMenu(internalFrame)) {
                logger.trace("Update menu failed:" + internalFrame.getTitle());
            }
            this.updateMenuItemTitle();
        } else {
            logger.trace(" menu iten of the frame is null");
        }
    }

    protected boolean updateMenu(InternalFrame internalFrame) {
        Menu menu;
        if (null == this.parentFrame) {
            return false;
        }
        WindowManagerCheckBoxMenuItem windowManagerCheckBoxMenuItem = null;
        WindowManagerCheckBoxMenuItem windowManagerCheckBoxMenuItem2 = (WindowManagerCheckBoxMenuItem)internalFrame.getRelationalMenuItem();
        windowManagerCheckBoxMenuItem = windowManagerCheckBoxMenuItem2 == null ? new WindowManagerCheckBoxMenuItem(internalFrame) : windowManagerCheckBoxMenuItem2;
        internalFrame.setRelationalMenuItem(windowManagerCheckBoxMenuItem);
        MenuManager menuManager = this.parentFrame.getMenuManager();
        if (null != menuManager && null != (menu = menuManager.getMenu(MAIN_MENU_DESC, "WindowMenu"))) {
            int n;
            if (this.menuItemGroup.size() < 1) {
                menuManager.addSeparator(MAIN_MENU_DESC, "WindowMenu", this.menuSeparator);
            }
            if ((n = this.menuItemList.size()) < 9) {
                menuManager.addMenuItem(MAIN_MENU_DESC, "WindowMenu", windowManagerCheckBoxMenuItem);
                this.menuItemList.addElement(windowManagerCheckBoxMenuItem);
            } else if (n == 9) {
                menuManager.addMenuItem(MAIN_MENU_DESC, "WindowMenu", this.otherItem);
            }
            this.id_MenuItem_Map.put(internalFrame.getWindowId(), windowManagerCheckBoxMenuItem);
            this.menuItemGroup.add(windowManagerCheckBoxMenuItem);
        }
        return true;
    }

    public boolean addWindowMenuItem(JFrame jFrame, ManagedFrameListener managedFrameListener, String string) {
        this.customMenuItemName = string;
        return this.addWindowMenuItem(jFrame, managedFrameListener);
    }

    public boolean addWindowMenuItem(final JFrame jFrame, ManagedFrameListener managedFrameListener) {
        if (null == jFrame || managedFrameListener == null) {
            logger.debug("MenuItem and ManageableFrame reference cannot be null");
            return false;
        }
        if (null != this.windowMenuFrameMap.get(jFrame)) {
            logger.debug("This menu:" + jFrame.getTitle() + " already exists in the Window Menu");
            return false;
        }
        final MenuManager menuManager = this.parentFrame.getMenuManager();
        Menu menu = menuManager.getMenu(MAIN_MENU_DESC, "WindowMenu");
        final WindowManagerCheckBoxMenuItem windowManagerCheckBoxMenuItem = new WindowManagerCheckBoxMenuItem(jFrame);
        jFrame.addWindowListener(new WindowListener(){
            boolean windowClosed = false;
            boolean windowClosing = false;

            @Override
            public void windowActivated(WindowEvent windowEvent) {
                windowManagerCheckBoxMenuItem.setSelected(true);
                WindowManager.this.refreshMenuStatus();
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                if (this.windowClosed) {
                    return;
                }
                WindowManager.this.removeWindowMenuItem(jFrame);
                if (WindowManager.this.internalFrameStore.entrySet().size() < 1 && WindowManager.this.windowMenuFrameMap.entrySet().size() < 1) {
                    menuManager.removeSeparator(WindowManager.MAIN_MENU_DESC, "WindowMenu", WindowManager.this.menuSeparator);
                }
                WindowManager.this.refreshMenuStatus();
                this.windowClosed = true;
            }

            @Override
            public void windowDeactivated(WindowEvent windowEvent) {
                IInternalFrameInterface iInternalFrameInterface = null;
                try {
                    windowManagerCheckBoxMenuItem.setSelected(false);
                    iInternalFrameInterface = FrameworkUtilities.getWindowManager().getActiveWindow();
                    if (iInternalFrameInterface instanceof InternalFrame) {
                        ((InternalFrame)iInternalFrameInterface).getRelationalMenuItem().setSelected(true);
                    }
                }
                catch (Exception exception) {
                    logger.error("Exception while deactivating the frame : " + iInternalFrameInterface, exception);
                }
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (this.windowClosing) {
                    return;
                }
                WindowManager.this.removeWindowMenuItem(jFrame);
                if (WindowManager.this.internalFrameStore.entrySet().size() < 1 && WindowManager.this.windowMenuFrameMap.entrySet().size() < 1) {
                    menuManager.removeSeparator(WindowManager.MAIN_MENU_DESC, "WindowMenu", WindowManager.this.menuSeparator);
                }
                WindowManager.this.refreshMenuStatus();
                this.windowClosing = true;
            }

            @Override
            public void windowDeiconified(WindowEvent windowEvent) {
            }

            @Override
            public void windowIconified(WindowEvent windowEvent) {
            }

            @Override
            public void windowOpened(WindowEvent windowEvent) {
            }
        });
        if (null == this.parentFrame) {
            return false;
        }
        WindowManagerCheckBoxMenuItem windowManagerCheckBoxMenuItem2 = windowManagerCheckBoxMenuItem;
        if (this.customMenuItemName != null && !"".equals(this.customMenuItemName)) {
            windowManagerCheckBoxMenuItem2.setText(this.customMenuItemName);
            windowManagerCheckBoxMenuItem2.setBaseTitle(this.customMenuItemName);
            this.customMenuItemName = "";
        }
        if (null != menu) {
            int n;
            if (this.internalFrameStore.entrySet().size() == 0 && this.windowMenuFrameMap.keySet().size() == 0) {
                menuManager.addSeparator(MAIN_MENU_DESC, "WindowMenu", this.menuSeparator);
            }
            if ((n = this.id_MenuItem_Map.size()) < 9) {
                menuManager.addMenuItem(MAIN_MENU_DESC, "WindowMenu", windowManagerCheckBoxMenuItem2);
                this.menuItemList.addElement(windowManagerCheckBoxMenuItem2);
            } else if (n == 9) {
                menuManager.addMenuItem(MAIN_MENU_DESC, "WindowMenu", this.otherItem);
            }
            this.id_MenuItem_Map.put(this.frameId++, windowManagerCheckBoxMenuItem2);
            this.windowMenuFrameMap.put(jFrame, windowManagerCheckBoxMenuItem2);
            this.frameListenerMap.put(jFrame, managedFrameListener);
            this.menuItemGroup.add(windowManagerCheckBoxMenuItem2);
        }
        this.updateMenuItemTitle();
        return true;
    }

    public boolean removeWindowMenuItem(JFrame jFrame) {
        if (null != jFrame) {
            MenuManager menuManager = this.parentFrame.getMenuManager();
            Menu menu = menuManager.getMenu(MAIN_MENU_DESC, "WindowMenu");
            Object v = this.windowMenuFrameMap.remove(jFrame);
            if (null != v) {
                menu.remove((WindowManagerCheckBoxMenuItem)v);
            }
            this.menuItemList.remove(v);
            this.menuItemGroup.remove(v);
            ManagedFrameListener managedFrameListener = (ManagedFrameListener)this.frameListenerMap.get(jFrame);
            if (managedFrameListener != null) {
                this.frameListenerMap.remove(jFrame);
                managedFrameListener.closeFrame();
            } else {
                logger.debug("Window listener is null, cannot notify the frame close");
            }
            Set set = this.id_MenuItem_Map.keySet();
            Object var7_72 = null;
            for (Object var7_72 : set) {
                if (null == v || !this.id_MenuItem_Map.get(var7_72).equals(v)) continue;
                this.id_MenuItem_Map.remove(var7_72);
                break;
            }
            this.updateMenuItemTitle();
            return true;
        }
        return false;
    }

    @Override
    public String getModuleName() {
        return moduleName;
    }

    @Override
    public MainDesktopPane getDesktopPane() {
        return this.desktopPane;
    }

    @Override
    public int getActiveWindowId() {
        JInternalFrame jInternalFrame = this.desktopPane.getSelectedFrame();
        if (null != jInternalFrame && !jInternalFrame.isIcon()) {
            return ((InternalFrame)jInternalFrame).getWindowId();
        }
        return -1;
    }

    @Override
    public IInternalFrameInterface getActiveWindow() {
        IInternalFrameInterface iInternalFrameInterface = (IInternalFrameInterface)((Object)this.desktopPane.getSelectedFrame());
        if (iInternalFrameInterface instanceof InternalDialog) {
            iInternalFrameInterface = ((InternalDialog)iInternalFrameInterface).getParentInternalFrame();
        }
        if (iInternalFrameInterface instanceof InternalFrame) {
            InternalFrame internalFrame = (InternalFrame)iInternalFrameInterface;
            if (!internalFrame.isIcon()) {
                return internalFrame;
            }
            return null;
        }
        return iInternalFrameInterface;
    }

    @Override
    public void addDesktopListener(IDesktopListener iDesktopListener) {
        this.desktopListeners.add(iDesktopListener);
    }

    @Override
    public void removeDesktopListener(IDesktopListener iDesktopListener) {
        this.desktopListeners.remove(iDesktopListener);
    }

    @Override
    public void notifyDesktopListener(int n) {
        if (null == this.desktopListeners) {
            return;
        }
        InternalFrame internalFrame = this.getWindow(n);
        if (null == internalFrame || !internalFrame.isMaximizable()) {
            return;
        }
        Enumeration enumeration = this.desktopListeners.elements();
        while (enumeration.hasMoreElements()) {
            IDesktopListener iDesktopListener = (IDesktopListener)enumeration.nextElement();
            if (null == iDesktopListener) continue;
            iDesktopListener.currentWindowStateChanged(n, internalFrame.isMaximum());
        }
    }

    private void refreshMenuStatus() {
        this.refreshFileMenuStatus(this.getActiveWindow());
        this.refreshWindowMenuStatus();
    }

    final void refreshFileMenuStatus(IInternalFrameInterface iInternalFrameInterface) {
        if (iInternalFrameInterface != this.getActiveWindow()) {
            return;
        }
        MenuManager menuManager = FrameworkUtilities.getMenuManager();
        if (null == menuManager || null == menuManager.getBaseMenuSet()) {
            return;
        }
        Menu menu = menuManager.getBaseMenuSet().getMenu("FileMenu");
        if (menu == null) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        if (iInternalFrameInterface instanceof InternalFrame) {
            InternalFrame internalFrame = (InternalFrame)iInternalFrameInterface;
            bl = internalFrame.isPreviewable();
            bl2 = internalFrame.isPrintable();
        }
        this.setMenuItemEnabled(menu, PRINT_PREVIEW_MENU, bl);
        this.setMenuItemEnabled(menu, PRINT_MENU, bl2);
        this.setMenuItemEnabled(menu, PAGE_SETUP_MENU, bl || bl2);
    }

    private void refreshWindowMenuStatus() {
        int n;
        int n2;
        int n3;
        MenuManager menuManager = FrameworkUtilities.getMenuManager();
        if (null == menuManager || null == menuManager.getBaseMenuSet()) {
            return;
        }
        Menu menu = menuManager.getBaseMenuSet().getMenu("WindowMenu");
        if (menu == null) {
            return;
        }
        if (this.getActiveWindow() == null || !((JInternalFrame)((Object)this.getActiveWindow())).isClosable() || ((InternalFrame)this.getActiveWindow()).isBusy()) {
            this.setMenuItemEnabled(menu, CLOSE_WINDOW, false);
        } else {
            this.setMenuItemEnabled(menu, CLOSE_WINDOW, true);
        }
        JInternalFrame[] jInternalFrameArray = this.desktopPane.getAllFrames();
        for (n3 = jInternalFrameArray.length - 1; n3 >= 0 && (!jInternalFrameArray[n3].isClosable() || ((InternalFrame)jInternalFrameArray[n3]).isBusy() || jInternalFrameArray[n3] instanceof InternalDialog); --n3) {
        }
        if (n3 < 0 || jInternalFrameArray.length == 0) {
            this.setMenuItemEnabled(menu, CLOSE_ALL, false);
        } else {
            this.setMenuItemEnabled(menu, CLOSE_ALL, true);
        }
        Component component = menu.getMenuItem(CLOSE_ALL);
        int n4 = this.windowMenuFrameMap.size();
        if (n4 != 0 && !component.isEnabled()) {
            this.setMenuItemEnabled(menu, CLOSE_ALL, true);
        }
        jInternalFrameArray = this.desktopPane.getAllFrames();
        for (n2 = jInternalFrameArray.length - 1; n2 >= 0 && (!jInternalFrameArray[n2].isIconifiable() || jInternalFrameArray[n2].isIcon()); --n2) {
        }
        if (n2 < 0 || jInternalFrameArray.length == 0) {
            this.setMenuItemEnabled(menu, MINIMIZE_ALL, false);
        } else {
            this.setMenuItemEnabled(menu, MINIMIZE_ALL, true);
        }
        JInternalFrame jInternalFrame = (JInternalFrame)((Object)this.getActiveWindow());
        if (jInternalFrame != null && jInternalFrame.isIconifiable() && !jInternalFrame.isIcon()) {
            this.setMenuItemEnabled(menu, MINIMIZE, true);
        } else {
            this.setMenuItemEnabled(menu, MINIMIZE, false);
        }
        boolean bl = false;
        for (n = 0; n < jInternalFrameArray.length; ++n) {
            if (jInternalFrameArray[n].isIcon()) continue;
            bl = true;
            break;
        }
        this.setMenuItemEnabled(menu, CASCADE, bl);
        this.setMenuItemEnabled(menu, TILEFRAMES, bl);
        this.setMenuItemEnabled(menu, TILE_HORIZONTAL, bl);
        this.setMenuItemEnabled(menu, TILE_VERTICAL, bl);
        n = 0;
        if (null != this.perMangerInstance) {
            n = ((Boolean)ReflectionUtilities.callTheMethod(this.perMangerInstance, "isPerspectiveFrame", new Class[]{Object.class}, new Object[]{this.getActiveWindow()})).booleanValue() ? 1 : 0;
        }
        if (null == this.perMangerInstance || n == 0) {
            this.setMenuItemEnabled(menu, RESET_PERSPECTIVE, false);
            this.setMenuItemEnabled(menu, DEFAULT_STYLE, false);
        } else {
            this.setMenuItemEnabled(menu, DEFAULT_STYLE, true);
            this.setStatus(menu, DEFAULT_STYLE);
            if (this.status) {
                this.setMenuItemEnabled(menu, RESET_PERSPECTIVE, false);
            } else {
                this.setMenuItemEnabled(menu, RESET_PERSPECTIVE, true);
            }
        }
    }

    private void setStatus(Menu menu, String string) {
        Component component = menu.getMenuItem(string);
        if (component != null && component instanceof AbstractButton) {
            this.status = ((AbstractButton)component).isSelected();
        }
    }

    final void enableRelativeMenuItem(boolean bl) {
        this.refreshMenuStatus();
    }

    private void setMenuItemEnabled(Menu menu, String string, boolean bl) {
        Component component = menu.getMenuItem(string);
        if (component != null && (component instanceof MenuItem || component instanceof CheckBoxMenuItem)) {
            component.setEnabled(bl);
        }
    }

    public void setEnableRelativeMenuItem(boolean bl, boolean bl2) {
        this.enableRelativeMenuItem(bl);
    }

    public void enableFullScreenToolBarButton(boolean bl, JInternalFrame jInternalFrame) {
        boolean bl2 = bl;
        if (jInternalFrame != null) {
            bl2 = jInternalFrame instanceof InternalFrame ? bl && jInternalFrame.isMaximizable() && ((InternalFrame)jInternalFrame).isFullScreenable() : bl && jInternalFrame.isMaximizable();
        }
        ArrayList arrayList = CommandManager.getInstance().getAbstractButton(FULL_SCREEN_COMMAND_ID);
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            AbstractButton abstractButton = (AbstractButton)arrayList.get(i);
            if (abstractButton == null) continue;
            abstractButton.setEnabled(bl2);
        }
    }

    public void selectMenuItem(WindowManagerCheckBoxMenuItem windowManagerCheckBoxMenuItem) {
        block3: {
            block5: {
                Menu menu;
                block4: {
                    MenuManager menuManager = this.parentFrame.getMenuManager();
                    menu = menuManager.getMenu(MAIN_MENU_DESC, "WindowMenu");
                    if (null == menu) break block3;
                    if (this.menuItemList.size() < 9) break block4;
                    if (this.menuItemList.contains(windowManagerCheckBoxMenuItem)) break block5;
                    WindowManagerCheckBoxMenuItem windowManagerCheckBoxMenuItem2 = (WindowManagerCheckBoxMenuItem)this.menuItemList.lastElement();
                    menuManager.removeMenuItem(MAIN_MENU_DESC, "WindowMenu", windowManagerCheckBoxMenuItem2);
                    this.menuItemList.removeElement(windowManagerCheckBoxMenuItem2);
                    ((JMenu)menu).insert(windowManagerCheckBoxMenuItem, menu.getItemCount() - 1);
                    this.menuItemList.addElement(windowManagerCheckBoxMenuItem);
                    break block5;
                }
                if (!this.menuItemList.contains(windowManagerCheckBoxMenuItem)) {
                    ((JMenu)menu).insert(windowManagerCheckBoxMenuItem, menu.getItemCount() - 1);
                    this.menuItemList.addElement(windowManagerCheckBoxMenuItem);
                } else {
                    for (Object object : this.id_MenuItem_Map.keySet()) {
                        if (this.hideWindowId.contains(object) || this.menuItemList.contains(object = this.id_MenuItem_Map.get(object))) continue;
                        JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)object;
                        ((JMenu)menu).insert(jCheckBoxMenuItem, menu.getItemCount() - 1);
                        this.menuItemList.addElement(jCheckBoxMenuItem);
                        break;
                    }
                }
            }
            this.updateMenuItemTitle();
            windowManagerCheckBoxMenuItem.setSelected(true);
        }
    }

    private void updateMenuItemTitle() {
        WindowManagerCheckBoxMenuItem windowManagerCheckBoxMenuItem = null;
        int n = this.menuItemList.size();
        for (int i = 0; i < n; ++i) {
            windowManagerCheckBoxMenuItem = (WindowManagerCheckBoxMenuItem)this.menuItemList.get(i);
            windowManagerCheckBoxMenuItem.updateMenuItemTitle(String.valueOf(i + 1));
        }
        MenuManager menuManager = this.parentFrame.getMenuManager();
        Menu menu = menuManager.getMenu(MAIN_MENU_DESC, "WindowMenu");
        if (null != menu) {
            menu.revalidate();
            menu.repaint();
        }
    }

    private void clearWindowMenuItem() {
        MenuManager menuManager = this.parentFrame.getMenuManager();
        if (menuManager == null || this.menuItemGroup.size() <= 0) {
            return;
        }
        if (this.otherItem != null) {
            menuManager.removeMenuItem(MAIN_MENU_DESC, "WindowMenu", this.otherItem);
        }
        if (this.menuSeparator != null) {
            menuManager.removeSeparator(MAIN_MENU_DESC, "WindowMenu", this.menuSeparator);
        }
        WindowManagerCheckBoxMenuItem windowManagerCheckBoxMenuItem = null;
        int n = this.menuItemGroup.size();
        for (int i = 0; i < n; ++i) {
            windowManagerCheckBoxMenuItem = (WindowManagerCheckBoxMenuItem)this.menuItemGroup.get(i);
            menuManager.removeMenuItem(MAIN_MENU_DESC, "WindowMenu", windowManagerCheckBoxMenuItem);
            windowManagerCheckBoxMenuItem.setInternalFrame(null);
            windowManagerCheckBoxMenuItem = null;
        }
        this.menuItemGroup.clear();
        this.menuItemList.clear();
        this.id_MenuItem_Map.clear();
        this.internalFrameStore.clear();
    }

    public void clearAllSelected() {
        WindowManagerCheckBoxMenuItem windowManagerCheckBoxMenuItem = null;
        int n = this.menuItemList.size();
        for (int i = 0; i < n; ++i) {
            windowManagerCheckBoxMenuItem = (WindowManagerCheckBoxMenuItem)this.menuItemList.get(i);
            windowManagerCheckBoxMenuItem.setSelected(false);
        }
    }

    public void setMDIEnabled(boolean bl) {
        this.parentFrame.setMDI(bl);
    }

    public boolean isMDI() {
        return this.parentFrame.isMDI();
    }

    public int registerWindow(ExtendedWindow extendedWindow) {
        return this.registerWindowEX(extendedWindow);
    }

    public JFrame getJFrame() {
        return this.parentFrame;
    }

    public void addLeftPanel(JPanel jPanel, String string) {
        this.parentFrame.addLeftPanel(jPanel, string);
    }

    public void addLeftPanel(JPanel jPanel, String string, double d) {
        this.parentFrame.addLeftPanel(jPanel, string, d);
    }

    public void removeLeftPanel(JPanel jPanel) {
        this.parentFrame.removeLeftPanel(jPanel);
    }

    public void registerWindow(ExtendWindow extendWindow, InternalLayer internalLayer) {
        this.registerWindowEX(extendWindow, internalLayer);
    }

    public void registerWindow(ExtendedWindow extendedWindow, InternalLayer internalLayer) {
        this.registerWindowEX(extendedWindow, internalLayer);
    }

    public void registerWindow(ExtendWindow extendWindow) {
        this.registerWindowEX(extendWindow);
    }

    public int registerWindowEX(ExtendedWindow extendedWindow) {
        return this.registerWindowEX(extendedWindow, InternalLayer.COMMON_LAYER);
    }

    private int registerWindowEX(ExtendedWindow extendedWindow, InternalLayer internalLayer) {
        if (!this.parentFrame.isMDI() && extendedWindow.isClosable()) {
            ExternalContainer externalContainer = this.parentFrame.createExternalContainer(extendedWindow);
            externalContainer.show();
            return 0;
        }
        InternalFrame internalFrame = new InternalFrame(extendedWindow);
        return this.registerWindow(internalFrame, internalLayer.getValue(), false);
    }

    public Hashtable getInternalFrameStore() {
        return this.internalFrameStore;
    }

    public void setTitle(String string) {
        this.parentFrame.setTitle(string);
    }

    public String getTitle() {
        return this.parentFrame.getTitle();
    }

    public void setMDITitle(String string) {
        this.parentFrame.setMDITitle(string);
    }

    public String getMDITitle() {
        return this.parentFrame.getMDITitle();
    }

    public void updateSettingPanel() {
        InternalLocalMsg internalLocalMsg = new InternalLocalMsg();
        internalLocalMsg.ID = 1;
        internalLocalMsg.sendModule = "mainwindowmanager";
        internalLocalMsg.data = new Object[]{this.isMDI(), this.getMDITitle()};
        super.sendEvent("mainframesetting", internalLocalMsg);
    }

    public boolean readSetting() {
        block5: {
            SubsystemManager subsystemManager = SubsystemManager.getInstance();
            if (null != subsystemManager && subsystemManager.getClientLoadMode() == SubsystemManager.LoadMode.single) {
                return false;
            }
            try {
                CommStyleInfo commStyleInfo = CommStyleManager.getInstance().getCommonStyleFile(SETTING_FILE);
                if (commStyleInfo != null && SubsystemManager.getInstance().getClientLoadMode() != SubsystemManager.LoadMode.single) {
                    DescContainer descContainer = commStyleInfo.getAreaDescContainer(0).getDescContainer(DESC_MAINFRAME);
                    this.parentFrame.setMDI(Boolean.valueOf(descContainer.getParasItemValue(PARA_MDI)));
                    String string = descContainer.getParasItemValue(PARA_TITLE);
                    if (string != null && string.length() > 0) {
                        this.parentFrame.setMDITitle(string);
                    }
                    break block5;
                }
                return false;
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
                return false;
            }
        }
        return true;
    }

    public void writeBackSetting() throws IOException {
        try {
            CommStyleInfo commStyleInfo = CommStyleManager.getInstance().getCommonStyleFile(SETTING_FILE);
            if (null != commStyleInfo) {
                DescContainer descContainer = commStyleInfo.getAreaDescContainer(0).getDescContainer(DESC_MAINFRAME);
                descContainer.setParasItem(PARA_MDI, String.valueOf(this.parentFrame.isMDI()));
                descContainer.setParasItem(PARA_TITLE, this.parentFrame.getMDITitle());
            } else {
                commStyleInfo = new CommStyleInfo();
                String string = CommStyleManager.getInstance().getPersonalFullFileName(SETTING_FILE);
                commStyleInfo.setFileName(string);
                AreaDescContainer areaDescContainer = new AreaDescContainer();
                DescContainer descContainer = new DescContainer(DESC_MAINFRAME);
                PARA pARA = new PARA();
                pARA.setName(PARA_MDI);
                pARA.setValue(String.valueOf(this.parentFrame.isMDI()));
                PARA pARA2 = new PARA();
                pARA2.setName(PARA_TITLE);
                pARA2.setValue(this.parentFrame.getMDITitle());
                descContainer.addParasItem(pARA);
                descContainer.addParasItem(pARA2);
                areaDescContainer.addDescContainer(descContainer);
                commStyleInfo.addAreaDescContainer(areaDescContainer);
            }
            CommStyleManager.getInstance().writeToServer(commStyleInfo);
        }
        catch (IOException iOException) {
            logger.trace(iOException.getMessage(), iOException);
            throw iOException;
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
    }

    public void horiTileWindows() {
        this.desktopPane.tileInternalFrames(0);
    }

    public void closeWindow() {
        this.parentFrame.closeWindow();
    }

    public void vertTileWindows() {
        this.desktopPane.tileInternalFrames(1);
    }

    public void selectNextFrame() {
        this.parentFrame.getDesktop().getActionMap().get("selectNextFrame").actionPerformed(null);
    }

    public void selectPreviousFrame() {
        this.parentFrame.getDesktop().getActionMap().get("selectPreviousFrame").actionPerformed(null);
    }

    protected void removeMenuItem(WindowManagerCheckBoxMenuItem windowManagerCheckBoxMenuItem) {
        if (null == windowManagerCheckBoxMenuItem) {
            return;
        }
        MenuManager menuManager = this.parentFrame.getMenuManager();
        Menu menu = menuManager.getMenu(MAIN_MENU_DESC, "WindowMenu");
        menuManager.removeMenuItem(MAIN_MENU_DESC, "WindowMenu", windowManagerCheckBoxMenuItem);
        this.menuItemList.removeElement(windowManagerCheckBoxMenuItem);
        this.menuItemGroup.removeElement(windowManagerCheckBoxMenuItem);
        WindowManagerCheckBoxMenuItem windowManagerCheckBoxMenuItem2 = null;
        int n = this.getFirstItemFromMore();
        if (n != -1) {
            windowManagerCheckBoxMenuItem2 = (WindowManagerCheckBoxMenuItem)this.menuItemGroup.get(n);
        }
        if (windowManagerCheckBoxMenuItem2 == null) {
            return;
        }
        if (this.menuItemGroup.size() > 9 && this.menuItemList.size() == 8 && null != menu) {
            ((JMenu)menu).insert(windowManagerCheckBoxMenuItem2, menu.getItemCount() - 1);
            this.menuItemList.addElement(windowManagerCheckBoxMenuItem2);
        } else if (this.menuItemGroup.size() == 9 && this.menuItemList.size() == 8 && null != menu) {
            menuManager.removeMenuItem(MAIN_MENU_DESC, "WindowMenu", this.otherItem);
            ((JMenu)menu).insert(windowManagerCheckBoxMenuItem2, menu.getItemCount());
            this.menuItemList.addElement(windowManagerCheckBoxMenuItem2);
        }
        this.updateMenuItemTitle();
    }

    private int getFirstItemFromMore() {
        int n = -1;
        int n2 = this.menuItemGroup.size();
        for (int i = 0; i < n2; ++i) {
            if (this.menuItemList.contains(this.menuItemGroup.elementAt(i))) continue;
            n = i;
        }
        return n;
    }

    public void printActivateWindow() {
        InternalFrame internalFrame = (InternalFrame)this.getActiveWindow();
        if (internalFrame == null) {
            logger.trace("Active window is null");
            return;
        }
        internalFrame.print();
    }

    public void previewActivateWindow() {
        InternalFrame internalFrame = (InternalFrame)this.getActiveWindow();
        if (internalFrame == null) {
            logger.trace("Active window is null");
            return;
        }
        internalFrame.printPreview();
    }

    public void pageSetupActivateWindow() {
        InternalFrame internalFrame = (InternalFrame)this.getActiveWindow();
        if (internalFrame == null) {
            logger.trace("Active window is null");
            return;
        }
        internalFrame.setupPage();
    }

    public boolean closeAllWindowsWithCheck() {
        boolean bl = true;
        JInternalFrame[] jInternalFrameArray = this.desktopPane.getAllFrames();
        if (null != jInternalFrameArray && jInternalFrameArray.length > 0) {
            for (int i = 0; i < jInternalFrameArray.length; ++i) {
                if (!((InternalFrame)jInternalFrameArray[i]).isBusy()) continue;
                logger.debug(jInternalFrameArray[i].getTitle() + " internalFrame is busy.");
                final String string = ((InternalFrame)jInternalFrameArray[i]).getBusyMessage();
                if (SwingUtilities.isEventDispatchThread()) {
                    OptionPane.showLineWrapOptionDialog(FrameworkUtilities.getMainFrame(), string, 1);
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            OptionPane.showLineWrapOptionDialog(FrameworkUtilities.getMainFrame(), string, 1);
                        }
                    });
                }
                bl = false;
                break;
            }
        }
        HashSet hashSet = new HashSet(this.windowMenuFrameMap.keySet());
        for (JFrame jFrame : hashSet) {
            jFrame.dispose();
        }
        return bl;
    }

    public int getClosableWindowCount() {
        int n = 0;
        JInternalFrame[] jInternalFrameArray = this.desktopPane.getAllFrames();
        if (null != jInternalFrameArray && jInternalFrameArray.length > 0) {
            for (int i = 0; i < jInternalFrameArray.length; ++i) {
                if (!jInternalFrameArray[i].isClosable() || jInternalFrameArray[i] instanceof InternalDialog || jInternalFrameArray[i] instanceof InternalFrame && ((InternalFrame)jInternalFrameArray[i]).isBusy()) continue;
                ++n;
            }
        }
        return n;
    }

    public void closeOtherWindows(InternalFrame internalFrame) {
        JInternalFrame[] jInternalFrameArray = this.desktopPane.getAllFrames();
        if (null != jInternalFrameArray && jInternalFrameArray.length > 0) {
            for (int i = 0; i < jInternalFrameArray.length; ++i) {
                if (!jInternalFrameArray[i].isClosable() || jInternalFrameArray[i].equals(internalFrame) || !(jInternalFrameArray[i] instanceof InternalFrame) || ((InternalFrame)jInternalFrameArray[i]).isBusy()) continue;
                InternalFrame internalFrame2 = (InternalFrame)jInternalFrameArray[i];
                try {
                    boolean bl = this.closeWindow(internalFrame2.getWindowId());
                    if (bl) continue;
                    logger.error("Can't close window:" + internalFrame2.getTitle());
                    continue;
                }
                catch (Exception exception) {
                    logger.trace(exception.getMessage(), exception);
                }
            }
        }
    }

    public INavigationHistory getNavigationHistory() {
        return this.navigationHistory;
    }

    public String getActiveFrameTitle(int n) {
        InternalFrame internalFrame = (InternalFrame)this.internalFrameStore.get(n);
        if (null != internalFrame) {
            String string = internalFrame.getTitle();
            int n2 = string.length();
            if (n2 > 50) {
                return string.substring(0, 50);
            }
            return internalFrame.getTitle();
        }
        logger.error("The Frame denoted by WindowId " + n + " does not exist");
        return null;
    }

    public void setFullScreenPasswordProtected(boolean bl) {
        this.fullScreenPasswordProtected = bl;
    }

    public boolean isFullScreenPasswordProtected() {
        return this.fullScreenPasswordProtected;
    }

    public void setFullScreenLock(boolean bl) {
        this.fullScreenLock = bl;
    }

    public boolean isFullScreenLockEnabled() {
        return this.fullScreenLock;
    }

    public void resetPerspective() {
        Object object = ReflectionUtilities.callStaticMethod("com.swimap.iview.framework.dockingmanagement.PerspectiveManager", "getInstance", null, null);
        if (null != object) {
            ReflectionUtilities.callTheMethod(object, "resetPerspective", null, null);
        }
    }

    public void setDefaultStyle() {
        Object object = ReflectionUtilities.callStaticMethod("com.swimap.iview.framework.dockingmanagement.PerspectiveManager", "getInstance", null, null);
        boolean bl = false;
        if (null != object) {
            bl = (Boolean)ReflectionUtilities.callTheMethod(object, "isPerspectiveFrame", new Class[]{Object.class}, new Object[]{this.getActiveWindow()});
        }
        if (bl) {
            MenuManager menuManager = FrameworkUtilities.getMenuManager();
            Menu menu = menuManager.getBaseMenuSet().getMenu("WindowMenu");
            this.setStatus(menu, DEFAULT_STYLE);
            ReflectionUtilities.callTheMethod(object, "setGUIStyle", new Class[]{Boolean.TYPE}, new Object[]{!this.status});
            this.refreshMenuStatus();
        }
    }

    @Override
    public boolean preLogout() {
        JInternalFrame[] jInternalFrameArray = this.desktopPane.getAllFrames();
        if (null != jInternalFrameArray && jInternalFrameArray.length > 0) {
            for (int i = 0; i < jInternalFrameArray.length; ++i) {
                if (!(jInternalFrameArray[i] instanceof InternalFrame) || ((InternalFrame)jInternalFrameArray[i]).preLogout()) continue;
                return false;
            }
        }
        return true;
    }

    public void updateActiveApPFrame(String string, InternalFrame internalFrame) {
        this.activeAPPframes.put(string, internalFrame);
    }

    public InternalFrame getActiveAppFrame(String string) {
        return this.activeAPPframes.get(string);
    }

    public void refreshAppWindowMenus() {
        Integer n2 = null;
        MenuManager menuManager = this.parentFrame.getMenuManager();
        if (null == menuManager) {
            return;
        }
        Menu menu = menuManager.getMenu(MAIN_MENU_DESC, "WindowMenu");
        if (null == menu) {
            return;
        }
        menuManager.addSeparator(MAIN_MENU_DESC, "WindowMenu", this.menuSeparator);
        TreeSet treeSet = new TreeSet(this.id_MenuItem_Map.keySet());
        for (Integer n2 : treeSet) {
            Object v = this.id_MenuItem_Map.get(n2);
            if (!(v instanceof WindowManagerCheckBoxMenuItem)) continue;
            WindowManagerCheckBoxMenuItem windowManagerCheckBoxMenuItem = (WindowManagerCheckBoxMenuItem)v;
            if (null == menu) continue;
            int n3 = this.menuItemList.size();
            if (n3 < 9) {
                menuManager.addMenuItem(MAIN_MENU_DESC, "WindowMenu", windowManagerCheckBoxMenuItem);
                continue;
            }
            if (n3 != 9) continue;
            menuManager.addMenuItem(MAIN_MENU_DESC, "WindowMenu", this.otherItem);
        }
    }

    public class InternalFramePropertyChangeListener
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            InternalFrame internalFrame = (InternalFrame)propertyChangeEvent.getSource();
            if ("maximum".equals(string) || "icon".equals(string)) {
                WindowManager.this.notifyDesktopListener(internalFrame.getWindowId());
            } else if ("isBusy".equals(string)) {
                if (internalFrame.isMaximum()) {
                    WindowManager.this.parentFrame.getLayOutBtnBoxEx().setCloseBtnEnable(!internalFrame.isBusy());
                }
                WindowManager.this.refreshMenuStatus();
            }
        }
    }

    private final class WindowManagerInternalFrameListener
    extends InternalFrameAdapter {
        private WindowManagerInternalFrameListener() {
        }

        @Override
        public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
            JInternalFrame jInternalFrame = internalFrameEvent.getInternalFrame();
            WindowManager.this.enableFullScreenToolBarButton(false == jInternalFrame.isIcon(), jInternalFrame);
            WindowManager.this.refreshMenuStatus();
        }

        @Override
        public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
            if (WindowManager.this.getActiveWindow() == null) {
                WindowManager.this.enableFullScreenToolBarButton(false, null);
            } else {
                WindowManager.this.enableFullScreenToolBarButton(true, WindowManager.this.desktopPane.getSelectedFrame());
            }
            WindowManager.this.refreshMenuStatus();
        }

        @Override
        public void internalFrameDeiconified(InternalFrameEvent internalFrameEvent) {
            WindowManager.this.refreshMenuStatus();
            WindowManager.this.enableFullScreenToolBarButton(true, internalFrameEvent.getInternalFrame());
        }

        @Override
        public void internalFrameIconified(InternalFrameEvent internalFrameEvent) {
            if (WindowManager.this.getActiveWindow() == null || !((JInternalFrame)((Object)WindowManager.this.getActiveWindow())).isIconifiable()) {
                WindowManager.this.refreshMenuStatus();
                WindowManager.this.enableFullScreenToolBarButton(false, null);
            }
        }

        @Override
        public void internalFrameOpened(InternalFrameEvent internalFrameEvent) {
            WindowManager.this.refreshMenuStatus();
            WindowManager.this.enableFullScreenToolBarButton(true, internalFrameEvent.getInternalFrame());
        }
    }
}

