/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.windowmanagement;

import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.framework.windowmanagement.WindowManagerCheckBoxMenuItem;
import com.swimap.iview.util.OptionPane;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.Collator;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class WindowListDlg
extends JDialog {
    private static IviewLogger logger = IviewLogger.getLogger(WindowListDlg.class, "IVIEW");
    private static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/framework/windowmanagement/Res");
    private JPanel dialogPanel = new JPanel();
    private JPanel buttonPanel = new JPanel();
    private JPanel titlePanel = new JPanel();
    private JButton okBtn = new JButton();
    private JButton cancelBtn = new JButton();
    private JScrollPane listScrollPane = new JScrollPane();
    private DefaultListModel model = new DefaultListModel();
    private JList winList = new JList(this.model);
    private BorderLayout dialogPanelLayout = new BorderLayout();
    private BorderLayout contentPaneLayout = new BorderLayout();
    private static final int BUTTON_PREFERRED_HEIGHT = 21;
    private boolean ok = false;
    private int selectedWindowID = -1;

    WindowListDlg(Frame frame, String string, boolean bl) {
        super(frame, string, bl);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
    }

    private void jbInit() throws Exception {
        this.dialogPanel.setLayout(this.dialogPanelLayout);
        this.getContentPane().setLayout(this.contentPaneLayout);
        this.okBtn.setText(res.getString("OK"));
        this.okBtn.setName("WindowListDlg_okBtn");
        this.cancelBtn.setText(res.getString("CANCEL"));
        this.cancelBtn.setName("WindowListDlg_cancelBtn");
        JLabel jLabel = new JLabel(res.getString("WindowListDlg_select_label"));
        this.titlePanel.setLayout(new FlowLayout(0));
        this.titlePanel.add(jLabel);
        this.dialogPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        this.getContentPane().add((Component)this.titlePanel, "North");
        this.getContentPane().add((Component)this.dialogPanel, "Center");
        this.dialogPanel.add((Component)this.listScrollPane, "Center");
        this.listScrollPane.getViewport().add((Component)this.winList, null);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.buttonPanel.setLayout(new FlowLayout(2));
        this.buttonPanel.add((Component)this.okBtn, null);
        this.buttonPanel.add((Component)this.cancelBtn, null);
        this.winList.setName("WindowListDialog_winList");
        this.winList.setSelectionMode(0);
        this.winList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && mouseEvent.getButton() == 1) {
                    WindowListDlg.this.okBtn_actionPerformed();
                }
            }
        });
        ScreenToolKit.setPreferredSizeofButtons(new JButton[]{this.okBtn, this.cancelBtn}, 21);
        ScreenToolKit.setDefaultButtons(this.okBtn, this.cancelBtn);
        this.okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WindowListDlg.this.okBtn_actionPerformed();
            }
        });
        this.cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WindowListDlg.this.cancelBtn_actionPerformed();
            }
        });
        this.setDefaultCloseOperation(2);
    }

    void addListData(Vector vector) {
        Collections.sort(vector, new WindowManagerCheckBoxMenuItemComparator());
        Iterator iterator = vector.iterator();
        WindowManagerCheckBoxMenuItem windowManagerCheckBoxMenuItem = null;
        while (iterator.hasNext()) {
            windowManagerCheckBoxMenuItem = (WindowManagerCheckBoxMenuItem)iterator.next();
            this.model.addElement(windowManagerCheckBoxMenuItem);
        }
    }

    final void cancelBtn_actionPerformed() {
        this.ok = false;
        this.dispose();
    }

    final void okBtn_actionPerformed() {
        int n = this.winList.getSelectedIndex();
        if (n < 0) {
            OptionPane.showMessageDialog(this, res.getString("no_select_list"));
            return;
        }
        WindowManagerCheckBoxMenuItem windowManagerCheckBoxMenuItem = (WindowManagerCheckBoxMenuItem)this.model.getElementAt(n);
        this.selectedWindowID = windowManagerCheckBoxMenuItem.getInternalFrameID();
        if (0 > this.selectedWindowID) {
            this.dispose();
            windowManagerCheckBoxMenuItem.doClick();
        }
        this.ok = true;
        this.dispose();
    }

    boolean showDialog(WindowManagerCheckBoxMenuItem windowManagerCheckBoxMenuItem) {
        if (null != windowManagerCheckBoxMenuItem) {
            this.winList.setSelectedValue(windowManagerCheckBoxMenuItem, true);
        }
        this.show();
        return this.ok;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.model.removeAllElements();
    }

    public int getSelectedID() {
        return this.selectedWindowID;
    }

    private class WindowManagerCheckBoxMenuItemComparator
    implements Comparator {
        private WindowManagerCheckBoxMenuItemComparator() {
        }

        public int compare(Object object, Object object2) {
            WindowManagerCheckBoxMenuItem windowManagerCheckBoxMenuItem = (WindowManagerCheckBoxMenuItem)object;
            WindowManagerCheckBoxMenuItem windowManagerCheckBoxMenuItem2 = (WindowManagerCheckBoxMenuItem)object2;
            Collator collator = Collator.getInstance();
            int n = collator.compare(windowManagerCheckBoxMenuItem.toString(), windowManagerCheckBoxMenuItem2.toString());
            return n;
        }
    }
}

