/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.windowmanagement;

import com.swimap.iview.framework.applicationmanagement.ApplicationLauncher;
import com.swimap.iview.framework.util.FrameworkCommandProcessor;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.framework.windowmanagement.IWindowTile;
import com.swimap.iview.framework.windowmanagement.InternalDialog;
import com.swimap.iview.framework.windowmanagement.InternalFrame;
import com.swimap.iview.framework.windowmanagement.WindowTileImpl;
import com.swimap.iview.util.ReflectionUtilities;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyVetoException;
import java.util.Vector;
import javax.swing.DefaultDesktopManager;
import javax.swing.ImageIcon;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class MainDesktopPane
extends JDesktopPane {
    private static IviewLogger logger = IviewLogger.getLogger(MainDesktopPane.class, "IVIEW");
    private static final double ORIGINAL_WIDTH_PORTION = 0.75;
    private static final double ORIGINAL_HEIGHT_PORTION = 0.75;
    private static final int GAP_TO_BOUNDS = 5;
    private int currentxPos = 5;
    private int currentyPos = 5;
    private static final int X_INCREMENT = 25;
    private static final int Y_INCREMENT = 25;
    private Image backGroundimage = null;
    public static final int TILEHORIZONTAL = 0;
    public static final int TILEVERTICAL = 1;
    private DesktopPaneInternalFrameListener internalFrameListener = new DesktopPaneInternalFrameListener();
    private transient IWindowTile windowTileImpl = null;
    private static final int DEFAULT_MIN_HEIGHT = 300;
    private boolean demaxAll = false;
    private boolean redundantSelectFrameFlag = false;
    private static final int ICON_HEIGHT = 40;

    public boolean isRedundantSelectFrameFlag() {
        return this.redundantSelectFrameFlag;
    }

    public MainDesktopPane() {
        SymComponent symComponent = new SymComponent();
        this.addComponentListener(symComponent);
        this.setDragMode(1);
        this.setDesktopManager(new MainDesktopManager());
        this.windowTileImpl = new WindowTileImpl(this);
    }

    @Override
    public Component add(Component component) {
        if (component instanceof JInternalFrame) {
            ((JInternalFrame)component).addInternalFrameListener(this.internalFrameListener);
        }
        return super.add(component);
    }

    @Override
    public void remove(Component component) {
        if (component instanceof JInternalFrame) {
            ((JInternalFrame)component).removeInternalFrameListener(this.internalFrameListener);
        }
        super.remove(component);
    }

    public void setBackGroundImage(ImageIcon imageIcon) {
        if (imageIcon != null) {
            this.backGroundimage = imageIcon.getImage();
        }
    }

    public void setBackGroundImage(Image image) {
        this.backGroundimage = image;
    }

    public Image getBackGroundImage() {
        return this.backGroundimage;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.backGroundimage != null) {
            graphics.drawImage(this.backGroundimage, 0, 0, this.getWidth(), this.getHeight(), null);
        }
    }

    public void tileVerticalAllFrames() {
        int n;
        int n2;
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        JInternalFrame[] jInternalFrameArray = this.getAllFrames();
        InternalFrame internalFrame = null;
        Vector<InternalFrame> vector = new Vector<InternalFrame>();
        Vector<InternalFrame> vector2 = new Vector<InternalFrame>();
        for (n2 = 0; n2 < jInternalFrameArray.length; ++n2) {
            try {
                if (jInternalFrameArray[n2] instanceof InternalFrame && ((InternalFrame)jInternalFrameArray[n2]).isManaged()) {
                    jInternalFrameArray[n2].setMaximum(false);
                }
            }
            catch (PropertyVetoException propertyVetoException) {
                logger.trace(propertyVetoException.getMessage(), propertyVetoException);
            }
            internalFrame = (InternalFrame)jInternalFrameArray[n2];
            if (internalFrame.isManaged() && !internalFrame.isIcon()) {
                vector.add(internalFrame);
                continue;
            }
            vector2.add(internalFrame);
        }
        n2 = vector.size();
        if (0 == n2) {
            return;
        }
        int n5 = n3 / n2;
        for (n = 0; n < n2; ++n) {
            internalFrame = (InternalFrame)vector.elementAt(n);
            if (internalFrame.isMaximum()) {
                internalFrame.setMaximum(false);
            }
            if (internalFrame.isIcon()) {
                internalFrame.setIcon(false);
            }
            internalFrame.setBounds(n * n5, 0, n5, n4);
        }
        for (n = 0; n < vector2.size(); ++n) {
            if (vector2.elementAt(n) instanceof InternalDialog) {
                if (!((InternalDialog)vector2.elementAt(n)).getParentInternalFrame().isSelected()) continue;
                ((JInternalFrame)vector2.elementAt(n)).toFront();
                continue;
            }
            ((InternalFrame)vector2.elementAt(n)).moveToFront();
        }
    }

    public void tileInternalFrames(int n) {
        int n2;
        int n3;
        int n4 = this.getWidth();
        int n5 = this.getHeight();
        boolean bl = false;
        JInternalFrame[] jInternalFrameArray = this.getAllFrames();
        InternalFrame internalFrame = null;
        Vector<JInternalFrame> vector = new Vector<JInternalFrame>();
        Vector<JInternalFrame> vector2 = new Vector<JInternalFrame>();
        for (n3 = 0; n3 < jInternalFrameArray.length; ++n3) {
            try {
                if (jInternalFrameArray[n3] instanceof InternalFrame && ((InternalFrame)jInternalFrameArray[n3]).isManaged()) {
                    jInternalFrameArray[n3].setMaximum(false);
                }
            }
            catch (PropertyVetoException propertyVetoException) {
                logger.trace(propertyVetoException.getMessage(), propertyVetoException);
            }
            if (jInternalFrameArray[n3].isIcon()) {
                bl = true;
                continue;
            }
            if (jInternalFrameArray[n3] instanceof InternalFrame && ((InternalFrame)jInternalFrameArray[n3]).isManaged() && jInternalFrameArray[n3].isResizable()) {
                vector.add(jInternalFrameArray[n3]);
                continue;
            }
            vector2.add(jInternalFrameArray[n3]);
        }
        n3 = vector.size();
        if (0 == n3) {
            return;
        }
        if (bl && n5 > 40) {
            n5 -= 40;
        }
        int n6 = n5 / n3;
        int n7 = n4 / n3;
        for (n2 = 0; n2 < n3; ++n2) {
            internalFrame = (InternalFrame)vector.elementAt(n2);
            if (internalFrame.isMaximum()) {
                internalFrame.setMaximum(false);
            }
            if (internalFrame.isIcon()) {
                internalFrame.setIcon(false);
            }
            if (n == 0) {
                internalFrame.setBounds(0, n2 * n6, n4, n6);
                continue;
            }
            if (n != 1) continue;
            internalFrame.setBounds(n2 * n7, 0, n7, n5);
        }
        for (n2 = 0; n2 < vector2.size(); ++n2) {
            if (vector2.elementAt(n2) instanceof InternalDialog) {
                if (!((InternalDialog)vector2.elementAt(n2)).getParentInternalFrame().isSelected()) continue;
                ((JInternalFrame)vector2.elementAt(n2)).toFront();
                continue;
            }
            ((InternalFrame)vector2.elementAt(n2)).moveToFront();
        }
    }

    public void tileFrames() {
        if (this.windowTileImpl != null) {
            this.windowTileImpl.tileFrames();
        } else {
            logger.error("windowTileImpl is null.");
        }
    }

    private void componentResizedProcess() {
        InternalFrame internalFrame = (InternalFrame)this.getSelectedFrame();
        if (null != internalFrame) {
            internalFrame.modifySize();
        }
    }

    public void cascadeInternalFrames() {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = this.getWidth();
        int n6 = this.getHeight();
        boolean bl = false;
        n3 = 5;
        n4 = 5;
        JInternalFrame[] jInternalFrameArray = this.getAllFrames();
        InternalFrame internalFrame = null;
        Vector<JInternalFrame> vector = new Vector<JInternalFrame>();
        Vector<JInternalFrame> vector2 = new Vector<JInternalFrame>();
        for (n2 = 0; n2 < jInternalFrameArray.length; ++n2) {
            try {
                if (jInternalFrameArray[n2] instanceof InternalFrame && ((InternalFrame)jInternalFrameArray[n2]).isManaged()) {
                    jInternalFrameArray[n2].setMaximum(false);
                }
            }
            catch (PropertyVetoException propertyVetoException) {
                logger.trace(propertyVetoException.getMessage(), propertyVetoException);
            }
            if (jInternalFrameArray[n2].isIcon()) {
                bl = true;
                continue;
            }
            if (jInternalFrameArray[n2] instanceof InternalFrame && ((InternalFrame)jInternalFrameArray[n2]).isManaged() && jInternalFrameArray[n2].isResizable()) {
                vector.add(jInternalFrameArray[n2]);
                continue;
            }
            vector2.add(jInternalFrameArray[n2]);
        }
        if (bl && n6 > 40) {
            n6 -= 40;
        }
        n2 = 0;
        int n7 = 0;
        int n8 = 0;
        for (n = vector.size() - 1; n >= 0; --n) {
            internalFrame = (InternalFrame)vector.elementAt(n);
            if (internalFrame.isMaximum()) {
                internalFrame.setMaximum(false);
            }
            if (internalFrame.isIcon()) {
                internalFrame.setIcon(false);
            }
            n2 = (int)((double)n5 * 0.75);
            n7 = (int)((double)n6 * 0.75);
            internalFrame.setBounds(n3, n4, n2, n7);
            if ((n3 += 25) + n2 <= n5 - 5 && (n4 += 25) + n7 <= n6 - 5) continue;
            n3 = 5 + ++n8 * 5;
            n4 = 5;
        }
        for (n = 0; n < vector2.size(); ++n) {
            ((InternalFrame)vector2.elementAt(n)).moveToFront();
        }
    }

    public Dimension getDefaultSizeOfInternaFrame() {
        int n = (int)((double)this.getWidth() * 0.75);
        int n2 = (int)((double)this.getHeight() * 0.75);
        if (n2 < 300) {
            n2 = 300;
        }
        return new Dimension(n, n2);
    }

    public Point getPosOfNewInternalFrame(JInternalFrame jInternalFrame) {
        if (null != this.getSelectedFrame()) {
            this.currentxPos = this.getSelectedFrame().getLocation().x + 25;
            this.currentyPos = this.getSelectedFrame().getLocation().y + 25;
        } else {
            this.currentxPos = 5;
            this.currentyPos = 5;
        }
        if ((double)this.currentxPos + jInternalFrame.getSize().getWidth() > this.getSize().getWidth() - 5.0 || (double)this.currentyPos + jInternalFrame.getSize().getHeight() > this.getSize().getHeight() - 5.0) {
            this.currentxPos = 5;
            this.currentyPos = 5;
        }
        return new Point(this.currentxPos, this.currentyPos);
    }

    public JInternalFrame getNextMaximizableInternalFrame() {
        return this.getNextInternalFrame(false);
    }

    JInternalFrame getNextInternalFrame(boolean bl) {
        JInternalFrame[] jInternalFrameArray = null;
        jInternalFrameArray = this.getAllFrames();
        if (null == jInternalFrameArray || 0 == jInternalFrameArray.length) {
            return null;
        }
        if (bl) {
            return jInternalFrameArray[0];
        }
        for (int i = 0; i < jInternalFrameArray.length; ++i) {
            if (!(jInternalFrameArray[i] instanceof InternalFrame) || !jInternalFrameArray[i].isMaximizable() || !((InternalFrame)jInternalFrameArray[i]).isManaged()) continue;
            return jInternalFrameArray[i];
        }
        return null;
    }

    public void demaxmizeAll() {
        this.demaxAll = true;
        JInternalFrame[] jInternalFrameArray = this.getAllFrames();
        if (null != jInternalFrameArray) {
            for (int i = 0; i < jInternalFrameArray.length; ++i) {
                if (!jInternalFrameArray[i].isMaximum() || !((InternalFrame)jInternalFrameArray[i]).isManaged()) continue;
                try {
                    jInternalFrameArray[i].setMaximum(false);
                    continue;
                }
                catch (PropertyVetoException propertyVetoException) {
                    logger.trace(propertyVetoException.getMessage(), propertyVetoException);
                }
            }
        }
        this.demaxAll = false;
    }

    public boolean isDemaxAll() {
        return this.demaxAll;
    }

    public void minimizeAllWindows() {
        JInternalFrame[] jInternalFrameArray = this.getAllFrames();
        if (null != jInternalFrameArray) {
            for (int i = 0; i < jInternalFrameArray.length; ++i) {
                if (!((InternalFrame)jInternalFrameArray[i]).isIconifiable()) continue;
                ((InternalFrame)jInternalFrameArray[i]).setIcon(true);
            }
        }
        this.requestFocus();
    }

    @Override
    public JInternalFrame selectFrame(boolean bl) {
        JInternalFrame jInternalFrame = super.selectFrame(bl);
        if (!(jInternalFrame instanceof InternalDialog)) {
            return jInternalFrame;
        }
        JInternalFrame[] jInternalFrameArray = this.getAllFrames();
        int n = 0;
        n = bl ? 0 : jInternalFrameArray.length - 2;
        while (jInternalFrameArray[n] instanceof InternalDialog) {
            if (bl) {
                ++n;
                continue;
            }
            --n;
        }
        if (!jInternalFrameArray[n].isIcon() && !jInternalFrameArray[n].isSelected()) {
            try {
                jInternalFrameArray[n].setSelected(true);
                return jInternalFrameArray[n];
            }
            catch (PropertyVetoException propertyVetoException) {
                logger.trace(propertyVetoException);
            }
        }
        return jInternalFrameArray[n];
    }

    final void activeFrame() {
        if (null == this.getSelectedFrame()) {
            int n = 0;
            JInternalFrame jInternalFrame = null;
            for (n = 0; n < this.getComponentCount(); ++n) {
                if (!(this.getComponent(n) instanceof JInternalFrame)) continue;
                jInternalFrame = (JInternalFrame)this.getComponent(n);
                break;
            }
            if (jInternalFrame != null) {
                this.setSelectedFrame(jInternalFrame);
                jInternalFrame.moveToFront();
                try {
                    jInternalFrame.setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    logger.trace(propertyVetoException.getMessage(), propertyVetoException);
                }
            }
        }
    }

    public void updateIconifiedFrameLocation() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainDesktopPane mainDesktopPane = FrameworkUtilities.getWindowManager().getDesktopPane();
                for (JInternalFrame jInternalFrame : mainDesktopPane.getAllFrames()) {
                    if (!jInternalFrame.isIcon()) continue;
                    Rectangle rectangle = ((MainDesktopManager)mainDesktopPane.getDesktopManager()).getBoundsForIconOf(jInternalFrame);
                    JInternalFrame.JDesktopIcon jDesktopIcon = jInternalFrame.getDesktopIcon();
                    jDesktopIcon.setBounds(rectangle);
                }
            }
        });
    }

    private class DesktopPaneInternalFrameListener
    extends InternalFrameAdapter {
        private DesktopPaneInternalFrameListener() {
        }

        @Override
        public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
            MainDesktopPane.this.activeFrame();
        }
    }

    private class MainDesktopManager
    extends DefaultDesktopManager {
        private MainDesktopManager() {
        }

        @Override
        public void closeFrame(JInternalFrame jInternalFrame) {
            InternalFrame internalFrame = (InternalFrame)jInternalFrame;
            boolean bl = FrameworkCommandProcessor.getInstance().isAppStyle();
            if (bl && null != ApplicationLauncher.getAppLauncher().getLastActiveInternalFrame() && !ApplicationLauncher.getAppLauncher().isAppEmptyFrameDisposing() && !(internalFrame instanceof InternalDialog)) {
                logger.trace("APpinternalFrame  is closed with previous application frame active");
                this.closeAPPInternalFrame(jInternalFrame);
                ApplicationLauncher.getAppLauncher().setLastActiveFrame(null);
            } else {
                super.closeFrame(jInternalFrame);
            }
            ReflectionUtilities.callTheMethod((Object)MainDesktopPane.this, JDesktopPane.class, "updateFramesCache", new Object[0]);
            jInternalFrame.putClientProperty("wasIconOnce", Boolean.FALSE);
            if (jInternalFrame.isMaximum()) {
                try {
                    jInternalFrame.setMaximum(false);
                    JInternalFrame jInternalFrame2 = MainDesktopPane.this.getNextInternalFrame(true);
                    if (jInternalFrame instanceof InternalFrame && ((InternalFrame)jInternalFrame).isManaged() && jInternalFrame2 instanceof InternalFrame) {
                        boolean bl2 = ((InternalFrame)jInternalFrame2).isManaged();
                        if (!((InternalFrame)jInternalFrame2).isRegistered() && bl2) {
                            JInternalFrame jInternalFrame3 = MainDesktopPane.this.getNextMaximizableInternalFrame();
                            if (null != jInternalFrame3) {
                                jInternalFrame3.setMaximum(true);
                            }
                        } else if (bl2) {
                            jInternalFrame2.setMaximum(true);
                        } else if (!bl2) {
                            JInternalFrame jInternalFrame4 = MainDesktopPane.this.getNextMaximizableInternalFrame();
                            if (null != jInternalFrame4) {
                                MainDesktopPane.this.redundantSelectFrameFlag = true;
                                jInternalFrame4.setMaximum(true);
                                MainDesktopPane.this.redundantSelectFrameFlag = false;
                            }
                            jInternalFrame2.setSelected(true);
                        }
                    }
                }
                catch (PropertyVetoException propertyVetoException) {
                    logger.trace(propertyVetoException.getMessage(), propertyVetoException);
                }
            }
            jInternalFrame.removeInternalFrameListener(MainDesktopPane.this.internalFrameListener);
        }

        private void closeAPPInternalFrame(JInternalFrame jInternalFrame) {
            JDesktopPane jDesktopPane = jInternalFrame.getDesktopPane();
            if (jDesktopPane == null) {
                return;
            }
            boolean bl = jInternalFrame.isSelected();
            Container container = jInternalFrame.getParent();
            InternalFrame internalFrame = null;
            if (bl) {
                internalFrame = ApplicationLauncher.getAppLauncher().getLastActiveInternalFrame();
                try {
                    jInternalFrame.setSelected(false);
                }
                catch (PropertyVetoException propertyVetoException) {
                    logger.trace("Excetpion in Closing APp internalFrame");
                }
            }
            if (container != null) {
                container.remove(jInternalFrame);
                container.repaint(jInternalFrame.getX(), jInternalFrame.getY(), jInternalFrame.getWidth(), jInternalFrame.getHeight());
            }
            this.removeIconFor(jInternalFrame);
            if (jInternalFrame.getNormalBounds() != null) {
                jInternalFrame.setNormalBounds(null);
            }
            if (this.wasIcon(jInternalFrame)) {
                this.setWasIcon(jInternalFrame, null);
            }
            if (internalFrame != null) {
                try {
                    ((JInternalFrame)internalFrame).setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    logger.trace("Excetpion in Closing APp internalFrame");
                }
            } else if (bl && jDesktopPane.getComponentCount() == 0) {
                jDesktopPane.requestFocus();
            }
        }

        @Override
        public void iconifyFrame(JInternalFrame jInternalFrame) {
            this.setWasIcon(jInternalFrame, Boolean.FALSE);
            super.iconifyFrame(jInternalFrame);
            if (jInternalFrame.isMaximum()) {
                try {
                    jInternalFrame.setMaximum(false);
                    if (jInternalFrame.getNormalBounds() != null) {
                        Rectangle rectangle = jInternalFrame.getNormalBounds();
                        jInternalFrame.setNormalBounds(null);
                        this.setBoundsForFrame(jInternalFrame, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    }
                }
                catch (PropertyVetoException propertyVetoException) {
                    logger.trace(propertyVetoException.getMessage(), propertyVetoException);
                }
            }
        }

        @Override
        protected Rectangle getBoundsForIconOf(JInternalFrame jInternalFrame) {
            return super.getBoundsForIconOf(jInternalFrame);
        }
    }

    private class SymComponent
    extends ComponentAdapter {
        private SymComponent() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            Object object = componentEvent.getSource();
            if (object == MainDesktopPane.this) {
                MainDesktopPane.this.componentResizedProcess();
            }
        }
    }
}

