/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.windowmanagement;

import com.swimap.iview.commstyle.commini.Menu;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.framework.applicationmanagement.Application;
import com.swimap.iview.framework.applicationmanagement.ApplicationData;
import com.swimap.iview.framework.applicationmanagement.ApplicationLauncher;
import com.swimap.iview.framework.applicationmanagement.ApplicationManager;
import com.swimap.iview.framework.applicationmanagement.gui.FloatingAppPanel;
import com.swimap.iview.framework.lookandfeel.SwimapInternalFrameTitlePane;
import com.swimap.iview.framework.lookandfeel.SwimapToolTipUI;
import com.swimap.iview.framework.mainframe.MDIFrame;
import com.swimap.iview.framework.menumanagement.MenuManager;
import com.swimap.iview.framework.util.FrameworkCommandProcessor;
import com.swimap.iview.framework.util.FrameworkGlobalInfo;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.framework.windowmanagement.IInternalFrameInterface;
import com.swimap.iview.framework.windowmanagement.InternalDialog;
import com.swimap.iview.framework.windowmanagement.WindowManager;
import com.swimap.iview.framework.windowmanagement.WindowManagerCheckBoxMenuItem;
import com.swimap.iview.framework.windowmanagement.WindowStyle;
import com.swimap.iview.framework.windowmanagement.navigation.NavigationHistory;
import com.swimap.iview.framework.windowmanagement.windowtabbed.WindowTabbedManager;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.adapter.PrintSupporterAdapter;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.mdi.ExtendedWindow;
import com.swimap.mdi.WindowInterface;
import com.swimap.mdi.WindowState;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.im.InputContext;
import java.awt.print.PageFormat;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.text.MessageFormat;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicInternalFrameUI;

public class InternalFrame
extends JInternalFrame
implements IInternalFrameInterface,
WindowInterface {
    private static IviewLogger logger = IviewLogger.getLogger(InternalFrame.class, "IVIEW");
    protected WindowStyle windowStyle = new WindowStyle();
    private boolean bAutoStoreStyles = false;
    private WindowManager windowManager = null;
    private int windowId = -1;
    private String styleName = null;
    private boolean isPreClosed = false;
    private boolean isInPreProcess = false;
    private boolean isFullScreenable = true;
    private ExtendedWindow framePanel = null;
    private boolean isMaximumBeforeIcon = false;
    public static final String IS_BUSY_PROPERTY = "isBusy";
    private boolean isBusy = false;
    private String busyMessage = "";
    private boolean printable = false;
    protected InternalFrame childAfterIconify = null;
    private boolean previewable = false;
    WindowManager navWindowMngr = FrameworkUtilities.getWindowManager();
    static int countRegisterWindow = 0;
    static boolean closeWindow = false;
    int cntCloseWindow = 0;
    private boolean lockScreen = false;
    protected InternalFrame modalChild = null;
    transient InputContext frameInputContext;
    private transient Object frameInputContextLock = new Object();
    private String appID = null;
    private transient InternalFrameAdapter internalFrameAdapter = new InternalFrameAdapter(){

        @Override
        public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
            InternalFrame internalFrame = (InternalFrame)internalFrameEvent.getSource();
            internalFrame.internalFrameActivated(internalFrameEvent);
            if (FrameworkCommandProcessor.getInstance().isAppStyle()) {
                if (FrameworkUtilities.getWindowTabbedManager().getTabbedBar() == null) {
                    ApplicationLauncher.getAppLauncher().updateMDIFrame(internalFrame.getAppID());
                }
                ApplicationLauncher.getAppLauncher().setLastActiveFrame(null);
            }
            if (InternalFrame.this.navWindowMngr.registerHistory) {
                NavigationHistory navigationHistory = (NavigationHistory)InternalFrame.this.navWindowMngr.getNavigationHistory();
                int n = internalFrame.getWindowId();
                navigationHistory.addWindow(n);
                logger.trace("Entry is added to the Navigation History for Ctrl Tab for frame: " + internalFrame.getTitle());
                InternalFrame.this.navWindowMngr.registerHistory = false;
            }
        }

        @Override
        public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
            InternalFrame internalFrame = (InternalFrame)internalFrameEvent.getSource();
            internalFrame.internalFrameDeactivated(internalFrameEvent);
            CommonUtil.hideShowTooltip();
            ((MDIFrame)FrameworkUtilities.getMainFrame()).hidePopupMenu();
        }

        @Override
        public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
            InternalFrame internalFrame = (InternalFrame)internalFrameEvent.getSource();
            internalFrame.internalFrameClosed(internalFrameEvent);
        }

        @Override
        public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
            InternalFrame internalFrame = (InternalFrame)internalFrameEvent.getSource();
            try {
                internalFrame.internalFrameClosing(internalFrameEvent);
            }
            catch (Exception exception) {
                logger.trace("Exception while doing internalFrameClosing for the frame: " + internalFrame.getName() + " ( " + exception.getMessage() + " )");
            }
        }

        @Override
        public void internalFrameIconified(InternalFrameEvent internalFrameEvent) {
            InternalFrame internalFrame = (InternalFrame)internalFrameEvent.getSource();
            internalFrame.internalFrameIconified(internalFrameEvent);
        }

        @Override
        public void internalFrameDeiconified(InternalFrameEvent internalFrameEvent) {
            InternalFrame internalFrame = (InternalFrame)internalFrameEvent.getSource();
            internalFrame.internalFrameDeiconified(internalFrameEvent);
        }

        @Override
        public void internalFrameOpened(InternalFrameEvent internalFrameEvent) {
            InternalFrame internalFrame = (InternalFrame)internalFrameEvent.getSource();
            internalFrame.internalFrameOpened(internalFrameEvent);
        }
    };
    private boolean isStyleLoaded = false;
    private boolean isRegistered = false;
    private boolean isManaged = true;
    private JMenuItem menuItem = null;
    private transient KeyAdapter keyAdapter = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == KeyStroke.getKeyStroke(9, 2).getKeyCode() && ((MDIFrame)FrameworkUtilities.getMainFrame()).hasPopupMenu()) {
                keyEvent.consume();
            }
        }
    };

    public InternalFrame getModalChild() {
        return this.modalChild;
    }

    public void setModalChild(InternalFrame internalFrame) {
        if (null != this.modalChild) {
            return;
        }
        if (internalFrame.isExistsInChildHierarchy(this)) {
            logger.trace("Cycle of parent child hirarchey exists! parent is " + this.getTitle() + ", child is " + internalFrame.getTitle());
            return;
        }
        this.modalChild = internalFrame;
        ChildCloseListener childCloseListener = new ChildCloseListener(this);
        this.modalChild.addInternalFrameListener(childCloseListener);
        this.modalChild.addComponentListener(childCloseListener);
    }

    boolean isExistsInChildHierarchy(InternalFrame internalFrame) {
        if (null == internalFrame) {
            return false;
        }
        if (this == internalFrame) {
            return true;
        }
        if (null == this.getModalChild()) {
            return false;
        }
        InternalFrame internalFrame2 = this.getModalChild();
        return internalFrame2.isExistsInChildHierarchy(internalFrame);
    }

    public InternalFrame() {
        this.setMaximizable(true);
        this.setIconifiable(true);
        this.setClosable(true);
        this.setResizable(true);
        ImageIcon imageIcon = (ImageIcon)ResourceMng.getInstance().getIcon("FrameIcon");
        WindowTabbedManager windowTabbedManager = FrameworkUtilities.getWindowTabbedManager();
        if (null == windowTabbedManager || windowTabbedManager.isDefaultTabIconVisible()) {
            this.setFrameIcon(imageIcon);
        } else {
            this.setFrameIcon(null);
        }
        this.initInternalFrame();
    }

    public InternalFrame(ExtendedWindow extendedWindow) {
        super(extendedWindow.getTitle());
        this.setBounds(extendedWindow.getWindowBounds());
        this.setTitle(extendedWindow.getTitle());
        this.setPrintable(extendedWindow.isPrintable());
        this.setPreviewable(extendedWindow.isPreviewable());
        this.setBusyMessage(extendedWindow.getBusyMessage());
        this.setBusy(extendedWindow.isBusy());
        this.setIconImage(extendedWindow.getIconImage());
        this.getDesktopIcon().setToolTipText(extendedWindow.getTitle());
        if (extendedWindow.isResizable()) {
            this.setMaximizable(extendedWindow.isMaximizable());
            this.setClosable(extendedWindow.isClosable());
            this.setIconifiable(extendedWindow.isIconfinable());
            this.setResizable(true);
        } else {
            this.setMaximizable(false);
            this.setClosable(extendedWindow.isClosable());
            this.setIconifiable(extendedWindow.isIconfinable());
            this.setResizable(false);
        }
        if (extendedWindow.getIconImage() != null) {
            this.setFrameIcon(new ImageIcon(extendedWindow.getIconImage()));
        }
        extendedWindow.setContainer(this);
        this.framePanel = extendedWindow;
        this.getContentPane().add(extendedWindow);
        this.initInternalFrame();
    }

    private void initInternalFrame() {
        this.addInternalFrameListener(this.internalFrameAdapter);
        this.getRootPane().addKeyListener(this.keyAdapter);
        if (this.isStylesAutoStore() && !this.loadStyles()) {
            logger.debug("Load window style failed.");
        }
        this.isMaximumBeforeIcon = this.isMaximum();
        JFrame jFrame = FrameworkUtilities.getMainFrame();
        if (null != jFrame) {
            ((MDIFrame)jFrame).addMouseEventListeners(this);
        } else {
            logger.trace("FrameworkUtilities.getMainFrame() is null.");
        }
    }

    @Override
    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        if (keyEvent.getKeyCode() == 9 && keyEvent.isControlDown() && keyEvent.isShiftDown() && bl) {
            if (!this.navWindowMngr.registerHistory) {
                this.navWindowMngr.registerHistory = true;
            }
            if (FrameworkUtilities.getWindowTabbedManager().isTabbedBarEnable()) {
                FrameworkUtilities.getWindowTabbedManager().getTabbedBar().selectNextTab(false);
            }
            return true;
        }
        if (keyEvent.getKeyCode() == 9 && keyEvent.isControlDown() && bl) {
            if (!this.navWindowMngr.registerHistory) {
                this.navWindowMngr.registerHistory = true;
            }
            if (FrameworkUtilities.getWindowTabbedManager().isTabbedBarEnable()) {
                FrameworkUtilities.getWindowTabbedManager().getTabbedBar().selectNextTab(true);
            }
            return true;
        }
        if (keyEvent.getKeyCode() == 115 && keyEvent.isControlDown() && bl) {
            InternalFrame internalFrame = (InternalFrame)FrameworkUtilities.getWindowManager().getDesktopPane().getSelectedFrame();
            if (internalFrame != null) {
                internalFrame.closeWindow();
            }
            keyEvent.consume();
        }
        return super.processKeyBinding(keyStroke, keyEvent, n, bl);
    }

    public InternalFrame(String string) {
        this();
        this.setTitle(string);
    }

    final boolean styleLoaded() {
        return this.isStyleLoaded;
    }

    @Override
    public boolean loadStyles() {
        if (null == this.getWindowStyleName()) {
            return false;
        }
        if (null == this.windowStyle) {
            this.windowStyle = new WindowStyle();
        }
        if (!this.windowStyle.loadStyles(this.getWindowStyleName())) {
            return false;
        }
        this.setBounds(this.windowStyle.getWindowBounds());
        this.isStyleLoaded = true;
        return true;
    }

    @Override
    public boolean storeStyles() {
        if (null == this.getWindowStyleName()) {
            return false;
        }
        if (null == this.windowStyle) {
            this.windowStyle = new WindowStyle();
        }
        return this.windowStyle.storeStyles(this.getWindowStyleName());
    }

    @Override
    public boolean preProcess() {
        return true;
    }

    @Override
    public void moveToFront() {
        super.moveToFront();
        if (null != this.modalChild) {
            this.modalChild.moveToFront();
        }
    }

    @Override
    public void moveToBack() {
        if (null != this.modalChild) {
            this.modalChild.moveToBack();
        }
        super.moveToBack();
    }

    @Override
    public void setSelected(boolean bl) {
        JInternalFrame jInternalFrame;
        FloatingAppPanel floatingAppPanel;
        if (!this.isRegistered) {
            if (bl) {
                this.toFront();
            }
            return;
        }
        if (bl && FrameworkCommandProcessor.getInstance().isAppStyle() && (floatingAppPanel = FloatingAppPanel.getInstance()).isVisible()) {
            floatingAppPanel.setVisible(false);
        }
        if (null == this.windowManager || null == this.windowManager.getDesktopPane() || this.windowManager.getDesktopPane().isRedundantSelectFrameFlag()) {
            return;
        }
        if (this.windowManager.getDesktopPane().isDemaxAll()) {
            return;
        }
        if (this.isSelected() == bl) {
            return;
        }
        boolean bl2 = false;
        if (!this.isSelected() && null != (jInternalFrame = this.windowManager.getDesktopPane().getNextMaximizableInternalFrame())) {
            logger.debug("Make the internal frame: " + this.getTitle() + " maximum :" + jInternalFrame.isMaximum());
            if (jInternalFrame.isMaximum() && this.isMaximizable() && this.isManaged) {
                bl2 = true;
            }
        }
        if (bl2 && !this.isClosed()) {
            this.setMaximum(true);
        }
        try {
            if (bl) {
                this.closeFullScreenFrame();
            }
            if (ScreenToolKit.getFullScreenFlg()) {
                this.customizedSetSelected(bl);
            } else {
                super.setSelected(bl);
                if (bl && null != (jInternalFrame = this.getModalChild())) {
                    jInternalFrame.toFront();
                }
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            logger.trace(propertyVetoException.getMessage(), propertyVetoException);
            try {
                super.setSelected(bl);
            }
            catch (PropertyVetoException propertyVetoException2) {
                logger.trace("Failed to select:" + propertyVetoException2);
            }
        }
        catch (Exception exception) {
            logger.error(exception.getMessage(), exception);
        }
    }

    private void customizedSetSelected(boolean bl) throws PropertyVetoException {
        if (bl && this.isSelected) {
            this.restoreSubcomponentFocus();
            return;
        }
        Boolean bl2 = this.isSelected ? Boolean.TRUE : Boolean.FALSE;
        Boolean bl3 = bl ? Boolean.TRUE : Boolean.FALSE;
        this.fireVetoableChange("selected", bl2, bl3);
        if (bl) {
            this.restoreSubcomponentFocus();
        }
        this.isSelected = bl;
        this.firePropertyChange("selected", bl2, bl3);
        if (this.isSelected) {
            this.fireInternalFrameEvent(25554);
        } else {
            this.fireInternalFrameEvent(25555);
        }
        this.repaint();
    }

    protected void closeFullScreenFrame() {
        if (ScreenToolKit.getFullScreenFlg()) {
            ScreenToolKit.updateFullScreen(FrameworkUtilities.getMainFrame(), this);
        }
    }

    @Override
    public void setTitle(String string) {
        Object object;
        super.setTitle(string);
        if (this.getRelationalMenuItem() != null) {
            object = "";
            this.getRelationalMenuItem().setIcon(ResourceMng.getInstance().getIconDirect((String)object));
            ((WindowManagerCheckBoxMenuItem)this.getRelationalMenuItem()).updateMenuBaseTitle(this.getTitle());
        }
        object = (MDIFrame)FrameworkUtilities.getMainFrame();
        if (this.isMaximum() && object != null) {
            ((MDIFrame)object).updateCoolbar(this.getWindowId(), true);
        }
        this.getDesktopIcon().setToolTipText(string);
    }

    @Override
    public boolean closeWindow() {
        boolean bl = true;
        if (!this.isClosable()) {
            return false;
        }
        if (null != this.modalChild) {
            bl = this.modalChild.closeWindow();
        }
        if (bl) {
            closeWindow = true;
            this.doDefaultCloseAction();
        }
        return this.isClosed() && bl;
    }

    @Override
    public void doDefaultCloseAction() {
        if (null != this.modalChild && !this.modalChild.isClosed) {
            this.modalChild.doDefaultCloseAction();
        }
        if (this.doPreClose()) {
            Component component;
            if (this.isSelected()) {
                ((MDIFrame)FrameworkUtilities.getMainFrame()).hidePopupMenu();
            }
            super.doDefaultCloseAction();
            JInternalFrame jInternalFrame = FrameworkUtilities.getWindowManager().getDesktopPane().getSelectedFrame();
            if (jInternalFrame == null) {
                component = FrameworkUtilities.getCurrentActiveFrame();
                if (null == component) {
                    FrameworkUtilities.getMainFrame().getRootPane().requestFocus();
                } else {
                    component.requestFocusInWindow();
                }
                if (FrameworkCommandProcessor.getInstance().isAppStyle() && !ApplicationLauncher.getAppLauncher().isAppEmptyFrameDisposing()) {
                    ApplicationLauncher applicationLauncher = ApplicationLauncher.getAppLauncher();
                    applicationLauncher.updateMDIFrame(null);
                    Application application = ApplicationManager.getInstance().getApplication(applicationLauncher.getActiveFrameAppId());
                    if (null != application) {
                        application.notifyApplicationDeActivated(applicationLauncher.getActiveFrameAppId());
                        applicationLauncher.setActiveFrameAppId(null);
                    }
                }
            } else {
                component = jInternalFrame.getFocusOwner();
                if (null == component) {
                    jInternalFrame.requestFocusInWindow();
                } else {
                    component.requestFocusInWindow();
                }
            }
            if (FrameworkCommandProcessor.getInstance().isAppStyle()) {
                component = FrameworkUtilities.getWindowManager().getActiveAppFrame(this.appID);
                if (this == component) {
                    FrameworkUtilities.getWindowManager().updateActiveApPFrame(this.appID, null);
                } else if (jInternalFrame != null && !((InternalFrame)jInternalFrame).isRegistered) {
                    ApplicationLauncher.getAppLauncher().updateMDIFrame(((InternalFrame)jInternalFrame).appID);
                }
            }
        }
    }

    @Override
    public void setClosed(boolean bl) throws PropertyVetoException {
        Boolean bl2;
        if (this.isClosed == bl) {
            return;
        }
        Boolean bl3 = this.isClosed ? Boolean.TRUE : Boolean.FALSE;
        Boolean bl4 = bl2 = bl ? Boolean.TRUE : Boolean.FALSE;
        if (bl) {
            if (!this.doPreClose()) {
                return;
            }
            this.fireInternalFrameEvent(25550);
        }
        this.fireVetoableChange("closed", bl3, bl2);
        this.isClosed = bl;
        this.firePropertyChange("closed", bl3, bl2);
        if (this.isClosed) {
            this.dispose();
        }
    }

    @Override
    public void dispose() {
        if (this.doPreClose()) {
            Container container;
            super.dispose();
            this.removeMenus();
            this.unregister();
            this.removeInternalFrameListener(this.internalFrameAdapter);
            ((MDIFrame)FrameworkUtilities.getMainFrame()).removeMouseEventListeners(this);
            this.getRootPane().removeKeyListener(this.keyAdapter);
            this.internalFrameAdapter = null;
            this.keyAdapter = null;
            JInternalFrame jInternalFrame = FrameworkUtilities.getWindowManager().getDesktopPane().getSelectedFrame();
            CommonUtil.hideShowTooltip();
            JToolTip jToolTip = new JToolTip();
            ComponentUI componentUI = SwimapToolTipUI.createUI(jToolTip);
            componentUI.uninstallUI(jToolTip);
            if (jInternalFrame == null) {
                Object object;
                container = FrameworkUtilities.getCurrentActiveFrame();
                if (null != container && container != FrameworkUtilities.getMainFrame()) {
                    container.requestFocusInWindow();
                } else {
                    object = FrameworkUtilities.getWindowManager().getDesktopPane().getAllFrames();
                    if (object != null && ((JInternalFrame[])object).length > 0) {
                        object[((JInternalFrame[])object).length - 1].getDesktopIcon().requestFocus();
                    }
                }
                if (FrameworkCommandProcessor.getInstance().isAppStyle() && !ApplicationLauncher.getAppLauncher().isAppEmptyFrameDisposing()) {
                    object = ApplicationLauncher.getAppLauncher();
                    ((ApplicationLauncher)object).updateMDIFrame(null);
                    Application application = ApplicationManager.getInstance().getApplication(((ApplicationLauncher)object).getActiveFrameAppId());
                    if (null != application) {
                        application.notifyApplicationDeActivated(((ApplicationLauncher)object).getActiveFrameAppId());
                        ((ApplicationLauncher)object).setActiveFrameAppId(null);
                    }
                }
            }
            if (FrameworkCommandProcessor.getInstance().isAppStyle()) {
                container = FrameworkUtilities.getWindowManager().getActiveAppFrame(this.appID);
                if (this == container) {
                    FrameworkUtilities.getWindowManager().updateActiveApPFrame(this.appID, null);
                } else if (jInternalFrame != null && !((InternalFrame)jInternalFrame).isRegistered) {
                    ApplicationLauncher.getAppLauncher().updateMDIFrame(((InternalFrame)jInternalFrame).appID);
                }
            }
        }
    }

    private void removeMenus() {
        Menu menu;
        MenuManager menuManager;
        ApplicationData applicationData;
        if (FrameworkCommandProcessor.getInstance().isAppStyle() && null != (applicationData = ApplicationLauncher.getAppLauncher().getApplicationData(this.appID)) && null != (menuManager = applicationData.getMenuManager()) && null != (menu = menuManager.getMenu("mainMenu", "WindowMenu")) && null != this.getRelationalMenuItem()) {
            menu.remove(this.getRelationalMenuItem());
        }
    }

    final void disposeOnly() {
        if (this.doPreClose()) {
            super.dispose();
        }
    }

    protected boolean preDispose() {
        if (this.isInPreProcess) {
            return true;
        }
        if (this.framePanel != null) {
            return this.framePanel.windowPreClose();
        }
        this.isInPreProcess = true;
        try {
            this.isInPreProcess = this.preProcess();
            return this.isInPreProcess;
        }
        catch (Exception exception) {
            logger.debug("Exception while doing preProcess: ( " + exception.getMessage() + " )");
            return true;
        }
    }

    private boolean doPreClose() {
        if (null != this.modalChild && !this.modalChild.isClosed) {
            this.modalChild.doDefaultCloseAction();
        }
        if (this.isPreClosed) {
            return true;
        }
        try {
            if (this.preDispose() || this.windowManager.isLogout()) {
                this.isPreClosed = true;
                if (this.isStylesAutoStore() && !this.storeStyles()) {
                    logger.debug("Store styles failed.");
                }
                this.closeFullScreen();
                return true;
            }
        }
        catch (Exception exception) {
            logger.error("Exception while doing preProcess: ( " + exception.getMessage() + " )");
            return true;
        }
        return false;
    }

    protected void closeFullScreen() {
        if (ScreenToolKit.getFullScreenFlg() && ScreenToolKit.getSrcChildFrame() == this && !(this instanceof InternalDialog)) {
            ScreenToolKit.closeFullScreenFrame();
        }
    }

    public void unregister() {
        if (this.isRegistered && null != this.windowManager) {
            if (!this.windowManager.unregisterWindow(this.getWindowId())) {
                logger.debug("Unregister window failed:" + this.getTitle());
            }
            this.isRegistered = false;
        }
    }

    public boolean isRegistered() {
        return this.isRegistered;
    }

    final void setRegister(boolean bl) {
        this.isRegistered = bl;
        this.isPreClosed = false;
        this.isInPreProcess = false;
    }

    public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
        if (this.framePanel != null) {
            this.addMenuToParent(this.getJFrame().getJMenuBar());
            this.getJFrame().getJMenuBar().revalidate();
            this.getJFrame().getJMenuBar().repaint();
            if (this.framePanel.getToolbar() != null) {
                this.framePanel.getToolbar().setVisible(true);
                FrameworkUtilities.getToolbarManager().updateToolbars();
            }
            this.framePanel.windowActivated();
        }
    }

    public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
        if (this.bAutoStoreStyles && !this.storeStyles()) {
            logger.debug("Store styles failed.");
        }
        if (this.framePanel != null) {
            this.getContentPane().remove(this.framePanel);
            try {
                this.framePanel.windowClosed();
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
            }
            this.framePanel.setContainer(null);
            this.framePanel = null;
        }
    }

    public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
    }

    public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
        if (this.framePanel != null) {
            this.delMenuFromParent(this.getJFrame().getJMenuBar());
            this.getJFrame().getJMenuBar().revalidate();
            this.getJFrame().getJMenuBar().repaint();
            if (this.framePanel.getToolbar() != null) {
                this.framePanel.getToolbar().setVisible(false);
                FrameworkUtilities.getToolbarManager().updateToolbars();
            }
            this.framePanel.windowDeactivated();
        }
    }

    public void internalFrameDeiconified(InternalFrameEvent internalFrameEvent) {
        if (null != this.childAfterIconify) {
            this.modalChild = this.childAfterIconify;
            this.childAfterIconify = null;
            ((InternalDialog)this.modalChild).showDialog();
        }
    }

    InternalFrame getChildAfterIconify() {
        return this.childAfterIconify;
    }

    public void internalFrameIconified(InternalFrameEvent internalFrameEvent) {
        if (null != this.modalChild) {
            this.childAfterIconify = this.modalChild;
            ((InternalDialog)this.modalChild).hideDialog();
        }
    }

    public void internalFrameOpened(InternalFrameEvent internalFrameEvent) {
        if (this.framePanel != null) {
            this.framePanel.windowOpened();
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiersEx() & 0x1400) == 5120) {
            mouseEvent.consume();
        } else if ((mouseEvent.getModifiersEx() & 0xC00) == 3072) {
            mouseEvent.consume();
        } else {
            super.processMouseEvent(mouseEvent);
        }
    }

    @Override
    public void setWindowManager(WindowManager windowManager) {
        this.windowManager = windowManager;
    }

    @Override
    public int getWindowId() {
        return this.windowId;
    }

    @Override
    public void setWindowId(int n) {
        this.windowId = n;
    }

    @Override
    public void setMaximum(boolean bl) {
        if (!this.isRegistered) {
            return;
        }
        boolean bl2 = this.isMaximum();
        Rectangle rectangle = new Rectangle(this.getBounds());
        if (bl) {
            this.windowStyle.setWindowState(this.windowStyle.MAXIMUM_STATE);
            if (bl2 && !this.isIcon()) {
                return;
            }
            if (!this.isMaximizable()) {
                logger.error("Try to set a InternalFrame: " + this.getTitle() + " maximum while it can't be maximized.");
                return;
            }
            if (this.isManaged) {
                this.windowManager.getDesktopPane().demaxmizeAll();
            }
            if (!this.isIcon()) {
                this.windowStyle.setWindowBounds(rectangle);
            }
            try {
                super.setMaximum(bl);
            }
            catch (PropertyVetoException propertyVetoException) {
                logger.trace(propertyVetoException.getMessage(), propertyVetoException);
                return;
            }
            if (!this.windowManager.activateWindow(this.getWindowId())) {
                logger.debug("Active window failed:" + this.getTitle());
            }
            this.setResizable(false);
        } else {
            this.windowStyle.setWindowState(this.windowStyle.NORMAL_STATE);
            if (!bl2) {
                return;
            }
            try {
                super.setMaximum(bl);
            }
            catch (PropertyVetoException propertyVetoException) {
                logger.trace(propertyVetoException.getMessage(), propertyVetoException);
                return;
            }
            if (this.isManaged) {
                this.windowManager.getDesktopPane().demaxmizeAll();
            }
            this.setResizable(true);
        }
        if (this.isMaximum() && this.isIcon()) {
            this.setIcon(false);
        }
        this.windowManager.notifyDesktopListener(this.getWindowId());
    }

    public void modifySize() {
        if (this.isMaximum()) {
            this.adjustToMaxSize();
        }
    }

    @Override
    public void reshape(int n, int n2, int n3, int n4) {
        if (this.isMaximum()) {
            Rectangle rectangle = this.getAdjustedMaxSize();
            if (null != rectangle) {
                super.reshape(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        } else {
            super.reshape(n, n2, n3, n4);
            this.windowStyle.setWindowBounds(n, n2, n3, n4);
        }
        this.validate();
        this.repaint();
    }

    public boolean isManaged() {
        return this.isManaged;
    }

    public void setManager(boolean bl) {
        this.isManaged = bl;
    }

    @Override
    public void setIcon(boolean bl) {
        JInternalFrame jInternalFrame;
        if (this.windowManager != null) {
            int n;
            if (this.isIcon()) {
                logger.trace("The Internal Frame " + this.title + " is in minimized form");
                n = this.getWindowId();
                this.windowManager.getNavigationHistory().addWindow(n);
            } else if (!this.isMaximum()) {
                if (this.windowManager.regWindow) {
                    logger.trace("Internal Frame: " + this.getTitle() + " is opened :" + countRegisterWindow);
                    if (countRegisterWindow < 2) {
                        ++countRegisterWindow;
                    } else {
                        countRegisterWindow = 0;
                        this.windowManager.regWindow = false;
                    }
                } else {
                    logger.trace("Internal Frame: " + this.getTitle() + " is not registerd :" + closeWindow);
                    if (!closeWindow) {
                        logger.trace("Internal Frame: " + this.getTitle() + " is not closing; add entry to the navigation history");
                        n = this.getWindowId();
                        this.windowManager.getNavigationHistory().addWindow(n);
                    } else {
                        logger.trace("Internal Frame was closed");
                        if (this.cntCloseWindow > 0) {
                            closeWindow = false;
                            this.cntCloseWindow = 0;
                        } else {
                            ++this.cntCloseWindow;
                        }
                    }
                }
            }
        }
        if (bl) {
            this.isMaximumBeforeIcon = this.isMaximum();
        }
        try {
            super.setIcon(bl);
            this.windowStyle.setWindowState(this.windowStyle.ICON_STATE);
        }
        catch (PropertyVetoException propertyVetoException) {
            logger.trace(propertyVetoException.getMessage(), propertyVetoException);
        }
        if (this.isMaximumBeforeIcon && !bl) {
            try {
                super.setMaximum(true);
                this.isMaximumBeforeIcon = false;
            }
            catch (PropertyVetoException propertyVetoException) {
                logger.trace(propertyVetoException.getMessage(), propertyVetoException);
            }
        }
        if (null != (jInternalFrame = FrameworkUtilities.getWindowManager().getDesktopPane().getSelectedFrame()) && (!this.isMaximumBeforeIcon || bl)) {
            ((MDIFrame)FrameworkUtilities.getMainFrame()).updateCoolbar(((InternalFrame)jInternalFrame).getWindowId(), ((InternalFrame)jInternalFrame).isMaximum());
        }
        if (jInternalFrame == null) {
            this.getDesktopIcon().requestFocus();
        }
    }

    public String getWindowStyleName() {
        return this.styleName;
    }

    public void setWindowStyleName(String string) {
        this.styleName = string;
        if (!this.loadStyles()) {
            logger.debug("Load styles failed.");
        }
    }

    final void setRelationalMenuItem(JMenuItem jMenuItem) {
        this.menuItem = jMenuItem;
    }

    public JMenuItem getRelationalMenuItem() {
        return this.menuItem;
    }

    public boolean isStylesAutoStore() {
        return this.bAutoStoreStyles;
    }

    public void setStylesAutoStore(boolean bl) {
        if (!this.bAutoStoreStyles && bl && !this.loadStyles()) {
            logger.debug("Load styles failed.");
        }
        this.bAutoStoreStyles = bl;
    }

    public void adjustToMaxSize() {
        Rectangle rectangle = this.getAdjustedMaxSize();
        if (null != rectangle) {
            this.reshape(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public Rectangle getAdjustedMaxSize() {
        int n = this.getInternalTitleHeight();
        Insets insets = this.getInsets();
        if (null != this.getParent()) {
            return new Rectangle(-insets.left, -n, this.getParent().getWidth() + insets.left + insets.right, this.getParent().getHeight() + n + insets.bottom);
        }
        return null;
    }

    private int getInternalTitleHeight() {
        int n = 0;
        BasicInternalFrameUI basicInternalFrameUI = (BasicInternalFrameUI)this.getUI();
        JComponent jComponent = basicInternalFrameUI.getNorthPane();
        if (jComponent != null) {
            Dimension dimension = jComponent.getPreferredSize();
            Insets insets = this.getInsets();
            n = dimension.height + insets.top;
        }
        return n;
    }

    public boolean isFullScreenable() {
        return this.isFullScreenable;
    }

    public void setFullScreenable(boolean bl) {
        this.isFullScreenable = bl;
    }

    @Override
    public void setIconImage(Image image) {
        if (image != null) {
            super.setFrameIcon(new ImageIcon(image));
        } else {
            super.setFrameIcon(null);
        }
    }

    @Override
    public Image getIconImage() {
        Icon icon = super.getFrameIcon();
        if (icon != null) {
            return ((ImageIcon)icon).getImage();
        }
        return null;
    }

    @Override
    public void setWindowBounds(Rectangle rectangle) {
        if (rectangle != null) {
            this.setBounds(rectangle);
        }
    }

    @Override
    public void addMenu(JMenu jMenu) {
        JMenuBar jMenuBar = this.getJFrame().getJMenuBar();
        jMenuBar.add((Component)jMenu, jMenuBar.getMenuCount() - FrameworkGlobalInfo.MenuStyle.INSERT_INDEX);
    }

    @Override
    public void addMenu(JMenu jMenu, JMenu jMenu2, int n) {
        JMenuBar jMenuBar = this.getJFrame().getJMenuBar();
        if (jMenuBar.getComponentIndex(jMenu2) >= 0) {
            jMenu2.insert(jMenu, n);
        }
    }

    @Override
    public Rectangle getWindowBounds() {
        return this.getBounds();
    }

    @Override
    public void setWindowState(WindowState windowState) {
        switch (windowState.getValue()) {
            case 0: {
                this.setMaximum(false);
                this.setIcon(false);
                break;
            }
            case 1: {
                this.setIcon(true);
                break;
            }
            case 2: {
                this.setMaximum(true);
                break;
            }
        }
    }

    @Override
    public WindowState getWindowState() {
        if (this.isMaximum()) {
            return WindowState.MAX_STATE;
        }
        if (this.isIcon()) {
            return WindowState.ICON_STATE;
        }
        return WindowState.NORMAL_STATE;
    }

    @Override
    public JFrame getJFrame() {
        return this.windowManager.getJFrame();
    }

    @Override
    public void addMenuItem(JMenuItem jMenuItem, JMenu jMenu, int n) {
        JMenuBar jMenuBar = this.getJFrame().getJMenuBar();
        if (jMenuBar.getComponentIndex(jMenu) >= 0) {
            jMenu.insert(jMenuItem, n);
        }
    }

    @Override
    public void removeMenu(JMenu jMenu) {
        JMenuBar jMenuBar = this.getJFrame().getJMenuBar();
        jMenuBar.remove(jMenu);
    }

    @Override
    public void removeMenu(JMenu jMenu, JMenu jMenu2) {
        JMenuBar jMenuBar = this.getJFrame().getJMenuBar();
        if (jMenuBar.getComponentIndex(jMenu2) >= 0) {
            jMenu2.remove(jMenu);
        }
    }

    @Override
    public void removeMenuItem(JMenuItem jMenuItem, JMenu jMenu) {
        JMenuBar jMenuBar = this.getJFrame().getJMenuBar();
        if (jMenuBar.getComponentIndex(jMenu) >= 0) {
            jMenu.remove(jMenuItem);
        }
    }

    public void addMenuToParent(JMenuBar jMenuBar) {
        JMenu[] jMenuArray;
        int n = this.framePanel.getMenuSite();
        if (n < 0) {
            int n2 = jMenuBar.getMenuCount();
            n = n2 > FrameworkGlobalInfo.MenuStyle.INSERT_INDEX ? n2 - FrameworkGlobalInfo.MenuStyle.INSERT_INDEX : 0;
        }
        if ((jMenuArray = this.framePanel.getJMenus()) != null && jMenuArray.length > 0) {
            for (int i = 0; i < jMenuArray.length; ++i) {
                jMenuBar.add((Component)jMenuArray[i], n);
            }
        }
    }

    public void delMenuFromParent(JMenuBar jMenuBar) {
        JMenu[] jMenuArray = this.framePanel.getJMenus();
        if (jMenuArray != null && jMenuArray.length > 0) {
            for (int i = 0; i < jMenuArray.length; ++i) {
                jMenuBar.remove(jMenuArray[i]);
            }
        }
    }

    @Override
    public final boolean isBusy() {
        return this.isBusy;
    }

    @Override
    public final void setBusy(boolean bl) {
        if (this.isBusy == bl) {
            return;
        }
        this.isBusy = bl;
        JButton jButton = this.getCloseButton();
        if (null != jButton) {
            if (bl) {
                jButton.setEnabled(false);
            } else {
                jButton.setEnabled(true);
            }
        }
        this.firePropertyChange(IS_BUSY_PROPERTY, !bl, bl);
    }

    private JButton getCloseButton() {
        JButton jButton = null;
        BasicInternalFrameUI basicInternalFrameUI = (BasicInternalFrameUI)this.getUI();
        JComponent jComponent = basicInternalFrameUI.getNorthPane();
        if (jComponent instanceof SwimapInternalFrameTitlePane) {
            jButton = ((SwimapInternalFrameTitlePane)jComponent).getCloseButton();
        }
        return jButton;
    }

    @Override
    public final void setBusyMessage(String string) {
        this.busyMessage = string;
    }

    @Override
    public final String getBusyMessage() {
        if (null == this.busyMessage || this.busyMessage.trim().length() == 0) {
            return MessageFormat.format(WindowManager.res.getString("InternalFrame_Default_BusyMsg"), this.getTitle());
        }
        return this.busyMessage;
    }

    @Override
    public void setPrintable(boolean bl) {
        this.printable = bl;
        if (null != this.windowManager) {
            this.windowManager.refreshFileMenuStatus(this);
        }
    }

    @Override
    public boolean isPrintable() {
        return this.printable;
    }

    @Override
    public void setPreviewable(boolean bl) {
        this.previewable = bl;
        if (null != this.windowManager) {
            this.windowManager.refreshFileMenuStatus(this);
        }
    }

    @Override
    public boolean isPreviewable() {
        return this.previewable;
    }

    @Override
    public boolean print() {
        if (null != this.framePanel) {
            return this.framePanel.print();
        }
        return true;
    }

    @Override
    public boolean printPreview() {
        if (null != this.framePanel) {
            return this.framePanel.printPreview();
        }
        return true;
    }

    @Override
    public boolean setupPage() {
        if (!this.isPrintable() && !this.isPreviewable()) {
            logger.debug("This internalFrame: " + this.getTitle() + " don't allow to print");
            return false;
        }
        PrintRequestAttributeSet printRequestAttributeSet = PrintSupporterAdapter.getPrintRequestAttributeSet();
        if (null != printRequestAttributeSet) {
            PrintSupporterAdapter.setupPage(printRequestAttributeSet);
        }
        return true;
    }

    @Override
    public PageFormat getPageFormat() {
        return PrintSupporterAdapter.getPageFormat();
    }

    @Override
    public PrintRequestAttributeSet getPrintRequestAttributeSet() {
        return PrintSupporterAdapter.getPrintRequestAttributeSet();
    }

    public void setLockScreen(boolean bl) {
        this.lockScreen = bl;
    }

    public boolean isLockScreen() {
        return this.lockScreen;
    }

    public boolean isMaximumBeforeIconed() {
        return this.isMaximumBeforeIcon;
    }

    public boolean preLogout() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputContext getInputContext() {
        if (this.frameInputContext == null) {
            Object object = this.frameInputContextLock;
            synchronized (object) {
                if (this.frameInputContext == null) {
                    this.frameInputContext = InputContext.getInstance();
                }
            }
        }
        return this.frameInputContext;
    }

    public String getAppID() {
        return this.appID;
    }

    public void setAppID(String string) {
        this.appID = string;
    }

    private class ChildCloseListener
    extends InternalFrameAdapter
    implements ComponentListener {
        private boolean isCloseOperationCalled = false;
        private InternalDialog child = null;
        private boolean bDialogShown = false;
        private MouseAdapter mouseListener = null;

        public ChildCloseListener(InternalFrame internalFrame2) {
            Component component = internalFrame2.getGlassPane();
            component.setVisible(false);
            this.mouseListener = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                }
            };
            component.addMouseListener(this.mouseListener);
            this.child = (InternalDialog)internalFrame2.getModalChild();
        }

        private void closeOperation() {
            PropertyChangeListener[] propertyChangeListenerArray;
            InternalFrame internalFrame = this.child.getModalParent();
            if (this.isCloseOperationCalled || internalFrame != null && internalFrame.isIcon()) {
                return;
            }
            this.isCloseOperationCalled = true;
            InternalDialog internalDialog = (InternalDialog)InternalFrame.this.modalChild;
            InternalFrame.this.getGlassPane().setVisible(false);
            InternalFrame.this.getGlassPane().removeMouseListener(this.mouseListener);
            InternalFrame.this.modalChild = null;
            for (PropertyChangeListener propertyChangeListener : propertyChangeListenerArray = InternalFrame.this.getPropertyChangeListeners()) {
                if (!(propertyChangeListener instanceof InternalDialog.InternalFrameSelectedProperty)) continue;
                InternalFrame.this.removePropertyChangeListener(propertyChangeListener);
            }
            if (null != internalDialog) {
                internalDialog.removeInternalFrameListener(this);
                internalDialog.removeComponentListener(this);
                if (internalDialog.isSelected()) {
                    InternalFrame.this.setSelected(true);
                }
            }
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
            if (this.bDialogShown) {
                this.bDialogShown = false;
                this.closeOperation();
            }
        }

        @Override
        public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
            this.closeOperation();
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
            this.bDialogShown = true;
        }
    }
}

