/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.windowmanagement;

import com.swimap.iview.framework.applicationmanagement.gui.FloatingAppPanel;
import com.swimap.iview.framework.util.FrameworkCommandProcessor;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.framework.windowmanagement.InternalFrame;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FocusTraversalPolicy;
import java.awt.KeyboardFocusManager;
import java.awt.MenuComponent;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TrayIcon;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.swing.FocusManager;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;

public class InternalDialog
extends InternalFrame {
    private static IviewLogger logger = IviewLogger.getLogger(InternalDialog.class, "IVIEW");
    private InternalFrame modalParent = null;
    private static InternalDialog frontDialog = null;
    private boolean modal = false;
    private boolean isSetLocationCalled = false;
    private Component focusOwner = null;
    private JDesktopPane desktopPane;
    private static Class sequencedEventClass = null;
    private static Method getFirstMethod = null;

    public InternalDialog() {
        this("Internal Dialog", FrameworkUtilities.getWindowManager().getDesktopPane());
    }

    public InternalDialog(String string) {
        this(string, FrameworkUtilities.getWindowManager().getDesktopPane());
    }

    public InternalDialog(String string, JDesktopPane jDesktopPane) {
        this.setTitle(string);
        this.setMaximizable(false);
        this.setIconifiable(false);
        this.setResizable(false);
        this.setClosable(true);
        this.setBounds(new Rectangle(50, 50, 500, 300));
        this.desktopPane = jDesktopPane;
    }

    public void setModal(boolean bl) {
        this.modal = bl;
    }

    public boolean isModal() {
        return this.modal;
    }

    @Override
    public void doDefaultCloseAction() {
        InternalFrame internalFrame = this.getModalChild();
        if (null != internalFrame && !internalFrame.isClosed()) {
            internalFrame.doDefaultCloseAction();
            if (!internalFrame.isClosed()) {
                return;
            }
        }
        super.doDefaultCloseAction();
        if (null != this.getModalParent() && this.isSelected()) {
            this.compositeRequestFocus(this.getModalParent());
        }
    }

    @Override
    public void dispose() {
        InternalFrame internalFrame = this.getModalChild();
        if (null != internalFrame && !internalFrame.isClosed()) {
            internalFrame.dispose();
            if (!internalFrame.isClosed()) {
                return;
            }
        }
        super.dispose();
        if (null != this.getModalParent()) {
            if (this.isSelected()) {
                this.compositeRequestFocus(this.getModalParent());
            }
            this.modalParent = null;
        }
        if (null != frontDialog && InternalDialog.frontDialog.isClosed) {
            frontDialog = null;
        }
        this.focusOwner = null;
    }

    void hideDialog() {
        if (null != this.modalChild) {
            this.childAfterIconify = (InternalDialog)this.modalChild;
            ((InternalDialog)this.modalChild).hideDialog();
        }
        super.setVisible(false);
    }

    void showDialog() {
        if (null != this.childAfterIconify) {
            this.modalChild = this.childAfterIconify;
            this.childAfterIconify = null;
            ((InternalDialog)this.modalChild).showDialog();
        }
        super.setVisible(true);
    }

    @Override
    public boolean closeWindow() {
        if (this.isClosed) {
            return true;
        }
        boolean bl = true;
        InternalFrame internalFrame = this.getModalChild();
        if (null != internalFrame && !internalFrame.isClosed()) {
            bl = internalFrame.closeWindow();
        }
        if (bl) {
            this.doDefaultCloseAction();
        }
        return !this.isVisible() && bl;
    }

    public InternalFrame getModalParent() {
        return this.modalParent;
    }

    @Override
    public JDesktopPane getDesktopPane() {
        return this.desktopPane;
    }

    public synchronized void setModalParent(InternalFrame internalFrame) {
        if (this.isVisible()) {
            logger.trace("Cannot set modal parent to internal dialog :" + this.getTitle() + " while it is visible");
            return;
        }
        if (null == internalFrame || null != internalFrame.getModalChild() || internalFrame.getChildAfterIconify() != null) {
            logger.trace("Either parent frame is null or frame: " + this.getTitle() + " already has a child dialog");
            return;
        }
        if (null != internalFrame.getDesktopPane() && internalFrame.getDesktopPane() != this.desktopPane) {
            logger.trace("Cannot set the parent which is in other desktop pane");
            return;
        }
        if (this.isExistsInChildHierarchy(internalFrame)) {
            logger.trace("Cycle of parent child hirarchey exists! parent is " + internalFrame.getTitle() + ", child is " + this.getTitle());
            return;
        }
        internalFrame.setModalChild(this);
        this.modalParent = internalFrame;
        JPanel jPanel = (JPanel)internalFrame.getGlassPane();
        jPanel.setVisible(false);
        jPanel.setOpaque(false);
        jPanel.setLayout(null);
        jPanel.add(this);
    }

    private void requestFocus(final InternalDialog internalDialog) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                InternalDialog.this.compositeRequestFocus(internalDialog);
            }
        });
    }

    @Override
    public void toFront() {
        this.toFront(false);
    }

    public void toFront(boolean bl) {
        boolean bl2;
        super.toFront();
        InternalFrame internalFrame = this.getModalChild();
        boolean bl3 = bl2 = bl || !this.checkFocusOwner();
        if (bl2) {
            if (null == internalFrame) {
                this.requestFocus(this);
                InternalDialog internalDialog = frontDialog;
                frontDialog = this;
                if (null != internalDialog) {
                    internalDialog.repaint();
                }
            } else if (internalFrame instanceof InternalDialog) {
                InternalDialog internalDialog = (InternalDialog)internalFrame;
                if (internalDialog.modal && internalDialog.isVisible()) {
                    this.requestFocus(internalDialog);
                } else {
                    this.requestFocus(this);
                    InternalDialog internalDialog2 = frontDialog;
                    frontDialog = this;
                    if (null != internalDialog2) {
                        internalDialog2.repaint();
                    }
                }
            } else {
                logger.trace("Child " + internalFrame.getTitle() + "  is not an " + "internalDailog , so focus  need not  set to child ");
            }
        }
        if (null != internalFrame && internalFrame.isVisible()) {
            internalFrame.toFront();
        }
    }

    private void compositeRequestFocus(Component component) {
        FocusTraversalPolicy focusTraversalPolicy;
        Component component2;
        Object object;
        Container container;
        if (!(component instanceof Container)) {
            component.requestFocus();
            return;
        }
        if (this.getModalParent() == component && null != (container = this.getModalParent()) && null != (object = ((JInternalFrame)container).getMostRecentFocusOwner()) && object != this) {
            ((Component)object).requestFocus();
            return;
        }
        container = (Container)component;
        if (container.isFocusCycleRoot()) {
            object = container.getFocusTraversalPolicy();
            final Component component3 = ((FocusTraversalPolicy)object).getDefaultComponent(container);
            if (null != component3) {
                if (this.isModal()) {
                    component3.requestFocus();
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (!InternalDialog.this.checkFocusOwner()) {
                                component3.requestFocus();
                            }
                        }
                    });
                }
                return;
            }
            component.requestFocus();
            return;
        }
        object = container.getFocusCycleRootAncestor();
        if (null != object && (component2 = (focusTraversalPolicy = ((Container)object).getFocusTraversalPolicy()).getComponentAfter((Container)object, container)) != null && SwingUtilities.isDescendingFrom(component2, container)) {
            component2.requestFocus();
            return;
        }
    }

    private boolean checkFocusOwner() {
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (component != null) {
            for (Container container = component.getParent(); container != null; container = container.getParent()) {
                if (container != this) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void setSelected(boolean bl) {
        if (this.isSelected() == bl) {
            return;
        }
        if (bl) {
            FloatingAppPanel floatingAppPanel;
            if (bl && FrameworkCommandProcessor.getInstance().isAppStyle() && (floatingAppPanel = FloatingAppPanel.getInstance()).isVisible()) {
                floatingAppPanel.setVisible(false);
            }
            this.toFront();
            if (null != this.getParentInternalFrame()) {
                this.getParentInternalFrame().setSelected(bl);
            }
        }
    }

    @Override
    public boolean isSelected() {
        InternalFrame internalFrame = this.getParentInternalFrame();
        boolean bl = true;
        if (null != internalFrame) {
            bl = internalFrame.isSelected();
        }
        return frontDialog == this && bl;
    }

    @Override
    public void setLocation(int n, int n2) {
        super.setLocation(n, n2);
        this.isSetLocationCalled = true;
    }

    public void locateToCentre(Component component) {
        if (null == component) {
            this.locateToCentre();
            return;
        }
        Point point = component.getLocation();
        Dimension dimension = component.getSize();
        Dimension dimension2 = this.getSize();
        Point point2 = new Point((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        point2.x += point.x;
        point2.y += point.y;
        this.setLocation(point2.x > 0 ? point2.x : 0, point2.y > 0 ? point2.y : 0);
    }

    private void locateToCentre() {
        if (null != this.desktopPane) {
            this.locateToCentre(this.desktopPane);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVisible(boolean bl) {
        InternalDialog internalDialog = this;
        synchronized (internalDialog) {
            if (bl == this.isVisible()) {
                logger.trace("Internal dialog: " + this.getTitle() + " visibility= " + bl + " is same so no need to set");
                return;
            }
            if (bl) {
                if (null == this.desktopPane) {
                    logger.trace("Desktop pane is null, cannot show Internal Dailog");
                    return;
                }
                if (null != this.modalParent && null != this.modalParent.getDesktopPane() && this.modalParent.getDesktopPane() != this.desktopPane) {
                    logger.trace("Cannot show dialog since parent is in other desktop pane");
                    return;
                }
                if (null != this.modalParent && null == this.modalParent.getModalChild()) {
                    this.setModalParent(this.modalParent);
                }
                if (!this.isSetLocationCalled) {
                    this.locateToCentre();
                }
                this.setSelected(true);
                if (-1 == this.desktopPane.getIndexOf(this)) {
                    this.desktopPane.add(this);
                }
                if (null != this.modalParent) {
                    this.modalParent.addPropertyChangeListener(new InternalFrameSelectedProperty(this.modalParent));
                }
                if (null != this.getModalParent()) {
                    if (this == this.getModalParent().getModalChild()) {
                        if (this.modal) {
                            this.getModalParent().getGlassPane().setVisible(true);
                        }
                        this.setLayer(this.getModalParent().getLayer());
                    } else {
                        this.setLayer(JLayeredPane.MODAL_LAYER);
                    }
                } else {
                    this.setLayer(JLayeredPane.MODAL_LAYER);
                }
                this.toFront();
                if (this.isClosed()) {
                    this.updateUI();
                }
                this.isClosed = false;
            }
            super.setVisible(bl);
            if (ScreenToolKit.getFullScreenFlg() && this.desktopPane == FrameworkUtilities.getWindowManager().getDesktopPane()) {
                if (bl) {
                    ScreenToolKit.updateFullScreen(FrameworkUtilities.getMainFrame(), this);
                } else {
                    InternalFrame internalFrame = this.getModalParent();
                    if (null != internalFrame && internalFrame.isSelected()) {
                        ScreenToolKit.updateFullScreen(FrameworkUtilities.getMainFrame(), internalFrame);
                    } else {
                        JInternalFrame jInternalFrame = FrameworkUtilities.getWindowManager().getDesktopPane().getAllFrames()[0];
                        if (null != jInternalFrame && jInternalFrame.isShowing()) {
                            ScreenToolKit.updateFullScreen(FrameworkUtilities.getMainFrame(), jInternalFrame);
                        }
                    }
                }
            }
        }
        if (bl && this.modal) {
            MenuSelectionManager.defaultManager().clearSelectedPath();
            this.focusOwner = FocusManager.getCurrentManager().getFocusOwner();
            this.startModal();
        } else {
            if (null != this.getModalParent()) {
                this.getModalParent().getGlassPane().setVisible(false);
            }
            this.stopModal();
        }
    }

    public InternalFrame getParentInternalFrame() {
        if (null == this.modalParent) {
            return this.modalParent;
        }
        if (!(this.modalParent instanceof InternalDialog)) {
            return this.modalParent;
        }
        return ((InternalDialog)this.modalParent).getParentInternalFrame();
    }

    private Object getMouseEventSource(MouseEvent mouseEvent) {
        Class<Container> clazz = Container.class;
        Object object = mouseEvent.getSource();
        try {
            Method method = clazz.getDeclaredMethod("getMouseEventTarget", Integer.TYPE, Integer.TYPE, Boolean.TYPE);
            method.setAccessible(true);
            return method.invoke(object, mouseEvent.getX(), mouseEvent.getY(), new Boolean(true));
        }
        catch (Exception exception) {
            logger.error("Exception while reflection call in InternalDialog: " + this.getTitle() + " dispatch " + "event :" + exception);
            return null;
        }
    }

    private boolean acceptEvent(AWTEvent aWTEvent) {
        try {
            Object object;
            if (null != sequencedEventClass && null != getFirstMethod && sequencedEventClass.isInstance(aWTEvent) && (object = getFirstMethod.invoke((Object)aWTEvent, (Object[])null)) != aWTEvent) {
                return false;
            }
        }
        catch (Exception exception) {
            logger.error("SECheck: Could not perform SequencedEvent check.", exception);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startModal() {
        block23: {
            try {
                if (SwingUtilities.isEventDispatchThread()) {
                    EventQueue eventQueue = this.getToolkit().getSystemEventQueue();
                    AWTEvent aWTEvent = null;
                    Object object = null;
                    ArrayList<AWTEvent> arrayList = new ArrayList<AWTEvent>(10);
                    while ((this.isVisible() || null != this.modalParent && this.modalParent.getChildAfterIconify() == this) && !Thread.currentThread().isInterrupted()) {
                        try {
                            aWTEvent = eventQueue.getNextEvent();
                            object = aWTEvent.getSource();
                            Object object3 = null;
                            if (!this.acceptEvent(aWTEvent)) {
                                arrayList.add(aWTEvent);
                                continue;
                            }
                            if (aWTEvent instanceof MouseEvent && this.modalParent != null) {
                                MouseEvent exception = (MouseEvent)aWTEvent;
                                object3 = this.getMouseEventSource(exception);
                            } else if (aWTEvent instanceof KeyEvent && this.modalParent != null) {
                                object3 = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                            }
                            if (this.focusOwner == object3 && null != this.modalParent && this.modalParent.isAncestorOf((Component)object3)) continue;
                            if (aWTEvent instanceof ActiveEvent) {
                                ((ActiveEvent)((Object)aWTEvent)).dispatch();
                                continue;
                            }
                            if (object instanceof Component) {
                                ((Component)object).dispatchEvent(aWTEvent);
                                continue;
                            }
                            if (object instanceof MenuComponent) {
                                ((MenuComponent)object).dispatchEvent(aWTEvent);
                                continue;
                            }
                            if (object instanceof TrayIcon) {
                                try {
                                    Method method = TrayIcon.class.getDeclaredMethod("dispatchEvent", AWTEvent.class);
                                    method.setAccessible(true);
                                    method.invoke(object, aWTEvent);
                                }
                                catch (Exception exception) {
                                    logger.trace(exception.getMessage(), exception);
                                }
                                continue;
                            }
                            logger.trace("Unable to dispatch: " + aWTEvent);
                        }
                        catch (Throwable throwable) {
                            logger.error("Exception in side EDT :", throwable);
                        }
                    }
                    if (!arrayList.isEmpty()) {
                        for (AWTEvent aWTEvent2 : arrayList) {
                            eventQueue.postEvent(aWTEvent2);
                        }
                    }
                    if (Thread.currentThread().isInterrupted()) {
                        logger.error("InternalDialog stopped dispatching since EDT is interrupted");
                    }
                    break block23;
                }
                InternalDialog internalDialog = this;
                synchronized (internalDialog) {
                    while (this.isVisible()) {
                        this.wait();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                logger.trace("Start modal interrupted" + interruptedException);
            }
        }
    }

    private synchronized void stopModal() {
        this.notifyAll();
    }

    static {
        try {
            sequencedEventClass = ClassLoader.getSystemClassLoader().loadClass("java.awt.SequencedEvent");
            getFirstMethod = sequencedEventClass.getDeclaredMethod("getFirst", new Class[0]);
            getFirstMethod.setAccessible(true);
            logger.trace("SECheck: Object initialized.");
        }
        catch (Exception exception) {
            logger.error("SECheck: Unable to initialize objects for checking SequenceEvent. The GUI may get blocked in certain scenarios. Exception ", exception);
        }
    }

    class InternalFrameSelectedProperty
    implements PropertyChangeListener {
        private InternalFrame parentFrame;

        public InternalFrameSelectedProperty(InternalFrame internalFrame) {
            this.parentFrame = internalFrame;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("selected".equals(propertyChangeEvent.getPropertyName()) && propertyChangeEvent.getNewValue().equals(true) && null != this.parentFrame.getModalChild()) {
                InternalFrame internalFrame = this.parentFrame.getModalChild();
                internalFrame.toFront();
            }
        }
    }
}

